local E, L, V, P, G = unpack(ElvUI)
local DT = E:GetModule('DataTexts')

local _G = _G
local strjoin = strjoin

local NOT_APPLICABLE = NOT_APPLICABLE

local displayString = ''
local inRestrictedArea = false
local mapInfo = E.MapInfo

local function Update(self, elapsed)
	if inRestrictedArea or not mapInfo.coordsWatching then return end

	self.timeSinceUpdate = (self.timeSinceUpdate or 0) + elapsed

	if self.timeSinceUpdate > 0.1 then
		self.text:SetFormattedText(displayString, mapInfo.xText or 0, mapInfo.yText or 0)
		self.timeSinceUpdate = 0
	end
end

local function OnEvent(self)
	if mapInfo.x and mapInfo.y then
		inRestrictedArea = false
		self.text:SetFormattedText(displayString, mapInfo.xText or 0, mapInfo.yText or 0)
	else
		inRestrictedArea = true
		self.text:SetText(NOT_APPLICABLE)
	end
end

local function Click()
	if not E:AlertCombat() then
		_G.ToggleFrame(_G.WorldMapFrame)
	end
end

local function ApplySettings(_, hex)
	displayString = strjoin('', hex, '%.2f|r', ' | ', hex, '%.2f|r')
end

DT:RegisterDatatext('Coords', nil, { 'LOADING_SCREEN_DISABLED', 'ZONE_CHANGED', 'ZONE_CHANGED_INDOORS', 'ZONE_CHANGED_NEW_AREA' }, OnEvent, Update, Click, nil, nil, L["Coords"], mapInfo, ApplySettings)
