﻿local hideDurability	= false
local mapScale			= 1
local mapStyle			= "tec"
local pingAnnounce	= UIErrorsFrame
local questHeight		= 1
local questScale		= 0.8
local showDate			= true

--[[-----------------------------------------------------------------------------

Setting descriptions:

hideDurability
	If set to true the durability frame be completely hidden and it's mover frame
	will not be created.

mapScale
	Changes the overall size of the minimap.  A value of 1 is normal size, values
	less than 1 shrink the size (ex: 0.5 halves the size), and values greater
	than 1 increase the size (ex: 2 doubles the size).

mapStyle
	Available styles are: "arrow", "gloss", "gold", "tec"
	Go to http://www.wowinterface.com/downloads/info17267-wMmap.html to see what
	the various styles look like.  Any value other than those listed keeps the
	default minimap style.

pingAnnounce
	Set where to display who pinged the minimap:
		ChatFrame1		- Main chat frame
		UIErrorsFrame	- Error notification frame
		false				- Disable ping announcements

questHeight
	Changes the height of the quest watch frame.  A value of 1 is the base height,
	values less than 1 decrease the height (ex: 0.5 halves the height), and
	values greater than 1 increase the height (ex: 2 doubles the height).

questScale
	Changes the overall size of the quest watch frame.  A value of 1 is normal
	size, values less than 1 shrink the size (ex: 0.5 halves the size), and
	values greater than 1 increase the size (ex: 2 doubles the size).

showDate
	Show the date under the time (if enabled):
		true	- Enable the date display
		false	- Disable the date display

-------------------------------------------------------------------------------]]

local addonName = ...

local DoNothing = function() end

local function GetPercent(value)
	value = tonumber(value) or 1
	return value <= 0.1 and 0.1 or value >= 2 and 2 or value
end

local function HideFrame(frame)
  frame.Show = DoNothing
  frame:Hide()
end

HideFrame(GameTimeFrame)
HideFrame(MiniMapVoiceChatFrame)
HideFrame(MinimapBackdrop)
HideFrame(MinimapCluster)

Minimap:SetParent(UIParent)
Minimap:SetFrameStrata('BACKGROUND')
Minimap:SetScale(GetPercent(mapScale))
MinimapBorder:SetParent(Minimap)

WatchFrame:ClearAllPoints()
WatchFrame:SetPoint('TOPRIGHT', Minimap, 'BOTTOMRIGHT', 0, -16)
WatchFrame:SetHeight((WatchFrame:GetTop() - CONTAINER_OFFSET_Y) * GetPercent(questHeight))
WatchFrame:SetScale(GetPercent(questScale))
WatchFrame:SetClampedToScreen(false)

VehicleSeatIndicator:ClearAllPoints()
VehicleSeatIndicator:SetPoint('TOPRIGHT', Minimap, 'BOTTOMRIGHT', -35, -26)

--[[-----------------------------------------------------------------------------
Map style
-------------------------------------------------------------------------------]]
local shape = ({
	arrow	= 'ROUND',
	gloss	= 'SQUARE',
	gold	= 'ROUND',
	tec	= 'SQUARE'
})[mapStyle]

MinimapBorder:ClearAllPoints()

if shape then
	MinimapBorder:SetTexture([[Interface\AddOns\wMmap\]] .. mapStyle)
	MinimapBorder:SetTexCoord(0, 1, 0, 1)
	if shape == 'SQUARE' then
		MinimapBorder:SetPoint('TOPLEFT', -3, 3)
		MinimapBorder:SetPoint('BOTTOMRIGHT', 3, -3)
		Minimap:SetMaskTexture([[Interface\BUTTONS\WHITE8X8]])
	else
		MinimapBorder:SetPoint('TOPLEFT', -12, 12)
		MinimapBorder:SetPoint('BOTTOMRIGHT', 12, -12)
		Minimap:SetMaskTexture([[Textures\MinimapMask]])
	end
else
	MinimapBorder:SetTexCoord(94/256, 244/256, 32/256, 182/256)
	MinimapBorder:SetPoint('TOPLEFT', -4, 4)
	MinimapBorder:SetPoint('BOTTOMRIGHT', 5, -7)
	Minimap:SetMaskTexture([[Textures\MinimapMask]])
	MinimapCompassTexture:SetParent(Minimap)
	MinimapNorthTag:SetParent(Minimap)
	shape = 'ROUND'
end

function GetMinimapShape()
	return shape
end

--[[-----------------------------------------------------------------------------
Tweaks
-------------------------------------------------------------------------------]]
-- Zone text
MinimapZoneTextButton:SetParent(Minimap)
MinimapZoneTextButton:SetPoint('TOP', 0, 8)
MinimapZoneTextButton:SetFrameStrata('HIGH')
MinimapZoneText:SetFont([[FONTS\FRIZQT__.ttf]], 10, 'OUTLINE')

-- Time
LoadAddOn('Blizzard_TimeManager')
local clockFrame, clockTime = TimeManagerClockButton:GetRegions()
clockFrame:Hide()
clockTime:Show()
clockTime:SetFont(MinimapZoneText:GetFont())
TimeManagerClockButton:ClearAllPoints()
TimeManagerClockButton:SetPoint('CENTER', Minimap, 'BOTTOM')

GameTimeFrame:HookScript('OnEvent', function()
	if CalendarGetNumPendingInvites() > 0 then
		clockTime:SetTextColor(0, 1, 0)
	else
		clockTime:SetTextColor(MinimapZoneText:GetTextColor())
	end
end)

-- Date
if showDate then
	local text = TimeManagerClockButton:CreateFontString(nil, 'BACKGROUND')
	text:SetFont(MinimapZoneText:GetFont())
	text:SetTextColor(MinimapZoneText:GetTextColor())
	text:SetPoint('TOP', clockTime, 'BOTTOM')
	text:SetText(date("%a %b %d"))

	local group = WorldFrame:CreateAnimationGroup()
	local timer = group:CreateAnimation('Animation')
	timer:SetScript('OnFinished', function()
		text:SetText(date("%a %b %d"))
	end)
	timer:SetDuration(30)
	group:SetLooping('REPEAT')
	group:Play()
end

-- Battleground
MiniMapBattlefieldFrame:ClearAllPoints()
MiniMapBattlefieldFrame:SetPoint('TOP', Minimap, 0, -3)
MiniMapBattlefieldFrame:SetScale(0.9)
MiniMapBattlefieldBorder:Hide()

-- Instance difficulty
MiniMapInstanceDifficulty:SetParent(Minimap)
MiniMapInstanceDifficulty:ClearAllPoints()
MiniMapInstanceDifficulty:SetPoint('TOPRIGHT', Minimap, 0, -4)
MiniMapInstanceDifficulty:SetScale(0.9)
MiniMapInstanceDifficulty:SetFrameStrata('HIGH')

-- LFG
LFDSearchStatus:ClearAllPoints()
LFDSearchStatus:SetPoint('TOPRIGHT', MiniMapLFGFrame, 'TOPLEFT')
LFDSearchStatus:SetScale(0.8)
LFDSearchStatus:SetFrameStrata("HIGH")

MiniMapLFGFrame:SetParent(Minimap)
MiniMapLFGFrame:ClearAllPoints()
MiniMapLFGFrame:SetPoint('BOTTOMRIGHT', Minimap, 3, -3)
MiniMapLFGFrame:SetScale(0.9)
MiniMapLFGFrameBorder:Hide()

-- Mail
MiniMapMailFrame:ClearAllPoints()
MiniMapMailFrame:SetPoint('BOTTOM', Minimap, 0, 18)
MiniMapMailFrame:SetHeight(10)
MiniMapMailBorder:Hide()
MiniMapMailIcon:SetTexture([[Interface\AddOns\wMmap\mail]])

-- Zoom
Minimap:SetScript('OnMouseWheel', function(self, direction)
	local zoom, maxZoom = self:GetZoom() + direction, self:GetZoomLevels()
	self:SetZoom(zoom >= maxZoom and maxZoom or zoom <= 0 and 0 or zoom)
end)
Minimap:EnableMouseWheel(true)
MinimapPing:UnregisterEvent('MINIMAP_UPDATE_ZOOM')

-- Ping
if type(pingAnnounce) == 'table' and type(pingAnnounce.AddMessage) == 'function' then
	MinimapPing:HookScript('OnEvent', function(self, event, unit)
		if event == 'MINIMAP_PING' and unit ~= 'player' then
			local _, class = UnitClass(unit)
			local color = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]
			pingAnnounce:AddMessage(("Pinged by: |cff%02x%02x%02x%s"):format(color.r * 255, color.g * 255, color.b * 255, UnitName(unit)))
		end
	end)
end

--[[-----------------------------------------------------------------------------
Movers
-------------------------------------------------------------------------------]]
local silhouette, movers = UIParent:CreateTexture(nil, 'BACKGROUND')
silhouette:SetTexture([[Interface\BUTTONS\WHITE8X8]])
silhouette:SetAlpha(0.45)
silhouette:Hide()

local function GetRelativePoint(frame)
	local L1, B1, W1, H1 = UIParent:GetRect()
	local L2, B2, W2, H2 = frame:GetRect()
	local x, y, h, w, anchor = L2 - L1, B2 - B1, H1 - H2, W1 - W2
	if x < w * 0.5 then
		anchor = 'LEFT'
	else
		anchor, x = 'RIGHT', x - w
	end
	if y < h * 0.5 then
		anchor = 'BOTTOM' .. anchor
	else
		anchor, y = 'TOP' .. anchor, y - h
	end
	return anchor, x, y
end

local function OnMouseDown(self, button)
	if button ~= 'LeftButton' then return end
	self.moving = true
	if not self[4]:IsVisible() or self[5] then
		silhouette:SetParent(self)
		silhouette:ClearAllPoints()
		silhouette:SetAllPoints(self[4])
		silhouette:Show()
	end
	self:StartMoving()
end

local function OnMouseUp(self, button)
	if button ~= 'LeftButton' or not self.moving then return end
	self.moving = nil
	silhouette:Hide()
	self:StopMovingOrSizing()
end

local function CreateMoverFrame(name, moveFrame, silhouette)
	local frame = CreateFrame('Frame', addonName .. name .. "Mover", UIParent)
	frame:EnableMouse(true)
	frame:SetMovable(true)
	frame:SetClampedToScreen(true)
	frame:SetScript('OnMouseDown', OnMouseDown)
	frame:SetScript('OnMouseUp', OnMouseUp)
	frame:Hide()

	local texture = frame:CreateTexture(nil, 'BORDER')
	texture:SetTexture([[Interface\Buttons\UI-Panel-Button-Up]])
	texture:SetAllPoints()
	texture:SetTexCoord(0, 0.625, 0, 0.6875)

	local string = frame:CreateFontString(nil, 'ARTWORK', 'GameFontNormal')
	string:SetPoint('CENTER', 1, 0)
	string:SetText(name)
	frame:SetHeight(string:GetStringHeight() + 8)
	frame:SetWidth(string:GetStringWidth() + 16)

	frame:SetPoint('TOP', moveFrame)
	local anchor, x, y = GetRelativePoint(frame)
	frame:ClearAllPoints()
	frame:SetPoint(anchor, x, y)

	moveFrame:ClearAllPoints()
	moveFrame:SetPoint('TOP', frame)
	moveFrame.ClearAllPoints = DoNothing
	moveFrame.SetAllPoints = DoNothing
	moveFrame.SetPoint = DoNothing

	frame[1], frame[2], frame[3], frame[4], frame[5] = anchor, x, y, silhouette or moveFrame, silhouette == false or nil
	return frame
end

movers = {
	CreateMoverFrame("Minimap", Minimap, MinimapBorder),
	CreateMoverFrame("Quest", WatchFrame, false),
	CreateMoverFrame("Ticket", TicketStatusFrame),
	CreateMoverFrame("Vehicle", VehicleSeatIndicator)
}

--[[-----------------------------------------------------------------------------
Durability
-------------------------------------------------------------------------------]]
if hideDurability then
	HideFrame(DurabilityFrame)
else
	DurabilityFrame:ClearAllPoints()
	DurabilityFrame:SetPoint('TOPRIGHT', Minimap, 'BOTTOMRIGHT', 0, -26)
	movers[#movers + 1] = CreateMoverFrame("Durability", DurabilityFrame)
end

--[[-----------------------------------------------------------------------------
Slash command
-------------------------------------------------------------------------------]]
_G['SLASH_' .. addonName .. 1] = "/wm"
_G['SLASH_' .. addonName .. 2] = "/wM"
_G['SLASH_' .. addonName .. 3] = "/Wm"
_G['SLASH_' .. addonName .. 4] = "/WM"
SlashCmdList[addonName] = function(msg)
	msg = msg:lower()
	if msg == "lock" then
		for index = 1, #movers do
			movers[index]:Hide()
		end
	elseif msg == "mouse" then
		print("|cff3399ffw|rMmap mouse button assignments:")
		print("|cff1eff1eleft|r - Ping the minimap")
		print("|cff1eff1emiddle|r - Toggle the calendar")
		print("|cff1eff1eright|r - Toggle the tracking menu")
		print("|cff1eff1ewheel|r - Zoom the minimap in/out")
	elseif msg == "reset" then
		local frame
		for index = 1, #movers do
			frame = movers[index]
			frame:ClearAllPoints()
			frame:SetPoint(frame[1], frame[2], frame[3])
		end
	elseif msg == "rl" then
		ReloadUI()
	elseif msg == "unlock" then
		for index = 1, #movers do
			movers[index]:Show()
		end
	else
		print("|cff3399ffw|rMmap commands:")
		print("|cff1eff1elock|r - Hide frame movers to prevent dragging")
		print("|cff1eff1emouse|r - Display mouse button assignments")
		print("|cff1eff1ereset|r - Reset frames to their default positions")
		print("|cff1eff1erl|r - Reload the UI")
		print("|cff1eff1eunlock|r - Show frame movers to enable dragging")
	end
end

--[[-----------------------------------------------------------------------------
Finish
-------------------------------------------------------------------------------]]
Minimap:SetScript('OnMouseUp', function(self, button)
	if button == 'RightButton' then
		ToggleDropDownMenu(1, nil, MiniMapTrackingDropDown, 'cursor')
	elseif button == 'MiddleButton' then
		ToggleCalendar()
	else
		Minimap_OnClick(self)
	end
end)
DropDownList1:SetClampedToScreen(true)

print("|cff3399ffw|rMmap has been loaded, use /wm for help.")
