﻿local ctfade	                = true
local cfade					= false
local uinoticea					        = true
local uinoticeb                 	= true
local csounds                   			= true
local altclickinvite            	= true
local eboxbottom                		= false
local arrows                    	= true
local Emote                     			= "Hide"
local Friends                   	= "Hide"
local outline                   			= false
local hidetimestamp            	= true
local WC_TIMESTAMP_FORMAT = "%H:%M"
local hidechannelnames                   	= true

--[[-----------------------------------------------------------------------------

Setting descriptions:

ctfade/cfade
	ctfade = Chat Tab, Set to false to have the Chat Tab not Fade out.
	cfade  = Chat Box, Set to true to have the Chat-box not Fade out.

uinoticea/uinoticeb
	Uinoticea = Error notification frame, Set to false to turn off.
        (WTS,WTB,LF,LFG,LFM.)
	Uinoticeb = Error notification frame, Set to false to turn off.
        (You have been outbid,group has been disbanded,instance will reset)

csounds
	Chat Sounds, Set to false to turn off.

altclickinvite
	Alt click invite to party, Set to false to turn off.
        (hold alt and left click to invite from the chat)

eboxbottom
	Set to true to have the editbox show at the bottom.

arrows
	Set to false to see the Arrows icon.

Emote
	Set to Show to see the Emote icon.

Friends
	Set to Show to see the Friends icon.

outline
	Set to true to have the Chat text bold.

hidetimestamp
        Set to false to hide the timestamp.

WC_TIMESTAMP_FORMAT
Copy code to what format you would like. 
and paste it in WC_TIMESTAMP_FORMAT = "%H:%M:%S"

%I:%M -- HHMM
%H:%M -- HHMM_24HR
%I:%M%p -- HHMM_AMPM
%I:%M:%S -- HHMMSS
%H:%M:%S -- HHMMSS_24HR
%I:%M:%S %p -- HHMMSS_AMPM

hidechannelnames
        Set to false to hide the channelnames.

-------------------------------------------------------------------------------]]

--Code Starts--

--Justify --"LEFT","RIGHT", or "CENTER" ChatFrames 1 - 10 
ChatFrame2:SetJustifyH("RIGHT")
--(combatlog) 2,RIGHT 

--Chat Tab Fade.
if ctfade then
	CHAT_FRAME_TAB_NORMAL_NOMOUSE_ALPHA = 0
	CHAT_FRAME_TAB_SELECTED_NOMOUSE_ALPHA = 0
	CHAT_FRAME_BUTTON_FRAME_MIN_ALPHA = 0
	for i=1, 10 do
		local tab = _G[format("%s%d%s", "ChatFrame", i, "Tab")]
		tab:SetAlpha(0)
		tab.noMouseAlpha = 0
	end
end

--Chat Font Fade.
if cfade then
for i = 1, 10 do
    local cf = _G["ChatFrame"..i]
    cf:SetFading(false)
end
end

--Sticky Channels, 0 off, 1 on
ChatTypeInfo.EMOTE.sticky = 1
ChatTypeInfo.YELL.sticky = 1
ChatTypeInfo.RAID_WARNING.sticky = 1

--If you want to unsticky whispers or BNet whispers, remove the "--" on the following lines
--ChatTypeInfo.WHISPER.sticky = 0
--ChatTypeInfo.BN_WHISPER.sticky = 0

--Scrolldown
function FloatingChatFrame_OnMouseScroll(self, delta)
	if delta < 0 then
		if IsShiftKeyDown() then self:ScrollToBottom()
		else
			for i = 1, 3 do self:ScrollDown() end end
	elseif delta > 0 then
		if IsShiftKeyDown() then self:ScrollToTop()
		else
			for i = 1, 3 do self:ScrollUp()
			end
		end
	end
end

--Channels
if hidechannelnames then
local gsub = _G.string.gsub
local newAddMsg = {}
local chn, rplc

CHAT_BATTLEGROUND_GET = "[BG] %s: "
CHAT_BATTLEGROUND_LEADER_GET = "[BGL]: %s "
CHAT_SAY_GET = "[S] %s: "
CHAT_YELL_GET = "[Y] %s: "
CHAT_WHISPER_GET = "[F] %s: "
CHAT_WHISPER_INFORM_GET = "[T] %s: "
CHAT_GUILD_GET = "[G] %s: "
CHAT_OFFICER_GET = "[O] %s: "
CHAT_PARTY_GET = "[P] %s: "
CHAT_PARTY_LEADER_GET = "[PL] %s: "
CHAT_PARTY_GUIDE_GET = "[DG] %s: "
CHAT_RAID_GET = "[R] %s: "
CHAT_RAID_LEADER_GET = "[RL] %s: "
CHAT_RAID_WARNING_GET = "[RW] %s: "

CHAT_FLAG_AFK = "[AFK] "
CHAT_FLAG_DND = "[DND] "
CHAT_FLAG_GM = "[GM] "

	rplc = {
		"[GEN]", --General
		"[TR]", --Trade
		"[WD]", --WorldDefense
		"[LD]", --LocalDefense
		"[LFG]", --LookingForGroup
		"[GR]", --GuildRecruitment
	}

	local L = GetLocale()
	if L == "ruRU" then --Russian
		chn = {
			"%[%d+%. Общий.-%]",
			"%[%d+%. Торговля.-%]",
			"%[%d+%. Оборона: глобальный%]", --Defense: Global
			"%[%d+%. Оборона.-%]", --Defense: Zone
			"%[%d+%. Поиск спутников%]",
			"%[%d+%. Гильдии.-%]",
		}
	elseif L == "deDE" then --German
		chn = {
			"%[%d+%. Allgemein.-%]",
			"%[%d+%. Handel.-%]",
			"%[%d+%. Weltverteidigung%]",
			"%[%d+%. LokaleVerteidigung.-%]",
			"%[%d+%. SucheNachGruppe%]",
			"%[%d+%. Gildenrekrutierung.-%]",
		}
	else --English & any other language not translated above.
		chn = {
			"%[%d+%. General.-%]",
			"%[%d+%. Trade.-%]",
			"%[%d+%. WorldDefense%]",
			"%[%d+%. LocalDefense.-%]",
			"%[%d+%. LookingForGroup%]",
			"%[%d+%. GuildRecruitment.-%]",
		}
	end

local function AddMessage(frame, text, ...)
	for i = 1, 6 do
		text = gsub(text, chn[i], rplc[i])
	end
	text = gsub(text, "%[(%d0?)%. .-%]", "[%1]") --custom channels
	return newAddMsg[frame:GetName()](frame, text, ...)
end

	for i = 1, 5 do
		if i ~= 2 then -- skip combatlog
			local ch = _G[format("%s%d", "ChatFrame", i)]
			newAddMsg[format("%s%d", "ChatFrame", i)] = ch.AddMessage
			ch.AddMessage = AddMessage
		end
    end
end

---timestamp
if hidetimestamp then
wcTimestamps = {}

WC_TIMESTAMP_COLOR = "777777"
WC_TIMESTAMP_OUTPUT_FORMAT = "%s|r %s"
WC_TIMESTAMP_ACTIVE = {
	true, --[1]
	true, --[2]
	true, --[3]
	true, --[4]
	true, --[5]
	true, --[6]
	true  --[7]
}

local _G = getfenv(0)
local format1 = nil
local orig = nil

local function addMessage(frame, text, ...)
	if type(text) == "string" then
		text = format1:format(date(WC_TIMESTAMP_FORMAT), text)
	end
	return orig(frame, text, ...)
end

function wcTimestamps:Enable()
	self:UpdateFormat()

	orig = ChatFrame1.AddMessage
	ChatFrame1.AddMessage = addMessage
end

function wcTimestamps:Disable()
	ChatFrame1.AddMessage = orig
end

function wcTimestamps:Update()
	self:Disable()
	self:Enable()
end

function wcTimestamps:UpdateFormat()
	format1 = "|cff"..WC_TIMESTAMP_COLOR..WC_TIMESTAMP_OUTPUT_FORMAT
end

wcTimestamps:Enable()
end

--Buttons
ChatFrameMenuButton[Emote](ChatFrameMenuButton)
ChatFrameMenuButton.Show = function() end
FriendsMicroButton[Friends](FriendsMicroButton)
FriendsMicroButton.Show = function() end
--Real ID Frame
BNToastFrame:SetClampedToScreen(true)

if arrows then
	local hideFunc = function(frame) frame:Hide() end
	for i = 1, 10 do
		local ab = _G[format("%s%d%s", "ChatFrame", i, "ButtonFrame")]
		ab:SetScript("OnShow", hideFunc)
		ab:Hide()
	end
end

--misc functions (Frame size/move,Arrow keys,editbox to the top) 
	for i = 1, 10 do
		local eb =  _G[format("%s%d%s", "ChatFrame", i, "EditBox")]
		local cfs = _G[format("%s%d", "ChatFrame", i)]
		cfs:SetMinResize(0,0)
		cfs:SetMaxResize(0,0)
                cfs:SetClampRectInsets(0,0,0,0)
		eb:SetAltArrowKeyMode(false)
if eboxbottom then
		eb:ClearAllPoints()
		eb:SetPoint("TOPLEFT",  cfs, "BOTTOMLEFT",  -5, 0)
		eb:SetPoint("TOPRIGHT", cfs, "BOTTOMRIGHT", 5, 0)
else
		eb:ClearAllPoints()
		eb:SetPoint("BOTTOMLEFT",  cfs, "TOPLEFT",  -5, 0)
		eb:SetPoint("BOTTOMRIGHT", cfs, "TOPRIGHT", 5, 0)
	end
end

if outline then 
for i = 1, 7 do
    local chat = _G["ChatFrame"..i]
    local font, size = chat:GetFont()
    chat:SetFont(font, size, "OUTLINE")
    chat:SetShadowOffset(0, 0)
    chat:SetShadowColor(0, 0, 0, 0)
end
end

--noticea
if uinoticea then
local cnot = CreateFrame("Frame")
cnot:RegisterEvent("CHAT_MSG_CHANNEL")
cnot:SetScript("OnEvent", function(self, event, arg1, arg2)
		if string.find(arg1, "WTS%s.*") then
			UIErrorsFrame:AddMessage("|cFFFF0000WTS: |cFFCCCCCC"..arg2..": |cFFFFFF00"..arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
		end
		if string.find(arg1, "WTB%s.*") then
			UIErrorsFrame:AddMessage("|cFF0000FFWTB: |cFFCCCCCC"..arg2..": |cFFFFFF00"..arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
		end
		if string.find(arg1, "LF%s.*") then
			UIErrorsFrame:AddMessage("|cFF00FF00LFG: |cFFCCCCCC"..arg2..": |cFFFFFF00"..arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
		end
		if string.find(arg1, "LFG%s.*") then
			UIErrorsFrame:AddMessage("|cFF00FF00LFG: |cFFCCCCCC"..arg2..": |cFFFFFF00"..arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
		end
		if string.find(arg1, "LFM%s.*") then
			UIErrorsFrame:AddMessage("|cFF00FF00LFM: |cFFCCCCCC"..arg2..": |cFFFFFF00"..arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
     end
end)
end

--noticeb
if uinoticeb then
local c2not = CreateFrame("Frame")
c2not:RegisterEvent("CHAT_MSG_CHANNEL")
c2not:SetScript("OnEvent", function(self, event, arg1, arg2)
		if string.find(arg1, "A buyer has been found for your auction of .+%.") then
			UIErrorsFrame:AddMessage(arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
			PlaySound("MapPing")
		end
		if string.find(arg1, "You have been outbid on .+ sold%.") then
			UIErrorsFrame:AddMessage(arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
			PlaySound("MapPing")
		end
		if string.find(arg1, "Your group has been disbanded.") then
			UIErrorsFrame:AddMessage(arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
			PlaySound("MapPing")
		end
		if string.find(arg1, "This instance will reset in .+%.") then
			UIErrorsFrame:AddMessage(arg1, 1.0, 1.0, 0.0, 1.0, UIERRORS_HOLD_TIME)
			PlaySound("MapPing")
		end
end)
end

--URL Copy
local color = "C0C0C0"
local pattern = "[wWhH][wWtT][wWtT][\46pP]%S+[^%p%s]"

function string.color(text, color)
	return "|cff"..color..text.."|r"
end

function string.link(text, type, value, color)
	return "|H"..type..":"..tostring(value).."|h"..tostring(text):color(color or "ffffff").."|h"
end

StaticPopupDialogs["LINKME"] = {
	text = "URL COPY",
	button2 = CANCEL,
	hasEditBox = true,
    hasWideEditBox = true,
	timeout = 0,
	exclusive = 1,
	hideOnEscape = 1,
	EditBoxOnEscapePressed = function(self) self:GetParent():Hide() end,
	whileDead = 1,
	maxLetters = 255,
}

local function f(url)
	return string.link("["..url.."]", "url", url, color)
end

local function hook(self, text, ...)
	self:f(text:gsub(pattern, f), ...)
end

function LinkMeURL()
	for i = 1, NUM_CHAT_WINDOWS do
		if ( i ~= 2 ) then
			local lframe = _G["ChatFrame"..i]
			lframe.f = lframe.AddMessage
			lframe.AddMessage = hook
		end
	end
end
LinkMeURL()

local ur = ChatFrame_OnHyperlinkShow
function ChatFrame_OnHyperlinkShow(self, link, text, button)
	local type, value = link:match("(%a+):(.+)")
	if ( type == "url" ) then
		local dialog = StaticPopup_Show("LINKME")
		local editbox1 = _G[dialog:GetName().."WideEditBox"]  
		editbox1:SetText(value)
		editbox1:SetFocus()
		editbox1:HighlightText()
		local button = _G[dialog:GetName().."Button2"]
            
		button:ClearAllPoints()
           
		button:SetPoint("CENTER", editbox1, "CENTER", 0, -30)
	else
		ur(self, link, text, button)
	end
end

--Chat copy
local frame = CreateFrame('Frame', nil, UIParent)
frame:SetFrameStrata('DIALOG')
frame:SetPoint('LEFT', 3, 10)
frame:SetHeight(400)
frame:SetWidth(500)
frame:Hide()

frame:SetBackdrop({
	bgFile = [[Interface\DialogFrame\UI-DialogBox-Background]],
	edgeFile = [[Interface\DialogFrame\UI-DialogBox-Border]],
	edgeSize = 16, tileSize = 16, tile = true,
	insets = { left = 3, right = 3, top = 5, bottom = 3 }
})
frame:SetBackdropColor(0, 0, 0, 1)

local scrollArea = CreateFrame('ScrollFrame', "wChatScrollFrame", frame, 'UIPanelScrollFrameTemplate')
scrollArea:SetPoint('TOPLEFT', 13, -30)
scrollArea:SetPoint('BOTTOMRIGHT', -30, 13)

local editBox = CreateFrame('EditBox', nil, frame)
editBox:SetMultiLine(true)
editBox:SetMaxLetters(20000)
editBox:EnableMouse(true)
editBox:SetAutoFocus(true)
editBox:SetFontObject(ChatFontNormal)
editBox:SetWidth(450)
editBox:SetHeight(270)
editBox:SetScript('OnEscapePressed', function() frame:Hide() end)

scrollArea:SetScrollChild(editBox)

local close = CreateFrame('Button', nil, frame, 'UIPanelCloseButton')
close:SetPoint('TOPRIGHT', 0, -1)

local CopyChat = function(self, chatTab)
	local chatFrame = _G['ChatFrame' .. chatTab:GetID()]
	local numMessages = chatFrame:GetNumMessages()
	if numMessages >= 1 then
		local GetMessageInfo = chatFrame.GetMessageInfo
		local text = GetMessageInfo(chatFrame, 1)
		for index = 2, numMessages do
			text = text .. "\n" .. GetMessageInfo(chatFrame, index)
		end
		frame:Show()
		editBox:SetText(text)
	end
end

hooksecurefunc('FCF_Tab_OnClick', function(self)
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Copy Chat Contents"
	info.notCheckable = true
	info.func = CopyChat
	info.arg1 = self
	UIDropDownMenu_AddButton(info)
end)

--Chat Sounds
if csounds then
local name, ns = ...
local mediaPath = [=[Interface\AddOns\wChat\media\]=]
local name = UnitName'player'
local evtsounds = {
	["CHAT_MSG_GUILD"] = "Kachink",
	["CHAT_MSG_OFFICER"] = "Link",
	["CHAT_MSG_PARTY"] = "pop1",
	["CHAT_MSG_PARTY_LEADER"] = "pop2",
	["CHAT_MSG_RAID"] = "Text2",
	["CHAT_MSG_WHISPER"] = "Heart",
	["CHAT_MSG_GMWHISPER"] = "gasp",
	["CHAT_MSG_RAID_LEADER"] = "Choo",
	["CHAT_MSG_BATTLEGROUND"] = "switchy",
	["CHAT_MSG_BATTLEGROUND_LEADER"] = "doublehit",
	["CHAT_MSG_CHANNEL"] = true, --dummy
}

local cs = CreateFrame'Frame'
cs:SetScript('OnEvent', function(self, event, ...)
	local msg, author, lang, channel = ...
	if author == name then return end
	if event == "CHAT_MSG_CHANNEL" then
		-- TODO
	else
		local sound = mediaPath..evtsounds[event]..'.wav'
		PlaySoundFile(sound)
	end
end)

for event, sound in pairs(evtsounds) do
	cs:RegisterEvent(event)
   end
end

--Alt click invite.
if altclickinvite then
local origSetItemRef = SetItemRef
SetItemRef = function(link, text, button)
	local linkType = string.sub(link, 1, 6)
	if IsAltKeyDown() and linkType == "player" then
		local aname = string.match(link, "player:([^:]+)")
		InviteUnit(aname)
		return nil
	end
	return origSetItemRef(link,text,button)
   end
end

print("|cff3399FFw|rChat: Loaded|r");