--- **Randomfacts by Draebersneglen** 
-- @release 1.5.5

local MODNAME = "Random Facts"

RNFCT	= LibStub("AceAddon-3.0"):NewAddon(MODNAME, "AceConsole-3.0")

local addon = RNFCT

local random = math.random
local lower = string.lower

if (not LibStub:GetLibrary("AceLocale-3.0", true)) then
	addon:Print(format("%s is missing.  Addon cannot run.","AceLocale-3.0"))
	--[===[@debug@
	addon:Print("You are using a git version of RNFCT. All libraries manually to esnure that it works properly.")
	--@end-debug@]===]
	RNFCT = nil
	return
end

local L	= LibStub("AceLocale-3.0"):GetLocale(MODNAME)

-- Returns configuration options for RNFCT

local function giveRNFCTOptions()

	local command_options = {
	    type = "group",
	    args =
		{
			header1 =
			{
				order = 1,
				type = "header",
				name = "",
			},
			displayinstance = 
			{
				type = "execute",
				name = L["Display Fact (Ins)"],
				desc = L["INSTANCE_LONG"],
				func = function(info) addon:DisplayRNFCT("INSTANCE") end,
				order = 22,
			},
			displayself = 
			{
				type = "execute",
				name = L["Display Fact (Self)"],
				desc = L["SELF_LONG"],
				func = function(info) addon:Print(addon:GetRNFCT()) end,
				order = 5,
			},
			displaysay = 
			{
				type = "execute",
				name = L["Display Fact (Say)"],
				desc = L["SAY_LONG"],
				func = function(info) addon:DisplayRNFCT("SAY") end,
				order = 6,
			},
			displayyell = 
			{
				type = "execute",
				name = L["Display Fact (Yell)"],
				desc = L["YELL_LONG"],
				func = function(info) addon:DisplayRNFCT("YELL") end,
				order = 7,
			},
			displayguild = 
			{
				type = "execute",
				name = L["Display Fact (Guild)"],
				desc = L["GUILD_LONG"],
				func = function(info) addon:DisplayRNFCT("GUILD") end,
				order = 10,
			},
			displayofficer = 
			{
				type = "execute",
				name = L["Display Fact (Officer)"],
				desc = L["OFFICER_LONG"],
				func = function(info) addon:DisplayRNFCT("OFFICER") end,
				order = 11,
			},
			displayparty = 
			{
				type = "execute",
				name = L["Display Fact (Party)"],
				desc = L["PARTY_LONG"],
				func = function(info) addon:DisplayRNFCT("PARTY") end,
				order = 20,
			},
			displayraid = 
			{
				type = "execute",
				name = L["Display Fact (Raid)"],
				desc = L["RAID_LONG"],
				func = function(info) addon:DisplayRNFCT("RAID") end,
				order = 21,
			},
			displayraidwarning = 
			{
				type = "execute",
				name = L["Display Fact (Raid Warning)"],
				desc = L["RAIDWARNING_LONG"],
				func = function(info) addon:DisplayRNFCT("RAIDWARN") end,
				order = 21,
			},
			displaybg = 
			{
				type = "execute",
				name = L["Display Fact (Battleground)"],
				desc = L["BATTLEGROUND_LONG"],
				func = function(info) addon:DisplayRNFCT("BG") end,
				order = 30,
			},
		}
	}

	return command_options

end

-- Loaded when addon is initialized

function addon:OnInitialize()

	local AceConfigReg = LibStub("AceConfigRegistry-3.0")
	local AceConfigDialog = LibStub("AceConfigDialog-3.0")

	-- Create the options with Ace3
	LibStub("AceConfig-3.0"):RegisterOptionsTable(MODNAME,giveRNFCTOptions,MODNAME)

	-- Add the options to blizzard frame (add them backwards so they show up in the proper order
	self.optionsFrame = AceConfigDialog:AddToBlizOptions(MODNAME,MODNAME)

	if LibStub:GetLibrary("LibAboutPanel", true) then
		self.optionsFrame["About"] = LibStub("LibAboutPanel").new(MODNAME, "RNFCT")
	else
		self:Print("Lib AboutPanel not loaded.")
	end

	self:RegisterChatCommand("randomfact", "ChatCommandHandler")
	self:RegisterChatCommand("rnfct", "ChatCommandHandler")

end

-- Gets a random fact from the database and returns it.

function addon:GetRNFCT()
	return addon.RNFCTDB[random(#addon.RNFCTDB)]
end

-- Outputs a random fact to the specified channel.

function addon:DisplayRNFCT(channel,target)

	if (target) then
		SendChatMessage(self:GetRNFCT(), channel, nil, target)
	else
		SendChatMessage(self:GetRNFCT(), channel)
	end

end

-- Slash command handler

function addon:ChatCommandHandler(arg)

	local input = lower(arg)

	if (not input) or (input and input:trim() == "") then
		self:Print(L["COMMAND_OPTIONS"])
	elseif (input == L["self"]) then
		self:Print(self:GetRNFCT())
	elseif (input == L["say"]) or (input == "s") then
		addon:DisplayRNFCT("SAY")
	elseif (input == L["yell"]) or (input == "y") then
		addon:DisplayRNFCT("YELL")
	elseif (input == "1") or (input == "2") or (input == "3") or (input == "4") or (input == "5") or (input == "6") or (input == "7") or (input == "8") or (input == "9") then
		addon:DisplayRNFCT("CHANNEL", input)
	elseif (input == L["guild"]) or (input == "g") then
		addon:DisplayRNFCT("GUILD")
	elseif (input == L["officer"]) or (input == "o") then
		addon:DisplayRNFCT("OFFICER")
	elseif (input == L["party"]) or (input == "p") then
		addon:DisplayRNFCT("PARTY")
	elseif (input == L["ins"]) or (input == "i") then
		addon:DisplayRNFCT("INSTANCE")
	elseif (input == L["raid"]) or (input == "r") then
		addon:DisplayRNFCT("RAID")
	elseif (input == L["raidwarn"]) or (input == "rw") then
		addon:DisplayRNFCT("RAID_WARNING")
	elseif (input == L["battleground"]) or (input == "bg") then
		addon:DisplayRNFCT("BATTLEGROUND")
	else
		local first, second = string.match(input, "([a-z0-9]+)[ ]?(.*)")
		if (first == L["whisper"]) or (first == "w") then
			addon:DisplayRNFCT("WHISPER", second)
		else
			self:Print(L["COMMAND_OPTIONS"])
		end
	end

end
