﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if nUI_Locale == "zhTW" then		-- Traditional Chinese
		
	nUI_L["font1"] = "Fonts\\FZLBJW.TTF";		-- used for most text and numeric displays
	nUI_L["font2"] = "Fonts\\FZLBJW.TTF";		-- used for special (fancy) text displays
	
	nUI_L["Welcome back to %s, %s..."] = "歡迎回來 %s, %s..."; 
	nUI_L["nUI version %s is loaded!"] = "nUI 版本 %s 已載入!"; 
	nUI_L["Type '/nui' for a list of available nUI commands."] = "使用 '/nui' 取得所有 nUI 指令."; 
	
	-- clock strings
	
	nUI_L["am"] = "上午";		
	nUI_L["pm"] = "下午";
	nUI_L["(S) <hour>:<minute><suffix> - <hour>:<minute><suffix> (L)"] = "(伺服器) %d:%02d%s - %d:%02d%s (玩家)";
	nUI_L["(S) <hour>:<minute> - <hour>:<minute> (L)"] = "(伺服器) %02d:%02d - %02d:%02d (玩家)"; 
	
	-- state strings
	
	nUI_L["|cFF00FF00ENABLED|r"]  = "|cFF00FF00啟動|r"; -- translate the word "ENABLED"
	nUI_L["|cFFFF0000DISABLED|r"] = "|cFFFF0000關閉|r"; -- translate the word "DISABLED"
	nUI_L["~INTERRUPTED~"]        = "~施法被斷~";
	nUI_L["~FAILED~"]             = "~施法失敗~";
	nUI_L["~MISSED~"]             = "~未擊中~";
	nUI_L["OFFLINE"]              = "離線";
	nUI_L["DND"]                  = "勿擾"; 
	nUI_L["AFK"]                  = "不在鍵盤前";
	nUI_L["DEAD"]                 = "死亡";
	nUI_L["GHOST"]                = "跑魂中";
	nUI_L["FD"]                   = "假死";
	nUI_L["TAXI"]                 = "搭乘坐騎中"; 
	
	-- time remaining (cooldowns, buffs, etc.)
	
	nUI_L["TimeLeftInHours"]   = "%0.0fh"; 
	nUI_L["TimeLeftInMinutes"] = "%0.0fm"; 
	nUI_L["TimeLeftInSeconds"] = "%0.0fs"; 
	nUI_L["TimeLeftInTenths"]  = "%0.1fs"; 
	
	-- raid and party role tooltip strings
	
	nUI_L["Party Role: |cFF00FFFF%s|r"] = "隊伍角色: |cFF00FFFF%s|r"; 
	nUI_L["Raid Role: |cFF00FFFF%s|r"]  = "團隊角色: |cFF00FFFF%s|r"; 
	nUI_L["Raid Leader"]                = "團隊隊長"; 
	nUI_L["Party Leader"]               = "隊伍隊長"; 
	nUI_L["Raid Assistant"]             = "團隊助手"; 
	nUI_L["Main Tank"]                  = "主坦"; 
	nUI_L["Off-Tank"]                   = "副坦"; 
	nUI_L["Master Looter"]              = "寶物分配者"; 
	
	-- hunter pet feeder strings
	
	nUI_L[nUI_FOOD_MEAT]	= "肉";
	nUI_L[nUI_FOOD_FISH]	= "魚";
	nUI_L[nUI_FOOD_BREAD]	= "麵包";
	nUI_L[nUI_FOOD_CHEESE]  = "乳酪";
	nUI_L[nUI_FOOD_FRUIT]	= "水果";
	nUI_L[nUI_FOOD_FUNGUS]  = "蘑菇";
	
	nUI_L["Click to feed %s"]           = "點選餵食%s"; 
	nUI_L["Click to cancel feeding"]    = "點選取消餵食"; 
	nUI_L["nUI: %s can eat %s%s%s"]     = "nUI: %喜歡吃%s%s%s"; 
	nUI_L[" or "]                       = "或"; 
	nUI_L["nUI: You don't have a pet!"] = "nUI: 你目前沒有寵物在身邊!";
	
	nUI_L["nUI: You can feed %s the following...\n"] = "nUI: 你可以給%s吃以下的東西...\n"; 
	nUI_L["nUI: You have nothing you can feed %s in your current inventory"] = "nUI: 背包裡沒有可以餵食%s的食物";
	nUI_L["    Click the pet happiness indictor to feed your pet now"] = "點選寵物快樂指標即可餵食寵物";
	
	-- status bar strings
	
	nUI_L["nUI: Cannot change status bar config while in combat!"] = "nUI: 戦鬥中無法調整狀態欄!";
	nUI_L["nUI: [%s] is not a valid option for orienting a status bar... use LEFT, RIGHT, TOP or BOTTOM"] = "nUI: [%s] 並不是個正確使用狀態欄的方式... 請使用 LEFT, RIGHT, TOP or BOTTOM"; -- do not translate the words "LEFT", "RIGHT", "TOP or "BOTTOM"
	nUI_L["nUI: Can not change status bar overlays while in combat!"] = "nUI: 戰鬥中無法調整狀態欄位置!";
	nUI_L["nUI: The maximum value (%d) of a status bar must be greater than the minimum value (%d)"] = "nUI: 狀態欄的最大值 (%d) 必須大於最小值 (%d)";
	
	-- information panel strings
	
	-- new -- this entire section is new...
	
	nUI_L["Minimap"] = "小地圖";
	
	nUI_L[nUI_INFOPANEL_MINIMAP]   		   		= "Info Panel: 小地圖顯示模式";
	nUI_L[nUI_INFOPANEL_MINIMAP.."Label"]		= "小地圖"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_COMBATLOG]      		= "Info Panel: 戦鬥訊息顯示模式";
	nUI_L[nUI_INFOPANEL_COMBATLOG.."Label"]		= "戦鬥中"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_BMM]		      		= "Info Panel: 戦場小地圖模式";
	nUI_L[nUI_INFOPANEL_BMM.."Label"]			= "地圖"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_RECOUNT]		   		= "Info Panel: Recount 傷害紀錄表模式";
	nUI_L[nUI_INFOPANEL_RECOUNT.."Label"]		= "Recount"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_OMEN2]		      		= "Info Panel: Omen2 仇恨表模式";
	nUI_L[nUI_INFOPANEL_OMEN2.."Label"]			= "Omen2"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_OMEN2KLH]	      		= "Info Panel:  Omen2 + KLH 仇恨表模式";
	nUI_L[nUI_INFOPANEL_OMEN2KLH.."Label"]		= "仇恨"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_OMEN2RECOUNT]		   	= "Info Panel: Omen2 仇恨表 + Recount 傷害表模式";
	nUI_L[nUI_INFOPANEL_OMEN2RECOUNT.."Label"]	= "Omen2+"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_KLH]		      		= "Info Panel: KLH 仇恨表模式";
	nUI_L[nUI_INFOPANEL_KLH.."Label"]			= "KTM"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L[nUI_INFOPANEL_KLHRECOUNT]	      		= "Info Panel: KLH 仇恨表 + Recount 傷害表模式";
	nUI_L[nUI_INFOPANEL_KLHRECOUNT.."Label"]	= "KTM+"; -- small word or abbreviation to show on the panel selector button
	
	nUI_L["nUI: You need to go to the WoW Interface menu, select the 'Social' option and turn off the 'Simple Chat' menu option to enable integrated combat log support in nUI."] = "nUI: 你需要到魔獸選單的介面選單, 到\"SOCIAL\"選擇 把\"SIMPLE CHAT\" 選單關閉 才能啟動戰鬥訊息在 nUI.";
	nUI_L["The %s Info Panel plugin is a core plugin to nUI and cannot be disabled"] = " %s 訊息是 nUI 的主要元件不能關閉";
	nUI_L["Click to change information panels"] = "點選轉換訊息模式";
	nUI_L["nUI: Cannot initialize the Info Panel plugin [ %s ] -- it does not have an initPanel() interface method"] = "nUI: nUI無法啟動 Info Panel plugin [ |cFF00FFFF%s|r ] -- 需要 initPanel() interface method";
	nUI_L["nUI: Cannot initialize the Info Panel plugin [ %s ] -- No global object by that name exists"] = "nUI: 無法啟動 Info Panel plugin [ |cFF00FFFF%s|r ] -- No global object by that name exists";	
	nUI_L["nUI: Cannot select the Info Panel plugin [ %s ] -- it does not have a setSelected() interface method"] = "nUI: 無法選擇 Info Panel plugin [ |cFF00FFFF%s|r ] -- 無 setSelected() interface method";
	
	-- HUD layout strings (heads up display)
	
	-- new -- this entire section is new
	
	nUI_L["Click to change HUD layouts"] = "點選轉換 HUD 排列";
	
	nUI_L[nUI_HUDLAYOUT_PLAYERTARGET]	   		= "HUD 排列: 玩家左邊 / 目標右邊";
	nUI_L[nUI_HUDLAYOUT_PLAYERTARGET.."Label"]	= "Player/Target"; -- small phrase or abbreviation to show on the HUD selector button
	
	nUI_L[nUI_HUDLAYOUT_HEALTHPOWER]	   		= "HUD 排列: 生命條左邊 / 能量條右邊";
	nUI_L[nUI_HUDLAYOUT_HEALTHPOWER.."Label"]	= "Health/Power"; -- small phrase or abbreviation to show on the HUD selector button
	
	nUI_L[nUI_HUDLAYOUT_SIDEBYSIDE]	   			= "HUD 排列: 橫列條";
	nUI_L[nUI_HUDLAYOUT_SIDEBYSIDE.."Label"]	= "Side by Side"; -- small phrase or abbreviation to show on the HUD selector button
	
	nUI_L[nUI_HUDLAYOUT_NOBARS]	   				= "HUD 排列: 簡便 HUD";
	nUI_L[nUI_HUDLAYOUT_NOBARS.."Label"]		= "Simple HUD"; -- small phrase or abbreviation to show on the HUD selector button
	
	nUI_L[nUI_HUDLAYOUT_NOHUD]		   			= "HUD 排列: 關閉 ";
	nUI_L[nUI_HUDLAYOUT_NOHUD.."Label"]			= "無 HUD"; -- small phrase or abbreviation to show on the panel selector button
	
	nUI_L[nUI_HUDMODE_PLAYERTARGET]        = "nUI 玩家/目標 HUD 模式";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_PET]    = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for 顯示玩家寵物資訊";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_PLAYER] = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for 顯示玩家資訊";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_TARGET] = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for 顯示目標資訊";
	nUI_L[nUI_HUDSKIN_PLAYERTARGET_TOT]    = nUI_L[nUI_HUDMODE_PLAYERTARGET]..": skin for 顯示目標的目標資訊";
	
	nUI_L[nUI_HUDMODE_HEALTHPOWER]         = "nUI 生命/能量 HUD Mode";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_PET]     = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for 顯示玩家寵物資訊";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_PLAYER]  = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for 顯示玩家資訊";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_TARGET]  = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for 顯示目標資訊";
	nUI_L[nUI_HUDSKIN_HEALTHPOWER_TOT]     = nUI_L[nUI_HUDMODE_HEALTHPOWER]..": skin for 顯示目標的目標資訊";
	
	nUI_L[nUI_HUDMODE_SIDEBYSIDE]          = "nUI 橫列 HUD 模式";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_PET]      = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for 顯示玩家寵物資訊";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_PLAYER]   = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for 顯示玩家資訊";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_TARGET]   = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for 顯示目標資訊";
	nUI_L[nUI_HUDSKIN_SIDEBYSIDE_TOT]      = nUI_L[nUI_HUDMODE_SIDEBYSIDE]..": skin for 顯示目標的目標資訊";
	
	-- nUI_Unit strings
	
	nUI_L["Pet"]    = "寵物";    -- new -- this should be a small single word or abbreviation to use as a label on a small targeting button
	nUI_L["Target"] = "目標"; -- new -- this hsould be a small single word or abbreviation to use as a label on a small targeting button
	
	nUI_L["Range: %d-%d"]             = "距離: %d-%d"; 
	
	nUI_L["unit: player"]             = "玩家"; 
	nUI_L["unit: pet"]		  = "玩家的寵物";
	nUI_L["unit: pettarget"]          = "玩家的寵物的目標";
	nUI_L["unit: focus"]              = "玩家的專注目標";
	nUI_L["unit: focustarget"]        = "玩家的專注目標的目標";
	nUI_L["unit: target"]             = "玩家的目前目標";
	nUI_L["unit: %s-target"]          = "%s的目標";
	nUI_L["unit: mouseover"]          = "鼠標懸停在目標上";
	nUI_L["unit: targettarget"]       = "目標的目標 (ToT)";
	nUI_L["unit: targettargettarget"] = "目標的目標的目標 (ToTT)";
	nUI_L["unit: party%d"]            = "隊員%d";
	nUI_L["unit: party%dpet"]         = "隊員%d的寵物"; 
	nUI_L["unit: party%dtarget"]      = "隊員%d的目標"; 
	nUI_L["unit: party%dpettarget"]   = "隊員%d的寵物的目標";
	nUI_L["unit: raid%d"]             = "團員%d";
	nUI_L["unit: raid%dpet"]          = "團員%d的寵物"; 
	nUI_L["unit: raid%dtarget"]       = "團員%的目標";
	nUI_L["unit: raid%dpettarget"]    = "團員%的寵物的目標";

	nUI_L[nUI_UNITMODE_PLAYER]        = "nUI 種田模式"; -- new
	nUI_L[nUI_UNITSKIN_PARTYFOCUS]    = nUI_L[nUI_UNITMODE_PLAYER]..": 玩家專注 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYMOUSE]    = nUI_L[nUI_UNITMODE_PLAYER]..": 滑鼠上浮 skin"; 
	nUI_L[nUI_UNITSKIN_SOLOPET]       = nUI_L[nUI_UNITMODE_PLAYER]..": 玩家寵物 skin"; 
	nUI_L[nUI_UNITSKIN_SOLOPETBUTTON] = nUI_L[nUI_UNITMODE_PLAYER]..": 寵物目標按鈕 skins... i.e. Target's Pet, Player Focus' Pet, etc"; 
	nUI_L[nUI_UNITSKIN_SOLOPLAYER]    = nUI_L[nUI_UNITMODE_PLAYER]..": 玩家 skin"; 
	nUI_L[nUI_UNITSKIN_SOLOTARGET]    = nUI_L[nUI_UNITMODE_PLAYER]..": 目標 skin"; 
	nUI_L[nUI_UNITSKIN_SOLOTGTBUTTON] = nUI_L[nUI_UNITMODE_PLAYER]..": 目標的目標按鈕 unit skins... i.e. Player Focus' target, etc."; 
	nUI_L[nUI_UNITSKIN_SOLOTOT]       = nUI_L[nUI_UNITMODE_PLAYER]..": 目標的目標 skin"; 

	nUI_L[nUI_UNITMODE_PARTY]          = "nUI 團隊/隊伍 模式"; -- new
	nUI_L[nUI_UNITSKIN_PARTYFOCUS]     = nUI_L[nUI_UNITMODE_PARTY]..": 玩家專注 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYMOUSE]     = nUI_L[nUI_UNITMODE_PARTY]..": 滑鼠上浮 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYPLAYER]    = nUI_L[nUI_UNITMODE_PARTY]..": 玩家 skin";
	nUI_L[nUI_UNITSKIN_PARTYPET]       = nUI_L[nUI_UNITMODE_PARTY]..": 玩家的寵物 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYTARGET]    = nUI_L[nUI_UNITMODE_PARTY]..": 目標 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYTOT]       = nUI_L[nUI_UNITMODE_PARTY]..": 目標的目標 skin";
	nUI_L[nUI_UNITSKIN_PARTYFOCUS]     = nUI_L[nUI_UNITMODE_PARTY]..": 玩家專注 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYLEFT]      = nUI_L[nUI_UNITMODE_PARTY]..": 左邊團隊隊員 skin"; 
	nUI_L[nUI_UNITSKIN_PARTYRIGHT]     = nUI_L[nUI_UNITMODE_PARTY]..": 右邊團隊隊員 skin";
	nUI_L[nUI_UNITSKIN_PARTYPETBUTTON] = nUI_L[nUI_UNITMODE_PARTY]..": 團隊隊員與寵物 skin";
	nUI_L[nUI_UNITSKIN_PARTYTGTBUTTON] = nUI_L[nUI_UNITMODE_PARTY]..": 團隊隊員的專著 skin";
	nUI_L[nUI_UNITSKIN_PARTYMOUSE]     = nUI_L[nUI_UNITMODE_PARTY]..": 滑鼠上浮 skin"; 
	
	nUI_L[nUI_UNITMODE_RAID10]          ="nUI 十人團隊 模式"; 
	nUI_L[nUI_UNITSKIN_RAID10FOCUS]     = nUI_L[nUI_UNITMODE_RAID10]..": 玩家專注 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10MOUSE]     = nUI_L[nUI_UNITMODE_RAID10]..": 滑鼠上浮 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10PLAYER]    = nUI_L[nUI_UNITMODE_RAID10]..": 玩家 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10PET]       = nUI_L[nUI_UNITMODE_RAID10]..": 玩家的寵物 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10TARGET]    = nUI_L[nUI_UNITMODE_RAID10]..": 目標 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10TOT]       = nUI_L[nUI_UNITMODE_RAID10]..": 目標的目標 skin";
	nUI_L[nUI_UNITSKIN_RAID10FOCUS]     = nUI_L[nUI_UNITMODE_RAID10]..": 玩家專注 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10LEFT]      = nUI_L[nUI_UNITMODE_RAID10]..": 左邊團隊隊員 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10RIGHT]     = nUI_L[nUI_UNITMODE_RAID10]..": 右邊團隊隊員 skin"; 
	nUI_L[nUI_UNITSKIN_RAID10PETBUTTON] = nUI_L[nUI_UNITMODE_RAID10]..": 團隊隊員與寵物 skin";
	nUI_L[nUI_UNITSKIN_RAID10TGTBUTTON] = nUI_L[nUI_UNITMODE_RAID10]..": 團隊隊員的專著 skin";
	nUI_L[nUI_UNITSKIN_RAID10MOUSE]     = nUI_L[nUI_UNITMODE_RAID10]..": 滑鼠上浮 skin"; 
	
	nUI_L[nUI_UNITPANEL_PLAYER]      		= "Unit Panel: 單獨模式"; 
	nUI_L[nUI_UNITPANEL_PLAYER.."Label"]	= "玩家"; 
	
	nUI_L[nUI_UNITPANEL_PARTY]       		= "Unit Panel: 隊伍/團隊模式"; 
	nUI_L[nUI_UNITPANEL_PARTY.."Label"] 	= "隊伍"; 
	
	nUI_L[nUI_UNITPANEL_RAID10]      		= "Unit Panel: 十人團隊模式"; 
	nUI_L[nUI_UNITPANEL_RAID10.."Label"]	= "團隊 十"; 
	
	nUI_L[nUI_UNITPANEL_RAID15]      		= "Unit Panel: 十五人團隊模式"; 
	nUI_L[nUI_UNITPANEL_RAID15.."Label"]	= "團隊 十五"; 
	
	nUI_L[nUI_UNITPANEL_RAID20]      		= "Unit Panel: 二十人團隊模式"; 
	nUI_L[nUI_UNITPANEL_RAID20.."Label"]	= "團隊 二十"; 
	
	nUI_L[nUI_UNITPANEL_RAID25]      		= "Unit Panel: 二十五人團隊模式"; 
	nUI_L[nUI_UNITPANEL_RAID25.."Label"]	= "團隊 二十五"; 
	
	nUI_L[nUI_UNITPANEL_RAID40]      		= "Unit Panel: 四十人團隊模式"; 
	nUI_L[nUI_UNITPANEL_RAID40.."Label"]	= "團隊 四十"; 
	
	nUI_L["Click to change unit frame panels"] = "點選轉換顯示框"; 
	
	nUI_L["<unnamed frame>"] = "<unnamed frame>";
	nUI_L["unit change"] = "unit change";
	nUI_L["unit class"] = "unit class";
	nUI_L["pet happiness"] = "pet happiness";
	nUI_L["unit label"] = "unit label";
	nUI_L["unit level"] = "unit level";
	nUI_L["unit reaction"] = "unit reaction";
	nUI_L["unit health"] = "unit health";
	nUI_L["unit power"] = "unit power";
	nUI_L["unit portrait"] = "unit portrait";
	nUI_L["raid group"] = "raid group";
	nUI_L["unit PvP"] = "unit PvP";
	nUI_L["raid target"] = "raid target";
	nUI_L["casting bar"] = "casting bar";
	nUI_L["ready check"] = "ready check";
	nUI_L["unit status"] = "unit status";
	nUI_L["unit aura"] = "unit aura"; 
	nUI_L["unit combat"] = "unit combat"; 
	nUI_L["unit resting"] = "unit resting"; 
	nUI_L["unit role"] = "unit role"; 
	nUI_L["unit feedback"] = "unit feedback"; 
	
	nUI_L["passed unit id is <nil> in callback table for %s"] = "passed unit id is <nil> in callback table for %s";
	nUI_L["nUI: Warning.. anchoring %s to %s -- anchor point has a <nil> value."] = "nUI: Warning.. anchoring %s to %s -- anchor point has a <nil> value."; 
	nUI_L["nUI: Cannot register %s for scaling... frame does not have an applyScale() method"] = "nUI: Cannot register %s for scaling... frame does not have an applyScale() method"; 
	nUI_L["nUI: Cannot register %s for scaling... frame does not have an applyAnchor() method"] = "nUI: Cannot register %s for scaling... frame does not have an applyAnchor() method"; 
	nUI_L["nUI: %s %s callback %s does not have a newUnitInfo() method."] = "nUI: %s %s callback %s does not have a newUnitInfo() method.";
	nUI_L["nUI_UnitClass.lua: unhandled unit class [%s] for [%s]"] = "nUI_UnitClass.lua: unhandled unit class [%s] for [%s]";
	nUI_L["nUI: click-casting registration is %s"] = "nUI: 一鍵施法狀態是 %s";
	nUI_L["nUI: must pass a valid parent frame to nUI_Unit:createFrame() for unit id [%s (%s)]"] = "nUI: must pass a valid parent frame to nUI_Unit:createFrame() for unit id [%s (%s)]";
	nUI_L["nUI says: Gratz for reaching level %d %s!"] = "nUI says: 恭喜 %s 達到等級 %d !";
	nUI_L["nUI_Unit: [%s] is not a valid unit frame element type!"] = "nUI_Unit: [%s] is not a valid unit frame element type!"; 
	nUI_L["nUI_Unit: [%s] is not a known unit skin name!"] = "nUI_Unit: [%s] is not a known unit skin name!"; 
	
	-- nUI_Unit hunter pet strings
	
	nUI_L["Your pet"] = "您的寵物";
	nUI_L["quickly"] = "迅速的";
	nUI_L["slowly"] = "慢慢的";
	nUI_L["nUI: %s is happy."] = "nUI: %s 很滿意.";
	nUI_L["nUI: %s is unhappy... time to feed!"] = "nUI: %s 不開心... 是時候餵食了!";
	nUI_L["nUI: Warning! %s is |cFFFFFFFFNOT|r happy! Better feed soon."] = "nUI: 警告! %s 目前 |cFFFFFFFF非常不開心|r ! 盡快餵食."; -- don't miss the word "NOT" hidden in this line when you translate
	nUI_L["nUI: Warning... %s is %s losing loyalty "] = "nUI: 警告... %s 正在 %s 降低忠誠度 ";
	nUI_L["nUI: %s is %s gaining loyalty"] = "nUI: %s is %s 獲得忠誠度";
	nUI_L["nUI: %s has stopped gaining loyalty"] = "nUI: %s 停止獲得忠誠度";
	nUI_L["nUI: %s has stopped losing loyalty"] = "nUI: %s 停止損失忠誠度";
	nUI_L["nUI_UnitHappiness.lua: unhandled pet happiness value (%s)"] = "nUI_UnitHappiness.lua: 寵物高興值 (%s)";
	nUI_L["Your pet's current damage bonus is %d%%"] = "Your pet's current damage bonus is %+d%%"; -- new
	nUI_L["Your pet's current damage penalty is %d%%"] = "Your pet's current damage penalty is %+d%%"; -- new
	nUI_L["nUI: It looks to me like you're a little busy... maybe you should try feeding %s AFTER you leave combat?"] = "nUI: It looks to me like you're a little busy... maybe you should try feeding %s AFTER you leave combat?"; -- new
	nUI_L["nUI: I looked everywhere, but I couldn't find a pet to feed. Perhaps he's in your backpack?"] = "nUI: I looked everywhere, but I couldn't find a pet to feed. Perhaps he's in your backpack?"; -- new
	nUI_L["nUI: You know, I could be wrong, but I don't think feeding %s is a very good idea... it doesn't look to me like what you have in your bags is what %s is thinking about eating."] = "nUI: You know, I could be wrong, but I don't think feeding %s is a very good idea... it doesn't look to me like what you have in your bags is what %s is thinking about eating."; -- new
	
	-- miscelaneous strings
	
	nUI_L["Version"]             = "nUI 版本 |cFF00FF00%s|r"; 
	nUI_L["Copyright"]           = "Copyright (C) 2008 by K. Scott Piel"; 
	nUI_L["Rights"]              = "All Rights Reserved";
	nUI_L["Off Hand Weapon:"]  = "副手武器:"; 
	nUI_L["Main Hand Weapon:"] = "主手武器:"; 
	nUI_L["Group %d"] = "第 %d 小隊";
	nUI_L["MS"]                  = "毫秒"; 
	nUI_L["FPS"]				 = "FPS"; 
	nUI_L["Minimap Button Bag"]  = "小地圖按鈕包"; 
	
	-- health race bar tooltip strings
	
	nUI_L["nUI Health Race Stats..."] = "nUI 生命條 種族 狀態..."; 
	nUI_L["No current advantage to <player> or <target>"] = "目前無優勢對於 %s 或 %s"; 
	nUI_L["<unit name>'s Health: <current>/<maximum> (<percent>)"] = "%s 的生命: |cFF00FF00%d/%d|r (|cFFFFFFFF%0.1f%%|r)"; 
	nUI_L["Advantage to <player>: <pct>"] = "%s: (|cFF00FF00%+0.1f%%|r) 有優勢"; 
	nUI_L["Advantage to <target>: <pct>"] = "%s: (|cFFFFC0C0%0.1f%%|r) 有優勢"; 
	
	-- skinning system messages
	
	nUI_L["nUI could not load the currently selected skin [ %s ]... perhaps you have it disabled? Switching to the default nUI skin."] = "nUI 無法載入目前選擇的 skin [ |cFFFFC0C0%s|r ]... 你可能已關閉它了? 使用預設的 nUI skin."; 
	nUI_L["nUI: Cannot register %s for skinning... frame does not have an applySkin() method"] = "nUI: 無法註冊 |cFFFFC0C0%s|r for skinning... frame does not have an applySkin() method"; 
	
	-- names of the various frames that nUI allows the user to move on the screen
	
	-- new / this entire section is new...
	-- these are labels for all of the movable frames in UI (the frames the user can drag around after using '/nui movers'
	
	nUI_L["Micro-Menu"]                = "小選單";
	nUI_L["Capture Bar"]               = "抓取條";
	nUI_L["Watched Quests"]            = "看過的任務";
	nUI_L["Quest Timer"]               = "任務計時";
	nUI_L["Equipment Durability"]      = "裝備耐久度";
	nUI_L["PvP Objectives"]            = "PvP 物件";
	nUI_L["In-Game Tooltips"]          = "遊戲說明";
	nUI_L["Bag Bar"]                   = "背包條";
	nUI_L["pg1 / Action Bar]"]         = "pg1 / 動作條]";
	nUI_L["pg2 / nUI Bonus Bar 1"]     = "pg2 / nUI Bonus條 1";
	nUI_L["pg3 / Right 2"]             = "pg3 / 右 2";
	nUI_L["pg4 / Right"]               = "pg4 / 右";
	nUI_L["pg5 / BottomRight"]         = "pg5 / 右下";
	nUI_L["pg6 / BottomLeft"]          = "pg6 / 左下";
	nUI_L["nUI Bonus Bar 2"]           = "nUI Bonus條 2";
	nUI_L["Pet/Stance/Shapeshift Bar"] = "寵物/姿勢/變形 條";
	
	-- slash command processing	
	
	-- new / this entire section is new...
	-- there are four components to each slash command entry... the command word the user types after the "/nui", a list of options
	-- (or arguments if you prefer) the user can provide to the command, a description of the command itself and a message that
	-- is printed after the command is executed. Any or all of these elements can be translated to make sense in the local language
	-- The only thing that cannot be translated, of course, is the "/nui" prefix itself. If any element is "nil" then it just does 
	-- not apply to that command and can be ignored.
	
	nUI_SlashCommands =
	{
		[nUI_SLASHCMD_HELP] =
		{
			command = "help",
			options = "{command}",
			desc    = "Displays the list of all available slash commands if {command} is not given or, if {command} is given, displays information about that specific command",
			message = nil,
		},
		[nUI_SLASHCMD_RELOAD] =
		{
			command = "rl",
			options = nil,
			desc    = "Reloads the user interface and all enabled mods (same as /console reloadui)",
			message = nil,
		},
		[nUI_SLASHCMD_BUTTONBAG] =
		{
			command = "bb",
			options = nil,
			desc    = "This command toggles the display of the Minimap Button Bag on and off.",
			message = nil,
		},
		[nUI_SLASHCMD_MOVERS] =
		{
			command = "movers",
			options = nil,
			desc    = "Enables and disables moving the standard Blizzard UI frames such as tooltips, durability, quest timer, etc.",
			message = "nUI: Blizzard frame movers have been %s", -- enabled or disabled
		},
		[nUI_SLASHCMD_CONSOLE] =
		{
			command = "console",
			options = "{on|off|mouseover}",
			desc    = "Sets the visibility option for the top console where 'on' always show the console, 'off' always hides the console and 'mouseover' shows the console when the mouse is over the console.",
			message = "nUI: Top console visibility has been set to %s", -- "on", "off" or "mouseover"
		},
		[nUI_SLASHCMD_TOOLTIPS] =
		{
			command = "tooltips",
			options = "{owner|mouse|fixed|default}",
			desc    = "This option sets the location of the mouseover tooltips where 'owner' displays the tooltip next to the frame that owns it, 'mouse' displays the tooltip at the current mouse location, 'fixed' displays all tooltips at a fixed location on screen or 'default' does not manage tooltips at all",
			message = "nUI: Tooltip display mode changed to |cFF00FFFF%s|r", -- the chosen tooltip mode
		},
		[nUI_SLASHCMD_BAGSCALE] =
		{
			command = "bagscale",
			options = "{n}",
			desc    = "This option increases and decreases the size of your bags where {n} is a number between 0.5 and 1.5 -- 1 is the default",
			message = "nUI: Your bag scale has been changed to |cFF00FFFF%0.2f|r", -- the chosen scale
		},
		[nUI_SLASHCMD_BAGBAR] =
		{
			command = "bagbar",
			options = nil,
			desc    = "This option toggles display of the bag bar on and off",
			message = "nUI: The bag bar's display has been %s", -- enabled or disabled
		},
		[nUI_SLASHCMD_FRAMERATE] =
		{
			command = "framerate",
			options = "{n}",
			desc    = "This option changes (or throttles) the maximum refresh rate for bar animations and unit frames. Increase {n} for smoothness, decrease {n} for performance. The default is "..nUI_DEFAULT_FRAME_RATE.." frames per second.",
			message = "nUI: Your refresh frame rate has been changed to |cFF00FFFF%0.0fFPS|r", -- the chosen rate in frames per second... change FPS if you need a different abreviation!
		},
		[nUI_SLASHCMD_SHOWANIM] =
		{
			command = "anim",
			options = nil,
			desc    = "This option toggles display of animated unit portraits and unit bars on and off",
			message = "nUI: Display of animated unit frames has been %s", -- enabled or disabled
		},
		[nUI_SLASHCMD_HUD] =
		{
			command  = "hud",
			options  = nil,
			desc     = "This command provides access to a set of commands used to control the behavior of the nUI HUD. Use the '/nui hud' command alone for a list of available sub-commands.",
			message  = nil,
			sub_menu =
			{
				[nUI_SLASHCMD_HUD_SCALE] =
				{
					command = "scale",
					options = "{n}",
					desc    = "This option sets the scale of the HUD where 0.25 <= {n} <= 1.75. Smaller values of {n} descrease the HUD size and larger values increase the size. The default is {n} = 1",
					message = "nUI: The HUD scale has been set to |cFF00FFFF%0.2f|r", -- a number
				},
				[nUI_SLASHCMD_HUD_SHOWNPC] =
				{
					command = "shownpc",
					options = nil,
					desc    = "This option toggles display of HUD bars for non-attackable NPC targets on and off when out of combat",
					message = "nUI: Non-attackable NPC target HUD bar display has been %s", -- enabled or disabled
				},
				[nUI_SLASHCMD_HUD_HEALTHRACE] =
				{
					command = "healthrace",
					options = nil,
					desc    = "This option toggles display of in-HUD health race bar on and off",
					message = "nUI: The HUD health race bar display has been %s", -- enabled or disabled
				},
				[nUI_SLASHCMD_HUD_HGAP] =
				{
					command = "hgap",
					options = "{n}",
					desc    = "This option sets horizontal gap between the left and right sides of the HUD where {n} is a number greater than 0. Increase {n} to increase the gap between the left and right of the HUD. The default value of {n} is 400",
					message = "nUI: The horizontal HUD gap has been set to |cFF00FFFF%0.0f|r", -- a number greater than zero
				},
				[nUI_SLASHCMD_HUD_IDLEALPHA] =
				{
					command = "idlealpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you are completely idle where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 0",
					message = "nUI: The HUD idle alpha has been set to |cFF00FFFF%0.2f|r", -- a number between 0 and 1
				},
				[nUI_SLASHCMD_HUD_REGENALPHA] =
				{
					command = "regenalpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you (or your pet) are regenerating health, regenerating power or are debuffed where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 0.35",
					message = "nUI: The HUD regen alpha has been set to |cFF00FFFF%0.2f|r", -- a number between 0 and 1
				},
				[nUI_SLASHCMD_HUD_TARGETALPHA] =
				{
					command = "targetalpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you have selected a valid target where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 0.75",
					message = "nUI: The HUD targeting alpha has been set to |cFF00FFFF%0.2f|r", -- a number between 0 and 1
				},
				[nUI_SLASHCMD_HUD_COMBATALPHA] =
				{
					command = "combatalpha",
					options = "{n}",
					desc    = "This option sets the transparency of the HUD when you or your pet are in combat where {n} = 0 for an invisible HUD and {n} = 1 for a fully opaque HUD. The default is {n} = 1",
					message = "nUI: The HUD combat alpha has been set to |cFF00FFFF%0.2f|r", -- a number between 0 and 1
				},
			},
		},
		[nUI_SLASHCMD_CLOCK] =
		{
			command = "clock",
			options = "{12|24}",
			desc    = "This option sets the display of the dashboard clock to either a 12 hour clock or a 24 hour clock. The default is 12",
			message = "nUI: The dashboard clock has been set to |cFF00FFFF%d|r hour format", -- 12 or 24 hour format
		},
		[nUI_SLASHCMD_LASTITEM+1] =
		{
			command = "debug",
			options = "{n}",
			desc    = "This option sets the nUI debugger messaging level. As a rule you should only change debug levels if you are asked to by the mod author. Use {n} = 0 to turn debugging off entirely (the default).",
			message = "nUI: Your debugging level has been set to |cFF00FFFF%d|r", -- an integer value
		},
	};
	
	-- new -- these strings are the optional arguments to their respective commands and can be 
	--        translated to make sense in the local language
	
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "on" )]        = "on";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "off" )]       = "off";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "mouseover" )] = "mouseover";
	
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "owner" )]   = "owner";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "mouse" )]   = "mouse";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "fixed" )]   = "fixed";
	nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_TOOLTIPS, "default" )] = "default";
	
	-- new -- miscellaneous slash command messages printed to the player
	
	nUI_L["The value [ %s ] is not a valid nUI slash command. Try [ /nui help ] for a list of commands"] = "The value [ |cFFFFC000%s|r ] is not a valid nUI slash command. Try [ |cFF00FFFF/nui help|r ] for a list of commands";
	nUI_L["nUI currently supports the following list of slash commands..."]	= "nUI currently supports the following list of slash commands..."; 
	nUI_L["The '/nui %s' slash command currently supports the following list of sub-commands..."] = "The '|cFF00FFFF/nui %s|r' slash command currently supports the following list of sub-commands...";
	nUI_L["nUI: [ %s ] is not a valid tooltip settings option... please choose from %s, %s, %s or %s"] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid tooltip settings option... please choose from |cFF00FFFF%s|r, |cFF00FFFF%s|r, |cFF00FFFF%s|r or |cFF00FFFF%s|r";
	nUI_L["nUI: [ %s ] is not a valid console visibility option... please choose from %s, %s or %s"] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid console visibility option... please choose from |cFF00FFFF%s|r, |cFF00FFFF%s|r or |cFF00FFFF%s|r";
	nUI_L["nUI: [ %s ] is not a valid alpha value... please choose a number between 0 and 1 where 0 is fully transparent and 1 is fully opaque."] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid alpha value... please choose a number between 0 and 1 where 0 is fully transparent and 1 is fully opaque.";
	nUI_L["nUI: [ %s ] is not a valid horizontal gap value... please choose a number between 1 and 1200 where 1 is very narrow and 1200 is very wide."] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid horizontal gap value... please choose a number between 1 and 1200 where 1 is very narrow and 1200 is very wide.";
	nUI_L["nUI: [ %s ] is not a valid clock option... please choose either '12' for a 12 hour clock or '24' for a 24 hour clock."] = "nUI: [ |cFFFFC0C0%s|r ] is not a valid clock option... please choose either '12' for a 12 hour clock or '24' for a 24 hour clock.";	
		
end