﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

-- pet feeder constants

nUI_DEFAULT_FRAME_RATE   = 30;
nUI_FOOD_MEAT	         = "meat";
nUI_FOOD_FISH	         = "fish";
nUI_FOOD_BREAD	         = "bread";
nUI_FOOD_CHEESE          = "cheese";
nUI_FOOD_FRUIT	         = "fruit";
nUI_FOOD_FUNGUS          = "fungus";

-- default information HUD layouts

nUI_HUDMODE_PLAYERTARGET = 1;
nUI_HUDMODE_HEALTHPOWER  = 2;
nUI_HUDMODE_SIDEBYSIDE   = 3;
nUI_HUDMODE_NOBARS       = 4;
nUI_HUDMODE_NOHUD        = 5;

nUI_HUDLAYOUT_PLAYERTARGET = "nUI_HUDLayout_PlayerTarget";
nUI_HUDLAYOUT_HEALTHPOWER  = "nUI_HUDLayout_HealthPower";
nUI_HUDLAYOUT_SIDEBYSIDE   = "nUI_HUDLayout_SideBySide";
nUI_HUDLAYOUT_NOBARS       = "nUI_HUDLayout_NoBars";
nUI_HUDLAYOUT_NOHUD        = "nUI_HUDLayout_NoHUD";

nUI_HUDUNIT_PLAYERTARGET        = "nUI_HUDUnit_PlayerTarget";
nUI_HUDUNIT_PLAYERTARGET_PET    = nUI_HUDUNIT_PLAYERTARGET.."_Pet";
nUI_HUDUNIT_PLAYERTARGET_PLAYER = nUI_HUDUNIT_PLAYERTARGET.."_Player";
nUI_HUDUNIT_PLAYERTARGET_TARGET = nUI_HUDUNIT_PLAYERTARGET.."_Target";
nUI_HUDUNIT_PLAYERTARGET_TOT    = nUI_HUDUNIT_PLAYERTARGET.."_ToT";

nUI_HUDSKIN_PLAYERTARGET_PET    = nUI_HUDUNIT_PLAYERTARGET_PET.."Skin";
nUI_HUDSKIN_PLAYERTARGET_PLAYER = nUI_HUDUNIT_PLAYERTARGET_PLAYER.."Skin";
nUI_HUDSKIN_PLAYERTARGET_TARGET = nUI_HUDUNIT_PLAYERTARGET_TARGET.."Skin";
nUI_HUDSKIN_PLAYERTARGET_TOT    = nUI_HUDUNIT_PLAYERTARGET_TOT.."Skin";

nUI_HUDUNIT_HEALTHPOWER         = "nUI_HUDUnit_HealthPower";
nUI_HUDUNIT_HEALTHPOWER_PET     = nUI_HUDUNIT_HEALTHPOWER.."_Pet";
nUI_HUDUNIT_HEALTHPOWER_PLAYER  = nUI_HUDUNIT_HEALTHPOWER.."_Player";
nUI_HUDUNIT_HEALTHPOWER_TARGET  = nUI_HUDUNIT_HEALTHPOWER.."_Target";
nUI_HUDUNIT_HEALTHPOWER_TOT     = nUI_HUDUNIT_HEALTHPOWER.."_ToT";

nUI_HUDSKIN_HEALTHPOWER_PET     = nUI_HUDUNIT_HEALTHPOWER_PET.."Skin";
nUI_HUDSKIN_HEALTHPOWER_PLAYER  = nUI_HUDUNIT_HEALTHPOWER_PLAYER.."Skin";
nUI_HUDSKIN_HEALTHPOWER_TARGET  = nUI_HUDUNIT_HEALTHPOWER_TARGET.."Skin";
nUI_HUDSKIN_HEALTHPOWER_TOT     = nUI_HUDUNIT_HEALTHPOWER_TOT.."Skin";

nUI_HUDUNIT_SIDEBYSIDE          = "nUI_HUDUnit_SideBySide";
nUI_HUDUNIT_SIDEBYSIDE_PET      = nUI_HUDUNIT_SIDEBYSIDE.."_Pet";
nUI_HUDUNIT_SIDEBYSIDE_PLAYER   = nUI_HUDUNIT_SIDEBYSIDE.."_Player";
nUI_HUDUNIT_SIDEBYSIDE_TARGET   = nUI_HUDUNIT_SIDEBYSIDE.."_Target";
nUI_HUDUNIT_SIDEBYSIDE_TOT      = nUI_HUDUNIT_SIDEBYSIDE.."_ToT";

nUI_HUDSKIN_SIDEBYSIDE_PET      = nUI_HUDUNIT_SIDEBYSIDE_PET.."Skin";
nUI_HUDSKIN_SIDEBYSIDE_PLAYER   = nUI_HUDUNIT_SIDEBYSIDE_PLAYER.."Skin";
nUI_HUDSKIN_SIDEBYSIDE_TARGET   = nUI_HUDUNIT_SIDEBYSIDE_TARGET.."Skin";
nUI_HUDSKIN_SIDEBYSIDE_TOT      = nUI_HUDUNIT_SIDEBYSIDE_TOT.."Skin";

nUI_HUDUNIT_NOBARS              = "nUI_HUDUnit_NoBars";
nUI_HUDUNIT_NOBARS_PLAYER       = nUI_HUDUNIT_NOBARS.."_Player";
nUI_HUDUNIT_NOBARS_TARGET       = nUI_HUDUNIT_NOBARS.."_Target";

nUI_HUDSKIN_NOBARS_PLAYER       = nUI_HUDUNIT_NOBARS_PLAYER.."Skin";
nUI_HUDSKIN_NOBARS_TARGET       = nUI_HUDUNIT_NOBARS_TARGET.."Skin";

-- default information panel modes

nUI_INFOMODE_MINIMAP      = 1;
nUI_INFOMODE_COMBATLOG    = 2;
nUI_INFOMODE_BMM          = 3;
nUI_INFOMODE_RECOUNT      = 4;
nUI_INFOMODE_OMEN2KLH     = 5;
nUI_INFOMODE_OMEN2        = 6;
nUI_INFOMODE_OMEN2RECOUNT = 7;
nUI_INFOMODE_KLH          = 8;
nUI_INFOMODE_KLHRECOUNT   = 9;

nUI_INFOPANEL_MINIMAP      = "nUI_InfoPanel_Minimap";
nUI_INFOPANEL_COMBATLOG    = "nUI_InfoPanel_CombatLog";
nUI_INFOPANEL_BMM          = "nUI_InfoPanel_BattlefieldMinimap";
nUI_INFOPANEL_RECOUNT      = "nUI_InfoPanel_Recount";
nUI_INFOPANEL_OMEN2KLH     = "nUI_InfoPanel_Omen2KLH";
nUI_INFOPANEL_OMEN2        = "nUI_InfoPanel_Omen2";
nUI_INFOPANEL_OMEN2RECOUNT = "nUI_InfoPanel_Omen2Recount";
nUI_INFOPANEL_KLH          = "nUI_InfoPanel_KLH";
nUI_INFOPANEL_KLHRECOUNT   = "nUI_InfoPanel_KLHRecount";
nUI_INFOPANEL_BUTTONBAG    = "nUI_InfoPanel_ButtonBag";

-- default unit frame panel modes

nUI_UNITMODE_PLAYER      = 1;
nUI_UNITMODE_PARTY       = 2;
nUI_UNITMODE_RAID10      = 3;
nUI_UNITMODE_RAID15      = 4;
nUI_UNITMODE_RAID20      = 5;
nUI_UNITMODE_RAID25      = 6;
nUI_UNITMODE_RAID40      = 7;

nUI_UNITPANEL_PLAYER     = "nUI_UnitPanel_Player";
nUI_UNITPANEL_PARTY		 = "nUI_UnitPanel_Party";
nUI_UNITPANEL_RAID10	 = "nUI_UnitPanel_Raid10";
nUI_UNITPANEL_RAID15	 = "nUI_UnitPanel_Raid15";
nUI_UNITPANEL_RAID20	 = "nUI_UnitPanel_Raid20";
nUI_UNITPANEL_RAID25	 = "nUI_UnitPanel_Raid25";
nUI_UNITPANEL_RAID40	 = "nUI_UnitPanel_Raid40";

nUI_UNITFRAME_SOLO        = "nUI_SoloUnit";
nUI_UNITFRAME_SOLOFOCUS   = nUI_UNITFRAME_SOLO.."_Focus";
nUI_UNITFRAME_SOLOFOCUSP  = nUI_UNITFRAME_SOLO.."_FocusP";
nUI_UNITFRAME_SOLOFOCUST  = nUI_UNITFRAME_SOLO.."_FocusT";
nUI_UNITFRAME_SOLOMOUSE   = nUI_UNITFRAME_SOLO.."_Mouseover";
nUI_UNITFRAME_SOLOPET     = nUI_UNITFRAME_SOLO.."_Pet";
nUI_UNITFRAME_SOLOPETT    = nUI_UNITFRAME_SOLO.."_PetTarget";
nUI_UNITFRAME_SOLOPLAYER  = nUI_UNITFRAME_SOLO.."_Player";
nUI_UNITFRAME_SOLOTARGET  = nUI_UNITFRAME_SOLO.."_Target";
nUI_UNITFRAME_SOLOTARGETP = nUI_UNITFRAME_SOLO.."_TargetP";
nUI_UNITFRAME_SOLOTOT     = nUI_UNITFRAME_SOLO.."_ToT";
nUI_UNITFRAME_SOLOTOTP    = nUI_UNITFRAME_SOLO.."_ToTP";
nUI_UNITFRAME_SOLOTOTT    = nUI_UNITFRAME_SOLO.."_ToTT";

nUI_UNITSKIN_SOLOFOCUS     = nUI_UNITFRAME_SOLOFOCUS.."Skin";
nUI_UNITSKIN_SOLOMOUSE     = nUI_UNITFRAME_SOLOMOUSE.."Skin";
nUI_UNITSKIN_SOLOPET       = nUI_UNITFRAME_SOLOPET.."Skin";
nUI_UNITSKIN_SOLOPETBUTTON = nUI_UNITFRAME_SOLO.."_PetButtonSkin";
nUI_UNITSKIN_SOLOPLAYER    = nUI_UNITFRAME_SOLOPLAYER.."Skin";
nUI_UNITSKIN_SOLOTARGET    = nUI_UNITFRAME_SOLOTARGET.."Skin";
nUI_UNITSKIN_SOLOTGTBUTTON = nUI_UNITFRAME_SOLO.."_TgtButtonSkin";
nUI_UNITSKIN_SOLOTOT       = nUI_UNITFRAME_SOLOTOT.."Skin";

nUI_UNITFRAME_PARTY         = "nUI_PartyUnit_Party";
nUI_UNITFRAME_PARTYFOCUS    = "nUI_PartyUnit_Focus";
nUI_UNITFRAME_PARTYFOCUSP   = "nUI_PartyUnit_FocusPet";
nUI_UNITFRAME_PARTYFOCUST   = "nUI_PartyUnit_FocusTarget";
nUI_UNITFRAME_PARTYP        = "nUI_PartyUnit_PartyPet";
nUI_UNITFRAME_PARTYT        = "nUI_PartyUnit_PartyTarget";
nUI_UNITFRAME_PARTYMOUSE    = "nUI_PartyUnit_Mouseover";
nUI_UNITFRAME_PARTYPET      = "nUI_PartyUnit_Pet";
nUI_UNITFRAME_PARTYPETT     = "nUI_PartyUnit_PetTarget";
nUI_UNITFRAME_PARTYPLAYER   = "nUI_PartyUnit_Player";
nUI_UNITFRAME_PARTYTARGET   = "nUI_PartyUnit_Target";
nUI_UNITFRAME_PARTYTARGETP  = "nUI_PartyUnit_TargetPet";
nUI_UNITFRAME_PARTYTOT      = "nUI_PartyUnit_ToT";
nUI_UNITFRAME_PARTYTOTT     = "nUI_PartyUnit_ToTT";

nUI_UNITSKIN_PARTYFOCUS     = nUI_UNITFRAME_PARTYFOCUS.."Skin";
nUI_UNITSKIN_PARTYLEFT      = nUI_UNITFRAME_PARTY.."LeftSkin";
nUI_UNITSKIN_PARTYMOUSE     = nUI_UNITFRAME_PARTYMOUSE.."Skin";
nUI_UNITSKIN_PARTYPET       = nUI_UNITFRAME_PARTYPET.."Skin";
nUI_UNITSKIN_PARTYPETBUTTON = nUI_UNITFRAME_PARTYPET.."ButtonSkin";
nUI_UNITSKIN_PARTYPLAYER    = nUI_UNITFRAME_PARTYPLAYER.."Skin";
nUI_UNITSKIN_PARTYRIGHT     = nUI_UNITFRAME_PARTY.."RightSkin";
nUI_UNITSKIN_PARTYTARGET    = nUI_UNITFRAME_PARTYTARGET.."Skin";
nUI_UNITSKIN_PARTYTGTBUTTON = nUI_UNITFRAME_PARTYTARGET.."ButtonSkin";
nUI_UNITSKIN_PARTYTOT       = nUI_UNITFRAME_PARTYTOT.."Skin";

nUI_UNITFRAME_RAID10        = "nUI_Raid10Unit_Raid";
nUI_UNITFRAME_RAID10FOCUS   = "nUI_Raid10Unit_Focus";
nUI_UNITFRAME_RAID10FOCUSP  = "nUI_Raid10Unit_FocusPet";
nUI_UNITFRAME_RAID10FOCUST  = "nUI_Raid10Unit_FocusTarget";
nUI_UNITFRAME_RAID10P       = "nUI_Raid10Unit_PartyPet";
nUI_UNITFRAME_RAID10T       = "nUI_Raid10Unit_PartyTarget";
nUI_UNITFRAME_RAID10MOUSE   = "nUI_Raid10Unit_Mouseover";
nUI_UNITFRAME_RAID10PET     = "nUI_Raid10Unit_Pet";
nUI_UNITFRAME_RAID10PETT    = "nUI_Raid10Unit_PetTarget";
nUI_UNITFRAME_RAID10PLAYER  = "nUI_Raid10Unit_Player";
nUI_UNITFRAME_RAID10TARGET  = "nUI_Raid10Unit_Target";
nUI_UNITFRAME_RAID10TARGETP = "nUI_Raid10Unit_TargetPet";
nUI_UNITFRAME_RAID10TOT     = "nUI_Raid10Unit_ToT";
nUI_UNITFRAME_RAID10TOTT    = "nUI_Raid10Unit_ToTT";

nUI_UNITSKIN_RAID10FOCUS     = nUI_UNITFRAME_RAID10FOCUS.."Skin";
nUI_UNITSKIN_RAID10LEFT      = nUI_UNITFRAME_RAID10.."LeftSkin";
nUI_UNITSKIN_RAID10MOUSE     = nUI_UNITFRAME_RAID10MOUSE.."Skin";
nUI_UNITSKIN_RAID10PET       = nUI_UNITFRAME_RAID10PET.."Skin";
nUI_UNITSKIN_RAID10PETBUTTON = nUI_UNITFRAME_RAID10PET.."ButtonSkin";
nUI_UNITSKIN_RAID10PLAYER    = nUI_UNITFRAME_RAID10PLAYER.."Skin";
nUI_UNITSKIN_RAID10RIGHT     = nUI_UNITFRAME_RAID10.."RightSkin";
nUI_UNITSKIN_RAID10TARGET    = nUI_UNITFRAME_RAID10TARGET.."Skin";
nUI_UNITSKIN_RAID10TGTBUTTON = nUI_UNITFRAME_RAID10TARGET.."ButtonSkin";
nUI_UNITSKIN_RAID10TOT       = nUI_UNITFRAME_RAID10TOT.."Skin";

FACTION_UPDATE_START_STRING    = "Reputation with ";
FACTION_UPDATE_END_STRING      = " increased";
FACTION_UPDATE_INCREASE_STRING = "increased";

-- slash command processing constants

nUI_SLASHCMD_OPTIONS   = "nUI_SLASHCMD_OPTIONS";

nUI_SLASHCMD_HELP      = 1;
nUI_SLASHCMD_RELOAD    = 2;
nUI_SLASHCMD_BUTTONBAG = 3;
nUI_SLASHCMD_MOVERS    = 4;
nUI_SLASHCMD_CONSOLE   = 5;
nUI_SLASHCMD_TOOLTIPS  = 6;
nUI_SLASHCMD_BAGSCALE  = 7;
nUI_SLASHCMD_BAGBAR    = 8;
nUI_SLASHCMD_FRAMERATE = 9;
nUI_SLASHCMD_SHOWANIM  = 10;
nUI_SLASHCMD_HUD       = 11;
nUI_SLASHCMD_CLOCK     = 12;
nUI_SLASHCMD_ROUNDMAP  = 13;

nUI_SLASHCMD_LASTITEM  = nUI_SLASHCMD_ROUNDMAP;

function nUI_SLASHCMD_OPTIONS( n, v ) return ("nUI_SHASHCMD_%d_%s"):format( n, v ); end

nUI_SLASHCMD_HUD_SCALE       = 1;
nUI_SLASHCMD_HUD_SHOWNPC     = 2;
nUI_SLASHCMD_HUD_HGAP        = 3;
nUI_SLASHCMD_HUD_HEALTHRACE  = 4;
nUI_SLASHCMD_HUD_IDLEALPHA   = 5;
nUI_SLASHCMD_HUD_REGENALPHA  = 6;
nUI_SLASHCMD_HUD_TARGETALPHA = 7;
nUI_SLASHCMD_HUD_COMBATALPHA = 8;
