﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_HUDLayouts then nUI_HUDLayouts = {}; end

-------------------------------------------------------------------------------
-- default configuration for the combat log info panel

nUI_HUDLayouts[nUI_HUDLAYOUT_NOBARS] =
{	
	enabled   = true,
	desc      = nUI_L[nUI_HUDLAYOUT_NOBARS],			-- player friendly name/description of the layout
	label     = nUI_L[nUI_HUDLAYOUT_NOBARS.."Label"],	-- label to use on the panel selection button face
	rotation  = nUI_HUDMODE_NOBARS,						-- index or position this panel appears on/in when clicking the selector button
	
	options  =
	{
		enabled     = true,
		scale       = 1,
		show_race   = false,
		show_threat = false,
		show_pet    = false,
		show_tot    = false,
		npc_bars    = false,
		hGap        = 500,
		vGap        = 400,
		
		alpha =
		{
			idle    = 0,
			regen   = 0.35,
			target  = 0.75,
			combat  = 1,
		},
	},
	elements =
	{
		health_race =
		{
			enabled = true;
			name    = nUI_HUDLAYOUT_NOBARS.."_HealthRaceBar",
			
			anchor =
			{
				anchor_pt   = "BOTTOM",
				relative_to = nUI_HUDLAYOUT_NOBARS.."Bottom",
				relative_pt = "CENTER",
				xOfs        = 0,
				yOfs        = 180,
			},
			options =
			{
				enabled = true;
				width   = 500;
			},
		},
		
		units =
		{
			[nUI_HUDUNIT_NOBARS_PLAYER] =
			{
				options = 
				{
					skinName  = nUI_HUDSKIN_NOBARS_PLAYER,
					enabled   = true,
					
					strata    = nil,
					level     = nil,
					
					unit_id   = "player",
					party_id  = nil,
					raid_id	  = nil,
					
					scale     = 1,
					clickable = false,
				},
			},
			[nUI_HUDUNIT_NOBARS_TARGET] =
			{
				options = 
				{
					skinName  = nUI_HUDSKIN_NOBARS_TARGET,
					enabled   = true,
					
					strata    = nil,
					level     = nil,
					
					unit_id   = "target",
					party_id  = nil,
					raid_id	  = nil,
					
					scale     = 1,
					clickable = false,
				},
			},
		},
	},
};
