﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

    nUI is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with nUI.  If not, see <http://www.gnu.org/licenses/>.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_DefaultConfig then nUI_DefaultConfig = {}; end
if not nUI_MicroMenuOptions then nUI_MicroMenuOptions = {}; end

local CreateFrame = CreateFrame;

-------------------------------------------------------------------------------
-- basic layout

nUI_DefaultConfig.MicroMenu =
{
	anchor =
	{
		anchor_pt   = "BOTTOM",
		relative_to = "nUI_TopBars",
		relative_pt = "BOTTOM",
		xOfs        = 5,
		yOfs        = 25,
	},
	
	options =
	{
		enabled  = "yes",
		strata   = "BACKGROUND",
		level    = 3,
		scale    = 1,
		btn_size = 40,
		btn_gap  = -3,
		
		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBg", 
				edgeFile = "Interface\\AddOns\\nUI\\Art\\nUI_BevelboxBorder", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 12, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0, g = 0, b = 0, a = 0.35 },
			},
		},
	},
};

-------------------------------------------------------------------------------
-- create the MicroMenu bar frame

local frame      = CreateFrame( "Frame", "nUI_MicroMenu", nUI_TopBars.Anchor );

frame.Buttons    = {};
frame.Buttons[1] = _G["CharacterMicroButton"];
frame.Buttons[2] = _G["SpellbookMicroButton"];
frame.Buttons[3] = _G["TalentMicroButton"];
frame.Buttons[4] = _G["QuestLogMicroButton"];
frame.Buttons[5] = _G["SocialsMicroButton"];
frame.Buttons[6] = _G["LFGMicroButton"];
frame.Buttons[7] = _G["MainMenuMicroButton"];
frame.Buttons[8] = _G["HelpMicroButton"];

for i in pairs( nUI_MicroMenu.Buttons ) do
	
	button = frame.Buttons[i];
	
	button:SetParent( frame );

	button.nUI_CachedClearAllPoints = button.ClearAllPoints;
	button.nUI_CachedSetAllPoints   = button.SetAllPoints;
	button.nUI_CachedSetPoint       = button.SetPoint;

	button.ClearAllPoints = function() end;
	button.SetAllPoints   = function() end;
	button.SetPoint       = function() end;
	
end

nUI_MicroMenu = frame;

-------------------------------------------------------------------------------
-- set the size of the bar and its elements

nUI_MicroMenu.applyScale = function( scale )
	
	local options  = frame.options;
	local anchor   = scale and frame.anchor or nil;	
	local scale    = scale or frame.scale or 1;
	local btn_size = options.btn_size * scale * nUI.scale;
	local btn_gap  = options.btn_gap * scale * nUI.scale;
	
	frame.scale = scale;

	if frame.btn_size ~= btn_size 
	or frame.btn_gap  ~= btn_gap
	then
			
		local btn_scale = btn_size / 35;
		local last_button;
		
		for i in pairs( frame.Buttons ) do
			
			local button = frame.Buttons[i];
			
			if not first_button then first_button = button; end
			
			button:SetScale( btn_scale  );
			
			button:nUI_CachedClearAllPoints();
			
			if i == 1 then button:nUI_CachedSetPoint( "BOTTOMLEFT", frame, "BOTTOMLEFT", 3 * nUI.scale, 3 * nUI.scale );
			else button:nUI_CachedSetPoint( "LEFT", last_button, "RIGHT", btn_gap, 0 );
			end
	
			last_button = button;
		end		

		frame:SetHeight( btn_size + 6 * nUI.scale );
		frame:SetWidth( btn_size * #frame.Buttons * 0.8 + 6 * nUI.scale );

	end
end

-------------------------------------------------------------------------------
-- set the location of the bar

nUI_MicroMenu.applyAnchor = function( anchor )
	
	local anchor = anchor or frame.anchor or {};
	local xOfs   = (anchor.xOfs or 0) * nUI.scale;
	local yOfs   = (anchor.yOfs or 0) * nUI.scale;
	
	frame.anchor = anchor;
	
	if frame.anchor_pt   ~= anchor.anchor_pt
	or frame.relative_to ~= anchor.relative_to
	or frame.relative_pt ~= anchor.relative_pt
	or frame.xOfs        ~= xOfs
	or frame.yOfs        ~= yOfs
	then
	
		frame.anchor_pt   = anchor.anchor_pt;
		frame.relative_to = anchor.relative_to;
		frame.realtive_pt = anchor.relative_pt;
		frame.xOfs        = xOfs;
		frame.yOfs        = yOfs;
		
		frame:SetPoint( anchor.anchor_pt, anchor.relative_to, anchor.relative_pt, xOfs, yOfs );
		
	end	
end

-------------------------------------------------------------------------------
-- set the bar options

nUI_MicroMenu.applyOptions = function( options )
	
	frame.options = options;
	
	nUI_MicroMenu:SetFrameStrata( options.strata or nUI_TopBars:GetFrameStrata() );
	nUI_MicroMenu:SetFrameLevel( options.layer or nUI_TopBars:GetFrameLevel()+2 );		

	if options.enabled ~= "no" then
		frame:Show();
	else
		frame:Hide();
	end
	
	if options.background then
		
		local backdrop_color = options.background.color.backdrop;
		local border_color   = options.background.color.border;
		
		frame:SetBackdrop( options.background.backdrop );
		frame:SetBackdropColor( backdrop_color.r, backdrop_color.g, backdrop_color.b, backdrop_color.a );
		frame:SetBackdropBorderColor( border_color.r, border_color.g, border_color.b, border_color.a );		
			
		for i in pairs( frame.Buttons ) do
			
			local button = frame.Buttons[i];
			
			button:SetFrameStrata( frame:GetFrameStrata() );
			button:SetFrameLevel( frame:GetFrameLevel()+1 );
			button:SetScale( options.btn_size / 36 );
		
		end
		
	else
		
		frame:SetBackdrop( nil );
		
	end
	
	frame.applyScale( options.scale or frame.scale or 1 );
	
end

-------------------------------------------------------------------------------
-- bar event management

local function onMicroMenuEvent()

	if event == "VARIABLES_LOADED" then
		
		nUI:setScale();
		nUI_MicroMenu:configBar();
	
	else
			
		if frame.fCache then nUI_Movers:lockFrame( frame, false ); end
		
		frame.applyOptions( nUI_MicroMenuOptions.options );
		frame.applyAnchor( nUI_MicroMenuOptions.anchor );
		
		nUI_Movers:lockFrame( frame, true, nUI_L["Micro-Menu"] );
		
	end
end

frame:SetScript( "OnEvent", onMicroMenuEvent );
frame:RegisterEvent( "VARIABLES_LOADED" );
frame:RegisterEvent( "PLAYER_LOGIN" );

-------------------------------------------------------------------------------

function nUI_MicroMenu:configBar( use_default )
	
	local default = nUI_DefaultConfig.MicroMenu;
	local config  = nUI_MicroMenuOptions or {};
	
	if not config.anchor then config.anchor = {}; end
	if not config.options then config.options = {}; end
	
	if use_default then
		
		config.anchor.anchor_pt   = default.anchor.anchor_pt;
		config.anchor.relative_to = default.anchor.relative_to;
		config.anchor.relative_pt = default.anchor.relative_pt;
		config.anchor.xOfs        = default.anchor.xOfs;
		config.anchor.yOfs        = default.anchor.yOfs;
		
		config.options.enabled  = default.options.enabled;
		config.options.strata   = default.options.strata;
		config.options.level    = default.options.level;
		config.options.scale    = default.options.scale;
		config.options.btn_size = default.options.btn_size;
		config.options.btn_gap  = default.options.btn_gap;

		if default.options.background then
			
			if not config.options.background then config.options.background = {}; end
			if not config.options.background.backdrop then config.options.background.backdrop = {}; end
			if not config.options.background.backdrop.insets then config.options.background.backdrop.insets = {}; end
			if not config.options.background.color then config.options.background.color = {}; end
			if not config.options.background.color.border then config.options.background.color.border = {}; end
			if not config.options.background.color.backdrop then config.options.background.color.backdrop = {}; end
			
			config.options.background.backdrop.bgFile   = default.options.background.backdrop.bgFile;
			config.options.background.backdrop.edgeFile = default.options.background.backdrop.edgeFile;
			config.options.background.backdrop.tile     = default.options.background.backdrop.tile;
			config.options.background.backdrop.tileSize = default.options.background.backdrop.tileSize;
			config.options.background.backdrop.edgeSize = default.options.background.backdrop.edgeSize;
			
			config.options.background.backdrop.insets.left   = default.options.background.backdrop.insets.left;
			config.options.background.backdrop.insets.right  = default.options.background.backdrop.insets.right;
			config.options.background.backdrop.insets.top    = default.options.background.backdrop.insets.top;
			config.options.background.backdrop.insets.bottom = default.options.background.backdrop.insets.bottom;
			
			config.options.background.color.border.r = default.options.background.color.border.r;
			config.options.background.color.border.g = default.options.background.color.border.g;
			config.options.background.color.border.b = default.options.background.color.border.b;
			config.options.background.color.border.a = default.options.background.color.border.a;
			
			config.options.background.color.backdrop.r = default.options.background.color.backdrop.r;
			config.options.background.color.backdrop.g = default.options.background.color.backdrop.g;
			config.options.background.color.backdrop.b = default.options.background.color.backdrop.b;
			config.options.background.color.backdrop.a = default.options.background.color.backdrop.a;
			
		else
			
			config.options.background = nil;
			
		end		
	else
		
		config.anchor.anchor_pt   = strupper( default.anchor.anchor_pt or config.anchor.anchor_pt );
		config.anchor.relative_to = default.anchor.relative_to or config.anchor.relative_to;
		config.anchor.relative_pt = strupper( default.anchor.relative_pt or config.anchor.relative_pt );
		config.anchor.xOfs        = tonumber( default.anchor.xOfs or config.anchor.xOfs );
		config.anchor.yOfs        = tonumber( default.anchor.yOfs or config.anchor.yOfs );
		
		config.options.enabled  = strlower( default.options.enabled or config.options.enabled );
		config.options.strata   = strupper( default.options.strata or config.options.strata );
		config.options.level    = tonumber( default.options.level or config.options.level );
		config.options.scale    = tonumber( default.options.scale or config.options.scale );
		config.options.btn_size = tonumber( default.options.btn_size or config.options.btn_size );
		config.options.btn_gap  = tonumber( default.options.btn_gap or config.options.btn_gap );

		if (not nUI_MicroMenuOptions and default.options.background)
		or (nUI_MicroMenuOptions and nUI_MicroMenuOptions.options.background)
		then
			
			if not config.options.background then config.options.background = {}; end
			if not config.options.background.backdrop then config.options.background.backdrop = {}; end
			if not config.options.background.backdrop.insets then config.options.background.backdrop.insets = {}; end
			if not config.options.background.color then config.options.background.color = {}; end
			if not config.options.background.color.border then config.options.background.color.border = {}; end
			if not config.options.background.color.backdrop then config.options.background.color.backdrop = {}; end
			
			config.options.background.backdrop.bgFile   = default.options.background.backdrop.bgFile or config.options.background.backdrop.bgFile;
			config.options.background.backdrop.edgeFile = default.options.background.backdrop.edgeFile or config.options.background.backdrop.edgeFile;
			config.options.background.backdrop.tile     = default.options.background.backdrop.tile or config.options.background.backdrop.tile;
			config.options.background.backdrop.tileSize = tonumber( default.options.background.backdrop.tileSize or config.options.background.backdrop.tileSize );
			config.options.background.backdrop.edgeSize = tonumber( default.options.background.backdrop.edgeSize or config.options.background.backdrop.edgeSize );
			
			config.options.background.backdrop.insets.left   = tonumber( default.options.background.backdrop.insets.left or config.options.background.backdrop.insets.left );
			config.options.background.backdrop.insets.right  = tonumber( default.options.background.backdrop.insets.right or config.options.background.backdrop.insets.right );
			config.options.background.backdrop.insets.top    = tonumber( default.options.background.backdrop.insets.top or config.options.background.backdrop.insets.top );
			config.options.background.backdrop.insets.bottom = tonumber( default.options.background.backdrop.insets.bottom or config.options.background.backdrop.insets.bottom );
			
			config.options.background.color.border.r = tonumber( default.options.background.color.border.r or config.options.background.color.border.r );
			config.options.background.color.border.g = tonumber( default.options.background.color.border.g or config.options.background.color.border.g );
			config.options.background.color.border.b = tonumber( default.options.background.color.border.b or config.options.background.color.border.b );
			config.options.background.color.border.a = tonumber( default.options.background.color.border.a or config.options.background.color.border.a );
			
			config.options.background.color.backdrop.r = tonumber( default.options.background.color.backdrop.r or config.options.background.color.backdrop.r );
			config.options.background.color.backdrop.g = tonumber( default.options.background.color.backdrop.g or config.options.background.color.backdrop.g );
			config.options.background.color.backdrop.b = tonumber( default.options.background.color.backdrop.b or config.options.background.color.backdrop.b );
			config.options.background.color.backdrop.a = tonumber( default.options.background.color.backdrop.a or config.options.background.color.backdrop.a );

		else
			
			config.options.background = nil;
			
		end
	end		
	
	nUI_MicroMenuOptions = config;

	frame.applyOptions( config.options );
	frame.applyAnchor( config.anchor );
end
