﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_Unit then nUI_Unit = {}; end
if not nUI_UnitOptions then nUI_UnitOptions = {}; end
if not nUI_DefaultConfig then nUI_DefaultConfig = {}; end
if not nUI_Profile then nUI_Profile = {}; end;
if not nUI_Options then nUI_Options = {}; end;

-------------------------------------------------------------------------------

if not nUI_Unit.Drivers then 
	nUI_Unit.Drivers = CreateFrame( "Frame", "nUI_UnitDrivers", WorldFrame ); 
end

nUI_Profile.nUI_RaidSort    = {};

local ProfileCounter = nUI_Profile.nUI_RaidSort;

local frame                 = CreateFrame( "Frame", "$parent_RaidSort", nUI_Unit.Drivers );
local RaidSortAssignments   = {};
local RaidSortCallbacks     = {};
local RaidSortUnits         = {};
local SortMethod            = nil;
local doSort                = false;
local sortTimer             = 1 / nUI_DEFAULT_FRAME_RATE;

nUI_Unit.Drivers.RaidSort   = frame;

for i=1,40 do
	RaidSortAssignments[i] = "raid"..i;   
end

nUI_Options.raidSort = nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "group" )];

-------------------------------------------------------------------------------
-- this method processes the current list of raid unit ID assignments, sorts it
-- according to the user's preference and then updates the active raid frames

local function SortRaidFrames()

	local sortTable = {};
	local usedTable = {};
	local newSort   = {};
	
	-- create a list of all of the active raid unit IDs
	
	for i=1,40 do
	
		local unit_id = "raid"..i;
		
		if RaidSortUnits[unit_id] and not UnitIsUnit( unit_id, "player" ) then
			
			local entry =
			{
				id   = i,
				info = RaidSortUnits[unit_id],
			};
			
			table.insert( sortTable, entry );
			
			usedTable[i] = true;
			newSort[i]   = "raid"..i;
			
		end
	end
	
	-- sort the list
	
	if SortMethod then 
	
		for i=1,#sortTable-1 do
			for j=i+1,#sortTable do
				if SortMethod( sortTable[i], sortTable[j] ) then
					local temp = sortTable[i];
					sortTable[i] = sortTable[j];
					sortTable[j] = temp;
				end
			end
		end
	
		-- the first n elements in the table are the ones that exist and were sorted
			
		for i=1,#sortTable do
			newSort[i] = "raid"..sortTable[i].id;
		end
		
		-- the rest of the table are the elements that don't exist yet so we append
		-- them to the table in raid unit ID order so they can be populated in the
		-- event the roster changes while we are in combat
		
		local ndx  = #sortTable+1;
		local last = nil;
		
		for i=1,40 do
			if not usedTable[i] then
				if UnitIsUnit( "raid"..i, "player" ) then
					last = "raid"..i;
				else
					newSort[ndx] = "raid"..i;
					ndx = ndx+1;
				end
			end
		end	
		
		if last then
			newSort[40] = last;
		end
	end
	
	-- now notify any frames that have changed unit IDs as a result of the sort
	
	for i=1,40 do
		if newSort[i] ~= RaidSortAssignments[i] then
			RaidSortAssignments[i] = newSort[i];
			
			for frame in pairs( RaidSortCallbacks ) do
				if RaidSortCallbacks[frame] == i then
					frame.setUnitID( RaidSortAssignments[i] );
				end
			end
		end
	end	
end

-------------------------------------------------------------------------------
-- this method sorts two raid units by their raid group and unit name

local function SortByRaidGroup( left, right )

	-- make sure we have units on both the left and the right
	
	if not left and not right then
		return false;		
	elseif left and not right then
		return false;		
	elseif right and not left then
		return true;		
	end
	
	-- get the unit info and raid info structures for those units
	
	local leftInfo  = left.info;
	local rightInfo = right.info;
	local leftRaid  = leftInfo.raid_info;
	local rightRaid = rightInfo.raid_info;
	
	-- make sure we have raid information for both the left and the right units
	
	if not leftRaid and not rightRaid then
		return false;		
	elseif not leftRaid and rightRaid then
		return true;		
	elseif leftRaid and not rightRaid then
		return false;							
	end
	
	-- make sure we have raid groups for both the left and the right units
	
	if not leftRaid.subGroup and not rightRaid.subGroup then
		return false;
	elseif not leftRaid.subGroup and rightRaid.subGroup then
		return true;
	elseif leftRaid.subGroup and not rightRaid.subGroup then
		return false;
	end
	
	-- compare raid groups
	
	if leftRaid.subGroup > rightRaid.subGroup then
		return true;
	elseif leftRaid.subGroup < rightRaid.subGroup then
		return false;
	end
	
	-- both are in the same raid group, sort by unit name within the group
	
	if not leftInfo.name and not rightInfo.name then
		return false;
	elseif not leftInfo.name and rightInfo.name then
		return true;
	elseif leftInfo.name and not rightInfo.name then
		return false;
	elseif leftInfo.name > rightInfo.name then
		return true;
	end
	
	return false;
end

-------------------------------------------------------------------------------
-- this method sorts two raid units by their raid group and unit name

local function SortByClass( left, right )

	-- make sure we have units on both the left and the right
	
	if not left and not right then
		return false;		
	elseif left and not right then
		return false;		
	elseif right and not left then
		return true;		
	end
	
	-- get the unit info and raid info structures for those units
	
	local leftInfo  = left.info;
	local rightInfo = right.info;

	-- makes sure we have class information for both the left and the right
	
	if not leftInfo.class and not rightInfo.class then
		return false;
	elseif not leftInfo.class and rightInfo.class then
		return true;
	elseif leftInfo.class and not rightInfo.class then
		return false;
	elseif leftInfo.class < rightInfo.class then
		return false;
	elseif leftInfo.class > rightInfo.class then
		return true;
	end
	
	-- both units share the same class, sort by unit name
	
	if not leftInfo.name and not rightInfo.name then
		return false;
	elseif not leftInfo.name and rightInfo.name then
		return true;
	elseif leftInfo.name and not rightInfo.name then
		return false;
	elseif leftInfo.name > rightInfo.name then
		return true;
	end
	
	return false;	
end

-------------------------------------------------------------------------------
-- this method sorts two raid units by their raid group and unit name

local function SortByName( left, right )

	-- make sure we have units on both the left and the right
	
	if not left and not right then
		return false;		
	elseif left and not right then
		return false;		
	elseif right and not left then
		return true;		
	end
	
	-- get the unit info and raid info structures for those units
	
	local leftInfo  = left.info;
	local rightInfo = right.info;

	-- sort by unit name
	
	if not leftInfo.name and not rightInfo.name then
		return false;
	elseif not leftInfo.name and rightInfo.name then
		return true;
	elseif leftInfo.name and not rightInfo.name then
		return false;
	elseif leftInfo.name > rightInfo.name then
		return true;
	end
	
	return false;	
end

-------------------------------------------------------------------------------

local function onRaidSortEvent()

	if event == "ADDON_LOADED" then
	
		if arg1 == "nUI" then
			
			if nUI_Options.raidSort == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "unit" )] then
				SortMethod = nil;
			elseif nUI_Options.raidSort == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "class" )] then
				SortMethod = SortByClass;
			elseif nUI_Options.raidSort == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "name" )] then
				SortMethod = SortByName;
			else
				SortMethod = SortByRaidGroup;
				nUI_Options.raidSort = nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "group" )];
			end
			
			doSort = true;
		end
				
	else
		
		for i=1,40 do
			nUI_Unit:registerRaidGroupCallback( "raid"..i, frame );
		end
		
		-- set up a slash command handler for choosing whether or not nUI will highlight the various dispellable debuff types
		
		local option = nUI_SlashCommands[nUI_SLASHCMD_RAIDSORT];
		
		nUI_SlashCommands:setHandler( option.command,
			
			function( msg, arg1 )

				if arg1 ~= nUI_Options.raidSort then
								
					if arg1 == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "unit" )] then
						SortMethod = nil;
						doSort = true;
						nUI_Options.raidSort = arg1;
						DEFAULT_CHAT_FRAME:AddMessage( (option.message):format( arg1 ), 1, 0.83, 0 );
					elseif arg1 == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "group" )] then
						SortMethod = SortByRaidGroup;
						doSort = true;
						nUI_Options.raidSort = arg1;
						DEFAULT_CHAT_FRAME:AddMessage( (option.message):format( arg1 ), 1, 0.83, 0 );
					elseif arg1 == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "class" )] then
						SortMethod = SortByClass;
						doSort = true;
						nUI_Options.raidSort = arg1;
						DEFAULT_CHAT_FRAME:AddMessage( (option.message):format( arg1 ), 1, 0.83, 0 );
					elseif arg1 == nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "name" )] then
						SortMethod = SortByName;
						doSort = true;
						nUI_Options.raidSort = arg1;
						DEFAULT_CHAT_FRAME:AddMessage( (option.message):format( arg1 ), 1, 0.83, 0 );
					else
						DEFAULT_CHAT_FRAME:AddMessage( 
							nUI_L["nUI: [ %s ] is not a valid raid sorting option... please choose either <unit>, <group> or <class>"]:format( 
								(arg1 or "<nil>"),
								nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "unit" )],
								nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "group" )],
								nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_RAIDSORT, "class" )]
							), 1, 0.83, 0
						);
					end
				end
			end
		);		
		
		frame:UnregisterEvent( "PLAYER_ENTERING_WORLD" );
	end	
end

frame:SetScript( "OnEvent", onRaidSortEvent );
frame:RegisterEvent( "ADDON_LOADED" );
frame:RegisterEvent( "PLAYER_ENTERING_WORLD" );

-------------------------------------------------------------------------------

local function onRaidSortUpdate( who, elapsed )

	sortTimer = sortTimer - elapsed;
	
	if sortTimer <= 0 then
	
		sortTimer = nUI_Unit.frame_rate;
		
		if not InCombatLockdown() and doSort then 
			doSort = false;
			SortRaidFrames(); 
		end		
	end	
end

frame:SetScript( "OnUpdate", onRaidSortUpate );

-------------------------------------------------------------------------------
-- this method is triggered anytime a change in the raid groups occurs

frame.newUnitInfo = function( unit_id, unit_info )

	doSort = true;
	
end

-------------------------------------------------------------------------------
-- add and remove callbacks from the list of listeners who want to know
-- when the underlying GUID / unit information of a unit changes
--
-- calling this method will return the current unit_info structure
-- for this unit id if it exists or nil if the unit does not exist
--
-- Note: this is NOT recommended for unit existence! Use RegisterUnitWatch()
--       or RegisterUnitWatchState() for that purpose (allows for a taint safe
--		 way to know when a unit does and does not exist including the ability
--		 to show and hide frames, move frames, etc.)

function nUI_Unit:registerRaidSortFrame( frame, raid_id )
	
--	nUI_ProfileStart( ProfileCounter, "registerRaidSort" );

	if raid_id then
		
		if raid_id < 1 or raid_id > 40 then
			DEFAULT_CHAT_FRAME:AddMessage( (nUI_L["nUI_Unit: [%d] is not a valid raid ID... the raid ID must be between 1 and 40"].." (%s)"):format( raid_id or 0, frame:GetName() or "<unknown frame>" ), 1, 0.83, 0 );
		elseif not frame or not frame.setUnitID then
			DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI_Unit: [%s] is not a valid raid sorting target frame, it does not have a setUnitID() method"]:format( frame and frame:GetName() or "<unknown frame>" ), 1, 0.83, 0 );
		else
			RaidSortCallbacks[frame] = raid_id;
			frame.setUnitID( RaidSortAssignments[raid_id] );
		end

	end
		
--	nUI_ProfileStop();
	
	return unit_info;
	
end

function nUI_Unit:unregisterRaidSortFrame( frame )
	
--	nUI_ProfileStart( ProfileCounter, "unregisterRaidSort" );
	
	if RaidSortCallbacks[frame] then
		RaidSortCallbacks[frame] = nil;
	end
	
--	nUI_ProfileStop();
	
end
