﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI then nUI = {}; end
if not nUI_Options then nUI_Options = {}; end;

-------------------------------------------------------------------------------
-- v2.00.06 Alpha added new slash commands, this patch sets their defaults

local function patch_v2_00_06()
	
	nUI_Options.version        = "2.00.06 (Alpha)";
	nUI_Options.hud_scale      = 1;
	nUI_Options.hud_healthrace = true;
	nUI_Options.hud_threatbar  = true;
	nUI_Options.bagbar         = true;
	
end

-------------------------------------------------------------------------------
-- v4.00.01 Alpha added change the clock slash command, this patch sets the
-- new default to display the current server time

local function patch_v4_00_01()
	
	nUI_Options.version = "4.00.01 (Alpha)";
	nUI_Options.clock   = nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CLOCK, "server" )];
	nUI_Options.minimap = true;

end

-------------------------------------------------------------------------------
-- v4.01.00 Beta added a onebag slash command and fixed a bug in the German
-- localization file for the '/nui console {on|off|mouseover}' command

local function patch_v4_01_00()
	
	nUI_Options.version = "4.01.00 (Beta)";
	nUI_Options.onebag  = false;

	if nUI_Locale == "deDE" then
		
		if nUI_Options.console == "AN"
		or nUI_Options.console == "an"
		or nUI_Options.console == "on"
		then 
		
			nUI_Options.console = nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "on" )];
		
		elseif nUI_Options.console == "AUS"
		or nUI_Options.console == "aus"
		or nUI_Options.console == "off"
		then 
		
			nUI_Options.console = nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "off" )];
			
		else
			
			nUI_Options.console = nUI_L[nUI_SLASHCMD_OPTIONS( nUI_SLASHCMD_CONSOLE, "mouseover" )];
		
		end
				
	end
	
end

-------------------------------------------------------------------------------
-- v4.07.00 Beta changed how the bagbar slash command works from an on/off
-- toggle to a three state including mouseover

local function patch_v4_07_00()
	
	nUI_Options.version = "4.07.00 (Beta)";

	if not nUI_Options.bagbar then nUI_Options.bagbar = "off";
	else nUI_Options.bagbar = "on";
	end
	
end

-------------------------------------------------------------------------------
-- v4.12.00 Beta added a new slash command (defaulted on) which toggles auto
-- switching between unit panels when joining/leaving a group. In addition,
-- for some reason a lot of people never got the "minimap" toggle set properly
-- to this update forces it back on for everyone one time.

local function patch_v4_12_00()
	
	nUI_Options.version = "4.12.00 (Beta)";

	nUI_Options.auto_group = true;
	
	if not IsAddOnLoaded( "nUI_InfoPanel_Minimap" ) then
		nUI_Options.minimap = true;
	end	
end

-------------------------------------------------------------------------------
-- v4.15.00 Beta added a new slash command (defaulted on) which toggles display
-- of player and cursor map coordinates on and off in the world map in addition
-- to a set of options for a cooldown bar, alerts and sounds.

local function patch_v4_15_00()
	
	nUI_Options.version = "4.15.00 (Beta)";

	nUI_Options.hud_cooldown = true;
	nUI_Options.hud_cdalert  = true;
	nUI_Options.hud_cdsound  = true;
	nUI_Options.map_coords   = true;

end

-------------------------------------------------------------------------------
-- v4.17.00 Beta separated scaling into horizontal and vertical components

local function patch_v4_17_00()
	
	nUI_Options.version = "4.17.00 (Beta)";

	nUI_Options.hScale = nUI_Options.scale;
	nUI_Options.vScale = nUI_Options.scale;
	nUI_Options.scale  = nil;

end

-------------------------------------------------------------------------------
-- v4.20.00 Beta appears some people are having some legacy scaling issues, so
-- this patch makes sure they don't have old scaling data breaking the new
-- layout engine

local function patch_v4_20_00()
	
	nUI_Options.version = "4.20.00 (Beta)";

	nUI_Options.hScale = nil;
	nUI_Options.vScale = nil;
	nUI_Options.scale  = nil;

end

-------------------------------------------------------------------------------
-- v5.00.02 Alpha added the "showhits" option which is on by default

local function patch_v5_00_02()
	
	nUI_Options.version = "5.00.02 (Alpha)";

	nUI_Options.show_hits = true;

end

-------------------------------------------------------------------------------
-- v5.00.03 Alpha added the "feedback {poison|curse|magic|disease}" option 
-- which is on by default for all four feedback modes

local function patch_v5_00_03()
	
	nUI_Options.version = "5.00.03 (Alpha)";

	nUI_Options.feedback_magic   = true;
	nUI_Options.feedback_disease = true;
	nUI_Options.feedback_curse   = true;
	nUI_Options.feedback_poison  = true;

end

-------------------------------------------------------------------------------
-- v5.03.08 added a slew of new slash commands for the action bars.

local function patch_v5_03_08()
	
	nUI_Options.version        = nUI_SetVersion( "5.03.08" );	
	nUI_Options.barCooldowns   = true;
	nUI_Options.barDurations   = true;
	nUI_Options.barMacroNames  = true;
	nUI_Options.barStackCounts = true;
	nUI_Options.barKeyBindings = true;

end

-------------------------------------------------------------------------------
-- v5.03.12 added a new slash command for the action bars.

local function patch_v5_03_12()
	
	nUI_Options.version        = nUI_SetVersion( "5.03.12" );	
	nUI_Options.barDimming     = true;

end

-------------------------------------------------------------------------------
-- apply all required patches to the user's saved variables file.

function nUI:patchConfig()

	if not nUI_Options.version then
		nUI_Options.minimap = true;
	end

	if nUI_Options.version ~= nUI_Version
	or nUI_Options.package ~= nUI_Package
	then 
		nUI_Options.show_splash = true;
		nUI_Options.package = nUI_Package;
	end
		
	while nUI_Options.version and nUI_Options.version < nUI_Version do
		
		if     nUI_Options.version < "2.00.06 (Alpha)" then patch_v2_00_06();	
		elseif nUI_Options.version < "4.00.01 (Alpha)" then patch_v4_00_01();
		elseif nUI_Options.version < "4.01.00 (Beta)"  then patch_v4_01_00();
		elseif nUI_Options.version < "4.07.00 (Beta)"  then patch_v4_07_00();
		elseif nUI_Options.version < "4.12.00 (Beta)"  then patch_v4_12_00();
		elseif nUI_Options.version < "4.15.00 (Beta)"  then patch_v4_15_00();
		elseif nUI_Options.version < "4.17.00 (Beta)"  then patch_v4_17_00();
		elseif nUI_Options.version < "4.20.00 (Beta)"  then patch_v4_20_00();
		elseif nUI_Options.version < "5.00.02 (Alpha)" then patch_v5_00_02();
		elseif nUI_Options.version < "5.00.03 (Alpha)" then patch_v5_00_03();
		elseif nUI_Options.version < "5.03.08"         then patch_v5_03_08();
		elseif nUI_Options.version < "5.03.12"         then patch_v5_03_12();
		else   break;
		end
		
	end	
	
	nUI_Options.version = nUI_Version;
	
end
