﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_Data then nUI_Data = {}; end
if not nUI_Data.MoverAnchors then nUI_Data.MoverAnchors = {}; end
if not nUI_Profile then nUI_Profile = {}; end;

nUI_Profile.nUI_Movers = {};

local ProfileCounter = nUI_Profile.nUI_Movers;
local MoverAnchors   = nUI_Data.MoverAnchors;

-------------------------------------------------------------------------------
-- frame mover event management

nUI_Movers           = CreateFrame( "Frame", "nUI_MoverEvents", WorldFrame );
nUI_Movers.FrameList = {};
nUI_MoverFrames      = {};

local function onMoversEvent()

--	nUI_ProfileStart( ProfileCounter, "onMoversEvent", event );
	
	if event == "PLAYER_LOGOUT" then
		
		for mover_name in pairs( nUI_Data.MoverAnchors ) do
			
			if not nUI_Data.MoverAnchors[mover_name].user_placed then
				nUI_Data.MoverAnchors[mover_name] = nil;
			end
		end
		
	elseif event == "ADDON_LOADED" and arg1 == "nUI" then

		if not nUI_Data.MoverAnchors then 
			nUI_Data.MoverAnchors = {}; 
		end		

		MoverAnchors = nUI_Data.MoverAnchors;

		VehicleSeatIndicator:SetScale( nUI_Options.mountScale or 1 );
					
	elseif event == "PLAYER_ENTERING_WORLD" then

		nUI_Movers:UnregisterEvent( "PLAYER_ENTERING_WORLD" );			
		
		nUI:setScale();
		
		-- initialize the slash command handler for selecting the mover state
		
		local option = nUI_SlashCommands[nUI_SLASHCMD_MOVERS];
		
		nUI_SlashCommands:setHandler( option.command,
		
			function()

				if not nUI_Movers.enabled then nUI_Movers.enabled = true;
				else nUI_Movers.enabled = false;
				end
			
				DEFAULT_CHAT_FRAME:AddMessage( (option.message):format(nUI_Movers.enabled and nUI_L["|cFF00FF00ENABLED|r"] or nUI_L["|cFFFF0000DISABLED|r"]), 1, 0.83, 0 );
				
				for i in pairs( nUI_Movers.FrameList ) do
					
					nUI_Movers:enableDrag( nUI_Movers.FrameList[i], nUI_Movers.enabled );
					
				end
			end
		);
		
		-- initialize the slash command handler for sizing the vehicle seat indicator
		
		local option = nUI_SlashCommands[nUI_SLASHCMD_MOUNTSCALE];
		
		nUI_SlashCommands:setHandler( option.command,
			
			function( msg, arg1 )
				
				local scale = tonumber( arg1 or "1" );
				
				if not scale or scale < 0.5 or scale > 1.5 then

					DEFAULT_CHAT_FRAME:AddMessage( nUI_L["nUI: [ %s ] is not a valid special mount indicator display scale. The scale must be a number between 0.5 and 1.5"]:format( arg1 or "<nil>" ), 1, 0.83, 0 );

				elseif nUI_Options.mountScale ~= scale then

					nUI_Options.mountScale = scale;
					VehicleSeatIndicator:SetScale( scale );
					
					DEFAULT_CHAT_FRAME:AddMessage( (option.message):format( scale ), 1, 0.83, 0 );

				end
			end
		);	
				
		-- create a mover for the capture bars
		
		local frame = WorldStateCaptureBar1;
		local mover = nUI_Data.MoverAnchors["nUI_CaptureBarMover"];
		
		nUI_CaptureBarMover = CreateFrame( "Frame", "nUI_CaptureBarMover", UIParent );
		nUI_CaptureBarMover:SetWidth( 173 );
		nUI_CaptureBarMover:SetHeight( 26 );
		
		if not mover then
			nUI_CaptureBarMover:SetPoint( "TOPRIGHT", UIParent, "TOPRIGHT", -10, -20 );
		else
			for i in pairs( mover.Point ) do
				local point = mover.Point[i];
				nUI_CaptureBarMover:SetPoint( point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs );
			end
		end
		
		nUI_CaptureBarMover:SetScript( "OnEvent", 
			function()	

--				nUI_ProfileStart( ProfileCounter, "CaptureBarMover.OnEvent", event );
	
				if event == "UPDATE_WORLD_STATES" then
					local last_frame;
					
					for i=1,NUM_EXTENDED_UI_FRAMES do
						local frame = _G["WorldStateCaptureBar"..i];				
						
						if not nUI_MoverFrames[frame] then nUI_Movers:lockFrame( frame, true, nil ); end					
						
						nUI_MoverFrames[frame].ClearAllPoints( frame );
						
						if i == 1 then
							nUI_MoverFrames[frame].SetPoint( frame, "CENTER", nUI_CaptureBarMover, "CENTER", 0, 0 );
						else
							nUI_MoverFrames[frame].SetPoint( frame, "TOP", last_frame, "BOTTOM", 0, 0 );
						end
						
						last_frame = frame;
					end
				end
				
--				nUI_ProfileStop();
				
			end
		);
	
		nUI_Movers:lockFrame( nUI_CaptureBarMover, true, nUI_L["Capture Bar"] );
		nUI_CaptureBarMover:RegisterEvent( "UPDATE_WORLD_STATES" );	

		if WatchFrame then nUI_Movers:lockFrame( WatchFrame, true, OBJECTIVES_TRACKER_LABEL ); end
		
		-- Bliz frames we want the player to be able to move any time
	
		LoadAddOn( "Blizzard_AchievementUI" );
		LoadAddOn( "Blizzard_AuctionUI" );
		LoadAddOn( "Blizzard_Calendar" );
		LoadAddOn( "Blizzard_CraftUI" );
		LoadAddOn( "Blizzard_GuildBankUI" );
		LoadAddOn( "Blizzard_InspectUI" );
		LoadAddOn( "Blizzard_TalentUI" );
		LoadAddOn( "Blizzard_TradeSkillUI" );
	
		if AchievementFrame then nUI_Movers:movableFrame( AchievementFrame ); end
		if AuctionFrame then nUI_Movers:movableFrame( AuctionFrame ); end
		if CalendarFrame then nUI_Movers:movableFrame( CalendarFrame ); end
		if CraftFrame then nUI_Movers:movableFrame( CraftFrame ); end
		if GuildBankFrame then nUI_Movers:movableFrame( GuildBankFrame ); end
		if InspectFrame then nUI_Movers:movableFrame( InspectFrame ); end
		if PlayerTalentFrame then nUI_Movers:movableFrame( PlayerTalentFrame ); end
		if TradeSkillFrame then nUI_Movers:movableFrame( TradeSkillFrame ); end
		
		nUI_Movers:movableFrame( ArenaFrame );
		nUI_Movers:movableFrame( BattlefieldFrame );
		nUI_Movers:movableFrame( ChannelFrame, FriendsFrame );
		nUI_Movers:movableFrame( ChatConfigFrame );
		nUI_Movers:movableFrame( FriendsFrame );
		nUI_Movers:movableFrame( GossipFrame );
		nUI_Movers:movableFrame( GuildRegistrarFrame );
		nUI_Movers:movableFrame( HonorFrame, CharacterFrame );
		nUI_Movers:movableFrame( LFGParentFrame ); -----------
		nUI_Movers:movableFrame( LFDParentFrame ); -----------
		nUI_Movers:movableFrame( LFRParentFrame ); -----------
		nUI_Movers:movableFrame( MailFrame );
		nUI_Movers:movableFrame( WorldMapFrame );
		nUI_Movers:movableFrame( MerchantFrame );
		nUI_Movers:movableFrame( PaperDollFrame, CharacterFrame );
		nUI_Movers:movableFrame( PetitionFrame );
		nUI_Movers:movableFrame( PetStableFrame );
		nUI_Movers:movableFrame( PVPFrame );
		nUI_Movers:movableFrame( QuestFrame );
		nUI_Movers:movableFrame( QuestLogFrame );
		nUI_Movers:movableFrame( RaidFrame, FriendsFrame );
		nUI_Movers:movableFrame( ReputationFrame, CharacterFrame );
		nUI_Movers:movableFrame( SendMailFrame, MailFrame );
		nUI_Movers:movableFrame( SkillFrame, CharacterFrame );
		nUI_Movers:movableFrame( SpellBookFrame );
		nUI_Movers:movableFrame( TaxiFrame );
		nUI_Movers:movableFrame( TradeFrame );
	
		-- standard Bliz frames we want to  move
		
		MirrorTimer1:ClearAllPoints();
		MirrorTimer1:SetPoint( "TOP", nUI_TopBars, "BOTTOM", 0, -5 );
		nUI_Movers:lockFrame( MirrorTimer1, true, nUI_L["Timer Bar"] );
				
		GroupLootFrame1:ClearAllPoints();
		GroupLootFrame1:SetPoint( "TOP", MirrorTimer1, "BOTTOM", 0, -5 );
		nUI_Movers:lockFrame( GroupLootFrame1, true, nUI_L["Group Loot Frame"].." 1" );
		
		GroupLootFrame2:ClearAllPoints();
		GroupLootFrame2:SetPoint( "TOP", GroupLootFrame1, "BOTTOM", 0, -5 );
		nUI_Movers:lockFrame( GroupLootFrame2, true, nUI_L["Group Loot Frame"].." 2" );
		
		GroupLootFrame3:ClearAllPoints();
		GroupLootFrame3:SetPoint( "TOP", GroupLootFrame2, "BOTTOM", 0, -5 );
		nUI_Movers:lockFrame( GroupLootFrame3, true, nUI_L["Group Loot Frame"].." 3" );
		
		GroupLootFrame4:ClearAllPoints();
		GroupLootFrame4:SetPoint( "TOP", GroupLootFrame3, "BOTTOM", 0, -5 );
		nUI_Movers:lockFrame( GroupLootFrame4, true, nUI_L["Group Loot Frame"].." 4" );
		
		if MultiCastActionBarFrame then
			MultiCastActionBarFrame:SetParent( nUI_Options.noTotemBar and MainMenuBar or UIParent );
			MultiCastActionBarFrame:ClearAllPoints();
			MultiCastActionBarFrame:SetPoint( "BOTTOM", nUI_Dashboard, "TOP", 0, 10 );
			nUI_Movers:lockFrame( MultiCastActionBarFrame, true, "Shaman Totem Bar" );
		end

		if DungeonCompletionAlertFrame1 then
			DungeonCompletionAlertFrame1:ClearAllPoints();
			DungeonCompletionAlertFrame1:SetPoint( "BOTTOM", MultiCastActionBarFrame or nUI_SpecialBars, "TOP", 0, 5 );
			nUI_Movers:lockFrame( DungeonCompletionAlertFrame1, true, nUI_L["Dungeon Completion Alert Frame"] );			
		end

		if AlertFrame then
			AlertFrame:ClearAllPoints();
			AlertFrame:SetPoint( "BOTTOM", DungeonCompletionAlertFrame1 or MultiCastActionBarFrame or nUI_SpecialBars, "TOP", 0, 5 );
			nUI_Movers:lockFrame( AlertFrame, true, nUI_L["Achievement Alert Frame"] );			
--[[			
			hooksecurefunc( "AchievementAlertFrame_GetAlertFrame", 				
				function()		
					if AchievementAlertFrame1 then
						print( "moving achievements" );
						AchievementAlertFrame1:ClearAllPoints();
						AchievementAlertFrame1:SetPoint( "BOTTOM", DungeonCompletionAlertFrame1 or MultiCastActionBarFrame or nUI_SpecialBars, "TOP", 0, 5 );
					end
				end
			);
]]--			
		end
				
		if not WatchFrame then
		
			if QuestWatchFrame then
				QuestWatchFrame:ClearAllPoints();
				QuestWatchFrame:SetPoint( "TOPLEFT", nUI_TopBars, "BOTTOMLEFT", 50, 120 * nUI.vScale );	
				nUI_Movers:lockFrame( QuestWatchFrame, true, nUI_L["Watched Quests"] );
			end
				
			if QuestTimerFrame then
				QuestTimerFrame:ClearAllPoints();
				QuestTimerFrame:SetPoint( "TOP", nUI_TopBars, "BOTTOM", 0, -5 );
				nUI_Movers:lockFrame( QuestTimerFrame, true, nUI_L["Quest Timer"] );
			end
			
		end
			
		DurabilityFrame:ClearAllPoints();
		DurabilityFrame:SetPoint( "BOTTOMRIGHT", UIParent, "RIGHT", -5, 0 );	
		nUI_Movers:lockFrame( DurabilityFrame, true, nUI_L["Equipment Durability"] );
	
		WorldStateAlwaysUpFrame:ClearAllPoints();
		WorldStateAlwaysUpFrame:SetPoint( "TOPLEFT", nUI_CaptureBarMover, "BOTTOMLEFT", 0, -10 );
		nUI_Movers:lockFrame( WorldStateAlwaysUpFrame, true, nUI_L["PvP Objectives"] );
	
		VehicleSeatIndicator:ClearAllPoints();
		VehicleSeatIndicator:SetPoint( "BOTTOMRIGHT", DurabilityFrame, "TOPRIGHT", 0, 5 );
		nUI_Movers:lockFrame( VehicleSeatIndicator, true, nUI_L["Vehicle Seat Indicator"] );
		
		VoiceChatTalkers:ClearAllPoints();
		VoiceChatTalkers:SetPoint( "BOTTOMRIGHT", VehicleSeatIndicator, "TOPRIGHT", 0, 5 );
		nUI_Movers:lockFrame( VoiceChatTalkers, true, nUI_L["Voice Chat Talkers"] );
		
		LoadAddOn( "QuestHelper" );
		
		if QuestWatchFrame and AchievementWatchFrame then
			if IsAddOnLoaded( "QuestHelper" ) then
				AchievementWatchFrame:ClearAllPoints();
				AchievementWatchFrame:SetPoint( "TOPLEFT", QuestHelperQuestWatchFrame, "BOTTOMLEFT", 0, -10 );
				nUI_Movers:lockFrame( AchievementWatchFrame, true, nUI_L["Watched Achievments"] );
			else
				AchievementWatchFrame:ClearAllPoints();
				AchievementWatchFrame:SetPoint( "TOPLEFT", QuestWatchFrame, "BOTTOMLEFT", 0, -10 );
				nUI_Movers:lockFrame( AchievementWatchFrame, true, nUI_L["Watched Achievments"] );
			end
		end
	end
	
--	nUI_ProfileStop();
	
end

nUI_Movers:SetScript( "OnEvent", onMoversEvent );
nUI_Movers:RegisterEvent( "PLAYER_ENTERING_WORLD" );
nUI_Movers:RegisterEvent( "ADDON_LOADED" );
nUI_Movers:RegisterEvent( "PLAYER_LOGOUT" );

-------------------------------------------------------------------------------

function nUI_Movers:movableFrame( frame, parent )
	
--	nUI_ProfileStart( ProfileCounter, "movableFrame" );
	
	if frame then
		frame:EnableMouse( true );
		frame:SetMovable( true );
		frame:RegisterForDrag( "LeftButton" );
		
		frame:SetScript( "OnEnter", 
			function()
				if not InCombatLockdown() then
					GameTooltip:SetOwner( frame );
					GameTooltip:SetText( nUI_L["Left-click and drag to move this frame"] );
					GameTooltip:Show();
				end
			end
		);
		
		frame:SetScript( "OnLeave",
			function()
				GameTooltip:Hide();
			end
		);
		
		frame:SetScript( "OnDragStart",
			function()			
				if not InCombatLockdown() then
					frame.is_moving = true;
					if parent then parent:StartMoving() 
					else frame:StartMoving();
					end
				end
			end
		);
		
		frame:SetScript( "OnDragStop",
			function()
				if frame.is_moving then
					frame.is_moving = false;
					if parent then parent:StopMovingOrSizing();
					else frame:StopMovingOrSizing();
					end
				end
			end
		);
	end
					
--	nUI_ProfileStop();
	
end

-------------------------------------------------------------------------------

function nUI_Movers:lockFrame( frame, mode, overlay )

--	nUI_ProfileStart( ProfileCounter, "lockFrame" );
	
	local new_mover = false;
	
	-- if we don't already have a frame cache for this frame, initialize it
	
	if not nUI_MoverFrames[frame] then	

		new_mover                    = true;		
		nUI_MoverFrames[frame]                = {};		
		nUI_MoverFrames[frame].SetAllPoints   = frame.SetAllPoints;
		nUI_MoverFrames[frame].SetPoint       = frame.SetPoint;
		nUI_MoverFrames[frame].ClearAllPoints = frame.ClearAllPoints;

	end
	
	-- lock the frame to prevent anyone else from moving it
	
	if not nUI_MoverFrames[frame].locked and mode then
		
		nUI_MoverFrames[frame].locked  = true;
		frame.SetAllPoints    = function() end;
		frame.SetPoint        = function() end;
		frame.ClearAllPoints  = function() end;
	
	-- make the frame moveable again
	
	elseif nUI_MoverFrames[frame].locked and not mode then

		nUI_MoverFrames[frame].locked  = false;
		frame.SetAllPoints    = nUI_MoverFrames[frame].SetAllPoints;
		frame.SetPoint        = nUI_MoverFrames[frame].SetPoint;
		frame.ClearAllPoints  = nUI_MoverFrames[frame].ClearAllPoints;
		
	end

	-- if this is a new mover, set up the overlay for it
	
	if new_mover then
		
		if not nUI_Data then
			nUI_Data = {};
		end
		
		if not nUI_Data.MoverAnchors then
			nUI_Data.MoverAnchors = {};
		end
		
		local frame_name = frame:GetName();
		local mover      = nUI_Data.MoverAnchors[frame_name];		

		-- if this frame has a visible overlay, then add it to the list of 
		-- movers we enable/disable on the "/nui movers" slash command

		if overlay then
			if not nUI_Movers.FrameList[frame_name] then 
				nUI_Movers.FrameList[frame_name] = frame; 
			end
		end
		
		-- record the default location for the frame
		
		nUI_MoverFrames[frame].DefaultPoints = {};
		
		for i=1,frame:GetNumPoints() do
			
			local point = {};

			point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs = frame:GetPoint( i );
			point.relative_to = point.relative_to and point.relative_to.GetName and point.relative_to:GetName() or point_relative_to;
			
			nUI_MoverFrames[frame].DefaultPoints[i] = point;
			
		end
		
		-- create a default mover in the config if we don't have one yet
		
		if not mover or not mover.user_placed then
			
			mover = {};
			mover.Point = {};
			mover.user_placed = false;
			
			for i in pairs( nUI_MoverFrames[frame].DefaultPoints ) do
				mover.Point[i] = nUI_MoverFrames[frame].DefaultPoints[i];
			end
			
			nUI_Data.MoverAnchors[frame_name] = mover;
			
		end

		nUI_MoverFrames[frame].label = overlay;	
		nUI_MoverFrames[frame].drag  = true;
		
		-- create an overlay mover frame to show the user and/or for dragging the frame
	
		nUI_MoverFrames[frame].overlay = CreateFrame( "Button", frame:GetName().."_MoverOverlay", frame:GetParent() );
		
		nUI_MoverFrames[frame].overlay:SetFrameStrata( "HIGH" );
		nUI_MoverFrames[frame].overlay:SetFrameLevel( frame:GetFrameLevel()+5 );
		
		nUI_MoverFrames[frame].overlay:SetScale( frame:GetScale() );
		nUI_MoverFrames[frame].overlay:SetWidth( max( frame:GetWidth(), 25 ) );
		nUI_MoverFrames[frame].overlay:SetHeight( max( frame:GetHeight(), 25 ) );

		for i in pairs( mover.Point ) do
			local point = mover.Point[i];
			nUI_MoverFrames[frame].overlay:SetPoint( point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs );
		end
		
		nUI_MoverFrames[frame].overlay:EnableMouse( true );
		nUI_MoverFrames[frame].overlay:RegisterForDrag();
		nUI_MoverFrames[frame].overlay:RegisterForClicks();
		nUI_MoverFrames[frame].overlay:SetScript( "OnDragStart", 
			function() 
--				nUI_ProfileStart( ProfileCounter, "OnDragStart" ); 
				nUI_Movers:dragFrame( frame, true ); 
--				nUI_ProfileStop();
			end 
		);
		nUI_MoverFrames[frame].overlay:SetScript( "OnDragStop", 
			function() 
--				nUI_ProfileStart( ProfileCounter, "OnDragStop" ); 
				nUI_Movers:dragFrame( frame, false ); 
--				nUI_ProfileStop();
			end 
		);
		nUI_MoverFrames[frame].overlay:SetScript( "OnClick", 
			function() 
--				nUI_ProfileStart( ProfileCounter, "OnClick" ); 
				nUI_Movers:resetFrame( frame ); 
--				nUI_ProfileStop();
			end 
		);
		nUI_MoverFrames[frame].overlay:SetMovable( true );

		-- if we want the mover to be visible, creat a texture for it
		
		if overlay then
			
			nUI_MoverFrames[frame].overlay:SetBackdrop(
				{
					bgFile   = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBg.blp", 
					edgeFile = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBorder.blp", 
					tile     = true, 
					tileSize = 1, 
					edgeSize = 10, 
					insets   = {left = 0, right = 0, top = 0, bottom = 0},
				}
			);
		
			nUI_MoverFrames[frame].overlay:SetBackdropColor( 1, 0.75, 0.75, 1 );
			nUI_MoverFrames[frame].overlay:SetBackdropBorderColor( 1, 0.75, 0.75, 1 );
			
			nUI_MoverFrames[frame].overlay.texture = nUI_MoverFrames[frame].overlay:CreateTexture();
			nUI_MoverFrames[frame].overlay.texture:SetAllPoints( nUI_MoverFrames[frame].overlay );
			nUI_MoverFrames[frame].overlay.texture:SetTexture( 1, 0.5, 0.5, 0.5 );
		
		end

		-- lock the frame to the overlay
		
		nUI_MoverFrames[frame].ClearAllPoints( frame );
		
		for i in pairs( mover.Point ) do
			local point = mover.Point[i];
			nUI_MoverFrames[frame].SetPoint( frame, point.anchor, nUI_MoverFrames[frame].overlay, point.anchor, 0, 0 );
		end
		
		-- disable any other movers that may be attached to the frame
		
		frame:RegisterForDrag();
		frame:SetScript( "OnDragStart", nil );
		frame:SetScript( "OnDragStop", nil );

		-- disable dragging
		
		self:enableDrag( frame, false );
	end	
	
--	nUI_ProfileStop();
	
end

-------------------------------------------------------------------------------

function nUI_Movers:enableDrag( frame, mode )

	if mode then

		if not nUI_MoverFrames[frame].moving and not nUI_MoverFrames[frame].drag then
			
			nUI_MoverFrames[frame].drag = true;
			nUI_MoverFrames[frame].overlay:SetWidth( max( frame:GetWidth(), 25 ) );
			nUI_MoverFrames[frame].overlay:SetHeight( max( frame:GetHeight(), 25 ) );
			nUI_MoverFrames[frame].overlay:SetScale( frame:GetScale() );
			nUI_MoverFrames[frame].overlay:Show();
			nUI_MoverFrames[frame].overlay:RegisterForDrag( "LeftButton" );
			nUI_MoverFrames[frame].overlay:RegisterForClicks( "RightButtonUp" );
			
			nUI_MoverFrames[frame].overlay:SetScript( "OnEnter", 
				function() 
					
--					nUI_ProfileStart( ProfileCounter, "OnEnter" ); 
					
					GameTooltip:SetOwner( nUI_MoverFrames[frame].overlay ); 
					GameTooltip:SetText( nUI_L["Left click and drag to move <frame label>"]:format( nUI_MoverFrames[frame].label ), 1, 0.83, 0 ); 
					
					if nUI_Data.MoverAnchors[frame:GetName()].user_placed then
						GameTooltip:AddLine( nUI_L["Right click to reset to the default location"], 1, 0.83, 0 );
					end
					
					GameTooltip:Show();
					
--					nUI_ProfileStop();
				end 
			);
			
			nUI_MoverFrames[frame].overlay:SetScript( "OnLeave", 
				function() 
--					nUI_ProfileStart( ProfileCounter, "OnLeave" ); 
					GameTooltip:Hide(); 
--					nUI_ProfileStop();
				end 
			);
			
		end
			
	else
		
		if not nUI_MoverFrames[frame].moving and nUI_MoverFrames[frame].drag then
			
			nUI_MoverFrames[frame].drag = false;
			nUI_MoverFrames[frame].overlay:Hide();
			nUI_MoverFrames[frame].overlay:RegisterForClicks();
			nUI_MoverFrames[frame].overlay:RegisterForDrag();
			nUI_MoverFrames[frame].overlay:SetScript( "OnEnter", function() end );
			nUI_MoverFrames[frame].overlay:SetScript( "OnLeave", function() end );
		end		
	end
end

-------------------------------------------------------------------------------

function nUI_Movers:dragFrame( frame, mode )
	
--	nUI_ProfileStart( ProfileCounter, "dragFrame" ); 
	
	if mode and nUI_MoverFrames[frame].drag and not nUI_MoverFrames[frame].moving then
		
		nUI_MoverFrames[frame].overlay:StartMoving();
		nUI_MoverFrames[frame].moving = true;
		GameTooltip:Hide();
		
	elseif not mode and nUI_MoverFrames[frame].drag and nUI_MoverFrames[frame].moving then
		
		local mover   = nUI_Data.MoverAnchors[frame:GetName()];
		local overlay = nUI_MoverFrames[frame].overlay;
		
		overlay:StopMovingOrSizing();
		nUI_MoverFrames[frame].moving = false;

		mover.Point = {};
		mover.user_placed = true;
		
		for i=1,overlay:GetNumPoints() do
			
			local point = {};

			point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs = overlay:GetPoint( i );
			point.relative_to = point.relative_to and point.relative_to:GetName() or point_relative_to;
			
			mover.Point[i] = point;
			
		end
	end
	
--	nUI_ProfileStop();
	
end

-------------------------------------------------------------------------------

function nUI_Movers:resetFrame( frame )
	
--	nUI_ProfileStart( ProfileCounter, "resetFrame" ); 
	
	local mover       = nUI_Data.MoverAnchors[frame:GetName()];
	local overlay     = nUI_MoverFrames[frame].overlay;

	for i in pairs( nUI_MoverFrames[frame].DefaultPoints ) do
		mover.Point[i] = nUI_MoverFrames[frame].DefaultPoints[i];
	end

	mover.user_placed = false;
	
	-- lock the frame to the overlay
	
	nUI_MoverFrames[frame].overlay:ClearAllPoints();
	
	for i in pairs( mover.Point ) do
		
		local point = mover.Point[i];						
		nUI_MoverFrames[frame].overlay:SetPoint( point.anchor, point.relative_to, point.relative_pt, point.xOfs, point.yOfs );
		
	end
	
--	nUI_ProfileStop();
	
end
