﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_DefaultConfig then nUI_DefaultConfig = {}; end
if not nUI_DefaultConfig.AddOns then nUI_DefaultConfig.AddOns = {}; end
if not nUI_DefaultConfig.Misc then nUI_DefaultConfig.Misc = {}; end

-------------------------------------------------------------------------------
-- default configuration for the chat frames

nUI_DefaultConfig.ChatFrame =
{	
	anchor =
	{
		anchor_pt   = "BOTTOMRIGHT",
		relative_to = "nUI_Dashboard",
		relative_pt = "CENTER",
		xOfs        = -685,
		yOfs        = -174,
	},
	
	options = 
	{
		strata   = "BACKGROUND",
		level    = 3,
		scale    = 1,
		height   = 290,
		width    = 585,
		fontsize = 11,
		btn_size = 45,
		btn_gap  = -8,

		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBg.blp", 
				edgeFile = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBorder.blp", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 12, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0, g = 0, b = 0, a = 0.85 },
			},
		},
	},	
};

-------------------------------------------------------------------------------
-- the information panel selector button

nUI_DefaultConfig.InfoPanelSelector =
{
	anchor =
	{
		anchor_pt   = "TOPRIGHT",
		relative_to = "nUI_BottomRightBar",
		relative_pt = "TOPLEFT",
		xOfs        = -10,
		yOfs        = 0,
	},
	options =
	{
		enabled = true,
		height  = 40,
		width   = 93,
		strata  = nil,
		level   = nil,
			
		label =
		{
			enabled = true,
			fontsize = 12,
			anchor_pt = "CENTER",
		},
		
		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
				edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 5, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0.75, g = 0, b = 0, a = 0.75 },
			},
		},		
	},
};

-------------------------------------------------------------------------------
-- default configuration for the actual information frame backdrop

nUI_DefaultConfig.InfoPanel =
{	
	anchor =
	{
		anchor_pt   = "BOTTOMLEFT",
		relative_to = "nUI_Dashboard",
		relative_pt = "CENTER",
		xOfs        = 685,
		yOfs        = -174,
	},	
	
	options = 
	{
		enabled  = true;
		strata   = "BACKGROUND",
		level    = 3,
		scale    = 1,
		height   = 290,
		width    = 585,
		inset    = 6,

		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBg", 
				edgeFile = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBorder", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 12, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0, g = 0, b = 0, a = 0.85 },
			},
		},
	},	
};

-------------------------------------------------------------------------------

nUI_DefaultConfig.UnitPanelSelector =
{
	anchor =
	{
		anchor_pt   = "TOPLEFT",
		relative_to = "nUI_BottomLeftBar",
		relative_pt = "TOPRIGHT",
		xOfs        = 7,
		yOfs        = 0,
	},
	options =
	{
		enabled = true,
		height  = 40,
		width   = 93,
		strata  = nil,
		level   = nil,
			
		label =
		{
			enabled = true,
			fontsize = 12,
			anchor_pt = "CENTER",
		},
		
		background =
		{
			backdrop =
			{
				bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
				edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 5, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},
			
			color =
			{
				border = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0.75, g = 0, b = 0, a = 0.75 },
			},
		},		
	},
};

-------------------------------------------------------------------------------
-- minimap location

nUI_DefaultConfig.Minimap =
{
	enabled = true,
	
	anchor = 
	{
		anchor_pt   = "CENTER",
		relative_to = nUI_Dashboard,
		relative_pt = "CENTER",
		xOfs        = 3,
		yOfs        = -60,
	},
	
	options =
	{
		enabled     = true;
		height      = 235;
		width       = 235;
		strata      = nil,
		level       = 2,
		round_mask  = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_RoundMinimapMask",
		square_mask = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_SquareMinimapMask",
	},
};

-------------------------------------------------------------------------------

nUI_DefaultConfig.Location =
{
	enabled = true;
	
	anchor = 
	{
		anchor_pt   = "BOTTOM",
		relative_to = "nUI_Dashboard",
		relative_pt = "BOTTOM",
		xOfs        = 0,
		yOfs        = 8,
	},
	options =
	{
		enabled  = true,
		strata   = nil,
		level    = 2,
		height   = 70,
		width    = 286,
		fontsize = 12,
		color    = { r = 1, g = 0.83, b = 0 },
						
		border =
		{
			backdrop =
			{
				bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
				edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 6, 
				insets   = { left = 0, right = 0, top = 0, bottom = 0 },
			},					
			color =
			{
				border   = { r = 1, g = 1, b = 1, a = 1 },
				backdrop = { r = 0, g = 0, b = 0, a = 0.75 },
			},
		},
	},
};

-------------------------------------------------------------------------------
-- basic bagbar layout

nUI_DefaultConfig.BagBar =
{
	btn_size = 50,
	gap      = 2,
	anchor   = "BOTTOMRIGHT",
	xOfs     = 1260,
	yOfs     = 150,
};

-------------------------------------------------------------------------------
-- default button bar configurations

nUI_DefaultConfig.ButtonBars =
{
	["nUI_ActionBar"] =
	{
		btn_size = 53.5,
		gap      = 2,
		anchor   = "BOTTOM",
		xOfs     = 0,
		yOfs     = 123,
		rows     = 1,
		cols     = 12,
		page     = 1,
		nuibind  = "nUI_ACTIONBAR",
		binding  = "ACTIONBUTTON",
		label    = nUI_L["nUI_ActionBar"],
	},

	-- the Bliz "bottom left" bar

	["nUI_TopLeftBar"] =
	{		
		btn_size = 53.5,
		gap      = 2,
		anchor   = "TOPRIGHT",
		yOfs     = 122,
		xOfs     = 0,
		rows     = 1,
		cols     = 12,
		page     = 6,
		nuibind  = "nUI_TOPLEFTBAR",
		binding  = "MULTIACTIONBAR1BUTTON",
		label    = nUI_L["nUI_TopLeftBar"],
	},
	
	-- the Bliz "bottom right" bar

	["nUI_TopRightBar"] =
	{		
		btn_size = 53.5,
		gap      = 2,
		anchor   = "TOPLEFT",
		yOfs     = 122,
		xOfs     = 0,
		rows     = 1,
		cols     = 12,
		page     = 5,
		nuibind  = "nUI_TOPRIGHTBAR",
		binding  = "MULTIACTIONBAR2BUTTON",
		label    = nUI_L["nUI_TopRightBar"],
	},
	
	-- the Bliz "right 1" bar (aka "left" bar in the Bliz code)

	["nUI_LeftUnitBar"] =
	{		
		btn_size = 48,
		gap      = 2,
		anchor   = "BOTTOMLEFT",		
		yOfs     = -250,
		xOfs     = -680,
		rows     = 6,
		cols     = 2,
		page     = 3,
		nuibind  = "nUI_LEFTUNITBAR",
		binding  = "MULTIACTIONBAR3BUTTON",
		label    = nUI_L["nUI_LeftUnitBar"],
	},
		
	-- the Bliz "right 2" bar (aka "right" bar in the Bliz code)
	
	["nUI_RightUnitBar"] =
	{		
		btn_size = 48,
		gap      = 2,
		anchor   = "BOTTOMRIGHT",
		yOfs     = -250,
		xOfs     = 680,
		rows     = 6,
		cols     = 2,
		page     = 4,
		nuibind  = "nUI_RIGHTUNITBAR",
		binding  = "MULTIACTIONBAR4BUTTON",
		label    = nUI_L["nUI_RightUnitBar"],
	},

	-- bonus bar 1

	["nUI_BottomLeftBar"] =
	{		
		btn_size = 38,
		gap      = 2,
		anchor   = "BOTTOMLEFT",
		yOfs     = -223,
		xOfs     = -1270,
		rows     = 1,
		cols     = 12,
		page     = 2,
		nuibind  = "nUI_BOTTOMLEFTBAR",
		binding  = nil,
		label    = nUI_L["nUI_BottomLeftBar"],
	},
		
	-- bonus bar 2
	
	["nUI_BottomRightBar"] =
	{		
		btn_size = 38,
		gap      = 2,
		anchor   = "BOTTOMRIGHT",
		yOfs     = -223,
		xOfs     = 1270,
		rows     = 1,
		cols     = 12,
		base_id  = 108,
		nuibind  = "nUI_BOTTOMRIGHTBAR",
		binding  = nil,
		label    = nUI_L["nUI_BottomRightBar"],
	},	
};
	
-------------------------------------------------------------------------------
-- pet bar, stance bar, shapeshift bar, aura bar, possession bar

nUI_DefaultConfig.SpecialBars =
{
	enabled = true;
	
	anchor =
	{
		anchor_pt   = "BOTTOM",
		relative_to = "nUI_Dashboard",
		relative_pt = "CENTER",
		xOfs        = 0,
		yOfs        = 183,
	},
	options =
	{
		enabled   = true,
		strata    = nil,
		level     = 2,
		btn_size  = 36,
		block_gap = 10,
		btn_gap   = 1,
		inset     = 3,
		
		border =
		{
			backdrop =
			{
				bgFile   = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBg.blp", 
				edgeFile = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BevelboxBorder.blp", 
				tile     = true, 
				tileSize = 1, 
				edgeSize = 12, 
				insets   = {left = 0, right = 0, top = 0, bottom = 0},
			},
			border_color = { r = 1, g = 1, b = 1, a = 1 },
			backdrop_color = { r = 0, g = 0, b = 0, a = 0.35 },
		}
	},
};

-------------------------------------------------------------------------------
-- experience bar

nUI_DefaultConfig.XPBar =
{
	enabled = true;
	
	anchor =
	{
		anchor_pt   = "TOPLEFT",
		relative_to = "nUI_BottomLeftBar",
		relative_pt = "BOTTOMLEFT",
		xOfs        = 0,
		yOfs        = -7,
	},
	
	options =
	{
		enabled  = true;
		strata   = nil,
		level    = 3,
		height   = 15,
		width    = 585,
		inset    = 0,
--[[		
		label =
		{
			enabled     = true;
			font_size   = 12,
			anchor_pt   = "CENTER",
			relative_to = "$parent",
			relative_pt = "CENTER",
			xOfs        = 0,
			yOfs        = 0,
			color =
			{
				normal = { r=1, g=1, b=0 },
				rested = { r=1, g=0.83, b=1 },
			},
		},
]]--		
		bar =
		{
			enabled     = true,
			orient      = "LEFT",
			tick_height = 35,
			tick_width  = 40,
			overlay     = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_XPRepOverlay",
			rested_tick = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_XPRestedTick",
			
			colors =
			{
				rested = { r = 0.25, g = 1, b = 0.25 },
				xp     = { r = 0.25, g = 0.5, b = 1 },
			},
		},
	},
};

-------------------------------------------------------------------------------
-- faction/reputation bar

nUI_DefaultConfig.FactionBar =
{
	enabled = true;
	
	anchor =
	{
		anchor_pt   = "TOPRIGHT",
		relative_to = "nUI_BottomRightBar",
		relative_pt = "BOTTOMRIGHT",
		xOfs        = 0,
		yOfs        = -7,
	},
	
	options =
	{
		enabled  = true;
		strata   = nil,
		level    = 3,
		height   = 15,
		width    = 585,
		inset    = 0,
--[[
		label =
		{
			enabled     = true;
			font_size   = 12,
			anchor_pt   = "CENTER",
			relative_to = "$parent",
			relative_pt = "CENTER",
			xOfs        = 0,
			yOfs        = 0,
		},
]]--				
		bar =
		{
			enabled     = true,
			orient      = "LEFT",
			overlay     = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_XPRepOverlay",			
			color       = { r = 0.25, g = 0.5, b = 1 },
		},
	},
};

