﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_UnitSkins then nUI_UnitSkins = {}; end

nUI_UnitSkins[nUI_UNITSKIN_SOLOPLAYER] =
{
	height   = 302,
	width    = 420,
	desc     = nUI_L[nUI_UNITSKIN_SOLOPLAYER],
	
	elements =
	{
		["Label"] =
		{
			[1] =
			{
				anchor =
				{
					anchor_pt   = "TOP",
					relative_to = "$parent_Feedback",
					xOfs        = 0,
					yOfs        = 0,
				},		
				options =
				{
					enabled = true,
					height  = 35,
					width   = 420,
					inset   = 7,
					strata  = nil,
					level   = nil,
	
					text          = nil,
					show_reaction = true,
					class_colors  = true,
					
					label =
					{
						enabled     = true,
						fontsize    = 11,
						justifyH    = "LEFT",
						justifyV    = "MIDDLE",
						anchor_pt   = "LEFT",
						relative_to = "$parent_Level",
						relative_pt = "RIGHT",
						xOfs        = 0,
						yOfs        = 0,					
						color       = { r = 1, g = 0.83, b = 0, a = 1 },
					},
				
					border =
					{
						backdrop =
						{
							bgFile   = nil, 
							edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
							tile     = true, 
							tileSize = 1, 
							edgeSize = 5, 
							insets   = { left = 0, right = 0, top = 0, bottom = 0 },
						},					
						color =
						{
							border   = { r = 1, g = 1, b = 1, a = 0.5 },
							backdrop = { r = 0, g = 0, b = 0, a = 0 },
						},
					},
				},
			},
			[2] =
			{
				anchor =
				{
					anchor_pt   = "BOTTOMLEFT",
					relative_to = "$parent_Aura2",
					relative_pt = "TOPLEFT",
					xOfs        = 0,
					yOfs        = 0,
				},		
				options =
				{
					enabled = true,
					height  = 35,
					width   = 350,
					inset   = 7,
					strata  = nil,
					level   = nil,
	
					text          = nil,
					show_reaction = true,
					class_colors  = true,
					clickable     = false,
					
					label =
					{
						enabled     = true,
						fontsize    = 12,
						justifyH    = "CENTER",
						justifyV    = "MIDDLE",
						xOfs        = 0,
						yOfs        = 0,					
						color       = { r = 1, g = 1, b = 1, a = 1 },
					},
				
					border =
					{
						backdrop =
						{
							bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
							edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
							tile     = true, 
							tileSize = 1, 
							edgeSize = 4, 
							insets   = { left = 0, right = 0, top = 0, bottom = 0 },
						},					
						color =
						{
							border   = { r = 1, g = 1, b = 1, a = 0.5 },
							backdrop = { r = 0.25, g = 0.25, b = 0.25, a = 0.5 },
						},
					},
				},
			},
		},
		["Class"] =
		{
			anchor =
			{
				anchor_pt   = "TOPRIGHT",
				relative_to = "$parent_Feedback",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				size    = 35,
				inset   = 6,
				strata  = nil,
				level   = 2,
			},
		},
		["Level"] =
		{
			anchor =
			{
				anchor_pt   = "TOPLEFT",
				relative_to = "$parent_Feedback",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				size    = 35,
				inset   = 0,
				strata  = nil,
				level   = 2,
				
				label =
				{
					enabled     = true,
					fontsize    = 11,
					justifyH    = "RIGHT",
					justifyV    = "MIDDLE",
					anchor_pt   = "RIGHT",
					xOfs        = 0,
					yOfs        = 1,					
					color       = { r = 1, g = 0.83, b = 0, a = 1 },
				},
			},
		},
		["Portrait"] =
		{
			anchor =
			{
				anchor_pt   = "BOTTOMLEFT",
				relative_to = "$parent_Feedback",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				height  = 120,
				width   = 120,
				inset   = 30,
				strata  = nil,
				level   = nil,

				show_anim = true,
				model     = false,
				outline   = true,
			},
		},
		["Runes"] =
		{
			anchor =
			{
				anchor_pt   = "BOTTOMLEFT",
				relative_to = "$parent_Health",
				relative_pt = "TOPLEFT",
				xOfs        = 0,
				yOfs        = 2,
			},		
			options =
			{
				enabled = true,
				size    = 20,
				hgap    = 8,
				strata  = nil,
				level   = 4,
				orient  = "LEFT",
			},
		},	
		["Resting"] =
		{
			anchor =
			{
				anchor_pt   = "TOPRIGHT",
				relative_to = "$parent_Portrait",
				xOfs = 0,
				yOfs = -2.5,
			},		
			options =
			{
				enabled = true,
				size    = 35,
				inset   = 0,
				strata  = nil,
				level   = 2,
			},
		},
		["Combat"] =
		{
			anchor =
			{
				anchor_pt   = "TOPRIGHT",
				relative_to = "$parent_Portrait",
				xOfs = 0,
				yOfs = -2.5,
			},		
			options =
			{
				enabled = true,
				size    = 35,
				inset   = 0,
				strata  = nil,
				level   = 2,
			},
		},
		["RaidTarget"] =
		{
			anchor =
			{
				anchor_pt   = "TOPLEFT",
				relative_to = "$parent_Portrait",
				xOfs = 0,
				yOfs = -2.5,
			},		
			options =
			{
				enabled = true,
				size    = 35,
				inset   = 0,
				strata  = nil,
				level   = 2,
			},
		},
		["RaidGroup"] =
		{
			anchor =
			{
				anchor_pt   = "TOP",
				relative_to = "$parent_Portrait",
				xOfs = 0,
				yOfs = -5,
			},		
			options =
			{
				enabled = true,
				size    = 25,
				inset   = 0,
				strata  = nil,
				level   = 2,
				
				label =
				{
					enabled     = true,
					justifyH    = "CENTER",
					justifyV    = "MIDDLE",
					anchor_pt   = "CENTER",
					xOfs        = 0,
					yOfs        = 1.5,
					color       = { r = 0, g = 1, b = 1, a = 1 },
				},
							
				border =
				{
					backdrop =
					{
						bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
						edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
						tile     = true, 
						tileSize = 1, 
						edgeSize = 4, 
						insets   = { left = 0, right = 0, top = 0, bottom = 0 },
					},					
					color =
					{
						border   = { r = 1, g = 1, b = 1, a = 0.75 },
						backdrop = { r = 0, g = 0, b = 0, a = 1 },
					},
				},
			},
		},
		["Spec"] =
		{
			anchor =
			{
				anchor_pt   = "BOTTOM",
				relative_to = "$parent_Portrait",
				xOfs = 0,
				yOfs = 0,
			},		
			options =
			{
				enabled = true,
				width   = 120,
				height  = 30,
				inset   = 0,
				strata  = nil,
				level   = 2,
				
				show_name = true,
				
				label =
				{
					enabled     = true,
					fontsize    = 10,
					justifyH    = "CENTER",
					justifyV    = "MIDDLE",
					anchor_pt   = "CENTER",
					xOfs        = 0,
					yOfs        = 5,
					color       = { r = 0, g = 1, b = 1, a = 1 },
				},
			},
		},
		["Health"] =
		{
			anchor =
			{
				anchor_pt   = "TOPLEFT",
				relative_to = "$parent_Portrait",
				relative_pt = "TOPRIGHT",
				xOfs = 0,
				yOfs = -13,
			},		
			options =
			{
				enabled  = true,
				height   = 25,
				width    = 225,
				inset    = 10,
				strata   = nil,
				level    = 2,
				
				bar = 
				{
					enabled  = true;
					orient   = "LEFT",
					overlay  = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BarOverlay1",
				},
				
				mix_health =
				{
					enabled     = true,
					fontsize    = 11,
					justifyH    = "RIGHT",
					justifyV    = "MIDDLE",
					anchor_pt   = "RIGHT",
					relative_to = "$parent_CurHealth",
					xOfs        = 0,
					yOfs        = 0,
					color       = { r = 0.5, g = 1, b = 0.5, a = 1 },
				},
				
				pct_health =
				{
					enabled     = true,
					fontsize    = 11,
					justifyH    = "CENTER",
					justifyV    = "MIDDLE",
					anchor_pt   = "CENTER",
					relative_to = "$parent_PctHealth",
					xOfs        = 0,
					yOfs        = 1,
					color       = { r = 0.5, g = 1, b = 0.5, a = 1 },
				},

				border =
				{
					backdrop =
					{
						bgFile   = nil, 
						edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
						tile     = true, 
						tileSize = 1, 
						edgeSize = 5, 
						insets   = { left = 0, right = 0, top = 0, bottom = 0 },
					},					
					color =
					{
						border   = { r = 1, g = 1, b = 1, a = 0.5 },
						backdrop = { r = 0, g = 0, b = 0, a = 0 },
					},
				},
			},
		},
		["Power"] =
		{
			anchor =
			{
				anchor_pt   = "TOP",
				relative_to = "$parent_Health",
				relative_pt = "BOTTOM",
				xOfs = 0,
				yOfs = -2.5,
			},		
			options =
			{
				enabled  = true,
				height   = 25,
				width    = 225,
				inset    = 10,
				strata   = nil,
				level    = 2,
				
				bar = 
				{
					enabled  = true;
					orient   = "LEFT",
					overlay  = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BarOverlay1",
				},
				
				pct_power =
				{
					enabled     = true,
					fontsize    = 11,
					justifyH    = "CENTER",
					justifyV    = "MIDDLE",
					anchor_pt   = "CENTER",
					relative_to = "$parent_PctPower",
					xOfs        = 0,
					yOfs        = 1,
					color       = { r = 1, g = 1, b = 1, a = 1 },
				},
			
				border =
				{
					backdrop =
					{
						bgFile   = nil, 
						edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
						tile     = true, 
						tileSize = 1, 
						edgeSize = 5, 
						insets   = { left = 0, right = 0, top = 0, bottom = 0 },
					},					
					color =
					{
						border   = { r = 1, g = 1, b = 1, a = 0.5 },
						backdrop = { r = 0, g = 0, b = 0, a = 0 },
					},
				},
			},
		},	
		["GCD"] =
		{
			anchor =
			{
				anchor_pt   = "CENTER",
				relative_to = "$parent",
				relative_pt = "TOP",
				xOfs = 0,
				yOfs = 0,
			},		
			options =
			{
				enabled    = true,
				height     = 20,
				width      = 420,
				inset      = 0,
				strata     = nil,
				level      = 8,
				barColor   = { r = 0.75, g = 0.75, b = 0.75 },
				sparkColor = { r = 1, g = 0.5, b = 0.5 },
			},
		},
		["Casting"] =
		{
			anchor =
			{
				anchor_pt   = "CENTER",
				relative_to = "$parent_Label1",
				relative_pt = "CENTER",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				height  = 35,
				width   = 420,
				inset   = 10,
				strata  = nil,
				level   = 3,
				
				orient       = "LEFT",
				persist      = false,
				show_bar     = true,
				show_gcd     = true,
				show_latency = true,	
				overlay     = "Interface\\AddOns\\nUI\\Layouts\\Default\\Art\\nUI_BarOverlay1",
				
				cur_time =
				{
					enabled     = true,
					justifyH    = "RIGHT",
					justifyV    = "MIDDLE",
					anchor_pt   = "RIGHT",
					xOfs        = -10,
					yOfs        = 1,
					
					color = { r = 1, g = 1, b = 1, a = 1 },
				},
				
				spell_name =
				{
					enabled     = true,
					justifyH    = "LEFT",
					justifyV    = "MIDDLE",
					anchor_pt   = "LEFT",
					xOfs        = 10,
					yOfs        = 1,
					
					color = { r = 1, g = 1, b = 1, a = 1 },
				},
				
				msg_label =
				{
					enabled   = true,
					fontsize    = 14,
					justifyH  = "CENTER",
					justifyV  = "MIDDLE",
					anchor_pt = "CENTER",
					xOfs      = 0,
					yOfs      = 1,
					
					color = { r = 1, g = 0, b = 0, a = 1 },
				},
				
				border =
				{
					backdrop =
					{
						bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
						edgeFile = nil, 
						tile     = true, 
						tileSize = 1, 
						edgeSize = 7, 
						insets   = {left = 0, right = 0, top = 0, bottom = 0},
					},
					
					color =
					{
						border = { r = 0, g = 0, b = 0, a = 0 },
						backdrop = { r = 0, g = 0, b = 0, a = 1 },
					},
				},
			},
		},
		["Feedback"] =
		{
			anchor =
			{
				anchor_pt   = "TOPLEFT",
				relative_to = "$parent",
				relative_pt = "TOPLEFT",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled   = true,
				height    = 151,
				width     = 420,
				inset     = 0,
				strata    = nil,
				level     = nil,
				clickable = true,
						
				border =
				{
					backdrop =
					{
						bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
						edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
						tile     = true, 
						tileSize = 1, 
						edgeSize = 6, 
						insets   = { left = 0, right = 0, top = 0, bottom = 0 },
					},					
					color =
					{
						border   = { r = 1, g = 1, b = 1, a = 1 },
						backdrop = { r = 0, g = 0, b = 0, a = 0.35 },
					},
				},
			},
		},
		["Aura"] =
		{
			[1] =	-- debuffs
			{
				anchor =
				{
					anchor_pt   = "BOTTOMLEFT",
					relative_to = "$parent_Portrait",
					relative_pt = "BOTTOMRIGHT",
					xOfs        = 10,
					yOfs        = 16,
				},		
				options =
				{
					enabled = true,
					size    = 35,
					strata  = nil,
					level   = 1,
					
					aura_type        = "harm",
					origin           = "BOTTOMRIGHT",
					player_auras     = false,
					dispellable      = false,
					horizontal       = false,
					highlight_player = false,
					aura_types       = true,
					cooldown_anim    = false,
					flash_expire     = true,
					clickable        = true,
					rows             = 1,
					cols             = 8,
					expire_time      = 10,
					hGap             = 0,
					vGap             = 0,

					timer =
					{
						enabled     = true,
						fontsize    = 9,
						justifyH    = "CENTER",
						justifyV    = "TOP",
						anchor_pt   = "TOP",
						relative_pt = "BOTTOM",
						xOfs        = 0,
						yOfs        = 2,
					},

					count =
					{
						enabled     = true,
						justifyH    = "CENTER",
						justifyV    = "MIDDLE",
						anchor_pt   = "CENTER",
						relative_pt = "CENTER",
						xOfs        = 0,
						yOfs        = 0.5,
					},
				},		
			},
			[2] =
			{
				anchor =
				{
					anchor_pt        = "BOTTOMLEFT",
					relative_to      = "nUI_Dashboard",
					relative_pt      = "TOPLEFT",
					xOfs             = 20,
					yOfs             = -80,
				},		
				options =
				{
					enabled          = true,
					width            = 350,
					size             = 28.5,
					strata           = nil,
					level            = 1,
					
					aura_type        = "help",
					origin           = "TOPLEFT",
					player_auras     = false,
					dispellable      = false,
					horizontal       = false,
					highlight_player = true,
					aura_types       = false,
					cooldown_anim    = false,
					flash_expire     = true,
					clickable        = true,
					dynamic_size     = true,
					rows             = 40,
					cols             = 1,
					expire_time      = 10,
					hGap             = 0,
					vGap             = 2,
				
					border =
					{
						backdrop =
						{
							bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
							edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
							tile     = true, 
							tileSize = 1, 
							edgeSize = 4, 
							insets   = { left = 0, right = 0, top = 0, bottom = 0 },
						},					
						color =
						{
							border   = { r = 1, g = 1, b = 1, a = 0.75 },
							backdrop = { r = 0, g = 0, b = 0, a = 0.4 },
						},
					},

					count =
					{
						enabled     = true,
						fontsize    = 11.5,
						justifyH    = "LEFT",
						justifyV    = "MIDDLE",
						anchor_pt   = "LEFT",
						relative_pt = "RIGHT",
						xOfs        = 10,
						yOfs        = 1,
						color       = { r = 0.5, g = 1, b = 0.5, a = 1 },
					},

					timer =
					{
						enabled     = true,
						fontsize    = 11.5,
						justifyH    = "RIGHT",
						justifyV    = "MIDDLE",
						anchor_pt   = "RIGHT",
						relative_pt = "RIGHT",
						xOfs        = 315,
						yOfs        = 1,
						color       = { r = 0, g = 1, b = 1, a = 1 },
					},

					label =
					{
						enabled     = true,
						fontsize    = 11.5,
						justifyH    = "LEFT",
						justifyV    = "MIDDLE",
						anchor_pt   = "LEFT",
						relative_pt = "RIGHT",
						width       = 240,
						height      = 28.5,
						xOfs        = 35,
						yOfs        = 1,
						color       = { r = 1, g = 0.83, b = 0, a = 1 },
					},
				},	
			},
		},
		["PvP"] =
		{
			anchor =
			{
				anchor_pt   = "TOP",
				relative_to = "$parent_Health",
				relative_pt = "TOP",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				size    = 52.5,
				strata  = nil,
				level   = 4,

				timer =
				{
					enabled     = true,
					fontsize    = 15,
					justifyH    = "LEFT",
					justifyV    = "MIDDLE",
					anchor_pt   = "LEFT",
					relative_pt = "RIGHT",
					xOfs        = 0,
					yOfs        = 1,					
					color       = { r = 1, g = 1, b = 1, a = 1 },
				},
			},
		},
		["Role"] =
		{
			anchor =
			{
				anchor_pt   = "CENTER",
				relative_to = "$parent_Label1",
				relative_pt = "CENTER",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				size    = 30,
				strata  = nil,
				level   = 1,

				icon_size = 30,
				orient    = "LEFT",				
			},
		},
		["ReadyCheck"] =
		{
			anchor =
			{
				anchor_pt   = "CENTER",
				relative_to = "$parent_Portrait",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				size    = 90,
				strata  = nil,
				level   = 9,
			},
		},
		["Status"] =
		{
			anchor =
			{
				anchor_pt   = "TOPLEFT",
				relative_to = "$parent_Health",
				xOfs        = 0,
				yOfs        = 0,
			},		
			options =
			{
				enabled = true,
				height  = 52.5,
				width   = 225,
				strata  = nil,
				level   = 5,
				
				fade_unit = 0.6,
				
				label =
				{
					enabled   = true,
					fontsize    = 26,
					justifyH  = "CENTER",
					justifyV  = "MIDDLE",
					anchor_pt = "CENTER",
					xOfs      = 0,
					yOfs      = 2,
					
					color = { r = 1, g = 0.8, b = 0.8, a = 1 },
				},
			
				border =
				{
					backdrop =
					{
						bgFile   = "Interface\\Tooltips\\UI-Tooltip-Background", 
						edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
						tile     = true, 
						tileSize = 1, 
						edgeSize = 5, 
						insets   = { left = 0, right = 0, top = 0, bottom = 0 },
					},					
					color =
					{
						border   = { r = 1, g = 1, b = 1, a = 0.5 },
						backdrop = { r = 0, g = 0, b = 0, a = 1 },
					},
				},
			},
		},
		["Frame"] =
		{
			[1] =
			{
				anchor =
				{
					anchor_pt   = "RIGHT",
					relative_to = "$parent_Class",
					relative_pt = "LEFT",
					xOfs        = 0,
					yOfs        = 0,
				},		
				options =
				{
					name    = "$parent_CurHealth",
					enabled = true,
					height  = 25,
					width   = 60,
					inset   = 0,
					strata  = nil,
					level   = nil,
				},
			},
			[2] =
			{
				anchor =
				{
					anchor_pt   = "LEFT",
					relative_to = "$parent_Health",
					relative_pt = "RIGHT",
					xOfs        = 5,
					yOfs        = 0,
				},		
				options =
				{
					name    = "$parent_PctHealth",
					enabled = true,
					height  = 25,
					width   = 60,
					inset   = 0,
					strata  = nil,
					level   = nil,
				},
			},
			[3] =
			{
				anchor =
				{
					anchor_pt   = "LEFT",
					relative_to = "$parent_Power",
					relative_pt = "RIGHT",
					xOfs        = 5,
					yOfs        = 0,
				},		
				options =
				{
					name    = "$parent_PctPower",
					enabled = true,
					height  = 25,
					width   = 60,
					inset   = 0,
					strata  = nil,
					level   = nil,
				},
			},
		},
	},
};
