﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_InfoPanels then nUI_InfoPanels = {}; end

local CreateFrame = CreateFrame;
local GetTime     = GetTime;

-------------------------------------------------------------------------------
-- default configuration for the Skada info panel

nUI_InfoPanels[nUI_INFOPANEL_SKADA] =
{	
	enabled   = true,
	desc      = nUI_L[nUI_INFOPANEL_SKADA],				-- player friendly name/description of the panel
	label     = nUI_L[nUI_INFOPANEL_SKADA.."Label"],	-- label to use on the panel selection button face
	rotation  = nUI_INFOMODE_SKADA,						-- index or position this panel appears on/in when clicking the selector button
	full_size = true;									-- this plugin requires the entire info panel port without the button bag
	
	options  =
	{
		enabled  = true,
	},
};

-------------------------------------------------------------------------------
-- master frame for the plugin

local plugin   = CreateFrame( "Frame", nUI_INFOPANEL_SKADA, nUI_Dashboard.Anchor );
plugin.enabled = false;
plugin.doInit  = false;
plugin.active  = false;

local function onOmenEvent()

	if event == "ADDON_LOADED" and arg1 == "nUI" then
	
		if not IsAddOnLoaded( "Skada" ) then 
			LoadAddOn( "Skada" );
		end
		
	elseif event == "ADDON_LOADED" and arg1 == "Skada" then
		
		plugin.active  = true;
		plugin.enabled = true;
		plugin.doInit  = true;

	elseif event == "PLAYER_ENTERING_WORLD" then
	
		plugin:UnregisterEvent( "PLAYER_ENTERING_WORLD" );
		
					
		plugin.setEnabled( IsAddOnLoaded( "Skada" ) );
		
	end	
	
end

plugin:SetScript( "OnEvent", onOmenEvent );
plugin:RegisterEvent( "ADDON_LOADED" );
plugin:RegisterEvent( "PLAYER_ENTERING_WORLD" );
-------------------------------------------------------------------------------

plugin.initPanel = function( container, options )

	plugin.container = container;
	plugin.options   = options;

	if options and options.enabled then
	end
end

-------------------------------------------------------------------------------

plugin.sizeChanged = function( scale, height, width )
	
	local options  = plugin.options;
	local windows  = Skada and Skada:GetWindows() or {};
	local window1  = nil;
	local window2  = nil;
	local count    = 0;
	
	plugin.scale  = scale;
	plugin.height = height;
	plugin.width  = width;
	
	-- find the two key nUI windows
	
	for i,win in ipairs( windows ) do
	
		if win.db.name == "nUI_Skada1" then 
			window1 = win; 
			count   = count+1; 
		end
		if win.db.name == "nUI_Skada2" then 
			window2 = win; 
			count   = count+1;
		end		
	end
	
	if not window1 and window2 then
		window1 = window2;
		window2 = nil;
	end

	if window1 then	

		window1.bargroup:ClearAllPoints();
		window1.bargroup:SetPoint( "TOPLEFT", plugin.container, "TOPLEFT", 2, 0 );
		window1.db.barwidth = width / count * 0.975;
		window1.db.barheight = height / 11;
		window1.db.barslocked = not nil;
		window1.db.background.height = height;
		
		if plugin.initWindows then
			Skada.db.profile.hidedisables = nil;
			Skada:RestoreView( window1, nil, "Damage" );
			window1.db.modeincombat = "Threat";
			window1.db.returnaftercombat = not nil;
		end
		
	end
	
	if window2 then

		window2.db.barwidth = width / count * 0.975;
		window2.db.background.height = height;
		window2.db.barheight = height / 11;
		window2.db.barslocked = not nil;
		window2.bargroup:SetPoint( "TOPRIGHT", plugin.container, "TOPRIGHT", -2, 0 );
		
		if plugin.initWindows then
			Skada:RestoreView( window2, nil, "DPS" );
			window2.db.modeincombat = "DPS";
			window2.db.returnaftercombat = not nil;
		end
	end
	
	if plugin.enabled then Skada:ApplySettings(); end

	plugin.initWindows = false;
	
end	

-------------------------------------------------------------------------------

plugin.setEnabled = function( enabled )

	local windows = Skada and Skada:GetWindows() or {};
	enabled       = Skada and enabled or false;		
	
	if doInit or plugin.enabled ~= enabled then
		
		doInit = true;
		
		plugin.enabled = enabled;
		
		if not enabled then

			for i, win in ipairs( windows ) do
   
				if win.bargroup.saved_bar_parent then

					win.bargroup:SetParent( win.bargroup.saved_bar_parent );					
					win.bargroup.saved_bar_parent = nil;
					
				end
			end
			
		else

			-- have we already defined Skada windows for use with nUI?

			local matched = false;			
			local window1 = nil;
			local window2 = nil;

			for i,win in ipairs( windows ) do	
				if win.db.name == "nUI_Skada1" then
					window1 = win;
				end
				if win.db.name == "nUI_Skada2" then
					window2 = win;
				end
			end
			
			if not window1 then
				plugin.initWindows = true;
				Skada:CreateWindow( "nUI_Skada1" );
			end
				
			if not window2 then
				plugin.initWindows = true;
				Skada:CreateWindow( "nUI_Skada2" );
			end
								
			windows = Skada:GetWindows();
			
			-- reparent the windows
			
			for i, win in ipairs( windows ) do
   
				if i == 1 then
				
					win.bargroup.saved_bar_parent = win.bargroup:GetParent();
					win.bargroup:SetParent( nUI_BlizUI );
					
				elseif not win.bargroup.saved_bar_parent then

					win.bargroup.saved_bar_parent = win.bargroup:GetParent();
					win.bargroup:SetParent( plugin.container );					
					
				end
			end	
			
			plugin.sizeChanged( plugin.scale, plugin.height, plugin.width )
					
		end				
	end			
end

-------------------------------------------------------------------------------

plugin.setSelected = function( selected )

	if selected ~= plugin.selected then

		plugin.selected = selected;
		
		if selected then
			
			
		else
			
			
		end
	end
end
