﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_HUDLayouts then nUI_HUDLayouts = {}; end

-------------------------------------------------------------------------------
-- default configuration for the combat log info panel

nUI_HUDLayouts[nUI_HUDLAYOUT_HEALTHPOWER] =
{	
	enabled   = true,
	desc      = nUI_L[nUI_HUDLAYOUT_HEALTHPOWER],			-- player friendly name/description of the layout
	label     = nUI_L[nUI_HUDLAYOUT_HEALTHPOWER.."Label"],	-- label to use on the panel selection button face
	rotation  = nUI_HUDMODE_HEALTHPOWER,					-- index or position this panel appears on/in when clicking the selector button
	
	options  =
	{
		enabled     = true,
		scale       = 1,
		show_race   = false,
		show_threat = false,
		show_pet    = false,
		show_tot    = false,
		npc_bars    = false,
		hGap        = 500,
		vGap        = 400,
		
		focus_pairs =
		{
			["target"] =
			{
				normal = nUI_HUDUNIT_HEALTHPOWER_TARGET,
				focus  = nUI_HUDUNIT_HEALTHPOWER_FOCUS,
			},
			["tot"] =
			{
				normal = nUI_HUDUNIT_HEALTHPOWER_TOT,
				focus  = nUI_HUDUNIT_HEALTHPOWER_FOCUSTARGET,
			},
		},
		
		alpha =
		{
			idle    = 0,
			regen   = 0.35,
			target  = 0.75,
			combat  = 1,
		},
	},
	elements =
	{
		cooldown_bar =
		{
			enabled = true;
			name    = nUI_HUDLAYOUT_HEALTHPOWER.."_CooldownBar",
			
			anchor =
			{
				anchor_pt   = "BOTTOM",
				relative_to = nUI_HUDLAYOUT_HEALTHPOWER.."Bottom",
				relative_pt = "CENTER",
				xOfs        = 0,
				yOfs        = 8,
			},
			options =
			{
				enabled      = true,
				scale        = 1,
				rows         = 1,
				cols         = 10,
				btn_size     = 45,
				hGap         = 2,
				vGap         = 0,
				origin       = "TOPLEFT",
				sound        = "Sound\\Event Sounds\\Wisp\\WispYes1.wav",
				fade         = false,
				dynamic_size = true,
				horizontal   = true,
				clickable    = false,
			
				message =
				{
					enabled     = true,
					fontsize    = 25,
					justifyH    = "CENTER",
					justifyV    = "BOTTOM",
					anchor_pt   = "BOTTOM",
					relative_pt = "BOTTOM",
					outline     = "THICKOUTLINE",
					xOfs        = 0,
					yOfs        = 2,
					color       = { r = 1, g = 0.75, b = 0.75, a = 1 },
				},
				
				timer =
				{
					enabled     = true,
					fontsize    = 10.5,
					justifyH    = "CENTER",
					justifyV    = "BOTTOM",
					anchor_pt   = "TOP",
					relative_pt = "BOTTOM",
					xOfs        = 0,
					yOfs        = -1,
				},
			},
		},
		
		units =
		{
			[nUI_HUDUNIT_HEALTHPOWER_CASTBAR] =
			{
				options = 
				{
					skinName  = nUI_HUDSKIN_HEALTHPOWER_CASTBAR,
					enabled   = true,
					
					strata    = nil,
					level     = nil,
					
					unit_id   = "player",
					party_id  = nil,
					raid_id	  = nil,
					
					scale     = 1,
					clickable = false,
					fade      = false,
				},
			},
			[nUI_HUDUNIT_HEALTHPOWER_PLAYER] =
			{
				options = 
				{
					skinName  = nUI_HUDSKIN_HEALTHPOWER_PLAYER,
					enabled   = true,
					
					strata    = nil,
					level     = nil,
					
					unit_id   = "player",
					party_id  = nil,
					raid_id	  = nil,
					
					scale     = 1,
					clickable = false,
					fade      = true,
				},
			},
			[nUI_HUDUNIT_HEALTHPOWER_PET] =
			{
				options = 
				{
					skinName  = nUI_HUDSKIN_HEALTHPOWER_PET,
					enabled   = true,
					
					strata    = nil,
					level     = nil,
					
					unit_id   = "pet",
					party_id  = nil,
					raid_id	  = nil,
					
					scale     = 1,
					clickable = false,
					fade      = true,
				},
			},
			[nUI_HUDUNIT_HEALTHPOWER_TARGET] =
			{
				options = 
				{
					skinName   = nUI_HUDSKIN_HEALTHPOWER_TARGET,
					enabled    = true,
					
					strata     = nil,
					level      = nil,
					
					unit_id    = "target",
					party_id   = nil,
					raid_id	   = nil,
					visibility = "[target=target, exists] show; hide";
					
					scale      = 1,
					clickable  = false,
					fade       = true,
				},
			},
			[nUI_HUDUNIT_HEALTHPOWER_FOCUS] =
			{
				options = 
				{
					skinName   = nUI_HUDSKIN_HEALTHPOWER_TARGET,
					enabled    = true,
					
					strata     = nil,
					level      = nil,
					
					unit_id    = "focus",
					party_id   = nil,
					raid_id	   = nil,
					visibility = "hide";
					
					scale      = 1,
					clickable  = false,
					fade       = true,
				},
			},
			[nUI_HUDUNIT_HEALTHPOWER_TOT] =
			{
				options = 
				{
					skinName   = nUI_HUDSKIN_HEALTHPOWER_TOT,
					enabled    = true,
					
					strata     = nil,
					level      = nil,
				 	
					unit_id    = "targettarget",
					party_id   = nil,
					raid_id	   = nil,
					visibility = "[target=targettarget, exists] show; hide";
					
					scale      = 1,
					clickable  = false,
					fade       = true,
				},
			},
			[nUI_HUDUNIT_HEALTHPOWER_FOCUSTARGET] =
			{
				options = 
				{
					skinName   = nUI_HUDSKIN_HEALTHPOWER_TOT,
					enabled    = true,
					
					strata     = nil,
					level      = nil,
				 	
					unit_id    = "focustarget",
					party_id   = nil,
					raid_id	   = nil,
					visibility = "hide";
					
					scale      = 1,
					clickable  = false,
					fade       = true,
				},
			},
		},
	},
};
