﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

(With thanks to Brillynt for doing the integration work)

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------
	
if not nUI_Profile then nUI_Profile = {}; end;

nUI_Profile.nUI_ChocolateBar = {};

local ProfileCounter = nUI_Profile.nUI_ChocolateBar;
local ChocolateBar = nil;

local function DetectChocolateBar_Bars()
	
--	nUI_ProfileStart( ProfileCounter, "DetectChocolateBar_Bars" );
	
	local temptop = {};
	local tempbottom = {};
	local chocolateBars = {};
	local ChocolateLowestTopBar = nil;
	local ChocolateHighestBottomBar = nil;

	-- Get the Bars from ChocolateBar
	-- sort{}
	temptop = {}
	tempbottom = {}
	
	chocolateBars = ChocolateBar:GetBars();
	for k,v in pairs(chocolateBars) do
		local settings = v.settings
		local index = settings.index
		if settings.align == "top" then
			table.insert(temptop,{v,index})
			--DEFAULT_CHAT_FRAME:AddMessage( "|cFFFF8080nUI Debug:|r ".."Found Top Chocolate Bar. Name = "..settings.barName.."  index = "..index, 1, 0.83, 0 );
		else
			table.insert(tempbottom,{v,index})
			--DEFAULT_CHAT_FRAME:AddMessage( "|cFFFF8080nUI Debug:|r ".."Found Bottom Chocolate Bar. Name = "..settings.barName.."  index = "..index, 1, 0.83, 0 );
		end
	end
	table.sort(temptop, function(a,b)return a[2] < b[2] end)
	table.sort(tempbottom, function(a,b)return a[2] < b[2] end)

	for i, v in ipairs(temptop) do
		ChocolateLowestTopBar = v[1]
		--DEFAULT_CHAT_FRAME:AddMessage( "|cFFFF8080nUI Debug:|r ".."ChocolateLowestTopBar Name = "..ChocolateLowestTopBar.settings.barName.."  Alpha = "..ChocolateLowestTopBar:GetAlpha(), 1, 0.83, 0 );
	end
	
	for i, v in ipairs(tempbottom) do
		ChocolateHighestBottomBar = v[1]
		--DEFAULT_CHAT_FRAME:AddMessage( "|cFFFF8080nUI Debug:|r ".."ChocolateHighestBottomBar Name = "..ChocolateHighestBottomBar.settings.barName.."  Alpha = "..ChocolateHighestBottomBar:GetAlpha(), 1, 0.83, 0 );
	end

	-- ChocolateLowestTopBar is located at the top of the screen

	nUI_TopBarsLocator:ClearAllPoints();
	
	if ChocolateLowestTopBar and ChocolateLowestTopBar:GetAlpha() > 0 then 
		nUI_TopBarsLocator:SetPoint( "BOTTOM", ChocolateLowestTopBar, "BOTTOM", 0, 0 );
	else
		nUI_TopBarsLocator:SetPoint( "BOTTOM", UIParent, "TOP", 0, 0 );
	end
	
	-- ChocolateHighestBottomBar is located at the bottom of the screen
	
	nUI_BottomBarsLocator:ClearAllPoints();	
	
	if ChocolateHighestBottomBar and ChocolateHighestBottomBar:GetAlpha() > 0 then
		nUI_BottomBarsLocator:SetPoint( "TOP", ChocolateHighestBottomBar, "TOP", 0, 0 );
	else
		nUI_BottomBarsLocator:SetPoint( "TOP", UIParent, "BOTTOM", 0, 0 );
	end
	
--	nUI_ProfileStop();
	
end

-------------------------------------------------------------------------------

local frame = CreateFrame( "Frame", "nUI_ChocolateBarEvents", WorldFrame )

local function onChocolateBarEvent()

--	nUI_ProfileStart( ProfileCounter, "onChocolateBarEvent", event );
	
	if event == "PLAYER_ENTERING_WORLD" then
		
		if IsAddOnLoaded( "ChocolateBar" ) then

			ChocolateBar = LibStub("AceAddon-3.0"):GetAddon("ChocolateBar");
			
			if ChocolateBar then
				
				ChocolateBar.nUI_AnchorBars	= ChocolateBar.AnchorBars;
		
				ChocolateBar.AnchorBars = function()
					--DEFAULT_CHAT_FRAME:AddMessage( "|cFFFF8080nUI Debug:|r ".."nUI ChocolateBar.AnchorBars() called", 1, 0.83, 0 );
					ChocolateBar:nUI_AnchorBars();
					DetectChocolateBar_Bars();
				end;
				
				DetectChocolateBar_Bars();
			end			
		end
		
		frame:UnregisterEvent( "PLAYER_ENTERING_WORLD" );
		
	end
	
--	nUI_ProfileStop();
	
end

frame:SetScript( "OnEvent", onChocolateBarEvent );
frame:RegisterEvent( "PLAYER_ENTERING_WORLD" );
