﻿--[[---------------------------------------------------------------------------

Copyright (c) 2008, 2009 by K. Scott Piel 
All Rights Reserved

E-mail: < kscottpiel@gmail.com >
Web:    < http://www.scottpiel.com >

This file is part of nUI.

	The copyright for all material provided within the nUI software package 
	("nUI") is held by Kenneth Scott Piel. Except as stated herein, none of 
	the material may be copied, reproduced, distributed, republished, 
	downloaded, displayed, posted or transmitted in any form or by any means, 
	including, but not limited to, electronic, mechanical, photocopying, 
	recording, or otherwise, without the prior written permission of 
	the copyright holder. Permission is granted to display, copy, distribute 
	and download the materials on this Site for personal, non-commercial use 
	only provided you do not modify the materials and that you retain all 
	copyright and other proprietary notices contained in the materials. You 
	also may not, without the copyright holder's permission, "mirror" any 
	material contained in nUI on any other server. This permission terminates 
	automatically if you breach any of these terms or conditions. Upon 
	termination, you will immediately destroy any downloaded and printed 
	materials. Any unauthorized use of any material contained in nUI may 
	violate copyright laws, trademark laws, the laws of privacy and publicity, 
	and communications regulations and statutes.
	
	nUI is packaged in four distributable versions known as "nUI Release",
	"nUI+", "nUI Development" and "nUI PTR Beta" -- Redistribution for these
	versions is governed by the following terms...
	
	1) Redistribution of the nUI Release (aka nUI Lite) version is permitted under 
	   the following terms... Permission is hereby	granted for unlimited free 
	   and open distribution of "nUI Release" / "nUI Lite" by anyone in any 
	   form and by any means provided the nUI Release distribution contents 
	   are not altered in any way, are distributed in full with all copyright 
	   statements and licensing terms included and intact and that any 
	   interface the end user is provided for the purpose of downloading nUI 
	   includes a plainly visible and functioning link to nUI's official web 
	   site at http://www.nUIaddon.com and a plainly visible notice that nUI 
	   accepts user donations with a working link to nUI's donation page at 
	   http://www.nUIaddon.com/donate.html
	   
	2) Permission is hereby granted for distribution of the "nUI+", "nUI+
	   Development" and "nUI+ PTR Beta" versions of nUI via the online download
	   service at http://www.wowinterface.com and the copyright holder's own
	   web site http://www.nuiaddon.com -- The end user is granted permission
	   to download any nUI package from these two web sites for their personal
	   use under the same terms and conditions as nUI Release but are prohibited
	   from sharing the contents of these packages via any means in any form
	   with anyone other than via direct transfer with immediate friends and
	   family members. Distribution of nUI+, nUI+ Development or nUI+ PTR Beta
	   via any other means by any other entity in any other form is strictly 
	   prohibited without the copyright holder's express written permission
	   explicitly granting such distribution rights specifically to that entity.
	   
	3) Deep-linking and leeching of nUI distributions is strictly prohibited. 
	   Any individual or entity who wishes to offer downloads of nUI 
	   distributions must either host the legal and unmodified distribution 
	   on their own servers to be distributed at their own expense using their 
	   own bandwidth or they must link the user back to the official download 
	   page on the third party provider's servers from which the user can 
	   initiate the download. Use of any download link or mechanism which 
	   initiates a download of any nUI distribution from a third party 
	   distribtion site that bypasses the official content and download pages 
	   or advertisements of that third party site is strictly prohibited
       without the express written consent of that site.
       
    See the included files "nUI_RELEASE_LICENSE.txt" and "nUI_PLUS_LICENSE.txt"
    for the complete terms of nUI's licensing terms.
	   
    nUI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    enclosed license for more details.
	
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

--]]---------------------------------------------------------------------------

if not nUI_MicroMenuOptions then nUI_MicroMenuOptions = {}; end
if not nUI_Profile then nUI_Profile = {}; end;

local CreateFrame = CreateFrame;

nUI_Profile.nUI_MicroMenu = {};

local ProfileCounter = nUI_Profile.nUI_MicroMenu;

-------------------------------------------------------------------------------
-- create the MicroMenu bar frame

local frame      = CreateFrame( "Frame", "nUI_MicroMenu", nUI_TopBars.Anchor );

frame.Buttons     = {};
frame.Buttons[1]  = _G["CharacterMicroButton"];
frame.Buttons[2]  = _G["SpellbookMicroButton"];
frame.Buttons[3]  = _G["TalentMicroButton"];
frame.Buttons[4]  = _G["AchievementMicroButton"];
frame.Buttons[5]  = _G["QuestLogMicroButton"];
frame.Buttons[6]  = _G["SocialsMicroButton"];
frame.Buttons[7]  = _G["PVPMicroButton"];
frame.Buttons[8]  = _G["LFGMicroButton"];
frame.Buttons[9]  = _G["LFDMicroButton"];
frame.Buttons[10] = _G["MainMenuMicroButton"];
frame.Buttons[11] = _G["HelpMicroButton"];

for i in pairs( nUI_MicroMenu.Buttons ) do
	
	button = frame.Buttons[i];
	
	button:SetParent( frame );

	button.nUI_CachedClearAllPoints = button.ClearAllPoints;
	button.nUI_CachedSetAllPoints   = button.SetAllPoints;
	button.nUI_CachedSetPoint       = button.SetPoint;
	button.nUI_CachedSetParent      = button.SetParent;

	button.ClearAllPoints = function() end;
	button.SetAllPoints   = function() end;
	button.SetPoint       = function() end;
	button.SetParent      = function() end;
	
end

nUI_MicroMenu = frame;

-------------------------------------------------------------------------------
-- set the size of the bar and its elements

nUI_MicroMenu.applyScale = function( scale )
	
--	nUI_ProfileStart( ProfileCounter, "applyScale" );
	
	local options  = frame.options;
	local anchor   = scale and frame.anchor or nil;	
	local scale    = scale or frame.scale or 1;
	local btn_size = options.btn_size * scale * nUI.vScale;
	local btn_gap  = options.btn_gap * scale * nUI.hScale;
		
	frame.scale = scale;

	if frame.btn_size ~= btn_size 
	or frame.btn_gap  ~= btn_gap
	then
			
		local last_button;
		local width = 0;
		
		for i in pairs(frame.Buttons) do
			
			local button    = frame.Buttons[i];
			local btnWidth  = button:GetWidth();
			local btn_scale = btn_size / btnWidth;
			
			if not first_button then first_button = button; end
			
			button:SetScale( btn_scale  );
			
			button:nUI_CachedClearAllPoints();
			
			if i == 1 then 
				width = (btnWidth+0.6) * btn_scale;
				button:nUI_CachedSetPoint( "BOTTOMLEFT", frame, "BOTTOMLEFT", 3 * scale * nUI.hScale, 3 * scale * nUI.vScale );				
			else 
				button:nUI_CachedSetPoint( "LEFT", last_button, "RIGHT", btn_gap, 0 );
				width = width + (btnWidth+0.6) * btn_scale + btn_gap;
			end
		
			last_button = button;
		end		

		frame:SetHeight( btn_size + 6 * scale * nUI.vScale );
		frame:SetWidth( width + 6 * scale * nUI.hScale );

	end
	
--	nUI_ProfileStop();
	
end

-------------------------------------------------------------------------------
-- set the location of the bar

nUI_MicroMenu.applyAnchor = function( anchor )
	
	if anchor or nUI_MicroMenu.anchor then
		
		local anchor      = anchor or nUI_MicroMenu.anchor;
		local xOfs        = (anchor.xOfs or 0) * nUI.hScale;
		local yOfs        = (anchor.yOfs or 0) * nUI.vScale;
		local anchor_pt   = anchor.anchor_pt or "CENTER";
		local relative_to = anchor.relative_to or nUI_MicroMenu:GetParent() or UIParent;
		local relative_pt = anchor.relative_pt or anchor_pt;
	
		nUI_MicroMenu.anchor = anchor;
		
		if nUI_MicroMenu.anchor_pt   ~= anchor.anchor_pt
		or nUI_MicroMenu.relative_to ~= anchor.relative_to
		or nUI_MicroMenu.relative_pt ~= anchor.relative_pt
		or nUI_MicroMenu.xOfs        ~= xOfs
		or nUI_MicroMenu.yOfs        ~= yOfs
		then
		
			nUI_MicroMenu.anchor_pt   = anchor.anchor_pt;
			nUI_MicroMenu.relative_to = anchor.relative_to;
			nUI_MicroMenu.realtive_pt = anchor.relative_pt;
			nUI_MicroMenu.xOfs        = xOfs;
			nUI_MicroMenu.yOfs        = yOfs;

			if nUI_MoverFrames[nUI_MicroMenu] then 
				nUI_MoverFrames[nUI_MicroMenu].ClearAllPoints( nUI_MicroMenu );
				nUI_MoverFrames[nUI_MicroMenu].SetPoint( nUI_MicroMenu, anchor_pt, relative_to, relative_pt, xOfs, yOfs );			
				
			else 
				nUI_MicroMenu:ClearAllPoints();
				nUI_MicroMenu:SetPoint( anchor_pt, relative_to, relative_pt, xOfs, yOfs );
			end
			
		end	
	end
end

-------------------------------------------------------------------------------
-- set the bar options

nUI_MicroMenu.applyOptions = function( options )
	
--	nUI_ProfileStart( ProfileCounter, "applyOptions" );
	
	if options then
		
		frame.options = options;
		
		nUI_MicroMenu:SetFrameStrata( options.strata or nUI_TopBars:GetFrameStrata() );
		nUI_MicroMenu:SetFrameLevel( options.layer or nUI_TopBars:GetFrameLevel()+2 );		

		if options.enabled ~= "no" then
			frame:Show();
		else
			frame:Hide();
		end
		
		if options.background then
			
			local backdrop_color = options.background.color.backdrop;
			local border_color   = options.background.color.border;
			
			frame:SetBackdrop( options.background.backdrop );
			frame:SetBackdropColor( backdrop_color.r, backdrop_color.g, backdrop_color.b, backdrop_color.a );
			frame:SetBackdropBorderColor( border_color.r, border_color.g, border_color.b, border_color.a );		
				
			for i in pairs( frame.Buttons ) do
				
				local button = frame.Buttons[i];
				
				button:SetFrameStrata( frame:GetFrameStrata() );
				button:SetFrameLevel( frame:GetFrameLevel()+1 );
				button:SetScale( options.btn_size / 36 );
			
			end
			
		else
			
			frame:SetBackdrop( nil );
			
		end
		
		frame.applyScale( options.scale or frame.scale or 1 );
	end
	
--	nUI_ProfileStop();
	
end

-------------------------------------------------------------------------------
-- bar event management

local function onMicroMenuEvent()

--	nUI_ProfileStart( ProfileCounter, "onMicroMenuEvent", event );
	
	if event == "ADDON_LOADED" then
		
		if arg1 == "nUI" then
			nUI:setScale();
			nUI_MicroMenu:configBar();
		end
	
	else
			
		if nUI_MoverFrames[frame] then nUI_Movers:lockFrame( frame, false ); end
		
		frame.applyOptions( nUI_MicroMenuOptions.options );
		frame.applyAnchor( nUI_MicroMenuOptions.anchor );
		
		nUI_Movers:lockFrame( frame, true, nUI_L["Micro-Menu"] );
		
		frame:UnregisterEvent( "PLAYER_ENTERING_WORLD" );
		
	end
	
--	nUI_ProfileStop();
	
end

frame:SetScript( "OnEvent", onMicroMenuEvent );
frame:RegisterEvent( "ADDON_LOADED" );
frame:RegisterEvent( "PLAYER_ENTERING_WORLD" );

-------------------------------------------------------------------------------

function nUI_MicroMenu:configBar( use_default )
	
--	nUI_ProfileStart( ProfileCounter, "configBar" );
	
	local default = nUI_DefaultConfig.MicroMenu;
	local config  = nUI_MicroMenuOptions or {};
	
	if not config.anchor then config.anchor = {}; end
	if not config.options then config.options = {}; end
	
	if use_default then
		
		config.anchor.anchor_pt   = default.anchor.anchor_pt;
		config.anchor.relative_to = default.anchor.relative_to;
		config.anchor.relative_pt = default.anchor.relative_pt;
		config.anchor.xOfs        = default.anchor.xOfs;
		config.anchor.yOfs        = default.anchor.yOfs;
		
		config.options.enabled  = default.options.enabled;
		config.options.strata   = default.options.strata;
		config.options.level    = default.options.level;
		config.options.scale    = default.options.scale;
		config.options.btn_size = default.options.btn_size;
		config.options.btn_gap  = default.options.btn_gap;

		if default.options.background then
			
			if not config.options.background then config.options.background = {}; end
			if not config.options.background.backdrop then config.options.background.backdrop = {}; end
			if not config.options.background.backdrop.insets then config.options.background.backdrop.insets = {}; end
			if not config.options.background.color then config.options.background.color = {}; end
			if not config.options.background.color.border then config.options.background.color.border = {}; end
			if not config.options.background.color.backdrop then config.options.background.color.backdrop = {}; end
			
			config.options.background.backdrop.bgFile   = default.options.background.backdrop.bgFile;
			config.options.background.backdrop.edgeFile = default.options.background.backdrop.edgeFile;
			config.options.background.backdrop.tile     = default.options.background.backdrop.tile;
			config.options.background.backdrop.tileSize = default.options.background.backdrop.tileSize;
			config.options.background.backdrop.edgeSize = default.options.background.backdrop.edgeSize;
			
			config.options.background.backdrop.insets.left   = default.options.background.backdrop.insets.left;
			config.options.background.backdrop.insets.right  = default.options.background.backdrop.insets.right;
			config.options.background.backdrop.insets.top    = default.options.background.backdrop.insets.top;
			config.options.background.backdrop.insets.bottom = default.options.background.backdrop.insets.bottom;
			
			config.options.background.color.border.r = default.options.background.color.border.r;
			config.options.background.color.border.g = default.options.background.color.border.g;
			config.options.background.color.border.b = default.options.background.color.border.b;
			config.options.background.color.border.a = default.options.background.color.border.a;
			
			config.options.background.color.backdrop.r = default.options.background.color.backdrop.r;
			config.options.background.color.backdrop.g = default.options.background.color.backdrop.g;
			config.options.background.color.backdrop.b = default.options.background.color.backdrop.b;
			config.options.background.color.backdrop.a = default.options.background.color.backdrop.a;
			
		else
			
			config.options.background = nil;
			
		end		
	else
		
		config.anchor.anchor_pt   = strupper( default.anchor.anchor_pt or config.anchor.anchor_pt );
		config.anchor.relative_to = default.anchor.relative_to or config.anchor.relative_to;
		config.anchor.relative_pt = strupper( default.anchor.relative_pt or config.anchor.relative_pt );
		config.anchor.xOfs        = tonumber( default.anchor.xOfs or config.anchor.xOfs );
		config.anchor.yOfs        = tonumber( default.anchor.yOfs or config.anchor.yOfs );
		
		config.options.enabled  = strlower( default.options.enabled or config.options.enabled );
		config.options.strata   = strupper( default.options.strata or config.options.strata );
		config.options.level    = tonumber( default.options.level or config.options.level );
		config.options.scale    = tonumber( default.options.scale or config.options.scale );
		config.options.btn_size = tonumber( default.options.btn_size or config.options.btn_size );
		config.options.btn_gap  = tonumber( default.options.btn_gap or config.options.btn_gap );

		if (not nUI_MicroMenuOptions and default.options.background)
		or (nUI_MicroMenuOptions and nUI_MicroMenuOptions.options.background)
		then
			
			if not config.options.background then config.options.background = {}; end
			if not config.options.background.backdrop then config.options.background.backdrop = {}; end
			if not config.options.background.backdrop.insets then config.options.background.backdrop.insets = {}; end
			if not config.options.background.color then config.options.background.color = {}; end
			if not config.options.background.color.border then config.options.background.color.border = {}; end
			if not config.options.background.color.backdrop then config.options.background.color.backdrop = {}; end
			
			config.options.background.backdrop.bgFile   = default.options.background.backdrop.bgFile or config.options.background.backdrop.bgFile;
			config.options.background.backdrop.edgeFile = default.options.background.backdrop.edgeFile or config.options.background.backdrop.edgeFile;
			config.options.background.backdrop.tile     = default.options.background.backdrop.tile or config.options.background.backdrop.tile;
			config.options.background.backdrop.tileSize = tonumber( default.options.background.backdrop.tileSize or config.options.background.backdrop.tileSize );
			config.options.background.backdrop.edgeSize = tonumber( default.options.background.backdrop.edgeSize or config.options.background.backdrop.edgeSize );
			
			config.options.background.backdrop.insets.left   = tonumber( default.options.background.backdrop.insets.left or config.options.background.backdrop.insets.left );
			config.options.background.backdrop.insets.right  = tonumber( default.options.background.backdrop.insets.right or config.options.background.backdrop.insets.right );
			config.options.background.backdrop.insets.top    = tonumber( default.options.background.backdrop.insets.top or config.options.background.backdrop.insets.top );
			config.options.background.backdrop.insets.bottom = tonumber( default.options.background.backdrop.insets.bottom or config.options.background.backdrop.insets.bottom );
			
			config.options.background.color.border.r = tonumber( default.options.background.color.border.r or config.options.background.color.border.r );
			config.options.background.color.border.g = tonumber( default.options.background.color.border.g or config.options.background.color.border.g );
			config.options.background.color.border.b = tonumber( default.options.background.color.border.b or config.options.background.color.border.b );
			config.options.background.color.border.a = tonumber( default.options.background.color.border.a or config.options.background.color.border.a );
			
			config.options.background.color.backdrop.r = tonumber( default.options.background.color.backdrop.r or config.options.background.color.backdrop.r );
			config.options.background.color.backdrop.g = tonumber( default.options.background.color.backdrop.g or config.options.background.color.backdrop.g );
			config.options.background.color.backdrop.b = tonumber( default.options.background.color.backdrop.b or config.options.background.color.backdrop.b );
			config.options.background.color.backdrop.a = tonumber( default.options.background.color.backdrop.a or config.options.background.color.backdrop.a );

		else
			
			config.options.background = nil;
			
		end
	end		
	
	nUI_MicroMenuOptions = config;

	frame.applyOptions( config.options );
	frame.applyAnchor( config.anchor );
	
--	nUI_ProfileStop();
	
end
