if select(2, UnitClass('player')) ~= "SHAMAN" then
	return
end
local _G = getfenv(0);
local BS = AceLibrary("Babble-Spell-2.2")
local AceOO = AceLibrary("AceOO-2.0");
if (not Yata.Class) then Yata.Class = {} end;
Yata.Class.Button = AceOO.Class("AceEvent-2.0");
Yata.Class.Button.virtual = true;
Yata.Class.IButton = AceOO.Interface{Assign = "function", Show = "function", Hide = "function"};
Yata.Class.ControlButton = AceOO.Class(Yata.Class.Button, Yata.Class.IButton);
Yata.Class.PopupButton = AceOO.Class(Yata.Class.Button, Yata.Class.IButton);
Yata.Class.Header = AceOO.Class();

---------------------------
-- Button Template stuff --
---------------------------

-- Show stuff
function Yata.Class.Button.prototype:Show()
	if(self.Frame) then self.Frame:Show(); end
end
-- Hide stuff
function Yata.Class.Button.prototype:Hide()
	if(self.Frame) then self.Frame:Hide(); end
end
function Yata.Class.Button.prototype:Assign(totem)
	if(self.Frame) then
		self.Icon = _G[self.Frame:GetName().."Icon"];
		self.Icon:SetTexture(totem.Texture);
		self.Totem = totem;
		self.Frame:SetAttribute("*type*", "spell");
		self.Frame:SetAttribute("spell1", self.Totem.Name);
		self.Frame:SetAttribute("spell2", BS["Totemic Call"]);
		if(#Yata.TotemData[totem.Name] > 1) then
			local rankone = (Yata.TotemData[totem.Name])[1];
			local spellName, spellRank = GetSpellName(rankone.SpellID, BOOKTYPE_SPELL);
			self.Frame:SetAttribute("shift-spell1",spellName.."("..spellRank..")");
		end
	end
end

function Yata.Class.Button.prototype:SetTooltip()
	local frame = self.Frame;
	if ( GetCVar("UberTooltips") == "1" ) then
		GameTooltip_SetDefaultAnchor(GameTooltip, frame);
	else
		GameTooltip:SetOwner(frame, "ANCHOR_RIGHT");
	end
	if(Yata.db.profile.ShortTooltip) then
		GameTooltip:SetText( self.Totem.Name, 1.0, 1.0, 1.0);
	else
		GameTooltip:SetSpell( self.Totem.SpellID, BOOKTYPE_SPELL );
	end
end

function Yata.Class.Button.prototype:init()
	Yata.Class.TotemBar.super.prototype.init(self);
	self:RegisterEvent("SPELL_UPDATE_USABLE", "UpdateUsableHandler");
end


-- same colors as Bartender3 for consistency reasons
function Yata.Class.Button.prototype:UpdateUsableHandler()
	if(not self.Totem) then return end;
	local usable, nomana = IsUsableSpell(self.Totem.Name);
	if(usable) then
		self.Icon:SetVertexColor(1.0,1.0,1.0);
	elseif(nomana) then
		self.Icon:SetVertexColor(0.1, 0.3, 1.0)
	else
		self.Icon:SetVertexColor(0.4,0.4,0.4);
	end
		
end

--------------------
-- Control Button --
--------------------
function Yata.Class.ControlButton.prototype:init(ID, header)
	Yata.Class.ControlButton.super.prototype.init(self);
	local buttonname = string.format("YATABUTTON%i",ID);
	self.Frame = _G[buttonname];
	if(not self.Frame) then
		self.Frame = CreateFrame("Button", buttonname, header.Frame, "ActionButtonTemplate,SecureActionButtonTemplate,SecureAnchorEnterTemplate");
	end
	self.ButtonID = ID;
	self.IsShown = true;
	self.Frame:RegisterForClicks("LeftButtonUp","RightButtonUp");
	self.Frame:RegisterForDrag( "LeftButton" );
	header.Frame:SetAttribute("AddChild",self.Frame);
	self.Frame:SetAttribute("showstates", "*");
	self.Frame:SetAttribute("delaystate", "0");
	self.Frame:SetAttribute("delaytime", "0.5");
	self.Frame:SetAttribute("delayhover", "any");
	self.Frame:SetAttribute("newstate", tostring(ID));
	self.Frame:SetAttribute("*childstate-OnEnter", "enter"..ID);
	self.Frame:SetAttribute("*childstate-OnLeave", "leave"..ID);
	self.Frame:SetAttribute("anchorchild", header.Frame);
	self.Frame:SetAttribute("childstate", "^" .. tostring(ID));
	self.Frame:SetScript("PostClick",function() self:TriggerEvent("Yata_ButtonClick",ID); end);
	self.Frame:SetScript("OnDragStart", function() Yata.TotemBar:ButtonDrag(true, ID); end);
	self.Frame:SetScript("OnReceiveDrag", function() Yata.TotemBar:ButtonDrag(nil, ID); end);
	self.Frame:HookScript("OnEnter", function() if(Yata:CheckShowToolTip()) then self:SetTooltip(ID) end end);
	self.Frame:HookScript("OnLeave", function() if(Yata:CheckShowToolTip()) then GameTooltip:Hide(); end end);
	self.Frame:SetToplevel(true);
	self.Frame:SetNormalTexture("");
	local NT = _G[buttonname.."NormalTexture"];
	NT:Hide();
end

-------------------
-- Popup Button --
-------------------


function Yata.Class.PopupButton.prototype:init(ID,header)
	Yata.Class.PopupButton.super.prototype.init(self);
	local buttonname = string.format("YATABUTTON%i",ID);
	self.Frame = _G[buttonname];
	if(not self.Frame) then
		self.Frame = CreateFrame("Button", buttonname, self.Header, "SecureActionButtonTemplate,ActionButtonTemplate");
	end
	self.ButtonID = ID;
	self.IsShown = true;
	self.Frame:RegisterForDrag( "LeftButton" );
	self.Frame:RegisterForClicks("LeftButtonUp","RightButtonUp");
	self.Frame:SetAttribute("showstates", math.floor(ID/10));
	self.Frame:SetAttribute("newstate", "0");
	self.Frame:SetScript("PostClick",function() self:TriggerEvent("Yata_ButtonClick",ID); end);
	self.Frame:SetScript("OnEnter", function() if(Yata:CheckShowToolTip()) then self:SetTooltip(ID) end end);
	self.Frame:SetScript("OnLeave", function() if(Yata:CheckShowToolTip()) then GameTooltip:Hide(); end end);
	self.Frame:SetScript("OnDragStart", function() Yata.TotemBar:ButtonDrag(true, ID); end);
	self.Frame:SetScript("OnReceiveDrag", function() Yata.TotemBar:ButtonDrag(nil, ID); end);
	self.Frame:SetToplevel(true);
	local border = _G[buttonname.."Border"];
	border:SetVertexColor(0, 1.0, 0, 0.5);
	header.Frame:SetAttribute("AddChild",self.Frame);
	self.Frame:SetNormalTexture("");
	local NT = _G[buttonname.."NormalTexture"];
	NT:Hide();
	self.Frame.VTexture = self.Frame:CreateTexture();
	self.Frame.VTexture:SetTexture(0, 0.5, 0, 0.5);
	self.Frame.VTexture:SetAllPoints(self.Frame);
	self.Frame.VTexture:Hide();
end

function Yata.Class.PopupButton.prototype:SetVisibility(state)
	local vtexture = self.Frame.VTexture;
	if(state) then
		vtexture:SetTexture(0.0, 0.5, 0.0, 0.5);
	else
		vtexture:SetTexture(0.5, 0, 0, 0.5);
	end
	if(state) then
		self.IsShown = true;
		self.Frame:SetAttribute("showstates", math.floor(self.ButtonID/10));
	else
		self.IsShown = false;
		self.Frame:SetAttribute("showstates", 100);
		
	end
end

------------
-- Header --
------------

function Yata.Class.Header.prototype:init()
	Yata.Class.Header.super.prototype.init(self);
	self.Frame = CreateFrame("Frame", "YATAHEADERFRAME",  UIParent, "SecureStateDriverTemplate");
	self.Frame:SetWidth(20);
	self.Frame:SetHeight(38);
	self.Frame.Texture = self.Frame:CreateTexture();
	self.Frame.Texture:SetTexture(0, 0, 0.5, 1);
	self.Frame.Texture:SetAllPoints(self.Frame);
	self.Frame.Texture:Hide();
	for i = 1, 4 do
		self.Frame:SetAttribute("statemap-anchor-enter"..i, "*:"..i);
		self.Frame:SetAttribute("statemap-anchor-leave"..i,      ";");
		self.Frame:SetAttribute("delaystatemap-anchor-leave"..i, i..":0");
		self.Frame:SetAttribute("delaytimemap-anchor-leave"..i,  i..":0.5");
		self.Frame:SetAttribute("delayhovermap-anchor-leave"..i, i..":true");
	end
	self.Frame:Show();
	self.Frame:RegisterForDrag( "LeftButton" );
	--[[
	function self.Frame:StateChanged(newState)
		Yata:Debug("State Changed: "..newState);
	end
	]]
end
