﻿-- Work_Complete (My First Addon)
-- Author: PunksNotDead on Quel'Thalas
-- Ver. 2014-06-04 lower case file extensions for Curse Client
-- Ver. 2014-06-03 TOC 5.04.00, Upgraded SVN 1.8.7.25475 & Update SVN Config, Force LF,EOL=Unix=Native
-- Ver. 2013-09-10 Updated TOC for 5.02.00 Patch dropped on 9/10/2013
-- Ver. 2013-08-11 svn:eol-style=native
-- Ver. 2013-05-21 Changed EOL Conversion to Unix/OSX
-- Ver. 2013-05-21 Updated TOC for 5.03.00 Patch dropped on 5/21/2013
-- Ver. 2013-03-27 UTF-8 BOM with Unix EOL
-- Ver. 2013-03-26 Changed Encoding to UTF-8 with BOM
-- Ver. 2013-03-06 Changed EOL Conversion to Unix/OSX for Client Status
-- Ver. 2013-03-05 Updated TOC for 5.02.00 Patch dropped on 03/05/2013
-- Ver. 2012-12-01 Updated TOC for 5.01.00 Patch dropped on 11/27/2012
-- Ver. 2012-08-29 Updated TOC for 5.00.04
--	 				New API GetNumGroupMembers() which replaces GetNumGroupMembers()
-- VER. 2012-01-06 Cleanup code & bug fix
-- ver. 2012-01-03 Fixed found bug with Grisly Trophy Option bit
-- ver. 2012-01-02 Added ByPass For DMF Grisly Trophy Quest 
-- ver. 2011-11-29 Updated TOC for 4.3
-- ver. 2011-07-10 Added an Options Page in the Blizz -Interface-Addons
--                 -- Added CheckBoxes to turn on or off chat and sound
--                 -- Added SavedVariables to retain selections
--                 -- first used of RGB colors.
--                 -- first use of structured variables
-- ver. 2011-06-30 Updated for 4.2 & TortoiseSVN Repo
-- Ver. 2011-06-13 Added Code to send Status To Party chat 
-- Ver. 2011-06-09 Removed PVPWarning @ Load
-- Ver. 2011-05-12 Original Code
--
-- LUA: Main Code, Events(API) & Functions
--
-- Create a new UI Frame in game for the Addon
-- newFrame = CreateFrame("frameType"[, "frameName"[, parentFrame[, "inheritsFrame"]]]);
local frmMyFrame = CreateFrame("Frame") -- Define a frame for WOW to interface with this code
local intUpdatedQuestIndex = nil   -- This will contain the quest ID # of the updated Quest
local SoundWorkComplete = "Sound\\Creature\\Peon\\PeonBuildingComplete1.wav"
local SoundReadyToWork =  "Sound\\Creature\\Peon\\PeonReady1.wav"
local PVPWarningHorde = "Sound\\Interface\\PVPWarningHordeMono.wav"
local PVPWarningAlliance = "Sound\\Interface\\PVPWarningAllianceMono.wav"
local ReadyCheck ="ReadyCheck"
local strMSG ="" -- holds the text from the Leader Board for an updated Quest
local strUISentMSG ="" -- holds the text sent by Wow User Interface
local True="1"
local False="0"
--
-- define colors using hex R,G,B in cffRRGGBB format
local myWhite = "|cffffffff"
local myRed   = "|cffff0000"
local myGreen = "|cff00ff00"
local myBlue  = "|cff0080ff"
local myYellow= "|cffffff00"
--
WorkComplete = {
	Defaults = {
	    OneShot = true;            -- 1-Shot
        PVPHorde = true;           -- PVPHorde;      
        PVPAlliance = false;       -- PVPAlliance;   
        SoundReady = true;         -- SoundReady;    
        SoloReady = true;          -- SoloReady;     
        PartyReady = true;         -- PartyReady;    
        SoundComplete = true;      -- SoundComplete; 
        SoloComplete = true;       -- SoloComplete;  
        PartyComplete = true;      -- PartyComplete;
        DMFTestYourStrength = true;-- DarkMoon Faire 250 Grisly Trophy
	}; -- End WorkComplete.Defaults.xxxx
    Options = {
        OneShot = nil;            -- 1-Shot
        PVPHorde = nil;           -- PVPHorde;      
        PVPAlliance = nil;        -- PVPAlliance;   
        SoundReady = nil;         -- SoundReady;    
        SoloReady = nil;          -- SoloReady;     
        PartyReady = nil;         -- PartyReady;    
        SoundComplete = nil;      -- SoundComplete; 
        SoloComplete = nil;       -- SoloComplete;  
        PartyComplete = nil;      -- PartyComplete;
        DMFTestYourStrength = nil; -- DarkMoon Faire 250 Grisly Trophy
	}; -- End WorkComplete.Options.xxxx
	strVersion = nil; -- Version number (text format)
};  -- End WorkComplete.xxxxx

WorkCompleteSaved = {};  --- This will be the data Referenced in the TOC, and Blizzard will save
--
--
-- Register Blizzard API Events for use & Display the Addon Loaded Text	
  --   Registers which events the object would like to monitor. 
  --   This ensures the code placed in the <OnEvent> section is not called for 
  --   any unneccessary events such as an incoming chat message when your addon 
  --   is only looking to perform actions based upon the start of casting a spell. 
  --   The last frame to register for an event is the last one to receive it.
  --   SYNTAX:    obj:RegisterEvent(event);  EX.  myChatAddon:RegisterEvent("CHAT_MSG");
  --
frmMyFrame:RegisterEvent("ADDON_LOADED");
  -- Fires when an addon and its saved variables are loaded. Fires once for each 
  -- addon (i.e. an addon loaded early in sequence will see ADDON_LOADED 
  -- events for all addons loaded later).
  --
frmMyFrame:RegisterEvent("VARIABLES_LOADED"); 
   --
frmMyFrame:RegisterEvent("PLAYER_LOGOUT"); --getting lua error for nil value 
  --
frmMyFrame:RegisterEvent("QUEST_LOG_UPDATE");
    -- This event is fired very often. This includes, but is not limited to: 
	-- viewing a quest for the first time in a session in the Quest Log; 
	-- (once for each quest?) every time the player changes zones across an 
	-- instance boundary; every time the player picks up a non-grey item; 
	-- every time after the player completes a quest goal, such as killing a mob for a quest. 
	-- It also fires whenever the player (or addon using the CollapseQuestHeader
	-- or ExpandQuestHeader() functions) collapses or expands any zone header in the quest log.  
    --
    
frmMyFrame:RegisterEvent("UI_INFO_MESSAGE");
	-- Fires when an informative message should be displayed. 
	-- e.g. "No fish are hooked", "You must be at least level 80 and in a raid group to enter this instance"
    -- Signature: ("message")
    -- Arguments: message - The message that needs to be displayed (string)
	--
	
frmMyFrame:RegisterEvent("QUEST_WATCH_UPDATE");
    -- Fires when the player's status regarding a quest's objectives changes, for instance 
    -- picking up a required object or killing a mob for that quest. All forms of (quest objective) 
    -- progress changes will trigger this event.
    --
   
frmMyFrame:SetScript("OnEvent", function(self, event, ...)
  if self[event] then return self[event](self, ...); end
end)
    -- Run script whenever an event fires for which the frame is registered. 
    -- In order for this script to be run, the frame must be registered for at 
    -- least one event via its :RegisterEvent() method
    --		OnEvent(self, "event", ...)
    --		Arguments:	
    --		          self - Reference to the widget for which the script was run (frame)
    --		          event - Name of the event (string)
    --		          ... - Arguments specific to the event (list)
    --		
--
-- Event Listing functions
--
--  
function frmMyFrame:ADDON_LOADED(arg1_name)

-- this function works once when this addon loads
    if arg1_name == "Work_Complete" then
        DEFAULT_CHAT_FRAME:AddMessage(myRed.."---["..myWhite.."Work_Complete"..myRed.."]---"..myYellow.." v:"..myGreen..GetAddOnMetadata("Work_Complete", "Version")..myWhite.." by "..myBlue.."PunksNotDead");
       --  
       -- check if this is the first time the variables have been loaded
       if (WorkCompleteSaved.OneShot == nil) then
         -- load the defaults
         WorkComplete.Options = WorkComplete.Defaults ;	
	 	 WorkCompleteSaved = WorkComplete.Options;     
	 	    -- print("[Debug Work Complete]----------------->Loaded Default Variables"); 
       else
         -- load the saved variables from the file
         WorkComplete.Options = WorkCompleteSaved;
         -- check if this is the first time for the latest option
         if (WorkComplete.Options.DMFTestYourStrength == nil) then
           WorkComplete.Options.DMFTestYourStrength = true
         end
           -- print("[Debug Work Complete]----------------->Loaded Saved File Variables");
           -- print(WorkComplete.Options.PVPHorde);      
           -- print(WorkComplete.Options.PVPAlliance);   
           -- print(WorkComplete.Options.SoundReady);    
           -- print(WorkComplete.Options.SoloReady);     
           -- print(WorkComplete.Options.PartyReady);    
           -- print(WorkComplete.Options.SoundComplete); 
           -- print(WorkComplete.Options.SoloComplete);  
           --print(WorkComplete.Options.PartyComplete); 
           --print(WorkComplete.Options.DMFTestYourStrength); 
           -- print("[Debug Work Complete]---------------->End of Saved Variables");
       end 
       ---
       if (WorkComplete.Options.PVPHorde) then
       	 PlaySoundFile(PVPWarningHorde);
       elseif (WorkComplete.Options.PVPAlliance) then
         PlaySoundFile(PVPWarningAlliance);
       end
       --
       --
       Work_Complete_OptionPanel()    -- Set up Interface Options Panel                                   
       WorkCompleteSetCheckBoxes()    -- Assign the Check Boxes to the Selected Options                                   
    end
end
--
function frmMyFrame:VARIABLES_LOADED(arg1_name)
  -- this function works once when the saved variables are loaded
  	if arg1_name == "Work_Complete" then
  	  -- print("Variables loaded Event fired");
    end
end 
--
function frmMyFrame:PLAYER_LOGOUT(arg1_name)
  -- this function works once when the saved variables are loaded
  --	if arg1_name == "Work_Complete" then
  WorkCompleteGetCheckBoxState()
end

--
--
-- When a message is output to the screen, the quest info obtained
-- from GetQuestLogTitle/GetQuestLogLeaderBoard isn't updated yet,
-- so we save it here and then look for it later in QUEST_LOG_UPDATE. 
-- This is slightly better than just checking for any changes
-- to previously-saved objectives in QUEST_LOG_UPDATE since it will only check 
-- if there has been recent info messages displayed,
-- and it only checks for exact string matches of the displayed message.
--
--
function frmMyFrame:UI_INFO_MESSAGE(arg)
	strUISentMSG=arg
	-- print("Debug 096="..strUISentMSG)
end
--
--
function frmMyFrame:QUEST_WATCH_UPDATE(questIndex)
 	intUpdatedQuestIndex = questIndex
 	-- This should contain the Quest number in your log Ex. the number 4
 	-- Would mean the 4th line of your quest log
 	-- print("Debug-104 UpdatedQuestIndex = "..intUpdatedQuestIndex);
end
--
--
function frmMyFrame:QUEST_LOG_UPDATE(...)
  local strMSG=""
  local bolByPassMSG = False
  if (strUISentMSG ~= nil) then 
    if intUpdatedQuestIndex then
      -- if (unitID == "player") then   
       -- This player's Quest Log has been Changed!
       local bolWorkComplete = nil
       -- set up the For loop to check 1 to the number of quest objectives for a quest in the player's quest log
       -- a quest may have more than one objective ( Kill 5 bears, Collect 10 Pelts)
       local intLastObjective = GetNumQuestLeaderBoards(intUpdatedQuestIndex) or 0
       		 --Returns the number of objectives for a given quest.
       		 --print("Debug 119 intLastObjective is below");
       		 --print (intLastObjective);
       for boardIndex = 1, intLastObjective  do
         -- bolByPassMSG = False
         -- This For Loop will examine each Objective for the Updated Quest Number
         --
         -- We use GetQuestLogTitle to find out if the Quest is Completed
         local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isQuestComplete, isDaily, questID = GetQuestLogTitle(intUpdatedQuestIndex);
           -- questTitle = string - The title of the quest, or nil if the index is out of range.
           -- level = Integer - The level of the quest
           -- questTag = string - Should be "Elite", "Dungeon", "PVP", "Raid", "Group", "Heroic" or nil (return value is #questTag).
           -- suggestedGroup = Integer - if questTag is GROUP, the positive number of players suggested for the quest or nil (added in 2.0.3)
           -- isHeader = Boolean - 1 if the entry is a header, nil otherwise.
           -- isCollapsed = Boolean - 1 if the entry is a collapsed header, nil otherwise.
           -- isQuestComplete = Integer - -1 if quest is (FAILED), +1 if quest is (COMPLETED), nil otherwise.
           -- isDaily = Integer - 1 if the quest is daily. (Added in 2.1.0). If questTag is not nil and isDaily is true, then the 
           -- quest tag in the QuestLogFrame will be displayed using DAILY_QUEST_TAG_TEMPLATE.
           -- questID = Integer - The quest identification number. 
                      --This is the number found in GetQuestsCompleted() after it has been completed. 
           --          
         -- we use GetQuestLogLeaderBoard to find out if a Quest Objective has been Fullfilled.
         local leaderboardTxt, itemType, isObjectiveDone = GetQuestLogLeaderBoard (boardIndex,intUpdatedQuestIndex);
       		 -- LeaderBoardTxt = String - The text description of the objective, like: "Jumbo Fish: 0/5"
       		 -- itemType = String - could be the following things: "item", "object", "monster", "reputation", "log", or "event".
       		 -- isDone = Boolean - nil=objective is not completed, or 1=Complete
         local i, j, itemName, numItems, numNeeded = string.find(leaderboardTxt, "(.*):%s*([%d]+)%s*/%s*([%d]+)");
         --print ("Debug:143 Leader board NEW debug update= ", leaderboardTxt, isDone,itemName, numItems, numNeeded);
         if (leaderboardTxt ~= nil) then
           strMSG = leaderboardTxt;
         end
         -- Now we have the string strMSG from the LeaderBoard, however, we may be looking
         --   at the wrong object.  Ex. Obj#1 =Kill 10 warriors & Obj#2= Kill 10 mages 
         --   So we will compare the Leaderboard Text to the Text that was captured from the
         --   UI_INFO_MESSAGE function and stored in the table WorkComplete_UI_Info_Message_Buffer
         	    --  print("Debug 254 strMSG="..strMSG)
         	    --  print("Debug 255 strUISentMSG="..strUISentMSG)
         -- check if this objective matches what was displayed
         --
         --- Modifications 1/6/2012
          local myStringFindCheck = string.find(strUISentMSG, "Grisly Trophy") 
          -- this will return an integer with the start of the pattern or nil
          if myStringFindCheck == nil then
          		-- print("Debug 264 - No Text Match")
          		bolByPassMSG = False; 
          else
          		-- 
          		if (WorkComplete.Options.DMFTestYourStrength==true) then  
		  	  		bolByPassMSG = True; 
		  	  		-- print("Debug 270 - Skip Ready to Work for Grisly Trophy")
		  	  	end	
          end
		 --- end Add 1/2/2012
         ---     
         ---
		 if ((strUISentMSG == strMSG) or (strUISentMSG == strMSG.." ("..COMPLETE..")")) then
		 	-- We have Matched the UI Message OutPut to the Quest Leader Board Change
		 	-- So we now know that we are dealing with the correct quest objective
		 	if (isQuestComplete) then
		 	   -- The Quest is Complete and we are done
		 	   PlaySoundFile(SoundWorkComplete);
		 	   PlaySound("QUESTCOMPLETED");
		 	   if (questTitle ~= nil) then
		 	     strMSG = ("Work Complete!: "..questTitle);
		 	       if (GetNumGroupMembers() > 0) then 
		 	         if (WorkComplete.Options.PartyComplete==true) then      
		 	   			SendChatMessage(strMSG, "PARTY")
		 	   		 end                                      
		 	       elseif (WorkComplete.Options.SoloComplete==true) then
		 	         DEFAULT_CHAT_FRAME:AddMessage(strMSG)
		 	       end
		 	   end
		 	elseif (isObjectiveDone) then
		 	   -- The Quest is not over - but we completed one of the objectives
		 	   PlaySoundFile(SoundWorkComplete);
		 	   if (strMSG ~= nil) then
		 	     strMSG = ("Work Complete!: "..strMSG);
		 	       if (GetNumGroupMembers() > 0) then 
		 	          if (WorkComplete.Options.PartyComplete==true) then
		 	   			SendChatMessage(strMSG, "PARTY")
		 	   		  end
		 	       elseif (WorkComplete.Options.SoloComplete==true) then
		 	         DEFAULT_CHAT_FRAME:AddMessage(strMSG)
		 	       end
		 	   end
		 	else
		 	     -- We have made quest objective progression only
		 	     --
		 	     if (bolByPassMSG==True) then      -- Check if bypass is set ex.Grisly Trophy Quest
		 	          -- print("[Debug 307]-------->Tested bolByPassMSG = true ")
		 	     	  -- Do Not Play or Write "Ready To Work
		 	     else 
		 	           if (WorkComplete.Options.SoundReady==true) then
                       	 PlaySoundFile(SoundReadyToWork);
                       end
                       if (strMSG ~= nil) then
                           strMSG = ("Ready To Work: "..strMSG);
                            if (GetNumGroupMembers() > 0) then
                              if (WorkComplete.Options.PartyReady==true) then
                       			SendChatMessage(strMSG, "PARTY")
                       	      end
                            elseif (WorkComplete.Options.SoloReady==true) then 
                             DEFAULT_CHAT_FRAME:AddMessage(strMSG)
                            end
                       end
                 end   
		 	end  
		 end	   
		end -- End For Loop
    end
  end -- End IF
  intUpdatedQuestIndex = nil
  strUISentMSG=""
end --End Function
-- 
--
-- panel.parent - string (optional)
--	Name of the parent of the AddOn or group of configuration options. 
--	This identifies "panel" as the child of another category.
--	If the parent category doesn't exist, "panel" will be displayed as a regular category.
--
-- panel.okay - function (optional)
--	This method will run when the player clicks "okay" in the Interface Options. 
--
-- panel.cancel - function (optional)
--	This method will run when the player clicks "cancel" in the Interface Options. 
--	Use this to revert their changes.
--
-- panel.default - function (optional)
--	This method will run when the player clicks "defaults". 
--	Use this to revert their changes to your defaults.
--
-- panel.refresh - function (optional)
--  This method will run when the Interface Options frame calls its OnShow function and after defaults
--  have been applied via the panel.default method described above.
--  Use this to refresh your panel's UI in case settings were changed without player interaction.
--
-- UI Option Panel Functions

function Work_Complete_OptionPanel()
-- local setting = "1";
  --[[ Create a frame to use as the panel ]] -- 
  -- The new Interface Options frame allows authors to place their configuration
  -- frames (aka "panels") alongside the panels for modifying the default UI.
  --
  local WCpanel = CreateFrame("FRAME", "ExamplePanel");
  -- panel.name - string (required)	
  WCpanel.name = "Work Complete";  --	This is the text that will display in the AddOn options list.
  -- Once a frame is ready to be used as a panel, it must be registered using the function
  -- InterfaceOptions_AddCategory, i.e. InterfaceOptions_AddCategory(panel)               
  InterfaceOptions_AddCategory(WCpanel);
  --
  ---                                                                                                                                                 
-- local VolumeText = WCpanel:CreateFontString("Work_Complete_Global_Text","ARTWORK","GameFontNormal");
-- VolumeText:SetPoint("TOPLEFT", 170, -195);
--
-- VolumeText:SetText("");                                                                                                                         
  --   
  --Signature:
  --                                                                                                              
  --fontstring = Frame:CreateFontString(["name" [, "layer" [, "inherits"]]])                                      
  --Arguments:                                                                                                                                                                                                                                                 
  ------  
  ----name - Global name for the new font string (string)
  ----layer - Graphic layer on which to create the font string; defaults to ARTWORK if not specified (string, layer)
  ----inherits - Name of a template from which the new front string should inherit (string)
 local strWork_Complete_Version = WCpanel:CreateFontString("varWork_Complete_Global_Text","ARTWORK","GameFontNormalLarge");                                           
 strWork_Complete_Version:SetPoint("TOPLEFT", 20, -5);                                                                                                
 strWork_Complete_Version:SetText("Work_Complete v:".. GetAddOnMetadata("Work_Complete", "Version"));  
 
 --   You can make a checkbox in WoW via the following commands:
 --     myCheckButton = CreateFrame("CheckButton", "myCheckButton_GlobalName", parentFrame, "ChatConfigCheckButtonTemplate")
 --  
 --   This is where you locate the checkbox relative to its parent frame. Coordinates are (0,0) is the top-left corner of 
 --   the parent, so a negative y-coordinate means down and positive x-coord means right.
 --     myCheckButton:SetPoint("TOPLEFT", 200, -65);
 --  You can reference the name of your Check Box either by writing it explicitly, or by making a function call. 
 --  Writing it explicitly "looks prettier", but might be confusing to anyone looking at your code, as the name for it seems made-up. 
 --  Note arg2 in the creation call. It is the same as what is below, but we have appended it with "Text". This is necessary, 
 --  I don't know why they didn't just set it up so you can do myCheckButton:Text, but we must work with what we're given.
 --  
 --    myCheckButton_GlobalNameText:SetText("CheckBox Name");
 --  Here is the code to do the exact same thing, but it's not explicitly written. This is (arguably) less confusing.
 --    getglobal(myCheckButton:GetName() .. 'Text'):SetText("CheckBox Name"); 
 --
 --  When mousing over your checkbox, you can have a tooltip appear, which is useful to describe the actions resulting from 
 --  clicking the checkbox, without putting it all in the name.
 --   myCheckButton.tooltip = "This is where you place MouseOver Text.";
 -- 
 if (myOptionTxt1 == nil) then
     myOptionTxt1 = WCpanel:CreateFontString( nil, "ARTWORK", "GameFontGreen" )
     myOptionTxt1:SetPoint( "TOPLEFT", 10, -30 )
     myOptionTxt1:SetText( "Play Sound when Addon is Loaded -------------------------------------------------------" )
 end
 if (myOptionBox01 == nil) then
    myOptionBox01 = CreateFrame("CheckButton", "globalVarWC_Opt1_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox01:SetPoint("TOPLEFT", 15, -40) 
    myOptionBox01:SetWidth(30)
    myOptionBox01:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox01:GetName().."Text"):SetText("Horde PVP Warning Sound");
    myOptionBox01.tooltip = "Plays the PVP warning sound if the Addon Successfully loads into memory";
 end
 -- Special Case Because Option 1 & 2 (Horde v Alliance) are complementary
  myOptionBox01:SetScript("OnClick", 
  function()
    if( myOptionBox01:GetChecked() ) then 
  		-- Horde Selected so De-Select Alliance regardless of where it is set
  		myOptionBox02:SetChecked(False)
    end -- Endif
  end);-- Function checkbox "onClick"
 -- 
 if (myOptionBox02 == nil) then
    myOptionBox02 = CreateFrame("CheckButton", "globalVarWC_Opt2_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox02:SetPoint("TOPLEFT", 300, -40) 
    myOptionBox02:SetWidth(30)
    myOptionBox02:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox02:GetName().."Text"):SetText("Alliance PVP Warning Sound");
    myOptionBox02.tooltip = "Plays the PVP warning sound if the Addon Successfully loads into memory";
 end
  -- Special Case Because Option 1 & 2 (Horde v Alliance) are complementary
  myOptionBox02:SetScript("OnClick", 
  function()
    if( myOptionBox02:GetChecked() ) then 
  		-- Alliance Selected so De-Select Horde regardless of where it is set
  		myOptionBox01:SetChecked(False)
    end -- Endif
  end); -- Function checkbox "onClick"
-- 
--- Quest Progression Option Bits
 if (myOptionTxt2 == nil) then
     myOptionTxt2 = WCpanel:CreateFontString( nil, "ARTWORK", "GameFontGreen" )
     myOptionTxt2:SetPoint( "TOPLEFT", 10, -100 )
     myOptionTxt2:SetText( "Quest Objective Progress --------------------------------------------------------------" )
 end
 if (myOptionBox03 == nil) then
    myOptionBox03 = CreateFrame("CheckButton", "globalVarWC_Opt3_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox03:SetPoint("TOPLEFT", 15, -110) 
    myOptionBox03:SetWidth(30)
    myOptionBox03:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox03:GetName().."Text"):SetText("Play Sound 'Ready To Work' when a quest objective is met.");
    myOptionBox03.tooltip = "Plays sound when a quest objective (item/kill/etc) is achieved.";
 end
  if (myOptionBox04 == nil) then
    myOptionBox04 = CreateFrame("CheckButton", "globalVarWC_Opt4_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox04:SetPoint("TOPLEFT", 15, -140) 
    myOptionBox04:SetWidth(30)
    myOptionBox04:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox04:GetName().."Text"):SetText("Solo: Write Quest Progress to Chat");
    myOptionBox04.tooltip = "UnCheck to reduce SPAM in Chat";
 end
 if (myOptionBox05 == nil) then
    myOptionBox05 = CreateFrame("CheckButton", "globalVarWC_Opt5_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox05:SetPoint("TOPLEFT", 300, -140) 
    myOptionBox05:SetWidth(30)
    myOptionBox05:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox05:GetName().."Text"):SetText("Party Chat: Write Progress when grouped");
    myOptionBox05.tooltip = "UnCheck to reduce SPAM in Party Chat";
 end
 ---
 --- Quest Complete Option Bits
 if (myOptionTxt3 == nil) then
     myOptionTxt3 = WCpanel:CreateFontString( nil, "ARTWORK", "GameFontGreen" )
     myOptionTxt3:SetPoint( "TOPLEFT", 10, -200 )
     myOptionTxt3:SetText( "Quest Completed! ----------------------------------------------------------------------" )
 end
 if (myOptionBox06 == nil) then
    myOptionBox06 = CreateFrame("CheckButton", "globalVarWC_Opt6_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox06:SetPoint("TOPLEFT", 15, -210) 
    myOptionBox06:SetWidth(30)
    myOptionBox06:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox06:GetName().."Text"):SetText("Play Sound 'Work Complete!' when a quest is completed.");
    myOptionBox06.tooltip = "If you are trying to un-Check this box then you probably don't want this Addon at all.";
    myOptionBox06:SetChecked()
    myOptionBox06:Disable()
    
 end
  if (myOptionBox07 == nil) then
    myOptionBox07 = CreateFrame("CheckButton", "globalVarWC_Opt7_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox07:SetPoint("TOPLEFT", 15, -240) 
    myOptionBox07:SetWidth(30)
    myOptionBox07:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox07:GetName().."Text"):SetText("Solo: Display message in Chat");
    myOptionBox07.tooltip = "UnCheck to reduce SPAM in Chat";
 end
 if (myOptionBox08 == nil) then
    myOptionBox08 = CreateFrame("CheckButton", "globalVarWC_Opt8_Button", WCpanel, "ChatConfigCheckButtonTemplate");
    myOptionBox08:SetPoint("TOPLEFT", 300, -240) 
    myOptionBox08:SetWidth(30)
    myOptionBox08:SetHeight(30)                                                                                                                                                                                           
    getglobal(myOptionBox08:GetName().."Text"):SetText("Party Chat: Display message grouped");
    myOptionBox08.tooltip = "UnCheck to reduce SPAM in Party Chat";
 end
 -- Added 1/2/2012
 ---
    --- Quest Complete Option Bits
    if (myOptionTxt4 == nil) then
        myOptionTxt4 = WCpanel:CreateFontString( nil, "ARTWORK", "GameFontGreen" )
        myOptionTxt4:SetPoint( "TOPLEFT", 10, -300 )
        myOptionTxt4:SetText( "Disable Specific Quest Objectives ----------------------------------------------------------------" )
    end
    if (myOptionBox09 == nil) then
       myOptionBox09 = CreateFrame("CheckButton", "globalVarWC_Opt9_Button", WCpanel, "ChatConfigCheckButtonTemplate");
       myOptionBox09:SetPoint("TOPLEFT", 15, -310) 
       myOptionBox09:SetWidth(30)
       myOptionBox09:SetHeight(30)                                                                                                                                                                                           
       getglobal(myOptionBox09:GetName().."Text"):SetText("Dark Moon Faire: Test Your Strength xxx/250 Grisly Trophy");
       myOptionBox09.tooltip = "UnCheck to show Grisly Trophy progression";
    end
 -- End Add 1/2/2012
 --
  
 
 ----------- About Display ---------------------------
 local myAboutTxt01 = WCpanel:CreateFontString("varWork_Complete_About01_Text","ARTWORK","GameFontGreen");                                           
 myAboutTxt01:SetPoint("TOPLEFT", 40, -450);                                                                                                
 myAboutTxt01:SetText("About:");  
 local myAboutTxt02 = WCpanel:CreateFontString("varWork_Complete_About02_Text","ARTWORK","GameFontNormalSmall");                                           
 myAboutTxt02:SetPoint("TOPLEFT", 20, -460);                                                                                                
 myAboutTxt02:SetText("Author:"..myBlue.." PunksNotDead");  
 local myAboutTxt03 = WCpanel:CreateFontString("varWork_Complete_About03_Text","ARTWORK","GameFontNormalSmall");                                           
 myAboutTxt03:SetPoint("TOPLEFT", 20, -470);                                                                                                
 myAboutTxt03:SetText("Credits:"..myWhite.." FlexYourHead, VooDooMon, Matsu, Probie");  
 local myAboutTxt04 = WCpanel:CreateFontString("varWork_Complete_About04_Text","ARTWORK","GameFontNormalSmall");                                           
 myAboutTxt04:SetPoint("TOPLEFT", 20, -480);                                                                                                
 myAboutTxt04:SetText("WebSite:"..myWhite.." www.SevenYearOldTwinkies.com"); 
 local myAboutTxt05 = WCpanel:CreateFontString("varWork_Complete_About53_Text","ARTWORK","GameFontNormalSmall");                                           
 myAboutTxt05:SetPoint("TOPLEFT", 20, -490);                                                                                                
 myAboutTxt05:SetText("License:"..myWhite.." All rights reserved (See license.txt)"); 
 
 
  ---
 --- WorkCompleteSetCheckBoxes()
 --- Option Panel Control Buttons from Blizzard
    WCpanel.okay =
	  function(self)   
	  	    WorkCompleteGetCheckBoxState()
    end       
	---
	WCpanel.cancel = function (self)
			-- Do Nothing
	  end
	---
	WCpanel.default =
	  function (self)
	  	-- The Default is all options Checked + Horde Startup Sound
	  	WorkCompleteLoadDefault()   
	  end                 	    
	 ---
end -- End Function Work_Complete_OptionPanel()

function WorkCompleteLoadDefault()
   -- Set The Options = Defaults 
   -- by Setting the Check box state
           myOptionBox01:SetChecked(True)  
           myOptionBox02:SetChecked(False) 
           myOptionBox03:SetChecked(True)  
           myOptionBox04:SetChecked(True)  
           myOptionBox05:SetChecked(True)  
           myOptionBox06:SetChecked(True)  
           myOptionBox06:Disable()         
           myOptionBox07:SetChecked(True)  
           myOptionBox08:SetChecked(True)  
           myOptionBox09:SetChecked(True)
   WorkCompleteGetCheckBoxState()
end -- Function WorkCompleteLoadDefault()   
 
function WorkCompleteGetCheckBoxState()
  -- Get the state of the check boxes and update the Option.bits
    if (myOptionBox01:GetChecked()) then  WorkComplete.Options.PVPHorde = true; else  WorkComplete.Options.PVPHorde = false; end
    if (myOptionBox02:GetChecked()) then  WorkComplete.Options.PVPAlliance = true; else  WorkComplete.Options.PVPAlliance = false; end
    if (myOptionBox03:GetChecked()) then  WorkComplete.Options.SoundReady = true; else  WorkComplete.Options.SoundReady = false; end
    if (myOptionBox04:GetChecked()) then  WorkComplete.Options.SoloReady = true; else  WorkComplete.Options.SoloReady = false; end
    if (myOptionBox05:GetChecked()) then  WorkComplete.Options.PartyReady = true; else  WorkComplete.Options.PartyReady = false; end
    if (myOptionBox06:GetChecked()) then  WorkComplete.Options.SoundComplete = true; else  WorkComplete.Options.SoundComplete = false; end
    if (myOptionBox07:GetChecked()) then  WorkComplete.Options.SoloComplete = true; else  WorkComplete.Options.SoloComplete = false; end      
    if (myOptionBox08:GetChecked()) then  WorkComplete.Options.PartyComplete = true; else  WorkComplete.Options.PartyComplete = false; end  
    if (myOptionBox09:GetChecked()) then  WorkComplete.Options.DMFTestYourStrength = true; else  WorkComplete.Options.DMFTestYourStrength = false; end
       -- print ("[Debug Work Complete] Options obtained from checkboxes");
    -- print(WorkComplete.Options.PVPHorde);     
    -- print(WorkComplete.Options.PVPAlliance);  
    -- print(WorkComplete.Options.SoundReady);   
    -- print(WorkComplete.Options.SoloReady);    
    -- print(WorkComplete.Options.PartyReady);   
    -- print(WorkComplete.Options.SoundComplete);
    -- print(WorkComplete.Options.SoloComplete); 
    -- print(WorkComplete.Options.PartyComplete); 
   WorkCompleteSaved = WorkComplete.Options;
end -- function WorkCompleteGetCheckBoxState()

function WorkCompleteSetCheckBoxes()
  -- this Function sets the Checkboxes State equal to WorkComplete.Options
  getglobal("myOptionBox01"):SetChecked(WorkComplete.Options.PVPHorde);     
  getglobal("myOptionBox02"):SetChecked(WorkComplete.Options.PVPAlliance);  
  getglobal("myOptionBox03"):SetChecked(WorkComplete.Options.SoundReady);   
  getglobal("myOptionBox04"):SetChecked(WorkComplete.Options.SoloReady);    
  getglobal("myOptionBox05"):SetChecked(WorkComplete.Options.PartyReady);   
  getglobal("myOptionBox06"):SetChecked(WorkComplete.Options.SoundComplete);
  getglobal("myOptionBox07"):SetChecked(WorkComplete.Options.SoloComplete); 
  getglobal("myOptionBox08"):SetChecked(WorkComplete.Options.PartyComplete);
  getglobal("myOptionBox09"):SetChecked(WorkComplete.Options.DMFTestYourStrength);
end -- function WorkCompleteSetCheckBoxes()
