﻿-- WoWEquip data file

local L = WoWEquip_Localization


-- The following strings are displayed in the Key Bindings
BINDING_HEADER_WOWEQUIP			= L["WOW_EQUIP_VERSION_TEXT"]
BINDING_NAME_WOWEQUIP_TOGGLE		= L["Show/Hide WoWEquip"]
BINDING_NAME_WOWEQUIP_INSPECT		= L["Inspect & Copy Target"]


-- IMPORTANT NOTE:
-- Note that the ordering of subtables in a table directly determines the order in which the menuitems appear.
-- Reordering them is allowed, but changing the id is not!

-- The following strings are used for the Item Bonus Summary category titles
WoWEquip_IBonusCatTitles = {
	L["Base Stats"],	-- 1
	L["Defenses"],		-- 2
	L["Combat"],		-- 3
	L["Spells"],		-- 4
	L["Health and Mana"],	-- 5
	L["Resistances"],	-- 6
	L["Gems"],		-- 7
	L["Others"],		-- 8
}

-- Item Bonus Summary
-- The next part of the file deals with the tables for the Item Bonus Summary
-- id	= is the category ID this stat should display under. -1 indicates not to display.
-- t	= is the text displayed.
-- r	= the BONUSID to send to StatLogic:GetEffectFromRating(), 'true' means use the key as the string.
-- p	= whether to display a % sign for the converted effect.
-- The index strings are taken from ItemBonusLib-1.0.lua
WoWEquip_IBonusData = {
	STR	= {id = 1, t = L["Strength"]},
	AGI	= {id = 1, t = L["Agility"]},
	STA	= {id = 1, t = L["Stamina"]},
	INT	= {id = 1, t = L["Intellect"]},
	SPI	= {id = 1, t = L["Spirit"]},
	ARMOR	= {id = 2, t = L["Armor"]},
	BASE_ARMOR	= {id = -1, t = L["Base Armor"]},
	ARMOR_BONUS	= {id = -1, t = L["Armor Bonus"]},

	ARCANERES	= {id = 6, t = L["Arcane Resistance"]},
	FIRERES		= {id = 6, t = L["Fire Resistance"]},
	NATURERES	= {id = 6, t = L["Nature Resistance"]},
	FROSTRES	= {id = 6, t = L["Frost Resistance"]},
	SHADOWRES	= {id = 6, t = L["Shadow Resistance"]},

	FISHING		= {id = 8, t = L["Fishing"]},
	MINING		= {id = 8, t = L["Mining"]},
	HERBALISM	= {id = 8, t = L["Herbalism"]},
	SKINNING	= {id = 8, t = L["Skinning"]},

	DEFENSE		= {id = 2, t = L["Defense"]},
	BLOCK		= {id = 2, t = L["Chance to Block"],		p = true},
	BLOCKVALUE	= {id = 2, t = L["Block value"]},
	DODGE		= {id = 2, t = L["Dodge"],			p = true},
	PARRY		= {id = 2, t = L["Parry"],			p = true},

	ATTACKPOWER		= {id = 3, t = L["Attack Power"]},
	ATTACKPOWERUNDEAD	= {id = 3, t = L["Attack Power (vs Ud)"]},
	ATTACKPOWERFERAL	= {id = 3, t = L["Attack Power (Feral)"]},
	CRIT			= {id = 3, t = L["Chance to Crit"],	p = true},
	RANGEDATTACKPOWER	= {id = 3, t = L["R. Attack Power"]},
	RANGEDCRIT		= {id = 3, t = L["Ranged Crit"], 	p = true},
	TOHIT			= {id = 3, t = L["Chance to Hit"],	p = true},
	IGNOREARMOR		= {id = 3, t = L["Ignore Armor"]},
	RANGEDTOHIT		= {id = 3, t = L["Ranged Hit"],		p = true},

	DMG		= {id = 4, t = L["Spell Damage"]},
	DMGUNDEAD	= {id = 4, t = L["Spell Damage (vs Ud)"]},
	SPELLCRIT	= {id = 4, t = L["Spell Crit"],			p = true},
	SPELLTOHIT	= {id = 4, t = L["Spell Hit"],			p = true},
	SPELLPEN	= {id = 4, t = L["Spell Penetration"]},
	HEAL		= {id = 4, t = L["Healing"]},

	ARCANEDMG	= {id = 4, t = L["Arcane Damage"]},
	FIREDMG		= {id = 4, t = L["Fire Damage"]},
	FROSTDMG	= {id = 4, t = L["Frost Damage"]},
	HOLYDMG		= {id = 4, t = L["Holy Damage"]},
	NATUREDMG	= {id = 4, t = L["Nature Damage"]},
	SHADOWDMG	= {id = 4, t = L["Shadow Damage"]},

	ARCANECRIT	= {id = 4, t = L["Spell Crit (Arcane)"],	p = true},
	FIRECRIT	= {id = 4, t = L["Spell Crit (Fire)"],		p = true},
	FROSTCRIT	= {id = 4, t = L["Spell Crit (Frost)"],		p = true},
	HOLYCRIT	= {id = 4, t = L["Spell Crit (Holy)"],		p = true},
	NATURECRIT	= {id = 4, t = L["Spell Crit (Nature)"],	p = true},
	SHADOWCRIT	= {id = 4, t = L["Spell Crit (Shadow)"],	p = true},

	ARCANEHIT	= {id = 4, t = L["Spell Hit (Arcane)"],		p = true},
	FIREHIT		= {id = 4, t = L["Spell Hit (Fire)"],		p = true},
	FROSTHIT	= {id = 4, t = L["Spell Hit (Frost)"],		p = true},
	HOLYHIT		= {id = 4, t = L["Spell Hit (Holy)"],		p = true},
	NATUREHIT	= {id = 4, t = L["Spell Hit (Nature)"],		p = true},
	SHADOWHIT	= {id = 4, t = L["Spell Hit (Shadow)"],		p = true},

	HEALTHREG	= {id = 5, t = L["Life Regeneration"]},
	MANAREG		= {id = 5, t = L["Mana Regeneration"]},
	HEALTH		= {id = 5, t = L["Life Points"]},
	MANA		= {id = 5, t = L["Mana Points"]},

	CR_WEAPON		= {id = 3, t = L["Weapon rating"],		r = "WEAPON_RATING"},
	CR_DEFENSE		= {id = 2, t = L["Defense rating"],		r = "DEFENSE_RATING"},
	CR_DODGE		= {id = 2, t = L["Dodge rating"],		r = "DODGE_RATING",		p = true},
	CR_PARRY		= {id = 2, t = L["Parry rating"],		r = "PARRY_RATING",		p = true},
	CR_BLOCK		= {id = 2, t = L["Block rating"],		r = "BLOCK_RATING",		p = true},
	CR_HIT			= {id = 3, t = L["Hit rating"],			r = "MELEE_HIT_RATING",		p = true},
	CR_CRIT			= {id = 3, t = L["Crit rating"],		r = "MELEE_CRIT_RATING",	p = true},
	CR_RANGEDHIT		= {id = 3, t = L["R. Hit rating"],		r = "RANGED_HIT_RATING",	p = true},
	CR_RANGEDCRIT		= {id = 3, t = L["R. Crit rating"],		r = "RANGED_CRIT_RATING",	p = true},
	CR_HASTE		= {id = 3, t = L["Haste rating"],		r = "MELEE_HASTE_RATING",	p = true},
	CR_SPELLHIT		= {id = 4, t = L["Spell Hit rating"],		r = "SPELL_HIT_RATING",		p = true},
	CR_SPELLCRIT		= {id = 4, t = L["Spell Crit rating"],		r = "SPELL_CRIT_RATING",	p = true},
	CR_SPELLHASTE		= {id = 4, t = L["Spell Haste rating"],		r = "SPELL_HASTE_RATING",	p = true},
	CR_RESILIENCE		= {id = 2, t = L["Resilience"],			r = "RESILIENCE_RATING",	p = true},
	CR_WEAPON_AXE		= {id = 3, t = L["Axe skill rating"],		r = "AXE_WEAPON_RATING"},
	CR_WEAPON_DAGGER	= {id = 3, t = L["Dagger skill rating"],	r = "DAGGER_WEAPON_RATING"},
	CR_WEAPON_MACE		= {id = 3, t = L["Mace skill rating"],		r = "MACE_WEAPON_RATING"},
	CR_WEAPON_SWORD		= {id = 3, t = L["Sword skill rating"],		r = "SWORD_WEAPON_RATING"},
	CR_WEAPON_SWORD_2H	= {id = 3, t = L["2H-Swords skill rating"],	r = "2H_SWORD_WEAPON_RATING"},

	SNARERES		= {id = 6, t = L["Snare/Root Resistance"]},

	-- The remainder of these aren't translated in ItemBonusLib
	CR_WEAPON_FERAL		= {id = 3, t = L["Feral Combat s. rating"],	r = "FERAL_WEAPON_RATING"},

	CR_WEAPON_AXE_2H	= {id = 3, t = L["2H-Axe skill rating"],	r = "2H_AXE_WEAPON_RATING"},
	CR_WEAPON_MACE_2H	= {id = 3, t = L["2H-Mace skill rating"],	r = "2H_MACE_WEAPON_RATING"},
	CR_WEAPON_FIST		= {id = 3, t = L["Fist skill rating"],		r = "FIST_WEAPON_RATING"},
	CR_WEAPON_STAFF		= {id = 3, t = L["Staff skill rating"],		r = "STAFF_WEAPON_RATING"},
	CR_WEAPON_GUN		= {id = 3, t = L["Gun skill rating"],		r = "GUN_WEAPON_RATING"},
	CR_WEAPON_BOW		= {id = 3, t = L["Bow skill rating"],		r = "BOW_WEAPON_RATING"},
	CR_WEAPON_CROSSBOW	= {id = 3, t = L["Crossbow skill rating"],	r = "CROSSBOW_WEAPON_RATING"},
	CR_EXPERTISE		= {id = 3, t = L["Expertise rating"], 		r = "EXPERTISE_RATING"},

	THREATREDUCTION		= {id = 8, t = L["Threat Reduction (%)"]},
	MELEEDMG		= {id = -1, t = L["Summed Melee Damage"]},

	CASTINGREG		= {id = 5, t = L["Mana Regen w/casting (%)"]},
	NATURECRIT		= {id = 4, t = L["Spell Crit (Nature)"]},
	CASTINGREGROWTH		= {id = -1, t = "-Cast (Regrowth)"},
	CASTINGHOLYLIGHT	= {id = -1, t = "-Cast (Holy Light)"},
	CASTINGHEALINGTOUCH	= {id = -1, t = "-Cast (Healing Touch)"},
	CASTINGFLASHHEAL	= {id = -1, t = "-Cast (Flash Heal)"},
	CASTINGCHAINHEAL	= {id = -1, t = "-Cast (Chain Heal)"},
	DURATIONREJUV		= {id = -1, t = "+Dur (Rejuvenation)"},
	DURATIONRENEW		= {id = -1, t = "+Dur (Renew)"},
	MANAREGNORMAL		= {id = -1, t = "Normal Life/Mana Regen"},
	IMPCHAINHEAL		= {id = -1, t = "Healing (Chain Heal)"},
	IMPREJUVENATION		= {id = -1, t = "Healing (Rejuvenation)"},
	IMPLESSERHEALINGWAVE	= {id = -1, t = "Healing (L.H. Wave)"},
	IMPFLASHOFLIGHT		= {id = -1, t = "Healing (Flash of Light)"},
	REFUNDHEALINGWAVE	= {id = -1, t = "Refund % mana (H. Wave)"},
	JUMPHEALINGWAVE		= {id = -1, t = "-% Heal/jump (H. Wave)"},
	CHEAPERDRUID		= {id = -1, t = "-% Mana (HT/Rg/Rej/Tr)"},
	REFUNDHTCRIT		= {id = -1, t = "Refund % mana (HT)"},
	CHEAPERRENEW		= {id = -1, t = "-% Mana (Renew)"},

	HEALTHREG_P		= {id = 5, t = L["Normal Health Regen"]},
	RUNSPEED		= {id = 8, t = L["Run Speed %"]},
	MOUNTSPEED		= {id = 8, t = L["Mount Speed %"]},
	SWIMSPEED		= {id = 8, t = L["Swim Speed %"]},
	STEALTH			= {id = 8, t = L["Stealth %"]},
	RANGED_SPEED_BONUS	= {id = 8, t = L["Ranged Speed Bonus %"]},
	NEGPARRY		= {id = 8, t = L["Less Parry %"]},
	STUNRESIST		= {id = 6, t = L["Stun Resistance %"]},
	FEARRESIST		= {id = 6, t = L["Fear Resistance %"]},
	DISORIENTRESIST		= {id = 6, t = L["Disorient Resistance %"]},
	MELEETAKEN		= {id = 8, t = L["Less Melee Dmg Taken"]},
	DMGTAKEN		= {id = 8, t = L["Less Spell Dmg Taken"]},
	UNDERWATER		= {id = 8, t = L["Underwater Breathing"]},
	LOCKPICK		= {id = 8, t = L["Lockpicking"]},
	STEALTHDETECT		= {id = 8, t = L["Stealth Detection"]},
	DISARMIMMUNE		= {id = 8, t = L["Disarm Immune"]},
	SLOWFALL		= {id = 8, t = L["Less Falling Damage %"]},
	IMPRESS			= {id = 8, t = L["Impress Others!"]},
	MOJO			= {id = 8, t = L["Mojo!"]},
	EMPTY_SOCKET_BLUE	= {id = 7, t = L["Empty Blue Socket"]},
	EMPTY_SOCKET_META	= {id = 7, t = L["Empty Meta Socket"]},
	EMPTY_SOCKET_RED	= {id = 7, t = L["Empty Red Socket"]},
	EMPTY_SOCKET_YELLOW	= {id = 7, t = L["Empty Yellow Socket"]},

	-- Added for manual counting of socketed gem colors
	BLUE_GEM	= {id = 7, t = L["Blue Gems"]},
	META_GEM	= {id = 7, t = L["Meta Gems"]},
	RED_GEM		= {id = 7, t = L["Red Gems"]},
	YELLOW_GEM	= {id = 7, t = L["Yellow Gems"]},

	SPELLCRITDMG = {id = -1, t = "+% Spell Critical Damage"},
	CRITDMG = {id = -1, t = "+% Critical Damage"},

	--[[
	-- These are for StatLogicLib-1.0
	ARCANE_RES	= {id = 6, t = "Arcane Resistance"},
	FIRE_RES	= {id = 6, t = "Fire Resistance"},
	NATURE_RES	= {id = 6, t = "Nature Resistance"},
	FROST_RES	= {id = 6, t = "Frost Resistance"},
	SHADOW_RES	= {id = 6, t = "Shadow Resistance"},

	BLOCK_VALUE	= {id = 2, t = "Block value"},

	AP		= {id = 3, t = "Attack Power"},
	AP_UNDEAD	= {id = 3, t = "Attack Power (vs Ud)"},
	AP_DEMON	= {id = 3, t = "Attack Power (vs Demon)"},
	FERAL_AP	= {id = 3, t = "Attack Power (Feral)"},
	RANGED_AP	= {id = 3, t = "Ranged Attack Power"},

	HEALTH_REG	= {id = 5, t = "Life Regeneration"},
	MANA_REG	= {id = 5, t = "Mana Regeneration"},

	SPELL_DMG		= {id = 4, t = "Spell Damage"},
	ARCANE_SPELL_DMG	= {id = 4, t = "Arcane Damage"},
	FIRE_SPELL_DMG		= {id = 4, t = "Fire Damage"},
	FROST_SPELL_DMG		= {id = 4, t = "Frost Damage"},
	HOLY_SPELL_DMG		= {id = 4, t = "Holy Damage"},
	NATURE_SPELL_DMG	= {id = 4, t = "Nature Damage"},
	SHADOW_SPELL_DMG	= {id = 4, t = "Shadow Damage"},
	SPELL_DMG_UNDEAD	= {id = 4, t = "Spell Damage (vs Ud)"},

	DPS			= {id = -1, t = "Damage per Second"},

	WEAPON_RATING		= {id = 3, t = "Weapon rating",		r = true},
	DEFENSE_RATING		= {id = 2, t = "Defense rating",	r = true},
	DODGE_RATING		= {id = 2, t = "Dodge rating",		r = true,	p = true},
	PARRY_RATING		= {id = 2, t = "Parry rating",		r = true,	p = true},
	BLOCK_RATING		= {id = 2, t = "Block rating",		r = true,	p = true},
	MELEE_HIT_RATING	= {id = 3, t = "Hit rating",		r = true,	p = true},
	MELEE_CRIT_RATING	= {id = 3, t = "Crit rating",		r = true,	p = true},
	MELEE_HASTE_RATING	= {id = 3, t = "Haste rating",		r = true,	p = true},
	RANGED_HIT_RATING	= {id = 3, t = "Ranged Hit rating",	r = true,	p = true},
	  RANGED_HASTE_RATING	= {id = 3, t = "Ranged Haste rating",	r = true,	p = true},
	RANGED_CRIT_RATING	= {id = 3, t = "Ranged Crit rating",	r = true,	p = true},
	SPELL_HIT_RATING	= {id = 4, t = "Spell Hit rating",	r = true,	p = true},
	SPELL_CRIT_RATING	= {id = 4, t = "Spell Crit rating",	r = true,	p = true},
	SPELL_HASTE_RATING	= {id = 4, t = "Spell haste rating",	r = true,	p = true},
	RESILIENCE_RATING	= {id = 2, t = "Resilience",		r = true,	p = true},
	AXE_WEAPON_RATING	= {id = 3, t = "Axe skill ratin	g",	r = true},
	DAGGER_WEAPON_RATING	= {id = 3, t = "Dagger skill rating",	r = true},
	MACE_WEAPON_RATING	= {id = 3, t = "Mace skill rating",	r = true},
	SWORD_WEAPON_RATING	= {id = 3, t = "Sword skill rating",	r = true},
	["2H_SWORD_WEAPON_RATING"]	= {id = 3, t = "2H-Swords skill rating",	r = true},
	  MELEE_HIT_AVOID_RATING	= {id = 2, t = "Hit Avoidance rating",		r = true,	p = true},
	  RANGED_HIT_AVOID_RATING	= {id = 2, t = "R. Hit Avoidance rating",	r = true,	p = true},
	  SPELL_HIT_AVOID_RATING	= {id = 2, t = "S. Hit Avoidance rating",	r = true,	p = true},
	  MELEE_CRIT_AVOID_RATING	= {id = 2, t = "Crit Avoidance rating",		r = true,	p = true},
	  RANGED_CRIT_AVOID_RATING	= {id = 2, t = "R. Crit Avoidance rating",	r = true,	p = true},
	  SPELL_CRIT_AVOID_RATING	= {id = 2, t = "S. Crit Avoidance rating",	r = true,	p = true},
	FERAL_WEAPON_RATING		= {id = 3, t = "Feral Combat s. rating",	r = true},
	["2H_AXE_WEAPON_RATING"]	= {id = 3, t = "2H-Axe skill rating",		r = true},
	["2H_MACE_WEAPON_RATING"]	= {id = 3, t = "2H-Mace skill rating",		r = true},
	FIST_WEAPON_RATING		= {id = 3, t = "Fist skill rating",		r = true},
	--CR_WEAPON_STAFF		= {id = 3, t = "Staff skill rating",		r = true},
	GUN_WEAPON_RATING		= {id = 3, t = "Gun skill rating",		r = true},
	BOW_WEAPON_RATING		= {id = 3, t = "Bow skill rating",		r = true},
	CROSSBOW_WEAPON_RATING		= {id = 3, t = "Crossbow skill rating",		r = true},

	MAX_DAMAGE	= {id = -1, t = "Summed Max Damage"},
	RUN_SPEED	= {id = 8, t = "Run Speed %"},
	MOUNT_SPEED	= {id = 8, t = "Mount Speed %"},
	]]
}
-- Create a metatable for this table to generate new unknown entries to classify under "Others"
local ibonusmt = {
	__index = function(tbl, key)
		if (type(key) == "string") then
			tbl[key] = {id = 8, t = key}
			return tbl[key]
		end
	end
}
setmetatable(WoWEquip_IBonusData, ibonusmt)


-- Enchants
-- The next part of the file deals with the tables for menu generation for enchants
-- id	= is the enchantID in the itemLink.
-- t	= is the text displayed on the menu.
-- icon = is the texture to be displayed without the "Interface\\Icons\\" prefix. This entry can be nil.

local NoneTable = {id = 0,	t = NONE}

local ArmorKitTable = {
	{id = 2989,	t = L["Arcane Armor Kit"],		ic = "Spell_Shadow_SealOfKings"},
	{id = 15,	t = L["Light Armor Kit"],		ic = "INV_Misc_ArmorKit_17"},
	{id = 16,	t = L["Medium Armor Kit"],		ic = "INV_Misc_ArmorKit_15"},
	{id = 17,	t = L["Heavy Armor Kit"],		ic = "INV_Misc_ArmorKit_16"},
	{id = 18,	t = L["Thick Armor Kit"],		ic = "INV_Misc_ArmorKit_07"},
	{id = 1843,	t = L["Rugged Armor Kit"],		ic = "INV_Misc_ArmorKit_09"},
	{id = 2503,	t = L["Core Armor Kit"],		ic = "INV_Misc_ArmorKit_05"},
	{id = 2793,	t = L["Vindicator's Armor Kit"],	ic = "INV_Misc_ArmorKit_26"},
	{id = 2985,	t = L["Flame Armor Kit"],		ic = "Spell_Fire_SealOfFire"},
	{id = 2987,	t = L["Frost Armor Kit"],		ic = "Spell_Frost_WizardMark"},
	{id = 2988,	t = L["Nature Armor Kit"],		ic = "Spell_Nature_SpiritArmor"},
	{id = 2984,	t = L["Shadow Armor Kit"],		ic = "Spell_Shadow_AntiShadow"},
	{id = 2792,	t = L["Knothide Armor Kit"],		ic = "INV_Misc_ArmorKit_24"},
	{id = 2841,	t = L["Heavy Knothide Armor Kit"],	ic = "INV_Misc_ArmorKit_25"},
	{id = 2794,	t = L["Magister's Armor Kit"],		ic = "INV_Misc_ArmorKit_22"},
	NoneTable,
}
local ArcanumTable = {
	{id = 1508,	t = L["Lesser Arcanum of Voracity (Agi)"],	ic = "INV_Misc_Gem_03"},
	{id = 1504,	t = L["Lesser Arcanum of Tenacity"],		ic = "INV_Misc_Gem_03"},
	{id = 2545,	t = L["Arcanum of Protection"],			ic = "INV_Misc_Gem_02"},
	{id = 1505,	t = L["Lesser Arcanum of Resilience"],		ic = "INV_Misc_Gem_03"},
	{id = 2543,	t = L["Arcanum of Rapidity"],			ic = "INV_Misc_Gem_02"},
	{id = 2544,	t = L["Arcanum of Focus"],			ic = "INV_Misc_Gem_02"},
	{id = 1503,	t = L["Lesser Arcanum of Constitution"],	ic = "INV_Misc_Gem_03"},
	{id = 1509,	t = L["Lesser Arcanum of Voracity (Int)"],	ic = "INV_Misc_Gem_03"},
	{id = 1483,	t = L["Lesser Arcanum of Rumination"],		ic = "INV_Misc_Gem_03"},
	{id = 1510,	t = L["Lesser Arcanum of Voracity (Spi)"],	ic = "INV_Misc_Gem_03"},
	{id = 1507,	t = L["Lesser Arcanum of Voracity (Sta)"],	ic = "INV_Misc_Gem_03"},
	{id = 1506,	t = L["Lesser Arcanum of Voracity (Str)"],	ic = "INV_Misc_Gem_03"},
	NoneTable,
}
local ZGIdolTable = {
	{id = 2583,	t = L["Presence of Might"],			ic = "Spell_Holy_SealOfWrath"},
	{id = 2584,	t = L["Syncretist's Sigil"],			ic = "Spell_Holy_PrayerOfHealing"},
	{id = 2585,	t = L["Death's Embrace"],			ic = "Spell_Shadow_ScourgeBuild"},
	{id = 2586,	t = L["Falcon's Call"],				ic = "Spell_Nature_ForceOfNature"},
	{id = 2587,	t = L["Vodouisant's Vigilant Embrace"],		ic = "Spell_Nature_Purge"},
	{id = 2588,	t = L["Presence of Sight"],			ic = "Spell_Shadow_DetectLesserInvisibility"},
	{id = 2589,	t = L["Hoodoo Hex"],				ic = "Spell_Shadow_ImpPhaseShift"},
	{id = 2590,	t = L["Prophetic Aura"],			ic = "Spell_Holy_HolyProtection"},
	{id = 2591,	t = L["Animist's Caress"],			ic = "Spell_Nature_Reincarnation"},
	{id = 2681,	t = L["Savage Guard"],				ic = "Spell_Nature_SpiritArmor"},
	NoneTable,
}
local FishingEnchants = {
	{id = 3269,	t = L["Spun Truesilver Fishing Line"],	ic = "INV_Misc_Thread_01"},
	{id = 2603,	t = L["High Test Eternium Fishing Line"],	ic = "INV_Fabric_Mageweave_02"},
	NoneTable,
}
local BSWeaponEnchants = {
	{id = 34,	t = L["Iron Counterweight"],	ic = "INV_Misc_Orb_01"},
	{id = 37,	t = L["Steel Weapon Chain"],	ic = "Spell_Frost_ChainsOfIce"},
	{id = 3223,	t = L["Adamantite Weapon Chain"],	ic = "Spell_Frost_ChainsOfIce"},
	NoneTable,
}
local QuestWeaponEnchants = {
	{id = 36,	t = L["Fiery Blaze Enchantment"],	ic = "INV_Jewelry_Talisman_01"},
	NoneTable,
}
local OneHandWeaponEnchants = {
	{[L["Part 1"]] = {
		{id = 2564,	t = L["Enchant Weapon - Agility"]},
		{id = 3222,	t = L["Enchant Weapon - Greater Agility"]},
		{id = 2675,	t = L["Enchant Weapon - Battlemaster"]},
		{id = 249,	t = L["Enchant Weapon - Minor Beastslayer"]},
		{id = 853,	t = L["Enchant Weapon - Lesser Beastslayer"]},
		{id = 1900,	t = L["Enchant Weapon - Crusader"]},
		{id = 250,	t = L["Enchant Weapon - Minor Striking"]},
		{id = 241,	t = L["Enchant Weapon - Lesser Striking"]},
		{id = 943,	t = L["Enchant Weapon - Striking"]},
		{id = 805,	t = L["Enchant Weapon - Greater Striking"]},
		{id = 1897,	t = L["Enchant Weapon - Superior Striking"]},
		{id = 963,	t = L["Enchant Weapon - Major Striking"]},
		{id = 912,	t = L["Enchant Weapon - Demonslaying"]},
		{id = 854,	t = L["Enchant Weapon - Lesser Elemental Slayer"]},
		{id = 3225,	t = L["Enchant Weapon - Executioner"]},
		{id = 803,	t = L["Enchant Weapon - Fiery Weapon"]},
		{id = 2443,	t = L["Enchant Weapon - Winter's Might"]},
	}},
	{[L["Part 2"]] = {
		{id = 2505,	t = L["Enchant Weapon - Healing Power"]},
		{id = 2343,	t = L["Enchant Weapon - Major Healing"]},
		{id = 1894,	t = L["Enchant Weapon - Icy Chill"]},
		{id = 2568,	t = L["Enchant Weapon - Mighty Intellect"]},
		{id = 2666,	t = L["Enchant Weapon - Major Intellect"]},
		{id = 1898,	t = L["Enchant Weapon - Lifestealing"]},
		{id = 2673,	t = L["Enchant Weapon - Mongoose"]},
		{id = 2672,	t = L["Enchant Weapon - Soulfrost"]},
		{id = 2504,	t = L["Enchant Weapon - Spell Power"]},
		{id = 2669,	t = L["Enchant Weapon - Major Spellpower"]},
		{id = 2674,	t = L["Enchant Weapon - Spellsurge"]},
		{id = 2567,	t = L["Enchant Weapon - Mighty Spirit"]},
		{id = 2563,	t = L["Enchant Weapon - Strength"]},
		{id = 2668,	t = L["Enchant Weapon - Potency"]},
		{id = 2671,	t = L["Enchant Weapon - Sunfire"]},
		{id = 1899,	t = L["Enchant Weapon - Unholy Weapon"]},
		NoneTable,
	}},
}
local TwoHandWeaponEnchants = {
	{id = 2646,	t = L["Enchant 2H Weapon - Agility"]},
	{id = 2670,	t = L["Enchant 2H Weapon - Major Agility"]},
	{id = 2667,	t = L["Enchant 2H Weapon - Savagery"]},
	{id = 241,	t = L["Enchant 2H Weapon - Minor Impact"]},
	{id = 943,	t = L["Enchant 2H Weapon - Lesser Impact"]},
	{id = 1897,	t = L["Enchant 2H Weapon - Impact"]},
	{id = 963,	t = L["Enchant 2H Weapon - Greater Impact"]},
	{id = 1896,	t = L["Enchant 2H Weapon - Superior Impact"]},
	{id = 723,	t = L["Enchant 2H Weapon - Lesser Intellect"]},
	{id = 1904,	t = L["Enchant 2H Weapon - Major Intellect"]},
	{id = 255,	t = L["Enchant 2H Weapon - Lesser Spirit"]},
	{id = 1903,	t = L["Enchant 2H Weapon - Major Spirit"]},
	NoneTable,
}
local OneHandEnchantsTable = {
	{[L["Enchanting (1H)"]]	= OneHandWeaponEnchants},
	{[L["Blacksmithing"]]	= BSWeaponEnchants},
	{[L["Quests"]]		= QuestWeaponEnchants},
}
local RangedWeaponEnchants = {
	{id = 30,	t = L["Crude Scope"], 			ic = "INV_Misc_Spyglass_02"},
	{id = 32,	t = L["Standard Scope"], 		ic = "INV_Misc_Spyglass_02"},
	{id = 33,	t = L["Accurate Scope"], 		ic = "INV_Misc_Spyglass_02"},
	{id = 663,	t = L["Deadly Scope"], 			ic = "INV_Misc_Spyglass_02"},
	{id = 664,	t = L["Sniper Scope"], 			ic = "INV_Misc_Spyglass_02"},
	{id = 2722,	t = L["Adamantite Scope"], 		ic = "INV_Misc_Spyglass_02"},
	{id = 2723,	t = L["Khorium Scope"], 		ic = "INV_Misc_Spyglass_02"},
	{id = 2724,	t = L["Stabilized Eternium Scope"], 	ic = "INV_Misc_Spyglass_02"},
	{id = 2523,	t = L["Biznicks 247x128 Accurascope"], 	ic = "INV_Misc_Spyglass_02"},
	NoneTable,
}
local ArgentDawnTable = {
	{id = 2682,	t = L["Ice Guard"],	ic = "Spell_Frost_FrostShock"},
	{id = 2683,	t = L["Shadow Guard"],	ic = "Spell_Shadow_AntiShadow"},
	NoneTable,
}

-- In this global table, the index "INVTYPE_HEAD" etc are not to be changed because those are the actual return values
-- of GetItemInfo() for itemEquipLoc which is irrelevant of language/localization.
WoWEquip_EnchantableLoc = {
	INVTYPE_HEAD = {
		{[L["Arcanums (Librams)"]] = ArcanumTable},
		{[L["Zul'Gurub (Idols)"]] = ZGIdolTable},
		{[L["Argent Dawn (Insignias)"]] = ArgentDawnTable},
		{[L["TBC Reputation Vendors"]] = {
			{id = 3006,	t = L["Glyph of Arcane Warding"],	ic = "Spell_Arcane_ArcaneResilience"},
			{id = 3003,	t = L["Glyph of Ferocity"],		ic = "Ability_Druid_DemoralizingRoar"},
			{id = 2999,	t = L["Glyph of the Defender"],		ic = "Ability_Warrior_VictoryRush"},
			{id = 3007,	t = L["Glyph of Fire Warding"],		ic = "Spell_Fire_SealOfFire"},
			{id = 3008,	t = L["Glyph of Frost Warding"],	ic = "Spell_Frost_FrostArmor02"},
			{id = 3001,	t = L["Glyph of Renewal"],		ic = "Spell_Holy_HealingAura"},
			{id = 3005,	t = L["Glyph of Nature Warding"],	ic = "Spell_Nature_ProtectionformNature"},
			{id = 3009,	t = L["Glyph of Shadow Warding"],	ic = "Spell_Shadow_SealOfKings"},
			{id = 3002,	t = L["Glyph of Power"],		ic = "Spell_Nature_LightningOverload"},
			{id = 3004,	t = L["Glyph of the Gladiator"],		ic = "INV_Misc_Statue_04"},
			{id = 3096,	t = L["Glyph of the Outcast"],		ic = "Ability_Rogue_MasterOfSubtlety"},
			NoneTable,
		}},
		{[L["Leatherworking"]] = {
			{id = 2841,	t = L["Heavy Knothide Armor Kit"],	ic = "INV_Misc_ArmorKit_25"},
			NoneTable,
		}},
	},
	INVTYPE_SHOULDER = {
		{[L["Aldor Inscriptions"]] = {
			{id = 2977,	t = L["Inscription of Warding"],		ic = "Spell_Holy_GreaterBlessingofSanctuary"},
			{id = 2978,	t = L["Greater Inscription of Warding"],	ic = "Spell_Holy_BlessingOfProtection"},
			{id = 2979,	t = L["Inscription of Faith"],			ic = "Spell_Holy_SealOfSalvation"},
			{id = 2980,	t = L["Greater Inscription of Faith"],		ic = "Spell_Holy_GreaterBlessingofSalvation"},
			{id = 2981,	t = L["Inscription of Discipline"],		ic = "Spell_Holy_SealOfWisdom"},
			{id = 2982,	t = L["Greater Inscription of Discipline"],	ic = "Spell_Holy_SealOfWisdom"},
			{id = 2983,	t = L["Inscription of Vengeance"],		ic = "Spell_Holy_FistOfJustice"},
			{id = 2986,	t = L["Greater Inscription of Vengeance"],	ic = "Spell_Holy_GreaterBlessingofKings"},
			NoneTable,
		}},
		{[L["Scryer Inscriptions"]] = {
			{id = 2990,	t = L["Inscription of the Knight"],		ic = "Spell_Holy_ChampionsBond"},
			{id = 2991,	t = L["Greater Inscription of the Knight"],	ic = "Spell_Holy_ChampionsGrace"},
			{id = 2992,	t = L["Inscription of the Oracle"],		ic = "Spell_Holy_SpiritualGuidence"},
			{id = 2993,	t = L["Greater Inscription of the Oracle"],	ic = "Spell_Holy_PowerInfusion"},
			{id = 2994,	t = L["Inscription of the Orb"],		ic = "INV_Misc_Orb_04"},
			{id = 2995,	t = L["Greater Inscription of the Orb"],	ic = "INV_Misc_Orb_03"},
			{id = 2996,	t = L["Inscription of the Blade"],		ic = "Ability_DualWield"},
			{id = 2997,	t = L["Greater Inscription of the Blade"],	ic = "Spell_Holy_WeaponMastery"},
			NoneTable,
		}},
		{[L["Violet Eye Inscriptions"]] = {
			{id = 2998,	t = L["Inscription of Endurance"],	ic = "Ability_Warrior_ShieldMastery"},
			NoneTable,
		}},
		{[L["Argent Dawn Mantles"]] = {
			{id = 2488,	t = L["Chromatic Mantle of the Dawn"],	ic = "INV_Misc_Gem_Variety_02"},
			{id = 2485,	t = L["Arcane Mantle of the Dawn"],	ic = "Spell_Holy_WordFortitude"},
			{id = 2483,	t = L["Flame Mantle of the Dawn"],	ic = "Spell_Fire_FlameShock"},
			{id = 2484,	t = L["Frost Mantle of the Dawn"],	ic = "Spell_Frost_FrostShock"},
			{id = 2486,	t = L["Nature Mantle of the Dawn"],	ic = "Spell_Nature_ProtectionformNature"},
			{id = 2487,	t = L["Shadow Mantle of the Dawn"],	ic = "Spell_Shadow_RagingScream"},
			NoneTable,
		}},
		{[L["Zul'Gurub Signets"]] = {
			{id = 2606,	t = L["Zandalar Signet of Might"],	ic = "INV_Misc_ArmorKit_08"},
			{id = 2604,	t = L["Zandalar Signet of Serenity"],	ic = "Spell_Holy_PowerWordShield"},
			{id = 2605,	t = L["Zandalar Signet of Mojo"],	ic = "INV_Jewelry_Ring_46"},
			NoneTable,
		}},
		{[L["Naxxramas Sapphiron Drops"]] = {
			{id = 2721,	t = L["Power of the Scourge"],		ic = "Spell_Shadow_DarkRitual"},
			{id = 2715,	t = L["Resilience of the Scourge"],	ic = "Spell_Shadow_DeadofNight"},
			{id = 2716,	t = L["Fortitude of the Scourge"],	ic = "Spell_Shadow_AntiShadow"},
			{id = 2717,	t = L["Might of the Scourge"],		ic = "Spell_Shadow_Deathpact"},
			NoneTable,
		}},
		{[L["Leatherworking"]] = {
			{id = 2841,	t = L["Heavy Knothide Armor Kit"],	ic = "INV_Misc_ArmorKit_25"},
			NoneTable,
		}},
	},
	INVTYPE_CHEST = {	-- For plate apparently
		{[L["Enchanting"]] = {
			{[L["Part 1"]] = {
				{id = 44,	t = L["Enchant Chest - Minor Absorption"]},
				{id = 63,	t = L["Enchant Chest - Lesser Absorption"]}, 
				{id = 847,	t = L["Enchant Chest - Minor Stats"]},
				{id = 866,	t = L["Enchant Chest - Lesser Stats"]},
				{id = 928,	t = L["Enchant Chest - Stats"]},
				{id = 1891,	t = L["Enchant Chest - Greater Stats"]},
				{id = 2661,	t = L["Enchant Chest - Exceptional Stats"]},
				{id = 1950,	t = L["Enchant Chest - Defense"]},
				{id = 41,	t = L["Enchant Chest - Minor Health"]},
				{id = 242,	t = L["Enchant Chest - Lesser Health"]},
				{id = 254,	t = L["Enchant Chest - Health"]},
				{id = 850,	t = L["Enchant Chest - Greater Health"]},
				{id = 908,	t = L["Enchant Chest - Superior Health"]},
				{id = 1892,	t = L["Enchant Chest - Major Health"]},
				{id = 2659,	t = L["Enchant Chest - Exceptional Health"]},
				NoneTable,
			}},
			{[L["Part 2"]] = {
				{id = 24,	t = L["Enchant Chest - Minor Mana"]},
				{id = 843,	t = L["Enchant Chest - Mana"]},
				{id = 857,	t = L["Enchant Chest - Greater Mana"]},
				{id = 913,	t = L["Enchant Chest - Superior Mana"]},
				{id = 1893,	t = L["Enchant Chest - Major Mana"]},
				{id = 2933,	t = L["Enchant Chest - Major Resilience"]},
				{id = 1144,	t = L["Enchant Chest - Major Spirit"]},
				{id = 3150,	t = L["Enchant Chest - Restore Mana Prime"]},	-- 2376 for nonplate
				NoneTable,
			}},
		}},
		{[L["Armor Kits"]] = ArmorKitTable},
	},
	INVTYPE_ROBE = {	-- For non-plate apparently
		{[L["Enchanting"]] = {
			{[L["Part 1"]] = {
				{id = 44,	t = L["Enchant Chest - Minor Absorption"]},
				{id = 63,	t = L["Enchant Chest - Lesser Absorption"]}, 
				{id = 847,	t = L["Enchant Chest - Minor Stats"]},
				{id = 866,	t = L["Enchant Chest - Lesser Stats"]},
				{id = 928,	t = L["Enchant Chest - Stats"]},
				{id = 1891,	t = L["Enchant Chest - Greater Stats"]},
				{id = 2661,	t = L["Enchant Chest - Exceptional Stats"]},
				{id = 1950,	t = L["Enchant Chest - Defense"]},
				{id = 41,	t = L["Enchant Chest - Minor Health"]},
				{id = 242,	t = L["Enchant Chest - Lesser Health"]},
				{id = 254,	t = L["Enchant Chest - Health"]},
				{id = 850,	t = L["Enchant Chest - Greater Health"]},
				{id = 908,	t = L["Enchant Chest - Superior Health"]},
				{id = 1892,	t = L["Enchant Chest - Major Health"]},
				{id = 2659,	t = L["Enchant Chest - Exceptional Health"]},
				NoneTable,
			}},
			{[L["Part 2"]] = {
				{id = 24,	t = L["Enchant Chest - Minor Mana"]},
				{id = 843,	t = L["Enchant Chest - Mana"]},
				{id = 857,	t = L["Enchant Chest - Greater Mana"]},
				{id = 913,	t = L["Enchant Chest - Superior Mana"]},
				{id = 1893,	t = L["Enchant Chest - Major Mana"]},
				{id = 2933,	t = L["Enchant Chest - Major Resilience"]},
				{id = 1144,	t = L["Enchant Chest - Major Spirit"]},
				{id = 2376,	t = L["Enchant Chest - Restore Mana Prime"]},	-- 3150 for plate
				NoneTable,
			}},
		}},
		{[L["Armor Kits"]] = ArmorKitTable},
	},
	INVTYPE_LEGS = {
		{[L["Tailoring"]] = {
			{id = 2745,	t = L["Silver Spellthread"],	ic = "Spell_Nature_Lightning"},
			{id = 2746,	t = L["Golden Spellthread"],	ic = "Spell_Holy_Restoration"},
			{id = 2747,	t = L["Mystic Spellthread"],	ic = "Spell_Nature_AstralRecal"},
			{id = 2748,	t = L["Runic Spellthread"],	ic = "Spell_Nature_AstralRecalGroup"},
			NoneTable,
		}},
		{[L["Leatherworking"]] = {
			{id = 3010,	t = L["Cobrahide Leg Armor"],		ic = "INV_Misc_ArmorKit_21"},
			{id = 3012,	t = L["Nethercobra Leg Armor"],		ic = "INV_Misc_ArmorKit_25"},
			{id = 2841,	t = L["Heavy Knothide Armor Kit"],	ic = "INV_Misc_ArmorKit_25"},
			{id = 3011,	t = L["Clefthide Leg Armor"],		ic = "INV_Misc_ArmorKit_23"},
			{id = 3013,	t = L["Nethercleft Leg Armor"],		ic = "INV_Misc_ArmorKit_25"},
			NoneTable,
		}},
		{[L["Armor Kits"]] = ArmorKitTable},
		{[L["Arcanums (Librams)"]] = ArcanumTable},
		{[L["Argent Dawn (Insignias)"]] = ArgentDawnTable},
		{[L["Zul'Gurub (Idols)"]] = ZGIdolTable},
	},
	INVTYPE_FEET = {
		{[L["Enchanting"]] = {
			{id = 911,	t = L["Enchant Boots - Minor Speed"]},
			{id = 2939,	t = L["Enchant Boots - Cat's Swiftness"]},
			{id = 2940,	t = L["Enchant Boots - Boar's Speed"]},
			{id = 247,	t = L["Enchant Boots - Minor Agility"]},
			{id = 849,	t = L["Enchant Boots - Lesser Agility"]},
			{id = 904,	t = L["Enchant Boots - Agility"]},
			{id = 1887,	t = L["Enchant Boots - Greater Agility"]},
			{id = 2657,	t = L["Enchant Boots - Dexterity"]},
			{id = 66,	t = L["Enchant Boots - Minor Stamina"]},
			{id = 724,	t = L["Enchant Boots - Lesser Stamina"]},
			{id = 852,	t = L["Enchant Boots - Stamina"]},
			{id = 929,	t = L["Enchant Boots - Greater Stamina"]},
			{id = 2649,	t = L["Enchant Boots - Fortitude"]},
			{id = 255,	t = L["Enchant Boots - Lesser Spirit"]},
			{id = 851,	t = L["Enchant Boots - Spirit"]},
			{id = 2658,	t = L["Enchant Boots - Surefooted"]},
			{id = 2656,	t = L["Enchant Boots - Vitality"]},
			NoneTable,
		}},
		{[L["Armor Kits"]] = ArmorKitTable},
		{[L["Blacksmithing"]] = {
			{id = 464,	t = L["Mithril Spurs"],	ic = "Ability_Rogue_Sprint"},
			NoneTable,
		}},
	},
	INVTYPE_WRIST = {
		{[L["Enchanting"]] = {
			{[L["Part 1"]] = {
				{id = 247,	t = L["Enchant Bracer - Minor Agility"]},
				{id = 1891,	t = L["Enchant Bracer - Stats"]},
				{id = 1593,	t = L["Enchant Bracer - Assault"]},
				{id = 924,	t = L["Enchant Bracer - Minor Deflection"]},
				{id = 925,	t = L["Enchant Bracer - Lesser Deflection"]},
				{id = 923,	t = L["Enchant Bracer - Deflection"]},
				{id = 2648,	t = L["Enchant Bracer - Major Defense"]},
				{id = 723,	t = L["Enchant Bracer - Lesser Intellect"]},
				{id = 905,	t = L["Enchant Bracer - Intellect"]},
				{id = 1883,	t = L["Enchant Bracer - Greater Intellect"]},
				{id = 369,	t = L["Enchant Bracer - Major Intellect"]},
				{id = 2566,	t = L["Enchant Bracer - Healing Power"]},
				{id = 2617,	t = L["Enchant Bracer - Superior Healing"]},
				{id = 41,	t = L["Enchant Bracer - Minor Health"]},
				{id = 2650,	t = L["Enchant Bracer - Spellpower"]},
				NoneTable,
			}},
			{[L["Part 2"]] = {
				{id = 243,	t = L["Enchant Bracer - Minor Spirit"]},
				{id = 255,	t = L["Enchant Bracer - Lesser Spirit"]},
				{id = 851,	t = L["Enchant Bracer - Spirit"]},
				{id = 907,	t = L["Enchant Bracer - Greater Spirit"]},
				{id = 1884,	t = L["Enchant Bracer - Superior Spirit"]},
				{id = 66,	t = L["Enchant Bracer - Minor Stamina"]},
				{id = 724,	t = L["Enchant Bracer - Lesser Stamina"]},
				{id = 852,	t = L["Enchant Bracer - Stamina"]},
				{id = 929,	t = L["Enchant Bracer - Greater Stamina"]},
				{id = 1886,	t = L["Enchant Bracer - Superior Stamina"]},
				{id = 2649,	t = L["Enchant Bracer - Fortitude"]},
				{id = 248,	t = L["Enchant Bracer - Minor Strength"]},
				{id = 823,	t = L["Enchant Bracer - Lesser Strength"]},
				{id = 856,	t = L["Enchant Bracer - Strength"]},
				{id = 927,	t = L["Enchant Bracer - Greater Strength"]},
				{id = 1885,	t = L["Enchant Bracer - Superior Strength"]},
				{id = 2647,	t = L["Enchant Bracer - Brawn"]},
				{id = 2565,	t = L["Enchant Bracer - Mana Regeneration"]},
				{id = 2679,	t = L["Enchant Bracer - Restore Mana Prime"]},
				NoneTable,
			}},
		}},
	},
	INVTYPE_HAND = {
		{[L["Enchanting"]] = {
			{[L["Part 1"]] = {
				{id = 904,	t = L["Enchant Gloves - Agility"]},
				{id = 1887,	t = L["Enchant Gloves - Greater Agility"]},
				{id = 2564,	t = L["Enchant Gloves - Superior Agility"]},
				{id = 1594,	t = L["Enchant Gloves - Assault"]},
				{id = 2616,	t = L["Enchant Gloves - Fire Power"]},
				{id = 846,	t = L["Enchant Gloves - Fishing"]},
				{id = 2615,	t = L["Enchant Gloves - Frost Power"]},
				{id = 931,	t = L["Enchant Gloves - Minor Haste"]},
				{id = 2617,	t = L["Enchant Gloves - Healing Power"]},
				{id = 2322,	t = L["Enchant Gloves - Major Healing"]},
				{id = 845,	t = L["Enchant Gloves - Herbalism"]},
				{id = 909,	t = L["Enchant Gloves - Advanced Herbalism"]},
				NoneTable,
			}},
			{[L["Part 2"]] = {
				{id = 844,	t = L["Enchant Gloves - Mining"]},
				{id = 906,	t = L["Enchant Gloves - Advanced Mining"]},
				{id = 930,	t = L["Enchant Gloves - Riding Skill"]},
				{id = 2614,	t = L["Enchant Gloves - Shadow Power"]},
				{id = 865,	t = L["Enchant Gloves - Skinning"]},
				{id = 2934,	t = L["Enchant Gloves - Blasting"]},
				{id = 2937,	t = L["Enchant Gloves - Major Spellpower"]},
				{id = 2935,	t = L["Enchant Gloves - Spell Strike"]},
				{id = 856,	t = L["Enchant Gloves - Strength"]},
				{id = 927,	t = L["Enchant Gloves - Greater Strength"]},
				{id = 684,	t = L["Enchant Gloves - Major Strength"]},
				{id = 2613,	t = L["Enchant Gloves - Threat"]},
				NoneTable,
			}},
		}},
		{[L["Armor Kits"]] = ArmorKitTable},
		{[L["Leatherworking"]] = {
			{id = 3260,	t = L["Glove Reinforcements"],		ic = "INV_Misc_ArmorKit_08"},
			NoneTable,
		}},
	},
	INVTYPE_FINGER = {
		{[L["Enchanting"]] = {
			{id = 2931,	t = L["Enchant Ring - Stats"]},
			{id = 2930,	t = L["Enchant Ring - Healing Power"]},
			{id = 2928,	t = L["Enchant Ring - Spellpower"]},
			{id = 2929,	t = L["Enchant Ring - Striking"]},
			NoneTable,
		}},
	},
	INVTYPE_CLOAK = {
		{[L["Enchanting"]] = {
			{[L["Part 1"]] = {
				{id = 247,	t = L["Enchant Cloak - Minor Agility"]},
				{id = 849,	t = L["Enchant Cloak - Lesser Agility"]},
				{id = 368,	t = L["Enchant Cloak - Greater Agility"]},
				{id = 65,	t = L["Enchant Cloak - Minor Resistance"]},
				{id = 903,	t = L["Enchant Cloak - Resistance"]},
				{id = 1888,	t = L["Enchant Cloak - Greater Resistance"]},
				{id = 2664,	t = L["Enchant Cloak - Major Resistance"]},
				{id = 1257,	t = L["Enchant Cloak - Greater Arcane Resistance"]},
				{id = 783,	t = L["Enchant Cloak - Minor Protection"]},
				{id = 744,	t = L["Enchant Cloak - Lesser Protection"]},
				{id = 848,	t = L["Enchant Cloak - Defense"]},
				{id = 884,	t = L["Enchant Cloak - Greater Defense"]},
				{id = 1889,	t = L["Enchant Cloak - Superior Defense"]},
				{id = 2662,	t = L["Enchant Cloak - Major Armor"]},
				NoneTable,
			}},
			{[L["Part 2"]] = {
				{id = 2648,	t = L["Enchant Cloak - Steelweave"]},
				{id = 2622,	t = L["Enchant Cloak - Dodge"]},
				{id = 256,	t = L["Enchant Cloak - Lesser Fire Resistance"]},
				{id = 2463,	t = L["Enchant Cloak - Fire Resistance"]},
				{id = 2619,	t = L["Enchant Cloak - Greater Fire Resistance"]},
				{id = 2620,	t = L["Enchant Cloak - Greater Nature Resistance"]},
				{id = 804,	t = L["Enchant Cloak - Lesser Shadow Resistance"]},
				{id = 1441,	t = L["Enchant Cloak - Greater Shadow Resistance"]},
				{id = 2938,	t = L["Enchant Cloak - Spell Penetration"]},
				{id = 910,	t = L["Enchant Cloak - Stealth"]},
				{id = 2621,	t = L["Enchant Cloak - Subtlety"]},
				NoneTable,
			}},
		}},
	},
	INVTYPE_WEAPON = OneHandEnchantsTable,
	INVTYPE_SHIELD = {
		{[L["Enchanting"]] = {
			{id = 1888,	t = L["Enchant Shield - Resistance"]},
			{id = 848,	t = L["Enchant Shield - Lesser Protection"]},
			{id = 863,	t = L["Enchant Shield - Lesser Block"]},
			{id = 2655,	t = L["Enchant Shield - Shield Block"]},
			{id = 2653,	t = L["Enchant Shield - Tough Shield"]},
			{id = 926,	t = L["Enchant Shield - Frost Resistance"]},
			{id = 2654,	t = L["Enchant Shield - Intellect"]},
			{id = 3229,	t = L["Enchant Shield - Resilience"]},
			{id = 255,	t = L["Enchant Shield - Lesser Spirit"]},
			{id = 851,	t = L["Enchant Shield - Spirit"]},
			{id = 907,	t = L["Enchant Shield - Greater Spirit"]},
			{id = 1884,	t = L["Enchant Shield - Superior Spirit"]},
			{id = 66,	t = L["Enchant Shield - Minor Stamina"]},
			{id = 724,	t = L["Enchant Shield - Lesser Stamina"]},
			{id = 852,	t = L["Enchant Shield - Stamina"]},
			{id = 929,	t = L["Enchant Shield - Greater Stamina"]},
			{id = 1071,	t = L["Enchant Shield - Major Stamina"]},
			NoneTable,
		}},
		{[L["Blacksmithing"]] = {
			{id = 43,	t = L["Iron Shield Spike"],		ic = "INV_Misc_ArmorKit_01"},
			{id = 463,	t = L["Mithril Shield Spike"],		ic = "INV_Misc_ArmorKit_02"},
			{id = 1704,	t = L["Thorium Shield Spike"],		ic = "INV_Misc_ArmorKit_20"},
			{id = 2714,	t = L["Felsteel Shield Spike"],		ic = "INV_Misc_ArmorKit_27"},
			NoneTable,
		}},
	},
	INVTYPE_2HWEAPON = {
		{[L["Enchanting (1H)"]]	= OneHandWeaponEnchants},
		{[L["Enchanting (2H)"]]	= TwoHandWeaponEnchants},
		{[L["Blacksmithing"]]	= BSWeaponEnchants},
		{[L["Quests"]]		= QuestWeaponEnchants},
	},
	INVTYPE_WEAPONMAINHAND = OneHandEnchantsTable,
	INVTYPE_WEAPONOFFHAND = OneHandEnchantsTable,
	INVTYPE_RANGED = RangedWeaponEnchants,
	INVTYPE_RANGEDRIGHT = RangedWeaponEnchants,
	FishingEnchants = FishingEnchants,
	NoEnchants = {NoneTable},
}


-- Gems
-- The next part of the file deals with the tables for menu generation for gems
-- id	= is the gemID in the itemLink.
-- t	= is the text displayed on the menu.
-- ic	= is the texture to be displayed without the "Interface\\Icons\\" prefix. This entry can be nil.
-- The index ITEM_QUALITY1_DESC, ITEM_QUALITY2_DESC, etc are actual global constants as defined in GlobalStrings.lua and
-- are localized strings of the quality of an item (common, uncommon, rare, epic, etc). This string is displayed in the menu.

local BlueGemMenu = {
	{[ITEM_QUALITY1_DESC] = {
		{id = 2963,	t = L["Lustrous Zircon"],	ic = "INV_Misc_Gem_Crystal_03"},
		{id = 2962,	t = L["Sparkling Zircon"],	ic = "INV_Misc_Gem_Crystal_03"},
		{id = 2961,	t = L["Solid Zircon"],		ic = "INV_Misc_Gem_Crystal_03"},
		NoneTable,
	}},
	{[ITEM_QUALITY2_DESC] = {
		{id = 2701,	t = L["Lustrous Azure Moonstone"],	ic = "INV_Misc_Gem_AzureDraenite_02"},
		{id = 2700,	t = L["Stormy Azure Moonstone"],	ic = "INV_Misc_Gem_AzureDraenite_02"},
		{id = 2699,	t = L["Sparkling Azure Moonstone"],	ic = "INV_Misc_Gem_AzureDraenite_02"},
		{id = 2698,	t = L["Solid Azure Moonstone"],		ic = "INV_Misc_Gem_AzureDraenite_02"},
		NoneTable,
	}},
	{[ITEM_QUALITY3_DESC] = {
		{id = 2733,	t = L["Lustrous Star of Elune"],	ic = "INV_Jewelcrafting_StarOfElune_03"},
		{id = 2765,	t = L["Stormy Star of Elune"],		ic = "INV_Jewelcrafting_StarOfElune_03"},
		{id = 2732,	t = L["Sparkling Star of Elune"],	ic = "INV_Jewelcrafting_StarOfElune_03"},
		{id = 2731,	t = L["Solid Star of Elune"],		ic = "INV_Jewelcrafting_StarOfElune_03"},
		{id = 3268,	t = L["Eye of the Sea"],			ic = "INV_Jewelcrafting_StarOfElune_01"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{id = 3124,	t = L["Lustrous Empyrean Sapphire"],	ic = "INV_Jewelcrafting_EmpyreanSapphire_02"},
		{id = 3125,	t = L["Stormy Empyrean Sapphire"],	ic = "INV_Jewelcrafting_EmpyreanSapphire_02"},
		{id = 3123,	t = L["Sparkling Empyrean Sapphire"],	ic = "INV_Jewelcrafting_EmpyreanSapphire_02"},
		{id = 3122,	t = L["Solid Empyrean Sapphire"],	ic = "INV_Jewelcrafting_EmpyreanSapphire_02"},
		{id = 3262,	t = L["Charmed Amani Jewel"],		ic = "INV_Misc_Gem_Pearl_07"},
		{id = 3212,	t = L["Falling Star"],			ic = "INV_Jewelcrafting_EmpyreanSapphire_02"},
		NoneTable,
	}},
}

local RedGemMenu = {
	{[ITEM_QUALITY1_DESC] = {
		{id = 2957,	t = L["Delicate Tourmaline"],	ic = "INV_Misc_Gem_Ruby_03"},
		{id = 2960,	t = L["Bright Tourmaline"],	ic = "INV_Misc_Gem_Ruby_03"},
		{id = 2958,	t = L["Teardrop Tourmaline"],	ic = "INV_Misc_Gem_Ruby_03"},
		{id = 2959,	t = L["Runed Tourmaline"],	ic = "INV_Misc_Gem_Ruby_03"},
		{id = 2956,	t = L["Bold Tourmaline"],	ic = "INV_Misc_Gem_Ruby_03"},
		NoneTable,
	}},
	{[ITEM_QUALITY2_DESC] = {
		{id = 2693,	t = L["Delicate Blood Garnet"],	ic = "INV_Misc_Gem_BloodGem_02"},
		{id = 2971,	t = L["Bright Blood Garnet"],	ic = "INV_Misc_Gem_BloodGem_02"},
		{id = 2690,	t = L["Teardrop Blood Garnet"],	ic = "INV_Misc_Gem_BloodGem_02"},
		{id = 2692,	t = L["Runed Blood Garnet"],	ic = "INV_Misc_Gem_BloodGem_02"},
		{id = 2691,	t = L["Bold Blood Garnet"],	ic = "INV_Misc_Gem_BloodGem_02"},
		NoneTable,
	}},
	{[ITEM_QUALITY3_DESC] = {
		{id = 2726,	t = L["Delicate Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 2944,	t = L["Mighty Blood Garnet (A)"],	ic = "INV_Misc_Gem_Bloodstone_02"},
		{id = 2943,	t = L["Mighty Blood Garnet (H)"],	ic = "INV_Misc_Gem_Bloodstone_02"},
		{id = 2729,	t = L["Bright Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 2730,	t = L["Subtle Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 2727,	t = L["Teardrop Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 2754,	t = L["Flashing Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 2924,	t = L["Stark Blood Garnet (A)"],	ic = "INV_Misc_Gem_Ruby_01"},
		{id = 2896,	t = L["Stark Blood Garnet (H)"],	ic = "INV_Misc_Gem_Ruby_01"},
		{id = 2728,	t = L["Runed Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 2725,	t = L["Bold Living Ruby"],		ic = "INV_Jewelcrafting_LivingRuby_03"},
		{id = 3103,	t = L["Don Amancio's Heart"],		ic = "INV_Misc_Gem_Ruby_01"},
		{id = 3065,	t = L["Don Rodrigo's Heart"],		ic = "INV_Misc_Gem_Ruby_01"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{id = 3116,	t = L["Delicate Crimson Spinel"],	ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 2945,	t = L["Bold Ornate Ruby"],		ic = "INV_Misc_Gem_Ruby_02"},
		{id = 3119,	t = L["Bright Crimson Spinel"],		ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3208,	t = L["Crimson Sun"],			ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3120,	t = L["Subtle Crimson Spinel"],		ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3117,	t = L["Teardrop Crimson Spinel"],	ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3211,	t = L["Kailee's Rose"],			ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3121,	t = L["Flashing Crimson Spinel"],	ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3118,	t = L["Runed Crimson Spinel"],		ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 2912,	t = L["Runed Ornate Ruby"],		ic = "INV_Misc_Gem_Bloodstone_01"},
		{id = 3210,	t = L["Don Julio's Heart"],		ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		{id = 3115,	t = L["Bold Crimson Spinel"],		ic = "INV_Jewelcrafting_CrimsonSpinel_02"},
		NoneTable,
	}},
}

local YellowGemMenu = {
	{[ITEM_QUALITY1_DESC] = {
		{id = 2965,	t = L["Smooth Amber"],		ic = "INV_Misc_Gem_Topaz_03"},
		{id = 2968,	t = L["Thick Amber"],		ic = "INV_Misc_Gem_Topaz_03"},
		{id = 2966,	t = L["Rigid Amber"],		ic = "INV_Misc_Gem_Topaz_03"},
		{id = 2964,	t = L["Brilliant Amber"],	ic = "INV_Misc_Gem_Topaz_03"},
		{id = 2967,	t = L["Gleaming Amber"],	ic = "INV_Misc_Gem_Topaz_03"},
		NoneTable,
	}},
	{[ITEM_QUALITY2_DESC] = {
		{id = 2942,	t = L["Smooth Golden Draenite"],	ic = "INV_Misc_Gem_GoldenDraenite_02"},
		{id = 2696,	t = L["Thick Golden Draenite"],		ic = "INV_Misc_Gem_GoldenDraenite_02"},
		{id = 2697,	t = L["Rigid Golden Draenite"],		ic = "INV_Misc_Gem_GoldenDraenite_02"},
		{id = 2694,	t = L["Brilliant Golden Draenite"],	ic = "INV_Misc_Gem_GoldenDraenite_02"},
		{id = 2695,	t = L["Gleaming Golden Draenite"],	ic = "INV_Misc_Gem_GoldenDraenite_02"},
		{id = 3104,	t = L["Great Golden Draenite"],		ic = "INV_Misc_Gem_GoldenDraenite_02"},
		NoneTable,
	}},
	{[ITEM_QUALITY3_DESC] = {
		{id = 2735,	t = L["Smooth Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		{id = 2737,	t = L["Thick Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		{id = 2764,	t = L["Rigid Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		{id = 2734,	t = L["Brilliant Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		{id = 2759,	t = L["Mystic Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		{id = 2736,	t = L["Gleaming Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		{id = 3105,	t = L["Great Dawnstone"],	ic = "INV_Jewelcrafting_Dawnstone_03"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{id = 3127,	t = L["Smooth Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 2913,	t = L["Smooth Ornate Dawnstone"],	ic = "INV_Misc_Gem_Topaz_01"},
		{id = 3220,	t = L["Stone of Blades"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3130,	t = L["Thick Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3221,	t = L["Facet of Eternity"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3128,	t = L["Rigid Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3126,	t = L["Brilliant Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3131,	t = L["Mystic Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 2891,	t = L["Sublime Mystic Dawnstone"],	ic = "INV_Misc_Gem_Topaz_01"},
		{id = 3129,	t = L["Gleaming Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 2914,	t = L["Gleaming Ornate Dawnstone"],	ic = "INV_Misc_Gem_Topaz_02"},
		{id = 3217,	t = L["Blood of Amber"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3287,	t = L["Quick Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		{id = 3132,	t = L["Great Lionseye"],		ic = "INV_Jewelcrafting_Lionseye_02"},
		NoneTable,
	}},
}

local GreenGemMenu = {
	{[ITEM_QUALITY2_DESC] = {
		{id = 2757,	t = L["Jagged Deep Peridot"],		ic = "INV_Misc_Gem_DeepPeridot_02"},
		{id = 2706,	t = L["Enduring Deep Peridot"],		ic = "INV_Misc_Gem_DeepPeridot_02"},
		{id = 2707,	t = L["Dazzling Deep Peridot"],		ic = "INV_Misc_Gem_DeepPeridot_02"},
		{id = 2762,	t = L["Radiant Deep Peridot"],		ic = "INV_Misc_Gem_DeepPeridot_02"},
		NoneTable,
	}},
	{[ITEM_QUALITY3_DESC] = {
		{id = 2921,	t = L["Barbed Deep Peridot (A)"],	ic = "INV_Misc_Gem_DeepPeridot_01"},
		{id = 2918,	t = L["Barbed Deep Peridot (H)"],	ic = "INV_Misc_Gem_DeepPeridot_01"},
		{id = 2923,	t = L["Notched Deep Peridot (A)"],	ic = "INV_Misc_Gem_DeepPeridot_03"},
		{id = 2898,	t = L["Notched Deep Peridot (H)"],	ic = "INV_Misc_Gem_DeepPeridot_03"},
		{id = 2758,	t = L["Jagged Talasite"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 2743,	t = L["Enduring Talasite"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 2744,	t = L["Dazzling Talasite"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3157,	t = L["Unstable Peridot"],		ic = "INV_Misc_Gem_DeepPeridot_03"},
		{id = 3226,	t = L["Steady Talasite"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 2763,	t = L["Radiant Talasite"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3161,	t = L["Unstable Talasite"],		ic = "INV_Jewelcrafting_Talasite_01"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{id = 3049,	t = L["Sundered Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3148,	t = L["Jagged Seaspray Emerald"],	ic = "INV_Jewelcrafting_SeasprayEmerald_02"},
		{id = 3145,	t = L["Enduring Seaspray Emerald"],	ic = "INV_Jewelcrafting_SeasprayEmerald_02"},
		{id = 3082,	t = L["Effulgent Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3074,	t = L["Seer's Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3071,	t = L["Timeless Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3147,	t = L["Dazzling Seaspray Emerald"],	ic = "INV_Jewelcrafting_SeasprayEmerald_02"},
		{id = 3077,	t = L["Dazzling Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3284,	t = L["Steady Seaspray Emerald"],	ic = "INV_Jewelcrafting_SeasprayEmerald_02"},
		{id = 3091,	t = L["Radiant Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3146,	t = L["Radiant Seaspray Emerald"],	ic = "INV_Jewelcrafting_SeasprayEmerald_02"},
		{id = 3058,	t = L["Rune Covered Chrysoprase"],	ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3285,	t = L["Forceful Seaspray Emerald"],	ic = "INV_Jewelcrafting_SeasprayEmerald_02"},
		{id = 3088,	t = L["Vivid Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3089,	t = L["Lambent Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3085,	t = L["Jagged Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3078,	t = L["Enduring Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3080,	t = L["Steady Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		{id = 3047,	t = L["Polished Chrysoprase"],		ic = "INV_Jewelcrafting_Talasite_03"},
		NoneTable,
	}},
}

local OrangeGemMenu = {
	{[ITEM_QUALITY2_DESC] = {
		{id = 3113,	t = L["Wicked Flame Spessarite"],	ic = "INV_Misc_Gem_FlameSpessarite_02"},
		{id = 2752,	t = L["Inscribed Flame Spessarite"],	ic = "INV_Misc_Gem_FlameSpessarite_02"},
		{id = 2705,	t = L["Luminous Flame Spessarite"],	ic = "INV_Misc_Gem_FlameSpessarite_02"},
		{id = 2755,	t = L["Glinting Flame Spessarite"],	ic = "INV_Misc_Gem_FlameSpessarite_02"},
		{id = 2760,	t = L["Potent Flame Spessarite"],	ic = "INV_Misc_Gem_FlameSpessarite_02"},
		{id = 3110,	t = L["Veiled Flame Spessarite"],	ic = "INV_Misc_Gem_FlameSpessarite_02"},
		NoneTable,
	}},
	{[ITEM_QUALITY3_DESC] = {
		{id = 3159,	t = L["Unstable Citrine"],	ic = "INV_Misc_Gem_Opal_01"},
		{id = 3112,	t = L["Wicked Noble Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_03"},
		{id = 2753,	t = L["Inscribed Noble Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_03"},
		{id = 2742,	t = L["Luminous Noble Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_03"},
		{id = 2756,	t = L["Glinting Noble Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_03"},
		{id = 2761,	t = L["Potent Noble Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_03"},
		{id = 3160,	t = L["Unstable Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_02"},
		{id = 3111,	t = L["Veiled Noble Topaz"],	ic = "INV_Jewelcrafting_NobleTopaz_03"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{[L["Part 1"]] = {
			{id = 3073,	t = L["Glistening Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3070,	t = L["Deadly Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3079,	t = L["Empowered Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3052,	t = L["Pristine Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 2946,	t = L["Inscribed Ornate Topaz"],	ic = "INV_Misc_Gem_Opal_01"},
			{id = 3062,	t = L["Assassin's Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3139,	t = L["Inscribed Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			{id = 3144,	t = L["Wicked Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			{id = 3053,	t = L["Stalwart Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3068,	t = L["Nimble Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3084,	t = L["Beaming Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3046,	t = L["Luminous Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3069,	t = L["Durable Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3081,	t = L["Iridescent Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3141,	t = L["Luminous Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			NoneTable,
		}},
		{[L["Part 2"]] = {
			{id = 3142,	t = L["Glinting Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			{id = 3056,	t = L["Glimmering Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3090,	t = L["Splendid Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3140,	t = L["Potent Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			{id = 3050,	t = L["Infused Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3076,	t = L["Potent Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3061,	t = L["Shining Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3066,	t = L["Mysterious Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 2916,	t = L["Potent Ornate Topaz"],		ic = "INV_Misc_Gem_Opal_02"},
			{id = 3286,	t = L["Reckless Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			{id = 3143,	t = L["Veiled Pyrestone"],		ic = "INV_Jewelcrafting_Pyrestone_02"},
			{id = 3072,	t = L["Enscribed Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3075,	t = L["Champion's Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3057,	t = L["Etched Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			{id = 3087,	t = L["Resplendent Fire Opal"],		ic = "INV_Jewelcrafting_NobleTopaz_03"},
			NoneTable,
		}},
	}},
}

local PurpleGemMenu = {
	{[ITEM_QUALITY2_DESC] = {
		{id = 2710,	t = L["Shifting Shadow Draenite"],	ic = "INV_Misc_Gem_EbonDraenite_02"},
		{id = 3108,	t = L["Infused Shadow Draenite"],	ic = "INV_Misc_Gem_EbonDraenite_02"},
		{id = 3106,	t = L["Balanced Shadow Draenite"],	ic = "INV_Misc_Gem_EbonDraenite_02"},
		{id = 3201,	t = L["Purified Jaggal Pearl"],		ic = "INV_Misc_Gem_Pearl_08"},
		{id = 2709,	t = L["Royal Shadow Draenite"],		ic = "INV_Misc_Gem_EbonDraenite_02"},
		{id = 2708,	t = L["Glowing Shadow Draenite"],	ic = "INV_Misc_Gem_EbonDraenite_02"},
		{id = 2711,	t = L["Sovereign Shadow Draenite"],	ic = "INV_Misc_Gem_EbonDraenite_02"},
		NoneTable,
	}},
	{[ITEM_QUALITY3_DESC] = {
		{id = 2739,	t = L["Shifting Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3109,	t = L["Infused Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3107,	t = L["Balanced Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3156,	t = L["Unstable Amethyst"],		ic = "INV_Jewelcrafting_ShadowsongAmethyst_01"},
		{id = 3280,	t = L["Regal Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3202,	t = L["Purified Shadow Pearl"],		ic = "INV_Misc_Gem_Pearl_07"},
		{id = 3158,	t = L["Unstable Sapphire"],		ic = "INV_Misc_Gem_Sapphire_02"},
		{id = 2741,	t = L["Royal Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 2740,	t = L["Glowing Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 2738,	t = L["Sovereign Nightseye"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{id = 3048,	t = L["Shifting Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3134,	t = L["Shifting Shadowsong Amethyst"],	ic = "INV_Jewelcrafting_ShadowsongAmethyst_02"},
		{id = 3136,	t = L["Infused Shadowsong Amethyst"],	ic = "INV_Jewelcrafting_ShadowsongAmethyst_02"},
		{id = 3067,	t = L["Brutal Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3101,	t = L["Pulsing Amethyst"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3135,	t = L["Balanced Shadowsong Amethyst"],	ic = "INV_Jewelcrafting_ShadowsongAmethyst_02"},
		{id = 3060,	t = L["Regal Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3086,	t = L["Royal Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3051,	t = L["Blessed Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3100,	t = L["Soothing Amethyst"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3138,	t = L["Royal Shadowsong Amethyst"],	ic = "INV_Jewelcrafting_ShadowsongAmethyst_02"},
		{id = 3063,	t = L["Defender's Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3083,	t = L["Fluorescent Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3054,	t = L["Glowing Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3137,	t = L["Glowing Shadowsong Amethyst"],	ic = "INV_Jewelcrafting_ShadowsongAmethyst_02"},
		{id = 3064,	t = L["Imperial Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3045,	t = L["Sovereign Tanzanite"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		{id = 3133,	t = L["Sovereign Shadowsong Amethyst"],	ic = "INV_Jewelcrafting_ShadowsongAmethyst_02"},
		{id = 3099,	t = L["Infused Amethyst"],		ic = "INV_Jewelcrafting_Nightseye_03"},
		NoneTable,
	}},
}

local PrismaticGemMenu = {
	{[ITEM_QUALITY3_DESC] = {
		{id = 2947,	t = L["Prismatic Sphere"],	ic = "INV_Enchant_PrismaticSphere"},
		NoneTable,
	}},
	{[ITEM_QUALITY4_DESC] = {
		{id = 2948,	t = L["Void Sphere"],	ic = "INV_Enchant_VoidSphere"},
		NoneTable,
	}},
}

local GemsMetaMenu = {
	{id = 3154,	t = L["Relentless Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 2969,	t = L["Swift Windfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2829,	t = L["Swift Skyfire Diamond"],			ic = "INV_Misc_Gem_Diamond_07"},
	{id = 3162,	t = L["Potent Unstable Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2830,	t = L["Enigmatic Skyfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2833,	t = L["Tenacious Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 3274,	t = L["Eternal Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 2832,	t = L["Bracing Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 2835,	t = L["Insightful Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 2834,	t = L["Brutal Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 3261,	t = L["Chaotic Skyfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2827,	t = L["Destructive Skyfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2970,	t = L["Swift Starfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 3163,	t = L["Imbued Unstable Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 3275,	t = L["Ember Skyfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2831,	t = L["Powerful Earthstorm Diamond"],		ic = "INV_Misc_Gem_Diamond_06"},
	{id = 3155,	t = L["Thundering Skyfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	{id = 2828,	t = L["Mystical Skyfire Diamond"],		ic = "INV_Misc_Gem_Diamond_07"},
	NoneTable,
}

local GemsMenu = {
	{[BLUE_GEM]			= BlueGemMenu},
	{[RED_GEM]			= RedGemMenu},
	{[YELLOW_GEM]			= YellowGemMenu},
	{[L["Green (B/Y)"]]		= GreenGemMenu},
	{[L["Orange (R/Y)"]]		= OrangeGemMenu},
	{[L["Purple (R/B)"]]		= PurpleGemMenu},
	{[L["Prismatic (R/B/Y)"]]	= PrismaticGemMenu},
}

WoWEquip_GemsControlMenu = {
	[EMPTY_SOCKET_BLUE]	= {menu = GemsMenu,	ic = "Interface\\ItemSocketingFrame\\UI-EmptySocket-Blue"},
	[EMPTY_SOCKET_META]	= {menu = GemsMetaMenu,	ic = "Interface\\ItemSocketingFrame\\UI-EmptySocket-Meta"},
	[EMPTY_SOCKET_RED]	= {menu = GemsMenu,	ic = "Interface\\ItemSocketingFrame\\UI-EmptySocket-Red"},
	[EMPTY_SOCKET_YELLOW]	= {menu = GemsMenu,	ic = "Interface\\ItemSocketingFrame\\UI-EmptySocket-Yellow"},
}


-- Filter Options
-- The next part of the file deals with the Filter Options for searching items.
-- t	= is the text displayed on the menu.
-- id	= is the table index used to filter from WoWEquip_FilterTable[] in WoWEquip.lua.

WOWEQUIP_FILTERTABLE = {
--[[	Each line contains the localized string returns from GetItemInfo() that much
	match itemType, itemSubType and itemEquipLoc. A second itemEquipLoc can be specified
	as the 4th parameter. Indexes 111-114 represent the "Miscellaneous" filter option
	and contains a list of indexes that must NOT match in order to match the category
	"Miscellaneous". This list is also used multiple times in several locations.
	This table should not be altered.]]
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_CLOTH"]},	-- 1
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_LEATHER"]},	-- 2
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_MAIL"]},	-- 3
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_PLATE"]},	-- 4

	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_DAGGERS"], "INVTYPE_WEAPON", "INVTYPE_WEAPONMAINHAND"},	-- 5
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_FISTWEAPONS"], "INVTYPE_WEAPON", "INVTYPE_WEAPONMAINHAND"},	-- 6
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_1HAXES"], "INVTYPE_WEAPON", "INVTYPE_WEAPONMAINHAND"},	-- 7
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_1HMACES"], "INVTYPE_WEAPON", "INVTYPE_WEAPONMAINHAND"},	-- 8
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_1HSWORDS"], "INVTYPE_WEAPON", "INVTYPE_WEAPONMAINHAND"},	-- 9
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_FISHINGPOLE"], "INVTYPE_2HWEAPON"},				-- 10
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_POLEARMS"], "INVTYPE_2HWEAPON"},				-- 11
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_STAVES"], "INVTYPE_2HWEAPON"},				-- 12
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_2HAXES"], "INVTYPE_2HWEAPON"},				-- 13
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_2HMACES"], "INVTYPE_2HWEAPON"},				-- 14
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_2HSWORDS"], "INVTYPE_2HWEAPON"},				-- 15

	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_SHIELDS"], "INVTYPE_SHIELD"},					-- 16
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_MISC"], "INVTYPE_HOLDABLE"},					-- 17
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_DAGGERS"], "INVTYPE_WEAPON", "INVTYPE_WEAPONOFFHAND"},	-- 18
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_FISTWEAPONS"], "INVTYPE_WEAPON", "INVTYPE_WEAPONOFFHAND"},	-- 19
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_1HAXES"], "INVTYPE_WEAPON", "INVTYPE_WEAPONOFFHAND"},		-- 20
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_1HMACES"], "INVTYPE_WEAPON", "INVTYPE_WEAPONOFFHAND"},	-- 21
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_1HSWORDS"], "INVTYPE_WEAPON", "INVTYPE_WEAPONOFFHAND"},	-- 22

	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_BOWS"], "INVTYPE_RANGED"},		-- 23
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_CROSSBOWS"], "INVTYPE_RANGEDRIGHT"},	-- 24
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_GUNS"], "INVTYPE_RANGEDRIGHT"},	-- 25
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_THROWN"], "INVTYPE_THROWN"},		-- 26
	{L["WOW_EQUIP_ITEMTYPE_WEAPON"], L["WOW_EQUIP_ITEMSUBTYPE_WANDS"], "INVTYPE_RANGEDRIGHT"},	-- 27
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_IDOLS"], "INVTYPE_RELIC"},		-- 28
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_LIBRAMS"], "INVTYPE_RELIC"},		-- 29
	{L["WOW_EQUIP_ITEMTYPE_ARMOR"], L["WOW_EQUIP_ITEMSUBTYPE_TOTEMS"], "INVTYPE_RELIC"},		-- 30

	[111]	= {1, 2, 3, 4},					-- Armor class filter table
	[112]	= {5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},	-- Main hand filter table
	[113]	= {16, 17, 18, 19, 20, 21, 22},			-- Off hand filter table
	[114]	= {23, 24, 25, 26, 27, 28, 29, 30},		-- Ranged filter table
}

local WoWEquip_ArmorClassTable = {
	{id = 1,	t = L["Cloth"]},
	{id = 2,	t = L["Leather"]},
	{id = 3,	t = L["Mail"]},
	{id = 4,	t = L["Plate"]},
	{id = 111,	t = L["Miscellaneous"]},
	misctable = 111,
}

local WoWEquip_MainHandTable = {
	{id = 5, 	t = L["Daggers"]},
	{id = 6,	t = L["Fist Weapons"]},
	{id = 7,	t = L["One-Handed Axes"]},
	{id = 8,	t = L["One-Handed Maces"]},
	{id = 9,	t = L["One-Handed Swords"]},
	{id = 10,	t = L["Fishing Pole"]},
	{id = 11,	t = L["Polearms"]},
	{id = 12,	t = L["Staves"]},
	{id = 13,	t = L["Two-Handed Axes"]},
	{id = 14,	t = L["Two-Handed Maces"]},
	{id = 15,	t = L["Two-Handed Swords"]},
	{id = 112,	t = L["Miscellaneous"]},
	misctable = 112,
}

local WoWEquip_OffHandTable = {
	{id = 16,	t = L["Shields"]},
	{id = 17,	t = L["Off-hand"]},
	{id = 18,	t = L["Daggers"]},
	{id = 19,	t = L["Fist Weapons"]},
	{id = 20,	t = L["One-Handed Axes"]},
	{id = 21,	t = L["One-Handed Maces"]},
	{id = 22,	t = L["One-Handed Swords"]},
	{id = 113,	t = L["Miscellaneous"]},
	misctable = 113,
}

local WoWEquip_RangedTable = {
	{id = 23,	t = L["Bows"]},
	{id = 24,	t = L["Crossbows"]},
	{id = 25,	t = L["Guns"]},
	{id = 26,	t = L["Thrown"]},
	{id = 27,	t = L["Wands"]},
	{id = 28,	t = L["Idols"]},
	{id = 29,	t = L["Librams"]},
	{id = 30,	t = L["Totems"]},
	{id = 114,	t = L["Miscellaneous"]},
	misctable = 114,
}

WOWEQUIP_FILTEROPTIONS = {
	WoWEquip_ArmorClassTable,	-- Head		1
	nil,				-- Neck		2
	WoWEquip_ArmorClassTable,	-- Shoulder	3
	nil,				-- Shirt	4
	WoWEquip_ArmorClassTable,	-- Chest/Robe	5
	WoWEquip_ArmorClassTable,	-- Waist	6
	WoWEquip_ArmorClassTable,	-- Legs		7
	WoWEquip_ArmorClassTable,	-- Feet		8
	WoWEquip_ArmorClassTable,	-- Wrist	9
	WoWEquip_ArmorClassTable,	-- Hands	10
	nil,				-- Finger	11
	nil,				-- Finger	12
	nil,				-- Trinket	13
	nil,				-- Trinket	14
	nil,				-- Cloak	15
	WoWEquip_MainHandTable,		-- MainHand	16
	WoWEquip_OffHandTable,		-- OffHand	17
	WoWEquip_RangedTable,		-- Ranged	18
	nil,				-- Tabard	19
}

WOWEQUIP_SLOTS = {
	-- List of itemSlots (without the "Slot" suffix) to display
	-- These strings are NOT meant to be localized!
	"Head",
	"Neck",
	"Shoulder",
	"Back",
	"Chest",
	"Shirt",
	"Tabard",
	"Wrist",
	"Hands",
	"Waist",
	"Legs",
	"Feet",
	"Finger0",
	"Finger1",
	"Trinket0",
	"Trinket1",
	"MainHand",
	"SecondaryHand",
	"Ranged",
}

-- The following strings are used to display the slotnames corresponding to WOWEQUIP_SLOTS above
-- These are meant to be localized!
WOWEQUIP_SLOTS_TEXT = {
	L["Head"],
	L["Neck"],
	L["Shoulder"],
	L["Back"],
	L["Chest"],
	L["Shirt"],
	L["Tabard"],
	L["Wrist"],
	L["Hands"],
	L["Waist"],
	L["Legs"],
	L["Feet"],
	L["Top Finger"],
	L["Bottom Finger"],
	L["Top Trinket"],
	L["Bottom Trinket"],
	L["Main Hand"],
	L["Off-hand"],
	L["Ranged"],
}

WOWEQUIP_EQUIPLOC = {
	-- List of possible itemEquipLoc returns and their corresponding equipSlotID
	--INVTYPE_AMMO = 0,
	INVTYPE_HEAD = 1,
	INVTYPE_NECK = 2,
	INVTYPE_SHOULDER = 3,
	INVTYPE_BODY = 4,
	INVTYPE_CHEST = 5,
	INVTYPE_ROBE = 5,
	INVTYPE_WAIST = 6,
	INVTYPE_LEGS = 7,
	INVTYPE_FEET = 8,
	INVTYPE_WRIST = 9,
	INVTYPE_HAND = 10,
	INVTYPE_FINGER = 11,
	INVTYPE_TRINKET = 13,
	INVTYPE_CLOAK = 15,
	INVTYPE_WEAPON = 16,
	INVTYPE_SHIELD = 17,
	INVTYPE_2HWEAPON = 16,
	INVTYPE_WEAPONMAINHAND = 16,
	INVTYPE_WEAPONOFFHAND = 17,
	INVTYPE_HOLDABLE = 17,
	INVTYPE_RANGED = 18,
	INVTYPE_THROWN = 18,
	INVTYPE_RANGEDRIGHT = 18,
	INVTYPE_RELIC = 18,
	INVTYPE_TABARD = 19,
	--INVTYPE_BAG = 20,	  -- 21, 22, 23
	-- Note: Trinkets can go in 14, Rings to 12 and Weapon to 17 as well.
	-- WoWEquip:CheckSlot(itemEquipLoc, slotnum) takes care of that
}



-- Sort Options
-- t	= is the text displayed on the menu.
-- id	= is the table index used to perform sorting in WoWEquip_SortDispList()
-- 		in WoWEquip_SortTable[] in WoWEquip.lua.

WoWEquip_SortOptions = {
	{id = 1,	t = L["by ItemLevel > Name > Rarity"]},
	{id = 2,	t = L["by ItemLevel > Rarity > Name"]},
	{id = 3,	t = L["by Name > ItemLevel > Rarity"]},
	{id = 4,	t = L["by Name > Rarity > ItemLevel"]},
	{id = 5,	t = L["by Rarity > ItemLevel > Name"]},
	{id = 6,	t = L["by Rarity > Name > ItemLevel"]},
}

WOWEQUIP_SORTTABLE = {
	-- 1 == Rarity, 2 == ItemLevel, 3 == Name
	{2, 3, 1},	-- 1, ilvl > name > rarity
	{2, 1, 3},	-- 2, ilvl > rarity > name
	{3, 2, 1},	-- 3, name > ilvl > rarity
	{3, 1, 2},	-- 4, name > rarity > ilvl
	{1, 2, 3},	-- 5, rarity > ilvl > name
	{1, 3, 2},	-- 6, rarity > name > ilvl
}


-- Compare Options
WoWEquip_CompareOptions = {
	{id = 1,	t = L["Don't compare"]},
	{id = 2,	t = L["Currently equipped gear"]},
	{id = 3,	t = L["Selected profile..."]},
}


-- Class Options
WoWEquip_ClassOptions = {
	{id = 1,	t = L["Warrior"]},
	{id = 2,	t = L["Paladin"]},
	{id = 3,	t = L["Hunter"]},
	{id = 4,	t = L["Rogue"]},
	{id = 5,	t = L["Priest"]},
	{id = 6,	t = L["Shaman"]},
	{id = 7,	t = L["Mage"]},
	{id = 8,	t = L["Warlock"]},
	{id = 9,	t = L["Druid"]},
}

WOWEQUIP_CLASSID = {
	"WARRIOR",
	"PALADIN",
	"HUNTER",
	"ROGUE",
	"PRIEST",
	"SHAMAN",
	"MAGE",
	"WARLOCK",
	"DRUID",
	["WARRIOR"] = 1,
	["PALADIN"] = 2,
	["HUNTER"] = 3,
	["ROGUE"] = 4,
	["PRIEST"] = 5,
	["SHAMAN"] = 6,
	["MAGE"] = 7,
	["WARLOCK"] = 8,
	["DRUID"] = 9,
}

-- Race Options
WoWEquip_RaceOptions = {
	{id = 1,	t2 = L["Draenei"],	t = L["Draenei (+1% Hit/Spellhit)"]},
	{id = 2,	t2 = L["Dwarf"],	t = L["Dwarf"]},
	{id = 3,	t2 = L["Gnome"],	t = L["Gnome (+5% Intelligence)"]},
	{id = 4,	t2 = L["Human"],	t = L["Human (+10% Spirit)"]},
	{id = 5,	t2 = L["NightElf"],	t = L["Night Elf (+1% Dodge)"]},
	{id = 6,	t2 = L["BloodElf"],	t = L["Blood Elf"]},
	{id = 7,	t2 = L["Orc"],		t = L["Orc"]},
	{id = 8,	t2 = L["Tauren"],	t = L["Tauren (+5% Maximum Health)"]},
	{id = 9,	t2 = L["Troll"],	t = L["Troll"]},
	{id = 10,	t2 = L["Scourge"],	t = L["Undead"]},
	{id = 0,	t2 = NONE,		t = NONE},
	[0] = {id = 0,	t2 = NONE,		t = NONE},
}

WOWEQUIP_RACEID = {
	"Draenei",
	"Dwarf",
	"Gnome",
	"Human",
	"NightElf",
	"BloodElf",
	"Orc",
	"Tauren",
	"Troll",
	"Scourge",
	["Draenei"]	= 1,
	["Dwarf"]	= 2,
	["Gnome"]	= 3,
	["Human"]	= 4,
	["NightElf"]	= 5,
	["BloodElf"]	= 6,
	["Orc"]		= 7,
	["Tauren"]	= 8,
	["Troll"]	= 9,
	["Scourge"]	= 10,
	["None"]	= 0,
	[0]		= "None",
}


-- List of gem enchantIDs that belong to a color
local function BuildGemTable(build, info)
	for k, v in pairs(info) do
		if v.id then
			build[v.id] = true
		else
			BuildGemTable(build, v)
		end
	end
end
WoWEquip_GemColorData = {yellow = {}, red = {}, blue = {}, meta = {}}
BuildGemTable(WoWEquip_GemColorData.yellow, YellowGemMenu)
BuildGemTable(WoWEquip_GemColorData.yellow, OrangeGemMenu)
BuildGemTable(WoWEquip_GemColorData.yellow, GreenGemMenu)
BuildGemTable(WoWEquip_GemColorData.yellow, PrismaticGemMenu)
BuildGemTable(WoWEquip_GemColorData.red, RedGemMenu)
BuildGemTable(WoWEquip_GemColorData.red, OrangeGemMenu)
BuildGemTable(WoWEquip_GemColorData.red, PurpleGemMenu)
BuildGemTable(WoWEquip_GemColorData.red, PrismaticGemMenu)
BuildGemTable(WoWEquip_GemColorData.blue, BlueGemMenu)
BuildGemTable(WoWEquip_GemColorData.blue, GreenGemMenu)
BuildGemTable(WoWEquip_GemColorData.blue, PurpleGemMenu)
BuildGemTable(WoWEquip_GemColorData.blue, PrismaticGemMenu)
BuildGemTable(WoWEquip_GemColorData.meta, GemsMetaMenu)
BuildGemTable = nil


-- This is arranged in the order to show in menus
WoWEquip_TalentData = {
	{	-- ["WARRIOR"] = 1,
		"WARRIOR|Arms|Deflection|5",
		"WARRIOR|Fury|Cruelty|5",
		"WARRIOR|Fury|Precision|3",
		"WARRIOR|Protection|Anticipation|5",
		"WARRIOR|Protection|Toughness|5",
		"WARRIOR|Protection|Vitality|5",
	},
	{	-- ["PALADIN"] = 2,
		"PALADIN|Holy|Divine Strength|5",
		"PALADIN|Holy|Divine Intellect|5",
		"PALADIN|Holy|Holy Power|5",
		"PALADIN|Holy|Holy Guidance|5",
		"PALADIN|Protection|Precision|3",
		"PALADIN|Protection|Toughness|5",
		"PALADIN|Protection|Anticipation|5",
		"PALADIN|Protection|Sacred Duty|2",
		"PALADIN|Protection|Combat Expertise|5",
		"PALADIN|Retribution|Deflection|5",
		"PALADIN|Retribution|Conviction|5",
		"PALADIN|Retribution|Sanctified Seals|3",
	},
	{	-- ["HUNTER"] = 3,
		"HUNTER|Beast Mastery|Enduring Training|5",
		"HUNTER|Beast Mastery|Thick Hide|3",
		"HUNTER|Marksmanship|Lethal Shots|5",
		"HUNTER|Marksmanship|Combat Experience|2",
		"HUNTER|Marksmanship|Careful Aim|3",
		"HUNTER|Marksmanship|Master Marksman|5",
		"HUNTER|Survival|Deflection|5",
		"HUNTER|Survival|Survivalist|5",
		"HUNTER|Survival|Surefooted|3",
		"HUNTER|Survival|Survival Instincts|2",
		"HUNTER|Survival|Killer Instinct|3",
		"HUNTER|Survival|Lightning Reflexes|5",
	},
	{	-- ["ROGUE"] = 4,
		"ROGUE|Assassination|Malice|5",
		"ROGUE|Combat|Lightning Reflexes|5",
		"ROGUE|Combat|Deflection|5",
		"ROGUE|Combat|Precision|5",
		"ROGUE|Combat|Vitality|2",
		"ROGUE|Subtlety|Deadliness|5",
		"ROGUE|Subtlety|Sinister Calling|5",
	},
	{	-- ["PRIEST"] = 5,
		"PRIEST|Discipline|Mental Strength|5",
		"PRIEST|Discipline|Force of Will|5",
		"PRIEST|Discipline|Enlightenment|5",
		"PRIEST|Holy|Holy Specialization|5",
		"PRIEST|Holy|Spirit of Redemption|1",
		"PRIEST|Holy|Spiritual Guidance|5",
		"PRIEST|Holy|Spiritual Healing|5",
		"PRIEST|Shadow|Shadow Focus|5",
		"PRIEST|Shadow|Darkness|5",
	},
	{	-- ["SHAMAN"] = 6,
		"SHAMAN|Elemental|Elemental Precision|3",
		"SHAMAN|Enhancement|Ancestral Knowledge|5",
		"SHAMAN|Enhancement|Shield Specialization|5",
		"SHAMAN|Enhancement|Thundering Strikes|5",
		"SHAMAN|Enhancement|Anticipation|5",
		"SHAMAN|Enhancement|Toughness|5",
		"SHAMAN|Enhancement|Mental Quickness|3",
		"SHAMAN|Restoration|Nature's Guidance|3",
		"SHAMAN|Restoration|Purification|5",
		"SHAMAN|Restoration|Nature's Blessing|3",
	},
	{	-- ["MAGE"] = 7,
		"MAGE|Arcane|Arcane Focus|5",
		"MAGE|Arcane|Arcane Fortitude|1",
		"MAGE|Arcane|Arcane Mind|5",
		"MAGE|Arcane|Arcane Instability|3",
		"MAGE|Arcane|Mind Mastery|3",
		"MAGE|Fire|Playing with Fire|3",
		"MAGE|Fire|Critical Mass|3",
		"MAGE|Fire|Fire Power|5",
		"MAGE|Fire|Pyromaniac|3",
		"MAGE|Frost|Elemental Precision|3",
		"MAGE|Frost|Piercing Ice|3",
		"MAGE|Frost|Arctic Winds|5",
	},
	{	-- ["WARLOCK"] = 8,
		"WARLOCK|Affliction|Shadow Mastery|5",
		"WARLOCK|Demonology|Demonic Embrace|5",
		"WARLOCK|Demonology|Fel Intellect|3",
		"WARLOCK|Demonology|Fel Stamina|3",
		"WARLOCK|Demonology|Demonic Tactics|5",
		"WARLOCK|Destruction|Emberstorm|5",
		"WARLOCK|Destruction|Backlash|3",
	},
	{	-- ["DRUID"] = 9,
		"DRUID|Balance|Lunar Guidance|3",
		"DRUID|Balance|Balance of Power|2",
		"DRUID|Feral Combat|Thick Hide|3",
		"DRUID|Feral Combat|Nurturing Instinct|2",
		"DRUID|Feral Combat|Heart of the Wild|5",
		"DRUID|Feral Combat|Survival of the Fittest|3",
		"DRUID|Restoration|Gift of Nature|5",
		"DRUID|Restoration|Living Spirit|3",
		"DRUID|Restoration|Natural Perfection|3",
	},
}

-- Table caches to promote table reuse
local t4710 = {4, 7, 10}

-- The data here is purely for menu display, the numbers here are not
-- used for calculations and are hardcoded into the main addon code.
-- ["class|tree|talent|maxrank"] = {
--   t   = "display format text",
--   m   = rank muiltiplier,
--   m2  = rank muiltiplier 2,
--   d   = {data table},
--   d2  = {data table 2},
--   ic  = "icon texture",
--   p   = multi part data,
--   tab = tab index of the talent
--   num = number index of the talent in the tab
-- }
WoWEquip_TalentData2 = {
	["WARRIOR|Arms|Deflection|5"] = {
		t = L["Increases your Parry chance by %d%%"],
		m = 1,
		ic = "Ability_Parry",
		tab = 1, num = 2,
	},
	["WARRIOR|Fury|Cruelty|5"] = {
		t = L["Increases your chance to get a critical strike with melee weapons by %d%%"],
		m = 1,
		ic = "Ability_Rogue_Eviscerate",
		tab = 2, num = 2,
	},
	--Weapon Mastery - Reduces the chance for your attacks to be dodged by 1/2% and....
	["WARRIOR|Fury|Precision|3"] = {
		t = L["Increases your chance to hit with melee weapons by %d%%"],
		m = 1,
		ic = "Ability_Marksmanship",
		tab = 2, num = 17,
	},
	["WARRIOR|Protection|Anticipation|5"] = {
		t = L["Increases your Defense skill by %d"],
		m = 4,
		ic = "Spell_Nature_MirrorImage",
		tab = 3, num = 3,
	},
	["WARRIOR|Protection|Toughness|5"] = {
		t = L["Increases your armor value from items by %d%%"],
		m = 2,
		ic = "Spell_Holy_Devotion",
		tab = 3, num = 5,
	},
	--Defiance - Increases the threat generated by your attacks by 5/10/15% while in Defensive Stance and increases your expertise by 2/4/6.
	["WARRIOR|Protection|Vitality|5"] = {
		t = L["Increases your total Stamina by %d%% and your total Strength by %d%%"],
		p = 2,
		m = 1,
		m2 = 2,
		ic = "INV_Helmet_21",
		tab = 3, num = 21,
	},
	["PALADIN|Holy|Divine Strength|5"] = {
		t = L["Increases your total Strength by %d%%"],
		m = 2,
		ic = "Ability_GolemThunderClap",
		tab = 1, num = 1,
	},
	["PALADIN|Holy|Divine Intellect|5"] = {
		t = L["Increases your total Intellect by %d%%"],
		m = 2,
		ic = "Spell_Nature_Sleep",
		tab = 1, num = 2,
	},
	["PALADIN|Holy|Holy Power|5"] = {
		t = L["Increases the critical effect chance of your Holy spells by %d%%"],
		m = 1,
		ic = "Spell_Holy_Power",
		tab = 1, num = 15,
	},
	["PALADIN|Holy|Holy Guidance|5"] = {
		t = L["Increases your spell damage and healing by %d%% of your total Intellect"],
		m = 7,
		ic = "Spell_Holy_HolyGuidance",
		tab = 1, num = 19,
	},
	["PALADIN|Protection|Precision|3"] = {
		t = L["Increases your chance to hit with melee weapons and spells by %d%%"],
		m = 1,
		ic = "Ability_Rogue_Ambush",
		tab = 2, num = 3,
	},
	["PALADIN|Protection|Toughness|5"] = {
		t = L["Increases your armor value from items by %d%%"],
		m = 2,
		ic = "Spell_Holy_Devotion",
		tab = 2, num = 5,
	},
	["PALADIN|Protection|Anticipation|5"] = {
		t = L["Increases your Defense skill by %d"],
		m = 4,
		ic = "Spell_Magic_LesserInvisibilty",
		tab = 2, num = 9,
	},
	["PALADIN|Protection|Sacred Duty|2"] = {
		t = L["Increases your total Stamina by %d%%"],
		m = 3,
		ic = "Spell_Holy_DivineIntervention",
		tab = 2, num = 16,
	},
	["PALADIN|Protection|Combat Expertise|5"] = {
		t = L["Increases your total Stamina by %d%%"], -- and your expertise by 1/2/3/4/5
		m = 2,
		ic = "Spell_Holy_WeaponMastery",
		tab = 2, num = 21,
	},
	["PALADIN|Retribution|Deflection|5"] = {
		t = L["Increases your Parry chance by %d%%"],
		m = 1,
		ic = "Ability_Parry",
		tab = 3, num = 5,
	},
	["PALADIN|Retribution|Conviction|5"] = {
		t = L["Increases your chance to get a critical strike with melee weapons by %d%%"],
		m = 1,
		ic = "Spell_Holy_RetributionAura",
		tab = 3, num = 7,
	},
	["PALADIN|Retribution|Sanctified Seals|3"] = {
		t = L["Increases your chance to critically hit with all spells and melee attacks by %d%%"], -- and reduces the chance your Seals will be dispelled by 33/66/100%
		m = 1,
		ic = "Spell_Holy_HolySmite",
		tab = 3, num = 18,
	},
	["HUNTER|Beast Mastery|Enduring Training|5"] = {
		t = L["Increases your total health by %d%%"],
		m = 1,
		ic = "Spell_Nature_Reincarnation",
		tab = 1, num = 2,
	},
	["HUNTER|Beast Mastery|Thick Hide|3"] = {
		t = L["Increases your armor value from items by %d%%"],
		d = t4710,
		ic = "INV_Misc_Pelt_Bear_03",
		tab = 1, num = 5,
	},
	["HUNTER|Marksmanship|Lethal Shots|5"] = {
		t = L["Increases your critical strike chance with ranged weapons by %d%%"],
		m = 1,
		ic = "Ability_SearingArrow",
		tab = 2, num = 2,
	},
	["HUNTER|Marksmanship|Combat Experience|2"] = {
		t = L["Increases your total Agility by %d%% and your total Intellect by %d%%"],
		p = 2,
		m = 1,
		m2 = 3,
		ic = "Ability_Hunter_CombatExperience",
		tab = 2, num = 14,
	},
	["HUNTER|Marksmanship|Careful Aim|3"] = {
		t = L["Increases your ranged attack power by an amount equal to %d%% of your total Intellect"],
		m = 15,
		ic = "Ability_Hunter_ZenArchery",
		tab = 2, num = 16,
	},
	["HUNTER|Marksmanship|Master Marksman|5"] = {
		t = L["Increases your ranged attack power by %d%%"],
		m = 2,
		ic = "Ability_Hunter_MasterMarksman",
		tab = 2, num = 19,
	},
	["HUNTER|Survival|Deflection|5"] = {
		t = L["Increases your Parry chance by %d%%"],
		m = 1,
		ic = "Ability_Parry",
		tab = 3, num = 6,
	},
	["HUNTER|Survival|Survivalist|5"] = {
		t = L["Increases your total health by %d%%"],
		m = 2,
		ic = "Spell_Shadow_Twilight",
		tab = 3, num = 9,
	},
	["HUNTER|Survival|Surefooted|3"] = {
		t = L["Increases hit chance by %d%%"],
		m = 1,
		ic = "Ability_Kick",
		tab = 3, num = 12,
	},
	["HUNTER|Survival|Survival Instincts|2"] = {
		t = L["Increases your Attack Power by %d%%"],
		m = 2,
		ic = "Ability_Hunter_SurvivalInstincts",
		tab = 3, num = 14,
	},
	["HUNTER|Survival|Killer Instinct|3"] = {
		t = L["Increases your critical strike chance with all attacks by %d%%"],
		m = 1,
		ic = "Spell_Holy_BlessingOfStamina",
		tab = 3, num = 15,
	},
	["HUNTER|Survival|Lightning Reflexes|5"] = {
		t = L["Increases your Agility by %d%%"],
		m = 3,
		ic = "Spell_Nature_Invisibilty",
		tab = 3, num = 18,
	},
	["ROGUE|Assassination|Malice|5"] = {
		t = L["Increases your critical strike chance by %d%%"],
		m = 1,
		ic = "Ability_Racial_BloodRage",
		tab = 1, num = 3,
	},
	["ROGUE|Combat|Lightning Reflexes|5"] = {
		t = L["Increases your Dodge chance by %d%%"],
		m = 1,
		ic = "Spell_Nature_Invisibilty",
		tab = 2, num = 3,
	},
	["ROGUE|Combat|Deflection|5"] = {
		t = L["Increases your Parry chance by %d%%"],
		m = 1,
		ic = "Ability_Parry",
		tab = 2, num = 5,
	},
	["ROGUE|Combat|Precision|5"] = {
		t = L["Increases your chance to hit with weapons by %d%%"],
		m = 1,
		ic = "Ability_Marksmanship",
		tab = 2, num = 6,
	},
	--Weapon Expertise - Increases your expertise by 5/10.
	["ROGUE|Combat|Vitality|2"] = {
		t = L["Increases your total Stamina by %d%% and your total Agility by %d%%"],
		p = 2,
		m = 2,
		m2 = 1,
		ic = "Ability_Warrior_Revenge",
		tab = 2, num = 20,
	},
	["ROGUE|Subtlety|Deadliness|5"] = {
		t = L["Increases your Attack Power by %d%%"],
		m = 2,
		ic = "INV_Weapon_Crossbow_11",
		tab = 3, num = 17,
	},
	["ROGUE|Subtlety|Sinister Calling|5"] = {
		t = L["Increases your Agility by %d%%"],
		m = 3,
		ic = "Ability_Rogue_SinisterCalling",
		tab = 3, num = 21,
	},
	--Meditation - Allows 10/20/30% of your Mana regeneration to continue while casting.
	["PRIEST|Discipline|Mental Strength|5"] = {
		t = L["Increases your maximum Mana by %d%%"],
		m = 2,
		ic = "Spell_Nature_EnchantArmor",
		tab = 1, num = 13,
	},
	["PRIEST|Discipline|Force of Will|5"] = {
		t = L["Increases your spell damage by %d%%"], -- and the critical strike chance of your offensive spells by 1/2/3/4/5%
		m = 1,
		ic = "Spell_Nature_SlowingTotem",
		tab = 1, num = 17,
	},
	["PRIEST|Discipline|Enlightenment|5"] = {
		t = L["Increases your total Stamina, Intellect, and Spirit by %d%%"],
		m = 1,
		ic = "Spell_Arcane_MindMastery",
		tab = 1, num = 21,
	},
	["PRIEST|Holy|Holy Specialization|5"] = {
		t = L["Increases the critical effect chance of your Holy spells by %d%%"],
		m = 1,
		ic = "Spell_Holy_SealOfSalvation",
		tab = 2, num = 3,
	},
	["PRIEST|Holy|Spirit of Redemption|1"] = {
		t = L["Increases your total Spirit by %d%%"],
		m = 5,
		ic = "INV_Enchant_EssenceEternalLarge",
		tab = 2, num = 13,
	},
	["PRIEST|Holy|Spiritual Guidance|5"] = {
		t = L["Increases spell damage and healing by up to %d%% of your total Spirit"],
		m = 5,
		ic = "Spell_Holy_SpiritualGuidence",
		tab = 2, num = 14,
	},
	["PRIEST|Holy|Spiritual Healing|5"] = {
		t = L["Increases the amount healed by your healing spells by %d%%"],
		m = 2,
		ic = "Spell_Nature_MoonGlow",
		tab = 2, num = 16,
	},
	["PRIEST|Shadow|Shadow Focus|5"] = {
		t = L["Reduces your target's chance to resist your Shadow spells by %d%%"],
		m = 2,
		ic = "Spell_Shadow_BurningSpirit",
		tab = 3, num = 5,
	},
	["PRIEST|Shadow|Darkness|5"] = {
		t = L["Increases your Shadow spell damage by %d%%"],
		m = 2,
		ic = "Spell_Shadow_Twilight",
		tab = 3, num = 17,
	},
	--Unrelenting Storm - Regenerate mana equal to 2/4/6/8/10% of your Intellect every 5 sec, even while casting.
	["SHAMAN|Elemental|Elemental Precision|3"] = {
		t = L["Increases your chance to hit with Fire, Frost and Nature spells by %d%%"],
		m = 2,
		ic = "Spell_Nature_ElementalPrecision_1",
		tab = 1, num = 15,
	},
	["SHAMAN|Enhancement|Ancestral Knowledge|5"] = {
		t = L["Increases your maximum Mana by %d%%"],
		m = 1,
		ic = "Spell_Shadow_GrimWard",
		tab = 2, num = 1,
	},
	["SHAMAN|Enhancement|Shield Specialization|5"] = {
		t = L["Increases your chance to block attacks with a shield by %d%%"], -- and increases the amount blocked by 5/10/15/20/25%
		m = 1,
		ic = "INV_Shield_06",
		tab = 2, num = 2,
	},
	["SHAMAN|Enhancement|Thundering Strikes|5"] = {
		t = L["Improves your chance to get a critical strike with your weapon attacks by %d%%"],
		m = 1,
		ic = "Ability_ThunderBolt",
		tab = 2, num = 4,
	},
	["SHAMAN|Enhancement|Anticipation|5"] = {
		t = L["Increases your chance to dodge by an additional %d%%"],
		m = 1,
		ic = "Spell_Nature_MirrorImage",
		tab = 2, num = 9,
	},
	["SHAMAN|Enhancement|Toughness|5"] = {
		t = L["Increases your armor value from items by %d%%"],
		m = 2,
		ic = "Spell_Holy_Devotion",
		tab = 2, num = 11,
	},
	["SHAMAN|Enhancement|Mental Quickness|3"] = {
		t = L["increases your spell damage and healing by an amount equal to %d%% of your attack power"], -- and reduces the mana cost of your instant cast spells by 2/4/6%
		m = 10,
		ic = "Spell_Nature_MentalQuickness",
		tab = 2, num = 15,
	},
	["SHAMAN|Restoration|Nature's Guidance|3"] = {
		t = L["Increases your chance to hit with melee attacks and spells by %d%%"],
		m = 1,
		ic = "Spell_Frost_Stun",
		tab = 3, num = 6,
	},
	["SHAMAN|Restoration|Purification|5"] = {
		t = L["Increases the amount healed by your healing spells by %d%%"],
		m = 2,
		ic = "Spell_Frost_WizardMark",
		tab = 3, num = 15,
	},
	["SHAMAN|Restoration|Nature's Blessing|3"] = {
		t = L["Increases your spell damage and healing by %d%% of your total Intellect"],
		m = 10,
		ic = "Spell_Nature_NatureBlessing",
		tab = 3, num = 18,
	},
	["MAGE|Arcane|Arcane Focus|5"] = {
		t = L["Reduces the chance that the opponent can resist your Arcane spells by %d%%"],
		m = 2,
		ic = "Spell_Holy_Devotion",
		tab = 1, num = 2,
	},
	["MAGE|Arcane|Arcane Fortitude|1"] = {
		t = L["Increases your armor by an amount equal to %d%% of your Intellect"],
		m = 100,
		ic = "Spell_Arcane_ArcaneResilience",
		tab = 1, num = 9,
	},
	["MAGE|Arcane|Arcane Mind|5"] = {
		t = L["Increases your total Intellect by %d%%"],
		m = 3,
		ic = "Spell_Shadow_Charm",
		tab = 1, num = 15,
	},
	["MAGE|Arcane|Arcane Instability|3"] = {
		t = L["Increases your spell damage and critical strike chance by %d%%"],
		m = 1,
		ic = "Spell_Shadow_Teleport",
		tab = 1, num = 17,
	},
	-- Arcane Meditation - Allows 10/20/30% of your mana regeneration to continue while casting.
	["MAGE|Arcane|Mind Mastery|3"] = {
		t = L["Increases spell damage by %d%% of your total Intellect"],
		m = 5,
		ic = "Spell_Arcane_MindMastery",
		tab = 1, num = 22,
	},
	["MAGE|Fire|Playing with Fire|3"] = {
		t = L["Increases all spell damage caused and taken by %d%%"],
		m = 1,
		ic = "Spell_Fire_PlayingWithFire",
		tab = 2, num = 13,
	},
	["MAGE|Fire|Critical Mass|3"] = {
		t = L["Increases the critical strike chance of your Fire spells by %d%%"],
		m = 2,
		ic = "Spell_Nature_WispHeal",
		tab = 2, num = 14,
	},
	["MAGE|Fire|Fire Power|5"] = {
		t = L["Increases the damage done by your Fire spells by %d%%"],
		m = 2,
		ic = "Spell_Fire_Immolation",
		tab = 2, num = 17,
	},
	["MAGE|Fire|Pyromaniac|3"] = {
		t = L["Increases chance to critically hit with all Fire spells by an additional %d%%"],
		m = 1,
		ic = "Spell_Fire_Burnout",
		tab = 2, num = 18,
	},
	["MAGE|Frost|Elemental Precision|3"] = {
		t = L["Reduces the chance targets resist your Frost and Fire spells by %d%%"],
		m = 1,
		ic = "Spell_Ice_MagicDamage",
		tab = 3, num = 3,
	},
	["MAGE|Frost|Piercing Ice|3"] = {
		t = L["Increases the damage done by your Frost spells by %d%%"],
		m = 2,
		ic = "Spell_Frost_Frostbolt",
		tab = 3, num = 8,
	},
	["MAGE|Frost|Arctic Winds|5"] = {
		t = L["Increases all Frost damage you cause by %d%%"],
		m = 1,
		ic = "Spell_Frost_ArcticWinds",
		tab = 3, num = 20,
	},
	["WARLOCK|Affliction|Shadow Mastery|5"] = {
		t = L["Increases the damage dealt by your Shadow spells by %d%%"],
		m = 2,
		ic = "Spell_Shadow_ShadeTrueSight",
		tab = 1, num = 16,
	},
	["WARLOCK|Demonology|Demonic Embrace|5"] = {
		t = L["Increases you total Stamina by %d%%, but reduces your total Spirit by %d%%"],
		p = 2,
		m = 3,
		m2 = 1,
		ic = "Spell_Shadow_Metamorphosis",
		tab = 2, num = 3,
	},
	["WARLOCK|Demonology|Fel Intellect|3"] = {
		t = L["Increases your maximum Mana by %d%%"],
		m = 1,
		ic = "Spell_Holy_MagicalSentry",
		tab = 2, num = 6,
	},
	["WARLOCK|Demonology|Fel Stamina|3"] = {
		t = L["Increases your total Stamina by %d%%"],
		m = 1,
		ic = "Spell_Shadow_AntiShadow",
		tab = 2, num = 9,
	},
	--Demonic Knowledge - Increases your spell damage by an amount equal to 5/10/15% of the total of your active demon's Stamina plus Intellect.
	["WARLOCK|Demonology|Demonic Tactics|5"] = {
		t = L["Increases melee and spell critical strike chance by %d%%"],
		m = 1,
		ic = "Spell_Shadow_DemonicTactics",
		tab = 2, num = 21,
	},
	["WARLOCK|Destruction|Emberstorm|5"] = {
		t = L["Increases the damage done by your Fire spells by %d%%"],
		m = 2,
		ic = "Spell_Fire_SelfDestruct",
		tab = 3, num = 16,
	},
	["WARLOCK|Destruction|Backlash|3"] = {
		t = L["Increases your critical strike chance with spells by %d%%"],
		m = 1,
		ic = "Spell_Fire_PlayingWithFire",
		tab = 3, num = 17,
	},
	["DRUID|Balance|Lunar Guidance|3"] = {
		t = L["Increases your spell damage and healing by %d%% of your total Intellect"],
		d = {8, 16, 25},
		ic = "Ability_Druid_LunarGuidance",
		tab = 1, num = 12,
	},
	--Dreamstate - Regenerate mana equal to 4/7/10% of your Intellect every 5 sec, even while casting.
	["DRUID|Balance|Balance of Power|2"] = {
		t = L["Increases your chance to hit with all spells by %d%%"],
		m = 2,
		ic = "Ability_Druid_BalanceofPower",
		tab = 1, num = 16,
	},
	["DRUID|Feral Combat|Thick Hide|3"] = {
		t = L["Increases your armor value from items by %d%%"],
		d = t4710,
		ic = "INV_Misc_Pelt_Bear_03",
		tab = 2, num = 5,
	},
	["DRUID|Feral Combat|Nurturing Instinct|2"] = {
		t = L["Increases your healing spells by up to %d%% of your Agility"],
		m = 50,
		ic = "Ability_Druid_HealingInstincts",
		tab = 2, num = 14,
	},
	["DRUID|Feral Combat|Heart of the Wild|5"] = {
		t = L["Increases your total Intellect by %d%%"], -- In addition, while in Bear or Dire Bear Form your Stamina is increased by 4/8/12/16/20% and while in Cat Form your attack power is increased by 2/4/6/8/10%.
		m = 4,
		ic = "Spell_Holy_BlessingOfAgility",
		tab = 2, num = 15,
	},
	["DRUID|Feral Combat|Survival of the Fittest|3"] = {
		t = L["Increases all attributes by %d%%"], -- And reduces the chances you'll be critically hit by melee attacks
		m = 1,
		ic = "Ability_Druid_Enrage",
		tab = 2, num = 16,
	},
	--Intensity - Allows 10/20/30% of your Mana regeneration to continue while casting and causes your Enrage ability to instantly generate 4/7/10 rage.
	["DRUID|Restoration|Gift of Nature|5"] = {
		t = L["Increases the amount healed by your healing spells by %d%%"],
		m = 2,
		ic = "Spell_Nature_ProtectionformNature",
		tab = 3, num = 12,
	},
	["DRUID|Restoration|Living Spirit|3"] = {
		t = L["Increases your total Spirit by %d%%"],
		m = 5,
		ic = "Spell_Nature_GiftoftheWaterSpirit",
		tab = 3, num = 16,
	},
	["DRUID|Restoration|Natural Perfection|3"] = {
		t = L["Increases your critical strike chance with spells by %d%%"],
		m = 1,
		ic = "Ability_Druid_NaturalPerfection",
		tab = 3, num = 18,
	},
}

--[[
itemIDtoEnchantID = {}
local itemLink = "|cff0070dd|Hitem:27773:0:%d:0:0:0:0:0|h[Barbaric Legstraps]|h|r"

for enchantID=1,4000 do
	local gem1Link = select(2, GetItemGem(itemLink:format(enchantID), 1) )
	if gem1Link then
		local itemID = gem1Link:match("item:(%d+):")
		itemIDtoEnchantID[tonumber(itemID)] = enchantID
	end
end
]]
