﻿--[[
****************************************************************************************
WoWEquip v0.91
2 April 2008
(Written for live servers v2.3.2.7741)

Author: Xinhuan @ US Blackrock Alliance
****************************************************************************************
Description:
	Try on different gear and see their total stats and their differences.
	In short, an ingame CT-Profiles-like addon.

	Users of WoWEquip are encouraged to use the addon RatingBuster written by
	Whitetooth@Cenarius.

Notes:
	In the process of coding WoWEquip and favouring to add more new features,
	there are currently no "validity checks" coded in to ensure that impossible
	combinations of gear/gems/enchants and talents/race/class do not occur. The
	user is expected to perform such checks himself.

	Note that ONLY the statistics and bonuses gained from the gear is calculated.
	Base character stats such as Agi, Str, Sta and base derived stats such as
	parry, dodge and block are not included. This is to allow comparison from a
	pure equipment-gain-only point of view.

Quirks:
	When the Dressing Room gets dragged offscreen, the model gets "flattened" (lol).

Known Issues:
	Dodge calculation isn't correct for any level/class but the player's (StatLogic).
	Counterweights can be placed on anything rather than just 2h swords, maces, axes
		and polearms (WoWEquip).
	Sometimes a set bonus isn't calculated (ItemBonusLib).
	Healing and Damage isn't being added correctly for healing gear due to 2.3
		changes, mostly to do with gem & enchant text changes (ItemBonusLib).
	Talents that increase armor contribution from items are incorrectly adding cloak
		+armor enchants as well (ItemBonusLib).

What I need:
	i need the base naked, untalented and unbuffed stats of every race/class
		combination at level 70.

Bug Reporting/Suggestions:
	Report any bugs or suggestions you may have at the forum thread:
	http://www.wowace.com/forums/index.php?topic=8317.0

Download:
	The latest version of WoWEquip can be obtained and downloaded from
	http://files.wowace.com/

Credits:
	Ideas from CT-Profiles and Danya's WoWEquip standalone application at
	http://wowequip.tehbox.org/

****************************************************************************************
]]

-- 8 July 2007, by Xinhuan @ Blackrock US Alliance: Version 0.1
-- Creation of addon, basic frames, itembuttons and usage of ItemBonusLib.
-- Added slash command.
-- Added basic method of searching for an item to replace in a slot.

-- 14 July 2007, by Xinhuan @ Blackrock US Alliance: Version 0.2
-- Added data and right click menus for all available enchants and gems.
-- Added icon data for items in menus.

-- 16 July 2007, by Xinhuan @ Blackrock US Alliance: Version 0.3
-- Redesigned WoWEquip to use the existing Dressing Room instead of using another model.
-- You may now Ctrl+Click items/itemlinks into the Dressing Room to equip them in WoWEquip.
-- Added colored borders to indicate the item quality of selected gear.
-- Replaced method of searching for items for equipment slots with a search box.
-- Added a button to copy your target's gear.
-- Added a 3rd column of numbers indicating the stats difference from your current equipped gear.
-- Added missing shoulder enchant - Inscription of Endurance.

-- 28 July 2007, by Xinhuan @ Blackrock US Alliance: Version 0.4
-- Added filter options for item searching.
-- Added sorting options for item searching.
-- Migrated all XML frames and functions to pure LUA. You can now safely delete WoWEquip.xml (a zero-byte file).
-- Filter/sorting options are saved between sessions.
-- Reduced the width of several menus so that they do not go offscreen.
-- Split several menus into submenus so that they do not go offscreen as they were too tall.
-- Added seperate enchant menu for fishing poles and miscellaneous weapons (blacksmith hammer, etc)
-- Added initial message that only items in the local cache can be searched.
-- Fixed scopes enchant menu not appearing for Guns and Crossbows.
-- Added a display number that shows how many items were found in a search.
-- Added checkboxes to show or hide Helm/Cloak display.
-- Various optimizations and localization.

-- 29 July 2007, by Xinhuan @ Blackrock US Alliance: Version 0.41
-- Improved the Item Bonus Summary display.

-- 2 August 2007, by Xinhuan @ Blackrock US Alliance: Version 0.5
-- Now uses both ItemBonusLib-1.0 and StatLogic-1.0 libraries for comparison purposes.
-- Additional display for converting ratings to %.
-- Added a box to input the level to use to calculate rating --> % conversions.
-- Various coding and namespace optimizations and other minor fixes.
-- The Item Bonus Summary box will now expand on mouseover to a larger viewing size.

-- 7 August 2007, by Xinhuan @ Blackrock US Alliance: Version 0.6
-- You may now save, load and delete profiles!
-- Added mechanisms for handling unsafe itemlinks (resulting from loading profiles).
-- The WoWEquip window is now movable (drag the title).
-- The Dressing Room is now attached to the movable WoWEquip window at 75% scaling when the WoWEquip window is open. You can toggle the Dressing Room on/off.
-- Localized slot names.
-- Fixed bug that allows gear to be equipped into equipment slots they can't go into.

-- 5 September 2007, by Xinhuan @ Blackrock US Alliance: Version 0.7
-- Fixed Equip button moving down instead of hiding on Bonus Frame mouseover.
-- Added the Enchant IDs of all epic gems from Black Temple/Mount Hyjal to the database so they are now enabled.
-- Added button to toggle between % and rating values instead of showing both at the same time.
-- Added Derived Stats to the summary window and a button to select the class for the calculation.
-- Profiles will now save the character class (for Derived Stats calculation).
-- All existing profiles that are saved from WoWEquip v0.6 will upgrade and try to guess the class based on the name of the profile, or default to the Warrior class till they are resaved/overwritten.
-- WoWEquip will now obtain your actual level (instead of assuming 70) when comparing gear against yourself.
-- You may now select a saved profile to compare stats against instead of comparing against your currently equipped gear. The selected profile will use the stored class/level for its calculation.
-- Added a confirmation dialog when deleting/overwriting profiles.
-- Added a button in the Blizzard Inspect UI window to copy the target to WoWEquip.
-- Added a keybinding to inspect your target in WoWEquip, and another to show/hide WoWEquip.

-- 29 September 2007, by Xinhuan @ Blackrock US Alliance: Version 0.8
-- Fixed error that occur when closing WoWEquip when the mouse is over the Summary Frame.
-- The searching of equipment has been moved to a separate dialog box and expanded to show 15 items. The Summary Frame is permanently bigger as a result.
-- The save/load/compare dialog is now movable.
-- Spell damage for different schools now include generic spell damage so that you no longer have to manually add them. Same with Attack Power.
-- Fixed bug where the selected profile to compare against always uses your player class instead of the stored class when calculating Derived Stats.
-- Fixed Stabilized Eternium Scope not being parsed and added an entry for Ranged Crit.
-- Added options dialog box with some basic options.
-- Added option to preserve the previous enchant when equipping new items.
-- Fixed bug where the keybind sometimes doesn't copy your selected target.
-- Fix ARMOR calculation due to ItemBonusLib change which split it into BASE_ARMOR and ARMOR_BONUS.
-- Add empty socket pattern support from ItemBonusLib.
-- Fix the Lock Window and Preserve Enchants option checkboxes from not initializing properly.
-- Added communication ability to share your profiles with other WoWEquip v0.8 users. Receiving profiles is off by default in the options.
-- Added AceComm-2.0 to embeds.xml and externals.
-- WoWEquip version bump to v0.8.
-- Updated Unstable Talasite gem color.
-- Updated EnchantIDs for all the gems (including patch 2.2 gems) and several enchants in the localization file.

-- 31 December 2007, by Xinhuan @ Blackrock US Alliance: Version 0.81
-- Added option slider to add to the width of WoWEquip.
-- Added the 5 new uncommon gems in patch 2.2. Updated icon textures for Purified Jaggal and Shadow Pearls.
-- Fix nil error on line 2387 when deleting profiles you are comparing against.
-- Add a Gems section to count the total of each socketed color.
-- Split data and localization into their own separate files.
-- Fix invalid link error occurring on line 3297 in hooked function DressUpItemLink().
-- Add Expertise rating for v2.3.
-- Convert from using StatLogicLib to ItemBonusLib for rating to % conversions.
-- Add ability to request a specified range of itemIDs from the server at the rate of 1 per 10 seconds in the Search Equipment window.
-- Add Chaotic Skyfire Diamond, Charmed Amani Jewel and Executioner enchant.
-- Add Argent Dawn leg resistance enchants to the menus, add Major Resistance cloak enchant ID.
-- Add Heavy Knothide Armor Kit, Resilience to shield enchant, and updated several lowbie 2H EnchantIDs.
-- Fixed an issue that can potentially result in the X, Options and other buttons being shown near the minimap.
-- Add Adamantite Weapon Chain, 20 agility one-hand enchant, updated weapon chain changes in patch 2.3.
-- Fixed profile saving bug where an empty slot (usually the offhand) would not overwrite (and nil out) the equipped item in the same slot in the profile to be overwritten.
-- Added Racial bonuses to WoWEquip. Version bump to 0.81.

-- 18 January 2008, by Xinhuan @ Blackrock US Alliance: Version 0.9
-- Implemented most talents into WoWEquip.
-- Fixed armor calculation issue. Base armor was added twice incorrectly.

-- 2 April 2008, by Xinhuan @ Blackrock US Alliance: Version 0.91
-- Update 8 new gems, 2 new enchants and talent changes.
-- Updated Shifting Tanzanite change and heroic gems Unique requirement.
-- Updated to LibItemBonus-2.0 instead of ItemBonusLib-1.0.


-- TODO:
-- * Possible coding in of enchant level requirements.
-- * Possibly add a method to allow random suffixed "of the xyz" gear to be selected.
-- * May add in a method to allow searching for items by stats that is similar to Wowhead.

-- Known Issues (ItemBonusLib - Jerry):
-- Healing and Damage isn't being added correctly for healing gear due to 2.3 changes, mostly to do with gem & enchant text changes.
-- Talents that increase armor contribution from items are incorrectly adding cloak +armor enchants as well.

-- Known issues (StatLogic - Whitetooth@Cenarius):
-- Dodge isn't correct for any level/class but the player's.

-- Known issues (WoWEquip):
-- Counterweights can be placed on anything rather than just 2h swords, maces, axes and polearms.
-- When the Dressing Room gets dragged offscreen, the model gets "flattened" (lol).

-- List of exposed WoWEquip API
-- WoWEquip:Show()
-- WoWEquip:Hide()
-- WoWEquip:Toggle()
-- WoWEquip:InspectAndCopyTarget()
-- WoWEquip:UpdateDressUpModel()
-- WoWEquip:UpdateBonusFrame()
-- WoWEquip:SaveProfile(name, desc)
-- WoWEquip:LoadProfile(name)
-- WoWEquip:DeleteProfile(name)
-- WoWEquip:CheckSlot(itemEquipLoc, slotnum)
-- WoWEquip:GenerateDispList(refreshMethod)
-- WoWEquip:ListUpdate()
-- WoWEquip:SetBackgroundColor(r, g, b, a)
-- WoWEquip:SetBackdropBorderColor(r, g, b, a)
-- WoWEquip:SendProfile(name, target)
-- WoWEquip:ReceiveProfile(sender, version, profile)
-- WoWEquip:PrintMessage(msg)
-- WoWEquip:[AceComm-2.0 mixin functions]
-- WoWEquip:SetExtraWidth(width)

WoWEquip	= {};	-- Our AddOn is contained in here
WoWEquip_Save	= {};	-- Our SavedVariable

-- Localize some used global functions, frames and constants
local WoWEquip = WoWEquip;
local WoWEquip_Save = WoWEquip_Save;
local L = WoWEquip_Localization;
local _G = getfenv(0);
local strfind, strsub, strlower, gsub, strtrim, strmatch = strfind, strsub, strlower, gsub, strtrim, strmatch;
local pairs, ipairs = pairs, ipairs;
local type, format, tonumber, floor, date = type, format, tonumber, floor, date;
local tinsert, tremove, tsort = tinsert, tremove, sort;
local SetItemButtonTexture = SetItemButtonTexture;
local GetInventoryItemLink = GetInventoryItemLink;
local GetInventorySlotInfo = GetInventorySlotInfo;
local GetItemInfo = GetItemInfo;
local DressUpFrame, DressUpModel = DressUpFrame, DressUpModel;
local UIDropDownMenu_AddButton = UIDropDownMenu_AddButton;
local FauxScrollFrame_Update = FauxScrollFrame_Update;
local FauxScrollFrame_GetOffset = FauxScrollFrame_GetOffset;
local FauxScrollFrame_OnVerticalScroll = FauxScrollFrame_OnVerticalScroll;
local GetItemQualityColor = GetItemQualityColor;
local ITEM_QUALITY_COLORS = ITEM_QUALITY_COLORS;
local GameTooltip = GameTooltip;
local AceComm = AceLibrary("AceComm-2.0");
local IBL = AceLibrary("LibItemBonus-2.0");
local SL = AceLibrary("StatLogic-1.0");


-- Local Variables and Tables
local _, temp, temp2, temp3, temp4;
local playereq = {};
local eq = {};
local eqvalid = {};
local info = {};
local socket = {};
local selectedItemID = nil;
local selectedSlotNum = -1;
local WoWEquip_DispResults = {};
local mt = {__mode = "k"};	-- weak keys metatable
local set = setmetatable({}, mt);
local setsizes = setmetatable({}, mt);
local sortA = {};
local sortB = {};
local eqsum = {};
local playereqsum = {};
local temptable = {};
local tier2data = {};
local playertier2data = {};
local currentProfileName = "";
local currentProfileDesc = "";
local currentProfileClass = 0;
local currentProfileChar = "";
local currentProfileRace = 0;
local currentProfileTalents = {};
local playerTalents = {};
local profiles = {};
local selectedProfileIndex = nil;
local oldDressUpFrameScale;
local lastSendTime = nil;

-- Local Constants
local WOWEQUIP_DISP_WIDTH		= 194;
local WOWEQUIP_DISP_HEIGHT		= 13;
local WOWEQUIP_ITEMS_SHOWN		= 15;
local WOWEQUIP_PROFILES_SHOWN		= 8;
local WOWEQUIP_PROFILES_DISP_WIDTH	= 300 - 26;
local WOWEQUIP_PROFILES_DISP_HEIGHT	= 13;

-- Localize some heavily used tables from WoWEquipData.lua
local WOWEQUIP_EQUIPLOC		= WOWEQUIP_EQUIPLOC;
local WOWEQUIP_FILTEROPTIONS	= WOWEQUIP_FILTEROPTIONS;
local WOWEQUIP_FILTERTABLE	= WOWEQUIP_FILTERTABLE;

-- Local Frame References (removing these local declarations will make these frames globally accessible)
local WoWEquip_Frame;			-- Available globally
local WoWEquip_Tooltip;			-- Available globally
local WoWEquip_GenericDropDownMenu = CreateFrame("Frame", "WoWEquip_GenericDropDownMenu");
WoWEquip_GenericDropDownMenu.displayMode = "MENU"
--local WoWEquip_CloseButton;
--local WoWEquip_DoneButton;
--local WoWEquip_ToggleDressingRoomButton;
--local WoWEquip_OpenButton;
local WoWEquip_PaperDollAr = {};
local WoWEquip_PaperDollDropDownMenu;	-- Available globally
local WoWEquip_ShowCloakCheckbox;
local WoWEquip_ShowHelmCheckbox;
local WoWEquip_BonusFrame;
local WoWEquip_BonusScrollFrame;	-- Available globally
local WoWEquip_LevelInputBox;
--local WoWEquip_ToggleRatingButton;
--local WoWEquip_CompareButton;
--local WoWEquip_ClassButton;
--local WoWEquip_RaceButton;
--local WoWEquip_TalentsButton;
local WoWEquip_EquipFrame;		-- Available globally
local WoWEquip_InputBox;
local WoWEquip_FilterButton;
local WoWEquip_SortButton;
local WoWEquip_SearchResultFrame;
local WoWEquip_ListScrollFrame;		-- Available globally
local WoWEquip_ItemButtonAr = {};
--local WoWEquip_EquipButton;
--local WoWEquip_EquipFrame_CancelButton;
--local WoWEquip_CopyTargetButton;
--local WoWEquip_SaveButton;
--local WoWEquip_LoadButton;
--local WoWEquip_SendButton;
local WoWEquip_SaveFrame;		-- Available globally
--local WoWEquip_SaveFrame_CloseButton;
local WoWEquip_SaveFrame_NameInputFrame;
local WoWEquip_SaveFrame_NameInputBox;
local WoWEquip_SaveFrame_TargetInputFrame;
local WoWEquip_SaveFrame_TargetInputBox;
local WoWEquip_SaveFrame_DescFrame;
local WoWEquip_DescEditScrollFrame;	-- Available globally
local WoWEquip_SaveFrame_DescInputBox;
local WoWEquip_SaveFrame_ProfilesFrame;
local WoWEquip_ProfilesScrollFrame;	-- Available globally
local WoWEquip_ProfilesButtonAr = {};
--local WoWEquip_SaveFrame_DeleteProfileButton;
--local WoWEquip_SaveFrame_SaveButton;
--local WoWEquip_SaveFrame_CancelButton;
--local WoWEquip_CopyInspectTargetButton;
local WoWEquip_OptionsFrame;		-- Available globally
--local WoWEquip_OptionsFrame_CloseButton;
--local WoWEquip_OptionsFrame_DoneButton;
--local WoWEquip_OptionsButton;
local WoWEquip_TalentsDropDownMenu;	-- Available globally

-- Local FontString References (removing these local declarations will make these strings globally accessible)
local WoWEquip_BonusText, WoWEquip_BonusTextR;
local WoWEquip_BonusText2, WoWEquip_BonusTextR2;
local WoWEquip_BetaText;
local WoWEquip_LevelText;
local WoWEquip_EquipFrame_TitleText;
local WoWEquip_SlotSearchText;
local WoWEquip_SearchInfoText;
local WoWEquip_SaveFrame_TitleText;
local WoWEquip_SaveFrame_NameText;
local WoWEquip_SaveFrame_TargetText;
local WoWEquip_SaveFrame_DescText;
local WoWEquip_SaveFrame_ProfilesText;
local WoWEquip_CompareText;
local WoWEquip_OptionsFrame_TitleText;

---------------------------------------------------
-- Some helper functions

-- Function to recycle non-recursive small simple tables by clearing its contents
local function cleartable(t)
	for k, v in pairs(t) do
		t[k] = nil;
	end
	t[true] = true;	-- This forces a resize on the table...
	t[true] = nil;	-- ... hopefully.
end

-- Generic function to generate a simple menu with a given title and with numerically indexed choices
local function WoWEquip_GenerateGenericMenu(level, menutable, func, check, title)
	if (not level) then
		return;
	end

	if (level == 1) then
		-- Create the title of the menu
		cleartable(info);
		info.isTitle		= 1;
		info.text		= title;
		info.notCheckable	= 1;
		UIDropDownMenu_AddButton(info, level);

		info.notCheckable	= nil;
		info.isTitle		= nil;

		for k, v in ipairs(menutable) do
			if (v.t) then
				info.text		= v.t
				info.arg1		= v.id;
				info.func     	 	= func;
				info.checked		= (check == v.id);
				if (v.id == -1) then
					info.disabled	= 1;
				else
					info.disabled	= nil;
				end
				UIDropDownMenu_AddButton(info, level);
			end
		end

		-- Close menu item
		info.text		= CLOSE;
		info.func		= CloseDropDownMenus;
		info.disabled		= nil;
		info.checked		= nil;
		info.notCheckable	= 1;
		info.arg1		= nil;
		UIDropDownMenu_AddButton(info, level);
	end
end

-- Generic function for leaving a frame to hide the GTT and reset the cursor
local function WoWEquip_Generic_OnLeave()
	GameTooltip:Hide();
	ResetCursor();
end

-- Generic function to hide a button's parent
local function WoWEquip_Generic_Hide(self)
	self:GetParent():Hide();
end

-- Generic function to start moving a frame's parent
local function WoWEquip_Generic_StartMoving(self)
	if (WoWEquip_Save.LockWindow == false) then
		self:GetParent():StartMoving();
	end
end

-- Generic function to stop moving a frame's parent
local function WoWEquip_Generic_StopMovingOrSizing(self)
	self:GetParent():StopMovingOrSizing();
end

-- Creates the button to copy inspected target from Blizzard Inspect UI to WoWEquip
local function WoWEquip_CreateInspectButton()
	WoWEquip_CopyInspectTargetButton = CreateFrame("Button", "WoWEquip_CopyInspectTargetButton", InspectPaperDollFrame, "OptionsButtonTemplate");
	WoWEquip_CopyInspectTargetButton:SetWidth(98);
	WoWEquip_CopyInspectTargetButton:SetHeight(22);
	temp, temp2, temp3 = WoWEquip_CopyInspectTargetButton:GetFont();
	WoWEquip_CopyInspectTargetButton:SetFont(temp, 10, temp3);
	WoWEquip_CopyInspectTargetButton:SetText(L["WOW_EQUIP_VERSION_TEXT"]);
	WoWEquip_CopyInspectTargetButton:SetPoint("BOTTOMRIGHT", -40, 84);
	WoWEquip_CopyInspectTargetButton:SetScript("OnClick", function(self)
		if (WoWEquip_Frame:IsShown()) then
			WoWEquip_Frame:Hide();
		else
			WoWEquip:InspectAndCopyTarget();
		end
	end);
	-- Unnecessary, the inspect pane hides itself if the target becomes uninspectable
	--WoWEquip_CopyInspectTargetButton:SetScript("OnUpdate", WoWEquip_CopyTargetButton.OnUpdate);
end

function WoWEquip:PrintMessage(msg)
	if (DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage("WoWEquip: "..msg, 1, 1, 1);
	end
end


------------------------
-- Talent scanning stuff
-- Scans the player for talent that we are interested in and store the talent rank
local function WoWEquip_ScanTalents()
	cleartable(playerTalents)
	local _, playerclass = UnitClass("player")
	for k, v in pairs(WoWEquip_TalentData2) do
		local class = strsplit("|", k)
		if class == playerclass then
			_, _, _, _, playerTalents[k] = GetTalentInfo(v.tab, v.num)
			if playerTalents[k] == 0 then playerTalents[k] = nil end
		end
	end
end

-- Scans the target for talents that we are interested in and store the talent rank
local function WoWEquip_ScanTalents2()
	cleartable(currentProfileTalents)
	local _, playerclass = UnitClass("target")
	if not playerclass then return end
	for k, v in pairs(WoWEquip_TalentData2) do
		local class = strsplit("|", k)
		if class == playerclass then
			_, _, _, _, currentProfileTalents[k] = GetTalentInfo(v.tab, v.num, true)
			if currentProfileTalents[k] == 0 then currentProfileTalents[k] = nil end
		end
	end
end


------------------------------------------------------
-- The Hidden tooltip for parsing sockets and set data

-- Create a hidden tooltip to scan itemlinks
WoWEquip_Tooltip = CreateFrame("GameTooltip", "WoWEquip_Tooltip", nil, "GameTooltipTemplate");
WoWEquip_Tooltip:SetOwner(WorldFrame, "ANCHOR_NONE");
for i = 1, 30 do
	WoWEquip_Tooltip[i] = _G["WoWEquip_TooltipTextLeft"..i];
	if (not WoWEquip_Tooltip[i]) then
		WoWEquip_Tooltip[i] = WoWEquip_Tooltip:CreateFontString();
		WoWEquip_Tooltip:AddFontStrings(WoWEquip_Tooltip[i], WoWEquip_Tooltip:CreateFontString());
	end
end

local function WoWEquip_ScanSockets(itemId)
	local itemLink = "item:"..itemId..":0:0:0:0:0:0:0";
	local text;
	local count = 0;
	cleartable(socket);
	WoWEquip_Tooltip:ClearLines();
	WoWEquip_Tooltip:SetHyperlink(itemLink);

	for k = 2, WoWEquip_Tooltip:NumLines() do
		text = WoWEquip_Tooltip[k]:GetText();
		for k2 in pairs(WoWEquip_GemsControlMenu) do
			if (strfind(text, k2, 1, true)) then
				count = count + 1;
				socket[count] = text;
				break;
			end
		end
		if (strfind(text, L["WOW_EQUIP_ITEM_SOCKET_BONUS_R"])) then
			return;
		end
	end
end

local function WoWEquip_ScanSetSize(itemLink)
	if (not itemLink) then return; end
	local text;
	local setname, setsize;
	WoWEquip_Tooltip:ClearLines();
	WoWEquip_Tooltip:SetHyperlink(itemLink);

	for k = 2, WoWEquip_Tooltip:NumLines() do
		text = WoWEquip_Tooltip[k]:GetText();
		_, _, setname, setsize = strfind(text, L["WOW_EQUIP_ITEM_SET_NAME_R"]);
		if (setsize) then
			setsizes[setname] = setsize;
			return;
		end
	end
end


---------------------------------------------------
-- WoWEquip frame declaration and OnFoo() functions

local WOWEQUIP_MAIN_BACKDROP	= { 
	bgFile = "Interface\\AddOns\\WoWEquip\\whitepixel", 
	edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
	tile = true,
	tileSize = 32,
	edgeSize = 32, 
 	insets = { left = 11, right = 12, top = 12, bottom = 11 },
};

local WOWEQUIP_BOX_BACKDROP2	= { 
	bgFile = nil, 
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = { left = 0, right = 0, top = 0, bottom = 0 },
};

-- Create the main WoWEquip frame
WoWEquip_Frame = CreateFrame("Frame", "WoWEquip_Frame", UIParent);
WoWEquip_Frame:Hide();
WoWEquip_Frame:SetWidth(320);
WoWEquip_Frame:SetHeight(435);
WoWEquip_Frame:SetBackdrop(WOWEQUIP_MAIN_BACKDROP);
WoWEquip_Frame:EnableMouse(true);
WoWEquip_Frame:SetToplevel(true);
WoWEquip_Frame:SetClampedToScreen(true);
WoWEquip_Frame:SetMovable(true);

-- This creates the WoWEquip title text and texture
temp = WoWEquip_Frame:CreateTexture(nil, "ARTWORK");
temp:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header");
temp:SetWidth(300);
temp:SetHeight(64);
temp:SetPoint("TOP", 0, 12);
WoWEquip_Frame.titleTexture = temp;
temp = WoWEquip_Frame:CreateFontString(nil, "ARTWORK", "GameFontNormal");
temp:SetPoint("TOP", 0, -3);
temp:SetText(L["WOW_EQUIP_VERSION_TEXT"]);

-- This creates a transparent textureless draggable frame to move WoWEquip, and saves the
-- position after a drag. It overlaps the above title text and texture (more or less) exactly.
temp = CreateFrame("Frame", nil, WoWEquip_Frame);
temp:SetWidth(150);
temp:SetHeight(30);
temp:SetPoint("TOP", 0, 8);
temp:EnableMouse(true);
temp:RegisterForDrag("LeftButton");
temp:SetScript("OnDragStart", WoWEquip_Generic_StartMoving);
temp:SetScript("OnDragStop", function(self)
	WoWEquip_Frame:StopMovingOrSizing();
	WoWEquip_Save.pospoint, _, WoWEquip_Save.posrelpoint, WoWEquip_Save.posoffsetx, WoWEquip_Save.posoffsety = WoWEquip_Frame:GetPoint();
	WoWEquip_Frame:SetUserPlaced(nil);
end);

function WoWEquip_Frame:OnShow()
	if (not self.init) then
		-- Load the current equipped items into the buttons
		for k, v in pairs(WoWEquip_PaperDollAr) do
			eq[v.slotname] = GetInventoryItemLink("player", v.slotnum);
			if (eq[v.slotname]) then
				_, _, temp2, _, _, _, _, _, _, temp = GetItemInfo(eq[v.slotname]);
				SetItemButtonTexture(v, temp);
				local r, g, b = GetItemQualityColor(temp2);
				v.border:SetVertexColor(r, g, b, 1);
				v.border:Show();
			end
		end
		local realm = GetRealmName():trim();
		local _, race = UnitRace("player");
		local guildname, guildrank = GetGuildInfo("player");
		if (not guildname) then
			guildname = NONE;
		else
			guildname = "<"..guildname..">, "..guildrank;
		end
		local faction, class;
		if (race == "Orc" or race == "Scourge" or race == "Troll" or race == "Tauren" or race == "BloodElf") then
			faction = FACTION_HORDE;
		else
			faction = FACTION_ALLIANCE;
		end
		WoWEquip_LevelInputBox:SetText(UnitLevel("player"));
		class, currentProfileClass = UnitClass("player");
		currentProfileClass = WOWEQUIP_CLASSID[currentProfileClass];
		currentProfileChar = UnitName("player");
		currentProfileName = class.."("..UnitLevel("player").."): "..currentProfileChar.." ("..L["Equipped Gear"]..")";
		currentProfileDesc = format(L["WOW_EQUIP_DEFAULT_COPYDESC"], currentProfileChar, guildname, realm, faction, date("%m/%d/%y %H:%M:%S"));
		currentProfileRace = WOWEQUIP_RACEID[race];

		if (WoWEquip_Save.compareOptions == 3) then
			WoWEquip_CompareText:SetText(L["Comparing: "]..WoWEquip_Save.compareProfile);
		else
			WoWEquip_CompareText:SetText(L["Comparing: "]..WoWEquip_CompareOptions[WoWEquip_Save.compareOptions].t);
		end
		WoWEquip_ClassButton:SetText(WoWEquip_ClassOptions[currentProfileClass].t);
		WoWEquip_RaceButton:SetText(WoWEquip_RaceOptions[currentProfileRace].t2);
		cleartable(currentProfileTalents)
		WoWEquip_ScanTalents()
		for k, v in pairs(playerTalents) do
			currentProfileTalents[k] = v
		end

		-- This is just to initialize the frame attributes or the later part will not work to reposition the DressUpFrame
		DressUpFrame:SetAttribute("UIPanelLayout-defined", true)
		for name, value in pairs(UIPanelWindows["DressUpFrame"]) do
			DressUpFrame:SetAttribute("UIPanelLayout-"..name, value);
		end
		DressUpModel:SetUnit("player");
		self.init = true;
	end

	local flag = DressUpFrame:IsShown();
	oldDressUpFrameScale = DressUpFrame:GetScale();
	if (flag) then
		HideUIPanel(DressUpFrame);
	end
	DressUpFrame:SetAttribute("UIPanelLayout-enabled", nil);
	DressUpFrame:ClearAllPoints();
	DressUpFrame:SetPoint("TOPRIGHT", WoWEquip_Frame, "TOPLEFT", 35, 8);
	DressUpFrame:SetScale(WoWEquip_Save.DRScale / 100);
	if (flag) then
		ShowUIPanel(DressUpFrame);
	end

	WoWEquip:UpdateBonusFrame();
	WoWEquip:UpdateDressUpModel();
	PlaySound("igCharacterInfoOpen");
	WoWEquip_Frame:RegisterEvent("UNIT_INVENTORY_CHANGED");
end

function WoWEquip_Frame:OnHide()
	local flag = DressUpFrame:IsShown();
	HideUIPanel(DressUpFrame);
	DressUpFrame:ClearAllPoints();
	DressUpFrame:SetAttribute("UIPanelLayout-enabled", true);
	DressUpFrame:SetScale(oldDressUpFrameScale);
	if (flag) then
		ShowUIPanel(DressUpFrame);
	end
	WoWEquip_SaveFrame:Hide();
	WoWEquip_OptionsFrame:Hide();
	PlaySound("igCharacterInfoClose");
	WoWEquip_Frame:UnregisterEvent("UNIT_INVENTORY_CHANGED");
end

WoWEquip_Frame:SetScript("OnShow", WoWEquip_Frame.OnShow);
WoWEquip_Frame:SetScript("OnHide", WoWEquip_Frame.OnHide);

local function WoWEquip_UpgradeSavedVars()
	WoWEquip_Save.sortOptions = WoWEquip_Save.sortOptions or 5;		-- Sort options were added in v0.4
	if (not WoWEquip_Save.filterOptions) then				-- Filter options were added in v0.4
		WoWEquip_Save.filterOptions = {};
		for k = 1, 30 do
			WoWEquip_Save.filterOptions[k] = true;
		end
		for k = 111, 114 do
			WoWEquip_Save.filterOptions[k] = true;
		end
	end
	if (not WoWEquip_Save.pospoint) then					-- Frame position saving was added in v0.6
		WoWEquip_Save.pospoint = "TOPLEFT";
		WoWEquip_Save.posrelpoint = "TOPLEFT";
		WoWEquip_Save.posoffsetx = 300;
		WoWEquip_Save.posoffsety = -150;
	end
	WoWEquip_Save.profiles = WoWEquip_Save.profiles or {};			-- Profiles were added in v0.6
	if (WoWEquip_Save.showrating == nil) then				-- Toggle Rating <--> % button added in v0.7
		WoWEquip_Save.showrating = true;
	end
	WoWEquip_Save.compareOptions = WoWEquip_Save.compareOptions or 2;	-- Compare options button added in v0.7
	for k, v in pairs(WoWEquip_Save.profiles) do				-- Upgrade v0.6 saved profiles to include a class in v0.7
		if (not v.class) then
			v.class = 1;	-- Default to warrior class first
			-- Attempt to find a class in the name of the profile
			for i, t in ipairs(WoWEquip_ClassOptions) do
				if (strfind(k, t.t)) then
					-- Found, assign that class
					v.class = i;
					break;
				end
			end
		end
	end
	WoWEquip_Save.Transparency = WoWEquip_Save.Transparency or 100;		-- Transparency was added in v0.8
	WoWEquip_Save.Scale = WoWEquip_Save.Scale or 100;			-- Scaling was added in v0.8
	WoWEquip_Save.DRScale = WoWEquip_Save.DRScale or 100;			-- Dressing room scaling was added in v0.8
	WoWEquip_Save.LockWindow = WoWEquip_Save.LockWindow or false;		-- Locking window was added in v0.8
	WoWEquip_Save.PreserveEnchant = WoWEquip_Save.PreserveEnchant or false;	-- Preserving enchants was added in v0.8
	WoWEquip_Save.r = WoWEquip_Save.r or 0;					-- Changing background color/opacity was added in v0.8
	WoWEquip_Save.g = WoWEquip_Save.g or 0;
	WoWEquip_Save.b = WoWEquip_Save.b or 0;
	WoWEquip_Save.a = WoWEquip_Save.a or 0.75;
	WoWEquip_Save.br = WoWEquip_Save.br or 1;				-- Changing background color/opacity was added in v0.8
	WoWEquip_Save.bg = WoWEquip_Save.bg or 1;
	WoWEquip_Save.bb = WoWEquip_Save.bb or 1;
	WoWEquip_Save.ba = WoWEquip_Save.ba or 1;
	WoWEquip_Save.ProfileReceive = WoWEquip_Save.ProfileReceive or false;	-- Profile sending/receiving was added in v0.8
	WoWEquip_Save.AddWidth = WoWEquip_Save.AddWidth or 30;			-- Variable width was added in v0.81
	for k, v in pairs(WoWEquip_Save.profiles) do				-- Upgrade v0.8 saved profiles to include a race in v0.81
		if (not v.race) then
			v.race = 0;	-- Default to no race
		end
	end
	WoWEquip_Save.IgnoreRace = WoWEquip_Save.IgnoreRace or false       -- Added in v0.9
	WoWEquip_Save.IgnoreTalents = WoWEquip_Save.IgnoreTalents or false -- Added in v0.9

	WoWEquip_Save.version = "0.9";						-- Finally, update the version number
end

function WoWEquip_Frame:OnEvent(event, ...)
	local arg1 = ...;

	if (event == "UNIT_INVENTORY_CHANGED" and arg1 == "player" and WoWEquip_Save.compareOptions == 2) then
		-- No need to check if WoWEquip_Frame:IsVisible() because we register/unregister it on show/hide.
		WoWEquip:UpdateBonusFrame();

	elseif (event == "INSPECT_TALENT_READY") then
		WoWEquip_ScanTalents2()
		WoWEquip:UpdateBonusFrame()
		WoWEquip_Frame:UnregisterEvent("INSPECT_TALENT_READY")

	elseif (event == "ADDON_LOADED") then
		if (arg1 == "WoWEquip") then
			-- Import the loaded SavedVariables into our WoWEquip environment if it exists
			WoWEquip_Save = _G["WoWEquip_Save"] or WoWEquip_Save;
			WoWEquip_UpgradeSavedVars();
			WoWEquip_Frame:SetPoint(WoWEquip_Save.pospoint, nil, WoWEquip_Save.posrelpoint, WoWEquip_Save.posoffsetx, WoWEquip_Save.posoffsety);
			WoWEquip_Frame:SetUserPlaced(nil);
			WoWEquip_Frame:SetScale(WoWEquip_Save.Scale / 100);
			WoWEquip_Frame:SetAlpha(WoWEquip_Save.Transparency / 100);
			WoWEquip:SetBackgroundColor(WoWEquip_Save.r, WoWEquip_Save.g, WoWEquip_Save.b, WoWEquip_Save.a);
			WoWEquip:SetBackdropBorderColor(WoWEquip_Save.br, WoWEquip_Save.bg, WoWEquip_Save.bb, WoWEquip_Save.ba);
			WoWEquip:SetExtraWidth(WoWEquip_Save.AddWidth);
			WoWEquip_Frame.ignore[1]:SetChecked(WoWEquip_Save.IgnoreRace)
			WoWEquip_Frame.ignore[2]:SetChecked(WoWEquip_Save.IgnoreTalents)
			if WoWEquip_Save.IgnoreRace then WoWEquip_RaceButton:Disable() end
			if WoWEquip_Save.IgnoreTalents then WoWEquip_TalentsButton:Disable() end
			if InspectFrame_Show then WoWEquip_CreateInspectButton() end
		elseif (arg1 == "Blizzard_InspectUI") then
			WoWEquip_CreateInspectButton();
		end

	elseif (event == "CHARACTER_POINTS_CHANGED") then
		WoWEquip_ScanTalents()
	end
end

WoWEquip_Frame:SetScript("OnEvent", WoWEquip_Frame.OnEvent);
WoWEquip_Frame:RegisterEvent("ADDON_LOADED");
WoWEquip_Frame:RegisterEvent("CHARACTER_POINTS_CHANGED")

function WoWEquip:Show()
	WoWEquip_Frame:Show();
end

function WoWEquip:Hide()
	WoWEquip_Frame:Hide();
end

function WoWEquip:Toggle()
	if (WoWEquip_Frame:IsShown()) then
		WoWEquip_Frame:Hide();
	else
		WoWEquip_Frame:Show();
	end
end

function WoWEquip:InspectAndCopyTarget()
	if (CanInspect("target")) then
		WoWEquip_Frame:Show();	-- Do this before CopyTarget because of initialisation code inside OnShow
		WoWEquip_CopyTargetButton.OnClick();
	end
end

-- Add the /wowequip slash command
_G["SlashCmdList"]["WOWEQUIP"] = WoWEquip.Show;
_G["SLASH_WOWEQUIP1"] = L["WOW_EQUIP_SLASH_COMMAND"];

-- Makes WoW close WoWEquip when the Escape key is pressed
tinsert(_G["UISpecialFrames"], "WoWEquip_Frame");
tinsert(_G["UISpecialFrames"], "WoWEquip_SaveFrame");

--------------------------------------------------------------
-- WoWEquip frame Close and Done buttons and OnFoo() functions

-- Create the Close button
WoWEquip_CloseButton = CreateFrame("Button", nil, WoWEquip_Frame, "UIPanelCloseButton");
WoWEquip_CloseButton:SetPoint("TOPRIGHT", -2, -1);
WoWEquip_CloseButton:SetHitRectInsets(5, 5, 5, 5);
WoWEquip_CloseButton:SetScript("OnClick", WoWEquip.Hide);

-- Create the Done button
WoWEquip_DoneButton = CreateFrame("Button", nil, WoWEquip_Frame, "OptionsButtonTemplate");
WoWEquip_DoneButton:SetWidth(82);
WoWEquip_DoneButton:SetHeight(22);
WoWEquip_DoneButton:SetPoint("BOTTOMRIGHT", WoWEquip_Frame, "BOTTOMRIGHT", -10, 11);
WoWEquip_DoneButton:SetText(DONE);
WoWEquip_DoneButton:SetScript("OnClick", WoWEquip.Hide);

-- Create the Toggle Dressing Room button
WoWEquip_ToggleDressingRoomButton = CreateFrame("Button", "WoWEquip_ToggleDressingRoomButton", WoWEquip_Frame);
WoWEquip_ToggleDressingRoomButton:SetWidth(24);
WoWEquip_ToggleDressingRoomButton:SetHeight(24);
WoWEquip_ToggleDressingRoomButton:SetPoint("TOPLEFT", 9, -5);
WoWEquip_ToggleDressingRoomButton:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Up");
WoWEquip_ToggleDressingRoomButton:SetPushedTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Down");
WoWEquip_ToggleDressingRoomButton:SetDisabledTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Disabled");
WoWEquip_ToggleDressingRoomButton:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight");

function WoWEquip_ToggleDressingRoomButton:OnClick()
	if (DressUpFrame:IsShown()) then
		HideUIPanel(DressUpFrame);
	else
		ShowUIPanel(DressUpFrame);
		DressUpFrame:SetScale(WoWEquip_Save.DRScale / 100);
		WoWEquip:UpdateDressUpModel();
	end
end
WoWEquip_ToggleDressingRoomButton:SetScript("OnClick", WoWEquip_ToggleDressingRoomButton.OnClick);

hooksecurefunc(DressUpFrame, "Show", function()
	WoWEquip_ToggleDressingRoomButton:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Up");
	WoWEquip_ToggleDressingRoomButton:SetPushedTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Down");
	WoWEquip_ToggleDressingRoomButton:SetDisabledTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Disabled");
end);
hooksecurefunc(DressUpFrame, "Hide", function()
	WoWEquip_ToggleDressingRoomButton:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Up");
	WoWEquip_ToggleDressingRoomButton:SetPushedTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Down");
	WoWEquip_ToggleDressingRoomButton:SetDisabledTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Disabled");
end);


--------------------------------------------------------------------------
-- WoWEquip frame Toggle button in the Dressing Room and OnFoo() functions

-- Create the WoWEquip toggle button in the Dressing Room
WoWEquip_OpenButton = CreateFrame("Button", nil, DressUpFrame, "UIPanelButtonTemplate");
WoWEquip_OpenButton:SetWidth(120);
WoWEquip_OpenButton:SetHeight(22);
--WoWEquip_OpenButton:SetPoint("BOTTOMLEFT", DressUpBackgroundBotLeft, "BOTTOMLEFT", -4, 26);
WoWEquip_OpenButton:SetPoint("BOTTOMLEFT", DressUpFrame, "TOPLEFT", 18, -433);
WoWEquip_OpenButton:SetText(L["WOW_EQUIP_VERSION_TEXT"]);
WoWEquip_OpenButton:SetScript("OnClick", WoWEquip.Toggle);


------------------------------------------------------------------
-- The 19 equipment slot buttons, its menus, and OnFoo() functions

local function WoWEquip_ClearSlot()
	local v = WoWEquip_PaperDollDropDownMenu.pointer;
	eq[v.slotname] = nil;
	_, temp = GetInventorySlotInfo(v.slotname.."Slot");
	SetItemButtonTexture(v, temp);
	v.border:Hide();
	WoWEquip:UpdateBonusFrame();
	WoWEquip:UpdateDressUpModel();
end

local function WoWEquip_ApplyEnchant(whichID, id)
	local itemLink;
	local v = WoWEquip_PaperDollDropDownMenu.pointer;
	if (not whichID) then		-- Replace enchantId
		itemLink = gsub(WoWEquip_PaperDollDropDownMenu.item, "(item:%d+):(%d+):", "%1:"..id..":");
	elseif (whichID == 1) then	-- Replace jewelId1
		itemLink = gsub(WoWEquip_PaperDollDropDownMenu.item, "(item:%d+:%d+):(%d+):", "%1:"..id..":");
	elseif (whichID == 2) then	-- Replace jewelId2
		itemLink = gsub(WoWEquip_PaperDollDropDownMenu.item, "(item:%d+:%d+:%d+):(%d+):", "%1:"..id..":");
	elseif (whichID == 3) then	-- Replace jewelId3
		itemLink = gsub(WoWEquip_PaperDollDropDownMenu.item, "(item:%d+:%d+:%d+:%d+):(%d+):", "%1:"..id..":");
	elseif (whichID == 4) then	-- Replace jewelId4
		itemLink = gsub(WoWEquip_PaperDollDropDownMenu.item, "(item:%d+:%d+:%d+:%d+:%d+):(%d+):", "%1:"..id..":");
	else
		itemLink = WoWEquip_PaperDollDropDownMenu.item;
	end

	eq[v.slotname] = itemLink;
	WoWEquip_PaperDollDropDownMenu.item = itemLink;
	WoWEquip:UpdateBonusFrame();
	if (v.slotname == "Back" and WoWEquip_ShowCloakCheckbox:GetChecked()) or
	   (v.slotname == "Head" and WoWEquip_ShowHelmCheckbox:GetChecked()) or
	   (v.slotname ~= "Back" and v.slotname ~= "Head") then
		DressUpModel:TryOn(itemLink);
	end
	CloseDropDownMenus(2);
end

local function WoWEquip_QueryServer(itemLink)
	WoWEquip_PaperDollDropDownMenu.pointer.needupdate = GetTime();
	GameTooltip:SetHyperlink(itemLink);
end

local function WoWEquip_GenerateDollMenu(level)
	if (not level) then
		return;
	end
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(WoWEquip_PaperDollDropDownMenu.item);

	-- Menu for item that is not in local cache
	if (not itemName) then
		-- Create the title of the menu
		local itemcolor, itemid, itemname = strmatch(WoWEquip_PaperDollDropDownMenu.item, "(|c.*)|Hitem:(%d+):.*|h%[(.*)%]|h|r");

		info.isTitle		= 1;
		info.text		= itemname;
		info.value		= nil;
		info.func      		= nil;
		info.notCheckable	= 1;
		info.icon		= "Interface\\Icons\\INV_Misc_QuestionMark";
		info.hasArrow		= nil;
		info.checked		= nil;
		info.arg1		= nil;
		info.arg2		= nil;
		UIDropDownMenu_AddButton(info, level);

		-- Query Server menu item
		info.disabled		= nil;
		info.isTitle		= nil;
		info.icon		= nil;
		info.hasArrow		= nil;
		info.text		= L["Query server for this item"];
		info.func		= WoWEquip_QueryServer;
		info.arg1		= WoWEquip_PaperDollDropDownMenu.item;
		UIDropDownMenu_AddButton(info, level);

		-- Clear Slot menu item
		info.text		= L["Unequip this slot"];
		info.func		= WoWEquip_ClearSlot;
		info.arg1		= nil;
		UIDropDownMenu_AddButton(info, level);

		-- Close menu item
		info.text		= CLOSE;
		info.func		= CloseDropDownMenus;
		UIDropDownMenu_AddButton(info, level);

		return;
	end

	-- Menu for item that is in local cache
	local found, _, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strfind(itemLink, "item:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)");
	if (level == 1) then
		-- Create the title of the menu
		cleartable(info);
		info.isTitle		= 1;
		info.text		= itemName;
		info.notCheckable	= 1;
		info.icon		= itemTexture;
		UIDropDownMenu_AddButton(info, level);

		info.disabled		= nil;
		info.isTitle		= nil;
		info.icon		= nil;
		info.hasArrow		= 1;

		-- If the item is enchantable, create the Enchant menuitem
		if (WoWEquip_EnchantableLoc[itemEquipLoc] and itemSubType ~= L["WOW_EQUIP_ITEMSUBTYPE_WANDS"]) then
			info.text	= ENSCRIBE;
			info.value	= WoWEquip_EnchantableLoc[itemEquipLoc];
			UIDropDownMenu_AddButton(info, level);
		end

		-- If the item has sockets, create a menuitem for each socket
		WoWEquip_ScanSockets(itemId);
		for k = 1, 4 do
			if (socket[k]) then
				info.text	= socket[k];
				info.value	= k;
				UIDropDownMenu_AddButton(info, level);
			end
		end

		-- Clear Slot menu item
		info.text		= L["Unequip this slot"];
		info.hasArrow		= nil;
		info.func		= WoWEquip_ClearSlot;
		UIDropDownMenu_AddButton(info, level);

		-- Close menu item
		info.text		= CLOSE;
		info.func		= CloseDropDownMenus;
		UIDropDownMenu_AddButton(info, level);

	else
		info.notCheckable	= 1;
		info.checked		= nil;
		info.hasArrow		= nil;
		info.value		= nil;
		info.func      		= nil;
		info.arg2		= nil;

		-- Sneaky way to pass an argument to the 3rd/4th level menu from the 2nd level
		-- by passing the socket number in info.arg1
		if (level == 2) then
			info.isTitle		= 1;
			if (type(UIDROPDOWNMENU_MENU_VALUE) == "number") then
				-- Gems submenu
				info.text	= socket[UIDROPDOWNMENU_MENU_VALUE];
				info.icon	= WoWEquip_GemsControlMenu[socket[UIDROPDOWNMENU_MENU_VALUE]].ic;
				UIDropDownMenu_AddButton(info, level);
				info.arg1 	= UIDROPDOWNMENU_MENU_VALUE;
				UIDROPDOWNMENU_MENU_VALUE = WoWEquip_GemsControlMenu[socket[UIDROPDOWNMENU_MENU_VALUE]].menu;
			else
				-- Enchants submenu
				info.text	= ENSCRIBE;
				info.icon	= nil;
				UIDropDownMenu_AddButton(info, level);
				info.arg1	= nil;

				-- Special case for fishing poles
				if (itemSubType == L["WOW_EQUIP_ITEMSUBTYPE_FISHINGPOLE"]) then
					UIDROPDOWNMENU_MENU_VALUE = WoWEquip_EnchantableLoc["FishingEnchants"];
				end
				-- Special case for Misc Weapons
				if (itemType == L["WOW_EQUIP_ITEMTYPE_WEAPON"] and itemSubType == L["WOW_EQUIP_ITEMSUBTYPE_MISC"]) then
					UIDROPDOWNMENU_MENU_VALUE = WoWEquip_EnchantableLoc["NoEnchants"];
				end
			end
		end
		info.disabled		= nil;
		info.isTitle		= nil;

		-- Sneaky way to do dynamic submenu creation, as many sublevels as needed.
		for k, v in ipairs(UIDROPDOWNMENU_MENU_VALUE) do
			if (v.t) then
				info.text		= gsub(v.t, "%(", "|cFFFFD200(", 1);		-- Makes the itemName yellow
				info.text		= gsub(info.text, "%) %(", ") |cFF00FF00(", 1);	-- Makes the additional info green
				info.value		= v.id;
				info.arg2		= v.id;
				info.func     	 	= WoWEquip_ApplyEnchant;
				info.checked		= nil;
				info.disabled		= nil;
				info.icon		= nil;
				info.notCheckable	= nil;
				info.hasArrow		= nil;
				if (v.ic) then
					info.icon	= "Interface\\Icons\\"..v.ic;
				end
				if ( (not info.arg1 and v.id == tonumber(enchantId))
					or (info.arg1 == 1 and v.id == tonumber(jewelId1))
					or (info.arg1 == 2 and v.id == tonumber(jewelId2))
					or (info.arg1 == 3 and v.id == tonumber(jewelId3))
					or (info.arg1 == 4 and v.id == tonumber(jewelId4)) ) then
						info.checked	= 1;
				end
				if (v.id == -1) then
					info.disabled	= 1;
				end
				UIDropDownMenu_AddButton(info, level);
			else
				info.func      	= nil;
				info.checked	= nil;
				info.disabled	= nil;
				info.hasArrow	= 1;
				info.icon	= nil;
				for l, w in pairs(v) do
					info.text		= l;
					info.value		= w;
					UIDropDownMenu_AddButton(info, level);
				end
			end
		end
	end
end

local function WoWEquip_PaperDollButton_OnEnter(self)
	local itemLink = eq[self.slotname];
	GameTooltip:SetOwner(self, "ANCHOR_LEFT");
	if (itemLink) then
		if (not GetItemInfo(itemLink) or (self.needupdate and (GetTime() - self.needupdate < 1.0))) then
			-- If itemLink isn't in local cache, or it has not been 1.0 secs since querying the server for it
			local itemcolor, itemid, itemname = strmatch(itemLink, "(|c.*)|Hitem:(%d+):.*|h%[(.*)%]|h|r");
			GameTooltip:ClearLines();
			GameTooltip:SetText(L["WOW_EQUIP_ERRORTOOLTIP_L1"]);
			GameTooltip:AddLine(L["WOW_EQUIP_ERRORTOOLTIP_L2"]..itemcolor..itemname.."|r");
			GameTooltip:AddLine(L["WOW_EQUIP_ERRORTOOLTIP_L3"]..itemid);
			GameTooltip:AddLine(L["WOW_EQUIP_ERRORTOOLTIP_L4"], 1, 1, 1, 1);
			GameTooltip:AddLine(L["WOW_EQUIP_ERRORTOOLTIP_L5"], nil, nil, nil, 1);
			GameTooltip:Show();
		else
			GameTooltip:SetHyperlink(itemLink);
			if (self.needupdate) then
				local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(itemLink);
				SetItemButtonTexture(self, itemTexture);
				local r, g, b = GetItemQualityColor(itemRarity);
				self.border:SetVertexColor(r, g, b, 1);
				self.border:Show();
				WoWEquip:UpdateBonusFrame();
				if (self.slotname == "Back" and WoWEquip_ShowCloakCheckbox:GetChecked()) or
				   (self.slotname == "Head" and WoWEquip_ShowHelmCheckbox:GetChecked()) or
				   (self.slotname ~= "Back" and self.slotname ~= "Head") then
					DressUpModel:TryOn(itemLink);
				end
				CloseDropDownMenus();
				self.needupdate = nil;
			end
		end
	else
		GameTooltip:SetText(self.slotnamelocal.." "..L["Slot"]);
	end
end

local function WoWEquip_PaperDollButton_OnClick(self, button)
	if ( button == "LeftButton" ) then
		if (IsShiftKeyDown() and ChatFrameEditBox:IsVisible()) then
			ChatFrameEditBox:Insert(eq[self.slotname]);
		else
			WoWEquip_EquipFrame:Show();
			if (selectedSlotNum ~= self.slotnum) then
				CloseDropDownMenus();
				WoWEquip_InputBox.pointer = self;
				selectedSlotNum = self.slotnum;
				selectedItemID = nil;
				WoWEquip_EquipButton:Disable();
				WoWEquip_InputBox:SetText("");
				WoWEquip_InputBox:SetFocus();
				if (WOWEQUIP_FILTEROPTIONS[selectedSlotNum]) then
					WoWEquip_FilterButton:Enable();
				else
					WoWEquip_FilterButton:Disable();
				end
				WoWEquip:GenerateDispList(1);
			end
		end
	elseif ( button == "RightButton" ) then
		if (eq[self.slotname]) then
			WoWEquip_PaperDollDropDownMenu.item = eq[self.slotname];
			WoWEquip_PaperDollDropDownMenu.pointer = self;
			ToggleDropDownMenu(1, nil, WoWEquip_PaperDollDropDownMenu, self, 0, 0);
		end
	end
end

-- Create the 19 equipment slot buttons and position them. All the buttons are stored in WoWEquip_PaperDollAr[]
temp2 = nil;
for k, v in ipairs(WOWEQUIP_SLOTS) do
	temp = CreateFrame("Button", "WoWEquip_PaperDoll"..k, WoWEquip_Frame, "ItemButtonTemplate");
	temp:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	temp:SetScript("OnClick", WoWEquip_PaperDollButton_OnClick);
	temp:SetScript("OnEnter", WoWEquip_PaperDollButton_OnEnter);
	temp:SetScript("OnLeave", WoWEquip_Generic_OnLeave);
	temp.border = temp:CreateTexture(nil, "OVERLAY");
	temp.border:Hide();
	temp.border:SetTexture("Interface\\AddOns\\WoWEquip\\ItemOverlay.blp");
	temp.border:SetWidth(41);
	temp.border:SetHeight(41);
	temp.border:SetPoint("CENTER", temp);
	temp.border:SetBlendMode("ADD");
	if (v == "Head") then
		temp:SetPoint("TOPLEFT", WoWEquip_Frame, "TOPLEFT", 13, -27);
	elseif (v == "Hands") then
		temp:SetPoint("TOPLEFT", WoWEquip_PaperDollAr["Head"], "TOPRIGHT", 3, 0);
	elseif (v == "MainHand") then
		temp:SetPoint("TOPLEFT", WoWEquip_PaperDollAr["Wrist"], "BOTTOMLEFT", 0, -4);
	elseif (v == "SecondaryHand") then
		temp:SetPoint("TOPLEFT", WoWEquip_PaperDollAr["MainHand"], "TOPRIGHT", 3, 0);
	elseif (v == "Ranged") then
		temp:SetPoint("TOPLEFT", WoWEquip_PaperDollAr["SecondaryHand"], "TOPRIGHT", 3, 0);
	elseif (temp2) then
		temp:SetPoint("TOPLEFT", temp2, "BOTTOMLEFT", 0, -4);
	end
	temp.slotname = v;
	temp.slotnamelocal = WOWEQUIP_SLOTS_TEXT[k];
	temp.slotnum, temp2 = GetInventorySlotInfo(v.."Slot");
	SetItemButtonTexture(temp, temp2);
	WoWEquip_PaperDollAr[v] = temp;
	temp2 = temp;
end

-- Creating a right click menu doesn't require you to inherit UIDropDownMenuTemplate
-- or even call UIDropDownMenu_Initialize()! The following code is sufficient.
-- This menu is for right clicking the paper doll
WoWEquip_PaperDollDropDownMenu = CreateFrame("Frame", "WoWEquip_PaperDollDropDownMenu", WoWEquip_Frame);
WoWEquip_PaperDollDropDownMenu.displayMode	= "MENU";
WoWEquip_PaperDollDropDownMenu.initialize	= WoWEquip_GenerateDollMenu;


----------------------------------------------------------------
-- The Show Cloak and Show Helm checkboxes and OnFoo() functions

-- Create the Show Cloak checkbox
WoWEquip_ShowCloakCheckbox = CreateFrame("CheckButton", nil, WoWEquip_Frame, "UICheckButtonTemplate");
WoWEquip_ShowCloakCheckbox:SetWidth(24);
WoWEquip_ShowCloakCheckbox:SetHeight(24);
WoWEquip_ShowCloakCheckbox:SetPoint("BOTTOMLEFT", 8, 6);
WoWEquip_ShowCloakCheckbox.string = WoWEquip_ShowCloakCheckbox:CreateFontString();
WoWEquip_ShowCloakCheckbox.string:SetWidth(WOWEQUIP_DISP_WIDTH);
WoWEquip_ShowCloakCheckbox.string:SetJustifyH("LEFT");
WoWEquip_ShowCloakCheckbox.string:SetPoint("LEFT", 21, 1);
WoWEquip_ShowCloakCheckbox:SetFontString(WoWEquip_ShowCloakCheckbox.string);
WoWEquip_ShowCloakCheckbox:SetTextFontObject("GameFontNormalSmall");
WoWEquip_ShowCloakCheckbox:SetHighlightFontObject("GameFontHighlightSmall");
WoWEquip_ShowCloakCheckbox:SetDisabledFontObject("GameFontDisableSmall");
WoWEquip_ShowCloakCheckbox:SetText(L["Show Cloak"]);
WoWEquip_ShowCloakCheckbox:SetChecked(true);
WoWEquip_ShowCloakCheckbox:SetHitRectInsets(0, -WoWEquip_ShowCloakCheckbox.string:GetStringWidth(), 0, 0);
WoWEquip_ShowCloakCheckbox:SetPushedTextOffset(0, 0);

-- Create the Show Helm checkbox
WoWEquip_ShowHelmCheckbox = CreateFrame("CheckButton", nil, WoWEquip_Frame, "UICheckButtonTemplate");
WoWEquip_ShowHelmCheckbox:SetWidth(24);
WoWEquip_ShowHelmCheckbox:SetHeight(24);
WoWEquip_ShowHelmCheckbox:SetPoint("BOTTOMLEFT", WoWEquip_ShowCloakCheckbox, "TOPLEFT", 0, -9);
WoWEquip_ShowHelmCheckbox.string = WoWEquip_ShowHelmCheckbox:CreateFontString();
WoWEquip_ShowHelmCheckbox.string:SetWidth(WOWEQUIP_DISP_WIDTH);
WoWEquip_ShowHelmCheckbox.string:SetJustifyH("LEFT");
WoWEquip_ShowHelmCheckbox.string:SetPoint("LEFT", 21, 1);
WoWEquip_ShowHelmCheckbox:SetFontString(WoWEquip_ShowHelmCheckbox.string);
WoWEquip_ShowHelmCheckbox:SetTextFontObject("GameFontNormalSmall");
WoWEquip_ShowHelmCheckbox:SetHighlightFontObject("GameFontHighlightSmall");
WoWEquip_ShowHelmCheckbox:SetDisabledFontObject("GameFontDisableSmall");
WoWEquip_ShowHelmCheckbox:SetText(L["Show Helm"]);
WoWEquip_ShowHelmCheckbox:SetChecked(true);
WoWEquip_ShowHelmCheckbox:SetHitRectInsets(0, -WoWEquip_ShowHelmCheckbox.string:GetStringWidth(), 0, 0);
WoWEquip_ShowHelmCheckbox:SetPushedTextOffset(0, 0);

function WoWEquip:UpdateDressUpModel()
	if (DressUpFrame:IsShown()) then
		DressUpModel:RefreshUnit();
		DressUpModel:Undress();
		for k, v in pairs(eq) do
			if (k == "Back" and WoWEquip_ShowCloakCheckbox:GetChecked()) or
			   (k == "Head" and WoWEquip_ShowHelmCheckbox:GetChecked()) or
			   (k ~= "Back" and k ~= "Head") then
				if (GetItemInfo(v)) then
					DressUpModel:TryOn(v);
				end
			end
		end

		-- Hack to tryon the main hand --> offhand --> ranged in that order
		if (eq["MainHand"] and GetItemInfo(eq["MainHand"])) then
			DressUpModel:TryOn(eq["MainHand"]);
		elseif (eq["SecondaryHand"] and GetItemInfo(eq["SecondaryHand"])) then
			DressUpModel:TryOn(eq["SecondaryHand"]);
		elseif (eq["Ranged"] and GetItemInfo(eq["Ranged"])) then
			DressUpModel:TryOn(eq["Ranged"]);
		end
	end
end
WoWEquip_ShowCloakCheckbox:SetScript("OnClick", WoWEquip.UpdateDressUpModel);
WoWEquip_ShowHelmCheckbox:SetScript("OnClick", WoWEquip.UpdateDressUpModel);


-----------------------------------------------------
-- The Item Bonus Summary frame and OnFoo() functions

local WOWEQUIP_BOX_BACKDROP = { 
	bgFile = nil,
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16, 
 	insets = { left = 5, right = 5, top = 5, bottom = 5 },
};

		
-- Create the Item Bonus Summary frame
WoWEquip_BonusFrame = CreateFrame("Frame", nil, WoWEquip_Frame);
WoWEquip_BonusFrame:SetWidth(220);
WoWEquip_BonusFrame:SetHeight(332);
WoWEquip_BonusFrame:SetPoint("TOPRIGHT", -10, -23);
WoWEquip_BonusFrame:SetBackdrop(WOWEQUIP_BOX_BACKDROP);
WoWEquip_BonusFrame:EnableMouse(true);
-- Create the ScrollFrame for the Item Bonus Summary
WoWEquip_BonusScrollFrame = CreateFrame("ScrollFrame", "WoWEquip_BonusScrollFrame", WoWEquip_BonusFrame, "UIPanelScrollFrameTemplate");
WoWEquip_BonusScrollFrame:SetWidth(187);
WoWEquip_BonusScrollFrame:SetHeight(289);
WoWEquip_BonusScrollFrame:SetPoint("TOPLEFT", 6, -36);
-- Create the ScrollChild frame and its contents
WoWEquip_BonusScrollFrame.ScrollChild = CreateFrame("Frame", nil, WoWEquip_BonusScrollFrame);
temp2 = WoWEquip_BonusScrollFrame.ScrollChild;
temp2:SetWidth(187);
temp2:SetHeight(20);
-- Equipment Stats fontstring
temp2.eqstring = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormal");
temp2.eqstring:SetTextColor(1.0, 1.0, 0.1);
temp2.eqstring:SetText(L["Equipment Stats"]);
temp2.eqstring:SetPoint("TOPLEFT", 0, 0);
temp2.eqstring:SetWidth(187);
-- The 2 summary strings
WoWEquip_BonusText = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_BonusText:SetJustifyH("LEFT");
WoWEquip_BonusText:SetPoint("TOPLEFT", temp2.eqstring, "BOTTOMLEFT", 0, 0);
WoWEquip_BonusTextR = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_BonusTextR:SetJustifyH("RIGHT");
WoWEquip_BonusTextR:SetPoint("TOPRIGHT", temp2.eqstring, "BOTTOMRIGHT", 0, 0);
-- Derived Stats font string
temp2.dsstring = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormal");
temp2.dsstring:SetTextColor(1.0, 1.0, 0.1);
temp2.dsstring:SetText(L["Derived Stats"]);
temp2.dsstring:SetPoint("TOPLEFT", WoWEquip_BonusText, "BOTTOMLEFT", 0, 0);
temp2.dsstring:SetWidth(187);
-- Create the Class button
WoWEquip_ClassButton = CreateFrame("Button", nil, temp2, "OptionsButtonTemplate");
WoWEquip_ClassButton:SetWidth(60);
WoWEquip_ClassButton:SetHeight(22);
WoWEquip_ClassButton:SetPoint("TOP", temp2.dsstring, "BOTTOM", 0, 0);
WoWEquip_ClassButton:SetText("Class");
-- Create the Race button
WoWEquip_RaceButton = CreateFrame("Button", nil, temp2, "OptionsButtonTemplate");
WoWEquip_RaceButton:SetWidth(60);
WoWEquip_RaceButton:SetHeight(22);
WoWEquip_RaceButton:SetPoint("RIGHT", WoWEquip_ClassButton, "LEFT", 0, 0);
WoWEquip_RaceButton:SetText("Race");
-- Create the Talents button
WoWEquip_TalentsButton = CreateFrame("Button", nil, temp2, "OptionsButtonTemplate");
WoWEquip_TalentsButton:SetWidth(60);
WoWEquip_TalentsButton:SetHeight(22);
WoWEquip_TalentsButton:SetPoint("LEFT", WoWEquip_ClassButton, "RIGHT", 0, 0);
WoWEquip_TalentsButton:SetText("Talents");
-- The 2 derived summary strings
WoWEquip_BonusText2 = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_BonusText2:SetJustifyH("LEFT");
WoWEquip_BonusText2:SetPoint("TOPLEFT", temp2.dsstring, "BOTTOMLEFT", 0, -36);
WoWEquip_BonusTextR2 = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_BonusTextR2:SetJustifyH("RIGHT");
WoWEquip_BonusTextR2:SetPoint("TOPRIGHT", temp2.dsstring, "BOTTOMRIGHT", 0, -36);
-- The beta status string
WoWEquip_BetaText = temp2:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_BetaText:SetWidth(187);
WoWEquip_BetaText:SetNonSpaceWrap(true);
WoWEquip_BetaText:SetJustifyH("LEFT");
WoWEquip_BetaText:SetPoint("TOPLEFT", WoWEquip_BonusText2, "BOTTOMLEFT", 0, 0);
WoWEquip_BetaText:SetText(L["WOW_EQUIP_BETA_TEXT"]);
-- Attach the ScrollChild to the ScrollFrame
WoWEquip_BonusScrollFrame:SetScrollChild(WoWEquip_BonusScrollFrame.ScrollChild);

-- Create the 2 ignore checkboxes
local ignore = {}
for i = 1, 2 do
	ignore[i] = CreateFrame("CheckButton", nil, temp2, "UICheckButtonTemplate")
	ignore[i]:SetWidth(24)
	ignore[i]:SetHeight(24)
	ignore[i].string = ignore[i]:CreateFontString()
	ignore[i].string:SetWidth(WOWEQUIP_DISP_WIDTH)
	ignore[i].string:SetJustifyH("LEFT")
	ignore[i].string:SetPoint("LEFT", 21, 1)
	ignore[i]:SetFontString(ignore[i].string)
	ignore[i]:SetTextFontObject("GameFontNormalSmall")
	ignore[i]:SetHighlightFontObject("GameFontHighlightSmall")
	ignore[i]:SetDisabledFontObject("GameFontDisableSmall")
	ignore[i]:SetText(L["Ignore"])
	ignore[i]:SetChecked(true)
	ignore[i]:SetHitRectInsets(0, -ignore[i].string:GetStringWidth(), 0, 0)
	ignore[i]:SetPushedTextOffset(0, 0)
end
ignore[1]:SetPoint("TOPLEFT", WoWEquip_RaceButton, "BOTTOMLEFT", -1, 4)
ignore[2]:SetPoint("TOPLEFT", WoWEquip_TalentsButton, "BOTTOMLEFT", -1, 4)
ignore[1].OnClick = function(self, button)
	WoWEquip_Save.IgnoreRace = self:GetChecked() == 1
	if WoWEquip_Save.IgnoreRace then
		WoWEquip_RaceButton:Disable()
	else
		WoWEquip_RaceButton:Enable()
	end
	WoWEquip:UpdateBonusFrame()
end
ignore[2].OnClick = function(self, button)
	WoWEquip_Save.IgnoreTalents = self:GetChecked() == 1
	if WoWEquip_Save.IgnoreTalents then
		WoWEquip_TalentsButton:Disable()
	else
		WoWEquip_TalentsButton:Enable()
	end
	WoWEquip:UpdateBonusFrame()
end
ignore[1]:SetScript("OnClick", ignore[1].OnClick)
ignore[2]:SetScript("OnClick", ignore[2].OnClick)
WoWEquip_Frame.ignore = ignore

local function WoWEquip_SetClassOptions(value)
	currentProfileClass = value;
	WoWEquip_ClassButton:SetText(WoWEquip_ClassOptions[value].t);
	if (strfind(currentProfileName, ".*%(%d+%):.*%(.*%)")) then
		currentProfileName = gsub(currentProfileName, ".*%((%d+%):.*%(.*%))", WoWEquip_ClassOptions[value].t.."(%1");
	end
	WoWEquip:UpdateBonusFrame();
end

local function WoWEquip_GenerateClassMenu(level)
	WoWEquip_GenerateGenericMenu(level, WoWEquip_ClassOptions, WoWEquip_SetClassOptions, currentProfileClass, L["Select class"]);
end

function WoWEquip_ClassButton:OnClick()
	WoWEquip_GenericDropDownMenu:SetParent(self);
	WoWEquip_GenericDropDownMenu.initialize = WoWEquip_GenerateClassMenu;
	ToggleDropDownMenu(1, nil, WoWEquip_GenericDropDownMenu, self, 0, 0);
end
WoWEquip_ClassButton:SetScript("OnClick", WoWEquip_ClassButton.OnClick);

local function WoWEquip_SetRaceOptions(value)
	currentProfileRace = value;
	WoWEquip_RaceButton:SetText(WoWEquip_RaceOptions[value].t2);
	WoWEquip:UpdateBonusFrame();
end

local function WoWEquip_GenerateRaceMenu(level)
	WoWEquip_GenerateGenericMenu(level, WoWEquip_RaceOptions, WoWEquip_SetRaceOptions, currentProfileRace, "Select Race");
end

function WoWEquip_RaceButton:OnClick()
	WoWEquip_GenericDropDownMenu:SetParent(self);
	WoWEquip_GenericDropDownMenu.initialize = WoWEquip_GenerateRaceMenu;
	ToggleDropDownMenu(1, nil, WoWEquip_GenericDropDownMenu, self, 0, 0);
end
WoWEquip_RaceButton:SetScript("OnClick", WoWEquip_RaceButton.OnClick);

local function WoWEquip_ApplyTalent(name, rank)
	if rank > 0 then
		currentProfileTalents[name] = rank
	else
		currentProfileTalents[name] = nil
	end
	-- To refresh the menu, make it close then open again.
	WoWEquip_TalentsButton:Click()
	WoWEquip_TalentsButton:Click()
	WoWEquip:UpdateBonusFrame();
end

local function WoWEquip_GenerateTalentMenu(level)
	if (not level) then return end
	cleartable(info)
	if (level == 1) then
		-- Create the title of the menu
		info.isTitle		= 1
		info.text		= WoWEquip_ClassOptions[currentProfileClass].t..L[" Talents"]
		info.notCheckable	= 1
		UIDropDownMenu_AddButton(info, level)

		info.isTitle		= nil
		info.hasArrow		= 1
		info.notCheckable	= nil
		info.disabled		= nil
		
		-- Add items for each talent
		for _, k in ipairs(WoWEquip_TalentData[currentProfileClass]) do
			local class, tree, talent, maxrank = strsplit("|", k)
			info.text		= ("|cFF00FF00(%d/%s)|r |cFFFFD200(%s)|r %s"):format(currentProfileTalents[k] or 0, maxrank, L[tree], L[talent])
			info.value		= k
			UIDropDownMenu_AddButton(info, level)
		end

		-- Close menu item
		info.hasArrow		= nil
		info.text		= CLOSE
		info.func		= CloseDropDownMenus
		UIDropDownMenu_AddButton(info, level)
	elseif (level == 2) then
		local v = WoWEquip_TalentData2[UIDROPDOWNMENU_MENU_VALUE]
		local classID, tree, talent, maxrank = strsplit("|", UIDROPDOWNMENU_MENU_VALUE)
		-- Create the title of the menu
		info.isTitle		= 1
		info.text		= "("..L[tree]..") "..L[talent]
		info.notCheckable	= 1
		info.icon		= v.ic and "Interface\\Icons\\"..v.ic or nil
		UIDropDownMenu_AddButton(info, level)

		info.isTitle		= nil
		info.notCheckable	= nil
		info.icon		= nil
		info.disabled		= nil

		-- Add menuitem for rank 0
		info.text		= L["Rank %d: "]:format(0)..L["Don't use this talent"]
		info.text		= info.text:gsub("%d+%%?", "|cFF00FF00%1|r")
		info.value		= 0
		info.arg1		= UIDROPDOWNMENU_MENU_VALUE
		info.arg2		= 0
		info.func     	 	= WoWEquip_ApplyTalent
		info.checked		= (not currentProfileTalents[UIDROPDOWNMENU_MENU_VALUE]) or (currentProfileTalents[UIDROPDOWNMENU_MENU_VALUE] == 0)
		UIDropDownMenu_AddButton(info, level);

		for i = 1, maxrank do
			if not v.p then
				info.text	= L["Rank %d: "]:format(i)..v.t:format(v.d and v.d[i] or v.m * i)
			elseif v.p == 2 then
				info.text	= L["Rank %d: "]:format(i)..v.t:format(v.d and v.d[i] or v.m * i, v.d2 and v.d2[i] or v.m2 * i)
			end
			info.text		= info.text:gsub("%d+%%?", "|cFF00FF00%1|r")
			info.value		= i
			info.arg1		= UIDROPDOWNMENU_MENU_VALUE
			info.arg2		= i
			info.func     	 	= WoWEquip_ApplyTalent
			info.checked		= currentProfileTalents[UIDROPDOWNMENU_MENU_VALUE] == i
			UIDropDownMenu_AddButton(info, level);
		end
	end
end

-- This menu is for the Talents button
WoWEquip_TalentsDropDownMenu = CreateFrame("Frame", "WoWEquip_TalentsDropDownMenu", WoWEquip_Frame);
WoWEquip_TalentsDropDownMenu.displayMode = "MENU";
WoWEquip_TalentsDropDownMenu.initialize	= WoWEquip_GenerateTalentMenu;

function WoWEquip_TalentsButton:OnClick()
	ToggleDropDownMenu(1, nil, WoWEquip_TalentsDropDownMenu, self, 0, 0);
	--ToggleDropDownMenu(1, nil, WoWEquip_TalentsDropDownMenu)
end
--UIDropDownMenu_SetAnchor(0, 0, WoWEquip_TalentsDropDownMenu, "TOPRIGHT", WoWEquip_TalentsButton, "BOTTOMRIGHT")
WoWEquip_TalentsButton:SetScript("OnClick", WoWEquip_TalentsButton.OnClick);


--[[ Racial data taken from http://www.worldofwarcraft.com class guide pages.
Draenei
	Gemcutting  - passive, Jewelcrafting skill increased by 5.
	Gift of the Naaru - active, Heals the target 50 + 15/Level over 15 sec - 40 yd range - 1.5 sec cast - 3 min cooldown.
	Inspiring Presence - passive - (Mages/Priests/Shaman only), Increases chance to hit with spells by 1% for you and all party members within 30 yards.
	Heroic Presence - passive - (Hunters/Paladins/Warriors only), Increases chance to hit by 1% for you and all party members within 30 yards.
	Shadow Resistance - passive, Shadow Resistance increased by 10.

Dwarf
	Stoneform - active, While active, grants immunity to Bleed, Poison, and Disease effects. In addition, Armor increases by 10%. Lasts 8 sec. - 3 min cooldown
	Gun Specialization - passive, Dwarves get +5 to Gun Skill
	Frost Resistance - passive, All Dwarves get +10 Frost Resistance
	Find Treasure - passive, Activate to see treasure chests on mini map - lasts until canceled - no cooldown

Gnomes
	Escape Artist - active, Activate to break out of a Root or Snare effect - Instant - 1 min cooldown
	Expansive Mind - passive, Increase Intelligence by 5%
	Arcane Resistance - passive, All Gnomes get +10 Arcane Resistance
	Engineering Specialization - passive, 15 skill bonus to Engineering

Humans
	Perception  - active, Activate to dramatically increase stealth detection - Lasts 20 sec - 3 min cooldown
	The Human Spirit - passive, Increase Spirit by 10%
	Diplomacy - passive, 10% bonus to faction point gain
	Sword Specialization - passive, Humans get +5 to Sword skill
	Mace Specialization - passive, Humans get +5 to Mace skill

Night Elves
	Shadowmeld - active, Activate while immobile and out of combat to enter stealth mode - lasts until canceled - 10 sec cooldown
	Quickness - passive, Dodge chance increased by 1%
	Wisp Spirit - passive, Become a wisp when dead with movement speed increase of 50% (25% faster than normal ghost)
	Nature Resistance - passive, All Night Elves get +10 Nature Resistance

Blood Elves
	Arcane Affinity  - passive, Enchanting skill increased by 10.
	Arcane Torrent - active - (Hunters/Paladins/Mages/Priests/Warlocks only), Silences all enemies within 8 yards for 2 sec. In addition, you gain 5 + 1/Level Mana restored per Mana Tap charge currently affecting you - Instant - 2 min cooldown.
	Arcane Torrent - active - (Rogue only), Silences all enemies within 8 yards for 2 sec. In addition, you gain 10 Energy for each Mana Tap charge currently affecting you - Instant - 2 min cooldown.
	Magic Resistance - passive, All resistances increased by 5.
	Mana Tap - active, Reduces target's mana by 51 and charges you with Arcane energy for 10 min. This effect stacks up to 3 times. Amount of mana reduced is 50 + 1/Level - 30 yd range - Instant - 30 sec cooldown.

Orcs
	Blood Fury - active, Increases attack power by about 4 per character level (282 at 70), but reduces healing effects on you 50%. Lasts 15 sec.
	Hardiness - passive, 15% resistance to stun and knockout effects.
	Command - passive, Pet melee damage increased by 5%.
	Axe Specialization - passive, Orcs get +5 to Axe skill.

Taurens
	War Stomp  - active, Activate to stun up to 5 opponents within 8 yards - lasts 2 sec - 2 min cooldown
	Endurance - passive, Max Health increased by 5%
	Cultivation - passive, 15 skill bonus to Herbalism
	Nature Resistance - passive, All Tauren get +10 Nature Resistance

Troll
	Berserking - active, Increases your attack speed by 10% to 30%. At full health the speed increase is 10% with a greater effect up to 30% if you are badly hurt when you activate Berserking. Lasts 10 sec.
	Regeneration - passive, 10% health regen bonus, 10% active in combat
	Beast Slaying - passive, 5% damage bonus to Beasts
	Throwing Specialization - passive, +5 to Throwing Weapon skills
	Bow Specialization - passive, +5 to Bow Weapon Skills

Undead
	Will of the Forsaken  - active, Activate to become immune to Fear, Sleep, and Charm effects. Can also be used while already afflicted by Fear or Sleep - lasts 5 sec - 2 min cooldown
	Cannibalize - active, Activate to regenerate 7% of total health every 2 sec. by consuming Humanoid or Undead corpses within 5 yds - lasts 10 sec - 2 min cooldown
	Underwater Breathing - passive, Underwater breath lasts 300% longer than normal
	Shadow Resistance - passive, All Undead get +10 Shadow Resistance
]]
local statmods = {a = {STR = 0, AGI = 0, STA = 0, INT = 0, SPI = 0},
                  b = {STR = 0, AGI = 0, STA = 0, INT = 0, SPI = 0}}
local function modifyBonuses2(a, b, raceA, raceB, classA, classB)
	local t = nil
	if (WoWEquip_Save.compareOptions == 2) then
		t = playerTalents
	elseif (WoWEquip_Save.compareOptions == 3) then
		t = WoWEquip_Save.profiles[WoWEquip_Save.compareProfile].talents
	end
	-- Reset % stat mods to 100%
	for k in pairs(statmods.a) do
		statmods.a[k] = 1
		statmods.b[k] = 1
	end
	if not WoWEquip_Save.IgnoreRace then
		-- Gnome - Expansive Mind - passive, Increase Intelligence by 5%
		if raceA == 3 then statmods.a.INT = statmods.a.INT + 0.05 end
		if raceB == 3 then statmods.b.INT = statmods.b.INT + 0.05 end
		-- Humans - The Human Spirit - passive, Increase Spirit by 10%
		if raceA == 4 then statmods.a.SPI = statmods.a.SPI + 0.1 end
		if raceB == 4 then statmods.b.SPI = statmods.b.SPI + 0.1 end
	end
	if not WoWEquip_Save.IgnoreTalents then
		if classB == 1 then
			statmods.b.STA = statmods.b.STA + 0.01 * (currentProfileTalents["WARRIOR|Protection|Vitality|5"] or 0)
			statmods.b.STR = statmods.b.STR + 0.02 * (currentProfileTalents["WARRIOR|Protection|Vitality|5"] or 0)
		end
		if classA == 1 and t then
			statmods.a.STA = statmods.a.STA + 0.01 * (t["WARRIOR|Protection|Vitality|5"] or 0)
			statmods.a.STR = statmods.a.STR + 0.02 * (t["WARRIOR|Protection|Vitality|5"] or 0)
		end
		if classB == 2 then
			statmods.b.STR = statmods.b.STR + 0.02 * (currentProfileTalents["PALADIN|Holy|Divine Strength|5"] or 0)
			statmods.b.INT = statmods.b.INT + 0.02 * (currentProfileTalents["PALADIN|Holy|Divine Intellect|5"] or 0)
			statmods.b.STA = statmods.b.STA + 0.03 * (currentProfileTalents["PALADIN|Protection|Sacred Duty|2"] or 0)
			statmods.b.STA = statmods.b.STA + 0.02 * (currentProfileTalents["PALADIN|Protection|Combat Expertise|5"] or 0)
		end
		if classA == 2 and t then
			statmods.a.STR = statmods.a.STR + 0.02 * (t["PALADIN|Holy|Divine Strength|5"] or 0)
			statmods.a.INT = statmods.a.INT + 0.02 * (t["PALADIN|Holy|Divine Intellect|5"] or 0)
			statmods.a.STA = statmods.a.STA + 0.03 * (t["PALADIN|Protection|Sacred Duty|2"] or 0)
			statmods.a.STA = statmods.a.STA + 0.02 * (t["PALADIN|Protection|Combat Expertise|5"] or 0)
		end
		if classB == 3 then
			statmods.b.AGI = statmods.b.AGI + 0.01 * (currentProfileTalents["HUNTER|Marksmanship|Combat Experience|2"] or 0)
			statmods.b.INT = statmods.b.INT + 0.03 * (currentProfileTalents["HUNTER|Marksmanship|Combat Experience|2"] or 0)
			statmods.b.AGI = statmods.b.AGI + 0.03 * (currentProfileTalents["HUNTER|Survival|Lightning Reflexes|5"] or 0)
		end
		if classA == 3 and t then
			statmods.a.AGI = statmods.a.AGI + 0.01 * (t["HUNTER|Marksmanship|Combat Experience|2"] or 0)
			statmods.a.INT = statmods.a.INT + 0.03 * (t["HUNTER|Marksmanship|Combat Experience|2"] or 0)
			statmods.a.AGI = statmods.a.AGI + 0.03 * (t["HUNTER|Survival|Lightning Reflexes|5"] or 0)
		end
		if classB == 4 then
			statmods.b.STA = statmods.b.STA + 0.02 * (currentProfileTalents["ROGUE|Combat|Vitality|2"] or 0)
			statmods.b.AGI = statmods.b.AGI + 0.01 * (currentProfileTalents["ROGUE|Combat|Vitality|2"] or 0)
			statmods.b.AGI = statmods.b.AGI + 0.03 * (currentProfileTalents["ROGUE|Subtlety|Sinister Calling|5"] or 0)
		end
		if classA == 4 and t then
			statmods.a.STA = statmods.a.STA + 0.02 * (t["ROGUE|Combat|Vitality|2"] or 0)
			statmods.a.AGI = statmods.a.AGI + 0.01 * (t["ROGUE|Combat|Vitality|2"] or 0)
			statmods.a.AGI = statmods.a.AGI + 0.03 * (t["ROGUE|Subtlety|Sinister Calling|5"] or 0)
		end
		if classB == 5 then
			local temp = 0.01 * (currentProfileTalents["PRIEST|Discipline|Enlightenment|5"] or 0)
			statmods.b.STA = statmods.b.STA + temp
			statmods.b.INT = statmods.b.INT + temp
			statmods.b.SPI = statmods.b.SPI + temp
			statmods.b.SPI = statmods.b.SPI + 0.05 * (currentProfileTalents["PRIEST|Holy|Spirit of Redemption|1"] or 0)
		end
		if classA == 5 and t then
			local temp = 0.01 * (t["PRIEST|Discipline|Enlightenment|5"] or 0)
			statmods.a.STA = statmods.a.STA + temp
			statmods.a.INT = statmods.a.INT + temp
			statmods.a.SPI = statmods.a.SPI + temp
			statmods.a.SPI = statmods.a.SPI + 0.05 * (t["PRIEST|Holy|Spirit of Redemption|1"] or 0)
		end
		if classB == 7 then
			statmods.b.INT = statmods.b.INT + 0.03 * (currentProfileTalents["MAGE|Arcane|Arcane Mind|5"] or 0)
		end
		if classA == 7 and t then
			statmods.a.INT = statmods.a.INT + 0.01 * (t["MAGE|Arcane|Arcane Mind|5"] or 0)
		end
		if classB == 8 then
			statmods.b.STA = statmods.b.STA + 0.03 * (currentProfileTalents["WARLOCK|Demonology|Demonic Embrace|5"] or 0)
			statmods.b.SPI = statmods.b.SPI - 0.01 * (currentProfileTalents["WARLOCK|Demonology|Demonic Embrace|5"] or 0)
			statmods.b.STA = statmods.b.STA + 0.01 * (currentProfileTalents["WARLOCK|Demonology|Fel Stamina|3"] or 0)
		end
		if classA == 8 and t then
			statmods.a.STA = statmods.a.STA + 0.03 * (t["WARLOCK|Demonology|Demonic Embrace|5"] or 0)
			statmods.a.SPI = statmods.a.SPI - 0.01 * (t["WARLOCK|Demonology|Demonic Embrace|5"] or 0)
			statmods.a.STA = statmods.a.STA + 0.01 * (t["WARLOCK|Demonology|Fel Stamina|3"] or 0)
		end
		if classB == 9 then
			local temp = 0.01 * (currentProfileTalents["DRUID|Feral Combat|Survival of the Fittest|3"] or 0)
			statmods.b.STR = statmods.b.STR + temp
			statmods.b.AGI = statmods.b.AGI + temp
			statmods.b.STA = statmods.b.STA + temp
			statmods.b.INT = statmods.b.INT + temp
			statmods.b.SPI = statmods.b.SPI + temp
			statmods.b.INT = statmods.b.INT + 0.04 * (currentProfileTalents["DRUID|Feral Combat|Heart of the Wild|5"] or 0)
			statmods.b.SPI = statmods.b.SPI + 0.05 * (currentProfileTalents["DRUID|Restoration|Living Spirit|3"] or 0)
		end
		if classA == 9 and t then
			local temp = 0.01 * (t["DRUID|Feral Combat|Survival of the Fittest|3"] or 0)
			statmods.a.STR = statmods.a.STR + temp
			statmods.a.AGI = statmods.a.AGI + temp
			statmods.a.STA = statmods.a.STA + temp
			statmods.a.INT = statmods.a.INT + temp
			statmods.a.SPI = statmods.a.SPI + temp
			statmods.a.INT = statmods.a.INT + 0.04 * (t["DRUID|Feral Combat|Heart of the Wild|5"] or 0)
			statmods.a.SPI = statmods.a.SPI + 0.05 * (t["DRUID|Restoration|Living Spirit|3"] or 0)
		end
	end
	-- Multiply in the % stat mods
	for k in pairs(statmods.a) do
		if a[k] then a[k] = a[k] * statmods.a[k] end
		if b[k] then b[k] = b[k] * statmods.b[k] end
	end
end

local statmods2 = {a = {HEALTH = 0, MANA = 0, ARMOR = 0, RANGEDATTACKPOWER = 0, ATTACKPOWER = 0,
                        DMG = 0, HEAL = 0,
                        ARCANEDMG = 0, FIREDMG = 0, FROSTDMG = 0, HOLYDMG = 0, NATUREDMG = 0, SHADOWDMG = 0},
                   b = {HEALTH = 0, MANA = 0, ARMOR = 0, RANGEDATTACKPOWER = 0, ATTACKPOWER = 0,
                        DMG = 0, HEAL = 0,
                        ARCANEDMG = 0, FIREDMG = 0, FROSTDMG = 0, HOLYDMG = 0, NATUREDMG = 0, SHADOWDMG = 0}}
local statmods3 = {a = {}, b = {}}
local damageTypes = {"ARCANEDMG", "FIREDMG", "FROSTDMG", "HOLYDMG", "NATUREDMG", "SHADOWDMG"}
local damageTypes2 = {ARCANECRIT = "SPELLCRIT", FIRECRIT = "SPELLCRIT", FROSTCRIT = "SPELLCRIT", HOLYCRIT = "SPELLCRIT", NATURECRIT = "SPELLCRIT", SHADOWCRIT = "SPELLCRIT",
                      ARCANEHIT = "SPELLTOHIT", FIREHIT = "SPELLTOHIT", FROSTHIT = "SPELLTOHIT", HOLYHIT = "SPELLTOHIT", NATUREHIT = "SPELLTOHIT", SHADOWHIT = "SPELLTOHIT"}
local function modifyBonuses3(a, b, oa, ob, raceA, raceB, classA, classB)
	local t = nil
	if (WoWEquip_Save.compareOptions == 2) then
		t = playerTalents
	elseif (WoWEquip_Save.compareOptions == 3) then
		t = WoWEquip_Save.profiles[WoWEquip_Save.compareProfile].talents
	end
	-- Reset % mods to 100%
	for k in pairs(statmods2.a) do
		statmods2.a[k] = 1
		statmods2.b[k] = 1
	end
	cleartable(statmods3.a)
	cleartable(statmods3.b)

	if not WoWEquip_Save.IgnoreRace then
		-- Night Elves - Quickness - passive, Dodge chance increased by 1%
		if raceA == 5 then a.DODGE = a.DODGE + 1 end
		if raceB == 5 then b.DODGE = b.DODGE + 1 end
		-- Draenei - Inspiring Presence - passive - (Mages/Priests/Shaman only), Increases chance to hit with spells by 1% for you and all party members within 30 yards.
		if raceA == 1 and (classA == 7 or classA == 5 or classA == 6) then statmods3.a.SPELLTOHIT = (statmods3.a.SPELLTOHIT or 0) + 1 end
		if raceB == 1 and (classB == 7 or classB == 5 or classB == 6) then statmods3.b.SPELLTOHIT = (statmods3.b.SPELLTOHIT or 0) + 1 end
		-- Draenei - Heroic Presence - passive - (Hunters/Paladins/Warriors only), Increases chance to hit by 1% for you and all party members within 30 yards.
		if raceA == 1 and (classA == 3 or classA == 2 or classA == 1) then a.TOHIT = a.TOHIT + 1 end
		if raceB == 1 and (classB == 3 or classB == 2 or classB == 1) then b.TOHIT = b.TOHIT + 1 end
		-- Tauren - Endurance - passive, Max Health increased by 5%
		if raceA == 8 then statmods2.a.HEALTH = statmods2.a.HEALTH + 0.05 end
		if raceB == 8 then statmods2.b.HEALTH = statmods2.b.HEALTH + 0.05 end
		--Troll - Regeneration - passive, 10% health regen bonus, 10% active in combat
	end
	if not WoWEquip_Save.IgnoreTalents then
		if classB == 1 then
			b.PARRY = b.PARRY + 1 * (currentProfileTalents["WARRIOR|Arms|Deflection|5"] or 0)
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["WARRIOR|Fury|Cruelty|5"] or 0)
			b.TOHIT = b.TOHIT + 1 * (currentProfileTalents["WARRIOR|Fury|Precision|3"] or 0)
			statmods2.b.ARMOR = statmods2.b.ARMOR + 0.02 * (currentProfileTalents["WARRIOR|Protection|Toughness|5"] or 0)

			local temp = 0.04 * 4 * (currentProfileTalents["WARRIOR|Protection|Anticipation|5"] or 0)
			b.PARRY = b.PARRY + temp
			b.BLOCK = b.BLOCK + temp
			b.DODGE = b.DODGE + temp
		end
		if classA == 1 and t then
			a.PARRY = a.PARRY + 1 * (t["WARRIOR|Arms|Deflection|5"] or 0)
			a.CRIT = a.CRIT + 1 * (t["WARRIOR|Fury|Cruelty|5"] or 0)
			a.TOHIT = a.TOHIT + 1 * (t["WARRIOR|Fury|Precision|3"] or 0)
			statmods2.a.ARMOR = statmods2.a.ARMOR + 0.02 * (t["WARRIOR|Protection|Toughness|5"] or 0)

			local temp = 0.04 * 4 * (t["WARRIOR|Protection|Anticipation|5"] or 0)
			a.PARRY = a.PARRY + temp
			a.BLOCK = a.BLOCK + temp
			a.DODGE = a.DODGE + temp
		end
		if classB == 2 then
			b.HOLYCRIT = b.HOLYCRIT + 1 * (currentProfileTalents["PALADIN|Holy|Holy Power|5"] or 0)
			b.TOHIT = b.TOHIT + 1 * (currentProfileTalents["PALADIN|Protection|Precision|3"] or 0)
			statmods3.b.SPELLTOHIT = (statmods3.b.SPELLTOHIT or 0) + 1 * (currentProfileTalents["PALADIN|Protection|Precision|3"] or 0)
			statmods2.b.ARMOR = statmods2.b.ARMOR + 0.02 * (currentProfileTalents["PALADIN|Protection|Toughness|5"] or 0)
			b.PARRY = b.PARRY + 1 * (currentProfileTalents["PALADIN|Retribution|Deflection|5"] or 0)
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["PALADIN|Retribution|Conviction|5"] or 0)
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["PALADIN|Retribution|Sanctified Seals|3"] or 0)
			statmods3.b.SPELLCRIT = (statmods3.b.SPELLCRIT or 0) + 1 * (currentProfileTalents["PALADIN|Retribution|Sanctified Seals|3"] or 0)

			local temp = 0.07 * (ob.INT or 0) * (currentProfileTalents["PALADIN|Holy|Holy Guidance|5"] or 0)
			statmods3.b.DMG = (statmods3.b.DMG or 0) + temp
			statmods3.b.HEAL = (statmods3.b.HEAL or 0) + temp
			temp = 0.04 * 4 * (currentProfileTalents["PALADIN|Protection|Anticipation|5"] or 0)
			b.PARRY = b.PARRY + temp
			b.BLOCK = b.BLOCK + temp
			b.DODGE = b.DODGE + temp
		end
		if classA == 2 and t then
			a.HOLYCRIT = a.HOLYCRIT + 1 * (t["PALADIN|Holy|Holy Power|5"] or 0)
			a.TOHIT = a.TOHIT + 1 * (t["PALADIN|Protection|Precision|3"] or 0)
			statmods3.a.SPELLTOHIT = (statmods3.a.SPELLTOHIT or 0) + 1 * (t["PALADIN|Protection|Precision|3"] or 0)
			statmods2.a.ARMOR = statmods2.a.ARMOR + 0.02 * (t["PALADIN|Protection|Toughness|5"] or 0)
			a.PARRY = a.PARRY + 1 * (t["PALADIN|Retribution|Deflection|5"] or 0)
			a.CRIT = a.CRIT + 1 * (t["PALADIN|Retribution|Conviction|5"] or 0)
			a.CRIT = a.CRIT + 1 * (t["PALADIN|Retribution|Sanctified Seals|3"] or 0)
			statmods3.a.SPELLCRIT = (statmods3.a.SPELLCRIT or 0) + 1 * (t["PALADIN|Retribution|Sanctified Seals|3"] or 0)

			local temp = 0.07 * (oa.INT or 0) * (t["PALADIN|Holy|Holy Guidance|5"] or 0)
			statmods3.a.DMG = (statmods3.a.DMG or 0) + temp
			statmods3.a.HEAL = (statmods3.a.HEAL or 0) + temp
			temp = 0.04 * 4 * (t["PALADIN|Protection|Anticipation|5"] or 0)
			a.PARRY = a.PARRY + temp
			a.BLOCK = a.BLOCK + temp
			a.DODGE = a.DODGE + temp
		end
		if classB == 3 then
			statmods2.b.HEALTH = statmods2.b.HEALTH + 0.01 * (currentProfileTalents["HUNTER|Beast Mastery|Enduring Training|5"] or 0)
			statmods2.b.ARMOR = statmods2.b.ARMOR + 0.01 * (WoWEquip_TalentData2["HUNTER|Beast Mastery|Thick Hide|3"].d[currentProfileTalents["HUNTER|Beast Mastery|Thick Hide|3"]] or 0)
			b.RANGEDCRIT = b.RANGEDCRIT + 1 * (currentProfileTalents["HUNTER|Marksmanship|Lethal Shots|5"] or 0)
			b.RANGEDATTACKPOWER = b.RANGEDATTACKPOWER + 0.15 * (ob.INT or 0) * (currentProfileTalents["HUNTER|Marksmanship|Careful Aim|3"] or 0)
			statmods2.b.RANGEDATTACKPOWER = statmods2.b.RANGEDATTACKPOWER + 0.02 * (currentProfileTalents["HUNTER|Marksmanship|Master Marksman|5"] or 0)
			b.PARRY = b.PARRY + 1 * (currentProfileTalents["HUNTER|Survival|Deflection|5"] or 0)
			statmods2.b.HEALTH = statmods2.b.HEALTH + 0.02 * (currentProfileTalents["HUNTER|Survival|Survivalist|5"] or 0)
			b.TOHIT = b.TOHIT + 1 * (currentProfileTalents["HUNTER|Survival|Surefooted|3"] or 0)
			b.RANGEDTOHIT = b.RANGEDTOHIT + 1 * (currentProfileTalents["HUNTER|Survival|Surefooted|3"] or 0)
			statmods2.b.ATTACKPOWER = statmods2.b.ATTACKPOWER + 0.02 * (currentProfileTalents["HUNTER|Survival|Survival Instincts|2"] or 0)
			statmods2.b.RANGEDATTACKPOWER = statmods2.b.RANGEDATTACKPOWER + 0.02 * (currentProfileTalents["HUNTER|Survival|Survival Instincts|2"] or 0)
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["HUNTER|Survival|Killer Instinct|3"] or 0)
			b.RANGEDCRIT = b.RANGEDCRIT + 1 * (currentProfileTalents["HUNTER|Survival|Killer Instinct|3"] or 0)
		end
		if classA == 3 and t then
			statmods2.a.HEALTH = statmods2.a.HEALTH + 0.01 * (t["HUNTER|Beast Mastery|Enduring Training|5"] or 0)
			statmods2.a.ARMOR = statmods2.a.ARMOR + 0.01 * (WoWEquip_TalentData2["HUNTER|Beast Mastery|Thick Hide|3"].d[t["HUNTER|Beast Mastery|Thick Hide|3"]] or 0)
			a.RANGEDCRIT = a.RANGEDCRIT + 1 * (t["HUNTER|Marksmanship|Lethal Shots|5"] or 0)
			a.RANGEDATTACKPOWER = a.RANGEDATTACKPOWER + 0.15 * (oa.INT or 0) * (t["HUNTER|Marksmanship|Careful Aim|3"] or 0)
			statmods2.a.RANGEDATTACKPOWER = statmods2.a.RANGEDATTACKPOWER + 0.02 * (t["HUNTER|Marksmanship|Master Marksman|5"] or 0)
			a.PARRY = a.PARRY + 1 * (t["HUNTER|Survival|Deflection|5"] or 0)
			statmods2.a.HEALTH = statmods2.a.HEALTH + 0.02 * (t["HUNTER|Survival|Survivalist|5"] or 0)
			a.TOHIT = a.TOHIT + 1 * (t["HUNTER|Survival|Surefooted|3"] or 0)
			a.RANGEDTOHIT = a.RANGEDTOHIT + 1 * (t["HUNTER|Survival|Surefooted|3"] or 0)
			statmods2.a.ATTACKPOWER = statmods2.a.ATTACKPOWER + 0.02 * (t["HUNTER|Survival|Survival Instincts|2"] or 0)
			statmods2.a.RANGEDATTACKPOWER = statmods2.a.RANGEDATTACKPOWER + 0.02 * (t["HUNTER|Survival|Survival Instincts|2"] or 0)
			a.CRIT = a.CRIT + 1 * (t["HUNTER|Survival|Killer Instinct|3"] or 0)
			a.RANGEDCRIT = a.RANGEDCRIT + 1 * (t["HUNTER|Survival|Killer Instinct|3"] or 0)
		end
		if classB == 4 then
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["ROGUE|Assassination|Malice|5"] or 0)
			b.RANGEDCRIT = b.RANGEDCRIT + 1 * (currentProfileTalents["ROGUE|Assassination|Malice|5"] or 0)
			b.DODGE = b.DODGE + 1 * (currentProfileTalents["ROGUE|Combat|Lightning Reflexes|5"] or 0)
			b.PARRY = b.PARRY + 1 * (currentProfileTalents["ROGUE|Combat|Deflection|5"] or 0)
			b.TOHIT = b.TOHIT + 1 * (currentProfileTalents["ROGUE|Combat|Precision|5"] or 0)
			b.RANGEDTOHIT = b.RANGEDTOHIT + 1 * (currentProfileTalents["ROGUE|Combat|Precision|5"] or 0)
			statmods2.b.ATTACKPOWER = statmods2.b.ATTACKPOWER + 0.02 * (currentProfileTalents["ROGUE|Subtlety|Deadliness|5"] or 0)
			statmods2.b.RANGEDATTACKPOWER = statmods2.b.RANGEDATTACKPOWER + 0.02 * (currentProfileTalents["ROGUE|Subtlety|Deadliness|5"] or 0)
		end
		if classA == 4 and t then
			a.CRIT = a.CRIT + 1 * (t["ROGUE|Assassination|Malice|5"] or 0)
			a.RANGEDCRIT = a.RANGEDCRIT + 1 * (t["ROGUE|Assassination|Malice|5"] or 0)
			a.DODGE = a.DODGE + 1 * (t["ROGUE|Combat|Lightning Reflexes|5"] or 0)
			a.PARRY = a.PARRY + 1 * (t["ROGUE|Combat|Deflection|5"] or 0)
			a.TOHIT = a.TOHIT + 1 * (t["ROGUE|Combat|Precision|5"] or 0)
			a.RANGEDTOHIT = a.RANGEDTOHIT + 1 * (t["ROGUE|Combat|Precision|5"] or 0)
			statmods2.a.ATTACKPOWER = statmods2.a.ATTACKPOWER + 0.02 * (t["ROGUE|Subtlety|Deadliness|5"] or 0)
			statmods2.a.RANGEDATTACKPOWER = statmods2.a.RANGEDATTACKPOWER + 0.02 * (t["ROGUE|Subtlety|Deadliness|5"] or 0)
		end
		if classB == 5 then
			statmods2.b.MANA = statmods2.b.MANA + 0.02 * (currentProfileTalents["PRIEST|Discipline|Mental Strength|5"] or 0)
			statmods2.b.DMG = statmods2.b.DMG + 0.01 * (currentProfileTalents["PRIEST|Discipline|Force of Will|5"] or 0)
			b.HOLYCRIT = b.HOLYCRIT + 1 * (currentProfileTalents["PRIEST|Holy|Holy Specialization|5"] or 0)
			statmods2.b.HEAL = statmods2.b.HEAL + 0.02 * (currentProfileTalents["PRIEST|Holy|Spiritual Healing|5"] or 0)
			b.SHADOWHIT = b.SHADOWHIT + 2 * (currentProfileTalents["PRIEST|Shadow|Shadow Focus|5"] or 0)
			statmods2.b.SHADOWDMG = statmods2.b.SHADOWDMG + 0.02 * (currentProfileTalents["PRIEST|Shadow|Darkness|5"] or 0)

			local temp = 0.05 * (ob.SPI or 0) * (currentProfileTalents["PRIEST|Holy|Spiritual Guidance|5"] or 0)
			statmods3.b.DMG = (statmods3.b.DMG or 0) + temp
			statmods3.b.HEAL = (statmods3.b.HEAL or 0) + temp
		end
		if classA == 5 and t then
			statmods2.a.MANA = statmods2.a.MANA + 0.02 * (t["PRIEST|Discipline|Mental Strength|5"] or 0)
			statmods2.a.DMG = statmods2.a.DMG + 0.01 * (t["PRIEST|Discipline|Force of Will|5"] or 0)
			a.HOLYCRIT = a.HOLYCRIT + 1 * (t["PRIEST|Holy|Holy Specialization|5"] or 0)
			statmods2.a.HEAL = statmods2.a.HEAL + 0.02 * (t["PRIEST|Holy|Spiritual Healing|5"] or 0)
			a.SHADOWHIT = a.SHADOWHIT + 2 * (t["PRIEST|Shadow|Shadow Focus|5"] or 0)
			statmods2.a.SHADOWDMG = statmods2.a.SHADOWDMG + 0.02 * (t["PRIEST|Shadow|Darkness|5"] or 0)

			local temp = 0.05 * (oa.SPI or 0) * (t["PRIEST|Holy|Spiritual Guidance|5"] or 0)
			statmods3.a.DMG = (statmods3.a.DMG or 0) + temp
			statmods3.a.HEAL = (statmods3.a.HEAL or 0) + temp
		end
		if classB == 6 then
			statmods2.b.MANA = statmods2.b.MANA + 0.01 * (currentProfileTalents["SHAMAN|Enhancement|Ancestral Knowledge|5"] or 0)
			b.BLOCK = b.BLOCK + 1 * (currentProfileTalents["SHAMAN|Enhancement|Shield Specialization|5"] or 0)
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["SHAMAN|Enhancement|Thundering Strikes|5"] or 0)
			b.DODGE = b.DODGE + 1 * (currentProfileTalents["SHAMAN|Enhancement|Anticipation|5"] or 0)
			statmods2.b.ARMOR = statmods2.b.ARMOR + 0.02 * (currentProfileTalents["SHAMAN|Enhancement|Toughness|5"] or 0)
			b.TOHIT = b.TOHIT + 1 * (currentProfileTalents["SHAMAN|Restoration|Nature's Guidance|3"] or 0)
			statmods2.b.HEAL = statmods2.b.HEAL + 0.02 * (currentProfileTalents["SHAMAN|Restoration|Purification|5"] or 0)
			statmods3.b.SPELLTOHIT = (statmods3.b.SPELLTOHIT or 0) + 1 * (currentProfileTalents["SHAMAN|Restoration|Nature's Guidance|3"] or 0)

			local temp = 0.10 * (ob.ATTACKPOWER or 0) * (currentProfileTalents["SHAMAN|Enhancement|Mental Quickness|3"] or 0)
			statmods3.b.DMG = (statmods3.b.DMG or 0) + temp
			statmods3.b.HEAL = (statmods3.b.HEAL or 0) + temp
			temp = 0.10 * (ob.INT or 0) * (currentProfileTalents["SHAMAN|Restoration|Nature's Blessing|3"] or 0)
			statmods3.b.DMG = (statmods3.b.DMG or 0) + temp
			statmods3.b.HEAL = (statmods3.b.HEAL or 0) + temp
			temp = 2 * (currentProfileTalents["SHAMAN|Elemental|Elemental Precision|3"] or 0)
			b.FIREHIT = b.FIREHIT + temp
			b.FROSTHIT = b.FROSTHIT + temp
			b.NATUREHIT = b.NATUREHIT + temp
		end
		if classA == 6 and t then
			statmods2.a.MANA = statmods2.a.MANA + 0.01 * (t["SHAMAN|Enhancement|Ancestral Knowledge|5"] or 0)
			a.BLOCK = a.BLOCK + 1 * (t["SHAMAN|Enhancement|Shield Specialization|5"] or 0)
			a.CRIT = a.CRIT + 1 * (t["SHAMAN|Enhancement|Thundering Strikes|5"] or 0)
			a.DODGE = a.DODGE + 1 * (t["SHAMAN|Enhancement|Anticipation|5"] or 0)
			statmods2.a.ARMOR = statmods2.a.ARMOR + 0.02 * (t["SHAMAN|Enhancement|Toughness|5"] or 0)
			a.TOHIT = a.TOHIT + 1 * (t["SHAMAN|Restoration|Nature's Guidance|3"] or 0)
			statmods2.a.HEAL = statmods2.a.HEAL + 0.02 * (t["SHAMAN|Restoration|Purification|5"] or 0)
			statmods3.a.SPELLTOHIT = (statmods3.a.SPELLTOHIT or 0) + 1 * (t["SHAMAN|Restoration|Nature's Guidance|3"] or 0)

			local temp = 0.10 * (oa.ATTACKPOWER or 0) * (t["SHAMAN|Enhancement|Mental Quickness|3"] or 0)
			statmods3.a.DMG = (statmods3.a.DMG or 0) + temp
			statmods3.a.HEAL = (statmods3.a.HEAL or 0) + temp
			temp = 0.10 * (oa.INT or 0) * (t["SHAMAN|Restoration|Nature's Blessing|3"] or 0)
			statmods3.a.DMG = (statmods3.a.DMG or 0) + temp
			statmods3.a.HEAL = (statmods3.a.HEAL or 0) + temp
			temp = 2 * (t["SHAMAN|Elemental|Elemental Precision|3"] or 0)
			a.FIREHIT = a.FIREHIT + temp
			a.FROSTHIT = a.FROSTHIT + temp
			a.NATUREHIT = a.NATUREHIT + temp
		end
		if classB == 7 then
			b.ARCANEHIT = b.ARCANEHIT + 2 * (currentProfileTalents["MAGE|Arcane|Arcane Focus|5"] or 0)
			b.ARMOR = b.ARMOR + 1.0 * (ob.INT or 0) * (currentProfileTalents["MAGE|Arcane|Arcane Fortitude|1"] or 0)
			statmods2.b.DMG = statmods2.b.DMG + 0.01 * (currentProfileTalents["MAGE|Arcane|Arcane Instability|3"] or 0)
			statmods3.b.SPELLCRIT = (statmods3.b.SPELLCRIT or 0) + 1 * (currentProfileTalents["MAGE|Arcane|Arcane Instability|3"] or 0)
			statmods2.b.DMG = statmods2.b.DMG + 0.01 * (currentProfileTalents["MAGE|Fire|Playing with Fire|3"] or 0)
			b.FIRECRIT = b.FIRECRIT + 2 * (currentProfileTalents["MAGE|Fire|Critical Mass|3"] or 0)
			statmods2.b.FIREDMG = statmods2.b.FIREDMG + 0.02 * (currentProfileTalents["MAGE|Fire|Fire Power|5"] or 0)
			b.FIRECRIT = b.FIRECRIT + 1 * (currentProfileTalents["MAGE|Fire|Pyromaniac|3"] or 0)
			b.FIREHIT = b.FIREHIT + 1 * (currentProfileTalents["MAGE|Frost|Elemental Precision|3"] or 0)
			b.FROSTHIT = b.FROSTHIT + 1 * (currentProfileTalents["MAGE|Frost|Elemental Precision|3"] or 0)
			statmods2.b.FROSTDMG = statmods2.b.FROSTDMG + 0.02 * (currentProfileTalents["MAGE|Frost|Piercing Ice|3"] or 0)
			statmods2.b.FROSTDMG = statmods2.b.FROSTDMG + 0.01 * (currentProfileTalents["MAGE|Frost|Arctic Winds|5"] or 0)

			local temp = 0.05 * (ob.INT or 0) * (currentProfileTalents["MAGE|Arcane|Mind Mastery|3"] or 0)
			statmods3.b.DMG = (statmods3.b.DMG or 0) + temp
		end
		if classA == 7 and t then
			a.ARCANEHIT = a.ARCANEHIT + 2 * (t["MAGE|Arcane|Arcane Focus|5"] or 0)
			a.ARMOR = a.ARMOR + 1.0 * (oa.INT or 0) * (t["MAGE|Arcane|Arcane Fortitude|1"] or 0)
			statmods2.a.DMG = statmods2.a.DMG + 0.01 * (t["MAGE|Arcane|Arcane Instability|3"] or 0)
			statmods3.a.SPELLCRIT = (statmods3.a.SPELLCRIT or 0) + 1 * (t["MAGE|Arcane|Arcane Instability|3"] or 0)
			statmods2.a.DMG = statmods2.a.DMG + 0.01 * (t["MAGE|Fire|Playing with Fire|3"] or 0)
			a.FIRECRIT = a.FIRECRIT + 2 * (t["MAGE|Fire|Critical Mass|3"] or 0)
			statmods2.a.FIREDMG = statmods2.a.FIREDMG + 0.02 * (t["MAGE|Fire|Fire Power|5"] or 0)
			a.FIRECRIT = a.FIRECRIT + 1 * (t["MAGE|Fire|Pyromaniac|3"] or 0)
			a.FIREHIT = a.FIREHIT + 1 * (t["MAGE|Frost|Elemental Precision|3"] or 0)
			a.FROSTHIT = a.FROSTHIT + 1 * (t["MAGE|Frost|Elemental Precision|3"] or 0)
			statmods2.a.FROSTDMG = statmods2.a.FROSTDMG + 0.02 * (t["MAGE|Frost|Piercing Ice|3"] or 0)
			statmods2.a.FROSTDMG = statmods2.a.FROSTDMG + 0.01 * (t["MAGE|Frost|Arctic Winds|5"] or 0)

			local temp = 0.05 * (oa.INT or 0) * (t["MAGE|Arcane|Mind Mastery|3"] or 0)
			statmods3.a.DMG = (statmods3.a.DMG or 0) + temp
		end
		if classB == 8 then
			statmods2.b.SHADOWDMG = statmods2.b.SHADOWDMG + 0.02 * (currentProfileTalents["WARLOCK|Affliction|Shadow Mastery|5"] or 0)
			statmods2.b.MANA = statmods2.b.MANA + 0.01 * (currentProfileTalents["WARLOCK|Demonology|Fel Intellect|3"] or 0)
			b.CRIT = b.CRIT + 1 * (currentProfileTalents["WARLOCK|Demonology|Demonic Tactics|5"] or 0)
			statmods3.b.SPELLCRIT = (statmods3.b.SPELLCRIT or 0) + 1 * (currentProfileTalents["WARLOCK|Demonology|Demonic Tactics|5"] or 0)
			statmods2.b.FIREDMG = statmods2.b.FIREDMG + 0.02 * (currentProfileTalents["WARLOCK|Destruction|Emberstorm|5"] or 0)
			statmods3.b.SPELLCRIT = (statmods3.b.SPELLCRIT or 0) + 1 * (currentProfileTalents["WARLOCK|Destruction|Backlash|3"] or 0)
		end
		if classA == 8 and t then
			statmods2.a.SHADOWDMG = statmods2.a.SHADOWDMG + 0.02 * (t["WARLOCK|Affliction|Shadow Mastery|5"] or 0)
			statmods2.a.MANA = statmods2.a.MANA + 0.01 * (t["WARLOCK|Demonology|Fel Intellect|3"] or 0)
			a.CRIT = a.CRIT + 1 * (t["WARLOCK|Demonology|Demonic Tactics|5"] or 0)
			statmods3.a.SPELLCRIT = (statmods3.a.SPELLCRIT or 0) + 1 * (t["WARLOCK|Demonology|Demonic Tactics|5"] or 0)
			statmods2.a.FIREDMG = statmods2.a.FIREDMG + 0.02 * (t["WARLOCK|Destruction|Emberstorm|5"] or 0)
			statmods3.a.SPELLCRIT = (statmods3.a.SPELLCRIT or 0) + 1 * (t["WARLOCK|Destruction|Backlash|3"] or 0)
		end
		if classB == 9 then
			statmods3.b.SPELLTOHIT = (statmods3.b.SPELLTOHIT or 0) + 2 * (currentProfileTalents["DRUID|Balance|Balance of Power|2"] or 0)
			statmods2.b.ARMOR = statmods2.b.ARMOR + 0.01 * (WoWEquip_TalentData2["DRUID|Feral Combat|Thick Hide|3"].d[currentProfileTalents["DRUID|Feral Combat|Thick Hide|3"]] or 0)
			statmods2.b.HEAL = statmods2.b.HEAL + 0.02 * (currentProfileTalents["DRUID|Restoration|Gift of Nature|5"] or 0)
			statmods3.b.SPELLCRIT = (statmods3.b.SPELLCRIT or 0) + 1 * (currentProfileTalents["DRUID|Restoration|Natural Perfection|3"] or 0)

			local temp = 0.01 * (ob.INT or 0) * (WoWEquip_TalentData2["DRUID|Balance|Lunar Guidance|3"].d[currentProfileTalents["DRUID|Balance|Lunar Guidance|3"]] or 0)
			statmods3.b.DMG = (statmods3.b.DMG or 0) + temp
			statmods3.b.HEAL = (statmods3.b.HEAL or 0) + temp
			temp = 0.50 * (ob.AGI or 0) * (currentProfileTalents["DRUID|Feral Combat|Nurturing Instinct|2"] or 0)
			statmods3.b.HEAL = (statmods3.b.HEAL or 0) + temp
		end
		if classA == 9 and t then
			statmods3.a.SPELLTOHIT = (statmods3.a.SPELLTOHIT or 0) + 2 * (t["DRUID|Balance|Balance of Power|2"] or 0)
			statmods2.a.ARMOR = statmods2.a.ARMOR + 0.01 * (WoWEquip_TalentData2["DRUID|Feral Combat|Thick Hide|3"].d[t["DRUID|Feral Combat|Thick Hide|3"]] or 0)
			statmods2.a.HEAL = statmods2.a.HEAL + 0.02 * (t["DRUID|Restoration|Gift of Nature|5"] or 0)
			statmods3.a.SPELLCRIT = (statmods3.a.SPELLCRIT or 0) + 1 * (t["DRUID|Restoration|Natural Perfection|3"] or 0)

			local temp = 0.01 * (oa.INT or 0) * (WoWEquip_TalentData2["DRUID|Balance|Lunar Guidance|3"].d[t["DRUID|Balance|Lunar Guidance|3"]] or 0)
			statmods3.a.DMG = (statmods3.a.DMG or 0) + temp
			statmods3.a.HEAL = (statmods3.a.HEAL or 0) + temp
			temp = 0.50 * (oa.AGI or 0) * (t["DRUID|Feral Combat|Nurturing Instinct|2"] or 0)
			statmods3.a.HEAL = (statmods3.a.HEAL or 0) + temp
		end
	end

	-- Apply DMG to all damage types
	if statmods3.a.DMG or statmods3.b.DMG then
		local tempA = statmods3.a.DMG or 0
		local tempB = statmods3.b.DMG or 0
		a.DMG = (a.DMG or 0) + tempA
		b.DMG = (b.DMG or 0) + tempB
		for _, key in ipairs(damageTypes) do
			a[key] = (a[key] or 0) + tempA
			b[key] = (b[key] or 0) + tempB
		end
	end
	-- Apply SPELLCRIT to all damage types
	if statmods3.a.SPELLCRIT or statmods3.b.SPELLCRIT then
		local tempA = statmods3.a.SPELLCRIT or 0
		local tempB = statmods3.b.SPELLCRIT or 0
		a.SPELLCRIT = (a.SPELLCRIT or 0) + tempA
		b.SPELLCRIT = (b.SPELLCRIT or 0) + tempB
		for key, value in pairs(damageTypes2) do
			if value == "SPELLCRIT" then
				a[key] = (a[key] or 0) + tempA
				b[key] = (b[key] or 0) + tempB
			end
		end
	end
	-- Apply SPELLTOHIT to all damage types
	if statmods3.a.SPELLTOHIT or statmods3.b.SPELLTOHIT then
		local tempA = statmods3.a.SPELLTOHIT or 0
		local tempB = statmods3.b.SPELLTOHIT or 0
		a.SPELLTOHIT = (a.SPELLTOHIT or 0) + tempA
		b.SPELLTOHIT = (b.SPELLTOHIT or 0) + tempB
		for key, value in pairs(damageTypes2) do
			if value == "SPELLTOHIT" then
				a[key] = (a[key] or 0) + tempA
				b[key] = (b[key] or 0) + tempB
			end
		end
	end
	if statmods3.a.HEAL or statmods3.b.HEAL then
		a.HEAL = (a.HEAL or 0) + (statmods3.a.HEAL or 0)
		b.HEAL = (b.HEAL or 0) + (statmods3.b.HEAL or 0)
	end

	-- Apply the DMG stat % increase to all damage types
	for _, key in ipairs(damageTypes) do
		statmods2.a[key] = statmods2.a[key] + statmods2.a.DMG - 1
		statmods2.b[key] = statmods2.b[key] + statmods2.b.DMG - 1
	end
	-- Multiply in the % mods
	for k in pairs(statmods2.a) do
		-- Treat +ARMOR% specially because it doesn't apply to enchants, only base item armor
		if k == "ARMOR" then
			--AceLibrary("AceConsole-2.0"):PrintLiteral(a.ARMOR, oa.BASE_ARMOR, oa.ARMOR_BONUS, statmods2.a.ARMOR)
			--AceLibrary("AceConsole-2.0"):PrintLiteral(b.ARMOR, ob.BASE_ARMOR, ob.ARMOR_BONUS, statmods2.b.ARMOR)
			a.ARMOR = a.ARMOR + (oa.BASE_ARMOR or 0) * (statmods2.a.ARMOR - 1)
			b.ARMOR = b.ARMOR + (ob.BASE_ARMOR or 0) * (statmods2.b.ARMOR - 1)
		else
			if a[k] then a[k] = a[k] * statmods2.a[k] end
			if b[k] then b[k] = b[k] * statmods2.b[k] end
		end
	end

	-- Remove ranged stat if its the same as the melee stat
	if abs(a.RANGEDCRIT - a.CRIT) < 0.01 then a.RANGEDCRIT = nil end
	if abs(b.RANGEDCRIT - b.CRIT) < 0.01 then b.RANGEDCRIT = nil end
	if abs(a.RANGEDTOHIT - a.TOHIT) < 0.01 then a.RANGEDTOHIT = nil end
	if abs(b.RANGEDTOHIT - b.TOHIT) < 0.01 then b.RANGEDTOHIT = nil end
	-- Remove damage stat if its the same as the base damage stat
	for _, key in ipairs(damageTypes) do
		if a[key] and a.DMG and abs(a[key] - a.DMG) < 0.01 then a[key] = nil end
		if b[key] and b.DMG and abs(b[key] - b.DMG) < 0.01 then b[key] = nil end
		if a[key] and not b[key] then b[key] = b.DMG end
		if b[key] and not a[key] then a[key] = a.DMG end
	end
	for key, value in pairs(damageTypes2) do
		if a[key] and a[value] and abs(a[key] - a[value]) < 0.01 then a[key] = nil end
		if b[key] and b[value] and abs(b[key] - b[value]) < 0.01 then b[key] = nil end
		if a[key] and not b[key] then b[key] = b[value] end
		if b[key] and not a[key] then a[key] = a[value] end
	end
end

-- To print the bonuses in the bonus frame
local function printBonuses(playerbonuses, bonuses, levelplayer, level, textleft, textright)
	local found, difference, diffstring;

	for k, v in ipairs(WoWEquip_IBonusCatTitles) do
		found = 0;
		for k2, v2 in pairs(bonuses) do
			if (WoWEquip_IBonusData[k2].id == k) then
				found = found + 1;
				if (found == 1) then
					textleft = textleft.."|cFFFFFFFF"..v.."|r\n";
					textright = textright.."\n";
				end
				textleft = textleft.."  "..WoWEquip_IBonusData[k2].t.."\n";
				playerbonuses[k2] = playerbonuses[k2] or 0;
				difference = bonuses[k2] - playerbonuses[k2];
				if (WoWEquip_Save.showrating or not WoWEquip_IBonusData[k2].r) then
					if (WoWEquip_IBonusData[k2].p and not WoWEquip_IBonusData[k2].r) then
						if (WoWEquip_Save.compareOptions == 1) then
							diffstring = "\n";
						else
							if (difference >= 0) then
								diffstring = format(" |cFF00FF00(+%.2f%%)|r\n", difference);
							else
								diffstring = format(" |cFFFF0000(%.2f%%)|r\n", difference);
							end
						end
						textright = format("%s%.2f%%%s", textright, v2, diffstring);
					else
						if (WoWEquip_Save.compareOptions == 1) then
							diffstring = "\n";
						else
							if (difference >= 0) then
								diffstring = format(" |cFF00FF00(+%d)|r\n", difference);
							else
								diffstring = format(" |cFFFF0000(%d)|r\n", difference);
							end
						end
						textright = format("%s%d%s", textright, v2, diffstring);
					end
				else
					local temp, temp2, temp4;
					if (WoWEquip_IBonusData[k2].p == true) then
						temp4 = "%";
					else
						temp4 = "";
					end
					temp = IBL:GetRatingBonus(k2, bonuses[k2], level);
					temp2 = temp - IBL:GetRatingBonus(k2, playerbonuses[k2], levelplayer);
					if (WoWEquip_Save.compareOptions == 1) then
							diffstring = "\n";
					else
						if (difference >= 0) then
							diffstring = format(" |cFF00FF00(+%.2f%s)|r\n", temp2, temp4);
						else
							diffstring = format(" |cFFFF0000(%.2f%s)|r\n", temp2, temp4);
						end
					end
					textright = format("%s%.2f%s%s", textright, temp, temp4, diffstring);
				end
			end
		end
		for k2, v2 in pairs(playerbonuses) do
			if (WoWEquip_IBonusData[k2].id == k) then
				if (not bonuses[k2]) then
					found = found + 1;
					if (found == 1) then
						textleft = textleft.."|cFFFFFFFF"..v.."|r\n";
						textright = textright.."\n";
					end
					textleft = textleft.."  "..WoWEquip_IBonusData[k2].t.."\n";
					if (WoWEquip_Save.showrating or not WoWEquip_IBonusData[k2].r) then
						if (WoWEquip_Save.compareOptions == 1) then
							diffstring = "\n";
						else
							if (v2 < 0) then
								diffstring = format(" |cFF00FF00(+%d)|r\n", -v2);
							else
								diffstring = format(" |cFFFF0000(%d)|r\n", -v2);
							end	
						end
						textright = format("%s0%s", textright, diffstring);
					else
						local temp, temp4;
						if (WoWEquip_IBonusData[k2].p == true) then
							temp4 = "%";
						else
							temp4 = "";
						end
						temp = IBL:GetRatingBonus(k2, v2, levelplayer);
						if (WoWEquip_Save.compareOptions == 1) then
							diffstring = "\n";
						else
							if (v2 < 0) then
								diffstring = format(" |cFF00FF00(+%.2f%s)|r\n", -temp, temp4);
							else
								diffstring = format(" |cFFFF0000(%.2f%s)|r\n", -temp, temp4);
							end	
						end
						textright = format("%s0%s%s", textright, temp4, diffstring);
					end
				end
			end
		end
		if (found > 0) then
			textleft = textleft.."\n";
			textright = textright.."\n";
		end
	end

	return textleft, textright;
end

local function printBonuses2(playerbonuses, bonuses, levelplayer, level, textleft2, textright2)
	local class = currentProfileClass;
	local race = currentProfileRace;
	local classplayer;
	local raceplayer;
	if (WoWEquip_Save.compareOptions == 1) then
		classplayer = class;
		raceplayer = race;
	elseif (WoWEquip_Save.compareOptions == 2) then
		_, classplayer = UnitClass("player");
		_, raceplayer = UnitRace("player");
		if not WoWEquip_Save.IgnoreRace then
			textleft2 = textleft2..L["Comparing: "]..L[raceplayer].." "..L[classplayer].."\n";
			textright2 = textright2.."\n";
		end
		classplayer = WOWEQUIP_CLASSID[classplayer];
		raceplayer = WOWEQUIP_RACEID[raceplayer];
		if not WoWEquip_Save.IgnoreTalents then
			for _, k in pairs(WoWEquip_TalentData[classplayer]) do
				local v = playerTalents[k]
				if v then
					local classID, tree, talent, maxrank = strsplit("|", k)
					textleft2 = textleft2..("|cFF00FF00(%d/%s)|r (%s) |cFFFFFFFF%s|r\n"):format(v, maxrank, L[tree], L[talent])
					textright2 = textright2.."\n";
				end
			end
		end
		textleft2 = textleft2.."\n";
		textright2 = textright2.."\n";
	elseif (WoWEquip_Save.compareOptions == 3) then
		classplayer = WoWEquip_Save.profiles[WoWEquip_Save.compareProfile].class;
		raceplayer = WoWEquip_Save.profiles[WoWEquip_Save.compareProfile].race or 0;
		if not WoWEquip_Save.IgnoreRace then
			textleft2 = textleft2..L["Comparing: "]..L[WOWEQUIP_RACEID[raceplayer]].." "..L[WOWEQUIP_CLASSID[classplayer]].."\n";
			textright2 = textright2.."\n";
		end
		if not WoWEquip_Save.IgnoreTalents then
			if WoWEquip_Save.profiles[WoWEquip_Save.compareProfile].talents then
				for _, k in pairs(WoWEquip_TalentData[classplayer]) do
					local v = WoWEquip_Save.profiles[WoWEquip_Save.compareProfile].talents[k]
					if v then
						local classID, tree, talent, maxrank = strsplit("|", k)
						if classID == WOWEQUIP_CLASSID[classplayer] then
							textleft2 = textleft2..("|cFF00FF00(%d/%s)|r (%s) |cFFFFFFFF%s|r\n"):format(v, maxrank, L[tree], L[talent])
							textright2 = textright2.."\n";
						end
					end
				end
			end
		end
		textleft2 = textleft2.."\n";
		textright2 = textright2.."\n";
	end

	playerbonuses.RANGEDATTACKPOWER	= playerbonuses.RANGEDATTACKPOWER or playerbonuses.ATTACKPOWER;
	playerbonuses.CR_RANGEDCRIT	= playerbonuses.CR_RANGEDCRIT or playerbonuses.CR_CRIT;
	bonuses.RANGEDATTACKPOWER	= bonuses.RANGEDATTACKPOWER or bonuses.ATTACKPOWER;
	bonuses.CR_RANGEDCRIT		= bonuses.CR_RANGEDCRIT or bonuses.CR_CRIT;

	-- Modify stats stage 2
	modifyBonuses2(playerbonuses, bonuses, raceplayer, race, classplayer, class);

	cleartable(tier2data);
	local defenseBonus	= floor(IBL:GetRatingBonus("CR_DEFENSE", bonuses.CR_DEFENSE or 0, level)) * 0.04;	-- to block/parry/dodge
	tier2data.HEALTH	= (bonuses.HEALTH or 0) + (bonuses.STA or 0) * 10;
	tier2data.MANA		= (bonuses.MANA or 0) + (bonuses.INT or 0) * 15;
	tier2data.ATTACKPOWER		= (bonuses.ATTACKPOWER or 0) + SL:GetAPFromStr(bonuses.STR or 0, class) + SL:GetAPFromAgi(bonuses.AGI or 0, class);
	tier2data.RANGEDATTACKPOWER	= (bonuses.RANGEDATTACKPOWER or 0) + SL:GetRAPFromAgi(bonuses.AGI or 0, class);
	tier2data.CRIT		= IBL:GetRatingBonus("CR_CRIT", bonuses.CR_CRIT or 0, level) + SL:GetCritFromAgi(bonuses.AGI or 0, class, level);
	tier2data.TOHIT		= IBL:GetRatingBonus("CR_HIT", bonuses.CR_HIT or 0, level);
	tier2data.RANGEDCRIT	= IBL:GetRatingBonus("CR_RANGEDCRIT", bonuses.CR_RANGEDCRIT or 0, level) + SL:GetCritFromAgi(bonuses.AGI or 0, class, level);
	tier2data.RANGEDTOHIT	= tier2data.TOHIT
	tier2data.SPELLCRIT	= IBL:GetRatingBonus("CR_SPELLCRIT", bonuses.CR_SPELLCRIT or 0, level) + SL:GetSpellCritFromInt(bonuses.INT or 0, class, level);
	tier2data.SPELLTOHIT	= IBL:GetRatingBonus("CR_SPELLHIT", bonuses.CR_SPELLHIT or 0, level);
	tier2data.ARMOR		= (bonuses.ARMOR or 0) + (bonuses.AGI or 0) * 2;
	tier2data.BLOCKVALUE	= (bonuses.BLOCKVALUE or 0) + SL:GetBlockValueFromStr(bonuses.STR or 0, class);
	tier2data.BLOCK		= IBL:GetRatingBonus("CR_BLOCK", bonuses.CR_BLOCK or 0, level) + defenseBonus;
	tier2data.DODGE		= IBL:GetRatingBonus("CR_DODGE", bonuses.CR_DODGE or 0, level) + SL:GetDodgeFromAgi(bonuses.AGI or 0, class, level) + defenseBonus;
	tier2data.PARRY		= IBL:GetRatingBonus("CR_PARRY", bonuses.CR_PARRY or 0, level) + defenseBonus;
	--tier2data.manareg
	--tier2data.hpreg
	tier2data.DMG		= bonuses.DMG
	tier2data.HEAL		= bonuses.HEAL
	for _, key in ipairs(damageTypes) do
		tier2data[key]	= bonuses[key] or bonuses.DMG
	end
	for key, value in pairs(damageTypes2) do
		tier2data[key]	= tier2data[value]
	end

	cleartable(playertier2data);
	defenseBonus			= floor(IBL:GetRatingBonus("CR_DEFENSE", playerbonuses.CR_DEFENSE or 0, levelplayer)) * 0.04;	-- to block/parry/dodge
	playertier2data.HEALTH		= (playerbonuses.HEALTH or 0) + (playerbonuses.STA or 0) * 10;
	playertier2data.MANA		= (playerbonuses.MANA or 0) + (playerbonuses.INT or 0) * 15;
	playertier2data.ATTACKPOWER		= (playerbonuses.ATTACKPOWER or 0) + SL:GetAPFromStr(playerbonuses.STR or 0, classplayer) + SL:GetAPFromAgi(playerbonuses.AGI or 0, classplayer);
	playertier2data.RANGEDATTACKPOWER	= (playerbonuses.RANGEDATTACKPOWER or 0) + SL:GetRAPFromAgi(playerbonuses.AGI or 0, classplayer);
	playertier2data.CRIT		= IBL:GetRatingBonus("CR_CRIT", playerbonuses.CR_CRIT or 0, levelplayer) + SL:GetCritFromAgi(playerbonuses.AGI or 0, classplayer, levelplayer);
	playertier2data.TOHIT		= IBL:GetRatingBonus("CR_HIT", playerbonuses.CR_HIT or 0, levelplayer);
	playertier2data.RANGEDCRIT	= IBL:GetRatingBonus("CR_RANGEDCRIT", playerbonuses.CR_RANGEDCRIT or 0, levelplayer) + SL:GetCritFromAgi(playerbonuses.AGI or 0, classplayer, levelplayer);
	playertier2data.RANGEDTOHIT	= playertier2data.TOHIT
	playertier2data.SPELLCRIT	= IBL:GetRatingBonus("CR_SPELLCRIT", playerbonuses.CR_SPELLCRIT or 0, levelplayer) + SL:GetSpellCritFromInt(playerbonuses.INT or 0, classplayer, levelplayer);
	playertier2data.SPELLTOHIT	= IBL:GetRatingBonus("CR_SPELLHIT", playerbonuses.CR_SPELLHIT or 0, levelplayer);
	playertier2data.ARMOR		= (playerbonuses.ARMOR or 0) + (playerbonuses.AGI or 0) * 2;
	playertier2data.BLOCKVALUE	= (playerbonuses.BLOCKVALUE or 0) + SL:GetBlockValueFromStr(playerbonuses.STR or 0, classplayer);
	playertier2data.BLOCK		= IBL:GetRatingBonus("CR_BLOCK", playerbonuses.CR_BLOCK or 0, levelplayer) + defenseBonus;
	playertier2data.DODGE		= IBL:GetRatingBonus("CR_DODGE", playerbonuses.CR_DODGE or 0, levelplayer) + SL:GetDodgeFromAgi(playerbonuses.AGI or 0, classplayer, levelplayer) + defenseBonus;
	playertier2data.PARRY		= IBL:GetRatingBonus("CR_PARRY", playerbonuses.CR_PARRY or 0, levelplayer) + defenseBonus;
	--playertier2data.manareg
	--playertier2data.hpreg
	playertier2data.DMG		= playerbonuses.DMG
	playertier2data.HEAL		= playerbonuses.HEAL
	for _, key in ipairs(damageTypes) do
		playertier2data[key]	= playerbonuses[key] or playerbonuses.DMG
	end
	for key, value in pairs(damageTypes2) do
		playertier2data[key]	= playertier2data[value]
	end

	-- Modify stats stage 3
	modifyBonuses3(playertier2data, tier2data, playerbonuses, bonuses, raceplayer, race, classplayer, class);

	-- If not comparing profiles, then remove all the 0 entries from the target
	-- profile table so that negative difference entries don't get generated
	if (WoWEquip_Save.compareOptions == 1) then
		for k, v in pairs(playertier2data) do
			if v == 0 then playertier2data[k] = nil end
		end
	end

	return printBonuses(playertier2data, tier2data, levelplayer, level, textleft2, textright2);
end

local function modifyBonuses(a, b)
	-- This function modifies some special bonus damages to include the generic damage.
	local admg = (a.DMG or 0);
	local bdmg = (b.DMG or 0);
	for _, key in ipairs(damageTypes) do
		if (a[key] or b[key]) then
			a[key]	= (a[key] or 0) + admg;
			b[key]	= (b[key] or 0) + bdmg;
		end
	end
	if (a.DMGUNDEAD or b.DMGUNDEAD) then
		a.DMGUNDEAD	= (a.DMGUNDEAD or 0) + admg;
		b.DMGUNDEAD	= (b.DMGUNDEAD or 0) + bdmg;
	end

	local aap = (a.ATTACKPOWER or 0);
	local bap = (b.ATTACKPOWER or 0);
	if (a.ATTACKPOWERUNDEAD or b.ATTACKPOWERUNDEAD) then
		a.ATTACKPOWERUNDEAD	= (a.ATTACKPOWERUNDEAD or 0) + aap;
		b.ATTACKPOWERUNDEAD	= (b.ATTACKPOWERUNDEAD or 0) + bap;
	end
	if (a.ATTACKPOWERFERAL or b.ATTACKPOWERFERAL) then
		a.ATTACKPOWERFERAL	= (a.ATTACKPOWERFERAL or 0) + aap;
		b.ATTACKPOWERFERAL	= (b.ATTACKPOWERFERAL or 0) + bap;
	end
	if (a.RANGEDATTACKPOWER or b.RANGEDATTACKPOWER) then
		a.RANGEDATTACKPOWER	= (a.RANGEDATTACKPOWER or 0) + aap;
		b.RANGEDATTACKPOWER	= (b.RANGEDATTACKPOWER or 0) + bap;
	end

	if (a.CR_RANGEDCRIT or b.CR_RANGEDCRIT) then
		a.CR_RANGEDCRIT	= (a.CR_RANGEDCRIT or 0) + (a.CR_CRIT or 0);
		b.CR_RANGEDCRIT	= (b.CR_RANGEDCRIT or 0) + (b.CR_CRIT or 0);
	end
	if (a.CR_RANGEDHIT or b.CR_RANGEDHIT) then
		a.CR_RANGEDHIT	= (a.CR_RANGEDHIT or 0) + (a.CR_HIT or 0);
		b.CR_RANGEDHIT	= (b.CR_RANGEDHIT or 0) + (b.CR_HIT or 0);
	end

	a.ARMOR = (a.BASE_ARMOR or 0) + (a.ARMOR_BONUS or 0);	-- To be seperated by talent effects
	b.ARMOR = (b.BASE_ARMOR or 0) + (b.ARMOR_BONUS or 0);
	if (a.ARMOR == 0 and b.ARMOR == 0) then
		a.ARMOR = nil;
		b.ARMOR = nil;
	end
end

local function addGemColors(enchantID, t)
	local WoWEquip_GemColorData = WoWEquip_GemColorData;
	if (enchantID == 0) then
		return;
	end
	if (WoWEquip_GemColorData.red[enchantID]) then
		t.RED_GEM = (t.RED_GEM or 0) + 1;
	end
	if (WoWEquip_GemColorData.yellow[enchantID]) then
		t.YELLOW_GEM = (t.YELLOW_GEM or 0) + 1;
	end
	if (WoWEquip_GemColorData.blue[enchantID]) then
		t.BLUE_GEM = (t.BLUE_GEM or 0) + 1;
	end
	if (WoWEquip_GemColorData.meta[enchantID]) then
		t.META_GEM = (t.META_GEM or 0) + 1;
	end
end

function WoWEquip:UpdateBonusFrame()
	local level = tonumber(WoWEquip_LevelInputBox:GetText());
	local notincache = false;
	local playerlevel = nil;

	if (WoWEquip_Save.compareOptions == 1) then
		cleartable(playereq);
	elseif (WoWEquip_Save.compareOptions == 2) then
		-- Copy equipped gear into a table
		for k, v in pairs(WoWEquip_PaperDollAr) do
			playereq[v.slotname] = GetInventoryItemLink("player", v.slotnum);
		end
		playerlevel = UnitLevel("player");
	elseif (WoWEquip_Save.compareOptions == 3) then
		-- Copy equipped gear into a table
		cleartable(playereq);
		local loadTable = WoWEquip_Save.profiles[WoWEquip_Save.compareProfile];
		for k, v in pairs(WoWEquip_PaperDollAr) do
			playereq[v.slotname] = loadTable.eq[k];
			if (playereq[v.slotname] and not GetItemInfo(playereq[v.slotname])) then
				-- Remove items not in local cache
				playereq[v.slotname] = nil;
				notincache = true;
			end
		end
		playerlevel = loadTable.level;
	end

	-- Obtain the sets worn details, and also generate a new table of links that excludes items not in the local cache.
	cleartable(eqvalid);
	cleartable(set);
	for k, v in pairs(eq) do
		if (GetItemInfo(v)) then
			-- Scan set data
			temp = IBL:ScanItemLink(v);
			if (temp.set) then
				set[temp.set] = (set[temp.set] or 0) + 1;
			end
			if (not setsizes[temp.set]) then
				WoWEquip_ScanSetSize(v);
			end
			-- Insert into valid table
			eqvalid[k] = v;
		end
	end
	temp = nil;

	local playerbonuses;
	local bonuses;
	local textleft = "";
	local textright = " ";
	local textleft2 = "";
	local textright2 = " ";

--[[
	-- StatLogic Code
	cleartable(eqsum);
	cleartable(playereqsum);
	for k, v in pairs(playereq) do
		-- SL:GetSum() returns temptable with a __add metamethod
		playereqsum = playereqsum + SL:GetSum(v, temptable);
	end
	for k, v in pairs(eq) do
		if (GetItemInfo(v)) then
			eqsum = eqsum + SL:GetSum(v, temptable);
		end
	end
	playerbonuses = playereqsum;
	bonuses = eqsum;
	textleft = "|cFF00FF00-- StatLogicLib-1.0 --|r\n";
	textright = "\n";
	textleft, textright = printBonuses(playerbonuses, bonuses, playerlevel, level, textleft, textright);

	-- ItemBonusLib Code
	textleft = textleft.."\n|cFF00FF00-- ItemBonusLib-1.0 --|r\n";
	textright = textright.."\n\n";
]]

	playerbonuses = IBL:MergeDetails(IBL:BuildBonusSet(playereq));
	bonuses = IBL:MergeDetails(IBL:BuildBonusSet(eqvalid));
	modifyBonuses(playerbonuses, bonuses);
	-- Scan socketed gem color data
	for k, v in pairs(playereq) do
		local jewelId1, jewelId2, jewelId3, jewelId4 = strmatch(v, "item:%d+:%d+:(%d+):(%d+):(%d+):(%d+):%-?%d+:%-?%d+");
		if (jewelId1) then
			addGemColors(tonumber(jewelId1), playerbonuses);
			addGemColors(tonumber(jewelId2), playerbonuses);
			addGemColors(tonumber(jewelId3), playerbonuses);
			addGemColors(tonumber(jewelId4), playerbonuses);
		end
	end
	for k, v in pairs(eqvalid) do
		local jewelId1, jewelId2, jewelId3, jewelId4 = strmatch(v, "item:%d+:%d+:(%d+):(%d+):(%d+):(%d+):%-?%d+:%-?%d+");
		if (jewelId1) then
			addGemColors(tonumber(jewelId1), bonuses);
			addGemColors(tonumber(jewelId2), bonuses);
			addGemColors(tonumber(jewelId3), bonuses);
			addGemColors(tonumber(jewelId4), bonuses);
		end
	end

	textleft, textright = printBonuses(playerbonuses, bonuses, playerlevel, level, textleft, textright);
	textleft2, textright2 = printBonuses2(playerbonuses, bonuses, playerlevel, level, textleft2, textright2);

	-- Print the sets worn details
	local found = 0;
	for k, v in pairs(set) do
		found = found + 1;
		if (found == 1) then
			textleft = textleft.."|cFFFFFFFF"..L["Sets"].."|r\n";
			textright = textright.."\n";
		end
		textleft = textleft.."  "..k.." |cFF00FF00("..v.."/"..setsizes[k]..")|r\n";
		--textright = textright..v.."\n";
		set[k] = nil;
	end

	if notincache then
		textleft2 = textleft2.."\n"..L["WOW_EQUIP_NOT_IN_CACHE"].."\n"
	end

	WoWEquip_BonusText:SetText(textleft.."\n");
	WoWEquip_BonusTextR:SetText(textright);
	WoWEquip_BonusText2:SetText(textleft2);
	WoWEquip_BonusTextR2:SetText(textright2);
	WoWEquip_BonusScrollFrame:UpdateScrollChildRect();
end


---------------------------------------------
-- The Level input box and OnFoo() functions

-- Create the Level Input Box and position it below the text
WoWEquip_LevelInputBox = CreateFrame("EditBox", nil, WoWEquip_BonusFrame);
WoWEquip_LevelInputBox:SetWidth(20);
WoWEquip_LevelInputBox:SetHeight(16);
WoWEquip_LevelInputBox:SetMaxLetters(2);
WoWEquip_LevelInputBox:SetNumeric(true);
WoWEquip_LevelInputBox:SetAutoFocus(false);
WoWEquip_LevelInputBox:SetFontObject("GameFontHighlightSmall");
temp = WoWEquip_LevelInputBox:CreateTexture(nil, "BACKGROUND");
temp:SetTexture("Interface\\Common\\Common-Input-Border");
temp:SetWidth(8);
temp:SetHeight(16);
temp:SetPoint("TOPLEFT", -5, 0);
temp:SetTexCoord(0, 0.0625, 0, 0.625);
temp2 = WoWEquip_LevelInputBox:CreateTexture(nil, "BACKGROUND");
temp2:SetTexture("Interface\\Common\\Common-Input-Border");
temp2:SetWidth(8);
temp2:SetHeight(16);
temp2:SetPoint("RIGHT");
temp2:SetTexCoord(0.9375, 1, 0, 0.625);
temp3 = WoWEquip_LevelInputBox:CreateTexture(nil, "BACKGROUND");
temp3:SetTexture("Interface\\Common\\Common-Input-Border");
temp3:SetWidth(10);
temp3:SetHeight(16);
temp3:SetPoint("LEFT", temp, "RIGHT");
temp3:SetPoint("RIGHT", temp2, "LEFT");
temp3:SetTexCoord(0.0625, 0.9375, 0, 0.625);
WoWEquip_LevelInputBox:SetPoint("TOPRIGHT", -4, -4);


------------------------------------------
-- Create the Toggle Rating <--> %  button
WoWEquip_ToggleRatingButton = CreateFrame("Button", nil, WoWEquip_BonusFrame, "OptionsButtonTemplate");
WoWEquip_ToggleRatingButton:SetWidth(16);
WoWEquip_ToggleRatingButton:SetHeight(16);
WoWEquip_ToggleRatingButton:SetPoint("TOPLEFT", 5, -5);
WoWEquip_ToggleRatingButton:SetText("%");

function WoWEquip_ToggleRatingButton:OnClick()
	WoWEquip_Save.showrating = not WoWEquip_Save.showrating;
	WoWEquip:UpdateBonusFrame();
end

WoWEquip_ToggleRatingButton:SetScript("OnClick", WoWEquip_ToggleRatingButton.OnClick);


--------------------------------------------------------------------------------
-- Create and position the Search Text string below the Item Bonus Summary frame
WoWEquip_LevelText = WoWEquip_BonusFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_LevelText:SetPoint("RIGHT", WoWEquip_LevelInputBox, "LEFT", -7, 1);
WoWEquip_LevelText:SetText(L["Lvl:"]);

function WoWEquip_LevelInputBox:OnEditFocusLost()
	temp = tonumber(self:GetText()) or 0;
	if (temp < 1) then
		self:SetText(1);
	elseif (temp > 70) then
		self:SetText(70);
	end
	self:HighlightText(0, 0);
	WoWEquip:UpdateBonusFrame();
end

WoWEquip_LevelInputBox:SetScript("OnEditFocusGained", WoWEquip_LevelInputBox.HighlightText);
WoWEquip_LevelInputBox:SetScript("OnEnterPressed", WoWEquip_LevelInputBox.ClearFocus);
WoWEquip_LevelInputBox:SetScript("OnEscapePressed", WoWEquip_LevelInputBox.ClearFocus);
WoWEquip_LevelInputBox:SetScript("OnEditFocusLost", WoWEquip_LevelInputBox.OnEditFocusLost);

--------------------------------------
-- The Item Bonus Summary frame title
WoWEquip_BonusFrame.title = WoWEquip_BonusFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal");
temp = WoWEquip_BonusFrame.title;
temp:SetTextColor(1.0, 1.0, 0.1);
temp:SetText(L["Item Bonus Summary"]);
temp:SetPoint("TOPLEFT", (WoWEquip_BonusFrame:GetWidth() - WoWEquip_LevelText:GetWidth() - WoWEquip_LevelInputBox:GetWidth() - WoWEquip_ToggleRatingButton:GetWidth() - temp:GetWidth()) / 2 + WoWEquip_ToggleRatingButton:GetWidth(), -6);

---------------------------------------------
-- The Equip dialog box and OnFoo() functions

-- Create the main Save/Load frame
WoWEquip_EquipFrame = CreateFrame("Frame", "WoWEquip_EquipFrame", WoWEquip_Frame);
WoWEquip_EquipFrame:Hide();
WoWEquip_EquipFrame:SetWidth(260);
WoWEquip_EquipFrame:SetHeight(345+70);
WoWEquip_EquipFrame:SetPoint("BOTTOM", 0, 90);
WoWEquip_EquipFrame:SetBackdrop(WOWEQUIP_MAIN_BACKDROP);
WoWEquip_EquipFrame:SetBackdropColor(0, 0, 0, 0.75);
WoWEquip_EquipFrame:EnableMouse(true);
WoWEquip_EquipFrame:SetToplevel(true);
WoWEquip_EquipFrame:SetClampedToScreen(true);
WoWEquip_EquipFrame:SetMovable(true);
temp = WoWEquip_EquipFrame:CreateTexture(nil, "ARTWORK");
temp:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header");
temp:SetWidth(300);
temp:SetHeight(64);
temp:SetPoint("TOP", 0, 12);
WoWEquip_EquipFrame.titleTexture = temp;
WoWEquip_EquipFrame_TitleText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal");
WoWEquip_EquipFrame_TitleText:SetPoint("TOP", 0, -3);
WoWEquip_EquipFrame_TitleText:SetText(L["Search Equipment"]);

-- This creates a transparent textureless draggable frame to move WoWEquip_EquipFrame
-- It overlaps the above title text and texture (more or less) exactly.
temp = CreateFrame("Frame", nil, WoWEquip_EquipFrame);
temp:SetWidth(150);
temp:SetHeight(30);
temp:SetPoint("TOP", 0, 8);
temp:EnableMouse(true);
temp:RegisterForDrag("LeftButton");
temp:SetScript("OnDragStart", WoWEquip_Generic_StartMoving);
temp:SetScript("OnDragStop", WoWEquip_Generic_StopMovingOrSizing);

-- Create the Close button
WoWEquip_EquipFrame_CloseButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "UIPanelCloseButton");
WoWEquip_EquipFrame_CloseButton:SetPoint("TOPRIGHT", WoWEquip_EquipFrame, "TOPRIGHT", -2, -1);
WoWEquip_EquipFrame_CloseButton:SetHitRectInsets(5, 5, 5, 5);
WoWEquip_EquipFrame_CloseButton:SetScript("OnClick", WoWEquip_Generic_Hide);


---------------------------------------------
-- The Search input box and OnFoo() functions

-- Create and position the Search Text string below the Item Bonus Summary frame
WoWEquip_SlotSearchText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_SlotSearchText:SetPoint("TOPLEFT", 25, -28);
WoWEquip_SlotSearchText:SetFormattedText(L["Selected Slot: %s (%d)"], "-", 0);

-- Create the Search Input Box and position it below the text
WoWEquip_InputBox = CreateFrame("EditBox", nil, WoWEquip_EquipFrame);
WoWEquip_InputBox:SetWidth(WOWEQUIP_DISP_WIDTH - 15);
WoWEquip_InputBox:SetHeight(16);
WoWEquip_InputBox:SetMaxLetters(100);
WoWEquip_InputBox:SetNumeric(false);
WoWEquip_InputBox:SetAutoFocus(false);
WoWEquip_InputBox:SetFontObject("GameFontHighlightSmall");
WoWEquip_InputBox.text = WoWEquip_InputBox:GetText();
WoWEquip_InputBox.len = #WoWEquip_InputBox:GetText();
WoWEquip_InputBox.time = GetTime();
temp = WoWEquip_InputBox:CreateTexture(nil, "BACKGROUND");
temp:SetTexture("Interface\\Common\\Common-Input-Border");
temp:SetWidth(8);
temp:SetHeight(16);
temp:SetPoint("TOPLEFT", -5, 0);
temp:SetTexCoord(0, 0.0625, 0, 0.625);
temp2 = WoWEquip_InputBox:CreateTexture(nil, "BACKGROUND");
temp2:SetTexture("Interface\\Common\\Common-Input-Border");
temp2:SetWidth(8);
temp2:SetHeight(16);
temp2:SetPoint("RIGHT");
temp2:SetTexCoord(0.9375, 1, 0, 0.625);
temp3 = WoWEquip_InputBox:CreateTexture(nil, "BACKGROUND");
temp3:SetTexture("Interface\\Common\\Common-Input-Border");
temp3:SetWidth(10);
temp3:SetHeight(16);
temp3:SetPoint("LEFT", temp, "RIGHT");
temp3:SetPoint("RIGHT", temp2, "LEFT");
temp3:SetTexCoord(0.0625, 0.9375, 0, 0.625);
WoWEquip_InputBox:SetPoint("TOPLEFT", WoWEquip_SlotSearchText, "BOTTOMLEFT", 2, -2);

function WoWEquip_InputBox:OnUpdate()
	if (GetTime() - self.time >= 0.5) then
		self:SetScript("OnUpdate", nil);
		WoWEquip:GenerateDispList(1);
		self.text = self:GetText();
		self.len = #self:GetText();
		self.time = GetTime();
	end
end

function WoWEquip_InputBox:OnEnterEscPressed()
	self:ClearFocus();
	self:HighlightText(0, 0);
end

function WoWEquip_InputBox:OnEditFocusGained()
	self:HighlightText();
	self.text = self:GetText();
	self.len = #self:GetText();
end

function WoWEquip_InputBox:OnTextChanged()
	if (#self:GetText() == self.len + 1) then
		if (strfind(self:GetText(), self.text, 1, true)) then
			WoWEquip:GenerateDispList(2);
			self.text = self:GetText();
			self.len = #self:GetText();
		end
	else
		self:SetScript("OnUpdate", WoWEquip_InputBox.OnUpdate);
	end
	self.time = GetTime();
end

WoWEquip_InputBox:SetScript("OnEnterPressed", WoWEquip_InputBox.OnEnterEscPressed);
WoWEquip_InputBox:SetScript("OnEscapePressed", WoWEquip_InputBox.OnEnterEscPressed);
WoWEquip_InputBox:SetScript("OnEditFocusGained", WoWEquip_InputBox.OnEditFocusGained);
WoWEquip_InputBox:SetScript("OnTextChanged", WoWEquip_InputBox.OnTextChanged);


------------------------------------------------------
-- The Filter button, its menus, and OnFoo() functions

-- Create the Filter button
WoWEquip_FilterButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "OptionsButtonTemplate");
WoWEquip_FilterButton:SetWidth(16);
WoWEquip_FilterButton:SetHeight(16);
WoWEquip_FilterButton:SetPoint("LEFT", WoWEquip_InputBox, "RIGHT", 0, 0);
WoWEquip_FilterButton:SetText(L["WOW_EQUIP_FILTER_LETTER"]);
WoWEquip_FilterButton:Disable();

local function WoWEquip_SetFilterOptions(value)
	if (WoWEquip_Save.filterOptions[value]) then
		WoWEquip_Save.filterOptions[value] = nil;
	else
		WoWEquip_Save.filterOptions[value] = true;
	end
	WoWEquip_InputBox:SetScript("OnUpdate", WoWEquip_InputBox.OnUpdate);
	WoWEquip_InputBox.time = GetTime();
end

local function WoWEquip_SetFilterOptionsSelectAll(select)
	local this = _G["this"];	-- Yes yes, shameful to use this (pun intended)
	temp = this:GetParent():GetName().."Button";
	temp2 = 2;
	for k, v in pairs(WOWEQUIP_FILTERTABLE[WOWEQUIP_FILTEROPTIONS[selectedSlotNum]["misctable"]]) do
		WoWEquip_Save.filterOptions[v] = select;
		if (select) then
			_G[temp..temp2.."Check"]:Show();
		else
			_G[temp..temp2.."Check"]:Hide();
		end
		_G[temp..temp2].checked = select;
		temp2 = temp2 + 1;
	end
	-- For the Miscellaneous button
	WoWEquip_Save.filterOptions[WOWEQUIP_FILTEROPTIONS[selectedSlotNum]["misctable"]] = select;
	if (select) then
		_G[temp..temp2.."Check"]:Show();
	else
		_G[temp..temp2.."Check"]:Hide();
	end
	_G[temp..temp2].checked = select;
	WoWEquip_InputBox:SetScript("OnUpdate", WoWEquip_InputBox.OnUpdate);
	WoWEquip_InputBox.time = GetTime();
	this.checked = true;	-- Hack to uncheck this option
end

local function WoWEquip_GenerateFilterMenu(level)
	if (not level) then
		return;
	end

	if (level == 1) then
		-- Create the title of the menu
		cleartable(info);
		info.isTitle		= 1;
		info.text		= L["Filter Options"];
		info.notCheckable	= 1;
		UIDropDownMenu_AddButton(info, level);

		info.notCheckable	= nil;
		info.disabled		= nil;
		info.isTitle		= nil;
		info.keepShownOnClick	= 1;

		for k, v in ipairs(WOWEQUIP_FILTEROPTIONS[selectedSlotNum]) do
			if (v.t) then
				info.text		= v.t
				info.value		= v.id;
				info.arg1		= v.id;
				info.func     	 	= WoWEquip_SetFilterOptions;
				info.checked		= WoWEquip_Save.filterOptions[v.id];
				UIDropDownMenu_AddButton(info, level);
			end
		end

		info.checked		= nil;
		info.notCheckable	= 1;

		-- Select All menu item
		info.text		= L["Select All"];
		info.arg1		= true;
		info.func		= WoWEquip_SetFilterOptionsSelectAll;
		UIDropDownMenu_AddButton(info, level);

		-- Unselect All menu item
		info.text		= L["Unselect All"];
		info.arg1		= nil;
		info.func		= WoWEquip_SetFilterOptionsSelectAll;
		UIDropDownMenu_AddButton(info, level);

		-- Close menu item
		info.keepShownOnClick	= nil;
		info.text		= CLOSE;
		info.func		= CloseDropDownMenus;
		UIDropDownMenu_AddButton(info, level);
	end
end

function WoWEquip_FilterButton:OnClick()
	WoWEquip_GenericDropDownMenu:SetParent(self);
	WoWEquip_GenericDropDownMenu.initialize = WoWEquip_GenerateFilterMenu;
	ToggleDropDownMenu(1, nil, WoWEquip_GenericDropDownMenu, self, 0, 0);
end
WoWEquip_FilterButton:SetScript("OnClick", WoWEquip_FilterButton.OnClick);


----------------------------------------------------
-- The Sort button, its menus, and OnFoo() functions

-- Create the Sort button
WoWEquip_SortButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "OptionsButtonTemplate");
WoWEquip_SortButton:SetWidth(16);
WoWEquip_SortButton:SetHeight(16);
WoWEquip_SortButton:SetPoint("LEFT", WoWEquip_FilterButton, "RIGHT", 0, 0);
WoWEquip_SortButton:SetText(L["WOW_EQUIP_SORT_LETTER"]);

local function WoWEquip_SortDispList(a, b)
	local sortBy = WOWEQUIP_SORTTABLE[WoWEquip_Save.sortOptions];
	sortA[3], _, sortA[1], sortA[2] = GetItemInfo(a);
	sortB[3], _, sortB[1], sortB[2] = GetItemInfo(b);

	-- Negate the itemRarity and itemLevel values so that a "better" item is a "smaller" integer.
	sortA[1], sortA[2] = -sortA[1], -sortA[2];
	sortB[1], sortB[2] = -sortB[1], -sortB[2];

	if (sortA[sortBy[1]] ~= sortB[sortBy[1]]) then
		return sortA[sortBy[1]] < sortB[sortBy[1]];
	elseif (sortA[sortBy[2]] ~= sortB[sortBy[2]]) then
		return sortA[sortBy[2]] < sortB[sortBy[2]];
	else
		return sortA[sortBy[3]] < sortB[sortBy[3]];
	end
end

local function WoWEquip_SetSortOptions(value)
	WoWEquip_Save.sortOptions = value;
	tsort(WoWEquip_DispResults, WoWEquip_SortDispList);
	WoWEquip:ListUpdate();
end

local function WoWEquip_GenerateSortMenu(level)
	WoWEquip_GenerateGenericMenu(level, WoWEquip_SortOptions, WoWEquip_SetSortOptions, WoWEquip_Save.sortOptions, L["Sort Options"]);
end

function WoWEquip_SortButton:OnClick()
	WoWEquip_GenericDropDownMenu:SetParent(self);
	WoWEquip_GenericDropDownMenu.initialize = WoWEquip_GenerateSortMenu;
	ToggleDropDownMenu(1, nil, WoWEquip_GenericDropDownMenu, self, 0, 0);
end
WoWEquip_SortButton:SetScript("OnClick", WoWEquip_SortButton.OnClick);


-------------------------------------------------
-- The Search Results frame and OnFoo() functions

-- Create the Search Result frame
WoWEquip_SearchResultFrame = CreateFrame("Frame", nil, WoWEquip_EquipFrame);
WoWEquip_SearchResultFrame:SetBackdrop(WOWEQUIP_BOX_BACKDROP);
WoWEquip_SearchResultFrame:SetWidth(WOWEQUIP_DISP_WIDTH + 26);
WoWEquip_SearchResultFrame:SetHeight(WOWEQUIP_DISP_HEIGHT * WOWEQUIP_ITEMS_SHOWN + 10);
WoWEquip_SearchResultFrame:SetPoint("TOPLEFT", WoWEquip_InputBox, "BOTTOMLEFT", -7, 1);

-- Create the Search Results scrollframe
WoWEquip_ListScrollFrame = CreateFrame("ScrollFrame", "WoWEquip_ListScrollFrame", WoWEquip_SearchResultFrame, "FauxScrollFrameTemplate");
WoWEquip_ListScrollFrame:SetPoint("TOPLEFT", 2, -5);
WoWEquip_ListScrollFrame:SetWidth(WOWEQUIP_DISP_WIDTH - 3);
WoWEquip_ListScrollFrame:SetHeight(WOWEQUIP_DISP_HEIGHT * WOWEQUIP_ITEMS_SHOWN);
FauxScrollFrame_Update(WoWEquip_ListScrollFrame, 0, WOWEQUIP_ITEMS_SHOWN, WOWEQUIP_DISP_HEIGHT);

local function WoWEquip_ListScrollFrame_Update()
	local itemIndex;
	local itemID, itemName, itemLink, itemRarity;
	local button;

	FauxScrollFrame_Update(WoWEquip_ListScrollFrame, #WoWEquip_DispResults, WOWEQUIP_ITEMS_SHOWN, WOWEQUIP_DISP_HEIGHT);
	for i = 1, WOWEQUIP_ITEMS_SHOWN do
		itemIndex = i + FauxScrollFrame_GetOffset(WoWEquip_ListScrollFrame);
		button = WoWEquip_ItemButtonAr[i];
		
		if (itemIndex <= #WoWEquip_DispResults) then
			itemID = WoWEquip_DispResults[itemIndex];
			itemName, itemLink, itemRarity = GetItemInfo(itemID);

			if (itemName) then
				button:SetText(itemName);
				button:SetTextColor(ITEM_QUALITY_COLORS[itemRarity].r, ITEM_QUALITY_COLORS[itemRarity].g, ITEM_QUALITY_COLORS[itemRarity].b);
			end
			button:SetID(itemID);

			if (itemID == selectedItemID) then
				button:LockHighlight();
				button.highlight:Show();
			else
				button:UnlockHighlight();
				button.highlight:Hide();
			end
			button:Show();
		else
			button:Hide();
		end
	end

	if (#WoWEquip_DispResults > WOWEQUIP_ITEMS_SHOWN) then
		-- Reduce width
		for i = 1, WOWEQUIP_ITEMS_SHOWN do
			WoWEquip_ItemButtonAr[i]:SetWidth(WOWEQUIP_DISP_WIDTH);
			WoWEquip_ItemButtonAr[i].string:SetWidth(WOWEQUIP_DISP_WIDTH);
		end
	else
		-- Increase width
		for i = 1, WOWEQUIP_ITEMS_SHOWN do
			WoWEquip_ItemButtonAr[i]:SetWidth(WOWEQUIP_DISP_WIDTH + 16);
			WoWEquip_ItemButtonAr[i].string:SetWidth(WOWEQUIP_DISP_WIDTH + 16);
		end
	end
end

WoWEquip_ListScrollFrame:SetScript("OnVerticalScroll", function(self)
	FauxScrollFrame_OnVerticalScroll(WOWEQUIP_DISP_HEIGHT, WoWEquip_ListScrollFrame_Update);
end);

local function WoWEquip_ItemButton_OnClick(self, button)
	if (button == "LeftButton" and IsShiftKeyDown() and ChatFrameEditBox:IsVisible()) then
		local _, itemLink = GetItemInfo(self:GetID());
		ChatFrameEditBox:Insert(itemLink);
	elseif (button == "LeftButton") then
		-- Set current button/item as selected
		selectedItemID = self:GetID();
		WoWEquip:ListUpdate();
		WoWEquip_EquipButton:Enable();
	end
end

local function WoWEquip_ItemButton_OnEnter(self)
	local itemName, itemLink = GetItemInfo(self:GetID());
	if (itemLink) then
		if ( self:GetRight() >= ( GetScreenWidth() * 3 / 4 ) ) then
			GameTooltip:SetOwner(self, "ANCHOR_LEFT");
		else
			GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		end
		GameTooltip:SetHyperlink(itemLink);
	end
end

-- Create the Search Result item buttons and position them. All the buttons are stored in WoWEquip_ItemButtonAr[]
for v = 1, WOWEQUIP_ITEMS_SHOWN do
	temp = CreateFrame("Button", nil, WoWEquip_SearchResultFrame);
	temp:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	temp:SetScript("OnClick", WoWEquip_ItemButton_OnClick);
	temp:SetScript("OnEnter", WoWEquip_ItemButton_OnEnter);
	temp:SetScript("OnLeave", WoWEquip_Generic_OnLeave);
	temp:SetWidth(WOWEQUIP_DISP_WIDTH);
	temp:SetHeight(WOWEQUIP_DISP_HEIGHT);
	temp:Hide();
	RaiseFrameLevel(temp);
	temp.string = temp:CreateFontString();
	temp.string:SetWidth(WOWEQUIP_DISP_WIDTH);
	temp.string:SetHeight(10);
	temp.string:SetJustifyH("LEFT");
	temp:SetFontString(temp.string);
	temp:SetTextFontObject("GameFontNormalSmall");
	temp:SetHighlightFontObject("GameFontHighlightSmall");
	temp:SetDisabledFontObject("GameFontDisableSmall");
	temp.highlight = temp:CreateTexture(nil, "ARTWORK");
	temp.highlight:SetTexture("Interface\\Buttons\\UI-Listbox-Highlight2");
	temp.highlight:SetVertexColor(1.0, 0.82, 0);
	temp.highlight:SetAllPoints();
	if (v == 1) then
		temp:SetPoint("TOPLEFT", 5, -5);
	else
		temp:SetPoint("TOPLEFT", WoWEquip_ItemButtonAr[v-1], "BOTTOMLEFT", 0, 0);
	end
	WoWEquip_ItemButtonAr[v] = temp;
end


-----------------------------------------
-- The Equip/Cancel button and OnFoo() functions

-- Create the Equip button
WoWEquip_EquipButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "OptionsButtonTemplate");
WoWEquip_EquipButton:SetWidth(110);
WoWEquip_EquipButton:SetHeight(22);
WoWEquip_EquipButton:SetPoint("TOPRIGHT", WoWEquip_SearchResultFrame, "BOTTOMRIGHT", 0, 0);
WoWEquip_EquipButton:SetText(L["Equip"]);
WoWEquip_EquipButton:Disable();

function WoWEquip_EquipButton:OnClick()
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(selectedItemID);
	local v = WoWEquip_InputBox.pointer;
	if (WoWEquip_Save.PreserveEnchant and eq[v.slotname]) then
		local oldEnchantID = strmatch(eq[v.slotname], "item:%d+:(%d+):");
		itemLink = gsub(itemLink, "(item:%d+):(%d+):", "%1:"..oldEnchantID..":");
	end
	eq[v.slotname] = itemLink;
	SetItemButtonTexture(v, itemTexture);
	local r, g, b = GetItemQualityColor(itemRarity);
	v.border:SetVertexColor(r, g, b, 1);
	v.border:Show();
	WoWEquip:UpdateBonusFrame();
	if (v.slotname == "Back" and WoWEquip_ShowCloakCheckbox:GetChecked()) or
	   (v.slotname == "Head" and WoWEquip_ShowHelmCheckbox:GetChecked()) or
	   (v.slotname ~= "Back" and v.slotname ~= "Head") then
		DressUpModel:TryOn(itemLink);
	end
	WoWEquip_InputBox:ClearFocus();
	WoWEquip_InputBox:HighlightText(0, 0);
	CloseDropDownMenus();
end
WoWEquip_EquipButton:SetScript("OnClick", WoWEquip_EquipButton.OnClick);

-- Create the Close button (Yes, I named it CancelButton)
WoWEquip_EquipFrame_CancelButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "OptionsButtonTemplate");
WoWEquip_EquipFrame_CancelButton:SetWidth(110);
WoWEquip_EquipFrame_CancelButton:SetHeight(22);
WoWEquip_EquipFrame_CancelButton:SetPoint("RIGHT", WoWEquip_EquipButton, "LEFT", 0, 0);
WoWEquip_EquipFrame_CancelButton:SetText(CLOSE);
WoWEquip_EquipFrame_CancelButton:SetScript("OnClick", WoWEquip_Generic_Hide);

-- Create and position the info string
WoWEquip_SearchInfoText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_SearchInfoText:SetWidth(210);
WoWEquip_SearchInfoText:SetPoint("TOP", WoWEquip_SearchResultFrame, "BOTTOM", 0, -22);
temp, temp2, temp3 = WoWEquip_SearchInfoText:GetFont();
WoWEquip_SearchInfoText:SetFont(temp, 8, temp3);
WoWEquip_SearchInfoText:SetJustifyV("MIDDLE");
WoWEquip_SearchInfoText:SetJustifyH("CENTER");
WoWEquip_SearchInfoText:SetText(L["WOW_EQUIP_SEARCH_INFO"]);


--------------------------------------------------------------------------
-- Extra code and stuff to query the server for an itemID every 10 seconds
-- Needs localizing soon

-- Create and position the Query text string.
WoWEquip_QueryText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal");
WoWEquip_QueryText:SetPoint("TOPLEFT", WoWEquip_SearchInfoText, "BOTTOMLEFT", 0, -7);
WoWEquip_QueryText:SetText(L["Query server for itemlinks:"]);

-- Create and position the Query text string.
WoWEquip_FromText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_FromText:SetPoint("TOPLEFT", WoWEquip_QueryText, "BOTTOMLEFT", 0, -3);
WoWEquip_FromText:SetText(L["From itemID"]);

-- Create the From Input Box and position it below the text
WoWEquip_QueryInputBox1 = CreateFrame("EditBox", nil, WoWEquip_EquipFrame);
WoWEquip_QueryInputBox1:SetWidth(45);
WoWEquip_QueryInputBox1:SetHeight(16);
WoWEquip_QueryInputBox1:SetMaxLetters(5);
WoWEquip_QueryInputBox1:SetNumeric(true);
WoWEquip_QueryInputBox1:SetAutoFocus(false);
WoWEquip_QueryInputBox1:SetFontObject("GameFontHighlightSmall");
WoWEquip_QueryInputBox1:SetText(1);
temp = WoWEquip_QueryInputBox1:CreateTexture(nil, "BACKGROUND");
temp:SetTexture("Interface\\Common\\Common-Input-Border");
temp:SetWidth(8);
temp:SetHeight(16);
temp:SetPoint("TOPLEFT", -5, 0);
temp:SetTexCoord(0, 0.0625, 0, 0.625);
temp2 = WoWEquip_QueryInputBox1:CreateTexture(nil, "BACKGROUND");
temp2:SetTexture("Interface\\Common\\Common-Input-Border");
temp2:SetWidth(8);
temp2:SetHeight(16);
temp2:SetPoint("RIGHT");
temp2:SetTexCoord(0.9375, 1, 0, 0.625);
temp3 = WoWEquip_QueryInputBox1:CreateTexture(nil, "BACKGROUND");
temp3:SetTexture("Interface\\Common\\Common-Input-Border");
temp3:SetWidth(10);
temp3:SetHeight(16);
temp3:SetPoint("LEFT", temp, "RIGHT");
temp3:SetPoint("RIGHT", temp2, "LEFT");
temp3:SetTexCoord(0.0625, 0.9375, 0, 0.625);
WoWEquip_QueryInputBox1:SetPoint("LEFT", WoWEquip_FromText, "RIGHT", 7, 0);
WoWEquip_QueryInputBox1:SetScript("OnEscapePressed", WoWEquip_QueryInputBox1.ClearFocus);
WoWEquip_QueryInputBox1:SetScript("OnEnterPressed", WoWEquip_QueryInputBox1.ClearFocus);
WoWEquip_QueryInputBox1:SetScript("OnTabPressed", function() WoWEquip_QueryInputBox2:SetFocus(); end);
WoWEquip_QueryInputBox1:SetScript("OnEditFocusGained", WoWEquip_QueryInputBox1.HighlightText);

-- Create and position the Query text string.
WoWEquip_ToText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_ToText:SetPoint("LEFT", WoWEquip_QueryInputBox1, "RIGHT", 3, 0);
WoWEquip_ToText:SetText(L["to"]);

-- Create the To Input Box and position it below the text
WoWEquip_QueryInputBox2 = CreateFrame("EditBox", nil, WoWEquip_EquipFrame);
WoWEquip_QueryInputBox2:SetWidth(45);
WoWEquip_QueryInputBox2:SetHeight(16);
WoWEquip_QueryInputBox2:SetMaxLetters(5);
WoWEquip_QueryInputBox2:SetNumeric(true);
WoWEquip_QueryInputBox2:SetAutoFocus(false);
WoWEquip_QueryInputBox2:SetFontObject("GameFontHighlightSmall");
WoWEquip_QueryInputBox2:SetText(35000);
temp = WoWEquip_QueryInputBox2:CreateTexture(nil, "BACKGROUND");
temp:SetTexture("Interface\\Common\\Common-Input-Border");
temp:SetWidth(8);
temp:SetHeight(16);
temp:SetPoint("TOPLEFT", -5, 0);
temp:SetTexCoord(0, 0.0625, 0, 0.625);
temp2 = WoWEquip_QueryInputBox2:CreateTexture(nil, "BACKGROUND");
temp2:SetTexture("Interface\\Common\\Common-Input-Border");
temp2:SetWidth(8);
temp2:SetHeight(16);
temp2:SetPoint("RIGHT");
temp2:SetTexCoord(0.9375, 1, 0, 0.625);
temp3 = WoWEquip_QueryInputBox2:CreateTexture(nil, "BACKGROUND");
temp3:SetTexture("Interface\\Common\\Common-Input-Border");
temp3:SetWidth(10);
temp3:SetHeight(16);
temp3:SetPoint("LEFT", temp, "RIGHT");
temp3:SetPoint("RIGHT", temp2, "LEFT");
temp3:SetTexCoord(0.0625, 0.9375, 0, 0.625);
WoWEquip_QueryInputBox2:SetPoint("LEFT", WoWEquip_ToText, "RIGHT", 7, 0);
WoWEquip_QueryInputBox2:SetScript("OnEscapePressed", WoWEquip_QueryInputBox2.ClearFocus);
WoWEquip_QueryInputBox2:SetScript("OnEnterPressed", WoWEquip_QueryInputBox2.ClearFocus);
WoWEquip_QueryInputBox2:SetScript("OnTabPressed", function() WoWEquip_QueryInputBox1:SetFocus(); end);
WoWEquip_QueryInputBox2:SetScript("OnEditFocusGained", WoWEquip_QueryInputBox2.HighlightText);

-- Create and position the Currently Scanning text string.
WoWEquip_ScanningText = WoWEquip_EquipFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_ScanningText:SetPoint("TOPLEFT", WoWEquip_FromText, "BOTTOMLEFT", 0, -3);
WoWEquip_ScanningText:SetText(L["Last queried ID: "]);

local function WoWEquip_StopScanningLinks()
	if (WoWEquip_ScanLinksFrame) then
		WoWEquip_ScanLinksFrame:SetScript("OnUpdate", nil);
	end
	WoWEquip_StartScanButton:Enable();
	WoWEquip_StopScanButton:Disable();
end

local function WoWEquip_StartScanningLinks()
	local startID = tonumber(WoWEquip_QueryInputBox1:GetText()) or 1;
	local endID = tonumber(WoWEquip_QueryInputBox2:GetText()) or 35000;
	WoWEquip_QueryInputBox1:SetText(startID);
	WoWEquip_QueryInputBox2:SetText(endID);
	WoWEquip_QueryInputBox1:ClearFocus();
	WoWEquip_QueryInputBox2:ClearFocus();
	local lastScannedID = startID;
	local totalElapsed = 0;
	local direction;
	if (startID <= endID) then
		direction = 1;
	else
		direction = -1;
	end
	if (not WoWEquip_ScanLinksFrame) then
		WoWEquip_ScanLinksFrame = CreateFrame("Frame");
		WoWEquip_ScanLinksTooltip = CreateFrame("GameTooltip", nil, nil, "GameTooltipTemplate");
		WoWEquip_ScanLinksTooltip:SetOwner(WorldFrame, "ANCHOR_NONE");
	end
	WoWEquip_ScanLinksFrame:SetScript("OnUpdate", function(self, elapsed)
		-- Yes, this creates a function closure with upvalues
		totalElapsed = totalElapsed + elapsed;
		if totalElapsed < 10 then
			return;
		end

		totalElapsed = 0;
		local i = 0;
		while (i < 1) do
			if not GetItemInfo(lastScannedID) then
				WoWEquip_ScanLinksTooltip:SetHyperlink("item:"..lastScannedID);
				ChatFrame2:AddMessage("item:"..lastScannedID);
				i = i + 1;
			end
			lastScannedID = lastScannedID + direction;
			if (direction == 1 and lastScannedID > endID) or (direction == -1 and lastScannedID < startID) then
				WoWEquip_StopScanningLinks();
				WoWEquip_ScanningText:SetText(L["Last queried ID: "]..lastScannedID-direction);
				return;
			end
		end
		WoWEquip_ScanningText:SetText(L["Last queried ID: "]..lastScannedID-direction);
	end);
	WoWEquip_StartScanButton:Disable();
	WoWEquip_StopScanButton:Enable();
end

-- Create the Start and Stop Scanning buttons
WoWEquip_StartScanButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "OptionsButtonTemplate");
WoWEquip_StartScanButton:SetWidth(110);
WoWEquip_StartScanButton:SetHeight(20);
WoWEquip_StartScanButton:SetPoint("TOPLEFT", WoWEquip_ScanningText, "BOTTOMLEFT", 0, -3);
WoWEquip_StartScanButton:SetText(L["Start"]);
WoWEquip_StartScanButton:SetScript("OnClick", WoWEquip_StartScanningLinks);

WoWEquip_StopScanButton = CreateFrame("Button", nil, WoWEquip_EquipFrame, "OptionsButtonTemplate");
WoWEquip_StopScanButton:SetWidth(110);
WoWEquip_StopScanButton:SetHeight(20);
WoWEquip_StopScanButton:SetPoint("LEFT", WoWEquip_StartScanButton, "RIGHT", 0, 0);
WoWEquip_StopScanButton:SetText(L["Stop"]);
WoWEquip_StopScanButton:SetScript("OnClick", WoWEquip_StopScanningLinks);
WoWEquip_StopScanButton:Disable();


-----------------------------------------------
-- The Copy Target button and OnFoo() functions

-- Create the Copy Target button
WoWEquip_CopyTargetButton = CreateFrame("Button", nil, WoWEquip_Frame, "OptionsButtonTemplate");
WoWEquip_CopyTargetButton:SetWidth(82);
WoWEquip_CopyTargetButton:SetHeight(22);
WoWEquip_CopyTargetButton:SetPoint("BOTTOMRIGHT", WoWEquip_DoneButton, "TOPRIGHT", 0, 28);
WoWEquip_CopyTargetButton:SetText(L["Copy Target"]);

function WoWEquip_CopyTargetButton:OnUpdate()
	if (CanInspect("target")) then
		self:Enable();
	else
		self:Disable();
	end
end

function WoWEquip_CopyTargetButton:OnClick()
	if (CanInspect("target")) then
		for k, v in pairs(WoWEquip_PaperDollAr) do
			eq[v.slotname] = GetInventoryItemLink("target", v.slotnum);
			if (eq[v.slotname]) then
				_, _, temp2, _, _, _, _, _, _, temp = GetItemInfo(eq[v.slotname]);
				local r, g, b = GetItemQualityColor(temp2);
				v.border:SetVertexColor(r, g, b, 1);
				v.border:Show();
			else
				_, temp = GetInventorySlotInfo(v.slotname.."Slot");
				v.border:Hide();
			end
			SetItemButtonTexture(v, temp);
		end
		local realm;
		local _, race = UnitRace("target");
		local guildname, guildrank = GetGuildInfo("target");
		if (not guildname) then
			guildname = NONE;
		else
			guildname = "<"..guildname..">, "..guildrank;
		end
		local faction, class;
		if (race == "Orc" or race == "Scourge" or race == "Troll" or race == "Tauren" or race == "BloodElf") then
			faction = FACTION_HORDE;
		else
			faction = FACTION_ALLIANCE;
		end
		WoWEquip_LevelInputBox:SetText(UnitLevel("target"));
		class, currentProfileClass = UnitClass("target");
		currentProfileClass = WOWEQUIP_CLASSID[currentProfileClass];
		currentProfileChar, realm = UnitName("target");
		currentProfileName = class.."("..UnitLevel("target").."): "..currentProfileChar.." ("..L["Equipped Gear"]..")";
		if (not realm) then
			realm = GetRealmName():trim();
		else
			realm = strtrim(realm);
		end
		currentProfileDesc = format(L["WOW_EQUIP_DEFAULT_COPYDESC"], currentProfileChar, guildname, realm, faction, date("%m/%d/%y %H:%M:%S"));
		WoWEquip_ClassButton:SetText(WoWEquip_ClassOptions[currentProfileClass].t);
		currentProfileRace = WOWEQUIP_RACEID[race];
		WoWEquip_RaceButton:SetText(WoWEquip_RaceOptions[currentProfileRace].t2);
		cleartable(currentProfileTalents)
		if UnitIsUnit("target", "player") then
			-- Copy talents from player over
			for k, v in pairs(playerTalents) do
				currentProfileTalents[k] = v
			end
		else
			NotifyInspect("target") -- Detect talents on target player
			WoWEquip_Frame:RegisterEvent("INSPECT_TALENT_READY")
		end
		WoWEquip:UpdateBonusFrame();
		WoWEquip:UpdateDressUpModel();
		CloseDropDownMenus();
	end
end

WoWEquip_CopyTargetButton:SetScript("OnClick", WoWEquip_CopyTargetButton.OnClick);
WoWEquip_CopyTargetButton:SetScript("OnUpdate", WoWEquip_CopyTargetButton.OnUpdate);


-------------------------------------------------
-- The Save/Load dialog box and OnFoo() functions

-- Create the main Save/Load frame
WoWEquip_SaveFrame = CreateFrame("Frame", "WoWEquip_SaveFrame", WoWEquip_Frame);
WoWEquip_SaveFrame:Hide();
WoWEquip_SaveFrame:SetWidth(350);
WoWEquip_SaveFrame:SetHeight(300);
WoWEquip_SaveFrame:SetPoint("BOTTOM", 0, 90);
WoWEquip_SaveFrame:SetBackdrop(WOWEQUIP_MAIN_BACKDROP);
WoWEquip_SaveFrame:SetBackdropColor(0, 0, 0, 0.75);
WoWEquip_SaveFrame:EnableMouse(true);
WoWEquip_SaveFrame:SetToplevel(true);
WoWEquip_SaveFrame:SetClampedToScreen(true);
WoWEquip_SaveFrame:SetMovable(true);
temp = WoWEquip_SaveFrame:CreateTexture(nil, "ARTWORK");
temp:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header");
temp:SetWidth(300);
temp:SetHeight(64);
temp:SetPoint("TOP", 0, 12);
WoWEquip_SaveFrame.titleTexture = temp;
WoWEquip_SaveFrame_TitleText = WoWEquip_SaveFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal");
WoWEquip_SaveFrame_TitleText:SetPoint("TOP", 0, -3);

-- This creates a transparent textureless draggable frame to move WoWEquip_SaveFrame
-- It overlaps the above title text and texture (more or less) exactly.
temp = CreateFrame("Frame", nil, WoWEquip_SaveFrame);
temp:SetWidth(150);
temp:SetHeight(30);
temp:SetPoint("TOP", 0, 8);
temp:EnableMouse(true);
temp:RegisterForDrag("LeftButton");
temp:SetScript("OnDragStart", WoWEquip_Generic_StartMoving);
temp:SetScript("OnDragStop", WoWEquip_Generic_StopMovingOrSizing);

-- Create the Close button
WoWEquip_SaveFrame_CloseButton = CreateFrame("Button", nil, WoWEquip_SaveFrame, "UIPanelCloseButton");
WoWEquip_SaveFrame_CloseButton:SetPoint("TOPRIGHT", WoWEquip_SaveFrame, "TOPRIGHT", -2, -1);
WoWEquip_SaveFrame_CloseButton:SetHitRectInsets(5, 5, 5, 5);

local function WoWEquip_SaveFrame_Hide()
	WoWEquip_SaveFrame:Hide();
	StaticPopup_Hide("WOWEQUIP_CONFIRM_OVERWRITE");
	StaticPopup_Hide("WOWEQUIP_CONFIRM_DELETE");
end
WoWEquip_SaveFrame_CloseButton:SetScript("OnClick", WoWEquip_SaveFrame_Hide);


--------------------------------------------------------------------
-- The Name/Desc input box for the save dialog and OnFoo() functions

-- Create and position the Name text string
WoWEquip_SaveFrame_NameText = WoWEquip_SaveFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_SaveFrame_NameText:SetPoint("TOPLEFT", 25, -28);
WoWEquip_SaveFrame_NameText:SetText(L["Name:"]);

-- Create the Search Input Box and position it below the text
WoWEquip_SaveFrame_NameInputFrame = CreateFrame("Frame", nil, WoWEquip_SaveFrame);
WoWEquip_SaveFrame_NameInputFrame:SetWidth(300);
WoWEquip_SaveFrame_NameInputFrame:SetHeight(24);
WoWEquip_SaveFrame_NameInputFrame:SetBackdrop(WOWEQUIP_BOX_BACKDROP2);
WoWEquip_SaveFrame_NameInputFrame:SetPoint("TOPLEFT", WoWEquip_SaveFrame_NameText, "BOTTOMLEFT", 0, 0);
WoWEquip_SaveFrame_NameInputBox = CreateFrame("EditBox", nil, WoWEquip_SaveFrame_NameInputFrame);
WoWEquip_SaveFrame_NameInputBox:SetWidth(290);
WoWEquip_SaveFrame_NameInputBox:SetHeight(24);
WoWEquip_SaveFrame_NameInputBox:SetMaxLetters(100);
WoWEquip_SaveFrame_NameInputBox:SetNumeric(false);
WoWEquip_SaveFrame_NameInputBox:SetAutoFocus(false);
WoWEquip_SaveFrame_NameInputBox:SetFontObject("GameFontHighlightSmall");
WoWEquip_SaveFrame_NameInputBox:SetPoint("TOPLEFT", 5, 1);
WoWEquip_SaveFrame_NameInputBox:SetScript("OnShow", WoWEquip_SaveFrame_NameInputBox.SetFocus);
WoWEquip_SaveFrame_NameInputBox:SetScript("OnEscapePressed", WoWEquip_SaveFrame_NameInputBox.ClearFocus);

-- Create and position the Target text string. Positioning is the same as the Name string since these are displayed exclusively.
WoWEquip_SaveFrame_TargetText = WoWEquip_SaveFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_SaveFrame_TargetText:SetPoint("TOPLEFT", 25, -28);
WoWEquip_SaveFrame_TargetText:SetText(L["Send profile to:"]);

-- Create the Target Input Box and position it below the text
WoWEquip_SaveFrame_TargetInputFrame = CreateFrame("Frame", nil, WoWEquip_SaveFrame);
WoWEquip_SaveFrame_TargetInputFrame:SetWidth(300);
WoWEquip_SaveFrame_TargetInputFrame:SetHeight(24);
WoWEquip_SaveFrame_TargetInputFrame:SetBackdrop(WOWEQUIP_BOX_BACKDROP2);
WoWEquip_SaveFrame_TargetInputFrame:SetPoint("TOPLEFT", WoWEquip_SaveFrame_TargetText, "BOTTOMLEFT", 0, 0);
WoWEquip_SaveFrame_TargetInputBox = CreateFrame("EditBox", nil, WoWEquip_SaveFrame_TargetInputFrame);
WoWEquip_SaveFrame_TargetInputBox:SetWidth(290);
WoWEquip_SaveFrame_TargetInputBox:SetHeight(24);
WoWEquip_SaveFrame_TargetInputBox:SetMaxLetters(100);
WoWEquip_SaveFrame_TargetInputBox:SetNumeric(false);
WoWEquip_SaveFrame_TargetInputBox:SetAutoFocus(false);
WoWEquip_SaveFrame_TargetInputBox:SetFontObject("GameFontHighlightSmall");
WoWEquip_SaveFrame_TargetInputBox:SetPoint("TOPLEFT", 5, 1);
WoWEquip_SaveFrame_TargetInputBox:SetScript("OnShow", WoWEquip_SaveFrame_TargetInputBox.SetFocus);
WoWEquip_SaveFrame_TargetInputBox:SetScript("OnEscapePressed", WoWEquip_SaveFrame_TargetInputBox.ClearFocus);

-- Create and position the Description text string
WoWEquip_SaveFrame_DescText = WoWEquip_SaveFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_SaveFrame_DescText:SetPoint("TOPLEFT", WoWEquip_SaveFrame_NameInputFrame, "BOTTOMLEFT", 0, 0);
WoWEquip_SaveFrame_DescText:SetText(L["Description/Notes:"]);

-- Create the ScrollFrame for the Description Edit Box
WoWEquip_SaveFrame_DescFrame = CreateFrame("Frame", nil, WoWEquip_SaveFrame);
WoWEquip_SaveFrame_DescFrame:SetWidth(300);
WoWEquip_SaveFrame_DescFrame:SetHeight(60);
WoWEquip_SaveFrame_DescFrame:SetBackdrop(WOWEQUIP_BOX_BACKDROP2);
WoWEquip_SaveFrame_DescFrame:SetPoint("TOPLEFT", WoWEquip_SaveFrame_DescText, "BOTTOMLEFT", 0, 0);
WoWEquip_DescEditScrollFrame = CreateFrame("ScrollFrame", "WoWEquip_DescEditScrollFrame", WoWEquip_SaveFrame_DescFrame, "UIPanelScrollFrameTemplate");
WoWEquip_DescEditScrollFrame:SetWidth(269);
WoWEquip_DescEditScrollFrame:SetHeight(52);
WoWEquip_DescEditScrollFrame:SetPoint("TOPLEFT", 5, -4);
-- Create the Description Input Box and position it below the text
WoWEquip_SaveFrame_DescInputBox = CreateFrame("EditBox", nil, WoWEquip_SaveFrame);
WoWEquip_SaveFrame_DescInputBox:SetWidth(269);
WoWEquip_SaveFrame_DescInputBox:SetHeight(52);
WoWEquip_SaveFrame_DescInputBox:SetMaxLetters(512);
WoWEquip_SaveFrame_DescInputBox:SetNumeric(false);
WoWEquip_SaveFrame_DescInputBox:SetAutoFocus(false);
WoWEquip_SaveFrame_DescInputBox:SetFontObject("GameFontHighlightSmall");
WoWEquip_SaveFrame_DescInputBox:SetMultiLine(true);
-- Attach the ScrollChild to the ScrollFrame
WoWEquip_DescEditScrollFrame:SetScrollChild(WoWEquip_SaveFrame_DescInputBox);
WoWEquip_DescEditScrollFrame:UpdateScrollChildRect();

function WoWEquip_SaveFrame_DescInputBox:OnTextChanged()
	WoWEquip_DescEditScrollFrame:UpdateScrollChildRect();
end

function WoWEquip_SaveFrame_DescInputBox:OnCursorChanged(x, y, w, h)
	local scrollFrame = self:GetParent();
	local height = scrollFrame:GetHeight();
	local range = scrollFrame:GetVerticalScrollRange();
	local scroll = scrollFrame:GetVerticalScroll();
	local size = height + range;
	local cursorOffset = -y;
	while ( cursorOffset < scroll ) do
		scroll = (scroll - (height / 2));
		if ( scroll < 0 ) then
			scroll = 0;
		end
		scrollFrame:SetVerticalScroll(scroll);
	end
	while ( (cursorOffset + h) > (scroll + height) and scroll < range ) do
		scroll = (scroll + (height / 2));
		if ( scroll > range ) then
			scroll = range;
		end
		scrollFrame:SetVerticalScroll(scroll);
	end
end

WoWEquip_SaveFrame_DescInputBox:SetScript("OnTextChanged", WoWEquip_SaveFrame_DescInputBox.OnTextChanged);
WoWEquip_SaveFrame_DescInputBox:SetScript("OnCursorChanged", WoWEquip_SaveFrame_DescInputBox.OnCursorChanged);
WoWEquip_SaveFrame_DescInputBox:SetScript("OnEscapePressed", WoWEquip_SaveFrame_DescInputBox.ClearFocus);

-- Create and position the List of saved profiles text string
WoWEquip_SaveFrame_ProfilesText = WoWEquip_SaveFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
WoWEquip_SaveFrame_ProfilesText:SetPoint("TOPLEFT", WoWEquip_SaveFrame_DescFrame, "BOTTOMLEFT", 0, 0);
WoWEquip_SaveFrame_ProfilesText:SetText(L["List of saved profiles:"]);

-- Create the ScrollFrame for the Saved Profiles scrollframe
WoWEquip_SaveFrame_ProfilesFrame = CreateFrame("Frame", nil, WoWEquip_SaveFrame);
WoWEquip_SaveFrame_ProfilesFrame:SetWidth(300);
WoWEquip_SaveFrame_ProfilesFrame:SetHeight(WOWEQUIP_PROFILES_DISP_HEIGHT * WOWEQUIP_PROFILES_SHOWN + 10);
WoWEquip_SaveFrame_ProfilesFrame:SetBackdrop(WOWEQUIP_BOX_BACKDROP2);
WoWEquip_SaveFrame_ProfilesFrame:SetPoint("TOPLEFT", WoWEquip_SaveFrame_ProfilesText, "BOTTOMLEFT", 0, 0);

WoWEquip_ProfilesScrollFrame = CreateFrame("ScrollFrame", "WoWEquip_ProfilesScrollFrame", WoWEquip_SaveFrame_ProfilesFrame, "FauxScrollFrameTemplate");
WoWEquip_ProfilesScrollFrame:SetPoint("TOPLEFT", 2, -5);
WoWEquip_ProfilesScrollFrame:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH - 3);
WoWEquip_ProfilesScrollFrame:SetHeight(WOWEQUIP_PROFILES_DISP_HEIGHT * WOWEQUIP_PROFILES_SHOWN);
FauxScrollFrame_Update(WoWEquip_ProfilesScrollFrame, 0, WOWEQUIP_PROFILES_SHOWN, WOWEQUIP_PROFILES_DISP_HEIGHT);

local function WoWEquip_SortProfiles(a, b)
	return strlower(a.name) < strlower(b.name);
end

local function WoWEquip_GenerateProfilesList()
	local count = 0;
	for k, v in pairs(profiles) do
		profiles[k] = nil;
	end
	for k, v in pairs(WoWEquip_Save.profiles) do
		count = count + 1;
		profiles[count] = v;
	end
	tsort(profiles, WoWEquip_SortProfiles);
	
	-- Check if the Delete and Save/Load button should be enabled or disabled
	local name = WoWEquip_SaveFrame_NameInputBox:GetText();
	for k, v in ipairs(profiles) do
		if (v.name == name) then
			selectedProfileIndex = k;
			WoWEquip_SaveFrame_DeleteProfileButton:Enable();
			if (WoWEquip_SaveFrame.mode ~= "save") then
				if (WoWEquip_SaveFrame.mode == "send") then
					if (WoWEquip_SaveFrame_TargetInputBox:GetText():trim():len() > 0) then
						WoWEquip_SaveFrame_SaveButton:Enable();
					end
				else
					WoWEquip_SaveFrame_SaveButton:Enable();
				end
			end
			return;
		end
	end
	selectedProfileIndex = nil;
	WoWEquip_SaveFrame_DeleteProfileButton:Disable();
	if (WoWEquip_SaveFrame.mode ~= "save") then
		WoWEquip_SaveFrame_SaveButton:Disable();
	end
end

local function WoWEquip_ProfilesScrollFrame_Update()
	local profileIndex;
	local button;

	FauxScrollFrame_Update(WoWEquip_ProfilesScrollFrame, #profiles, WOWEQUIP_PROFILES_SHOWN, WOWEQUIP_PROFILES_DISP_HEIGHT);
	for i = 1, WOWEQUIP_PROFILES_SHOWN do
		profileIndex = i + FauxScrollFrame_GetOffset(WoWEquip_ProfilesScrollFrame);
		button = WoWEquip_ProfilesButtonAr[i];
		
		if (profileIndex <= #profiles) then
			button:SetText(profiles[profileIndex].name);
			button:SetID(profileIndex);

			if (profileIndex == selectedProfileIndex) then
				button:LockHighlight();
				button.highlight:Show();
			else
				button:UnlockHighlight();
				button.highlight:Hide();
			end
			button:Show();
		else
			button:Hide();
		end
	end

	if (#profiles > WOWEQUIP_PROFILES_SHOWN) then
		-- Reduce width
		for i = 1, WOWEQUIP_PROFILES_SHOWN do
			WoWEquip_ProfilesButtonAr[i]:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH);
			WoWEquip_ProfilesButtonAr[i].string:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH);
		end
	else
		-- Increase width
		for i = 1, WOWEQUIP_PROFILES_SHOWN do
			WoWEquip_ProfilesButtonAr[i]:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH + 16);
			WoWEquip_ProfilesButtonAr[i].string:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH + 16);
		end
	end
end

WoWEquip_ProfilesScrollFrame:SetScript("OnVerticalScroll", function(self)
	FauxScrollFrame_OnVerticalScroll(WOWEQUIP_PROFILES_DISP_HEIGHT, WoWEquip_ProfilesScrollFrame_Update);
end);

function WoWEquip_SaveFrame_NameInputBox:OnTextChanged()
	local oldvalue = selectedProfileIndex;
	for k, v in ipairs(profiles) do
		if (v.name == self:GetText()) then
			selectedProfileIndex = k;
			WoWEquip_SaveFrame_DeleteProfileButton:Enable();
			if (WoWEquip_SaveFrame.mode ~= "save") then
				if (WoWEquip_SaveFrame.mode == "send") then
					if (WoWEquip_SaveFrame_TargetInputBox:GetText():trim():len() > 0) then
						WoWEquip_SaveFrame_SaveButton:Enable();
					end
				else
					WoWEquip_SaveFrame_SaveButton:Enable();
				end
			end
			WoWEquip_ProfilesScrollFrame_Update();
			return;
		end
	end
	selectedProfileIndex = nil;
	WoWEquip_SaveFrame_DeleteProfileButton:Disable();
	if (WoWEquip_SaveFrame.mode ~= "save") then
		WoWEquip_SaveFrame_SaveButton:Disable();
	end
	if (oldvalue ~= selectedProfileIndex) then
		WoWEquip_ProfilesScrollFrame_Update();
	end
end
WoWEquip_SaveFrame_NameInputBox:SetScript("OnTextChanged", WoWEquip_SaveFrame_NameInputBox.OnTextChanged);

function WoWEquip_SaveFrame_TargetInputBox:OnTextChanged()
	if (selectedProfileIndex and self:GetText():trim():len() > 0) then
		WoWEquip_SaveFrame_SaveButton:Enable();
	else
		WoWEquip_SaveFrame_SaveButton:Disable();
	end
end
WoWEquip_SaveFrame_TargetInputBox:SetScript("OnTextChanged", WoWEquip_SaveFrame_TargetInputBox.OnTextChanged);

local function WoWEquip_ProfilesButton_OnClick(self, button)
	if (button == "LeftButton") then
		-- Set current button/profile as selected
		-- Note that this will trigger WoWEquip_SaveFrame_NameInputBox:OnTextChanged() to run...
		WoWEquip_SaveFrame_NameInputBox:SetText(profiles[self:GetID()].name);
		WoWEquip_SaveFrame_DescInputBox:SetText(profiles[self:GetID()].desc);
		-- ... unless it is hidden because the dialog is in load mode
		if (not WoWEquip_SaveFrame_NameInputBox:IsVisible()) then
			WoWEquip_SaveFrame_NameInputBox:OnTextChanged();
		end
	end
end

local function WoWEquip_ProfilesButton_OnEnter(self)
	local desc = profiles[self:GetID()].desc;
	if ( self:GetRight() >= ( GetScreenWidth() * 3 / 4 ) ) then
		GameTooltip:SetOwner(self, "ANCHOR_LEFT");
	else
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
	end
	if (desc and desc ~= "") then
		GameTooltip:SetText(L["Description/Notes:"]);
		GameTooltip:AddLine(desc, 1, 1, 1, 1);
	else
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(L["[No description]"]);
	end
	GameTooltip:Show();
end

-- Create the Profiles scrolllist buttons and position them. All the buttons are stored in WoWEquip_ProfilesButtonAr[]
for v = 1, WOWEQUIP_PROFILES_SHOWN do
	temp = CreateFrame("Button", nil, WoWEquip_SaveFrame_ProfilesFrame);
	temp:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	temp:SetScript("OnClick", WoWEquip_ProfilesButton_OnClick);
	temp:SetScript("OnEnter", WoWEquip_ProfilesButton_OnEnter);
	temp:SetScript("OnLeave", WoWEquip_Generic_OnLeave);
	temp:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH);
	temp:SetHeight(WOWEQUIP_PROFILES_DISP_HEIGHT);
	temp:Hide();
	RaiseFrameLevel(temp);
	temp.string = temp:CreateFontString();
	temp.string:SetWidth(WOWEQUIP_PROFILES_DISP_WIDTH);
	temp.string:SetHeight(10);
	temp.string:SetJustifyH("LEFT");
	temp:SetFontString(temp.string);
	temp:SetTextFontObject("GameFontNormalSmall");
	temp:SetHighlightFontObject("GameFontHighlightSmall");
	temp:SetDisabledFontObject("GameFontDisableSmall");
	temp.highlight = temp:CreateTexture(nil, "ARTWORK");
	temp.highlight:SetTexture("Interface\\Buttons\\UI-Listbox-Highlight2");
	temp.highlight:SetVertexColor(1.0, 0.82, 0);
	temp.highlight:SetAllPoints();
	if (v == 1) then
		temp:SetPoint("TOPLEFT", 5, -5);
	else
		temp:SetPoint("TOPLEFT", WoWEquip_ProfilesButtonAr[v-1], "BOTTOMLEFT", 0, 0);
	end
	WoWEquip_ProfilesButtonAr[v] = temp;
end


function WoWEquip:SaveProfile(name, desc)
	WoWEquip_Save.profiles[name] = WoWEquip_Save.profiles[name] or {};
	local saveTable = WoWEquip_Save.profiles[name];
	saveTable.name = name;						-- Save name
	saveTable.desc = desc;						-- Save description
	saveTable.class = currentProfileClass;				-- Save class
	saveTable.race = currentProfileRace;				-- Save race
	saveTable.level = tonumber(WoWEquip_LevelInputBox:GetText());	-- Save level
	saveTable.eq = saveTable.eq or {};
	for k, v in pairs(WoWEquip_PaperDollAr) do
		saveTable.eq[k] = eq[v.slotname];			-- Save equipment
	end
	saveTable.talents = saveTable.talents or {}
	cleartable(saveTable.talents)
	for k, v in pairs(currentProfileTalents) do			-- Save talents
		if v > 0 then						-- only if rank 1 or better
			saveTable.talents[k] = v
		end
	end
	currentProfileName = saveTable.name;				-- Load edited name
	currentProfileDesc = saveTable.desc;				-- Load edited description
	CloseDropDownMenus();
	if name == WoWEquip_Save.compareProfile then
		self:UpdateBonusFrame()
	end
	return 1;
end

function WoWEquip:LoadProfile(name)
	--local flag = false;
	local loadTable = WoWEquip_Save.profiles[name];
	if (not loadTable) then
		return;
	end
	currentProfileName = loadTable.name;			-- Load name
	currentProfileDesc = loadTable.desc;			-- Load description
	currentProfileClass = loadTable.class or 1;		-- Load class
	currentProfileRace = loadTable.race or 0;		-- Load race
	WoWEquip_LevelInputBox:SetText(loadTable.level);	-- Load level
	for k, v in pairs(WoWEquip_PaperDollAr) do
		eq[v.slotname] = loadTable.eq[k];		-- Load equipment
		if (eq[v.slotname]) then
			_, _, temp2, _, _, _, _, _, _, temp = GetItemInfo(eq[v.slotname]);
			temp = temp or "Interface\\Icons\\INV_Misc_QuestionMark";
			local r, g, b, h;
			if (temp2) then
				r, g, b = GetItemQualityColor(temp2);
			else
				for i = -1, 6 do
					r, g, b, h = GetItemQualityColor(i);
					if strfind(eq[v.slotname], h) then
						break;
					end
				end
			end
			v.border:SetVertexColor(r, g, b, 1);
			v.border:Show();
		else
			_, temp = GetInventorySlotInfo(v.slotname.."Slot");
			v.border:Hide();
		end
		SetItemButtonTexture(v, temp);
	end
	cleartable(currentProfileTalents)
	if loadTable.talents then
		for k, v in pairs(loadTable.talents) do			-- Load talents
			if WoWEquip_TalentData2[k] then			-- Only if this talent exists
				currentProfileTalents[k] = v
			end
		end
	end

	WoWEquip_ClassButton:SetText(WoWEquip_ClassOptions[currentProfileClass].t);
	WoWEquip_RaceButton:SetText(WoWEquip_RaceOptions[currentProfileRace].t2);
	self:UpdateBonusFrame();
	self:UpdateDressUpModel();
	CloseDropDownMenus();
	return 1;
end

function WoWEquip:DeleteProfile(name)
	if (not WoWEquip_Save.profiles[name]) then
		return;
	end
	WoWEquip_Save.profiles[name] = nil;	-- Delete entire profile
	return 1;
end

local function WoWEquip_PreSave()
	local name = strtrim(WoWEquip_SaveFrame_NameInputBox:GetText());
	local desc = strtrim(WoWEquip_SaveFrame_DescInputBox:GetText());
	if (WoWEquip_Save.profiles[name]) then
		StaticPopup_Hide("WOWEQUIP_CONFIRM_DELETE");
		StaticPopup_Show("WOWEQUIP_CONFIRM_OVERWRITE", strtrim(WoWEquip_SaveFrame_NameInputBox:GetText()));
	else
		WoWEquip:SaveProfile(name, desc);
		WoWEquip_SaveFrame:Hide();
	end
end

local function WoWEquip_PreSave2()
	local name = strtrim(WoWEquip_SaveFrame_NameInputBox:GetText());
	local desc = strtrim(WoWEquip_SaveFrame_DescInputBox:GetText());
	WoWEquip:SaveProfile(name, desc);
	WoWEquip_SaveFrame:Hide();
end

local function WoWEquip_PreLoad()
	local name = strtrim(WoWEquip_SaveFrame_NameInputBox:GetText());
	WoWEquip:LoadProfile(name);
	WoWEquip_SaveFrame:Hide();
end

local function WoWEquip_PreDelete()
	if (selectedProfileIndex and profiles[selectedProfileIndex]) then
		StaticPopup_Hide("WOWEQUIP_CONFIRM_OVERWRITE");
		StaticPopup_Show("WOWEQUIP_CONFIRM_DELETE", profiles[selectedProfileIndex].name);
	end
end

local function WoWEquip_PreDelete2()
	if (selectedProfileIndex and profiles[selectedProfileIndex]) then
		local name = profiles[selectedProfileIndex].name;
		WoWEquip:DeleteProfile(name);
		selectedProfileIndex = nil;
		WoWEquip_GenerateProfilesList();
		WoWEquip_ProfilesScrollFrame_Update();
		if (name == WoWEquip_Save.compareProfile) then
			WoWEquip_Save.compareOptions = 1;
			WoWEquip_CompareText:SetText(L["Comparing: "]..WoWEquip_CompareOptions[1].t);
			WoWEquip:UpdateBonusFrame();
		end
	end
end

-------------------------------------------------
-- StaticPopups for Deleting/Overwriting profiles

_G["StaticPopupDialogs"]["WOWEQUIP_CONFIRM_OVERWRITE"] = {
	text = L["Overwrite the following profile?\n%s"],
	button1 = YES,
	button2 = NO,
	OnAccept = WoWEquip_PreSave2,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

_G["StaticPopupDialogs"]["WOWEQUIP_CONFIRM_DELETE"] = {
	text = L["Delete the following profile?\n%s"],
	button1 = YES,
	button2 = NO,
	OnAccept = WoWEquip_PreDelete2,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};


-----------------------------------------------------------------------------
-- Last few buttons and dialog box functionality for the save/load dialog box

-- Create the Delete profile button
WoWEquip_SaveFrame_DeleteProfileButton = CreateFrame("Button", nil, WoWEquip_SaveFrame, "OptionsButtonTemplate");
WoWEquip_SaveFrame_DeleteProfileButton:SetWidth(100);
WoWEquip_SaveFrame_DeleteProfileButton:SetHeight(22);
WoWEquip_SaveFrame_DeleteProfileButton:SetPoint("TOPLEFT", WoWEquip_SaveFrame_ProfilesFrame, "BOTTOMLEFT", 0, 0);
WoWEquip_SaveFrame_DeleteProfileButton:SetText(L["Delete"]);
WoWEquip_SaveFrame_DeleteProfileButton:SetScript("OnClick", WoWEquip_PreDelete);

-- Create the Cancel button
WoWEquip_SaveFrame_CancelButton = CreateFrame("Button", nil, WoWEquip_SaveFrame, "OptionsButtonTemplate");
WoWEquip_SaveFrame_CancelButton:SetWidth(100);
WoWEquip_SaveFrame_CancelButton:SetHeight(22);
WoWEquip_SaveFrame_CancelButton:SetPoint("LEFT", WoWEquip_SaveFrame_DeleteProfileButton, "RIGHT", 0, 0);
WoWEquip_SaveFrame_CancelButton:SetText(CANCEL);
WoWEquip_SaveFrame_CancelButton:SetScript("OnClick", WoWEquip_SaveFrame_Hide);

-- Create the Save/Load button
WoWEquip_SaveFrame_SaveButton = CreateFrame("Button", nil, WoWEquip_SaveFrame, "OptionsButtonTemplate");
WoWEquip_SaveFrame_SaveButton:SetWidth(100);
WoWEquip_SaveFrame_SaveButton:SetHeight(22);
WoWEquip_SaveFrame_SaveButton:SetPoint("LEFT", WoWEquip_SaveFrame_CancelButton, "RIGHT", 0, 0);

local function WoWEquip_SaveFrame_NameInputBox_OnTabEnterPressed()
	WoWEquip_SaveFrame_DescInputBox:SetFocus()
end
WoWEquip_SaveFrame_NameInputBox:SetScript("OnTabPressed", WoWEquip_SaveFrame_NameInputBox_OnTabEnterPressed);
WoWEquip_SaveFrame_NameInputBox:SetScript("OnEnterPressed", WoWEquip_SaveFrame_NameInputBox_OnTabEnterPressed);
WoWEquip_SaveFrame_DescInputBox:SetScript("OnTabPressed", function() WoWEquip_SaveFrame_NameInputBox:SetFocus() end);


--------------------------------------------------
-- The Save and Load profile buttons and OnFoo() functions

-- Create the Save button
WoWEquip_SaveButton = CreateFrame("Button", nil, WoWEquip_Frame, "OptionsButtonTemplate");
WoWEquip_SaveButton:SetWidth(100);
WoWEquip_SaveButton:SetHeight(22);
WoWEquip_SaveButton:SetPoint("BOTTOMLEFT", WoWEquip_PaperDollAr["Ranged"], "BOTTOMRIGHT", 1, -2);
WoWEquip_SaveButton:SetText(L["Save Profile..."]);

-- Create the Load button
WoWEquip_LoadButton = CreateFrame("Button", nil, WoWEquip_Frame, "OptionsButtonTemplate");
WoWEquip_LoadButton:SetWidth(100);
WoWEquip_LoadButton:SetHeight(22);
WoWEquip_LoadButton:SetPoint("BOTTOM", WoWEquip_SaveButton, "TOP", 0, -2);
WoWEquip_LoadButton:SetText(L["Load Profile..."]);

function WoWEquip_SaveButton:OnClick()
	if (WoWEquip_SaveFrame:IsShown() and WoWEquip_SaveFrame.mode == "save") then
		WoWEquip_SaveFrame:Hide();
	else
		WoWEquip_SaveFrame_TitleText:SetText(L["Save Profile"]);
		WoWEquip_SaveFrame_SaveButton:SetText(L["Save"]);
		WoWEquip_SaveFrame_SaveButton:SetScript("OnClick", WoWEquip_PreSave);
		WoWEquip_SaveFrame_NameInputBox:SetText(currentProfileName);
		WoWEquip_SaveFrame_DescInputBox:SetText(currentProfileDesc);
		WoWEquip_SaveFrame_NameText:Show();
		WoWEquip_SaveFrame_NameInputFrame:Show();
		WoWEquip_SaveFrame_TargetText:Hide();
		WoWEquip_SaveFrame_TargetInputFrame:Hide();
		WoWEquip_SaveFrame_DescText:Show();
		WoWEquip_SaveFrame_DescFrame:Show();
		WoWEquip_SaveFrame_ProfilesText:SetPoint("TOPLEFT", WoWEquip_SaveFrame_DescFrame, "BOTTOMLEFT", 0, 0);
		WoWEquip_SaveFrame:SetHeight(300);
		WoWEquip_SaveFrame_SaveButton:Enable();
		WoWEquip_SaveFrame.mode = "save";	-- must do this before GenerateProfileList()
		WoWEquip_GenerateProfilesList();
		WoWEquip_ProfilesScrollFrame_Update();
		WoWEquip_SaveFrame:Show();
	end
end

function WoWEquip_LoadButton:OnClick()
	if (WoWEquip_SaveFrame:IsShown() and WoWEquip_SaveFrame.mode == "load") then
		WoWEquip_SaveFrame:Hide();
	else
		WoWEquip_SaveFrame_TitleText:SetText(L["Load Profile"]);
		WoWEquip_SaveFrame_SaveButton:SetText(L["Load"]);
		WoWEquip_SaveFrame_SaveButton:SetScript("OnClick", WoWEquip_PreLoad);
		WoWEquip_SaveFrame_NameText:Hide();
		WoWEquip_SaveFrame_NameInputFrame:Hide();
		WoWEquip_SaveFrame_TargetText:Hide();
		WoWEquip_SaveFrame_TargetInputFrame:Hide();
		WoWEquip_SaveFrame_DescText:Hide();
		WoWEquip_SaveFrame_DescFrame:Hide();
		WoWEquip_SaveFrame_ProfilesText:SetPoint("TOPLEFT", 25, -28);
		WoWEquip_SaveFrame:SetHeight(196);
		WoWEquip_SaveFrame.mode = "load";	-- must do this before GenerateProfileList()
		WoWEquip_GenerateProfilesList();
		WoWEquip_ProfilesScrollFrame_Update();
		WoWEquip_SaveFrame:Show();
	end
end

WoWEquip_SaveButton:SetScript("OnClick", WoWEquip_SaveButton.OnClick);
WoWEquip_LoadButton:SetScript("OnClick", WoWEquip_LoadButton.OnClick);


---------------------------------------------------
-- The Compare Against button and OnFoo() functions

-- Create the Compare button
WoWEquip_CompareButton = CreateFrame("Button", nil, WoWEquip_BonusFrame, "OptionsButtonTemplate");
WoWEquip_CompareButton:SetWidth(16);
WoWEquip_CompareButton:SetHeight(16);
WoWEquip_CompareButton:SetPoint("TOPLEFT", WoWEquip_ToggleRatingButton, "BOTTOMLEFT", 0, 3);
WoWEquip_CompareButton:SetText("C");

local function WoWEquip_SetCompareProfile()
	local name = strtrim(WoWEquip_SaveFrame_NameInputBox:GetText());
	WoWEquip_Save.compareProfile = name;
	WoWEquip_Save.compareOptions = 3;
	WoWEquip_CompareText:SetText(name);
	WoWEquip_SaveFrame:Hide();
	WoWEquip:UpdateBonusFrame();
end

local function WoWEquip_SetCompareOptions(value)
	if (value == 3) then
		if (WoWEquip_SaveFrame:IsShown() and WoWEquip_SaveFrame.mode == "compare") then
			WoWEquip_SaveFrame:Hide();
		else
			WoWEquip_SaveFrame_TitleText:SetText(L["Compare Profile"]);
			WoWEquip_SaveFrame_SaveButton:SetText(L["Compare"]);
			WoWEquip_SaveFrame_SaveButton:SetScript("OnClick", WoWEquip_SetCompareProfile);
			WoWEquip_SaveFrame_NameText:Hide();
			WoWEquip_SaveFrame_NameInputFrame:Hide();
			WoWEquip_SaveFrame_TargetText:Hide();
			WoWEquip_SaveFrame_TargetInputFrame:Hide();
			WoWEquip_SaveFrame_DescText:Hide();
			WoWEquip_SaveFrame_DescFrame:Hide();
			WoWEquip_SaveFrame_ProfilesText:SetPoint("TOPLEFT", 25, -28);
			WoWEquip_SaveFrame:SetHeight(196);
			WoWEquip_SaveFrame.mode = "compare";	-- must do this before GenerateProfileList()
			WoWEquip_GenerateProfilesList();
			WoWEquip_ProfilesScrollFrame_Update();
			WoWEquip_SaveFrame:Show();
		end
	else
		WoWEquip_Save.compareOptions = value;
		WoWEquip_CompareText:SetText(L["Comparing: "]..WoWEquip_CompareOptions[value].t);
		WoWEquip:UpdateBonusFrame();
	end
end

local function WoWEquip_GenerateCompareMenu(level)
	WoWEquip_GenerateGenericMenu(level, WoWEquip_CompareOptions, WoWEquip_SetCompareOptions, WoWEquip_Save.compareOptions, L["Compare against..."]);
end

function WoWEquip_CompareButton:OnClick()
	WoWEquip_GenericDropDownMenu:SetParent(self);
	WoWEquip_GenericDropDownMenu.initialize = WoWEquip_GenerateCompareMenu;
	ToggleDropDownMenu(1, nil, WoWEquip_GenericDropDownMenu, self, 0, 0);
end
WoWEquip_CompareButton:SetScript("OnClick", WoWEquip_CompareButton.OnClick);

-- Create the text next to the Compare button
WoWEquip_CompareText = WoWEquip_BonusFrame:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall");
WoWEquip_CompareText:SetJustifyH("LEFT");
WoWEquip_CompareText:SetPoint("LEFT", WoWEquip_CompareButton, "RIGHT", 0, 0);
WoWEquip_CompareText:SetWidth(WoWEquip_BonusFrame:GetWidth() - WoWEquip_CompareButton:GetWidth() - WOWEQUIP_BOX_BACKDROP.insets.left - WOWEQUIP_BOX_BACKDROP.insets.right);
temp, temp2, temp3 = WoWEquip_CompareText:GetFont();
WoWEquip_CompareText:SetFont(temp, 8, temp3);
WoWEquip_CompareText:SetHeight(8);
WoWEquip_CompareText:SetText(L["Comparing: "]);


------------------------------------------------------
-- Other functions

function WoWEquip:CheckSlot(itemEquipLoc, slotnum)
	-- Function that checks if a itemEquipLoc return from a GetItemInfo() is equippable for a slotnum
	if (WOWEQUIP_EQUIPLOC[itemEquipLoc] == slotnum) or
	(itemEquipLoc == "INVTYPE_FINGER"  and slotnum == 12) or
	(itemEquipLoc == "INVTYPE_TRINKET" and slotnum == 14) or
	(itemEquipLoc == "INVTYPE_WEAPON"  and slotnum == 17) then
		return true;
	end
	return false;
end

local function WoWEquip_Filter(itemLink, itemType, itemSubType, itemEquipLoc)
	local flag;
	if (not WOWEQUIP_FILTEROPTIONS[WOWEQUIP_EQUIPLOC[itemEquipLoc]]) then
		return true;
	end

	local misctableID = WOWEQUIP_FILTEROPTIONS[selectedSlotNum]["misctable"];
	for i = 1, #WOWEQUIP_FILTERTABLE[misctableID] do
		local k = WOWEQUIP_FILTERTABLE[misctableID][i];
		if (WoWEquip_Save.filterOptions[k]) then
			flag = true;
			if (WOWEQUIP_FILTERTABLE[k][1] and WOWEQUIP_FILTERTABLE[k][1] ~= itemType) then flag = false; end
			if (flag and WOWEQUIP_FILTERTABLE[k][2] and WOWEQUIP_FILTERTABLE[k][2] ~= itemSubType) then flag = false; end
			if (flag and WOWEQUIP_FILTERTABLE[k][3] and WOWEQUIP_FILTERTABLE[k][3] ~= itemEquipLoc and WOWEQUIP_FILTERTABLE[k][4] ~= itemEquipLoc) then
				flag = false;
			end
			if (flag) then return true; end
		end
	end

	-- This part of the code deals with "Miscellaneous" which is a search for anything not categorised in the other options
	if (WoWEquip_Save.filterOptions[misctableID]) then
		for i = 1, #WOWEQUIP_FILTERTABLE[misctableID] do
			local v = WOWEQUIP_FILTERTABLE[misctableID][i];
			flag = true;
			if (WOWEQUIP_FILTERTABLE[v][1] and WOWEQUIP_FILTERTABLE[v][1] ~= itemType) then flag = false; end
			if (flag and WOWEQUIP_FILTERTABLE[v][2] and WOWEQUIP_FILTERTABLE[v][2] ~= itemSubType) then flag = false; end
			if (flag and WOWEQUIP_FILTERTABLE[v][3] and WOWEQUIP_FILTERTABLE[v][3] ~= itemEquipLoc and WOWEQUIP_FILTERTABLE[v][4] ~= itemEquipLoc) then
				flag = false;
			end
			if (flag) then return false; end
		end
		return true;
	end

	return false;
end

function WoWEquip:GenerateDispList(refreshMethod)
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture;
	local findText = strlower(WoWEquip_InputBox:GetText());

	if (refreshMethod == 1) then
		-- This refresh method builds an brand new list by scanning the entire local cache
		for k = #WoWEquip_DispResults, 1, -1 do
			WoWEquip_DispResults[k] = nil;
		end
		local found = 0;
		for k = 40000, 1, -1 do
			-- Scan backwards since the epics usually have larger itemIDs (gives a list that is already better sorted)
			itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(k);
			if (itemName and self:CheckSlot(itemEquipLoc, selectedSlotNum) and strfind(strlower(itemName), findText, 1, true) and WoWEquip_Filter(itemLink, itemType, itemSubType, itemEquipLoc)) then
				found = found + 1;
				WoWEquip_DispResults[found] = k;
				if (selectedItemID == k) then
					WoWEquip_EquipButton:Enable();
				end
			end
		end
		tsort(WoWEquip_DispResults, WoWEquip_SortDispList);

	elseif (refreshMethod == 2) then
		-- This refresh method uses the existing list and prunes it for high speed on-the-fly search. Since the list is already sorted, it doesn't need to be sorted either.
		for k = #WoWEquip_DispResults, 1, -1 do
			itemName = GetItemInfo(WoWEquip_DispResults[k]);
			if (not strfind(strlower(itemName), findText, 1, true)) then
				tremove(WoWEquip_DispResults, k);
				if (selectedItemID == k) then
					WoWEquip_EquipButton:Disable();
				end
			end
		end
	end

	if (WoWEquip_InputBox.pointer) then
		WoWEquip_SlotSearchText:SetFormattedText(L["Selected Slot: %s (%d)"], WoWEquip_InputBox.pointer.slotnamelocal, #WoWEquip_DispResults);
		self:ListUpdate();
	end
end

function WoWEquip:ListUpdate()
	WoWEquip_ListScrollFrame_Update();
end

--------------------------------------------------
-- Profile Sharing via addon whisper communication

local ValidVersions = {
	["0.8"] = true,
	["0.81"] = true,
	["0.9"] = true,
}

AceComm:embed(WoWEquip);

function WoWEquip:SendProfile(name, target)
	local success = self:SendPrioritizedCommMessage("BULK", "WHISPER", target, "SendProfile", WoWEquip_Save.version, WoWEquip_Save.profiles[name]);
	if (success) then
		WoWEquip:PrintMessage(format(L["WOW_EQUIP_SEND_SUCCESS"], name, target));
	else
		WoWEquip:PrintMessage(format(L["WOW_EQUIP_SEND_FAIL"], name, target));
	end
end

function WoWEquip:ReceiveProfile(sender, version, profile)
	if (not WoWEquip_Save.ProfileReceive) then
		self:SendPrioritizedCommMessage("BULK", "WHISPER", sender, "ReceiveProfile", "3");
		return;
	end
	
	local valid = true;
	-- Check version and that the received profile is a table
	if (type(profile) ~= "table" or not ValidVersions[version]) then
		valid = false;
	end
	version = tonumber(version)
	-- Check that the name, desc, class, level and eq fields are valid
	if (valid) then
		if (type(profile.name) ~= "string" or type(profile.desc) ~= "string" or type(profile.class) ~= "number" or type(profile.level) ~= "number" or type(profile.eq) ~= "table") then
			valid = false;
		end
	end
	-- Check that the equipment key/value pairs are valid
	if (valid) then
		for k, v in pairs(profile.eq) do
			-- Check k is a valid slot and v is a valid link
			if (WoWEquip_PaperDollAr[k] == nil) or (not strfind(v, "^|c%x+|Hitem:%d+:%d+:%d+:%d+:%d+:%d+:[-]?%d+:[-]?%d+|h%[.-%]|h|r$")) then
				valid = false;
				break;
			end
		end
	end
	-- Check race in v0.81
	if valid and version >= 0.81 then
		if type(profile.race) ~= "number" then
			valid = false
		end
	end
	if (not valid) then
		self:SendPrioritizedCommMessage("BULK", "WHISPER", sender, "ReceiveProfile", "2");
		WoWEquip:PrintMessage(format(L["WOW_EQUIP_RECEIVE_INVALID"], profile.name, sender));
		return;
	end

	-- Profile is validated
	-- Check for naming conflict and rename profile if necessary, then save it
	if (not WoWEquip_Save.profiles[profile.name]) then
		WoWEquip_Save.profiles[profile.name] = profile;
	else
		local i = 1;
		while (WoWEquip_Save.profiles[profile.name.."-"..i]) do 
			i = i + 1;
		end
		profile.name = profile.name.."-"..i;
		WoWEquip_Save.profiles[profile.name] = profile;
	end
	WoWEquip:PrintMessage(format(L["WOW_EQUIP_RECEIVE_SUCCESS"], profile.name, sender));
	self:SendPrioritizedCommMessage("BULK", "WHISPER", sender, "ReceiveProfile", "0");
end

function WoWEquip:ReceiveMessage(prefix, sender, distribution, messageType, arg1, arg2)
	if (messageType == "SendProfile") then
		self:ReceiveProfile(sender, arg1, arg2);
	elseif (messageType == "ReceiveProfile") then
		if (lastSendTime and (GetTime() - lastSendTime < 30)) then
			WoWEquip:PrintMessage(format(L["WOW_EQUIP_RECEIVE_ACK"..arg1], sender));
		end
	end
end

WoWEquip:SetCommPrefix("WoWEquip");
WoWEquip:RegisterComm(WoWEquip.commPrefix, "WHISPER", "ReceiveMessage");

-- Create the Send button
WoWEquip_SendButton = CreateFrame("Button", nil, WoWEquip_Frame, "OptionsButtonTemplate");
WoWEquip_SendButton:SetWidth(100);
WoWEquip_SendButton:SetHeight(22);
WoWEquip_SendButton:SetPoint("TOP", WoWEquip_SaveButton, "BOTTOM", 0, 2);
WoWEquip_SendButton:SetText(L["Send Profile..."]);

local function WoWEquip_PreSend()
	if (lastSendTime and (GetTime() - lastSendTime < 30)) then
		WoWEquip:PrintMessage(L["WOW_EQUIP_SEND_LIMIT_ERROR"]);
		return;
	end
	lastSendTime = GetTime();
	local name = strtrim(WoWEquip_SaveFrame_NameInputBox:GetText());
	local target = strtrim(WoWEquip_SaveFrame_TargetInputBox:GetText());
	WoWEquip:SendProfile(name, target);
	WoWEquip_SaveFrame:Hide();
end

function WoWEquip_SendButton:OnClick()
	if (WoWEquip_SaveFrame:IsShown() and WoWEquip_SaveFrame.mode == "send") then
		WoWEquip_SaveFrame:Hide();
	else
		WoWEquip_SaveFrame_TitleText:SetText(L["Send Profile"]);
		WoWEquip_SaveFrame_SaveButton:SetText(L["Send"]);
		WoWEquip_SaveFrame_SaveButton:SetScript("OnClick", WoWEquip_PreSend);
		WoWEquip_SaveFrame_NameText:Hide();
		WoWEquip_SaveFrame_NameInputFrame:Hide();
		WoWEquip_SaveFrame_TargetText:Show();
		WoWEquip_SaveFrame_TargetInputFrame:Show();
		WoWEquip_SaveFrame_DescText:Hide();
		WoWEquip_SaveFrame_DescFrame:Hide();
		WoWEquip_SaveFrame_ProfilesText:SetPoint("TOPLEFT", WoWEquip_SaveFrame_TargetInputFrame, "BOTTOMLEFT", 0, 0);
		WoWEquip_SaveFrame:SetHeight(230);
		WoWEquip_SaveFrame.mode = "send";	-- must do this before GenerateProfileList()
		WoWEquip_GenerateProfilesList();
		WoWEquip_ProfilesScrollFrame_Update();
		WoWEquip_SaveFrame:Show();
	end
end

WoWEquip_SendButton:SetScript("OnClick", WoWEquip_SendButton.OnClick);


--------------------------------------------------------------
-- Hook the Dressing Room general dressup function to WoWEquip

hooksecurefunc("DressUpItemLink", function(link)
	-- Hooks any item that is sent to the dressing room to also equip in WoWEquip if the WoWEquip frame is open
	if (not link) then
		return;
	end
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(link);
	if (not WoWEquip_Frame:IsShown() or not itemName) then
		return;
	end

	-- Only do something if it is an equippable gear (slot 1-19). Can't use IsEquippableItem(itemLink) because
	-- it will also return true for ammo (slot 0) and bags (slot 20-23).
	if (WOWEQUIP_EQUIPLOC[itemEquipLoc] and (WOWEQUIP_EQUIPLOC[itemEquipLoc] > 0) and (WOWEQUIP_EQUIPLOC[itemEquipLoc] < 20)) then
		for k, v in pairs(WoWEquip_PaperDollAr) do
			if (v.slotnum == WOWEQUIP_EQUIPLOC[itemEquipLoc]) then
				if (WoWEquip_Save.PreserveEnchant and eq[v.slotname]) then
					local oldEnchantID = strmatch(eq[v.slotname], "item:%d+:(%d+):");
					itemLink = gsub(itemLink, "(item:%d+):(%d+):", "%1:"..oldEnchantID..":");
				end
				eq[v.slotname] = itemLink;
				SetItemButtonTexture(v, itemTexture);
				local r, g, b = GetItemQualityColor(itemRarity);
				v.border:SetVertexColor(r, g, b, 1);
				v.border:Show();
				WoWEquip:UpdateBonusFrame();
				return;
			end
		end
	end
end);


-------------------------------------------------
-- The Options dialog box and OnFoo() functions

do
	-- Create the Options frame
	-- Note: Scaling the WoWEquip frame with the Options Frame as a child causes Slider issues when you click it
	-- Basically the options frame would resize and what you clicked on would be a different % size.
	WoWEquip_OptionsFrame = CreateFrame("Frame", "WoWEquip_OptionsFrame", UIParent);
	WoWEquip_OptionsFrame:Hide();
	WoWEquip_OptionsFrame:SetWidth(350);
	WoWEquip_OptionsFrame:SetHeight(290);
	WoWEquip_OptionsFrame:SetPoint("CENTER", 0, 0);
	WoWEquip_OptionsFrame:SetBackdrop(WOWEQUIP_MAIN_BACKDROP);
	WoWEquip_OptionsFrame:SetBackdropColor(0, 0, 0, 0.75);
	WoWEquip_OptionsFrame:EnableMouse(true);
	WoWEquip_OptionsFrame:SetToplevel(true);
	WoWEquip_OptionsFrame:SetClampedToScreen(true);
	WoWEquip_OptionsFrame:SetMovable(true);
	temp = WoWEquip_OptionsFrame:CreateTexture(nil, "ARTWORK");
	temp:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header");
	temp:SetWidth(300);
	temp:SetHeight(64);
	temp:SetPoint("TOP", 0, 12);
	WoWEquip_OptionsFrame.titleTexture = temp;
	WoWEquip_OptionsFrame_TitleText = WoWEquip_OptionsFrame:CreateFontString(nil, "ARTWORK", "GameFontNormal");
	WoWEquip_OptionsFrame_TitleText:SetPoint("TOP", 0, -3);
	WoWEquip_OptionsFrame_TitleText:SetText(L["WoWEquip Options"]);

	-- This creates a transparent textureless draggable frame to move WoWEquip_OptionsFrame
	-- It overlaps the above title text and texture (more or less) exactly.
	temp = CreateFrame("Frame", nil, WoWEquip_OptionsFrame);
	temp:SetWidth(150);
	temp:SetHeight(30);
	temp:SetPoint("TOP", 0, 8);
	temp:EnableMouse(true);
	temp:RegisterForDrag("LeftButton");
	temp:SetScript("OnDragStart", WoWEquip_Generic_StartMoving);
	temp:SetScript("OnDragStop", WoWEquip_Generic_StopMovingOrSizing);

	-- Create the Close button
	WoWEquip_OptionsFrame_CloseButton = CreateFrame("Button", nil, WoWEquip_OptionsFrame, "UIPanelCloseButton");
	WoWEquip_OptionsFrame_CloseButton:SetPoint("TOPRIGHT", WoWEquip_OptionsFrame, "TOPRIGHT", -2, -1);
	WoWEquip_OptionsFrame_CloseButton:SetHitRectInsets(5, 5, 5, 5);
	WoWEquip_OptionsFrame_CloseButton:SetScript("OnClick", WoWEquip_Generic_Hide);

	-- Lock window checkbox
	CreateFrame("CheckButton", "WoWEquip_OptionsFrame_LockWindow", WoWEquip_OptionsFrame, "OptionsCheckButtonTemplate");
	WoWEquip_OptionsFrame_LockWindow:SetPoint("TOPLEFT", 20, -25);
	WoWEquip_OptionsFrame_LockWindow:SetHitRectInsets(0, -260, 0, 0);
	WoWEquip_OptionsFrame_LockWindowText:SetText(L["Lock WoWEquip windows from being moved"]);
	WoWEquip_OptionsFrame_LockWindow:SetScript("OnClick", function(self)
		WoWEquip_Save.LockWindow = not WoWEquip_Save.LockWindow;
		self:SetChecked(WoWEquip_Save.LockWindow);
	end);

	-- Preserve enchants checkbox
	CreateFrame("CheckButton", "WoWEquip_OptionsFrame_PreserveEnchant", WoWEquip_OptionsFrame, "OptionsCheckButtonTemplate");
	WoWEquip_OptionsFrame_PreserveEnchant:SetPoint("TOP", WoWEquip_OptionsFrame_LockWindow, "BOTTOM", 0, 10);
	WoWEquip_OptionsFrame_PreserveEnchant:SetHitRectInsets(0, -260, 0, 0);
	WoWEquip_OptionsFrame_PreserveEnchantText:SetText(L["Keep previous enchant when equipping a new item"]);
	WoWEquip_OptionsFrame_PreserveEnchant:SetScript("OnClick", function(self)
		WoWEquip_Save.PreserveEnchant = not WoWEquip_Save.PreserveEnchant;
		self:SetChecked(WoWEquip_Save.PreserveEnchant);
	end);

	-- Allow profile receiving checkbox
	CreateFrame("CheckButton", "WoWEquip_OptionsFrame_ProfileReceive", WoWEquip_OptionsFrame, "OptionsCheckButtonTemplate");
	WoWEquip_OptionsFrame_ProfileReceive:SetPoint("TOP", WoWEquip_OptionsFrame_PreserveEnchant, "BOTTOM", 0, 10);
	WoWEquip_OptionsFrame_ProfileReceive:SetHitRectInsets(0, -260, 0, 0);
	WoWEquip_OptionsFrame_ProfileReceiveText:SetText(L["Allow others to send WoWEquip profiles to you"]);
	WoWEquip_OptionsFrame_ProfileReceive:SetScript("OnClick", function(self)
		WoWEquip_Save.ProfileReceive = not WoWEquip_Save.ProfileReceive;
		self:SetChecked(WoWEquip_Save.ProfileReceive);
	end);

	function WoWEquip:SetBackgroundColor(r, g, b, a)
		WoWEquip_Frame:SetBackdropColor(r, g, b, a);
		WoWEquip_EquipFrame:SetBackdropColor(r, g, b, a);
		WoWEquip_SaveFrame:SetBackdropColor(r, g, b, a);
		WoWEquip_OptionsFrame:SetBackdropColor(r, g, b, a);
		WoWEquip_Save.r = r;
		WoWEquip_Save.g = g;
		WoWEquip_Save.b = b;
		WoWEquip_Save.a = a;
	end

	local function WoWEquip_SetNewBackgroundColor()
		local r, g, b = ColorPickerFrame:GetColorRGB();
		local a = 1.0 - OpacitySliderFrame:GetValue();
		WoWEquip:SetBackgroundColor(r, g, b, a);
	end

	local function WoWEquip_SetOldBackgroundColor(colortable)		
		WoWEquip:SetBackgroundColor(colortable.r, colortable.g, colortable.b, colortable.a);
	end

	-- Create and position the Name text string
	temp = WoWEquip_OptionsFrame:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
	temp:SetPoint("TOPLEFT", WoWEquip_OptionsFrame_ProfileReceive, "BOTTOMLEFT", 4, 0);
	temp:SetText(L["Change:"]);

	-- Change Background Colour button
	WoWEquip_OptionsFrame_BGColorButton = CreateFrame("Button", nil, WoWEquip_OptionsFrame, "OptionsButtonTemplate");
	WoWEquip_OptionsFrame_BGColorButton:SetWidth(120);
	WoWEquip_OptionsFrame_BGColorButton:SetPoint("LEFT", temp, "RIGHT");
	WoWEquip_OptionsFrame_BGColorButton:SetText(L["Background Color"]);
	WoWEquip_OptionsFrame_BGColorButton:SetScript("OnClick", function(self)
		-- These 2 lines fix a bug for an uninitialised OpacitySliderFrame
		-- returning and saving a value of 0 on SetColorRGB and SetValue
		ColorPickerFrame.opacityFunc = nil;
		OpacitySliderFrame:SetValue(1.0 - WoWEquip_Save.a);

		ColorPickerFrame.func = WoWEquip_SetNewBackgroundColor;
		ColorPickerFrame.hasOpacity = 1;
		ColorPickerFrame.opacityFunc = WoWEquip_SetNewBackgroundColor;
		ColorPickerFrame.opacity = 1.0 - WoWEquip_Save.a;
		ColorPickerFrame.previousValues = {r = WoWEquip_Save.r, g = WoWEquip_Save.g, b = WoWEquip_Save.b, a = WoWEquip_Save.a};
		ColorPickerFrame.cancelFunc = WoWEquip_SetOldBackgroundColor;
		ColorPickerFrame:SetColorRGB(WoWEquip_Save.r, WoWEquip_Save.g, WoWEquip_Save.b);
		ShowUIPanel(ColorPickerFrame);
	end);

	function WoWEquip:SetBackdropBorderColor(r, g, b, a)
		WoWEquip_Frame:SetBackdropBorderColor(r, g, b, a);
		WoWEquip_Frame.titleTexture:SetVertexColor(r, g, b, a);
		WoWEquip_EquipFrame:SetBackdropBorderColor(r, g, b, a);
		WoWEquip_EquipFrame.titleTexture:SetVertexColor(r, g, b, a);
		WoWEquip_SaveFrame:SetBackdropBorderColor(r, g, b, a);
		WoWEquip_SaveFrame.titleTexture:SetVertexColor(r, g, b, a);
		WoWEquip_OptionsFrame:SetBackdropBorderColor(r, g, b, a);
		WoWEquip_OptionsFrame.titleTexture:SetVertexColor(r, g, b, a);
		WoWEquip_Save.br = r;
		WoWEquip_Save.bg = g;
		WoWEquip_Save.bb = b;
		WoWEquip_Save.ba = a;
	end

	local function WoWEquip_SetNewBackdropBorderColor()
		local r, g, b = ColorPickerFrame:GetColorRGB();
		local a = 1.0 - OpacitySliderFrame:GetValue();
		WoWEquip:SetBackdropBorderColor(r, g, b, a);
	end

	local function WoWEquip_SetOldBackdropBorderColor(colortable)		
		WoWEquip:SetBackdropBorderColor(colortable.r, colortable.g, colortable.b, colortable.a);
	end

	-- Change Border Colour button
	WoWEquip_OptionsFrame_BBGColorButton = CreateFrame("Button", nil, WoWEquip_OptionsFrame, "OptionsButtonTemplate");
	WoWEquip_OptionsFrame_BBGColorButton:SetWidth(120);
	WoWEquip_OptionsFrame_BBGColorButton:SetPoint("Left", WoWEquip_OptionsFrame_BGColorButton, "RIGHT");
	WoWEquip_OptionsFrame_BBGColorButton:SetText(L["Border Color"]);
	WoWEquip_OptionsFrame_BBGColorButton:SetScript("OnClick", function(self)
		-- These 2 lines fix a bug for an uninitialised OpacitySliderFrame
		-- returning and saving a value of 0 on SetColorRGB and SetValue
		ColorPickerFrame.opacityFunc = nil;
		OpacitySliderFrame:SetValue(1.0 - WoWEquip_Save.ba);

		ColorPickerFrame.func = WoWEquip_SetNewBackdropBorderColor;
		ColorPickerFrame.hasOpacity = 1;
		ColorPickerFrame.opacityFunc = WoWEquip_SetNewBackdropBorderColor;
		ColorPickerFrame.opacity = 1.0 - WoWEquip_Save.ba;
		ColorPickerFrame.previousValues = {r = WoWEquip_Save.br, g = WoWEquip_Save.bg, b = WoWEquip_Save.bb, a = WoWEquip_Save.ba};
		ColorPickerFrame.cancelFunc = WoWEquip_SetOldBackdropBorderColor;
		ColorPickerFrame:SetColorRGB(WoWEquip_Save.br, WoWEquip_Save.bg, WoWEquip_Save.bb);
		ShowUIPanel(ColorPickerFrame);
	end);

	-- Transparency slider
	CreateFrame("Slider", "WoWEquip_TransparencySlider", WoWEquip_OptionsFrame, "OptionsSliderTemplate");
	WoWEquip_TransparencySlider:SetWidth(300);
	WoWEquip_TransparencySlider:SetHeight(16);
	WoWEquip_TransparencySlider:SetPoint("TOP", 0, -135);
	WoWEquip_TransparencySliderText:SetText(L["WoWEquip Transparency: "]);
	WoWEquip_TransparencySliderLow:SetText("25%");
	WoWEquip_TransparencySliderHigh:SetText("100%");
	WoWEquip_TransparencySlider:SetMinMaxValues(25, 100);
	WoWEquip_TransparencySlider:SetValueStep(1);
	WoWEquip_TransparencySlider:SetScript("OnValueChanged", function(self, value)
		WoWEquip_TransparencySliderText:SetText(L["WoWEquip Transparency: "]..value.."%");
		WoWEquip_Save.Transparency = value;
		WoWEquip_Frame:SetAlpha(value / 100);
	end);

	-- Scale slider
	CreateFrame("Slider", "WoWEquip_ScaleSlider", WoWEquip_OptionsFrame, "OptionsSliderTemplate");
	WoWEquip_ScaleSlider:SetWidth(300);
	WoWEquip_ScaleSlider:SetHeight(16);
	WoWEquip_ScaleSlider:SetPoint("TOP", WoWEquip_TransparencySlider, "BOTTOM", 0, -15);
	WoWEquip_ScaleSliderText:SetText(L["WoWEquip Scaling: "]);
	WoWEquip_ScaleSliderLow:SetText("50%");
	WoWEquip_ScaleSliderHigh:SetText("150%");
	WoWEquip_ScaleSlider:SetMinMaxValues(50, 150);
	WoWEquip_ScaleSlider:SetValueStep(1);
	WoWEquip_ScaleSlider:SetScript("OnValueChanged", function(self, value)
		WoWEquip_ScaleSliderText:SetText(L["WoWEquip Scaling: "]..value.."%");
		WoWEquip_Save.Scale = value;
		WoWEquip_Frame:SetScale(value / 100);
	end);

	-- Dressing Room Scale slider
	CreateFrame("Slider", "WoWEquip_DRScaleSlider", WoWEquip_OptionsFrame, "OptionsSliderTemplate");
	WoWEquip_DRScaleSlider:SetWidth(300);
	WoWEquip_DRScaleSlider:SetHeight(16);
	WoWEquip_DRScaleSlider:SetPoint("TOP", WoWEquip_ScaleSlider, "BOTTOM", 0, -15);
	WoWEquip_DRScaleSliderText:SetText(L["Attached Dressing Room Scaling: "]);
	WoWEquip_DRScaleSliderLow:SetText("50%");
	WoWEquip_DRScaleSliderHigh:SetText("150%");
	WoWEquip_DRScaleSlider:SetMinMaxValues(50, 150);
	WoWEquip_DRScaleSlider:SetValueStep(1);
	WoWEquip_DRScaleSlider:SetScript("OnValueChanged", function(self, value)
		WoWEquip_DRScaleSliderText:SetText(L["Attached Dressing Room Scaling: "]..value.."%");
		WoWEquip_Save.DRScale = value;
		if (WoWEquip_Frame:IsShown() and DressUpFrame:IsShown()) then
			DressUpFrame:SetScale(WoWEquip_Save.DRScale / 100);
			WoWEquip:UpdateDressUpModel();
		end
	end);

	function WoWEquip:SetExtraWidth(width)
		assert(width >= 0, "Width must not be negative");
		WoWEquip_Frame:SetWidth(320 + width);
		WoWEquip_DoneButton:SetWidth(82 + width);
		WoWEquip_CopyTargetButton:SetWidth(82 + width);
		WoWEquip_OptionsButton:SetWidth(60 + width/2);
		WoWEquip_BonusFrame:SetWidth(220 + width);
		WoWEquip_BonusScrollFrame:SetWidth(187 + width);
		WoWEquip_BonusFrame.title:SetPoint("TOPLEFT", (WoWEquip_BonusFrame:GetWidth() - WoWEquip_LevelText:GetWidth() - WoWEquip_LevelInputBox:GetWidth() - WoWEquip_ToggleRatingButton:GetWidth() - WoWEquip_BonusFrame.title:GetWidth()) / 2 + WoWEquip_ToggleRatingButton:GetWidth(), -6);
		WoWEquip_BonusScrollFrame:GetScrollChild():SetWidth(187 + width);
		WoWEquip_BonusScrollFrame.ScrollChild.eqstring:SetWidth(187 + width);
		WoWEquip_BonusScrollFrame.ScrollChild.dsstring:SetWidth(187 + width);
		WoWEquip_BetaText:SetWidth(187 + width);
		WoWEquip_BonusScrollFrame:UpdateScrollChildRect();
	end

	-- Dressing Room Scale slider
	CreateFrame("Slider", "WoWEquip_ExtraWidthSlider", WoWEquip_OptionsFrame, "OptionsSliderTemplate");
	WoWEquip_ExtraWidthSlider:SetWidth(300);
	WoWEquip_ExtraWidthSlider:SetHeight(16);
	WoWEquip_ExtraWidthSlider:SetPoint("TOP", WoWEquip_DRScaleSlider, "BOTTOM", 0, -15);
	WoWEquip_ExtraWidthSliderText:SetText(L["Add extra width to WoWEquip: "]);
	WoWEquip_ExtraWidthSliderLow:SetText("0");
	WoWEquip_ExtraWidthSliderHigh:SetText("80");
	WoWEquip_ExtraWidthSlider:SetMinMaxValues(0, 80);
	WoWEquip_ExtraWidthSlider:SetValueStep(1);
	WoWEquip_ExtraWidthSlider:SetScript("OnValueChanged", function(self, value)
		WoWEquip_ExtraWidthSliderText:SetText(L["Add extra width to WoWEquip: "]..value);
		WoWEquip_Save.AddWidth = value;
		WoWEquip:SetExtraWidth(value);
	end);

	-- Done button
	WoWEquip_OptionsFrame_DoneButton = CreateFrame("Button", nil, WoWEquip_OptionsFrame, "OptionsButtonTemplate");
	WoWEquip_OptionsFrame_DoneButton:SetPoint("BOTTOM", 0, 20);
	WoWEquip_OptionsFrame_DoneButton:SetText(DONE);
	WoWEquip_OptionsFrame_DoneButton:SetScript("OnClick", WoWEquip_Generic_Hide);

	WoWEquip_OptionsFrame:SetScript("OnShow", function(self)
		WoWEquip_OptionsFrame_LockWindow:SetChecked(WoWEquip_Save.LockWindow);
		WoWEquip_OptionsFrame_PreserveEnchant:SetChecked(WoWEquip_Save.PreserveEnchant);
		WoWEquip_OptionsFrame_ProfileReceive:SetChecked(WoWEquip_Save.ProfileReceive);
		WoWEquip_TransparencySlider:SetValue(WoWEquip_Save.Transparency);
		WoWEquip_ScaleSlider:SetValue(WoWEquip_Save.Scale);
		WoWEquip_DRScaleSlider:SetValue(WoWEquip_Save.DRScale);
		WoWEquip_ExtraWidthSlider:SetValue(WoWEquip_Save.AddWidth);
	end);
end


----------------------------
-- Create the Options button
WoWEquip_OptionsButton = CreateFrame("Button", nil, WoWEquip_Frame, "OptionsButtonTemplate");
WoWEquip_OptionsButton:SetWidth(60);
WoWEquip_OptionsButton:SetHeight(18);
WoWEquip_OptionsButton:SetPoint("RIGHT", WoWEquip_CloseButton, "LEFT", 8, 1);
WoWEquip_OptionsButton:SetText(L["Options..."]);
temp, temp2, temp3 = WoWEquip_OptionsButton:GetFont();
WoWEquip_OptionsButton:SetFont(temp, 10, temp3);

function WoWEquip_OptionsButton:OnClick()
	if (WoWEquip_OptionsFrame:IsShown()) then
		WoWEquip_OptionsFrame:Hide();
	else
		WoWEquip_OptionsFrame:Show();
	end
end
WoWEquip_OptionsButton:SetScript("OnClick", WoWEquip_OptionsButton.OnClick);

