if GetLocale() ~= "zhTW" then return end

local lib = LibStub("LibItemBonus-2.0")
local ALL_RESISTS = {"ARCANERES", "FIRERES", "FROSTRES", "NATURERES", "SHADOWRES"}
local ALL_STATS = {"STR", "AGI", "STA", "INT", "SPI"}
local HEAL_AND_DMG = {"HEAL", "DMG"}

lib.patterns = {
	NAMES = {
		STR = "力量",
		AGI = "敏捷",
		STA = "耐力",

		INT = "智力",
		SPI = "精神",
		ARMOR = "強化護甲",

		ARCANERES = "秘法抗性",
		FIRERES = "火焰抗性",
		NATURERES = "自然抗性",

		FROSTRES = "冰霜抗性",
		SHADOWRES = "暗影抗性",

		FISHING = "釣魚技能",
		MINING = "採礦",
		HERBALISM = "草藥學",
		SKINNING = "剝皮",

		DEFENSE = "防禦",

		BLOCK = "格擋",
		BLOCKVALUE = "格擋值",
		DODGE = "躲避",
		PARRY = "招架",
		ATTACKPOWER = "攻擊強度",

		ATTACKPOWERUNDEAD = "對不死生物的攻擊強度",
		ATTACKPOWERFERAL = "野性戰鬥強度",
		CRIT = "近戰致命等級",
		RANGEDATTACKPOWER = "遠程攻擊強度",
		RANGEDCRIT = "遠程攻擊致命一擊等級",
		TOHIT = "命中等級",

		ATTACKPOWEREVIL = "對惡魔的攻擊強度";
		DMG = "法術傷害",
		DMGUNDEAD = "對不死生物的法術傷害",
		ARCANEDMG = "秘法傷害",
		FIREDMG = "火焰傷害",
		FROSTDMG = "冰霜傷害",

		HOLYDMG = "神聖傷害",
		NATUREDMG = "自然傷害",
		SHADOWDMG = "暗影傷害",
		SPELLCRIT = "法術致命等級",
		SPELLTOHIT = "法術命中等級",
		SPELLPEN = "法術穿透",

		HEAL = "治療量",
		HOLYCRIT = "神聖爆擊等級",

		HEALTHREG = "生命回復",
		MANAREG = "法力回復",
		HEALTH = "生命值",
		MANA = "法力值",


		CR_WEAPON = "武器等級",
		CR_DEFENSE = "防禦等級",
		CR_DODGE = "躲避等級",
		CR_PARRY = "招架等級",
		CR_BLOCK = "格擋機率等級",

		CR_HIT = "命中等級",
		CR_CRIT = "致命一擊等級",
		CR_HASTE = "攻擊速度等級",
		CR_SPELLHIT = "法術命中等級",
		CR_SPELLCRIT = "法術致命一擊等級",
		CR_SPELLHASTE = "法術加速等級",

		CR_RESILIENCE = "韌性",

		CR_RANGEDHASTE = "遠程攻擊加速等級",
		CR_RANGEDHIT = "遠程命中等級",
		CR_WEAPON_DAGGER = "匕首類技能",
		CR_WEAPON_SWORD = "單手劍類技能",
		CR_WEAPON_SWORD_2H = "雙手劍技能",

		CR_WEAPON_AXE = "單手斧技能",
		CR_WEAPON_AXE_2H = "雙手斧技能",
		CR_WEAPON_MACE = "單手錘技能",
		CR_WEAPON_MACE_2H = "雙手錘技能",
		CR_WEAPON_BOW = "弓箭類技能",
		CR_WEAPON_XBOW = "十字弓技能",

		CR_WEAPON_GUN = "槍械類技能",
		CR_WEAPON_FIST = "拳套類技能",
		CR_WEAPON_STAFF = "法杖類技能",
		CR_WEAPON_POLEARM = "長柄武器技能",
	},

	PATTERNS_SKILL_RATING = {},
	SKILL_NAMES = {},

	PATTERNS_PASSIVE = {
		{ pattern = "使釣魚技能%+(%d+)點", effect = "FISHING" },
		{ pattern = "剝皮技能提高(%d+)點", effect = "SKINNING" },
		{ pattern = "使攻擊強度提高(%d+)點", effect = {"ATTACKPOWER","RANGEDATTACKPOWER"} },
		{ pattern = "+(%d+)攻擊強度", effect = {"ATTACKPOWER","RANGEDATTACKPOWER"} },
		{ pattern = "+(%d+)遠程攻擊強度", effect = "RANGEDATTACKPOWER" },

		{ pattern = "遠程攻擊強度提高(%d+)點", effect = "RANGEDATTACKPOWER" },
		{ pattern = "使你的格擋等級提高(%d+)點", effect = "BLOCK" },
		{ pattern = "提高你的盾牌格擋等級(%d+)", effect = "BLOCK" },
		{ pattern = "使你的閃躲等級提高(%d+)", effect = "DODGE" },
		{ pattern = "使你的韌性等級提高(%d+)", effect = "RESILIENCE" },
		{ pattern = "使你的招架等級提高(%d+)點", effect = "PARRY" },

		{ pattern = "法術致命一擊等級提高(%d+)", effect = "SPELLCRIT" },
		{ pattern = "使你的法術致命一擊等級提高(%d+)點", effect = "SPELLCRIT" },
		{ pattern = "使你的致命一擊等級提高(%d+)點", effect = {"CRIT","RANGEDCRIT"} },
		{ pattern = "致命一擊等級提高(%d+)", effect = {"CRIT","RANGEDCRIT"} },
		{ pattern = "使你的法術穿透提高(%d+)點", effect = "PENETRATION" },
		{ pattern = "使你的神聖系法術的致命一擊和極效治療機率提高(%d+)%%", effect = "HEALCRIT" },

		{ pattern = "使你的神聖系法術的致命一擊和極效治療機率提高(%d+)%%", effect = "HOLYCRIT" },
		{ pattern = "使你的神聖法術的致命一擊的機率提高(%d+)%%", effect = "HOLYCRIT" },
		{ pattern = "提高秘法法術和效果所造成的傷害，最多(%d+)點", effect = "ARCANEDMG" },
		{ pattern = "提高秘法法術和效果所造成的傷害，最多(%d+)點", effect = "ARCANEDMG" },
		{ pattern = "提高火焰法術和效果所造成的傷害，最多(%d+)點", effect = "FIREDMG" },
		{ pattern = "提高冰霜法術和效果所造成的傷害，最多(%d+)點", effect = "FROSTDMG" },

		{ pattern = "提高神聖法術和效果所造成的傷害，最多(%d+)點", effect = "HOLYDMG" },
		{ pattern = "提高自然法術和效果所造成的傷害，最多(%d+)點", effect = "NATUREDMG" },
		{ pattern = "提高暗影法術和效果所造成的傷害，最多(%d+)點", effect = "SHADOWDMG" },
		{ pattern = "使秘法法術和效果所造成的傷害提高最多(%d+)點", effect = "ARCANEDMG" },
		{ pattern = "使秘法法術所造成的傷害提高最多(%d+)點", effect = "ARCANEDMG" },
		{ pattern = "使火焰法術和效果所造成的傷害提高最多(%d+)點", effect = "FIREDMG" },

		{ pattern = "使火焰法術所造成的傷害提高最多(%d+)點", effect = "FIREDMG" },
		{ pattern = "使冰霜法術和效果所造成的傷害提高最多(%d+)點", effect = "FROSTDMG" },
		{ pattern = "使冰霜法術所造成的傷害提高最多(%d+)點", effect = "FROSTDMG" },
		{ pattern = "使神聖法術和效果所造成的傷害提高最多(%d+)點", effect = "HOLYDMG" },
		{ pattern = "使神聖法術所造成的傷害提高最多(%d+)點", effect = "HOLYDMG" },
		{ pattern = "使自然法術和效果所造成的傷害提高最多(%d+)點", effect = "NATUREDMG" },

		{ pattern = "使自然法術所造成的傷害提高最多(%d+)點", effect = "NATUREDMG" },
		{ pattern = "使暗影法術和效果所造成的傷害提高最多(%d+)點", effect = "SHADOWDMG" },
		{ pattern = "使暗影法術所造成的傷害提高最多(%d+)點", effect = "SHADOWDMG" },
		{ pattern = "使治療法術和效果所回復的生命值提高(%d+)點", effect = "HEAL" },
		{ pattern = "使治療法術和效果所回復的生命力提高(%d+)點", effect = "HEAL" },
		{ pattern = "使法術所造成的治療效果提高最多(%d+)點", effect = "HEAL" },

		{ pattern = "提高法術和魔法效果所造成的治療效果，最多(%d+)點", effect = "HEAL" },
		{ pattern = "使所有法術和魔法效果所造成的傷害和治療效果提高最多(%d+)點", effect = "DMG" },
		{ pattern = "使所有法術和魔法效果所造成的傷害和治療效果提高最多(%d+)點", effect = "HEAL" },
		{ pattern = "每+%d+秒恢復(%d+)點生命力", effect = "HEALTHREG" },
		{ pattern = "每+%d+秒回復(%d+)點生命力", effect = "HEALTHREG" },
		{ pattern = "每+%d+秒%+(%d+)生命力", effect = "HEALTHREG" },

		{ pattern = "每+%d+秒恢復(%d+)點法力", effect = "MANAREG" },
		{ pattern = "每+%d+秒回復(%d+)點法力", effect = "MANAREG" },
		{ pattern = "每+%d+秒%+(%d+)法力", effect = "MANAREG" },
		{ pattern = "使你的命中等級提高(%d+)點", effect = "TOHIT" },
		{ pattern = "提高命中等級(%d+)", effect = "TOHIT" },
		{ pattern = "使你的生命值和法力值回復提高(%d+)點", effect = {"HEALTHREG", "MANAREG"} },

		{ pattern = "使你的生命力和法力回復提高(%d+)點", effect = {"HEALTHREG", "MANAREG"} },
		{ pattern = "防禦等級提高(%d+)", effect = "DEFENSE" },
		{ pattern = "使防禦等級提高(%d+)點", effect = "DEFENSE" },
		{ pattern = "使你的法術命中等級提高(%d+)點", effect = "SPELLTOHITLV" },
		{ pattern = "使你的盾牌格擋值提高(%d+)點", effect = "BLOCKAMT" },
		{ pattern = "使你盾牌的格擋值提高(%d+)點", effect = "BLOCKAMT" },

		{ pattern = "擊中目標後有(%d+)%%的機率獲得1次額外的攻擊機會", effect = "XTRAHIT" },
		{ pattern = "使目標遭到重創，對其造成(%d+)點傷害", effect = "HIT_WOUND" },
		{ pattern = "向目標射出一支暗影箭，對其造成%d+到(%d+)點暗影傷害", effect = "HIT_SHADOW" },
		{ pattern = "向敵人發射一支暗影箭，對其造成(%d+)點暗影傷害", effect = "HIT_SHADOW" },
		{ pattern = "發射一枚火球攻擊目標，對其造成%d+到(%d+)點火焰傷害，並在%d+秒內造成額外的%d+點傷害", effect = "HIT_FIRE" },
		{ pattern = "發射一枚火球攻擊目標，對其造成%d+到%d+點火焰傷害，並在%d+秒內造成額外的(%d+)點傷害", effect = "HIT_FIRE_EX" },

		{ pattern = "對不死生物的攻擊強度提高(%d+)點", effect = "UNDEADAP" },
		{ pattern = "攻擊不死生物時+(%d+)點攻擊強度", effect = "UNDEADAP" },
		{ pattern = "提高法術和魔法效果對不死生物所造成的傷害，最多(%d+)點", effect = "UNDEADDMG" },
		{ pattern = "法術和魔法效果對亡靈造成的傷害提高最多(%d+)點", effect = "UNDEADDMG" },
		{ pattern = "使魔法和法術效果對亡靈造成的傷害提高最多(%d+)點", effect = "UNDEADDMG" },
		{ pattern = "對惡魔的攻擊強度提高(%d+) 點", effect = "ATTACKPOWEREVIL" },

	},

	SEPARATORS = { "/", "和", ",", "。", " 持續 ", "&", "及", "並", "，", },

	HEAL_AND_DMG_PATTERNS = {
	},
	
	GENERIC_PATTERNS = {
		["^%+?(%d+)%%?(.*)$"]	= true,
		["^(.*)%+ ?(%d+)%%?$"]	= false,
		["^(.*): ?(%d+)$"]		= false
	},

	PATTERNS_GENERIC_LOOKUP = {
		["所有屬性"] = ALL_STATS,
		["力量"] = "STR",

		["敏捷"] = "AGI",
		["耐力"] = "STA",
		["智力"] = "INT",
		["精神"] = "SPI",
		["所有抗性"] = ALL_RESISTS,
		["釣魚技能"] = "FISHING",

		["釣魚技能提高"] = "FISHING",
		["採礦"] = "MINING",
		["草藥學"] = "HERBALISM",
		["剝皮"] = "SKINNING",
		["防禦等級"] = "DEFENSE",
		["攻擊強度"] = "ATTACKPOWER",

		["對不死生物的攻擊強度"] = "ATTACKPOWERUNDEAD",
		["閃躲等級"] = "DODGE",
		["格擋機率等級"] = "BLOCK",
		["盾牌格擋"] = "BLOCKVALUE",
		["格擋值"] = "BLOCKVALUE",
		["命中等級"] = "TOHIT",

		["法術命中等級"] = "SPELLTOHIT",
		["遠程攻擊強度"] = "RANGEDATTACKPOWER",
		["治療法術"] = "HEAL",
		["治療"] = "HEAL",
		["治療和法術傷害"] = HEAL_AND_DMG,
		["法術治療和傷害"] = HEAL_AND_DMG,

		["法術傷害和治療"] = HEAL_AND_DMG,
		["傷害及治療法術"] = HEAL_AND_DMG,
		["法術傷害及治療"] = HEAL_AND_DMG,
		["法術傷害"] = "DMG",
		["致命一擊"] = "CRIT",
		["致命一擊等級"] = "CRIT",

		["生命力"] = "HEALTH",
		["法力"] = "MANA",
		["護甲"] = "BASE_ARMOR",
		["韌性等級"] = "CR_RESILIENCE",
		["法術穿透等級"] = "SPELLPEN",
		["法力恢復"] = "MANAREG",

		["武器傷害"] = "WEPDMG",

	},

	PATTERNS_GENERIC_STAGE1 = {
		{ pattern = "秘法", 	effect = "ARCANE" },
		{ pattern = "秘法", 	effect = "ARCANE" },

		{ pattern = "火焰", 	effect = "FIRE" },
		{ pattern = "冰霜", 	effect = "FROST" },
		{ pattern = "神聖", 	effect = "HOLY" },
		{ pattern = "暗影",	effect = "SHADOW" },
		{ pattern = "陰影",	effect = "SHADOW" },
		{ pattern = "自然", 	effect = "NATURE" }

	},

	PATTERNS_GENERIC_STAGE2 = {
		{ pattern = "抗性", 	effect = "RES" },
		{ pattern = "傷害", 	effect = "DMG" }
	},


	PATTERNS_OTHER = {
		{ pattern = "強化%(%+(%d+)護甲%)", effect = "ARMOR_BONUS" },
		{ pattern = "每%d秒回復(%d+)點法力", effect = "MANAREG" },

		{ pattern = "初級巫師之油", effect = HEAL_AND_DMG, value = 8 },
		{ pattern = "次級巫師之油", effect = HEAL_AND_DMG, value = 16 },
		{ pattern = "巫師之油", effect = HEAL_AND_DMG, value = 24 },

		{ pattern = "卓越巫師之油", effect = {"DMG", "HEAL", "SPELLCRIT"}, value = {36, 36, 1} },

		{ pattern = "初級法力之油", effect = "MANAREG", value = 4 },
		{ pattern = "次級法力之油", effect = "MANAREG", value = 8 },
		{ pattern = "卓越法力之油", effect = { "MANAREG", "HEAL"}, value = {12, 25} },

		{ pattern = "每%d秒恢復(%d+)點法力", effect = "MANAREG" },

		{ pattern = "魚餌 %+(%d+)（%d分鐘）", effect = "FISHING" },
		{ pattern = "每%d秒回復(%d+)點生命力", effect = "HEALTHREG" },
		{ pattern = "每%d秒恢復(%d+)點生命力", effect = "HEALTHREG" },
		{ pattern = "贊達拉力量徽記", effect = "ATTACKPOWER", value = 30 },
		{ pattern = "贊達拉魔精徽記", effect = {"DMG", "HEAL"}, value = 18 },
		{ pattern = "贊達拉寧靜徽記", effect = "HEAL", value = 33 },

		{ pattern = "瞄準鏡（%+(%d+) 傷害）", effect = "RANDMG" },
		{ pattern = "對不死族%+(%d+)法術傷害（%d分鐘）", effect = "UNDEADDMG"},
		{ pattern = "%+(%d+) 命中等級", effect = "HIT"},
		{ pattern = "%+30 遠程命中等級", effect = "CR_RANGEDHIT", value = 30 },
	},
}
