if GetLocale() ~= "deDE" then return end

local lib = LibStub("LibItemBonus-2.0")
local ALL_RESISTS = {"ARCANERES", "FIRERES", "FROSTRES", "NATURERES", "SHADOWRES"}
local ALL_STATS = {"STR", "AGI", "STA", "INT", "SPI"}
local HEAL_AND_DMG = {"HEAL", "DMG"}

lib.patterns = {
	NAMES = {
		STR = "Stärke",
		AGI = "Beweglichkeit",
		STA = "Ausdauer",
		INT = "Intelligenz",
		SPI = "Willenskraft",
		ARMOR = "Rüstung",
		BASE_ARMOR = "Rüstung",
		ARMOR_BONUS = "Verstärkte Rüstung",

		ARCANERES = "Arkanwiderstand",
		FIRERES = "Feuerwiderstand",
		NATURERES = "Naturwiderstand",
		FROSTRES = "Frostwiderstand",
		SHADOWRES = "Schattenwiderstand",

		FISHING = "Angeln",
		MINING = "Bergbau",
		HERBALISM = "Kräuterkunde",
		SKINNING = "Kürschnerei",
		DEFENSE = "Verteidigung",

		BLOCK = "Blockchance",
		BLOCKVALUE = "Blockwert",
		DODGE = "Ausweichen",
		PARRY = "Parieren",
		ATTACKPOWER = "Angriffskraft",
		ATTACKPOWERUNDEAD = "Angriffskraft gegen Untote",
		ATTACKPOWERFERAL = "Angriffskraft in Tierform",
		CRIT = "krit. Treffer",
		RANGEDATTACKPOWER = "Distanzangriffskraft",
		RANGEDCRIT = "krit. Schuss",
		TOHIT = "Trefferchance",
		IGNOREARMOR = "Ignorierte Rüstung",
		THREATREDUCTION = "Reduzierte Bedrohung",
		
		DMG = "Zauberschaden",
		DMGUNDEAD = "Zauberschaden gegen Untote",
		ARCANEDMG = "Arkanschaden",
		FIREDMG = "Feuerschaden",
		FROSTDMG = "Frostschaden",
		HOLYDMG = "Heiligschaden",
		NATUREDMG = "Naturschaden",
		SHADOWDMG = "Schattenschaden",
		HOLYCRIT = "krit. Heiligzauber",
		SPELLCRIT = "krit. Zauber",
		SPELLTOHIT = "Zaubertrefferchance",
		SPELLPEN = "Zauberdurchschlag",
		HEAL = "Heilung",
		HEALTHREG = "Lebensregeneration",
		MANAREG = "Manaregeneration",
		HEALTH = "Lebenspunkte",
		MANA = "Manapunkte",

		CR_WEAPON = "Waffenwertung",
		CR_DEFENSE = "Verteidigungswertung",
		CR_DODGE = "Ausweichwertung",
		CR_PARRY = "Parrierwertung",
		CR_BLOCK = "Blockwertung",
		CR_HIT = "Trefferwertung",
		CR_RANGEDHIT = "Distanztrefferwertung",
		CR_CRIT = "kritische Trefferwertung",
		CR_HASTE = "Angriffsgeschwindigkeit",
		CR_SPELLHIT = "Zaubertrefferwertung",
		CR_SPELLCRIT = "kritische Zaubertrefferwertung",
		CR_SPELLHASTE = "Zaubergeschwindigkeit",
		CR_RANGEDHASTE = "Fernkampfgeschwindigkeit",
		CR_RESILIENCE = "Abhärtungswertung",
	},

	PATTERNS_SKILL_RATING = {},
	SKILL_NAMES = {},

	PATTERNS_PASSIVE = {
		{ pattern = "%+(%d+) bei allen Widerstandsarten%.", effect = ALL_RESISTS },
		{ pattern = "+(%d+) Distanzangriffskraft.", effect = "RANGEDATTACKPOWER" },
		{ pattern = "Erhöht Eure Chance, Angriffe mit einem Schild zu blocken, um (%d+)%%%.", effect = "BLOCK" },
		{ pattern = "Erhöht den Blockwert Eures Schildes um (%d+)%.", effect = "BLOCKVALUE" },
		{ pattern = "Erhöht Eure Chance, einem Angriff auszuweichen, um (%d+)%%%.", effect = "DODGE" },
		{ pattern = "Erhöht Eure Chance, einen Angriff zu parieren, um (%d+)%%%.", effect = "PARRY" },
		{ pattern = "Erhöht Eure Chance, einen kritischen Treffer durch Zauber zu erzielen, um (%d+)%%%.", effect = "SPELLCRIT" },
		{ pattern = "Erhöht Eure Chance, einen kritischen Treffer durch Heiligzauber zu erzielen, um (%d+)%%%.", effect = "HOLYCRIT" },
		{ pattern = "Erhöht Eure Chance, einen kritischen Treffer zu erzielen, um (%d+)%%%.", effect = "CRIT" },
		{ pattern = "Erhöht Eure Chance, mit Fernkampfwaffen einen kritischen Treffer zu erzielen, um (%d+)%.", effect = "RANGEDCRIT" },
		{ pattern = "Erhöht durch Arkanzauber und Arkaneffekte zugefügten Schaden um bis zu (%d+)%.", effect = "ARCANEDMG" },
		{ pattern = "Erhöht durch Feuerzauber und Feuereffekte zugefügten Schaden um bis zu (%d+)%.", effect = "FIREDMG" },
		{ pattern = "Erhöht durch Frostzauber und Frosteffekte zugefügten Schaden um bis zu (%d+)%.", effect = "FROSTDMG" },
		{ pattern = "Erhöht durch Heiligzauber und Heiligeffekte zugefügten Schaden um bis zu (%d+)%.", effect = "HOLYDMG" },
		{ pattern = "Erhöht durch Naturzauber und Natureffekte zugefügten Schaden um bis zu (%d+)%.", effect = "NATUREDMG" },
		{ pattern = "Erhöht durch Schattenzauber und Schatteneffekte zugefügten Schaden um bis zu (%d+)%.", effect = "SHADOWDMG" },
		{ pattern = "Erhöht durch Zauber und Effekte verursachte Heilung um bis zu (%d+)%.", effect = "HEAL" },
		{ pattern = "Erhöht durch sämtliche Zauber und magische Effekte verursachte Heilung um bis zu (%d+) und den verursachten Schaden um bis zu (%d+)%.", effect = HEAL_AND_DMG },
		{ pattern = "Erhöht durch Zauber und magische Effekte zugefügten Schaden und Heilung um bis zu (%d+)%.", effect = HEAL_AND_DMG },
		{ pattern = "Erhöht durch Zauber und magische Effekte verursachten Schaden und Heilung um bis zu (%d+)%.", effect = HEAL_AND_DMG },
		{ pattern = "Erhöht den durch magische Zauber und magische Effekte zugefügten Schaden gegen Untote um bis zu (%d+)%.", effect = "DMGUNDEAD", nofinish = true },
		{ pattern = "Erhöht die Angriffskraft im Kampf gegen Untote um (%d+)%.", effect = "ATTACKPOWERUNDEAD", nofinish = true },
		{ pattern = "Erhöht die Angriffskraft im Kampf gegen Untote um (%d+)%. Ermöglicht das Einsammeln von Geißelsteinen im Namen der Agentumdämmerung", effect = "ATTACKPOWERUNDEAD" },
		{ pattern = "Stellt alle 5 Sek%. (%d+) Gesundheit wieder her%.", effect = "HEALTHREG" },
		{ pattern = "Stellt alle 5 Sek%. (%d+) Mana wieder her%.", effect = "MANAREG" },
		{ pattern = "Verbessert Eure Trefferchance um (%d+)%%%.", effect = "TOHIT" },
		{ pattern = "Reduziert die Magiewiderstände der Ziele Eurer Zauber um (%d+)%.", effect = "SPELLPEN" },

		{ pattern = ".+ Angriffstempowertung um (%d+)", effect = "CR_HASTE"},
		{ pattern = "Erhöht Eure Angriffstempowertung %d Sek%. lang um (%d+)%.", effect = "CR_HASTE"},
		{ pattern = ".+ Zaubertempowertung um (%d+)", effect = "CR_SPELLHASTE"},
		{ pattern = ".+ Distanztempowertung um (%d+)%.", effect = "CR_RANGEDHASTE"},
		{ pattern = "Eure Angriffe ignorieren (%d+) R\195\188stung Eures Gegners%.", effect = "IGNOREARMOR"},
		{ pattern = "Erhöht Tempowertung um (%d+)%.", effect = "CR_HASTE"},

		-- Atiesh related patterns
		{ pattern = "Erhöht Euren Zauberschaden um bis zu (%d+) und Eure Heilung um bis zu (%d+)%.", effect = {"DMG","HEAL"} },
		{ pattern = "Erhöht durch Zauber und magische Effekte verursachte Heilung aller Gruppenmitglieder, die sich im Umkreis von %d+ Metern befinden, um bis zu (%d+)%.", effect = "HEAL" },
		{ pattern = "Erhöht durch Zauber und magische Effekte verursachte Schaden und Heilung aller Gruppenmitglieder, die sich im Umkreis von %d+ Metern befinden, um bis zu (%d+)%.", effect = HEAL_AND_DMG },
		{ pattern = "Stellt alle 5 Sek. (%d+) Mana bei allen Gruppenmitgliedern, die sich im Umkreis von %d+ Metern befinden, wieder her.", effect = "MANAREG" },
		{ pattern = "Erhöht die kritische Zaubertrefferwertung aller Gruppenmitglieder innerhalb von %d+ Metern um (%d+)%.", effect = "SPELLCRIT" },

		-- Added for HealPoints
		{ pattern = "Ermöglicht, das (%d+)%% Eurer Manaregeneration während des Zauberwirkens weiter läuft%.", effect = "CASTINGREG"},
		-- { pattern = "Improves your chance to get a critical strike with Nature spells by (%d+)%%%.", effect = "NATURECRIT"},
		-- { pattern = "Reduces the casting time of your Regrowth spell by 0%.(%d+) sec%.", effect = "CASTINGREGROWTH"},
		-- { pattern = "Reduces the casting time of your Holy Light spell by 0%.(%d+) sec%.", effect = "CASTINGHOLYLIGHT"},
		-- { pattern = "Reduces the casting time of your Healing Touch spell by 0%.(%d+) sec%.", effect = "CASTINGHEALINGTOUCH"},
		-- { pattern = "%-0%.(%d+) sec to the casting time of your Flash Heal spell%.", effect = "CASTINGFLASHHEAL"},
		-- { pattern = "%-0%.(%d+) seconds on the casting time of your Chain Heal spell%.", effect = "CASTINGCHAINHEAL"},
		-- { pattern = "Increases the duration of your Rejuvenation spell by (%d+) sec%.", effect = "DURATIONREJUV"},
		-- { pattern = "Increases the duration of your Renew spell by (%d+) sec%.", effect = "DURATIONRENEW"},
		-- { pattern = "Increases your normal health and mana regeneration by (%d+)%.", effect = "MANAREGNORMAL"},
		-- { pattern = "Increases the amount healed by Chain Heal to targets beyond the first by (%d+)%%%.", effect = "IMPCHAINHEAL"},
		{ pattern = "Erhöht den Effekt eures Zaubers Verjüngung um (%d+)%.", effect = "IMPREJUVENATION"},
		-- { pattern = "Increases healing done by Lesser Healing Wave by up to (%d+)%.", effect = "IMPLESSERHEALINGWAVE"},
		{ pattern = "Erhöht den durch Eure Zauber Heiliges Licht und Lichtblitz geheilten Wert um (%d+)%.", effect = "IMPFLASHOFLIGHT"},
		-- { pattern = "After casting your Healing Wave or Lesser Healing Wave spell%, gives you a 25%% chance to gain Mana equal to (%d+)%% of the base cost of the spell%.", effect = "REFUNDHEALINGWAVE"},
		-- { pattern = "Your Healing Wave will now jump to additional nearby targets%. Each jump reduces the effectiveness of the heal by (%d+)%%%, and the spell will jump to up to two additional targets%.", effect = "JUMPHEALINGWAVE"},
		-- { pattern = "Reduces the mana cost of your Healing Touch%, Regrowth%, Rejuvenation and Tranquility spells by (%d+)%%%.", effect = "CHEAPERDRUID"},
		-- { pattern = "On Healing Touch critical hits%, you regain (%d+)%% of the mana cost of the spell%.", effect = "REFUNDHTCRIT"},
		{ pattern = "Erhöht den durch euren Zauber Erneuerung geheilten Wert um (%d+)%%%.", effect = "CHEAPERRENEW"},

		-- Combat Rating
		{ pattern = "Erhöht Eure Trefferwertung um (%d+)%.", effect = "CR_HIT" },
		{ pattern = "Erhöht Eure kritische Trefferwertung um (%d+)%.", effect = "CR_CRIT" },
		{ pattern = "Erhöht Eure Distanztrefferwertung um (%d+)%.", effect = "CR_RANGEDHIT" },
		{ pattern = "Erhöht die Verteidigungswertung um (%d+)%.", effect = "CR_DEFENSE" },
		{ pattern = "Erhöht Eure kritische Zaubertrefferwertung um (%d+)%.", effect = "CR_SPELLCRIT" },
		{ pattern = "Erhöht Eure Abhärtungswertung um (%d+)%.", effect = "CR_RESILIENCE" },
		{ pattern = "Erhöht Eure Zaubertrefferwertung um (%d+)%.", effect = "CR_SPELLHIT" },
		{ pattern = "Erhöht Trefferwertung um (%d+)%.", effect = "CR_HIT" },
		{ pattern = "Erhöht kritische Trefferwertung um (%d+)%.", effect = "CR_CRIT" },
		{ pattern = "Erhöht Eure Ausweichwertung um (%d+)%.", effect = "CR_DODGE" },
		{ pattern = "Erhöht Eure Blockwertung um (%d+)%.", effect = "CR_BLOCK" },
		{ pattern = "Erhöht Eure Parrierwertung um (%d+)%.", effect = "CR_PARRY" },
		{ pattern = "Erhöht die Fertigkeitswertung für Äxte um (%d+)%.", effect = "CR_WEAPON_AXE" },
		{ pattern = "Erhöht die Fertigkeitswertung für Dolche um (%d+)%.", effect = "CR_WEAPON_DAGGER" },
		{ pattern = "Erhöht die Fertigkeitswertung für Streitkolben um (%d+)%.", effect = "CR_WEAPON_MACE" },
		{ pattern = "Erhöht die Fertigkeitswertung für Schwerter um(%d+)%.", effect = "CR_WEAPON_SWORD" },
		{ pattern = "Erhöht die Fertigkeitswertung für Zweihandschwerter um (%d+)%.", effect = "CR_WEAPON_SWORD_2H" },
		{ pattern = "Erhöht die Fertigkeitswertung für Bögen um (%d+)%.", effect = "CR_WEAPON_BOW" },
		{ pattern = "Erhöht die Fertigkeitswertung für Armbrüste um (%d+)%.", effect = "CR_WEAPON_XBOW" },
		{ pattern = "Erhöht die Fertigkeitswertung für Schusswaffen um (%d+)%.", effect = "CR_WEAPON_GUN" },
		{ pattern = "Erhöht die Fertigkeitswertung für unbewaffneten Kampf um (%d+)%.", effect = "CR_WEAPON_FIST" },
		{ pattern = "Erhöht die Fertigkeitswertung für Stäbe um (%d+)%.", effect = "CR_WEAPON_STAFF" },
		{ pattern = "Erhöht die Fertigkeitswertung für Zweihandäxte um (%d+)%.", effect = "CR_WEAPON_AXE_2H" },
		{ pattern = "Erhöht die Fertigkeitswertung für Zweihandstreitkolben um (%d+)%.", effect = "CR_WEAPON_MACE_2H" },
		{ pattern = "Erhöht die Fertigkeitswertung für Stangenwaffen um (%d+)%.", effect = "CR_WEAPON_POLEARM" },


		-- Updated Patterns (in 2.0)
		{ pattern = "Verringert den Widerstand des Ziels gegen Eure Zauber um (%d+)%.", effect = "SPELLPEN" },
		{ pattern = "Verbessert Eure Angriffskraft um (%d+)%.", effect = "ATTACKPOWER" },
		{ pattern = "Erhöht die Angriffskraft um (%d+)%.", effect = "ATTACKPOWER" },
		{ pattern = "Erhöht die Angriffskraft in Katzengestalt, Bärengestalt, Terrorbärengestalt oder Mondkingestalt um (%d+)%.", effect = "ATTACKPOWERFERAL" },
	},

	SEPARATORS = { "/", ",", "&", " und " },

	HEAL_AND_DMG_PATTERNS = {
		["%+(%d+) Heilung und %+(%d+) Zauberschaden"] = false,
		["%+(%d+) Heilzauber und %+(%d+) Schadenszauber"] = false,
		["%+(%d+) Heilung %+(%d+) Zauberschaden"] = false,
	},

	GENERIC_PATTERNS = {
		["^%+?(%d+)%%?(.*)$"]	= true,
		["^(.*)%+ ?(%d+)%%?$"]	= false,
		["^(.*): ?(%d+)$"]		= false
	},

	PATTERNS_GENERIC_LOOKUP = {
		["Alle Werte"] = ALL_STATS,
		["Stärke"] = "STR",
		["Beweglichkeit"] = "AGI",
		["Ausdauer"] = "STA",
		["Intelligenz"] = "INT",
		["Willenskraft"] = "SPI",

		["Alle Widerstandsarten"] = ALL_RESISTS,

		["Angeln"] = "FISHING",
		["Angelköder"] = "FISHING",
		["Bergbau"] = "MINING",
		["Kräuterkunde"] = "HERBALISM",
		["Kürschnerei"] = "SKINNING",
		["Verteidigung"] = "DEFENSE",
		["Verteidigungsfertigkeit"] = "DEFENSE",

		["Angriffskraft"] = "ATTACKPOWER",
		["Angriffskraft gegen Untote"] = "ATTACKPOWERUNDEAD",
		["Angriffskraft in Katzengestalt, Bärengestalt oder Terrorbärengestalt"] = "ATTACKPOWERFERAL",
		["Ausweichen"] = "DODGE",
		["Blocken"] = "BLOCK",
		["Blockwert"] = "BLOCKVALUE",
		["Trefferchance"] = "TOHIT",
		["Distanzangriffskraft"] = "RANGEDATTACKPOWER",
		["Gesundheit alle 5 Sek"] = "HEALTHREG",
		["Heilzauber"] = "HEAL",
		["Erhöht Heilung"] = "HEAL",
		["Mana alle 5 Sek"] = "MANAREG",
		["Manaregeneration"] = "MANAREG",
		["Zauberschaden erhöhen"]= "DMG",
		["Kritischer Treffer"] = "CRIT",
		["Zauberschaden"] = HEAL_AND_DMG,
		["Blocken"] = "BLOCK",
		["Gesundheit"] = "HEALTH",
		["HP"] = "HEALTH",
		["Heilung und Zauberschaden"] = HEAL_AND_DMG,
		["Zauberschaden und Heilung"] = HEAL_AND_DMG,
		["Schadenszauber und Heilzauber"] = HEAL_AND_DMG,
		["Schadens- und Heilzauber"] = HEAL_AND_DMG,
		["Zaubertrefferchance"] = "SPELLTOHIT",
		["Mana"] = "MANA",
		["Rüstung"] = "BASE_ARMOR",
		["Verstärkte Rüstung"]= "ARMOR_BONUS",
		["Reduzierte Bedrohung"] = "THREATREDUCTION",
	},

	PATTERNS_GENERIC_STAGE1 = {
		{ pattern = "Arkan", effect = "ARCANE" },
		{ pattern = "Feuer", effect = "FIRE" },
		{ pattern = "Frost", effect = "FROST" },
		{ pattern = "Heilig", effect = "HOLY" },
		{ pattern = "Schatten", effect = "SHADOW" },
		{ pattern = "Natur", effect = "NATURE" },
	},

	PATTERNS_GENERIC_STAGE2 = {
		{ pattern = "widerst", effect = "RES" },
		{ pattern = "schaden", effect = "DMG" },
		{ pattern = "effekte", effect = "DMG" },
	},

	PATTERNS_OTHER = {
		{ pattern = "Manaregeneration (%d+) pro 5 Sek%.", effect = "MANAREG" },

		{ pattern = "Zandalarianisches Siegel der Macht", effect = "ATTACKPOWER", value = 30 },
		{ pattern = "Zandalarianisches Siegel des Mojo", effect = HEAL_AND_DMG, value = 18 },
		{ pattern = "Zandalarianisches Siegel der Inneren Ruhe", effect = "HEAL", value = 33 },

		{ pattern = "Schwaches Zauberöl", effect = HEAL_AND_DMG, value = 8 },
		{ pattern = "Geringes Zauberöl", effect = HEAL_AND_DMG, value = 16 },
		{ pattern = "Zauberöl", effect = HEAL_AND_DMG, value = 24 },
		{ pattern = "Hervorragendes Zauberöl", effect = {"DMG", "HEAL", "CR_SPELLCRIT"}, value = {36, 36, 14} },
		{ pattern = "Überragendes Zauberöl", effect = HEAL_AND_DMG, value = 42 },

		{ pattern = "Schwaches Manaöl", effect = "MANAREG", value = 4 },
		{ pattern = "Geringes Manaöl", effect = "MANAREG", value = 8 },
		{ pattern = "Hervorragendes Manaöl", effect = { "MANAREG", "HEAL"}, value = {12, 25} },
		{ pattern = "Überragendes Manaöl", effect = "MANAREG", value = 14 },

		{ pattern = "Eterniumangelschnur", effect = "FISHING", value = 5 },
		{ pattern = "%+30 Distanztrefferwertung", effect = "CR_RANGEDHIT", value = 30 }, --Biznicks 247x128 Accurascope
		{ pattern = "Vitalität", effect = {"MANAREG", "HEALTHREG"}, value = {4, 4} },
		{ pattern = "Seelenfrost", effect = {"FROSTDMG", "SHADOWDMG"}, value = {54, 54} },
		{ pattern = "Sonnenfeuer", effect = {"ARCANEDMG", "FIREDMG"}, value = {50, 50} },
		{ pattern = "Unbändigkeit", effect = "ATTACKPOWER", value = 70 },
		{ pattern = "Sicherer Stand", effect = {"CR_HIT", "SNARERES"}, value = {10, 5} },
		{ pattern = "%+2%% Bedrohung", effect = "THREATREDUCTION", value = -2 },
		{ pattern = "Feingefühl", effect = "THREATREDUCTION", value = 2 },

	}
}
