﻿--[[
	Thank you for trying out Wan-Wan!

	Feel free to let me know of any bugs or other errors via comments on the Curse website. 
	A personal message is also acceptable. Please make sure to post the whole error message.
	I will get it fixed as soon as I can.

	Questions? Comments? Suggestions? Please, send them my way! I am open to constructive criticism.

	Regards,
	Cammy Bear.
]]


WanWan_script = 
{
	CLASS_DRUID = "DRUID",
	CLASS_SHAMAN = "SHAMAN",

	ERROR_ADJUST_TAIL = [==[|cff800000Error:|r The "adjust" option must be paired with a valid number.]==],
	ERROR_BAD_TOPIC = [==[|cff800000Error:|r No topics like that are available.]==],
	ERROR_SLASH_COMMAND = [==[|cff800000Error:|r Bad option(s). Use "|cff22b14c/wanwan ?|r" to see a list of acceptable commands.]==],
	
	MSG_ADJUST_OKAY1 = [==[Successfully adjusted the wait time to ]==],
	MSG_ADJUST_OKAY2 = [==[ seconds!]==],
	MSG_ADJUST_FAIL = [==[|cff800000Error:|r That number is not within a permissible range.]==],
	MSG_GREETING = [==[Wan-Wan! has successfully loaded! Type "|cff22b14c/wanwan ?|r" for some help with commands.]==],
	--MSG_HELP_ABOUT = [==[This 'about' option will show the "About" page if it is hidden -- otherwise, it will hide it.]==],
	MSG_HELP_ADJUST = [==[Use the 'adjust' or 'a' option followed by a number between 1 and 20 (inclusive) to set the number of seconds to wait before making another extra sound. (NOTE: Combat and friendly-NPC wait times are separate!)]==],
	MSG_HELP_RESET = [==[The 'reset' or 'r' option irreversibly sets all saved settings to their defaults.]==],
	MSG_HELP_SPAM = [==[The 'spam' or 's' option simply enables/disables the login greeting.]==],
	MSG_RESET = [==[Settings for Wan-Wan! were reset!]==],
	MSG_SPAM_DISABLED = [==[Wan-Wan! has had its login greeting |cff800000disabled|r.]==],
	MSG_SPAM_ENABLED = [==[Wan-Wan! has had its login greeting |cff008000enabled|r.]==],
	MSG_TOGGLE_DISABLED = [==[Wan-Wan! has been |cff800000disabled|r. You will not make any extra sounds.]==],
	MSG_TOGGLE_ENABLED = [==[Wan-Wan! has been |cff008000enabled|r. You will make extra sounds in feral form.]==],
	
	RACE_TROLL = "Troll",
	
	SPAM_MAIN_TOGGLE = [==["|cff22b14c/wanwan|r" > Toggle the extra feral sounds on/off.]==],
	SPAM_SPAM_TOGGLE = [==["|cff22b14c/wanwan spam|r" > Toggle the login greeting on/off.]==],
	SPAM_RESET_TOGGLE = [==["|cff22b14c/wanwan reset|r" > Reset Wan-Wan! settings to their defaults.]==],
	SPAM_ADJUST_TOGGLE = [==["|cff22b14c/wanwan adjust x|r" > Adjust the wait time when making extra sounds by 'x' seconds.]==],
	SPAM_HELP1_SPAM = [==["|cff22b14c/wanwan ?|r" > Display these messages.]==],
	SPAM_HELP2_SPAM = [==["|cff22b14c/wanwan ? topic|r" > Get more help on a specific 'topic'.]==],
	SPAM_HELP3_SPAM = [==[Help topics: |cff22b14cspam|r, |cff22b14creset|r, |cff22b14cadjust|r.]==],
	--SPAM_ABOUT_SPAM = [==["|cff22b14c/wanwan about|r" > Show/Hide the "About" page.]==],
	--SPAM_HELP3_SPAM = [==[Help topics: |cff22b14cspam|r, |cff22b14creset|r, |cff22b14cadjust|r, |cff22b14cabout|r.]==],
	SPAM_BOWWOW_SPAM = [==[You can always use "|cff22b14c/bowwow|r" instead.]==],
};

WanWan_form = nil;

WanWan_MIN_COUNT = 1;
WanWan_MAX_COUNT = 20;

local BattleCount = nil;
local Count = nil;
local IsBattleReady = true;
local IsReady = true;

local Defaults = {
	Count_Max = 5,
	Enabled = true,
	Spam = true,
	Version = 4.0,
};

local Options = {};

local CurrentVersion = 4.0;
local TimeSinceLastUpdate = 0;
local UpdateInterval = 1.0;

local GlyphEnabled_Cheetah = false;
local GlyphEnabled_Orca = false;
local GlyphEnabled_Spectral = false;
local GlyphEnabled_Stars = false;

local WanWan_GlyphOfTheCheetah_ID = 131113;
local WanWan_GlyphOfTheOrca_ID = 114333;
local WanWan_GlyphOfTheSpectralWolf_ID = 58135;
local WanWan_GlyphOfStars_ID = 114301;

local WanWan_TreantForm_spellID = 114282;

local Events = {
	"AUCTION_HOUSE_SHOW",
	"BANKFRAME_OPENED",
	"BATTLEFIELDS_SHOW",
	"FORGE_MASTER_OPENED",
	"GOSSIP_SHOW",
	"LFG_OPEN_FROM_GOSSIP",
	"MERCHANT_SHOW",
	"QUEST_GREETING",
	"TAXIMAP_OPENED",
	"TRAINER_SHOW",
};

local Sounds = {
	["Bat"] = {
		[1] = "Sound\\Creature\\Felbat\\FelbatAttackA.ogg",
		[2] = "Sound\\Creature\\Felbat\\FelbatAttackB.ogg",
		[3] = "Sound\\Creature\\Felbat\\FelbatAttackC.ogg",
		[4] = "Sound\\Creature\\Felbat\\FelbatPreAggro.ogg",
	},
	["Bear"] = {
		[1] = "Sound\\Creature\\Bear\\MBearAttackA.ogg",
		[2] = "Sound\\Creature\\Bear\\MBearAttackB.ogg",
		[3] = "Sound\\Creature\\Bear\\MBearAttackD.ogg",
		[4] = "Sound\\Creature\\Bear\\MBearAttackCriticalA.ogg",
		["Aggro"] = "Sound\\Creature\\Bear\\MBearAggroA.ogg",
	},
	["Cat"] = {
		[1] = "Sound\\Creature\\Tiger\\MTigerAttackA.ogg",
		[2] = "Sound\\Creature\\Tiger\\MTigerAttackB.ogg",
		[3] = "Sound\\Creature\\Tiger\\MTigerAttackC.ogg",
		[4] = "Sound\\Creature\\Tiger\\MTigerAttackD.ogg",
		["Aggro"] = "Sound\\Creature\\Tiger\\MTigerDeathA.ogg",
	},
	["Crow"] = {
		[1] = "Sound\\Creature\\StormCrow\\StormCrowAttackA.ogg",
		[2] = "Sound\\Creature\\StormCrow\\StormCrowAttackB.ogg",
		[3] = "Sound\\Creature\\StormCrow\\StormCrowAttackC.ogg",
		[4] = "Sound\\Creature\\StormCrow\\StormCrowPreAggro.ogg",
	},
	["Moonkin"] = {
		[1] = "Sound\\Creature\\ForceOfNature\\ForceOfNatureAttack.ogg",
		[2] = "Sound\\Creature\\ForceOfNature\\ForceOfNatureAttackB.ogg",
		[3] = "Sound\\Creature\\ForceOfNature\\ForceOfNatureAttackC.ogg",
		["Aggro"] = "Sound\\Creature\\ForceOfNature\\ForceOfNatureAggro.ogg",
	},
	["Orca"] = {
		[1] = "Sound\\Creature\\Orca\\OrcaAttackA.ogg",
		[2] = "Sound\\Creature\\Orca\\OrcaAttackB.ogg",
		[3] = "Sound\\Creature\\Orca\\OrcaAttackC.ogg",
		[4] = "Sound\\Creature\\Orca\\OrcaPreAggro.ogg",
		["Aggro"] = "Sound\\Creature\\Orca\\OrcaAggro.ogg",
	},
	["Spectral Wolf"] = {
		[1] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAttackA.ogg",
		[2] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAttackB.ogg",
		[3] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAttackC.ogg",
		[4] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAttackD.ogg",
		[5] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAttackE.ogg",
		[6] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAttackF.ogg",
		["Aggro"] = "Sound\\Creature\\Wolf_Ghost\\GhostWolfAggro3.ogg",
	},
	["Stag"] = {
		[1] = "Sound\\Creature\\Giraffe\\GiraffeAttackA.ogg",
		[2] = "Sound\\Creature\\Giraffe\\GiraffeAttackB.ogg",
		[3] = "Sound\\Creature\\Giraffe\\GiraffeAttackC.ogg",
		[4] = "Sound\\Creature\\Giraffe\\GiraffePreAggroA.ogg",
		["Aggro"] = "Sound\\Creature\\Giraffe\\GiraffeAggroA.ogg",
	},
	["Treant"] = {
		[1] = "Sound\\Creature\\Ent\\EntAttackA.ogg",
		[2] = "Sound\\Creature\\Ent\\EntAttackB.ogg",
		[3] = "Sound\\Creature\\Ent\\EntAttackC.ogg",
		[4] = "Sound\\Creature\\Ent\\EntAttackD.ogg",
		["Aggro"] = "Sound\\Creature\\Ent\\EntAggroA.ogg",
	},
	["Walrus"] = {
		[1] = "Sound\\Creature\\Walrus\\WalrusAttackA.ogg",
		[2] = "Sound\\Creature\\Walrus\\WalrusAttackB.ogg",
		[3] = "Sound\\Creature\\Walrus\\WalrusAttackC.ogg",
		[4] = "Sound\\Creature\\Walrus\\WalrusPreAggroA.ogg",
		["Aggro"] = "Sound\\Creature\\Walrus\\WalrusAggroA.ogg",
	},
	["Wolf"] = {
		[1] = "Sound\\Creature\\Wolf\\MWolfAttack1.ogg",
		[2] = "Sound\\Creature\\Wolf\\MWolfAttack2.ogg",
		[3] = "Sound\\Creature\\Wolf\\MWolfAttack3.ogg",
		[4] = "Sound\\Creature\\Wolf\\MWolfAttack4.ogg",
		[5] = "Sound\\Creature\\Wolf\\MWolfAttack5.ogg",
		[6] = "Sound\\Creature\\Wolf\\MWolfAttack6.ogg",
		["Aggro"] = "Sound\\Creature\\Wolf\\MWolfAggro3.ogg",
	},
};

function WanWan_checkGlyphs()
	GlyphEnabled_Cheetah = false;
	GlyphEnabled_Orca = false;
	GlyphEnabled_Spectral = false;
	GlyphEnabled_Stars = false;
	
	for i = 1, NUM_GLYPH_SLOTS, 1 do
		local spellID = select(4, GetGlyphSocketInfo(i));
		if(spellID) then
			if(spellID == WanWan_GlyphOfTheCheetah_ID) then
				GlyphEnabled_Cheetah = true;
			elseif(spellID == WanWan_GlyphOfTheOrca_ID) then
				GlyphEnabled_Orca = true;
			elseif(spellID == WanWan_GlyphOfTheSpectralWolf_ID) then
				GlyphEnabled_Spectral = true;
			elseif(spellID == WanWan_GlyphOfStars_ID) then
				GlyphEnabled_Stars = true;
			end
		end
	end
end

function WanWan_help(subject)
	if(not subject) then
		print(WanWan_script.SPAM_MAIN_TOGGLE);
		print(WanWan_script.SPAM_SPAM_TOGGLE);
		print(WanWan_script.SPAM_RESET_TOGGLE);
		print(WanWan_script.SPAM_ADJUST_TOGGLE);
		print(WanWan_script.SPAM_HELP1_SPAM);
		print(WanWan_script.SPAM_HELP2_SPAM);
		print(WanWan_script.SPAM_HELP3_SPAM);
		--print(WanWan_script.SPAM_ABOUT_SPAM);
		print(WanWan_script.SPAM_BOWWOW_SPAM);
	--[[
	elseif(strlower(subject) == "about") then
		print(WanWan_script.MSG_HELP_ABOUT);
	]]
	elseif((strlower(subject) == "adjust") or (strlower(subject) == "a")) then
		print(WanWan_script.MSG_HELP_ADJUST);
	elseif((strlower(subject) == "reset") or (strlower(subject) == "r")) then
		print(WanWan_script.MSG_HELP_RESET);
	elseif((strlower(subject) == "spam") or (strlower(subject) == "s")) then
		print(WanWan_script.MSG_HELP_SPAM);
	else
		print(WanWan_script.ERROR_BAD_TOPIC);
	end
end

function WanWan_isValidAdjustment(amount)
	-- The variable amount must be an integer between 1 and 20, inclusive.
	if((amount < WanWan_MIN_COUNT) or (amount > WanWan_MAX_COUNT)) then
		-- Invalid number was used. Abort.
		return false;
	end
	
	-- Anything else should be okay.
	Options.Count_Max = amount;
	print(WanWan_script.MSG_ADJUST_OKAY1..Options.Count_Max..WanWan_script.MSG_ADJUST_OKAY2);
	return true;
end

function WanWan_menu(msg)
	if(strlen(msg) <= 0) then
		WanWan_toggleEnabled();
	else
		local head, tail = strsplit(" ", msg);
		local tempHead = strlower(head);
		head = tempHead;
		if(not tail) then
			if((head == "spam") or (head == "s")) then
				WanWan_toggleSpam();
			elseif((head == "reset") or (head == "r")) then
				WanWan_resetSettings();
			elseif((head == "adjust") or (head == "a")) then
				print(WanWan_script.ERROR_ADJUST_TAIL);
				return;
			elseif((head == "help") or (head == "?")) then
				WanWan_help();
			--[[
			elseif(head == "about") then
				WanWan_toggleAboutPage();
			]]
			else
				print(WanWan_script.ERROR_SLASH_COMMAND);
				return;
			end
		else
			local tempTail = strlower(tail);
			tail = tempTail;
			if((head == "adjust") or (head == "a")) then
				tail = tonumber(tempTail);
				if(not (type(tail) == "number")) then
					print(WanWan_script.ERROR_ADJUST_TAIL);
					return;
				elseif(not WanWan_isValidAdjustment(tail)) then
					print(WanWan_script.MSG_ADJUST_FAIL);
					return;
				end
			elseif((head == "?") or (head == "help")) then
				local topic = nil;
				if((tail == "spam") or (tail == "s")) then
					topic = "spam";
				elseif((tail == "reset") or (tail == "r")) then
					topic = "reset";
				elseif((tail == "adjust") or (tail == "a")) then
					topic = "adjust";
				--[[
				elseif(tail == "about") then
					topic = "about";
				]]
				end
				WanWan_help(topic);
			else
				print(WanWan_script.ERROR_SLASH_COMMAND);
				return;
			end
		end
	end
end

function WanWan_onEvent(self, event, ...)
	if(event == "ADDON_LOADED") then
		arg1 = ...;
		if(arg1 == "WanWan") then
			WanWan_checkGlyphs();
			WanWan_form = GetShapeshiftFormID();
			if(not WanWan_form) then
				for i = 1, 40, 1 do
					local spellID = select(11, UnitBuff("player", i));
					if((spellID) and (spellID == WanWan_TreantForm_spellID)) then
						WanWan_form = 9001; -- A made-up number for Treant Form.
					end
				end
			end
			if(WanWan_Save) then
				Options = WanWan_Save;
			else
				Options = Defaults;
			end
			if(Options.Spam) then
				print(WanWan_script.MSG_GREETING);
			end
		end
	elseif(event == "PLAYER_LOGOUT") then
		WanWan_Save = Options;
	elseif(event == "GLYPH_UPDATED") then
		WanWan_checkGlyphs();
	elseif(event == "GLYPH_ADDED") then
		WanWan_checkGlyphs();
	elseif(event == "UPDATE_SHAPESHIFT_FORM") then
		WanWan_form = GetShapeshiftFormID();
		if(not WanWan_form) then
			for i = 1, 40, 1 do
				local spellID = select(11, UnitBuff("player", i));
				if((spellID) and (spellID == WanWan_TreantForm_spellID)) then
					WanWan_form = 9001; -- A made-up number for Treant Form.
				end
			end
		end
	elseif(Options.Enabled) then
		local class, race = select(2, UnitClass("player")), select(2, UnitRace("player"));
		if((class == WanWan_script.CLASS_DRUID) or (class == WanWan_script.CLASS_SHAMAN)) then
			if((IsBattleReady) and (event == "PLAYER_ENTER_COMBAT")) then
				if(WanWan_form == 4) then
					if(GlyphEnabled_Orca) then
						PlaySoundFile(Sounds["Orca"]["Aggro"]);
					else
						PlaySoundFile(Sounds["Walrus"]["Aggro"]);
					end
				elseif(WanWan_form == 5) then
					PlaySoundFile(Sounds["Bear"]["Aggro"]);
				elseif(WanWan_form == 1) then
					PlaySoundFile(Sounds["Cat"]["Aggro"]);
				elseif(WanWan_form == 16) then
					if(GlyphEnabled_Spectral) then
						PlaySoundFile(Sounds["Spectral Wolf"]["Aggro"]);
					else
						PlaySoundFile(Sounds["Wolf"]["Aggro"]);
					end
				elseif((WanWan_form == 31) and (not GlyphEnabled_Stars)) then
					PlaySoundFile(Sounds["Moonkin"]["Aggro"]);
				elseif(WanWan_form == 3) then
					if(GlyphEnabled_Cheetah) then
						PlaySoundFile(Sounds["Cat"]["Aggro"]);
					else
						PlaySoundFile(Sounds["Stag"]["Aggro"]);
					end
				elseif((WanWan_form == 9001) or (WanWan_form == 2)) then
					PlaySoundFile(Sounds["Treant"]["Aggro"]);
				end
				IsBattleReady = false;
				BattleCount = 0;
			elseif(event == "PLAYER_REGEN_ENABLED") then
				IsBattleReady = true;
				BattleCount = nil;
			else
				if((IsReady) and (tContains(Events, event))) then
					if(WanWan_form == 4) then
						x = math.random(1, 4);
						if(GlyphEnabled_Orca) then
							PlaySoundFile(Sounds["Orca"][x]);
						else
							PlaySoundFile(Sounds["Walrus"][x]);
						end
					elseif(WanWan_form == 5) then
						x = math.random(1, 4);
						PlaySoundFile(Sounds["Bear"][x]);
					elseif(WanWan_form == 1) then
						x = math.random(1, 4);
						PlaySoundFile(Sounds["Cat"][x]);
					elseif(WanWan_form == 16) then
						x = math.random(1, 6);
						if(GlyphEnabled_Spectral) then
							PlaySoundFile(Sounds["Spectral Wolf"][x]);
						else
							PlaySoundFile(Sounds["Wolf"][x]);
						end
					elseif((WanWan_form == 31) and (not GlyphEnabled_Stars)) then
						x = math.random(1, 3);
						PlaySoundFile(Sounds["Moonkin"][x]);
					elseif(WanWan_form == 3) then
						x = math.random(1, 4);
						if(GlyphEnabled_Cheetah) then
							PlaySoundFile(Sounds["Cat"][x]);
						else
							PlaySoundFile(Sounds["Stag"][x]);
						end
					elseif((WanWan_form == 9001) or (WanWan_form == 2)) then
						x = math.random(1, 4);
						PlaySoundFile(Sounds["Treant"][x]);
					elseif((WanWan_form == 29) or (WanWan_form == 27)) then
						x = math.random(1, 4);
						if(race == WanWan_script.RACE_TROLL) then
							PlaySoundFile(Sounds["Bat"][x]);
						else
							PlaySoundFile(Sounds["Crow"][x]);
						end
					end
					IsReady = false;
					Count = 0;
				end
			end
		end
	end
end

function WanWan_onLoad(self)
	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("PLAYER_LOGOUT");

	self:RegisterEvent("GLYPH_ADDED");
	self:RegisterEvent("GLYPH_UPDATED");
	self:RegisterEvent("UPDATE_SHAPESHIFT_FORM");
	
	self:RegisterEvent("PLAYER_ENTER_COMBAT");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");

	self:RegisterEvent("AUCTION_HOUSE_SHOW");
	self:RegisterEvent("BANKFRAME_OPENED");
	self:RegisterEvent("BATTLEFIELDS_SHOW");
	self:RegisterEvent("FORGE_MASTER_OPENED");
	self:RegisterEvent("GOSSIP_SHOW");
	self:RegisterEvent("LFG_OPEN_FROM_GOSSIP");
	self:RegisterEvent("MERCHANT_SHOW");
	self:RegisterEvent("QUEST_GREETING");
	self:RegisterEvent("TAXIMAP_OPENED");
	self:RegisterEvent("TRAINER_SHOW");
	
	SlashCmdList["WANWAN_MENU"] = WanWan_menu;
	SLASH_WANWAN_MENU1 = "/wanwan";
	SLASH_WANWAN_MENU2 = "/bowwow";
end

function WanWan_onUpdate(self, elapsed)
	if(Count) then
		-- Watching the regular count...
		TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed;
		while((not IsReady) and (TimeSinceLastUpdate > UpdateInterval)) do
			Count = Count + 1;
			if(Count >= Options.Count_Max) then
				IsReady = true;
				Count = nil;
			end
			TimeSinceLastUpdate = TimeSinceLastUpdate - UpdateInterval;
		end
	elseif(BattleCount) then
		-- Watching the combat count...
		TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed;
		while((not IsBattleReady) and (TimeSinceLastUpdate > UpdateInterval)) do
			BattleCount = BattleCount + 1;
			if(BattleCount >= Options.Count_Max) then
				IsBattleReady = true;
				BattleCount = nil;
			end
			TimeSinceLastUpdate = TimeSinceLastUpdate - UpdateInterval;
		end
	end
end

function WanWan_resetSettings()
	Options = Defaults;
	print(WanWan_script.MSG_RESET);
end

function WanWan_toggleEnabled()
	Options.Enabled = not Options.Enabled;
	
	if(Options.Enabled) then
		Count = nil;
		BattleCount = nil;
		IsReady = true;
		IsBattleReady = true;
		print(WanWan_script.MSG_TOGGLE_ENABLED);
	else
		Count = nil;
		BattleCount = nil;
		IsReady = false;
		IsBattleReady = false;
		print(WanWan_script.MSG_TOGGLE_DISABLED);
	end
end

function WanWan_toggleSpam()
	Options.Spam = not Options.Spam;
	
	if(Options.Spam) then
		print(WanWan_script.MSG_SPAM_ENABLED);
	else
		print(WanWan_script.MSG_SPAM_DISABLED);
	end
end

--[[
function WanWan_toggleAboutPage()

end
]]