vexpower = {}
vexpower.combopoints = 0
vexpower.infight = false
vexpower.energytype = "ENERGY"
vexpower.maxwidth = 0
vexpower.maxenergy = 100
vexpower.maxenergy_prev = 100
vexpower.currentenergy = 100
vexpower.currentenergy_prev = 100
vexpower.markers = {nil}
vexpower.maxcps = 5
vexpower.currentcps = 0
vexpower.currentcps_prev = 0
vexpower.show = false
vexpower.stealth = false
vexpower.class = ""
vexpower.cpsbars = {}
vexpower.cpsbars_anigrps = {}
vexpower.cpsbars_anis = {}
vexpower.testmode = false
vexpower.spec = 1
vexpower.loaded = false

vexpower.AceConfigDialog = LibStub("AceConfigDialog-3.0", true)
vexpower.AceConfig = LibStub("AceConfig-3.0", true)
vexpower.AceConsole= LibStub("AceConsole-3.0", true)
vexpower.LSM = LibStub("LibSharedMedia-3.0", true)
vexpower.LSMWidgets = LibStub("AceGUI-3.0-SharedMediaWidgets", true)

function vexpower_onEvent(self, event, arg1, arg2, ...)
	if event == "PLAYER_LOGIN" then
		vexpower_initialize(false)
		vexpower.loaded = true
	elseif vexpower.loaded and event == "PLAYER_REGEN_DISABLED" then
		vexpower.infight=true
		vexpower_showHandler()
		vexpower_setEnergybarColor()
	elseif vexpower.loaded and event == "PLAYER_REGEN_ENABLED" then
		vexpower.infight=false
		vexpower_showHandler()
		vexpower_setEnergybarColor()
	elseif vexpower.loaded and event == "UPDATE_STEALTH" then
		vexpower.stealth=IsStealthed()
		vexpower_showHandler()
	elseif vexpower.loaded and event == "UNIT_DISPLAYPOWER" then
		vexpower_setEnergyType()
		vexpower_showHandler()
		vexpower_changeEnergy(true)
	elseif vexpower.loaded and event == "ACTIVE_TALENT_GROUP_CHANGED" then
		vexpower_setSpec()
		vexpower_markerHandler()
	end
end

function vexpower_onUpdate()
	if vexpower_parameters["frame"]["show"] and not(vexpower.testmode) then
		if UnitPower("player") ~= vexpower.currentenergy then
			vexpower_changeEnergy()
		end
		
		if vexpower_getCpsCurrent() ~= vexpower.currentcps then
			vexpower_changeCps()
		end
		
		if vexpower_getCpsMax() ~= vexpower.maxcps then
			vexpower_initialize(true)
		end
	end
end

function vexpower_initialize(refresh)
	vexpower_loaddefaults()
	if not(refresh) then
		print("|CFFFF7D0AVex Power|r loaded")
		vexpower_energybarbg = CreateFrame("Frame", nil, vexpower_MainFrame)
		vexpower_energyTextbar = CreateFrame("Frame", nil, vexpower_energybarbg)
		vexpower_energybar = CreateFrame("Frame", nil, vexpower_energybarbg)
		vexpower_energybarDif = CreateFrame("Frame", nil, vexpower_energybarbg)
		vexpower_energytext_left = vexpower_energyTextbar:CreateFontString(nil, "OVERLAY", "GameFontNormal")
		vexpower_energytext_right = vexpower_energyTextbar:CreateFontString(nil, "OVERLAY", "GameFontNormal")
		vexpower_cpsbar = CreateFrame("Frame", nil, vexpower_MainFrame)
	end
	vexpower_setMainFrame()
	
	vexpower_setSpec()
	
	vexpower_setMaxWidth()
	vexpower_setClass()
	if not(vexpower.testmode) then
		vexpower_setCpsMax()
		vexpower_setCpsCurrent()
		vexpower_setEnergyCurrent()
		vexpower_setEnergyType()
	end
	
	vexpower_setEnergybarBG()
	vexpower_setEnergybar()
	vexpower_setEnergybarDif()
	vexpower_setEnergyTextbar()
	vexpower_setFontStrings()
	vexpower_changeEnergyText()
	
	vexpower_setCpsBars()
	
	vexpower_showHandler()
	vexpower_markerHandler()
	
	if not(vexpower.testmode) then
		vexpower_changeEnergy()
	end
	
	vexpower_movable(false)
	
	if not(refresh) then
		vexpower.options = {}
		vexpower.options.main = vexpower.AceConfigDialog:AddToBlizOptions("Vex Power", "Vex Power")
		vexpower.options.frame = vexpower.AceConfigDialog:AddToBlizOptions("VexP EnergyBar", "VexP EnergyBar", "Vex Power")
		vexpower.options.text = vexpower.AceConfigDialog:AddToBlizOptions("VexP Text", "VexP Text", "Vex Power")
		vexpower.options.cps = vexpower.AceConfigDialog:AddToBlizOptions("VexP ComboPoints", "VexP ComboPoints", "Vex Power")
		vexpower.options.markers = vexpower.AceConfigDialog:AddToBlizOptions("VexP Markers", "VexP Markers", "Vex Power")
		vexpower.options.show = vexpower.AceConfigDialog:AddToBlizOptions("VexP Show/Enable", "VexP Show/Enable", "Vex Power")
		vexpower.options.profiles = vexpower.AceConfigDialog:AddToBlizOptions("VexP Profiles", "VexP Profiles", "Vex Power")
	end
	
	vexpower.AceConfig:RegisterOptionsTable("Vex Power", vexpower.panel_main(), {})
	vexpower.AceConfig:RegisterOptionsTable("VexP EnergyBar", vexpower.panel_energybar(), {})
	vexpower.AceConfig:RegisterOptionsTable("VexP Text", vexpower.panel_text(), {})
	vexpower.AceConfig:RegisterOptionsTable("VexP ComboPoints", vexpower.panel_cps(), {})
	vexpower.AceConfig:RegisterOptionsTable("VexP Markers", vexpower.panel_markers(), {})
	vexpower.AceConfig:RegisterOptionsTable("VexP Show/Enable", vexpower.panel_show(), {})
	vexpower.AceConfig:RegisterOptionsTable("VexP Profiles", vexpower.panel_profiles(), {})
end

function vexpower_showHandler()
	local show = true
	
	--check for enabled addon
	if vexpower_parameters["frame"]["show"] then
		--check for infight
		if vexpower_parameters["frame"]["infightshow"] and vexpower.infight	then
			show = true
		elseif not(vexpower_parameters["frame"]["infightshow"])	then
			show = true
		else
			show = false
		end
		
		--check for stealth
		if vexpower_parameters["frame"]["stealthshow"] and vexpower.stealth then
			show = true
		end
		
		--check for show not with manapool
		if not(vexpower_parameters["frame"]["energy"]["showwithmana"]) and vexpower.energytype == "MANA" then
			show = false
		end		
	else
		show = false
	end
	
	vexpower.show = show
	
	local show_energy = show
	local show_cps = show
	
	if not(vexpower_parameters["frame"]["combo"]["showWithoutEnergy"]) and vexpower.energytype ~= "ENERGY" then
		show_cps = false
	end
	
	if not(vexpower_parameters["frame"]["energy"]["show"]) then
		show_energy = false
	end
	
	if not(vexpower_parameters["frame"]["combo"]["show"]) then
		show_cps = false
	end
	
	--react to 'show'
	if show_energy then 	vexpower_energybarbg:Show() 
	else					vexpower_energybarbg:Hide() end
	
	if show_cps then		vexpower_cpsbar:Show() vexpower_ShowCPs()
	else					vexpower_cpsbar:Hide() end
end

function vexpower_setSpec()
	if GetActiveSpecGroup == nil then
		vexpower.spec = GetActiveTalentGroup(false, false)	-- OLD
	else
		vexpower.spec = GetActiveSpecGroup(false, false)	-- MoP
	end
end

function vexpower_setClass()
	vexpower.class = select(2, UnitClass("player"))
end





