function vexpower_test_starter(val, timer)
	if val and vexpower.testmode then
		local frame = vexpower_MainFrame
		local test_aniGRP = frame:CreateAnimationGroup("test_aniGRP")
		test_aniGRP:SetLooping("NONE")
		local test_ani = test_aniGRP:CreateAnimation("Scale")
		test_ani:SetOrder(1)
		test_ani:SetDuration(0)
		test_ani:SetScale(1,1)
		test_ani:SetEndDelay(0.1)
		if timer == nil or timer == 23 then timer = 0 end
		timer = timer + 1
		test_aniGRP:SetScript("OnFinished", function () vexpower_test_func(timer) vexpower_test_starter(true, timer) end)
		test_aniGRP:Play()
	end
end

function vexpower_test_func(timer)
	if vexpower.testmode then
		if timer == 1 then
			vexpower_test_func_changeEnergy()
			vexpower_test_func_changeCP()
		else
			vexpower_test_func_changeEnergy(true)
		end
	end
end

function vexpower_test_func_changeCP()
	if vexpower.maxcps>0 then
		if vexpower.currentcps >= vexpower.maxcps then
				vexpower_changeCps(-vexpower.maxcps)
		else 	vexpower_changeCps(1) end
	end
end

function vexpower_test_func_changeEnergy(add)
	local energychange = 0	
	
	if add then
		energychange = math.floor(vexpower.maxenergy/50)
		if vexpower.currentenergy+energychange <= vexpower.maxenergy then
			vexpower_changeEnergy(false, energychange)
		else
			if vexpower.currentenergy ~= vexpower.maxenergy then
				vexpower_changeEnergy(false, vexpower.maxenergy-vexpower.currentenergy)
			end
		end
	else
		energychange = math.floor(-(4*vexpower.maxenergy)/10)
		if vexpower.currentenergy - energychange > 0 then
			vexpower_changeEnergy(false, energychange)
		end
	end
end