function vexpower.panel_text()
	return {
		type = "group",
		order= 3,
		args = {
			grpleft = {
				name = "Left text",
				order=1, type ="group", dialogInline = true,
				args = {
					framelefttextcontent = {
						name = "Text",
						desc = "Text that is shown left",
						order=2, type = "input", multiline = false,
						width = "double",
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["text"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["text"] end
						},
					framelefttexttags = {name = "You can use the following tags to parse information:\n{CurrentEnergy} {MissingEnergy} {CurrentManaSmart} {CurrentManaShort} {MaxEnergy} {MaxManaSmart} {MaxManaShort} {PercEnergy} {CurrentCPs} {MaxCPs}", type="description", order=3},
					framelefttextfont = {
						name = "Font",
						order=5, type = "select",
						dialogControl = "LSM30_Font",
						values = vexpower.LSM:HashTable("font"),
						set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["left"]["font"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["font"] end,
						},
					framelefttextsize = {
						name = "Size",
						order=6, type = "range",
						step = 1, min = 6, max = 20,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["size"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["size"] end,
						},
					framelefttextfontalign = {
						name = "Text align",
						order=7, type = "select", style = "dropdown",
						desc = "Sets the text align",
						values = {["LEFT"]="Left", ["CENTER"]="Center", ["RIGHT"]="Right"},
						set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["left"]["align"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["align"] end,
						},
					framelefttextcolor = {
						name = "color",
						order=8, type = "color", hasAlpha=true, width="double",
						desc = "Sets the text color",
						set = function(info,r,g,b,a)
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["r"]=r
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["g"]=g
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["b"]=b
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["a"]=a
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["r"],
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["g"],
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["b"],
							vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["a"] end,
						},
					framelefteffect = {
						name = "effect",
						order=9, type = "select", style = "dropdown",
						values = {["MONOCHROME"]="Monochrome",
									["OUTLINE"]="Outline",
									[""]="None",
									["THICKOUTLINE"]="Thickoutline"},
						set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["left"]["effect"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["effect"] end,
						},
					framelefttextwidth = {
						name = "Width",
						order=10, type = "range",
						step = 1, min = 1, max = 400,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["width"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["width"] end
						},
					framelefttextx = {
						name = "X Position",
						order=11, type = "range",
						step = 1, min = -100, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["x"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["x"] end
						},
					framelefttexty = {
						name = "Y Position",
						order=12, type = "range",
						step = 1, min = -100, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["y"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["y"] end
						},
					grpleftshadow = {
						name = "Shadow Effect",
						order=20, type ="group", dialogInline = true,
						args = {
							leftshadowallow = {
								name = "Activate shadow effect",
								order=1, type = "toggle", width="full",
								desc = "",
								set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"]=key vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"] end,
								},
							leftshadowcolor = {
								name = "color",
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"]),
								order=2, type = "color", hasAlpha=true, width="double",
								set = function(info,r,g,b,a)
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["r"]=r
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["g"]=g
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["b"]=b
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["a"]=a
									vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["r"],
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["g"],
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["b"],
									vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["a"] end,
								},
							leftshadowopacity = {
								name = "Opacity %",
								order=3, type = "range",
								step = 5, min = 0, max = 100,
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"]),
								set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["a"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["a"]*100 end
								},
							leftshadowx = {
								name = "X Position",
								order=4, type = "range",
								step = 1, min = -50, max = 50,
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"]),
								set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["offset"]["x"]=val vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["offset"]["x"] end
								},
							leftshadowy = {
								name = "Y Position",
								order=5, type = "range",
								step = 1, min = -50, max = 50,
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"]),
								set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["offset"]["y"]=val vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["offset"]["y"] end
								},
							},
						},
						
					},
				},
			frame_space1 = {name ="\n", type = "description", order=2},
			
			
			grpright = {
				name = "Right text",
				order=3, type ="group", dialogInline = true,
				args = {
					framerighttextcontent = {
						name = "text",
						desc = "text that is shown right",
						order=102, type = "input", multiline = false,
						width = "double",
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["text"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["text"] end
						},
					framerighttexttags = {name = "You can use the following tags to parse information:\n{CurrentEnergy} {MissingEnergy} {CurrentManaSmart} {CurrentManaShort} {MaxEnergy} {MaxManaSmart} {MaxManaShort} {PercEnergy} {CurrentCPs} {MaxCPs}", type="description", order=103},
					framerighttextfont = {
						name = "font",
						order=105, type = "select",
						dialogControl = "LSM30_Font",
						values = vexpower.LSM:HashTable("font"),
						set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["right"]["font"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["font"] end,
						},
					framerighttextsize = {
						name = "Size",
						order=106, type = "range",
						step = 1, min = 6, max = 20,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["size"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["size"] end,
						},
					framerighttextfontalign = {
						name = "Text align",
						order=107, type = "select", style = "dropdown",
						desc = "Sets the text align",
						values = {["LEFT"]="Left", ["CENTER"]="Center", ["RIGHT"]="Right"},
						set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["right"]["align"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["align"] end,
						},
					framerighttextcolor = {
						name = "color",
						order=108, type = "color", hasAlpha=true, width="double",
						set = function(info,r,g,b,a)
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["r"]=r
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["g"]=g
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["b"]=b
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["a"]=a
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["r"],
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["g"],
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["b"],
							vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["a"] end,
						},
					framerighteffect = {
						name = "effect",
						order=109, type = "select", style = "dropdown",
						values = {["MONOCHROME"]="Monochrome",
									["OUTLINE"]="Outline",
									[""]="None",
									["THICKOUTLINE"]="Thickoutline"},
						set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["right"]["effect"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["effect"] end,
						},
					framerighttextwidth = {
						name = "Width",
						order=110, type = "range",
						step = 1, min = 1, max = 400,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["width"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["width"] end
						},
					framerighttextx = {
						name = "X-Position",
						order=111, type = "range",
						step = 1, min = -100, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["x"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["x"] end
						},
					framerighttexty = {
						name = "Y-Position",
						order=112, type = "range",
						step = 1, min = -100, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["y"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["y"] end
						},
					grprightshadow = {
						name = "Shadow Effect",
						order=120, type ="group", dialogInline = true,
						args = {
							rightshadowallow = {
								name = "Activate shadow effect",
								order=1, type = "toggle", width="full",
								desc = "",
								set = function(self,key) vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"]=key vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"] end,
								},
							rightshadowcolor = {
								name = "color",
								order=2, type = "color", hasAlpha=true, width="double",
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"]),
								set = function(info,r,g,b,a)
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["r"]=r
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["g"]=g
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["b"]=b
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["a"]=a
									vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["r"],
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["g"],
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["b"],
									vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["a"] end,
								},
							rightshadowopacity = {
								name = "Opacity %",
								order=3, type = "range",
								step = 5, min = 0, max = 100,
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"]),
								set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["a"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["a"]*100 end
								},
							rightshadowx = {
								name = "X Position",
								order=4, type = "range",
								step = 1, min = -50, max = 50,
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"]),
								set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["offset"]["x"]=val vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["offset"]["x"] end
								},
							rightshadowy = {
								name = "Y Position",
								order=5, type = "range",
								step = 1, min = -50, max = 50,
								disabled = not(vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"]),
								set = function(info,val) vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["offset"]["y"]=val vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["offset"]["y"] end
								},
							},
						},
					},
				},
			}
		}
end