local vexpower_profiles_profile_load = ""
local vexpower_profiles_profile_delete = ""
local vexpower_profiles_profile_new = GetRealmName().." "..select(1, UnitName("player"))

function vexpower.panel_profiles()
	return {
		type = "group",
		args = {
			grpex = {
				name = "Information",
				order=1, type = "group", dialogInline = true,
				args = {
					info1={name = "You can save your current settings in profiles and load them later on. That way you can easily copy your settings to other characters.", type="description", order=2, fontSize="medium"},
					space1={name= " ", type="description", order=10},
					},
				},
			frame_space1 = {name =" ", type = "description", order=2},
			grpadd = {
				name = "Add Profile",
				order=3, type ="group", dialogInline = true,
				args = {
					profile_new = {
						name = "Name",
						desc = "Enter a name for the new profile",
						order=1, type = "input", multiline = false, width = "double",
						validate = function (info, val)
							if vexpower_profile_checkName(val) then return true
							else return "ERROR - "..val.." is not a valid name" end
							end,
						set = function(info,val) vexpower_profiles_profile_new = val end,
						get = function() return vexpower_profiles_profile_new end,
						},
					profile_new_add = {
						name = "add", width="half",
						order=2, type = "execute",
						func = function(info,val) vexpower_profile_add() end,
						},
					grpadddelete_allowed = {name ="Profile names may only contain numbers, letters and spaces\n\nWarning: Changes made to an existing profile after saving it will not be automatically saved! You have to overwrite the profile to save the changes!", type = "description", order=3, fontSize="medium"},
					},
				},
			frame_space2 = {name =" ", type = "description", order=4},
			grpdelete = {
				name = "Delete Profile",
				order=5, type ="group", dialogInline = true,
				args = {
					profile_delete = {
						name = "Profile",
						order=1, type = "select", style = "dropdown",
						desc = "Delete an existing profile",
						values = vexpower_profiles["profilelist"],
						set = function(self,key) vexpower_profiles_profile_delete = key end,
						get = function() return vexpower_profiles_profile_delete end,
						},
					delete_exe = {
						name = "delete",
						order=2, type = "execute",
						func = function(info,val) vexpower_profile_delete() end,
						confirm = true,
						confirmText = "Are you sure you want to delete the profile?"
						},
					},
				},
			frame_space3 = {name =" ", type = "description", order=6},
			grpload = {
				name = "Load Profile",
				order=7, type ="group", dialogInline = true,
				args = {
					profile_load = {
						name = "Profile",
						order=1, type = "select", style = "dropdown",
						values = vexpower_profiles["profilelist"],
						set = function(self,key) vexpower_profiles_profile_load = key end,
						get = function() return vexpower_profiles_profile_load end,
						},
					load_exe_all = {
						name = "load",
						order=3, type = "execute",
						func = function(info,val) vexpower_profile_load() vexpower_initialize(true) end,
						},
					},
				},
			}
		}
end

function vexpower_profile_add()
	local key = vexpower_profiles_profile_new
	if key ~= "" then
		vexpower_profiles["profilelist"][key] = key
		vexpower_profiles[key] = vexpower_CopyTable(vexpower_parameters)
		
		vexpower_profiles_profile_new = ""
	end
end

function vexpower_profile_checkName(val)
	local returnvalue = false
	local val_edited = string.gsub(val, "%a", "")
	val_edited = string.gsub(val_edited, "%d", "")
	val_edited = string.gsub(val_edited, " ", "")
	if val_edited == "" then returnvalue = true end
	if val == "" or val == "profilelist" then returnvalue = false end
	return returnvalue
end

function vexpower_profile_delete(key)
	if key == nil then key = vexpower_profiles_profile_delete end
	if key ~= "" then
		vexpower_profiles["profilelist"][key] = nil
		vexpower_profiles[key] = nil
	end
	vexpower_profiles_profile_delete = ""
end

function vexpower_profile_load()
	local key = vexpower_profiles_profile_load
	if key ~= "" then
		vexpower_parameters = vexpower_CopyTable(vexpower_profiles[key])
		vexpower_loaddefaults(false)
	end
end

-- thx to Lombra from WoWAce for this function
function vexpower_CopyTable(settings)
	local copy = {}
	for k, v in pairs(settings) do
		if type(v) == "table" then  copy[k] = vexpower_CopyTable(v)
		else						copy[k] = v end
	end
	return copy
end







