vexpower.new_marker_location = ""
vexpower.new_marker_spec = ""

function vexpower.panel_markers()
	local spec1 = "Spec 1"
	local spec2 = "Spec 2"
	-- local tabnumber = 1
	-- if GetPrimaryTalentTree == nil then
		-- tabnumber = GetSpecialization(false, false, 1)
	-- else
		-- tabnumber = GetPrimaryTalentTree(false, false, 1)
	-- end
	
	-- if GetTalentTabInfo == nil then
		-- if GetSpecializationInfo ~= nil then
			-- spec1 = spec1..": "..select(2, GetSpecializationInfo(tabnumber, false, false, 1))
		-- end
		-- if GetSpecializationInfo ~= nil then
			-- spec2 = spec2..": "..select(2, GetSpecializationInfo(tabnumber, false, false, 2))
		-- end
	-- else
		-- if GetTalentTabInfo ~= nil then
			-- spec1 = spec1..": "..select(2, GetTalentTabInfo(tabnumber, false, false, 1))
		-- end
		-- if GetTalentTabInfo ~= nil then
			-- spec2 = spec2..": "..select(2, GetTalentTabInfo(tabnumber, false, false, 2))
		-- end
	-- end
	
	
	return {
		type = "group",
		order= 5,
		args = {
			grpex = {
				name = "Examples",
				order=1, type = "group", dialogInline = true,
				args = {
					infopic={name = "", type="description", order=1, image="Interface\\AddOns\\vexpower\\images\\options_markers.tga",
						imageWidth=512, imageHeight=64},	
					info1={name = "Examples for markers in the red circles\n", type="description", order=2,},	
					info2={name = "Markers are marks at specific places on your energybar. They can be placed at absolute positions and at relative positions.", type="description", order=3, fontSize="medium"},	
					info3={name = "Example 1: '50' will be placed on the energybar that represents 50 of your mana/energy/etc", type="description", order=4, fontSize="medium"},	
					info4={name = "Example 2: '50%' will be placed on the energybar that represents 50% of your mana/energy/etc", type="description", order=5, fontSize="medium"},	
					info5={name = "Markers that are placed at the end or outside of the energybar aren't shown", type="description", order=6, fontSize="medium"},	
					info6={name = "Example 3: the marker '140' isn't shown unless the powerbar has at least 141 energy/mana/etc", type="description", order=7, fontSize="medium"},	
					info7={name = "Example 4: the marker '100%' and higher is never shown", type="description", order=8, fontSize="medium"},	
					space1={name= " ", type="description", order=10},
					},
				},
			frame_space = {name =" ", type = "description", order=2},
			
			grpadddelete = {
				name = "Add / delete marker",
				order=50, type ="group", dialogInline = true,
				args = {
					grpadd = {
						name = "Add marker",
						order=1, type ="group", dialogInline = true,
						args = {
							marker_new = {
								name = "Location",
								desc = "Enter a location where to put the new marker",
								order=1, type = "input", multiline = false,
								validate = function (info, val)
									if vexpower_panel_markercheck(val) then return true
									else print("ERROR - "..val.." is not a valid position") return false end
									end,
								set = function(info,val) vexpower.new_marker_location=val end,
								get = function() return vexpower.new_marker_location end,
								},
							marker_new_spec = {
								name = "Spec",
								order=1, type = "select", style = "dropdown",
								desc = "Show the marker with the spec",
								values = {[""]="Both Specs",
								["a"]=spec1,
								["b"]=spec2},
								set = function(self,key) vexpower.new_marker_spec = key end,
								get = function() return vexpower.new_marker_spec end,
								},
							marker_new_add = {
								name = "add",
								order=2, type = "execute",
								func = function(info,val) vexpower_panel_addmarker() vexpower_initialize(true) end,
								},
							},
						},
					grpadddelete_space = {name =" ", type = "description", order=2},
					grpdelete = {
						name = "Delete marker",
						order=3, type ="group", dialogInline = true,
						args = {
							marker_delete = {
								name = "Both specs",
								order=1, type = "select", style = "dropdown",
								desc = "Delete an existing marker",
								values = vexpower_parameters["frame"]["energy"]["markers"]["points"],
								set = function(self,key) vexpower_panel_deletemarker(key, "") vexpower_initialize(true) end,
								get = function() return "" end,
								},
							marker_delete_a = {
								name = "Spec 1",
								order=2, type = "select", style = "dropdown",
								desc = "Delete an existing marker",
								values = vexpower_parameters["frame"]["energy"]["markers"]["points_spec_a"],
								set = function(self,key) vexpower_panel_deletemarker(key, "a") vexpower_initialize(true) end,
								get = function() return "" end,
								},
							marker_delete_b = {
								name = "Spec 2",
								order=3, type = "select", style = "dropdown",
								desc = "Delete an existing marker",
								values = vexpower_parameters["frame"]["energy"]["markers"]["points_spec_b"],
								set = function(self,key) vexpower_panel_deletemarker(key, "b") vexpower_initialize(true) end,
								get = function() return "" end,
								},
							},
						},
					},
				},
			frame_space1 = {name =" ", type = "description", order=51},
			
			grpapp = {
				name = "Appearance",
				order=100, type = "group", dialogInline = true,
				args = {
					grpappsize = {
						name = "Size",
						order=1, type = "group", dialogInline = true,
						args = {
							markerswidth = {
								name = "Width",
								order=1, type = "range",
								desc = "Sets the width of the marker",
								step = 1, min = 1, max = 10,
								set = function(info,val) vexpower_parameters["frame"]["energy"]["markers"]["width"]=val vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["width"] end,
								},
							},
						},
					space_app1 = {name = " ", type = "description", order=2},
					
					grpappbg = {
						name = "Background",
						order=3, type ="group", dialogInline = true,
						args = {
							bordercolor_likebar = {
								name = "Use the color of the powerbar",
								order=1, type = "toggle", width="full",
								set = function(self,key) vexpower_parameters["frame"]["energy"]["markers"]["color_likebg"]=key vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["color_likebg"] end,
								},
							markersbg = {
								name = "Color",
								order=2, type = "color", hasAlpha=false,
								desc = "Set the marker's background color",
								disabled = vexpower_parameters["frame"]["energy"]["markers"]["color_likebg"],
								set = function(info,r,g,b,a)
									vexpower_parameters["frame"]["energy"]["markers"]["color"]["r"]=r
									vexpower_parameters["frame"]["energy"]["markers"]["color"]["g"]=g
									vexpower_parameters["frame"]["energy"]["markers"]["color"]["b"]=b
									vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["color"]["r"],
									vexpower_parameters["frame"]["energy"]["markers"]["color"]["g"],
									vexpower_parameters["frame"]["energy"]["markers"]["color"]["b"] end,
								},
							backgroundopacity = {
								name = "Opacity %",
								order=3, type = "range",
								desc = "Sets the opacity",
								step = 5, min = 0, max = 100,
								set = function(info,val) vexpower_parameters["frame"]["energy"]["markers"]["color"]["a"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["color"]["a"]*100 end
								},
							},
						},
					space_app2 = {name =" ", type = "description", order=4},
					
					grpappborder = {
						name = "Border",
						order=5, type ="group", dialogInline = true,
						args = {
							bordercolor_likebar = {
								name = "Use the color of the powerbar",
								order=1, type = "toggle", width="full",
								set = function(self,key) vexpower_parameters["frame"]["energy"]["markers"]["border"]["color_likebg"]=key vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["border"]["color_likebg"] end,
								},
							markersborder = {
								name = "Color",
								order=2, type = "color", hasAlpha=false,
								desc = "Set the marker's border color",
								disabled = vexpower_parameters["frame"]["energy"]["markers"]["border"]["color_likebg"],
								set = function(info,r,g,b,a)
									vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["r"]=r
									vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["g"]=g
									vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["b"]=b
									vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["r"],
									vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["g"],
									vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["b"] end,
								},
							opacityborder = {
								name = "Opacity %",
								order=3, type = "range",
								desc = "Sets the opacity",
								step = 5, min = 0, max = 100,
								set = function(info,val) vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["a"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["border"]["color"]["a"]*100 end
								},
							markersborderwidth = {
								name = "Size",
								order=5, type = "range",
								desc = "Sets the width of the border",
								step = 1, min = 1, max = 10,
								set = function(info,val) vexpower_parameters["frame"]["energy"]["markers"]["border"]["size"]=val vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["markers"]["border"]["size"] end,
								},
							},
						},
					},
				},
			}
		}
end

function vexpower_panel_addmarker()
	local pos = vexpower.new_marker_location
	local spec = vexpower.new_marker_spec
	
	if vexpower_panel_markercheck(pos) then
		if spec == "" 		then vexpower_parameters["frame"]["energy"]["markers"]["points"][pos] = pos
		elseif spec == "a" 	then vexpower_parameters["frame"]["energy"]["markers"]["points_spec_a"][pos] = pos
		elseif spec == "b" 	then vexpower_parameters["frame"]["energy"]["markers"]["points_spec_b"][pos] = pos end
		vexpower.new_marker_location = ""
	else
		print("|CFFFF7D0AVex Power|r - ERROR --> "..pos.." <-- is not a valid 'marker' !")
	end
end

function vexpower_panel_markercheck(val)
	local returnvalue = false
	if string.gsub(val, "^%d+%%?", "") == "" then returnvalue = true end
	if val == "" then returnvalue = false end
	return returnvalue
end

function vexpower_panel_deletemarker(pos, spec)
	if spec == "" 		then vexpower_parameters["frame"]["energy"]["markers"]["points"][pos] = nil
	elseif spec == "a" 	then vexpower_parameters["frame"]["energy"]["markers"]["points_spec_a"][pos] = nil
	elseif spec == "b" 	then vexpower_parameters["frame"]["energy"]["markers"]["points_spec_b"][pos] = nil end
end