function vexpower.panel_energybar()
	local warning = " \n"
	if vexpower_parameters["frame"]["energy"]["altcolors"]["empty"] > vexpower_parameters["frame"]["energy"]["altcolors"]["full"] then
		warning = "|CFFFF0000Warning: The % for 'power empty' has been set higher than the % for 'power full'|r\n"
	end
	
	return {
		type = "group",
		order= 3,
		args = {
			grppos = {
				name = "Position and Size",
				order=1, type ="group", dialogInline = true,
				args = {
					framewidth = {
						name = "Width",
						order=1, type = "range",
						desc = "Sets the width of the frame",
						step = 1, min = 0, max = 2000,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["size"]["width"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["size"]["width"] end
						},
					frameheight = {
						name = "Height",
						order=2, type = "range",
						desc = "Sets the height of the frame",
						step = 1, min = 0, max = 2000,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["size"]["height"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["size"]["height"] end
						},
					frame_size_space = {name =" ", type = "description", order=3},
					framemoveable = {
						name = "Make the frame temporarily moveable",
						order=4, type = "toggle", width="full",
						desc = "",
						set = function(self,key) vexpower_movable(key) end,
						get = function() return vexpower_MainFrame:IsMovable() end,
						},
					frame_size_space2 = {name =" ", type = "description", order=5},
					frameposx = {
						name = "X Position",
						order=6, type = "range",
						desc = "Sets the x position of the frame",
						step = 1, min = -2000, max = 2000,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["position"]["x"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["position"]["x"] end
						},
					frameposy = {
						name = "Y Position",
						order=7, type = "range",
						desc = "Sets the y position of the frame",
						step = 1, min = -2000, max = 2000,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["position"]["y"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["position"]["y"] end
						},
					frame_size_space3 = {name =" ", type = "description", order=8},
					frameanchorFrame = {
						name = "Frame Anchor",
						order=9, type = "select", style = "dropdown",
						desc = "Sets the achor of the frame",
						values = {
							["CENTER"]="Center",
							["BOTTOM"]="Bottom",
							["TOP"]="Top",
							["LEFT"]="Left",
							["RIGHT"]="Right",
							["BOTTOMLEFT"]="Bottomleft",
							["BOTTOMRIGHT"]="Bottomright",
							["TOPLEFT"]="Topleft",
							["TOPRIGHT"]="Topright"},
						set = function(self,key) vexpower_parameters["frame"]["energy"]["position"]["anchorFrame"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["position"]["anchorFrame"] end,
						},
					frameanchorScreen = {
						name = "Screen Anchor",
						order=10, type = "select", style = "dropdown",
						desc = "Sets the achor of the screen",
						values = {
							["CENTER"]="Center",
							["BOTTOM"]="Bottom",
							["TOP"]="Top",
							["LEFT"]="Left",
							["RIGHT"]="Right",
							["BOTTOMLEFT"]="Bottomleft",
							["BOTTOMRIGHT"]="Bottomright",
							["TOPLEFT"]="Topleft",
							["TOPRIGHT"]="Topright"},
						set = function(self,key) vexpower_parameters["frame"]["energy"]["position"]["anchor"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["position"]["anchor"] end,
						},
					},
				},
			frame_space1 = {name ="\n", type = "description", order=2},
				
			grppowerpool = {
				name = "Power Pool",
				order=3, type ="group", dialogInline = true,
				args = {
					frametypecolored = {
						name = "Use blizzard's colors for mana/energy/etc",
						order=1, type = "toggle", width="full",
						desc = "",
						set = function(self,key) vexpower_parameters["frame"]["energy"]["typecolored"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["typecolored"] end,
						},
					frameenergycolor = {
						name = "Alternative color", width="double",
						order=2, type = "color", hasAlpha=false,
						desc = "background color used when not using blizzard's preset colors",
						disabled = vexpower_parameters["frame"]["energy"]["typecolored"],
						set = function(info,r,g,b,a)
							vexpower_parameters["frame"]["energy"]["color"]["r"]=r
							vexpower_parameters["frame"]["energy"]["color"]["g"]=g
							vexpower_parameters["frame"]["energy"]["color"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["color"]["r"],
							vexpower_parameters["frame"]["energy"]["color"]["g"],
							vexpower_parameters["frame"]["energy"]["color"]["b"] end,
						},
					opacityframe = {
						name = "Opacity %",
						order=3, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["color"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["color"]["a"]*100 end
						},
				
					framebackdrop = {
						name = "Texture Pack 1",
						order=4, type = "select",
						dialogControl = "LSM30_Background",
						desc = "Sets the frame's background-texture",
						values = vexpower.LSM:HashTable("background"),
						set = function(self,key)
							vexpower_parameters["frame"]["energy"]["bg"]=key
							vexpower_parameters["frame"]["energy"]["bg2"]="None"
							vexpower_parameters["frame"]["energy"]["textureToUse"]=1
							vexpower_initialize(true)
							end,
						get = function() return vexpower_parameters["frame"]["energy"]["bg"] end,
						},
					framebackdrop2 = {
						name = "Texture Pack 2",
						order=5, type = "select",
						dialogControl = "LSM30_Statusbar",
						desc = "Sets the frame's background-texture",
						values = vexpower.LSM:HashTable("statusbar"),
						set = function(self,key)
							vexpower_parameters["frame"]["energy"]["bg2"]=key
							vexpower_parameters["frame"]["energy"]["bg"]="None"
							vexpower_parameters["frame"]["energy"]["textureToUse"]=2
							vexpower_initialize(true)
							end,
						get = function() return vexpower_parameters["frame"]["energy"]["bg2"] end,
						},
						
					grpchangecolor = {
						name = "Change Color",
						order=9, type ="group", dialogInline = true,
						args = {
							powerempty = {
								name = "Set % for 'power empty'",
								order=1, type = "range",
								step = 1, min = 0, max = 100,
								set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["empty"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["empty"]*100 end
								},
							powerfull = {
								name = "Set % for 'power full'",
								order=2, type = "range",
								step = 1, min = 0, max = 100,
								set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["full"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["full"]*100 end
								},
							warning = {name = warning, type = "description", order=3},
							grpchangecolor1 = {
								name = "When 'In combat' and power is empty",
								order=11, type ="group", dialogInline = true,
								args = {
									use = {
										name = "Change color",
										order=1, type = "toggle", width="full",
										desc = "",
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["use"][1]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["use"][1] end,
										},
									frametypecolored = {
										name = "Use blizzard's colors for mana/energy/etc",
										order=2, type = "toggle", width="full",
										desc = "",
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][1]),
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][1]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][1] end,
										},
									frameenergycolor = {
										name = "Alternative color", width="double",
										order=3, type = "color", hasAlpha=false,
										desc = "background color used when not using blizzard's preset colors",
										disabled = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][1] or not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][1]),
										set = function(info,r,g,b,a)
											vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["r"]=r
											vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["g"]=g
											vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["b"]=b
											vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["r"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["g"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["b"] end,
										},
									opacityframe = {
										name = "Opacity %",
										order=4, type = "range",
										desc = "Sets the opacity",
										step = 5, min = 0, max = 100,
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][1]),
										set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["a"]=val/100 vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["1"]["a"]*100 end
										},
									},
								},
							grpchangecolor2 = {
								name = "When 'In combat' and power is not full and not empty",
								order=12, type ="group", dialogInline = true,
								args = {
									use = {
										name = "Change color",
										order=1, type = "toggle", width="full",
										desc = "",
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["use"][2]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["use"][2] end,
										},
									frametypecolored = {
										name = "Use blizzard's colors for mana/energy/etc",
										order=2, type = "toggle", width="full",
										desc = "",
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][2]),
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][2]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][2] end,
										},
									frameenergycolor = {
										name = "Alternative color", width="double",
										order=3, type = "color", hasAlpha=false,
										desc = "background color used when not using blizzard's preset colors",
										disabled = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][2] or not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][2]),
										set = function(info,r,g,b,a)
											vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["r"]=r
											vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["g"]=g
											vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["b"]=b
											vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["r"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["g"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["b"] end,
										},
									opacityframe = {
										name = "Opacity %",
										order=4, type = "range",
										desc = "Sets the opacity",
										step = 5, min = 0, max = 100,
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][2]),
										set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["a"]=val/100 vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["2"]["a"]*100 end
										},
									},
								},
							grpchangecolor3 = {
								name = "When 'In combat' and power is full",
								order=13, type ="group", dialogInline = true,
								args = {
									use = {
										name = "Change color",
										order=1, type = "toggle", width="full",
										desc = "",
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["use"][3]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["use"][3] end,
										},
									frametypecolored = {
										name = "Use blizzard's colors for mana/energy/etc",
										order=2, type = "toggle", width="full",
										desc = "",
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][3]),
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][3]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][3] end,
										},
									frameenergycolor = {
										name = "Alternative color", width="double",
										order=3, type = "color", hasAlpha=false,
										desc = "background color used when not using blizzard's preset colors",
										disabled = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][3] or not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][3]),
										set = function(info,r,g,b,a)
											vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["r"]=r
											vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["g"]=g
											vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["b"]=b
											vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["r"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["g"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["b"] end,
										},
									opacityframe = {
										name = "Opacity %",
										order=4, type = "range",
										desc = "Sets the opacity",
										step = 5, min = 0, max = 100,
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][3]),
										set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["a"]=val/100 vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["3"]["a"]*100 end
										},
									},
								},
							grpchangecolor4 = {
								name = "When 'Out of combat' and power is empty",
								order=14, type ="group", dialogInline = true,
								args = {
									use = {
										name = "Change color",
										order=1, type = "toggle", width="full",
										desc = "",
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["use"][4]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["use"][4] end,
										},
									frametypecolored = {
										name = "Use blizzard's colors for mana/energy/etc",
										order=2, type = "toggle", width="full",
										desc = "",
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][4]),
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][4]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][4] end,
										},
									frameenergycolor = {
										name = "Alternative color", width="double",
										order=3, type = "color", hasAlpha=false,
										desc = "background color used when not using blizzard's preset colors",
										disabled = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][4] or not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][4]),
										set = function(info,r,g,b,a)
											vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["r"]=r
											vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["g"]=g
											vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["b"]=b
											vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["r"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["g"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["b"] end,
										},
									opacityframe = {
										name = "Opacity %",
										order=4, type = "range",
										desc = "Sets the opacity",
										step = 5, min = 0, max = 100,
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][4]),
										set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["a"]=val/100 vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["4"]["a"]*100 end
										},
									},
								},
							grpchangecolor5 = {
								name = "When 'Out of combat' and power is not full and not empty",
								order=15, type ="group", dialogInline = true,
								args = {
									use = {
										name = "Change color",
										order=1, type = "toggle", width="full",
										desc = "",
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["use"][5]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["use"][5] end,
										},
									frametypecolored = {
										name = "Use blizzard's colors for mana/energy/etc",
										order=2, type = "toggle", width="full",
										desc = "",
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][5]),
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][5]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][5] end,
										},
									frameenergycolor = {
										name = "Alternative color", width="double",
										order=3, type = "color", hasAlpha=false,
										desc = "background color used when not using blizzard's preset colors",
										disabled = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][5] or not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][5]),
										set = function(info,r,g,b,a)
											vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["r"]=r
											vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["g"]=g
											vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["b"]=b
											vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["r"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["g"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["b"] end,
										},
									opacityframe = {
										name = "Opacity %",
										order=4, type = "range",
										desc = "Sets the opacity",
										step = 5, min = 0, max = 100,
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][5]),
										set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["a"]=val/100 vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["5"]["a"]*100 end
										},
									},
								},
							grpchangecolor6 = {
								name = "When 'Out of combat' and power is full",
								order=16, type ="group", dialogInline = true,
								args = {
									use = {
										name = "Change color",
										order=1, type = "toggle", width="full",
										desc = "",
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["use"][6]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["use"][6] end,
										},
									frametypecolored = {
										name = "Use blizzard's colors for mana/energy/etc",
										order=2, type = "toggle", width="full",
										desc = "",
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][6]),
										set = function(self,key) vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][6]=key vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][6] end,
										},
									frameenergycolor = {
										name = "Alternative color", width="double",
										order=3, type = "color", hasAlpha=false,
										desc = "background color used when not using blizzard's preset colors",
										disabled = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][6] or not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][6]),
										set = function(info,r,g,b,a)
											vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["r"]=r
											vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["g"]=g
											vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["b"]=b
											vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["r"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["g"],
											vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["b"] end,
										},
									opacityframe = {
										name = "Opacity %",
										order=4, type = "range",
										desc = "Sets the opacity",
										step = 5, min = 0, max = 100,
										disabled = not(vexpower_parameters["frame"]["energy"]["altcolors"]["use"][6]),
										set = function(info,val) vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["a"]=val/100 vexpower_initialize(true) end,
										get = function() return vexpower_parameters["frame"]["energy"]["altcolors"]["6"]["a"]*100 end
										},
									},
								},
							},
						},
					frameenergyusedcolor = {
						name = "Color for 'used'-energy", width="double",
						order=10, type = "color", hasAlpha=false,
						desc = "Color of the energy that has just been used",
						set = function(info,r,g,b,a)
							vexpower_parameters["frame"]["energy"]["usedcolor"]["r"]=r
							vexpower_parameters["frame"]["energy"]["usedcolor"]["g"]=g
							vexpower_parameters["frame"]["energy"]["usedcolor"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["usedcolor"]["r"],
							vexpower_parameters["frame"]["energy"]["usedcolor"]["g"],
							vexpower_parameters["frame"]["energy"]["usedcolor"]["b"] end,
						},
					opacityused = {
						name = "Opacity %",
						order=11, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["usedcolor"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["usedcolor"]["a"]*100 end
						},
					},
				},
			frame_space2 = {name ="\n", type = "description", order=4},
					
			grpbackground = {
				name = "Background",
				order=5, type ="group", dialogInline = true,
				args = {
					framebackdropbg = {
						name = "Background Texture",
						order=1, type = "select",
						dialogControl = "LSM30_Background",
						values = vexpower.LSM:HashTable("background"),
						set = function(self,key) vexpower_parameters["frame"]["energy"]["bg_texture"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["bg_texture"] end,
						},
					frameenergybgcolor = {
						name = "Background Color",
						order=2, type = "color", hasAlpha=false,
						set = function(info,r,g,b,a)
							vexpower_parameters["frame"]["energy"]["bgcolor"]["r"]=r
							vexpower_parameters["frame"]["energy"]["bgcolor"]["g"]=g
							vexpower_parameters["frame"]["energy"]["bgcolor"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["bgcolor"]["r"],
							vexpower_parameters["frame"]["energy"]["bgcolor"]["g"],
							vexpower_parameters["frame"]["energy"]["bgcolor"]["b"] end,
						},
					opacitybg = {
						name = "Background Opacity %",
						order=3, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["bgcolor"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["bgcolor"]["a"]*100 end
						},
					framebgspace = {name ="\n", type = "description", order=4},
					framebackdrop = {
						name = "Border Texture",
						order=5, type = "select",
						dialogControl = "LSM30_Border",
						values = vexpower.LSM:HashTable("border"),
						set = function(self,key) vexpower_parameters["frame"]["energy"]["border"]["texture"]=key vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["border"]["texture"] end,
						},
					frameenergybordercolor = {
						name = "Border Color",
						order=6, type = "color", hasAlpha=false,
						set = function(info,r,g,b,a)
							vexpower_parameters["frame"]["energy"]["border"]["color"]["r"]=r
							vexpower_parameters["frame"]["energy"]["border"]["color"]["g"]=g
							vexpower_parameters["frame"]["energy"]["border"]["color"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["border"]["color"]["r"],
							vexpower_parameters["frame"]["energy"]["border"]["color"]["g"],
							vexpower_parameters["frame"]["energy"]["border"]["color"]["b"] end,
						},
					opacityborder = {
						name = "Border Opacity %",
						order=7, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["border"]["color"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["border"]["color"]["a"]*100 end
						},
					frameenergybordersize = {
						name = "Border Size",
						order=8, type = "range",
						step = 1, min = 1, max = 15,
						set = function(info,val) vexpower_parameters["frame"]["energy"]["border"]["size"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["energy"]["border"]["size"] end
						},
					},
				},
			}
		}
end