function vexpower.panel_cps()
	return {
		type = "group",
		order= 5,
		args = {
			grptestmode = {
				name = "Test-mode",
				order=1, type ="group", dialogInline = true,
				args = {
					testmode = {
						name = "activate",
						order=1, type = "toggle", width="double",
						set = function(info,val) vexpower.testmode=val vexpower_test_starter(val) end,
						get = function() return vexpower.testmode end,
						},
					},
				},
			frame_space = {name ="\n", type = "description", order=2},
			grplayout = {
				name = "Layout",
				order=3, type ="group", dialogInline = true,
				args = {
					infopic={name = "", type="description", order=1, image="Interface\\AddOns\\vexpower\\images\\options_cps.tga",
						imageWidth=512, imageHeight=128},
					bordercolorspace = {name = "", type ="description", order=2},
					framex = {
						name = "X-Distance",
						order=10, type = "range",
						desc = "Sets the distance of the energybar to the combopoints",
						step = 1, min = -400, max = 400,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["measure"]["offset"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["measure"]["offset"] end
						},
					framey = {
						name = "Y-Distance",
						order=12, type = "range",
						desc = "Sets the distance of the energybar to the combopoints",
						step = 1, min = -400, max = 400,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["measure"]["y"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["measure"]["y"] end
						},
					bordercolorspace1 = {name = "", type ="description", order=15},
					frameheight = {
						name = "Height",
						order=16, type = "range",
						desc = "Height of the combopoints",
						step = 1, min = 1, max = 400,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["measure"]["height"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["measure"]["height"] end
						},
					framegap = {
						name = "Gap",
						order=17, type = "range",
						desc = "Distance between the individual combopoints",
						step = 1, min = 1, max = 400,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["measure"]["gap"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["measure"]["gap"] end
						},
					bordercolorspace2 = {name = "", type ="description", order=20},
					framebordersize = {
						name = "Border size",
						order=21, type = "range",
						desc = "Sets the size of the border",
						step = 1, min = 1, max = 10,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["border"]["size"]=val vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["border"]["size"] end
						},
					framebordercolor = {
						name = "Border color",
						order=22, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["border"]["color"]["r"]=r
							vexpower_parameters["frame"]["combo"]["border"]["color"]["g"]=g
							vexpower_parameters["frame"]["combo"]["border"]["color"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["border"]["color"]["r"],
							vexpower_parameters["frame"]["combo"]["border"]["color"]["g"],
							vexpower_parameters["frame"]["combo"]["border"]["color"]["b"] end,
						},
					opacityborder = {
						name = "Border opacity %",
						order=23, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["border"]["color"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["border"]["color"]["a"]*100 end
						},
					},
				},
			frame_space1 = {name ="\n", type = "description", order=4},
				
			grpcolors = {
				name = "Background colors",
				order=5, type ="group", dialogInline = true,
				args = {
					framecolors1 = {
						name = "Color of the 1st combopoint/soulshard/holypower", width="double",
						order=110, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["r"]=r
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["g"]=g
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["r"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["g"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["b"] end,
						},
					opacity1 = {
						name = "Opacity %",
						order=111, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["1"]["a"]*100 end
						},
					framecolors2 = {
						name = "Color of the 2nd combopoint/soulshard/holypower", width="double",
						order=120, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["r"]=r
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["g"]=g
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["r"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["g"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["b"] end,
						},
					opacity2 = {
						name = "Opacity %",
						order=121, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["2"]["a"]*100 end
						},
					framecolors3 = {
						name = "Color of the 3rd combopoint/soulshard/holypower", width="double",
						order=130, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["r"]=r
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["g"]=g
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["r"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["g"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["b"] end,
						},
					opacity3 = {
						name = "Opacity %",
						order=131, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["3"]["a"]*100 end
						},
					framecolors4 = {
						name = "Color of the 4th combopoint", width="double",
						order=140, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["r"]=r
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["g"]=g
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["r"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["g"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["b"] end,
						},
					opacity4 = {
						name = "Opacity %",
						order=141, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["4"]["a"]*100 end
						},
					framecolors5 = {
						name = "Color of the 5th combopoint", width="double",
						order=150, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["r"]=r
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["g"]=g
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["r"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["g"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["b"] end,
						},
					opacity5 = {
						name = "Opacity %",
						order=151, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["5"]["a"]*100 end
						},
					framecolorsusedspace = {name = "\n\n", type="description", order=199},
					framecolorsused = {
						name = "Color for a used combopoint that fades out", width="double",
						order=200, type = "color", hasAlpha=false,
						set = function(info,r,g,b)
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["r"]=r
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["g"]=g
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["b"]=b
							vexpower_initialize(true) end,
						get = function() return
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["r"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["g"],
							vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["b"] end,
						},
					opacityused = {
						name = "Opacity %",
						order=201, type = "range",
						desc = "Sets the opacity",
						step = 5, min = 0, max = 100,
						set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["a"]=val/100 vexpower_initialize(true) end,
						get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["used"]["a"]*100 end
						},
					framecolorchangespace2 = {name = "\n\n", type="description", order=300},
							
					grpchangeCPsOnX = {
						name = "Color ComboPoints on X",
						order=400, type ="group", dialogInline = true,
						args = {
							changeOnXinfo = {name = "Activating this option will change the color of your ComboPoints. The change will take effect as long as you have X or more ComboPoints and will act like a visual alarm.", type="description", order=1, fontSize="medium"},
							activatechange = {
								name = "Activate",
								order=301, type = "toggle", width="double",
								set = function(self,key) vexpower_parameters["frame"]["combo"]["bg"]["allowchange"]=key vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["combo"]["bg"]["allowchange"] end,
								},
							changex = {
								name = "X",
								order=302, type = "range",
								step = 1, min = 1, max = 15,
								disabled = not(vexpower_parameters["frame"]["combo"]["bg"]["allowchange"]),
								set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["cpchange"]=val vexpower_initialize(true) end,
								get = function() return tonumber(vexpower_parameters["frame"]["combo"]["bg"]["cpchange"]) end
								},
							activatechangeall = {
								name = "Change only the color of the first X ComboPoints, instead of all",
								order=303, type = "toggle", width="full",
								disabled = not(vexpower_parameters["frame"]["combo"]["bg"]["allowchange"]),
								set = function(self,key) vexpower_parameters["frame"]["combo"]["bg"]["cpchangeonly"]=key vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["combo"]["bg"]["cpchangeonly"] end,
								},
							framecolorschange = {
								name = "new color", width="double",
								order=305, type = "color", hasAlpha=false,
								disabled = not(vexpower_parameters["frame"]["combo"]["bg"]["allowchange"]),
								set = function(info,r,g,b)
									vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["r"]=r
									vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["g"]=g
									vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["b"]=b
									vexpower_initialize(true) end,
								get = function() return
									vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["r"],
									vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["g"],
									vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["b"] end,
								},
							opacitychange = {
								name = "Opacity %",
								order=306, type = "range",
								desc = "Sets the opacity",
								step = 5, min = 0, max = 100,
								disabled = not(vexpower_parameters["frame"]["combo"]["bg"]["allowchange"]),
								set = function(info,val) vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["a"]=val/100 vexpower_initialize(true) end,
								get = function() return vexpower_parameters["frame"]["combo"]["bg"]["color"]["change"]["a"]*100 end
								},
							},
						},
					},
				},
			}
		}
end





