local defaults = {}
vexpower_defaults = {
	["variableversion"] = 2,
	["frame"] = {
		["infightshow"] = false,
		["stealthshow"] = true,
		["show"] = true, 
		["energy"] = {
			["show"] = true, 
			["showwithmana"] = true,
			["size"] = {["width"]=400,  ["height"]=30},
			["position"] = {["x"]=0,  ["y"]=0, ["anchor"]="CENTER", ["anchorFrame"]="CENTER"},
			["typecolored"]=true,
			["bgcolor"]={["r"]=0, ["g"]=0, ["b"]=0, ["a"]=0.5},
			["color"]={["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
			["altcolors"] = {
				["full"] = 0.95,
				["empty"] = 0.05,
				["use"] = {false, false, false, false, false, false},
				["typecolored"] = {false, false, false, false, false, false},
				["1"] = {["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
				["2"] = {["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
				["3"] = {["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
				["4"] = {["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
				["5"] = {["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
				["6"] = {["r"]=1, ["g"]=1, ["b"]=0, ["a"]=1},
				},
			["alphabyenergy"]=false,
			["border"] = {
				["texture"] = "Solid",
				["color"]={["r"]=0, ["g"]=0, ["b"]=0, ["a"]=1},
				["size"]=2,
				},
			["textureToUse"] = 1,
			["bg"]="Solid",
			["bg2"]="None",
			["bg_texture"]="Solid",
			["markers"]={
				--delete markers
				["points"] =  {},
				["points_spec_a"] =  {},
				["points_spec_b"] =  {},
				["width"] = 3,
				["color"] = {["r"]=0, ["g"]=0, ["b"]=0, ["a"]=1},
				["color_likebg"] = false,
				["border"] = {
					["color"] = {["r"]=0, ["g"]=0, ["b"]=0, ["a"]=1},
					["size"] = 1,
					["color_likebg"] = false,
					},
				},
			["usedcolor"] = {["r"]=1, ["g"]=0.6, ["b"]=0, ["a"]=1},
			["text"]={
				["left"]={
					["text"]="{CurrentEnergy}",
					["font"]="Friz Quadrata TT",
					["size"]=14,
					["align"]="LEFT",
					["x"]=5, ["y"]=-7,
					["width"]=100,
					["color"]={["r"]=1, ["g"]=1, ["b"]=1, ["a"]=1},
					["effect"]="OUTLINE",
					["shadow"]={
						["allow"] = false,
						["offset"] = {["x"] = 5, ["y"] = 5},
						["color"] = {["r"]=0, ["g"]=0, ["b"]=0, ["a"]=1},
						}
					},
				["right"]={["font"]="Friz Quadrata TT",
					["text"]="{MaxEnergy}",
					["size"]=14,
					["align"]="RIGHT",
					["x"]=-5, ["y"]=-7,
					["width"]=100,
					["color"]={["r"]=1, ["g"]=1, ["b"]=1, ["a"]=1},
					["effect"]="OUTLINE",
					["shadow"]={
						["allow"] = false,
						["offset"] = {["x"] = 5, ["y"] = 5},
						["color"] = {["r"]=0, ["g"]=0, ["b"]=0, ["a"]=1},
						}
					}
				}
			},
		["combo"] = {
			["show"] = true,
			["showWithoutEnergy"] = true,
			["measure"] = {
				["y"] = 40,
				["gap"] = 10,
				["offset"] = 20,
				["height"] = 30
				},
			["bg"] = {
				["allowchange"] = true,
				["cpchange"] = "3",
				["cpchangeonly"] = false,
				["color"] = {
					["1"] = {["r"]=1, ["g"]=0.929, ["b"]=0.0156, ["a"]=1},
					["2"] = {["r"]=0.7725, ["g"]=1, ["b"]=0.043, ["a"]=1},
					["3"] = {["r"]=0.314, ["g"]=1, ["b"]=0.6666, ["a"]=1},
					["4"] = {["r"]=0, ["g"]=1, ["b"]=0.753, ["a"]=1},
					["5"] = {["r"]=0.0078, ["g"]=0.757, ["b"]=1, ["a"]=1},
					["change"] = {["r"]=1, ["g"]=0, ["b"]=0, ["a"]=1},
					["used"] = {["r"]=1, ["g"]=0.6, ["b"]=0, ["a"]=1},
					},
				},
			["border"] = {
				["size"] = 1,
				["color"] = {["r"]=0, ["g"]=0, ["b"]=0, ["a"]=1},
				},
			}
		}
	}

function vexpower_loaddefaults(force)
	vexpower_parameters =  vexpower_check_tablecontent(vexpower_defaults, vexpower_parameters, force)
	if vexpower_parameters["variableversion"] < 2 then
		vexpower_parameters["frame"]["energy"]["position"]["x"] = vexpower_parameters["frame"]["energy"]["position"]["x"] + vexpower_parameters["frame"]["energy"]["size"]["width"]/2
		vexpower_parameters["frame"]["energy"]["position"]["y"] = vexpower_parameters["frame"]["energy"]["position"]["y"] - vexpower_parameters["frame"]["energy"]["size"]["height"]/2
		vexpower_parameters["variableversion"] = 2
	end
	
	if vexpower_profiles == nil then vexpower_profiles = { } end
	if vexpower_profiles["profilelist"] == nil then vexpower_profiles["profilelist"] = {} end
		
	if force then vexpower_initialize(true) end
end

function vexpower_check_tablecontent(defaults, saved, force)
	local temp = {}
	if force or type(saved) ~= "table" then temp=defaults
	else
		for key,val in pairs(defaults) do
			if type(val) == "table" then
				temp[key] = {}
				if saved[key] == nil then
					temp[key] = val
				else
					temp[key] = vexpower_check_tablecontent(defaults[key], saved[key], force)
				end
			else
				if saved[key] == nil then
					temp[key] = val
				else
					temp[key] = saved[key]
				end
			end
		end
		
		--adds information that is not in the defaults list. eg. 'markers'
		for key,val in pairs(saved) do
			if type(val) == "table" then
				temp[key] = {}
				if defaults[key] == nil then
					temp[key] = val
				else
					temp[key] = vexpower_check_tablecontent(defaults[key], saved[key], force)
				end
			else
				if defaults[key] == nil then
					temp[key] = val
				else
					temp[key] = saved[key]
				end
			end
		end
	end
	return temp
end
