function vexpower_changeEnergy(energyTypeChanged, newenergy)
	if vexpower.show then
		if energyTypeChanged then
			if vexpower_energybarDif_anigrp:IsPlaying() then
				vexpower_energybarDif_anigrp:Stop()
			end
			if vexpower_energybar_anigrp:IsPlaying() then
				vexpower_energybar_anigrp:Stop()
			end
			vexpower_energybar:SetWidth(vexpower.maxwidth)
			vexpower_changeEnergy()
		else
			if not(vexpower_energybar_anigrp:IsPlaying()) then
				if newenergy ~= nil then
					vexpower.currentenergy_prev = vexpower.currentenergy
					vexpower.currentenergy = vexpower.currentenergy + newenergy
				else vexpower_setEnergyCurrent() end
				vexpower_setEnergyMax()
				vexpower_changeEnergyText()
				local maxenergy = vexpower.maxenergy
				if maxenergy == 0 then maxenergy = 1 end
				local barfactor_current = vexpower.currentenergy_prev/maxenergy
				local barfactor_new = vexpower.currentenergy/maxenergy
				local barfactor = 0
				
				if barfactor_current ~= 0 then 
					barfactor = barfactor_new/barfactor_current
				end
				
				local newWidth = vexpower_getEnergyWidth(vexpower.currentenergy)
								
				if barfactor < 1 and barfactor > 0 then
					local oldWidth = vexpower_getEnergyWidth(vexpower.currentenergy_prev)
					local difWidth = oldWidth - newWidth
					vexpower_energybar_ani:SetScale(barfactor, 1)
					if vexpower.energytype == "RAGE" or vexpower.energytype == "RUNIC_POWER" then
						vexpower_energybar_anigrp:SetScript("onFinished", function () vexpower_energybar:SetWidth(newWidth) end)
					end
					vexpower_energybar_anigrp:Play()
					
					if oldWidth<=vexpower.maxwidth then
						vexpower_energybarDif:SetWidth(difWidth)
						vexpower_energybarDif:ClearAllPoints()
						vexpower_energybarDif:SetPoint("TOPLEFT", vexpower_energybarbg, "TOPLEFT",
									vexpower_parameters["frame"]["energy"]["border"]["size"]+newWidth,
									-vexpower_parameters["frame"]["energy"]["border"]["size"])
							vexpower_energybarDif_anigrp:Play()
					else
						vexpower_energybarDif:Hide()
					end
				else 
					vexpower_energybar:SetWidth(newWidth)
				end
				vexpower_setEnergybarColor()
			end
		end
	end
end

function vexpower_changeEnergyText()
	local lefttemplate = vexpower_parameters["frame"]["energy"]["text"]["left"]["text"]
	local righttemplate = vexpower_parameters["frame"]["energy"]["text"]["right"]["text"]
	local percenergy = 0
	if vexpower.maxenergy ~= 0 then	percenergy = math.floor((vexpower.currentenergy/vexpower.maxenergy)*100) end
	lefttemplate = string.gsub(lefttemplate, "{CurrentEnergy}", vexpower.currentenergy)
	lefttemplate = string.gsub(lefttemplate, "{CurrentManaSmart}", vexpower_GetEnergyShort(vexpower.currentenergy,1))
	lefttemplate = string.gsub(lefttemplate, "{CurrentManaShort}", vexpower_GetEnergyShort(vexpower.currentenergy))
	lefttemplate = string.gsub(lefttemplate, "{MaxEnergy}", vexpower.maxenergy)
	lefttemplate = string.gsub(lefttemplate, "{MaxManaSmart}", vexpower_GetEnergyShort(vexpower.maxenergy,1))
	lefttemplate = string.gsub(lefttemplate, "{MaxManaShort}", vexpower_GetEnergyShort(vexpower.maxenergy))
	lefttemplate = string.gsub(lefttemplate, "{MissingEnergy}", vexpower.maxenergy-vexpower.currentenergy)
	lefttemplate = string.gsub(lefttemplate, "{PercEnergy}", tostring(percenergy).."%%")
	lefttemplate = string.gsub(lefttemplate, "{CurrentCPs}", tostring(vexpower.currentcps))
	lefttemplate = string.gsub(lefttemplate, "{MaxCPs}", tostring(vexpower.maxcps))
	
	righttemplate = string.gsub(righttemplate, "{CurrentEnergy}", vexpower.currentenergy)
	righttemplate = string.gsub(righttemplate, "{CurrentManaSmart}", vexpower_GetEnergyShort(vexpower.currentenergy,1))
	righttemplate = string.gsub(righttemplate, "{CurrentManaShort}", vexpower_GetEnergyShort(vexpower.currentenergy))
	righttemplate = string.gsub(righttemplate, "{MaxEnergy}", vexpower.maxenergy)
	righttemplate = string.gsub(righttemplate, "{MaxManaSmart}", vexpower_GetEnergyShort(vexpower.maxenergy,1))
	righttemplate = string.gsub(righttemplate, "{MaxManaShort}", vexpower_GetEnergyShort(vexpower.maxenergy))
	righttemplate = string.gsub(righttemplate, "{MissingEnergy}", vexpower.maxenergy-vexpower.currentenergy)
	righttemplate = string.gsub(righttemplate, "{PercEnergy}", ""..percenergy.."%%")
	righttemplate = string.gsub(righttemplate, "{CurrentCPs}", tostring(vexpower.currentcps))
	righttemplate = string.gsub(righttemplate, "{MaxCPs}", tostring(vexpower.maxcps))
	
	vexpower_energytext_left:SetText(lefttemplate)
	vexpower_energytext_right:SetText(righttemplate)
end

function vexpower_GetEnergyShort(amount, dec)
	local returnvalue = ""
	if dec == 1 then
		local amount = tonumber(amount)/100
		amount = vexpower_CeilNumber(tonumber(amount))
		amount = tostring(amount / 10)
		if string.find(amount, "%.") == nil then
			amount = amount..".0"
		end
		returnvalue = amount
	else
		local amount = tonumber(amount)/1000
		amount = vexpower_CeilNumber(tonumber(amount))
		returnvalue = tostring(amount)
	end
	return returnvalue
end

function vexpower_CeilNumber(amount)
	local returnvalue = ""
	amount = tostring(amount)
	if string.find(amount, "%.") ~= nil then
		local amount_l = string.gsub(amount, "%.%d+$", "")
		local amount_r = string.gsub(amount, "^%d+%.", "0.")
		amount_l = tonumber(amount_l)
		amount_r = tonumber(amount_r)
		if amount_r >= 0.5 then
			amount_l = amount_l+1
		end
		returnvalue = amount_l
	else
		returnvalue = tonumber(amount)
	end
	return returnvalue
end

function vexpower_setEnergybarBG()
	vexpower_energybarbg:SetBackdrop({bgFile=vexpower.LSM:Fetch("background", vexpower_parameters["frame"]["energy"]["bg_texture"]),
									edgeFile=vexpower.LSM:Fetch("border", vexpower_parameters["frame"]["energy"]["border"]["texture"]), tile=false,
										edgeSize=vexpower_parameters["frame"]["energy"]["border"]["size"]})
	vexpower_energybarbg:SetBackdropColor(	vexpower_parameters["frame"]["energy"]["bgcolor"]["r"],
											vexpower_parameters["frame"]["energy"]["bgcolor"]["g"],
											vexpower_parameters["frame"]["energy"]["bgcolor"]["b"],
											vexpower_parameters["frame"]["energy"]["bgcolor"]["a"])
	vexpower_energybarbg:SetBackdropBorderColor(	vexpower_parameters["frame"]["energy"]["border"]["color"]["r"],
													vexpower_parameters["frame"]["energy"]["border"]["color"]["g"],
													vexpower_parameters["frame"]["energy"]["border"]["color"]["b"],
													vexpower_parameters["frame"]["energy"]["border"]["color"]["a"])
	vexpower_energybarbg:SetWidth(vexpower_parameters["frame"]["energy"]["size"]["width"])
	vexpower_energybarbg:SetHeight(vexpower_parameters["frame"]["energy"]["size"]["height"])
	vexpower_energybarbg:ClearAllPoints()
	vexpower_energybarbg:SetPoint("CENTER", vexpower_MainFrame, "CENTER", 0, 0)
	vexpower_energybarbg:SetFrameStrata("LOW")
	vexpower_energybarbg:RegisterForDrag("LeftButton")
	vexpower_energybarbg:SetScript("OnDragStart", function () vexpower_MainFrame:StartMoving() end)
	vexpower_energybarbg:SetScript("OnDragStop", function () vexpower_MainFrame:StopMovingOrSizing() vexpower_saveFramePos() end)
	vexpower_energybarbg:SetMovable(false)
	vexpower_energybarbg:EnableMouse(false)
end

function vexpower_setEnergybar()
	if vexpower_parameters["frame"]["energy"]["textureToUse"] == 1 then
		vexpower_energybar:SetBackdrop({bgFile=vexpower.LSM:Fetch("background", vexpower_parameters["frame"]["energy"]["bg"]), tile=false,
								edgeFile="Interface\\Buttons\\WHITE8X8", edgeSize=1})
	else
		vexpower_energybar:SetBackdrop({bgFile=vexpower.LSM:Fetch("statusbar", vexpower_parameters["frame"]["energy"]["bg2"]), tile=false,
								edgeFile="Interface\\Buttons\\WHITE8X8", edgeSize=1})
	end
	vexpower_setEnergybarColor()
	vexpower_energybar:SetBackdropBorderColor(1,1,1,0)
	
	if not(vexpower.testmode) then
		if vexpower.class == "WARRIOR" or vexpower.class == "DEATHKNIGHT" then vexpower_energybar:SetWidth(1)
		else vexpower_energybar:SetWidth(vexpower.maxwidth) end
		vexpower_energybar:Show()
	end
	vexpower_energybar:SetHeight(vexpower_parameters["frame"]["energy"]["size"]["height"]-(vexpower_parameters["frame"]["energy"]["border"]["size"]*2))
	vexpower_energybar:ClearAllPoints()
	vexpower_energybar:SetPoint("TOPLEFT", vexpower_energybarbg, "TOPLEFT",
						vexpower_parameters["frame"]["energy"]["border"]["size"],
						-vexpower_parameters["frame"]["energy"]["border"]["size"])
	vexpower_energybar_anigrp = vexpower_energybar:CreateAnimationGroup("vexpower_energybar_anigrp")
	vexpower_energybar_anigrp:SetLooping("NONE")
	vexpower_energybar_ani = vexpower_energybar_anigrp:CreateAnimation("Scale")
	vexpower_energybar_ani:SetSmoothing("OUT")
	vexpower_energybar_ani:SetDuration(0.2)
	vexpower_energybar_ani:SetOrder(1)
	vexpower_energybar_ani:SetOrigin("TOPLEFT",0,0)
end

function vexpower_setEnergybarColor()
	local coloring = {}
	coloring = vexpower_getEnergyBarColor()
	if coloring[1] == "standard" then
		if coloring[2] then
			vexpower_energybar:SetBackdropColor(	PowerBarColor[vexpower.energytype].r,
													PowerBarColor[vexpower.energytype].g,
													PowerBarColor[vexpower.energytype].b,
													vexpower_parameters["frame"]["energy"]["color"]["a"])
		else
			vexpower_energybar:SetBackdropColor(	vexpower_parameters["frame"]["energy"]["color"]["r"],
													vexpower_parameters["frame"]["energy"]["color"]["g"],
													vexpower_parameters["frame"]["energy"]["color"]["b"],
													vexpower_parameters["frame"]["energy"]["color"]["a"])
		end
	else
		if coloring[2] then
			vexpower_energybar:SetBackdropColor(	PowerBarColor[vexpower.energytype].r,
													PowerBarColor[vexpower.energytype].g,
													PowerBarColor[vexpower.energytype].b,
													vexpower_parameters["frame"]["energy"]["altcolors"][coloring[1]]["a"])
		else
			vexpower_energybar:SetBackdropColor(	vexpower_parameters["frame"]["energy"]["altcolors"][coloring[1]]["r"],
													vexpower_parameters["frame"]["energy"]["altcolors"][coloring[1]]["g"],
													vexpower_parameters["frame"]["energy"]["altcolors"][coloring[1]]["b"],
													vexpower_parameters["frame"]["energy"]["altcolors"][coloring[1]]["a"])
		end
	end
end

function vexpower_getEnergyBarColor()
	local situation = 0
	local perc_energy = 0.5
	local returnvalue = {}
	returnvalue[1] = "standard"
	returnvalue[2] = vexpower_parameters["frame"]["energy"]["typecolored"]
	if vexpower.maxenergy ~= 0 then
		perc_energy = vexpower.currentenergy / vexpower.maxenergy
	end
	
	if vexpower.infight then
		if perc_energy < vexpower_parameters["frame"]["energy"]["altcolors"]["empty"] 		then situation = 1
		elseif perc_energy > vexpower_parameters["frame"]["energy"]["altcolors"]["full"]	then situation = 3
		else					 																 situation = 2
		end
	else
		if perc_energy < vexpower_parameters["frame"]["energy"]["altcolors"]["empty"] 		then situation = 4
		elseif perc_energy > vexpower_parameters["frame"]["energy"]["altcolors"]["full"]	then situation = 6
		else					 																 situation = 5
		end
	end
	if vexpower_parameters["frame"]["energy"]["altcolors"]["use"][situation] then
		returnvalue[1] = tostring(situation)
		returnvalue[2] = vexpower_parameters["frame"]["energy"]["altcolors"]["typecolored"][situation]
	end
	return returnvalue
end

function vexpower_setEnergyTextbar()
	vexpower_energyTextbar:SetBackdrop({bgFile="Interface\\Buttons\\WHITE8X8", edgeFile="Interface\\Buttons\\WHITE8X8", tile=false, edgeFile="Interface\\Buttons\\WHITE8X8", edgeSize=1})
	vexpower_energyTextbar:SetBackdropColor(0, 0, 0, 0)
	vexpower_energyTextbar:SetBackdropBorderColor(1,1,1,0)
	vexpower_energyTextbar:SetWidth(vexpower.maxwidth)
	vexpower_energyTextbar:SetHeight(vexpower_parameters["frame"]["energy"]["size"]["height"]-(vexpower_parameters["frame"]["energy"]["border"]["size"]*2))
	vexpower_energyTextbar:ClearAllPoints()
	vexpower_energyTextbar:SetPoint("TOPLEFT", vexpower_energybarbg, "TOPLEFT",
						vexpower_parameters["frame"]["energy"]["border"]["size"],
						-vexpower_parameters["frame"]["energy"]["border"]["size"])
end

function vexpower_setEnergybarDif()
	vexpower_energybarDif:SetBackdrop({bgFile="Interface\\Buttons\\WHITE8X8", edgeFile="Interface\\Buttons\\WHITE8X8", tile=false, edgeSize=1})	
	vexpower_energybarDif:SetBackdropColor(	vexpower_parameters["frame"]["energy"]["usedcolor"]["r"],
											vexpower_parameters["frame"]["energy"]["usedcolor"]["g"],
											vexpower_parameters["frame"]["energy"]["usedcolor"]["b"],
											vexpower_parameters["frame"]["energy"]["usedcolor"]["a"])
	vexpower_energybarDif:SetBackdropBorderColor(1,1,1,0)
	if not(vexpower.testmode) then
		vexpower_energybarDif:SetWidth(0)
		vexpower_energybarDif:Hide()
	end
	vexpower_energybarDif:SetHeight(vexpower_parameters["frame"]["energy"]["size"]["height"]-(vexpower_parameters["frame"]["energy"]["border"]["size"]*2))
	vexpower_energybarDif:ClearAllPoints()
	vexpower_energybarDif:SetPoint("TOPLEFT", vexpower_energybarbg, "TOPLEFT",
						vexpower_parameters["frame"]["energy"]["border"]["size"],
						-vexpower_parameters["frame"]["energy"]["border"]["size"])
	vexpower_energybarDif_anigrp = vexpower_energybarDif:CreateAnimationGroup("vexpower_energybarDif_anigrp")
	vexpower_energybarDif_anigrp:SetLooping("NONE")
	vexpower_energybarDif_anigrp:SetScript("OnPlay", function () vexpower_energybarDif:Show() end)
	vexpower_energybarDif_anigrp:SetScript("OnFinished", function () vexpower_energybarDif:Hide() end)
	vexpower_energybarDif_anigrp:SetScript("OnStop", function () vexpower_energybarDif:Hide() end)
	vexpower_energybarDif_ani = vexpower_energybarDif_anigrp:CreateAnimation("Alpha")
	vexpower_energybarDif_ani:SetDuration(0.5)
	vexpower_energybarDif_ani:SetOrder(1)
	vexpower_energybarDif_ani:SetChange(-1)
end

function vexpower_setFontStrings()
	-- FontString 1
	vexpower_energytext_left:ClearAllPoints()
	vexpower_energytext_left:SetPoint("TOPLEFT", vexpower_energyTextbar, "TOPLEFT" , vexpower_parameters["frame"]["energy"]["text"]["left"]["x"], vexpower_parameters["frame"]["energy"]["text"]["left"]["y"])
	vexpower_energytext_left:SetTextColor(vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["r"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["g"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["b"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["color"]["a"])
	vexpower_energytext_left:SetFont(vexpower.LSM:Fetch("font", vexpower_parameters["frame"]["energy"]["text"]["left"]["font"]),
									vexpower_parameters["frame"]["energy"]["text"]["left"]["size"],
									vexpower_parameters["frame"]["energy"]["text"]["left"]["effect"])	
	vexpower_energytext_left:SetWidth(vexpower_parameters["frame"]["energy"]["text"]["left"]["width"])	
	vexpower_energytext_left:SetJustifyH(vexpower_parameters["frame"]["energy"]["text"]["left"]["align"])
	if vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["allow"] then	
		vexpower_energytext_left:SetShadowColor(vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["r"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["g"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["b"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["color"]["a"])
		vexpower_energytext_left:SetShadowOffset(vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["offset"]["x"],
											vexpower_parameters["frame"]["energy"]["text"]["left"]["shadow"]["offset"]["y"])
	else
		vexpower_energytext_left:SetShadowColor(0, 0, 0, 0)
		vexpower_energytext_left:SetShadowOffset(0, 0)
	end
	
	
	-- FontString 2
	vexpower_energytext_right:ClearAllPoints()
	vexpower_energytext_right:SetPoint("TOPRIGHT", vexpower_energyTextbar, "TOPRIGHT" , vexpower_parameters["frame"]["energy"]["text"]["right"]["x"], vexpower_parameters["frame"]["energy"]["text"]["right"]["y"])
	vexpower_energytext_right:SetTextColor(vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["r"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["g"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["b"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["color"]["a"])
	vexpower_energytext_right:SetFont(vexpower.LSM:Fetch("font", vexpower_parameters["frame"]["energy"]["text"]["right"]["font"]),
									vexpower_parameters["frame"]["energy"]["text"]["right"]["size"],
									vexpower_parameters["frame"]["energy"]["text"]["right"]["effect"])	
	vexpower_energytext_right:SetWidth(vexpower_parameters["frame"]["energy"]["text"]["right"]["width"])	
	vexpower_energytext_right:SetJustifyH(vexpower_parameters["frame"]["energy"]["text"]["right"]["align"])
	
	if vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["allow"] then	
		vexpower_energytext_right:SetShadowColor(vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["r"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["g"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["b"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["color"]["a"])
		vexpower_energytext_right:SetShadowOffset(vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["offset"]["x"],
											vexpower_parameters["frame"]["energy"]["text"]["right"]["shadow"]["offset"]["y"])
	else
		vexpower_energytext_right:SetShadowColor(0, 0, 0, 0)
		vexpower_energytext_right:SetShadowOffset(0, 0)
	end
	
end

function vexpower_setEnergyMax()
	if UnitPowerMax("player") ~= vexpower.maxenergy then
		vexpower.maxenergy_prev = vexpower.maxenergy
		vexpower.maxenergy = UnitPowerMax("player")
		vexpower_markerHandler()
	end
end

function vexpower_setEnergyCurrent()
	local new = UnitPower("player")
	if new ~= vexpower.currentenergy then
		vexpower.currentenergy_prev = vexpower.currentenergy
		vexpower.currentenergy = new
	end
end

function vexpower_getEnergyWidth(energy)
	local width = 0
	if vexpower.maxenergy~=0 then
		if not(string.find(energy, "%%")) then
			width = (energy / vexpower.maxenergy) * vexpower.maxwidth
		else
			local energypercentage = string.gsub(energy, "%%", "")
			energypercentage = energypercentage/100
			width = energypercentage * vexpower.maxwidth
		end
	end
	if width == 0 then width = 1 end
	return width
end

function vexpower_setMaxWidth()
	local newwidth = vexpower_parameters["frame"]["energy"]["size"]["width"]-(vexpower_parameters["frame"]["energy"]["border"]["size"]*2)
	if vexpower.maxwidth ~= newwidth then
		vexpower.maxwidth = newwidth
		vexpower_markerHandler()
	end
end

function vexpower_setEnergyType()
	vexpower.energytype = select(2, UnitPowerType("player"))
	vexpower_setEnergybarColor()
end