function vexpower_getCpsCurrent(change)
	local new = 0
	
	if vexpower.class == "DRUID" or vexpower.class == "ROGUE"	then new = GetComboPoints("player")
	elseif vexpower.class == "PALADIN" 							then new = UnitPower("player", 9)
	elseif vexpower.class == "MONK"								then new = UnitPower("player", 12) 
	elseif vexpower.class == "PRIEST"							then new = UnitPower("player", 13) 
	elseif vexpower.class == "WARLOCK" 							then new = UnitPower("player", 7)
	end
	
	if change ~= nil then new = vexpower.currentcps+change end

	return new
end

function vexpower_setCpsCurrent(change)
	local new = vexpower_getCpsCurrent(change)
	
	if change ~= nil then new = vexpower.currentcps+change end
	
	if new ~= vexpower.currentcps then
		vexpower.currentcps_prev = vexpower.currentcps
		vexpower.currentcps = new
	end
end

function vexpower_getCpsMax()
	local temp = 0
	if vexpower.class == "ROGUE"			then temp = 5	
	elseif vexpower.class == "PALADIN"		then temp = UnitPowerMax("player", 9)
	elseif vexpower.class == "MONK"			then temp = UnitPowerMax("player", 12) 
	elseif vexpower.class == "DRUID"		then temp = 5
	elseif vexpower.class == "PRIEST"		then temp = UnitPowerMax("player", 13) 
	elseif vexpower.class == "WARLOCK"		then temp = UnitPowerMax("player", 7) end
	return temp
end

function vexpower_setCpsMax()
	vexpower.maxcps = vexpower_getCpsMax()
end

function vexpower_changeCps(change)
	vexpower_setCpsCurrent(change)
	if vexpower.currentcps > vexpower.currentcps_prev then
		--CPs built
		for i=1, vexpower.currentcps do
			vexpower_setCpsBarsBGColor(i, true)
			if vexpower.cpsbars_anigrps[i]:IsPlaying() then vexpower.cpsbars_anigrps[i]:Stop() end
			vexpower.cpsbars[i]:Show()
		end
	else
		--CPs used
		for i=1, vexpower.maxcps do
			vexpower_setCpsBarsBGColor(i, true)
		end
		
		local cpsLost = vexpower.currentcps_prev-vexpower.currentcps
		
		for i=1, cpsLost do
			local bar = vexpower.currentcps_prev+1-i
			vexpower_setCpsBarsBGColor(bar, false) vexpower.cpsbars_anigrps[bar]:Play()
		end
	end
end

function vexpower_setCpsBarsBGColor(cp, standard)
	if vexpower.cpsbars[cp] ~=nil then
		local color = tostring(cp)
		if vexpower_parameters["frame"]["combo"]["bg"]["allowchange"] and vexpower.currentcps >= tonumber(vexpower_parameters["frame"]["combo"]["bg"]["cpchange"]) then
			if (vexpower_parameters["frame"]["combo"]["bg"]["cpchangeonly"] and cp <= tonumber(vexpower_parameters["frame"]["combo"]["bg"]["cpchange"])) or
						not(vexpower_parameters["frame"]["combo"]["bg"]["cpchangeonly"])  				then color = "change"
			end
		end
		if not(standard) then color = "used" end
		vexpower.cpsbars[cp]:SetBackdropColor(	vexpower_parameters["frame"]["combo"]["bg"]["color"][color]["r"],
												vexpower_parameters["frame"]["combo"]["bg"]["color"][color]["g"],
												vexpower_parameters["frame"]["combo"]["bg"]["color"][color]["b"],
												vexpower_parameters["frame"]["combo"]["bg"]["color"][color]["a"])
	end
end

function vexpower_setCpsBars()
	if not(vexpower.testmode) then
		if vexpower.cpsbars ~= nil then
			for i=1, #vexpower.cpsbars do
				if vexpower.cpsbars[i] ~= nil then vexpower.cpsbars[i]:Hide() end
			end
		end
	end
	
	local offset_total = vexpower_parameters["frame"]["combo"]["measure"]["offset"]*2
	local gap_total = (vexpower.maxcps-1)*vexpower_parameters["frame"]["combo"]["measure"]["gap"]
	
	local width = 0
	if vexpower.maxcps == 0 then width = (vexpower_parameters["frame"]["energy"]["size"]["width"] - gap_total - offset_total)
	else 						 width = (vexpower_parameters["frame"]["energy"]["size"]["width"] - gap_total - offset_total)/vexpower.maxcps end

	local start = {}
	start[1] = vexpower_parameters["frame"]["combo"]["measure"]["offset"]
	if vexpower.maxcps > 1 then
		for i=2, vexpower.maxcps do
			start[i] = start[i-1]+width+vexpower_parameters["frame"]["combo"]["measure"]["gap"]
		end
	end
	
	local animationduration = 0.3
	
	
	
	--Setup CPs
	for i=1, vexpower.maxcps do
		
		if not(vexpower.testmode) then
			vexpower.cpsbars[i] = CreateFrame("Frame", nil, vexpower_cpsbar)
		end
		vexpower.cpsbars[i]:SetBackdrop({bgFile="Interface\\Buttons\\WHITE8X8", edgeFile="Interface\\Buttons\\WHITE8X8", tile=false,
											edgeSize=vexpower_parameters["frame"]["combo"]["border"]["size"]})
		vexpower_setCpsBarsBGColor(i, true)
		vexpower.cpsbars[i]:SetBackdropBorderColor(vexpower_parameters["frame"]["combo"]["border"]["color"]["r"],
														vexpower_parameters["frame"]["combo"]["border"]["color"]["g"],
														vexpower_parameters["frame"]["combo"]["border"]["color"]["b"],
														vexpower_parameters["frame"]["combo"]["border"]["color"]["a"])
		vexpower.cpsbars[i]:SetHeight(vexpower_parameters["frame"]["combo"]["measure"]["height"])
		
		if not(vexpower.testmode) then
			if vexpower.currentcps > 0 then vexpower.cpsbars[i]:Show()
			else vexpower.cpsbars[i]:Hide() end
		end
		vexpower.cpsbars[i]:SetWidth(width)
		vexpower.cpsbars[i]:ClearAllPoints()
		vexpower.cpsbars[i]:SetPoint("TOPLEFT", vexpower_energybarbg, "TOPLEFT", start[i], vexpower_parameters["frame"]["combo"]["measure"]["y"])
		
		vexpower.cpsbars_anigrps[i] = vexpower.cpsbars[i]:CreateAnimationGroup("vexpower.cpsbars_anigrps["..i.."]")
		vexpower.cpsbars_anigrps[i]:SetLooping("NONE")
		vexpower.cpsbars_anigrps[i]:SetScript("OnPlay", function () vexpower.cpsbars[i]:Show() end)
		vexpower.cpsbars_anigrps[i]:SetScript("OnFinished", function () vexpower.cpsbars[i]:Hide() end)
		vexpower.cpsbars_anis[i] = vexpower.cpsbars_anigrps[i]:CreateAnimation("Alpha")
		vexpower.cpsbars_anis[i]:SetDuration(animationduration)
		vexpower.cpsbars_anis[i]:SetOrder(1)
		vexpower.cpsbars_anis[i]:SetChange(-1)
		
	end
end

function vexpower_setcpsbar()
	vexpower_cpsbar:SetWidth(1)
	vexpower_cpsbar:SetHeight(1)
	vexpower_cpsbar:ClearAllPoints()
	vexpower_cpsbar:SetPoint("TOPLEFT", vexpower_MainFrame, "TOPLEFT", 0, 0)
end

function vexpower_ShowCPs()
	for i=1, #vexpower.cpsbars do
		if vexpower.cpsbars[i] ~=nil then
			if i <= vexpower.currentcps then
				vexpower.cpsbars[i]:Show()
			else
				vexpower.cpsbars[i]:Hide()
			end
		end
	end
end