function VendorBuy_OnLoad()
	level=UnitLevel("player");
	playerClass,clasa=UnitClass("player");
	desired=nil;
	merchantopen=false;
	vbenabled=true;
	skills={};

	this:RegisterEvent("MERCHANT_SHOW");
	this:RegisterEvent("MERCHANT_UPDATE");
	hooksecurefunc("MerchantFrame_Update", update);
	this:RegisterEvent("MERCHANT_CLOSED");
	
	this:RegisterEvent("PLAYER_LEVEL_UP");
	
	DEFAULT_CHAT_FRAME:AddMessage("VendorBuy Loaded");
	CreateFrame( "GameTooltip", "VendorBuyTooltip" );
	VendorBuyTooltip:SetOwner( WorldFrame, "ANCHOR_NONE" );
	VendorBuyTooltip:AddFontStrings(
	VendorBuyTooltip:CreateFontString( "$parentTextLeft1", nil, "GameTooltipText" ),
	VendorBuyTooltip:CreateFontString( "$parentTextRight1", nil, "GameTooltipText" ) );
	
	updatedesired();
	
	SlashCmdList["VENBUY"] = VendorParseCommand;
	SLASH_VENBUY1 = "/venbuy";
end

function updateskills()
	skills={};
	local numSkills = GetNumSkillLines();
	for si=1, numSkills do
  		local skillName = GetSkillLineInfo(si);
  		if((skillName=='Alchemy')or(skillName=='Herbalism')or(skillName=='Engineering')or(skillName=='Mining')or(skillName=='Enchanting')or(skillName=='Skining')or(skillName=='Blacksmithing')or(skillName=='Jewelcrafting')or(skillName=='Tailoring')or(skillName=='Leatherworking')or(skillName=='First Aid')or(skillName=='Cooking')or(skillName=='Fishing'))then 
  			skills[skillName]=skillName; 
  		end
	end
end

function VendorParseCommand(cmd)
	local goodcmd=false;
	if(cmd:upper()=="OFF")then
		goodcmd=true;
		vbenabled=false;
		print("VendorBuy Disabled");
		if(merchantopen) then
			for i=1, MERCHANT_ITEMS_PER_PAGE, 1 do
				local item = getglobal("MerchantItem"..i);
				item:SetAlpha(1);
			end		
			update();
		end
	end
	if(cmd:upper()=="ON")then
		goodcmd=true;
		vbenabled=true;
		print("VendorBuy Enabled");
		if(merchantopen) then
			for i=1, MERCHANT_ITEMS_PER_PAGE, 1 do
				local item = getglobal("MerchantItem"..i);
				item:SetAlpha(1);
			end				
			update();
		end
	end
	if(goodcmd==false)then
		print("VendorBuy CLI commands:");
		print("/venbuy off => disable VendorBuy");
		print("/venbuy on => enable VendorBuy");
		if(vbenabled==false)then
			print("VendorBuy is now Disabled");
		else
			print("VendorBuy is now Enabled");
		end
	end
end

function updatedesired()
	desired=nil;
	if((clasa=="WARRIOR")and(level<40))then desired="Mail"; end
	if((clasa=="WARRIOR")and(level>=40))then desired="Plate"; end
	
	if((clasa=="PALADIN")and(level<40))then desired="Mail"; end
	if((clasa=="PALADIN")and(level>=40))then desired="Plate"; end

	if((clasa=="HUNTER")and(level<40))then desired="Leater"; end
	if((clasa=="HUNTER")and(level>=40))then desired="Mail"; end
	
	if((clasa=="SHAMAN")and(level<40))then desired="Leather"; end
	if((clasa=="SHAMAN")and(level>=40))then desired="Mail"; end

	if(clasa=="DEATHKNIGHT")then desired="Plate"; end

	if((clasa=="PRIEST")or(clasa=="MAGE")or(clasa=="WARLOCK"))then desired="Cloth"; end
	if((clasa=="ROGUE")or(clasa=="DRUID"))then desired="Leather"; end
	
end

function VendorBuy_OnEvent(self, event, ...)
	if (event == "MERCHANT_SHOW") then
		merchantopen=true;
		updateskills();
		update();
	end

	if ((event == "MERCHANT_CLOSED") and (merchantopen)) then
		merchantopen=false;
		for i=1, MERCHANT_ITEMS_PER_PAGE, 1 do
			local item = getglobal("MerchantItem"..i);
			item:SetAlpha(1);
		end		
	end
	
	if (event=="PLAYER_LEVEL_UP") then
		level=arg1;
		updatedesired();
	end
		
end

function update()
	if ((merchantopen==false)or(vbenabled==false))then
		return;
	end
	if(MerchantFrame.selectedTab==2)then
		for i=1, BUYBACK_ITEMS_PER_PAGE, 1 do
			local item = getglobal("MerchantItem"..i);
			item:SetAlpha(1);
		end	
		return;
	end

	for i=1, MERCHANT_ITEMS_PER_PAGE, 1 do
		local index = (((MerchantFrame.page - 1) * MERCHANT_ITEMS_PER_PAGE) + i);
		local item = _G["MerchantItem"..i];
		item:SetAlpha(1);
		name, texture, price, quantity, numAvailable, isUsable, extendedCost = GetMerchantItemInfo(index);
		link = GetMerchantItemLink(index);
		if ((not isUsable) and (link)) then
			VendorBuyTooltip:ClearLines();
			VendorBuyTooltip:SetHyperlink(GetMerchantItemLink(index));
			local gasit=false;
			itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,itemTexture=GetItemInfo(link);
			for i = 1, VendorBuyTooltip:NumLines() do
				local text = _G["VendorBuyTooltipTextLeft"..i]:GetText();
				if(text)then
					local a,b,c = _G["VendorBuyTooltipTextLeft"..i]:GetTextColor();
					a=round(a);
					b=round(b);
					c=round(c);
					if ((a>b)and(b==c))then
						if((string.find(text,"Requires Level")==nil)and(string.find(text,"Friendly")==nil)and(string.find(text,"Honored")==nil)and(string.find(text,"Revered")==nil)and(string.find(text,"Exalted")==nil))then 
							isskill=false;
							for si,sv in pairs(skills) do
						 		if(string.find(text,"Requires "..si)~=nil)then isskill=true; break; end
							end
							if(isskill==false)then gasit=true; break; end
						end
					end
				end
				
				local text = _G["VendorBuyTooltipTextRight"..i]:GetText();
				if(text)then
					local a,b,c = _G["VendorBuyTooltipTextRight"..i]:GetTextColor();
					a=round(a);
					b=round(b);
					c=round(c);
					if ((a>b)and(b==c))then
						gasit = true; 
						break;
					end
				end
			end
			if(gasit==true)then item:SetAlpha(0.1); end

			if((link)and(gasit==false))then
				itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,itemTexture=GetItemInfo(link);
				if((itemType=="Armor") and (itemSubType~="Miscellaneous") and (itemEquipLoc~="INVTYPE_CLOAK") and (itemEquipLoc~="INVTYPE_SHIELD") and (itemEquipLoc~="INVTYPE_RELIC"))then 
					if(itemSubType~=desired)then
						item:SetAlpha(0.5);
					end
				end
			end
			
		else
			if(link)then
				itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,itemTexture=GetItemInfo(link);
				if((itemType=="Armor") and (itemSubType~="Miscellaneous") and (itemEquipLoc~="INVTYPE_CLOAK") and (itemEquipLoc~="INVTYPE_SHIELD") and (itemEquipLoc~="INVTYPE_RELIC"))then 
					if(itemSubType~=desired)then
						item:SetAlpha(0.5);
					end
				end
				
				VendorBuyTooltip:ClearLines();
				VendorBuyTooltip:SetHyperlink(GetMerchantItemLink(index));
				gasit=false;
				for i = 1, VendorBuyTooltip:NumLines() do
					local text = _G["VendorBuyTooltipTextLeft"..i]:GetText();
					if((text)and(text=="Already known"))then gasit=true; break; end					
				end
				if(gasit==true)then 
					local itemButton=_G["MerchantItem"..i.."ItemButton"];
					SetItemButtonNameFrameVertexColor(item, 1.0, 0.0, 1.0);
					SetItemButtonSlotVertexColor(item, 1.0, 0.0, 1.0);
					SetItemButtonTextureVertexColor(itemButton, 1.0, 0, 1.0);
					SetItemButtonNormalTextureVertexColor(itemButton, 1.0, 0, 1.0);
					item:SetAlpha(0.5); 
				end
			end
		end
	end
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end
