CreateFrame("Frame", "UrzEventWatcher");
CreateFrame("Frame", "UrzOptionsInterface");
CreateFrame("Frame", "UrzNameplates"):Hide();
CreateFrame("Frame", "UrzBin"):Hide();

local function Remove(name)
	if ( name ) then
		name:SetParent(UrzBin);
	end
end

local function Move(name, pos1, parent, pos2, x, y)
	name:ClearAllPoints();
	name:SetPoint(pos1, parent, pos2, x, y);
end

function UrzEventHandler(self, event, ...)
	if ( event == "MERCHANT_SHOW" ) then
		if ( UrzVariable[4] ) then
			RepairAllItems(1);
		end
		if ( UrzVariable[3] ) then
			RepairAllItems(0);
		end
		if ( UrzVariable[5] ) then
			for bag = 0, 4 do
				for slot = 0, GetContainerNumSlots(bag) do
					local link = GetContainerItemLink(bag, slot);
					if ( link and (select(3, GetItemInfo(link)) == 0) ) then
						UseContainerItem(bag, slot);
					end
				end
			end
		end
	else
		if ( UrzVariable[1] ) then
			UrzNameplates:Show();
		else
			UrzNameplates:Hide();
		end
		if ( UrzVariable[2] ) then
			UIErrorsFrame:Hide();
		else
			UIErrorsFrame:Show();
		end
		TextStatusBar_UpdateTextString(PlayerFrameHealthBar);
		TextStatusBar_UpdateTextString(TargetFrameHealthBar);
	end
end

local function Initialize()
	--Nameplates
	do
		local knownkids = 0;
		UrzNameplates:SetScript("OnUpdate", function(self, elapsed)
				if ( knownkids < WorldFrame:GetNumChildren() ) then
					for i = 1, WorldFrame:GetNumChildren() do
						local frame = select(i, WorldFrame:GetChildren());
						if (( not frame.Urzified ) and ( frame:GetName() ) and ( frame:GetName():find("NamePlate%d") )) then
							frame.Urzified = true;
							local plate, name = frame:GetChildren();
							local bar = plate:GetChildren();
							local threat, bg, hover, lvl = plate:GetRegions();
							local font = name:GetRegions();
							frame.target = frame:CreateTexture(nil, "BACKGROUND");
							frame.target:SetTexture(threat:GetTexture());
							frame.target:SetSize(threat:GetSize());
							frame.target:SetTexCoord(threat:GetTexCoord());
							frame.target:SetAllPoints(threat);
							threat:SetTexture(nil);
							bg:SetTexture(nil);
							bg:Hide();
							bar.health = frame:CreateFontString();
							bar.health:SetPoint("CENTER", bar);
							bar.health:SetFont("Fonts\\ARIALN.TTF", 12, "OUTLINE");
							font:SetFont("Fonts\\ARIALN.TTF", 12);
							font:SetShadowOffset(1, -1);
							lvl:SetFont("Fonts\\ARIALN.TTF", 12);
							lvl:SetShadowOffset(1, -1);
							local function setup(self, value)
								local hp = ceil(bar:GetValue()/select(2, bar:GetMinMaxValues())*100);
								if ( hp <= 20 ) then
									bar.health:SetText(GREEN_FONT_COLOR_CODE..hp.."%"..FONT_COLOR_CODE_CLOSE);
								else
									bar.health:SetText(hp.."%");
								end
							end
							setup();
							bar:HookScript("OnValueChanged", setup);
							frame:HookScript("OnUpdate", function(self, elapsed)
									if ( UnitExists("target") and ( frame:GetAlpha() == 1 )) then
										frame.target:Show();
									else
										frame.target:Hide();
									end
									frame:SetAlpha(1);
							end);
							name:HookScript("OnUpdate", function(self, elapsed)
									if ( threat:IsShown() ) then
										font:SetTextColor(1, 0.1, 0.1, 1);
									else
										font:SetTextColor(1, 1, 1, 1);
									end
							end);
						end
					end
				end
				knownkids = WorldFrame:GetNumChildren();
		end);
	end

	--MainMenu & ActionBars
	do
		for _, name in pairs({MainMenuBarPageNumber, ActionBarUpButton, ActionBarDownButton, MainMenuBarLeftEndCap, MainMenuBarRightEndCap, MainMenuXPBarTextureLeftCap, MainMenuXPBarTextureMid, MainMenuXPBarTextureRightCap, StanceBarLeft, StanceBarMiddle, StanceBarRight, SlidingActionBarTexture0, SlidingActionBarTexture1, PossessBackground1, PossessBackground2, MainMenuXPBarDiv1, MainMenuXPBarDiv2, MainMenuXPBarDiv3, MainMenuXPBarDiv4, MainMenuXPBarDiv5, MainMenuXPBarDiv6, MainMenuXPBarDiv7, MainMenuXPBarDiv8, MainMenuXPBarDiv9, MainMenuXPBarDiv10, MainMenuXPBarDiv11, MainMenuXPBarDiv12, MainMenuXPBarDiv13, MainMenuXPBarDiv14, MainMenuXPBarDiv15, MainMenuXPBarDiv16, MainMenuXPBarDiv17, MainMenuXPBarDiv18, MainMenuXPBarDiv19, MainMenuBarTexture0, MainMenuBarTexture1, MainMenuBarTexture2, MainMenuBarTexture3, ReputationXPBarTexture0, ReputationXPBarTexture1, ReputationXPBarTexture2, ReputationXPBarTexture3, ReputationWatchBarTexture0, ReputationWatchBarTexture1, ReputationWatchBarTexture2, ReputationWatchBarTexture3, MainMenuMaxLevelBar0, MainMenuMaxLevelBar1, MainMenuMaxLevelBar2, MainMenuMaxLevelBar3}) do
			Remove(name);
		end
		for _, name in pairs({StanceBarFrame, PossessBarFrame, PetActionBarFrame, MultiBarLeft, MultiBarRight, MultiBarBottomLeft, MultiBarBottomRight, MainMenuBar, MainMenuBarMaxLevelBar}) do
			name:SetFrameStrata("MEDIUM");
			name:EnableMouse(false);
		end
		for _, text in pairs({"ActionButton", "MultiBarBottomLeftButton", "MultiBarBottomRightButton", "MultiBarLeftButton", "MultiBarRightButton", "StanceButton", "PossessButton", "PetActionButton"}) do
			for i = 1, 12 do
				local name = _G[text..i];
				if ( name ) then
					name:GetNormalTexture():SetPoint("TOPLEFT", name, "TOPLEFT", -12, 12);
					name:GetNormalTexture():SetPoint("BOTTOMRIGHT", name, "BOTTOMRIGHT", 13, -13);
					name:SetSize(36, 36);
					name:SetScale(1);
					Remove(_G[text..i.."FloatingBG"]);
					Remove(_G[text..i.."Name"]);
				end
			end
		end
		MainMenuBarVehicleLeaveButton:SetSize(36, 36);
		for _, name in pairs({MainMenuBarVehicleLeaveButton, StanceBarFrame, PossessBarFrame, PetActionBarFrame}) do
			name:SetScale(0.7);
		end
		MainMenuBar:SetWidth(512);
		Move(MultiBarBottomLeftButton1, "BOTTOMLEFT", ActionButton1, "TOPLEFT", 0, 6);
		Move(MultiBarBottomRightButton1, "BOTTOMLEFT", MultiBarBottomLeftButton1, "TOPLEFT", 0, 6);
		Move(StanceButton1, "BOTTOMLEFT", MultiBarBottomRightButton1, "TOPLEFT", 0, 6);
		Move(PossessButton1, "BOTTOMLEFT", MultiBarBottomRightButton1, "TOPLEFT", 0, 6);
		Move(PetActionButton10, "BOTTOMRIGHT", MultiBarBottomRightButton12, "TOPRIGHT", 0, 6);
		Move(PossessButton2, "LEFT", PossessButton1, "RIGHT", 6, 0);
		for i = 2, 10 do
			Move(_G["StanceButton"..i], "LEFT", _G["StanceButton"..i-1], "RIGHT", 6, 0);
			Move(_G["PetActionButton"..11-i], "RIGHT", _G["PetActionButton"..12-i], "LEFT", -6, 0);
		end
		local function setup()
			if (( GetNumShapeshiftForms() < 1 ) and not IsPossessBarVisible() ) then
				Move(MainMenuBarVehicleLeaveButton, "BOTTOMLEFT", MultiBarBottomRightButton1, "TOPLEFT", 0, 6);
			end
		end
		setup();
		hooksecurefunc("MainMenuBarVehicleLeaveButton_Update", setup);
		local function setup()
			if ( MainMenuBar:IsShown() ) then
				Move(CharacterMicroButton, "BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", -275, 1);
				Move(PVPMicroButton, "BOTTOMLEFT", GuildMicroButton, "BOTTOMRIGHT", -3, 0);
			end
		end
		setup();
		hooksecurefunc("MoveMicroButtons", setup);
		local function setup()
			MainMenuExpBar:SetSize(300, 13);
			ReputationWatchStatusBar:SetSize(300, 13);
			ReputationWatchBar:SetSize(300, 13);
			Move(ReputationWatchStatusBarText, "CENTER", ReputationWatchBarOverlayFrame, "CENTER", 0, 1);
			ReputationWatchBarOverlayFrame:SetFrameStrata("MEDIUM");
			local y = 40;
			Move(MainMenuExpBar, "BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", -1, y);
			if ( MainMenuExpBar:IsShown() ) then
				y = y+16;
			end
			Move(ReputationWatchBar, "BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", -1, y);
			if ( ReputationWatchBar:IsShown() ) then
				y = y+16;
			end
			Move(MainMenuBarBackpackButton, "BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", -1, y);
		end
		setup();
		hooksecurefunc("ReputationWatchBar_Update", setup);
	end

	--ChatFrames
	do
		for i = 1, NUM_CHAT_WINDOWS do
			for _, text in pairs({"ButtonFrameMinimizeButton", "ButtonFrameBackground", "ButtonFrameTopLeftTexture", "ButtonFrameBottomLeftTexture", "ButtonFrameTopRightTexture", "ButtonFrameBottomRightTexture", "ButtonFrameLeftTexture", "ButtonFrameRightTexture", "ButtonFrameBottomTexture", "ButtonFrameTopTexture"}) do
				Remove(_G["ChatFrame"..i..text]);
			end
			_G["ChatFrame"..i.."Tab"]:SetScript("OnDoubleClick", nil);
			if ( i ~= 1 ) then
				_G["ChatFrame"..i.."EditBox"]:SetAllPoints(ChatFrame1EditBox);
			end
		end
		FCFManager_RegisterDedicatedFrame(ChatFrame2, "PET_BATTLE_COMBAT_LOG");
		for name in pairs(ChatTypeGroup) do
			SetChatColorNameByClass(name, true);
		end
		for i = 1, MAX_WOW_CHAT_CHANNELS do
			local name = "CHANNEL"..i;
			if ( name ) then
				SetChatColorNameByClass(name, true);
			end
		end
		Move(FriendsMicroButton, "BOTTOM", ChatFrameMenuButton, "TOP", 0, 3);
		ChatFrameMenuButton:SetScript("OnClick", function(self, button, down)
			PlaySound("igChatEmoteButton");
			if ( not ChatMenu:IsShown() ) then
				ChatMenu:Show();
			else
				ChatMenu:Hide();
			end
		end);
		local function setup(editBox)
			editBox:SetFrameStrata("BACKGROUND");
		end
		setup(ChatFrame1EditBox);
		hooksecurefunc("ChatEdit_DeactivateChat", setup);
		hooksecurefunc("ChatEdit_SetLastActiveWindow", setup);
		hooksecurefunc("FCFDock_RemoveChatFrame", setup);
	end

	--URL copy
	do
		for _, name in pairs({"CHAT_MSG_SAY", "CHAT_MSG_WHISPER", "CHAT_MSG_YELL", "CHAT_MSG_GUILD", "CHAT_MSG_OFFICER", "GUILD_MOTD", "CHAT_MSG_BN_WHISPER", "CHAT_MSG_BN_CONVERSATION", "CHAT_MSG_BN_INLINE_TOAST_BROADCAST", "CHAT_MSG_PARTY", "CHAT_MSG_PARTY_LEADER", "CHAT_MSG_RAID", "CHAT_MSG_RAID_LEADER", "CHAT_MSG_INSTANCE_CHAT", "CHAT_MSG_INSTANCE_CHAT_LEADER", "CHAT_MSG_CHANNEL"}) do
			ChatFrame_AddMessageEventFilter(name, function(_, _, msg, ...)
				local newMsg, found = gsub(msg, "[^ \"£%^`¨{}%[%]\\|<>]+[^ '%-=%./,\"£%^`¨{}%[%]\\|<>%d]%.[^ '%-=%./,\"£%^`¨{}%[%]\\|<>%d][^ \"£%^`¨{}%[%]\\|<>]+", "|cff9999ff|Hurzurl~%1|h[%1]|h|r");
				if ( found > 0 ) then
					return false, newMsg, ...;
				end
				newMsg, found = gsub(msg, "^%x+[%.:]%x+[%.:]%x+[%.:]%x+[^ \"£%^`¨{}%[%]\\|<>]*", "|cff9999ff|Hurzurl~%1|h[%1]|h|r");
				if ( found > 0 ) then
					return false, newMsg, ...;
				end
				newMsg, found = gsub(msg, " %x+[%.:]%x+[%.:]%x+[%.:]%x+[^ \"£%^`¨{}%[%]\\|<>]*", "|cff9999ff|Hurzurl~%1|h[%1]|h|r");
				if ( found > 0 ) then
					return false, newMsg, ...;
					end
			end);
		end
		local old = ItemRefTooltip.SetHyperlink;
		function ItemRefTooltip:SetHyperlink(data, ...)
			local isURL, link = strsplit("~", data);
			if (( isURL ) and ( isURL == "urzurl" )) then
				local activeWindow = ChatEdit_GetActiveWindow();
				if ( activeWindow ) then
					activeWindow:SetText(link);
					ChatEdit_FocusActiveWindow();
					activeWindow:HighlightText();
				else
					activeWindow = ChatEdit_GetLastActiveWindow();
					activeWindow:Show();
					activeWindow:SetText(link);
					activeWindow:SetFocus();
					activeWindow:HighlightText();
				end
			else
				old(self, data, ...);
			end
		end
	end

	--UnitFrames
	do
		PlayerFrame:UnregisterEvent("UNIT_COMBAT");
		PetFrame:UnregisterEvent("UNIT_COMBAT");
		for _, name in pairs({PlayerStatusTexture, PlayerAttackBackground, PlayerFrameFlash, PlayerStatusGlow, PlayerAttackGlow, PlayerRestGlow, PlayerHitIndicator, PetFrameFlash, PetAttackModeTexture, PetHitIndicator, TargetFrameFlash, FocusFrameFlash}) do
			Remove(name);
		end
		hooksecurefunc("PlayerFrame_UpdateStatus", function()
			if (( not UnitHasVehiclePlayerFrameUI("player") ) and ( UnitAffectingCombat("player") )) then
				PlayerAttackIcon:Show();
				PlayerRestIcon:Hide();
			end
			if (( PlayerAttackIcon:IsShown() ) or ( PlayerRestIcon:IsShown() )) then
				PlayerLevelText:Hide();
			else
				PlayerLevelText:Show();
			end
		end);
		hooksecurefunc("TextStatusBar_UpdateTextString", function(textStatusBar)
			if ( UrzVariable[6] ) then
				if (( textStatusBar == TargetFrameHealthBar ) or ( textStatusBar == PlayerFrameHealthBar )) then
					local current = textStatusBar:GetValue();
					local _, max = textStatusBar:GetMinMaxValues();
					if (( current > 0) and ( max > 0 )) then
						textStatusBar.TextString:SetFormattedText("%i%%   %s", ceil(current/max*100), AbbreviateLargeNumbers(current));
					end
				end
			end
		end);
	end

	--Minimap
	do
		for _, name in pairs({MinimapZoomIn, MinimapZoomOut, MiniMapTracking}) do
			Remove(name);
		end
		Minimap:EnableMouseWheel(true);
		Minimap:SetScript("OnMouseWheel", function(self, delta)
			local zoom = Minimap:GetZoom();
			if ( delta > 0 and zoom < 5 ) then
				Minimap:SetZoom(zoom+1);
			elseif ( delta < 0 and zoom > 0 ) then
				Minimap:SetZoom(zoom-1);
			end
		end);
		Minimap:SetScript("OnMouseUp", function(self, button)
			if ( button == "LeftButton" ) then
				Minimap_OnClick(self);
			elseif ( button == "RightButton" ) then
				PlaySound("igMainMenuOptionCheckBoxOn");
				ToggleDropDownMenu(1, nil, MiniMapTrackingDropDown, "Minimap", -150, 130);
			end
		end);
	end

	--CastBar
	CastingBarFrame:SetFrameStrata("FULLSCREEN_DIALOG");

	--Disable right-click interaction in combat
	do
		UrzRightClickUpdateDelay = 0;
		WorldFrame:HookScript("OnMouseUp", function(self, button)
			if ( UrzVariable[7] ) then
				if ( UnitAffectingCombat("player") and ( button == "RightButton" ) and ( UrzRightClickUpdateDelay < GetTime() )) then
					UrzRightClickUpdateDelay = GetTime()+0.3;
					MouselookStop();
				end
			end
		end);
	end

	--OptionsInterface
	do
		UrzOptionsInterface.name = "UrzUI";
		InterfaceOptions_AddCategory(UrzOptionsInterface);
		SlashCmdList["UrzSlash"] = function(UrzVariable)
			InterfaceOptionsFrame:Show();
			InterfaceOptionsFrame_OpenToCategory("UrzUI");
		end;
		SLASH_UrzSlash1 = "/urz";
		local text1 = UrzOptionsInterface:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge");
		local text2 = UrzOptionsInterface:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall");
		text1:SetPoint("TOPLEFT", 16, -16);
		text1:SetText("UrzUI");
		text2:SetPoint("TOPLEFT", text1, "BOTTOMLEFT", 0, -8);
		text2:SetText("Dedicated to Madsam.");
		UrzSettings = {
			[1] = {p = 1, Text = "Enable UrzNameplates. (When unchecked, a reload is required to be fully disabled.)"},
			[2] = {p = 2, Text = "Hide error messages."},
			[3] = {p = 3, Text = "Auto-repair."},
			[4] = {p = 4, Text = "Auto-guild-repair. (If both auto-repairs are enabled, then guild-repair is used first.)"},
			[5] = {p = 5, Text = "Auto-sell poor quality items."},
			[6] = {p = 6, Text = "Show player and target health text in both percentage and numbers."},
			[7] = {p = 7, Text = "Disable right-click interaction in combat. (Use right-double-click to interact.)"},
		};
		if (( not UrzVariable ) or (( UrzVariable ) and ( type(UrzVariable) ~= "table" ))) then
			UrzVariable = {[1] = 1, [2] = 1, [3] = 1, [5] = 1, [6] = 1};
		end
		local box = {};
		for i = 1, #UrzSettings do
			box[i] = CreateFrame("CheckButton", "box"..i, UrzOptionsInterface, "InterfaceOptionsCheckButtonTemplate");
			Move(box[i], "TOPLEFT", UrzOptionsInterface, "TOPLEFT", 16, -UrzSettings[i]["p"]*35-35);
			box[i].Nr = i;
			box[i]:SetChecked(UrzVariable[i]);
			_G[box[i]:GetName().."Text"]:SetText(UrzSettings[i]["Text"]);
			box[i]:SetScript("OnClick", function(self, button,down)
				UrzVariable[self.Nr] = self:GetChecked();
				UrzEventHandler();
			end);
			UrzOptionsInterface:SetScript("OnShow", function(self)
				for i = 1, #UrzSettings do
					box[i]:SetChecked(UrzVariable[i]);
				end
			end);
			UrzOptionsInterface:SetScript("OnHide", function(self)
				collectgarbage();
			end);
		end
	end
end

UrzEventWatcher:SetScript("OnEvent", function(self, event, ...)
	if ( not UnitAffectingCombat("player") ) then
		UrzEventWatcher:UnregisterAllEvents();
		Initialize();
		UrzEventHandler();
		UrzEventWatcher:SetScript("OnEvent", UrzEventHandler);
		UrzEventWatcher:RegisterEvent("MERCHANT_SHOW");
		collectgarbage();
	end
end);
UrzEventWatcher:RegisterEvent("PLAYER_ENTERING_WORLD");
UrzEventWatcher:RegisterEvent("PLAYER_REGEN_ENABLED");

for i = 1, NUM_CHAT_WINDOWS do
	_G["ChatFrame"..i]:SetClampRectInsets(-35, 35, 35, -35);
end
