local L = LibStub("AceLocale-3.0"):GetLocale("UnderHood_HideBlizzard")
local _G = _G
local ipairs = ipairs

local playerFrameState = true
local partyFrameState = true
local targetFrameState = true
local focusFrameState = true
local castingBarState = true
local auraFrameState = true
local runeFrameState = true
local holyPowerFrameState = true
local soulShardsFrameState = true

local function HideBlizzardPlayerFrame()
	if not playerFrameState then return end

	playerFrameState = false
	PlayerFrame:UnregisterAllEvents()
	PlayerFrameHealthBar:UnregisterAllEvents()
	PlayerFrameManaBar:UnregisterAllEvents()
	PlayerFrame:Hide()
end

local function ShowBlizzardPlayerFrame()
	if playerFrameState then return end

	playerFrameState = true
	PlayerFrame:RegisterEvent("UNIT_LEVEL")
	PlayerFrame:RegisterEvent("UNIT_COMBAT")
	PlayerFrame:RegisterEvent("UNIT_SPELLMISS")
	PlayerFrame:RegisterEvent("UNIT_PVP_UPDATE")
	PlayerFrame:RegisterEvent("UNIT_MAXMANA")
	PlayerFrame:RegisterEvent("PLAYER_ENTER_COMBAT")
	PlayerFrame:RegisterEvent("PLAYER_LEAVE_COMBAT")
	PlayerFrame:RegisterEvent("PLAYER_UPDATE_RESTING")
	PlayerFrame:RegisterEvent("GROUP_ROSTER_UPDATE")
	PlayerFrame:RegisterEvent("PARTY_LEADER_CHANGED")
	PlayerFrame:RegisterEvent("PARTY_LOOT_METHOD_CHANGED")
	PlayerFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	PlayerFrame:RegisterEvent("PLAYER_REGEN_DISABLED")
	PlayerFrame:RegisterEvent("PLAYER_REGEN_ENABLED")
	PlayerFrameHealthBar:RegisterEvent("UNIT_HEALTH")
	PlayerFrameHealthBar:RegisterEvent("UNIT_MAXHEALTH")
	PlayerFrameManaBar:RegisterEvent("UNIT_MANA")
	PlayerFrameManaBar:RegisterEvent("UNIT_RAGE")
	PlayerFrameManaBar:RegisterEvent("UNIT_FOCUS")
	PlayerFrameManaBar:RegisterEvent("UNIT_ENERGY")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXMANA")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXRAGE")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXFOCUS")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXENERGY")
	PlayerFrameManaBar:RegisterEvent("UNIT_DISPLAYPOWER")
	PlayerFrame:RegisterEvent("UNIT_NAME_UPDATE")
	PlayerFrame:RegisterEvent("UNIT_PORTRAIT_UPDATE")
	PlayerFrame:RegisterEvent("UNIT_DISPLAYPOWER")
	PlayerFrame:Show()
end

local function HideBlizzardPartyFrames()
	if not partyFrameState then return end

	partyFrameState = false
	for i = 1, 4 do
		local frame = _G["PartyMemberFrame"..i]
		frame:UnregisterAllEvents()
		frame:Hide()
		frame.Show = function() end
	end

	UIParent:UnregisterEvent("GROUP_ROSTER_UPDATE")
end

local function ShowBlizzardPartyFrames()
	if partyFrameState then return end

	partyFrameState = true
	for i = 1, 4 do
		local frame = _G["PartyMemberFrame"..i]
		frame.Show = nil
		frame:RegisterEvent("GROUP_ROSTER_UPDATE")
		frame:RegisterEvent("PARTY_LEADER_CHANGED")
		frame:RegisterEvent("PARTY_MEMBER_ENABLE")
		frame:RegisterEvent("PARTY_MEMBER_DISABLE")
		frame:RegisterEvent("PARTY_LOOT_METHOD_CHANGED")
		frame:RegisterEvent("UNIT_PVP_UPDATE")
		frame:RegisterEvent("UNIT_AURA")
		frame:RegisterEvent("UNIT_PET")
		frame:RegisterEvent("VARIABLES_LOADED")
		frame:RegisterEvent("UNIT_NAME_UPDATE")
		frame:RegisterEvent("UNIT_PORTRAIT_UPDATE")
		frame:RegisterEvent("UNIT_DISPLAYPOWER")

		UnitFrame_OnEvent("GROUP_ROSTER_UPDATE")

		local oldThis = _G.this
		_G.this = frame
		PartyMemberFrame_UpdateMember()
		_G.this = oldThis
	end

	UIParent:RegisterEvent("GROUP_ROSTER_UPDATE")
end

local function HideBlizzardTargetFrame()
	if not targetFrameState then return end

	targetFrameState = false
	TargetFrame:UnregisterAllEvents()
	TargetFrame:Hide()

	ComboFrame:UnregisterAllEvents()
end

local function ShowBlizzardTargetFrame()
	if targetFrameState then return end

	targetFrameState = true
	TargetFrame:RegisterEvent("PLAYER_TARGET_CHANGED")
	TargetFrame:RegisterEvent("PLAYER_FOCUS_CHANGED")
	TargetFrame:RegisterEvent("UNIT_HEALTH")
	TargetFrame:RegisterEvent("UNIT_LEVEL")
	TargetFrame:RegisterEvent("UNIT_FACTION")
	TargetFrame:RegisterEvent("UNIT_CLASSIFICATION_CHANGED")
	TargetFrame:RegisterEvent("UNIT_AURA")
	TargetFrame:RegisterEvent("PLAYER_FLAGS_CHANGED")
	TargetFrame:RegisterEvent("GROUP_ROSTER_UPDATE")

	TargetFrame_Update(TargetFrame)

	ComboFrame:RegisterEvent("PLAYER_FOCUS_CHANGED")
	ComboFrame:RegisterEvent("PLAYER_TARGET_CHANGED")
	ComboFrame:RegisterEvent("PLAYER_COMBO_POINTS")
end

local function HideBlizzardFocusFrame()
	if not focusFrameState then return end

	focusFrameState = false
	FocusFrame:UnregisterAllEvents()
	FocusFrame:Hide()
end

function ShowBlizzardFocusFrame()
	if focusFrameState then return end

	focusFrameState = true
	FocusFrame:RegisterEvent("PLAYER_TARGET_CHANGED")
	FocusFrame:RegisterEvent("PLAYER_FOCUS_CHANGED")
	FocusFrame:RegisterEvent("UNIT_HEALTH")
	FocusFrame:RegisterEvent("UNIT_LEVEL")
	FocusFrame:RegisterEvent("UNIT_FACTION")
	FocusFrame:RegisterEvent("UNIT_CLASSIFICATION_CHANGED")
	FocusFrame:RegisterEvent("UNIT_AURA")
	FocusFrame:RegisterEvent("PLAYER_FLAGS_CHANGED")
	FocusFrame:RegisterEvent("GROUP_ROSTER_UPDATE")

	if UnitExists("focus") then
		FocusFrame:Show()

		FocusFrame_Update(FocusFrame)
	end
end

local function HideBlizzardCastingBar()
	if not castingBarState then return end

	castingBarState = false
	CastingBarFrame:UnregisterAllEvents()
	PetCastingBarFrame:UnregisterAllEvents()
end

local function ShowBlizzardCastingBar()
	if castingBarState then return end

	castingBarState = true
	local t = { CastingBarFrame, PetCastingBarFrame }

	for _, v in ipairs(t) do
		v:RegisterEvent("UNIT_SPELLCAST_START")
		v:RegisterEvent("UNIT_SPELLCAST_STOP")
		v:RegisterEvent("UNIT_SPELLCAST_FAILED")
		v:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
		v:RegisterEvent("UNIT_SPELLCAST_DELAYED")
		v:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
		v:RegisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE")
		v:RegisterEvent("PLAYER_ENTERING_WORLD")
	end

	PetCastingBarFrame:RegisterEvent("UNIT_PET")
end

local function HideBlizzardAuraFrame()
	if not auraFrameState then return end

	auraFrameState = false
	BuffFrame:Hide()
	TemporaryEnchantFrame:Hide()
	BuffFrame:UnregisterAllEvents()
end

local function ShowBlizzardAuraFrame()
	if auraFrameState then return end

	auraFrameState = true
	BuffFrame:Show()
	TemporaryEnchantFrame:Show()
	BuffFrame:RegisterEvent("PLAYER_AURAS_CHANGED")

	BuffFrame_Update()
end

local function HideBlizzardRuneFrame()
	if not runeFrameState or not RuneFrame then return end

	runeFrameState = false
	RuneFrame:Hide()
end

local function ShowBlizzardRuneFrame()
	if runeFrameState or not RuneFrame then return end

	runeFrameState = true
	RuneFrame:Show()
end

local function HideHolyPowerFrame()
	if not holyPowerFrameState or not PaladinPowerBar then return end

	holyPowerFrameState = false
	PaladinPowerBar:Hide()
end

local function ShowHolyPowerFrame()
	if holyPowerFrameState or not PaladinPowerBar then return end

	holyPowerFrameState = true
	PaladinPowerBar:Show()
end

local function HideSoulShardsFrame()
	if not soulShardsFrameState or not ShardBarFrame then return end

	soulShardsFrameState = false
	ShardBarFrame:Hide()
end

local function ShowSoulShardsFrame()
	if soulShardsFrameState or not ShardBarFrame then return end

	soulShardsFrameState = true
	ShardBarFrame:Show()
end

local Module = UnderHood:NewModule("HideBlizzard")

local defaults = {
	profile = {
		player = true,
		party = true,
		target = true,
		focus = true,
		castbar = true,
		aura = false,
		rune = true,
		holypower = false,
		soulshards = false,
	},
}

local options = {
	name = L["Hide Blizzard Frames"],
	type = "group",
	hidden = function() return not Module:IsEnabled() end,
	get = function(info) return Module.db.profile[info[#info]] end,
	set = function(info, value)
		Module.db.profile[info[#info]] = value
		Module:UpdateBlizzardFrames()
	end,
	args = {
		player = {
			name = L["Player"],
			type = "toggle",
			order = 1,
		},
		target = {
			name = L["Target"],
			type = "toggle",
			order = 2,
		},
		focus = {
			name = L["Focus"],
			type = "toggle",
			order = 3,
		},
		party = {
			name = L["Party"],
			type = "toggle",
			order = 4,
		},
		castbar = {
			name = L["Cast bar"],
			type = "toggle",
			order = 5,
		},
		aura = {
			name = L["Auras"],
			type = "toggle",
			order = 6,
		},
		rune = {
			name = L["Runes"],
			type = "toggle",
			order = 7,
		},
		holypower = {
			name = L["Holy Power"],
			type = "toggle",
			order = 8,
		},
		soulshards = {
			name = L["Soul Shards"],
			type = "toggle",
			order = 8,
		},
	},
}

function Module:OnInitialize()
	self.db = UnderHood.db:RegisterNamespace("HideBlizzard", defaults)

	UnderHood:AddGeneralOptionsSection("hideBlizzard", options)
end

function Module:OnEnable()
end

function Module:OnDisable()
	self:UpdateBlizzardFrames(true)
end

function Module:HandleProfileChanges()
	self:UpdateBlizzardFrames()
end

function Module:UpdateBlizzardFrames(forceShow)
	local hb = self.db.profile

	if (hb.player and not forceShow) then HideBlizzardPlayerFrame() else ShowBlizzardPlayerFrame() end
	if (hb.party and not forceShow) then HideBlizzardPartyFrames() else ShowBlizzardPartyFrames() end
	if (hb.target and not forceShow) then HideBlizzardTargetFrame() else ShowBlizzardTargetFrame() end
	if (hb.focus and not forceShow) then HideBlizzardFocusFrame() else ShowBlizzardFocusFrame() end
	if (hb.castbar and not forceShow) then HideBlizzardCastingBar() else ShowBlizzardCastingBar() end
	if (hb.aura and not forceShow) then HideBlizzardAuraFrame() else ShowBlizzardAuraFrame() end
	if (hb.rune and not forceShow) then HideBlizzardRuneFrame() else ShowBlizzardRuneFrame() end
	if (hb.holypower and not forceShow) then HideHolyPowerFrame() else ShowHolyPowerFrame() end
	if (hb.soulshards and not forceShow) then HideSoulShardsFrame() else ShowSoulShardsFrame() end
end
