local Module = UnderHood:GetModule("Bars")

local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local unpack = unpack

local _, unitClass = UnitClass("player")

local Provider = UnderHood.OO:NewClass("SoulShardsBarProvider", "BarProvider")

function Provider:init(factory)
	super(self, factory, "AceTimer-3.0")
end

function Provider:OnAcquire(bar, zone, settings)
	super(self, bar, zone, settings)

	if unitClass == "WARLOCK" then
		self:ScheduleRepeatingTimer("UpdateValue", 0.2)
		self:UpdateColor()
	end
end

function Provider:UpdateColor()
	local r, g, b = unpack(Module.db.profile.colors.power.soulShards)

	self:SetColor(r, g, b, 1)
end

function Provider:UpdateValue()
	super(self)

	local current, max = UnitPower("player", SPELL_POWER_SOUL_SHARDS), UnitPowerMax("player", SPELL_POWER_SOUL_SHARDS)

	current = (max > 0) and (current / max) or 0

	self:SetValue(current)
end

local Factory = UnderHood.OO:NewClass("SoulShardsBarProviderFactory", "BarProviderFactory")

function Factory:init()
	local L = Module.L

	super(self, "SoulShards", L["Soul Shards"])
end

function Factory:CreateProvider()
	return Provider:new(self)
end

local factory = Factory:new()

Module:RegisterProviderFactory(factory:GetName(), factory)
