local UnderHood = UnderHood
local Module = UnderHood:GetModule("Bars")
local L = Module.L
local OO = UnderHood.OO

local UnitGUID = UnitGUID

local Provider = OO:NewClass("BarProviderWithUnit", "BarProvider")

function Provider:init(factory, ...)
	super(self, factory, "AceEvent-3.0", ...)
end

function Provider:OnAcquire(bar, zone, settings)
	super(self, bar, zone, settings)

	self.unit = self.settings.unit

	if self.unit == "default" then
		self.unit = bar:GetUnit()
	end

	self.unitGUID = UnitGUID(self.unit)

	self:UnitChanged()
	self:Update()
end

function Provider:OnRelease()
	UnderHood:UnregisterUpdateTarget(self)

	self.unit = nil
	self.unitGUID = nil

	super(self)
end

function Provider:GetUnit()
	return self.unit
end

function Provider:UpdateIfUnit(event, unit)
	if unit == self.unit or (self.unitOwner and unit == self.unitOwner) then
		self:Update()
	end
end

function Provider:UpdateValueIfUnit(event, unit, ...) -- arg[1] = PowerType
	if unit == self.unit or (self.unitOwner and unit == self.unitOwner) then
		self:UpdateValue(...)
	end
end

function Provider:UpdateColorIfUnit(event, unit, ...) -- arg[1] = powerType
	if unit == self.unit or (self.unitOwner and unit == self.unitOwner) then
		self:UpdateColor(...)
	end
end

function Provider:UpdateUneventedUnit()
	local guid = UnitGUID(self.unit)

	if guid ~= self.unitGUID then
		local oldUnitId = self.unitGUID

		self.unitGUID = guid

		self:RealUnitChanged(oldUnitId)
	else
		self:UpdateValue()
	end
end

function Provider:BarUnitChanged(unit)
	if self.settings.unit == "default" then
		local oldUnit = self.unit

		self.unit = unit

		self:UnitChanged(oldUnit)
		self:Update()
	end
end

function Provider:HandleUnitChange()
	local oldUnitId = self.unitGUID

	self.unitGUID = UnitGUID(self.unit)

	if oldUnitId ~= self.unitGUID then
		self:RealUnitChanged(oldUnitId)
	end
end

function Provider:HandleUnitChangeIfUnit(event, unit)
	if unit == self.unit or (self.unitOwner and unit == self.unitOwner) then
		local oldUnitId = self.unitGUID

		self.unitGUID = UnitGUID(self.unit)

		if oldUnitId ~= self.unitGUID then
			self:RealUnitChanged(oldUnitId)
		end
	end
end

function Provider:RealUnitChanged(oldUnitId)
	self:Update()
end

function Provider:UnitChanged(oldUnit)
	if oldUnit then
		UnderHood:UnregisterUpdateTarget(self)
		self:UnregisterAllEvents()
	end

	local event, haveOwner, owner = UnderHood:GetUnitChangedEvent(self.unit)

	self.unitOwner = owner
	self.unitGUID = UnitGUID(self.unit)

	if event then
		if haveOwner then
			self:RegisterEvent(event, "HandleUnitChangeIfUnit")
		else
			self:RegisterEvent(event, "HandleUnitChange")
		end
	else
		UnderHood:RegisterUpdateTarget(self, "UpdateUneventedUnit")
	end
end

function Provider:CreateOptions()
	local options = super(self)

	options.unit = {
		type = "select",
		order = 10,
		name = L["Unit"],
		values = function() return OO:GetClass("SecureUnitFrame"):GetUnitOptionValues(true) end,
		get = function() return self.settings.unit end,
		set = function(info, value)
			self.settings.unit = value

			local unit = value

			if unit == "default" then
				unit = self.bar:GetUnit()
			end

			if self.unit ~= unit then
				local oldUnit = self.unit
				self.unit = unit

				self:UnitChanged(oldUnit)
				self:Update()
			end
		end,
	}

	return options
end
