local UnderHood = UnderHood
local Module = UnderHood:GetModule("Bars")

local UnitExists = UnitExists
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local UnitPowerType = UnitPowerType
local unpack = unpack

local Provider = UnderHood.OO:NewClass("PowerBarProvider", "BarProviderWithUnit")

function Provider:init(factory)
	super(self, factory, "AceTimer-3.0")
end

function Provider:UnitChanged(oldUnit)
	super(self, oldUnit)

	if self.unit == "player" or self.unit == "pet" then
		self:ScheduleRepeatingTimer("UpdateValue", 0.2)
		self:RegisterEvent("UNIT_DISPLAYPOWER", "UpdateIfUnit")
	elseif UnderHood.UnitSendEvents[self.unit] then
		self:RegisterEvent("UNIT_MAX_POWER", "UpdateValueIfUnit")
		self:RegisterEvent("UNIT_POWER", "UpdateValueIfUnit")
		self:RegisterEvent("UNIT_DISPLAYPOWER", "UpdateIfUnit")
	end
end

function Provider:UpdateColor()
	super(self)

	local colors = Module.db.profile.colors
	local unit = self.unit
	local powerType = UnitExists(unit) and UnitPowerType(unit) or -1
	local r, g, b

	if powerType == SPELL_POWER_MANA then
		r, g, b = unpack(colors.power.mana)
	elseif powerType == SPELL_POWER_RAGE then
		r, g, b = unpack(colors.power.rage)
	elseif powerType == SPELL_POWER_FOCUS then
		r, g, b = unpack(colors.power.focus)
	elseif powerType == SPELL_POWER_ENERGY then
		r, g, b = unpack(colors.power.energy)
	elseif powerType == SPELL_POWER_RUNIC_POWER then
		r, g, b = unpack(colors.power.runicPower)
	else
		r, g, b = unpack(colors.unit.unknown)
	end

	self:SetColor(r, g, b, 1)
end

function Provider:UpdateValue(powerType)
	super(self)

	local unit = self.unit
	local current, max = UnitPower(unit, powerType), UnitPowerMax(unit, powerType)

	current = (max > 0) and (current / max) or 0

	self:SetValue(current)
end

local Factory = UnderHood.OO:NewClass("PowerBarProviderFactory", "BarProviderFactory")

function Factory:init()
	local L = Module.L

	super(self, "Power", L["Power"])
end

function Factory:GetDefaultSettings()
	local settings = super(self)

	settings.unit = "default"

	return settings
end

function Factory:CreateProvider()
	return Provider:new(self)
end

local factory = Factory:new()

Module:RegisterProviderFactory(factory:GetName(), factory)
