local Module = UnderHood:GetModule("Bars")
local L = Module.L

local GetTime = GetTime
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local UnitPowerType = UnitPowerType
local unpack = unpack

local _, unitClass = UnitClass("player")
local fiveSecondLength = 5

local Provider = UnderHood.OO:NewClass("FiveSecondsRuleBarProvider", "BarProvider")

function Provider:init(factory)
	super(self, factory, "AceEvent-3.0")
end

function Provider:IsRealtime()
	return true
end

function Provider:OnAcquire(bar, zone, settings)
	super(self, bar, zone, settings)

	self.powerType = UnitPowerType("player")

	if unitClass ~= "ROGUE" and unitClass ~= "WARRIOR" and unitClass ~= "HUNTER" and unitClass ~= "DEATHKNIGHT" then
		self.currentMana = UnitPower("player", SPELL_POWER_MANA)

		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
		self:RegisterEvent("UNIT_POWER")
	end

	self:UpdateColor()

	self.spellcastFinishTime = 0
	self.lastSpellcast = 0
end

function Provider:Show()
	self.active = true
	self.hideRequest = nil
end

function Provider:Hide()
	if self.active and not self.hideRequest then
		self.hideRequest = 1
	end
end

--
-- Called from OnUpdate of bar
--
-- arguments: currentTime = time when OnUpdate started
-- return values: value, r, g, b, a
--
function Provider:GetRealtimeValueAndColor(currentTime)
	local powerType = self.powerType
	local value

	if not self.active or powerType ~= SPELL_POWER_MANA then return end

	if self.hideRequest and self.hideRequest > 1 then
		self.hideRequest = nil
		self.active = nil

		return 0
	end

	local timeDiff = currentTime - self.spellcastFinishTime

	if timeDiff > fiveSecondLength then
		self.hideRequest = 2
	else
		value = timeDiff / fiveSecondLength
	end

	return value
end

function Provider:UpdateColor()
	local r, g, b, a

	if self.powerType == SPELL_POWER_MANA then
		r, g, b = unpack(Module.db.profile.colors.power.mana)
		a = 1
	else
		r = 0
		g = 0
		b = 0
		a = 0
	end

	self:SetColor(r, g, b, a)
end

function Provider:UNIT_POWER(event, unit, power)
	if unit ~= "player" or self.powerType ~= SPELL_POWER_MANA then
		return
	end

	local mana = UnitPower("player", SPELL_POWER_MANA)

	if mana == UnitPowerMax("player", SPELL_POWER_MANA) then
		self:Hide()
	else
		self:Show()
		self.spellcastFinishTime = self.lastSpellcast
	end

	self.currentMana = mana
end

function Provider:UNIT_SPELLCAST_SUCCEEDED(event, unit)
	if unit == "player" then
		self.lastSpellcast = GetTime()
	end
end

function Provider:UNIT_DISPLAYPOWER(event, unit)
	if unit ~= "player" then return end

	self.powerType = UnitPowerType("player")

	self:UpdateColor()

	if self.powerType == SPELL_POWER_MANA then
		self.currentMana = UnitMana("player")
		self:Show()
	else
		self:Hide()
	end
end

local Factory = UnderHood.OO:NewClass("FiveSecondsRuleBarProviderFactory", "BarProviderFactory")

function Factory:init()
	super(self, "FSR", L["Five Seconds Rule"])
end

function Factory:CreateProvider()
	return Provider:new(self)
end

local factory = Factory:new()

Module:RegisterProviderFactory(factory:GetName(), factory)
