local Module = UnderHood:GetModule("Bars")
local L = Module.L

local GetPrimaryTalentTree = GetPrimaryTalentTree
local GetShapeshiftFormID = GetShapeshiftFormID
local UnitBuff = UnitBuff
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local unpack = unpack

local _, unitClass = UnitClass("player")

local Provider = UnderHood.OO:NewClass("EclipseBarProvider", "BarProvider")

function Provider:init(factory)
	super(self, factory, "AceEvent-3.0", "AceTimer-3.0")
end

function Provider:OnAcquire(bar, zone, settings)
	super(self, bar, zone, settings)

	if unitClass == "DRUID" then
		self:RegisterEvent("UPDATE_SHAPESHIFT_FORM", "UpdateShown")
		self:RegisterEvent("PLAYER_TALENT_UPDATE", "UpdateShown")
		self:RegisterEvent("MASTERY_UPDATE", "UpdateShown")
		self:RegisterEvent("UNIT_AURA", "UpdateEclipseBuffs")
		self:ScheduleRepeatingTimer("UpdateValue", 0.2)
		self:UpdateShown()
	end
end

function Provider:UpdateShown()
	local form = GetShapeshiftFormID()

	if form == MOONKIN_FORM or not form then
		if GetPrimaryTalentTree() == 1 then
--			self:Show()
		else
--			self:Hide()
		end
	else
--		self:Hide()
	end
end

function Provider:UpdateEclipseBuffs()
	local i = 1
	local solar, lunar
	local r, g, b

	local name, _, _, _, _, _, _, _, _, _, spellID = UnitBuff("player", i)
	while name do
		if spellID == ECLIPSE_BAR_SOLAR_BUFF_ID then
			solar = true
		elseif spellID == ECLIPSE_BAR_LUNAR_BUFF_ID then
			lunar = true
		end
		i=i+1
		name, _, _, _, _, _, _, _, _, _, spellID = UnitBuff("player", i);
	end

	if hasSolar then
		r, g, b = unpack(Module.db.profile.colors.power.eclipseSolarActive)
	elseif hasLunar then
		r, g, b = unpack(Module.db.profile.colors.power.eclipseLunarActive)
	else
		r, g, b = unpack(Module.db.profile.colors.power.eclipseLunar)
	end

	self:SetColor(r, g, b, 1)
end

function Provider:UpdateValue()
	super(self)

	local current, max = UnitPower("player", SPELL_POWER_ECLIPSE), UnitPowerMax("player", SPELL_POWER_ECLIPSE)

	current = (max > 0) and (current / max) or 0

	if UnitPower("player", SPELL_POWER_ECLIPSE) ~= 0 and self.combat then
		self:SetValue(current)
		self:UpdateEclipseBuffs()
	end
end

local Factory = UnderHood.OO:NewClass("EclipseBarProviderFactory", "BarProviderFactory")

function Factory:init()
	super(self, "Eclipse", L["Eclipse"])
end

function Factory:CreateProvider()
	return Provider:new(self)
end

local factory = Factory:new()

Module:RegisterProviderFactory(factory:GetName(), factory)

