local Module = UnderHood:GetModule("Bars")
local L = Module.L

local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local UnitPowerType = UnitPowerType
local unpack = unpack

local _, unitClass = UnitClass("player")

local Provider = UnderHood.OO:NewClass("DruidManaBarProvider", "BarProvider")

function Provider:init(factory)
	super(self, factory, "AceEvent-3.0", "AceTimer-3.0")
end

function Provider:OnAcquire(bar, zone, settings)
	super(self, bar, zone, settings)

	self.powerType = UnitPowerType("player")

	if unitClass == "DRUID" then
		self:RegisterEvent("UNIT_DISPLAYPOWER")
		self:UNIT_DISPLAYPOWER("UNIT_DISPLAYPOWER", "player")
		self:UpdateColor()
	end
end

function Provider:UpdateColor()
	local r, g, b = unpack(Module.db.profile.colors.power.mana)

	self:SetColor(r, g, b, 1)
end

function Provider:UpdateValue()
	super(self)

	local current, max = UnitPower("player", SPELL_POWER_MANA), UnitPowerMax("player", SPELL_POWER_MANA)

	current = (max > 0) and (current / max) or 0

	self:SetValue(current)
end

function Provider:UNIT_DISPLAYPOWER(event, unit)
	if unit ~= "player" then return end

	self.powerType = UnitPowerType("player")

	if self.powerType == SPELL_POWER_MANA then
		self:CancelAllTimers()
		self:SetValue(0)
	else
		self:ScheduleRepeatingTimer("UpdateValue", 0.2)
	end
end

local Factory = UnderHood.OO:NewClass("DruidManaBarProviderFactory", "BarProviderFactory")

function Factory:init()
	super(self, "DruidMana", L["Druid Mana"])
end

function Factory:CreateProvider()
	return Provider:new(self)
end

local factory = Factory:new()

Module:RegisterProviderFactory(factory:GetName(), factory)

