local UnderHood = UnderHood
local L = LibStub("AceLocale-3.0"):GetLocale("UnderHood_Auras")

local next = next
local pairs = pairs

local defaults = {
	profile = {
		colorDebuffBorders = true,
		doubleSelfBuffs = false,
		doubleSelfDebuffs = false,
		doubleWhenSolo = false,
		filter = {
			friendBuffs = {
				["*"] = true,
			},
			friendDebuffs = {
				["*"] = true,
			},
			enemyDebuffs = {
				["*"] = true,
			},
		},
	},
}

local Module = UnderHood:NewModule("Auras")
Module.L = L

function Module:OnInitialize()
	self.db = UnderHood.db:RegisterNamespace("Auras", defaults)

	self:CreateOptions()
end

function Module:UpdateFrames()
	for _, v in UnderHood:IterateFrames() do
		if v:instanceOf("AurasFrame") then
			v:ForceUpdate()
		end
	end
end

function Module:CreateOptions()
	local options = {
		name = L["Aura settings"],
		type = "group",
		get = function(info) return self.db.profile[info.arg or info[#info]] end,
		set = function(info, value)
			self.db.profile[info.arg or info[#info]] = value
			self:UpdateFrames()
		end,
		args = {
			colorDebuffBorders = {
				name = L["Color borders"],
				desc = L["Color borders using debuff type color"],
				type = "toggle",
				order = 1,
			},
			doubleSelfDebuffs = {
				name = L["Enlarge my debuffs"],
				desc = L["Enlarge debuffs that was applied by you"],
				type = "toggle",
				order = 2,
			},
			doubleSelfBuffs = {
				name = L["Enlarge my buffs"],
				desc = L["Enlarge buffs that was applied by you"],
				type = "toggle",
				order = 3,
			},
			doubleWhenSolo = {
				name = L["Enlarge when solo"],
				desc = L["Enlarge buffs and debuffs when not in group or raid"],
				type = "toggle",
				order = 4,
			},
			filter = {
				name = L["Filter"],
				type = "group",
				order = 2,
				--childGroups = "tab",
				args = {
					fb = {
						name = L["Friend buffs"],
						type = "group",
						order = 1,
						args = {
							extraSpells = {
								name = L["Class-specific spells"],
								type = "multiselect",
								order = 1,
								hidden = function() return not self.db.profile.filter.extraFriendBuffs end,
								values = function()
									local result = {}

									if self.db.profile.filter.extraFriendBuffs then
										for k in pairs(self.db.profile.filter.extraFriendBuffs) do
											result[k] = k
										end
									end

									return result
								end,
								get = function(info, key)
									return self.db.profile.filter.extraFriendBuffs[key]
								end,
								set = function(info, key, value)
									self.db.profile.filter.extraFriendBuffs[key] = value
									self:UpdateFrames()
								end,
							},
							descr = {
								name =  L["To add or remove additional spell you need to type spell name into respective input box below and press [Enter]."],
								type = "description",
								order = 2,
							},
							add = {
								name = L["Enter the name of the spell you wish to add"],
								type = "input",
								order = 3,
								width = "full",
								get = function(info) return "" end,
								set = function(info, value)
									if not self.db.profile.filter.extraFriendBuffs then
										self.db.profile.filter.extraFriendBuffs = {}
									end

									if self.db.profile.filter.extraFriendBuffs[value] == nil then
										self.db.profile.filter.extraFriendBuffs[value] = true
										self:UpdateFrames()
										UnderHood:NotifyOptionsChanged()
									end
								end,
							},
							remove = {
								name = L["Enter the name of the spell you wish to remove"],
								type = "input",
								order = 4,
								width = "full",
								hidden = function() return not self.db.profile.filter.extraFriendBuffs end,
								get = function(info) return "" end,
								set = function(info, value)
									if self.db.profile.filter.extraFriendBuffs and self.db.profile.filter.extraFriendBuffs[value] ~= nil then
										self.db.profile.filter.extraFriendBuffs[value] = nil

										if not next(self.db.profile.filter.extraFriendBuffs) then
											self.db.profile.filter.extraFriendBuffs = nil
										end

										self:UpdateFrames()
										UnderHood:NotifyOptionsChanged()
									end
								end,
							},
						},
					},
					fd = {
						name = L["Friend debuffs"],
						type = "group",
						order = 2,
						args = {
							extraSpells = {
								name = L["Class-specific spells"],
								type = "multiselect",
								order = 1,
								hidden = function() return not self.db.profile.filter.extraFriendDebuffs end,
								values = function()
									local result = {}

									if self.db.profile.filter.extraFriendDebuffs then
										for k in pairs(self.db.profile.filter.extraFriendDebuffs) do
											result[k] = k
										end
									end

									return result
								end,
								get = function(info, key)
									return self.db.profile.filter.extraFriendDebuffs[key]
								end,
								set = function(info, key, value)
									self.db.profile.filter.extraFriendDebuffs[key] = value
									self:UpdateFrames()
								end,
							},
							descr = {
								name =  L["To add or remove additional spell you need to type spell name into respective input box below and press [Enter]."],
								type = "description",
								order = 2,
							},
							add = {
								name = L["Enter the name of the spell you wish to add"],
								type = "input",
								order = 3,
								width = "full",
								get = function(info) return "" end,
								set = function(info, value)
									if not self.db.profile.filter.extraFriendDebuffs then
										self.db.profile.filter.extraFriendDebuffs = {}
									end

									if self.db.profile.filter.extraFriendDebuffs[value] == nil then
										self.db.profile.filter.extraFriendDebuffs[value] = true
										self:UpdateFrames()
										UnderHood:NotifyOptionsChanged()
									end
								end,
							},
							remove = {
								name = L["Enter the name of the spell you wish to remove"],
								type = "input",
								order = 4,
								width = "full",
								hidden = function() return not self.db.profile.filter.extraFriendDebuffs end,
								get = function(info) return "" end,
								set = function(info, value)
									if self.db.profile.filter.extraFriendDebuffs and self.db.profile.filter.extraFriendDebuffs[value] ~= nil then
										self.db.profile.filter.extraFriendDebuffs[value] = nil

										if not next(self.db.profile.filter.extraFriendDebuffs) then
											self.db.profile.filter.extraFriendDebuffs = nil
										end

										self:UpdateFrames()
										UnderHood:NotifyOptionsChanged()
									end
								end,
							},
						},
					},
					ed = {
						name = L["Enemy debuffs"],
						type = "group",
						order = 3,
						args = {
							extraSpells = {
								name = L["Class-specific spells"],
								type = "multiselect",
								order = 1,
								hidden = function() return not self.db.profile.filter.extraEnemyDebuffs end,
								values = function()
									local result = {}

									if self.db.profile.filter.extraEnemyDebuffs then
										for k in pairs(self.db.profile.filter.extraEnemyDebuffs) do
											result[k] = k
										end
									end

									return result
								end,
								get = function(info, key)
									return self.db.profile.filter.extraEnemyDebuffs[key]
								end,
								set = function(info, key, value)
									self.db.profile.filter.extraEnemyDebuffs[key] = value
									self:UpdateFrames()
								end,
							},
							descr = {
								name = L["To add or remove additional spell you need to type spell name into respective input box below and press [Enter]."],
								type = "description",
								order = 2,
							},
							add = {
								name = L["Enter the name of the spell you wish to add"],
								type = "input",
								order = 3,
								width = "full",
								get = function(info) return "" end,
								set = function(info, value)
									if not self.db.profile.filter.extraEnemyDebuffs then
										self.db.profile.filter.extraEnemyDebuffs = {}
									end

									if self.db.profile.filter.extraEnemyDebuffs[value] == nil then
										self.db.profile.filter.extraEnemyDebuffs[value] = true
										self:UpdateFrames()
										UnderHood:NotifyOptionsChanged()
									end
								end,
							},
							remove = {
								name = L["Enter the name of the spell you wish to remove"],
								type = "input",
								order = 4,
								width = "full",
								hidden = function() return not self.db.profile.filter.extraEnemyDebuffs end,
								get = function(info) return "" end,
								set = function(info, value)
									if self.db.profile.filter.extraEnemyDebuffs and self.db.profile.filter.extraEnemyDebuffs[value] ~= nil then
										self.db.profile.filter.extraEnemyDebuffs[value] = nil

										if not next(self.db.profile.filter.extraEnemyDebuffs) then
											self.db.profile.filter.extraEnemyDebuffs = nil
										end

										self:UpdateFrames()
										UnderHood:NotifyOptionsChanged()
									end
								end,
							},
						},
					},
				},
			},
		},
	}

	UnderHood:AddGeneralOptionsSection("auras", options)
end
