-- List and breakdown of spells is taken from PitBull_Aura

local Module = UnderHood:GetModule("Auras")

local GetSpellInfo = GetSpellInfo
local GetTalentInfo = GetTalentInfo

local canDispel
local _, playerClass = UnitClass("player")

local function scanForKnownTalent(spellid) 
	local wantedName, _ = GetSpellInfo(spellid)
	if not wantedName then return nil end
	local numTabs = GetNumSpecializations()
	for t=1, numTabs do
		local numTalents = GetNumTalents(t)
		for i=1, numTalents do
			local nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(t, i)
			if nameTalent and (nameTalent == wantedName) then
				if currentRank and (currentRank > 0) then
					return true
				else
					return nil
				end
			end
		end
	end
	return nil
end

if playerClass == "DRUID" then
	canDispel = {
		["Curse"] = true,
		["Magic"] = scanForKnownTalent(88423),
		["Poison"] = true,
	}
elseif playerClass == "MAGE" then
	canDispel = {
		["Curse"] = true,
	}
elseif playerClass == "PALADIN" then
	canDispel = {
		["Disease"] = true,
		["Magic"] = scanForKnownTalent(53551),
		["Poison"] = true,
	}
elseif playerClass == "PRIEST" then
	canDispel = {
		["Curse"] = true,
		["Disease"] = true,
	}
elseif playerClass == "SHAMAN" then
	canDispel = {
		["Curse"] = true,
		["Magic"] = scanForKnownTalent(77130),
	}
elseif playerClass == "WARLOCK" then
	canDispel = {
		["Magic"] = true,
	}
end

Module.Spells = {
	canDispel = canDispel,
}
