local UnderHood = UnderHood

local pairs = pairs
local select = select
local strfind = strfind
local strformat = strformat
local tostring = tostring
local type = type

UnderHood.Debug = function() end
UnderHood.ModulePrototype.Debug = function() end


function UnderHood:CopyTable(src, dest)
	if type(dest) ~= "table" then dest = {} end
	if type(src) == "table" then
		for k, v in pairs(src) do
			if type(v) == "table" then
				-- try to index the key first so that the metatable creates the defaults, if set, and use that table
				v = self:CopyTable(v, dest[k])
			end

			dest[k] = v
		end
	end

	return dest
end

--[===[@debug@
local debug = true

UnderHood:RegisterChatCommand("uhd", function()
	if debug then
		UnderHood:Print("Debug turned off.")
	else
		UnderHood:Print("Debug turned on.")
	end

	debug = not debug
	end)

local function debugPrint(self, ...)
	if not debug then return end

	local elem = ...
	local count = select("#", ...);
	local text = nil;

	if count == 0 then
		text = ""
	elseif count == 1 then
		text = tostring(elem)
	elseif type(elem) == "string" and strfind(elem, "%%") then
		text = strformat(...)
	else
		text = ""

		for i=1, count do
			if i > 1 then
				text = text..", "
			end

			text = text..tostring(select(i, ...))
		end
	end

	print("|cffff0000"..(self and tostring(self) or "UnderHood")..": |r"..text);
end

UnderHood.Debug = debugPrint
UnderHood.ModulePrototype.Debug = debugPrint
--@end-debug@]===]
