local MAJOR_VERSION, MINOR_VERSION = GetAddOnMetadata("UnderHood", "Version"), string.match("$Revision$", "%d+") or -1
local L = LibStub("AceLocale-3.0"):GetLocale("UnderHood2")

UnderHood = LibStub("AceAddon-3.0"):NewAddon("UnderHood", "AceEvent-3.0", "AceTimer-3.0", "AceConsole-3.0")
local UnderHood = UnderHood

local next = next
local strformat = string.format
local type = type

UnderHood.L = L
UnderHood.addonPath = "Interface\\Addons\\UnderHood"

local defaults = {
	profile = {
		alpha = {
			enablePet = true,
			enableFocus = true,
			enableTarget = true,
			enableCasting = true,
			enableRegen = true,
			combat = 1,
			ooc = 0,
			regen = 0.75,
			target = 0.75,
			focus = 0.75,
			pet = 0.75,
			casting = 0.75,
		},
		modules = {
			["*"] = true,
		},
		frames = {
			["**"] = {
				enable = true,
				settings = {
					alpha = {
						inherit = true,
						enablePet = true,
						enableFocus = true,
						enableTarget = true,
						enableCasting = true,
						enableRegen = true,
						combat = 1,
						ooc = 0,
						regen = 0.75,
						target = 0.75,
						focus = 0.75,
						pet = 0.75,
						casting = 0.75,
					},
				},
			},
		},
	},
}

UnderHood:SetDefaultModuleState(false)

function UnderHood:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("UnderHoodDB", defaults, "Default")

	self.db.RegisterCallback(self, "OnNewProfile", "HandleProfileChanges")
	self.db.RegisterCallback(self, "OnProfileReset", "HandleProfileChanges")
	self.db.RegisterCallback(self, "OnProfileChanged", "HandleProfileChanges")
	self.db.RegisterCallback(self, "OnProfileCopied", "HandleProfileChanges")

	self:InitializeOptions()

	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")

	if not ClickCastFrames then
		ClickCastFrames = {}
	end

	self:Print(strformat(L["Version %s.%d loaded. Type |cff00ffff/uh|r to configure."], MAJOR_VERSION, MINOR_VERSION))
end

function UnderHood:OnEnable()
	self.inCombat = InCombatLockdown()

	self:ScheduleRepeatingTimer("ProcessUpdate", 0.2) -- Too few checks?
	self:InitializeAlphaEngine()

	self:HandleProfileChanges("OnProfileChanged")

	for _, v in self:IterateFrames() do
		v:ConfigurationModeChanged(false)
	end
end

function UnderHood:HandleProfileChanges(event, ...)
	-- Enabling/disabling modules

	for moduleName, module in self:IterateModules() do
		if self.db.profile.modules[moduleName] then
			if not module:IsEnabled() then
				module:Enable()
			end

			if type(module.HandleProfileChanges) == "function" then
				module:HandleProfileChanges(event, ...)
			end
		else
			if module:IsEnabled() then
				module:Disable()
			end
		end
	end

	if event == "OnProfileReset" or event == "OnProfileChanged" then
		if not self.db.profile.version and not next(self.db.profile.frames) then
			self:ApplyDefaultLayout()
			self.db.profile.version = MAJOR_VERSION
		end
	end

	self:ReloadFrames()
	self:UpdateAlpha()
end

function UnderHood:PLAYER_REGEN_DISABLED()
	self.inCombat = true

	self:UpdateAlpha()

	for _, v in self:IterateFrames() do
		v:OnEnterCombat()
	end
end

function UnderHood:PLAYER_REGEN_ENABLED()
	self.inCombat = false

	self:UpdateAlpha()

	for _, v in self:IterateFrames() do
		v:OnLeaveCombat()
	end
end

UnderHood.ModulePrototype = {}
UnderHood.ModulePrototype.__index = UnderHood.ModulePrototype

UnderHood:SetDefaultModulePrototype(UnderHood.ModulePrototype)