local UnderHood = UnderHood
local L = UnderHood.L

local assert = assert
local type = type

UnderHood.configMode = false

local options = {
	type = "group",
	handler = UnderHood,
	args = {
		general = {
			type = "group",
			name = L["General settings"],
			order = 1,
			args = {
				config = {
					type = "toggle",
					name = L["Configuration mode"],
					order = 1,
					get = function() return UnderHood.configMode end,
					set = function(info, value)
						UnderHood.configMode = value

						for _, v in UnderHood:IterateFrames() do
							v:ConfigurationModeChanged(value)
						end

						UnderHood:UpdateAlpha()
					end,
				},
				alpha = {
					name = L["Alpha settings"],
					type = "group",
					order = 2,
					get = function(info) return UnderHood.db.profile.alpha[info[#info]] end,
					set = function(info, value) UnderHood.db.profile.alpha[info[#info]] = value; UnderHood:UpdateAlpha() end,
					args = {
						combat = {
							name = L["Combat"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 2,
						},
						ooc = {
							name = L["Out of Combat"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 3,
						},
						regen = {
							name = L["Regenerating"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 4,
						},
						casting = {
							name = L["Casting"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 5,
						},
						target = {
							name = L["Have target"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 6,
						},
						focus = {
							name = L["Have focus"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 7,
						},
						pet = {
							name = L["Have pet"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 8,
						},
						header = {
							name = "\n"..L["You can enable or disable some conditions by checking or unchecking boxes below:"].."\n",
							type = "description",
							order = 9,
						},
						enableCasting = {
							name = L["Enable |cffffff00Casting|r"],
							type = "toggle",
							order = 10,
						},
						enableRegen = {
							name = L["Enable |cffffff00Regenerating|r"],
							type = "toggle",
							order = 11,
						},
						enableTarget = {
							name = L["Enable |cffffff00Have Target|r"],
							type = "toggle",
							order = 12,
						},
						enableFocus = {
							name = L["Enable |cffffff00Have Focus|r"],
							type = "toggle",
							order = 13,
						},
						enablePet = {
							name = L["Enable |cffffff00Have Pet|r"],
							type = "toggle",
							order = 14,
						},
					},
				},
			},
		},
--[[ Disabled for now, since I don't really know why I need this :)
		modules = {
			type = "group",
			name = L["Modules"],
			order = 2,
			args = {
				toggle = {
					type = "multiselect",
					name = L["Enable or disable specific modules"],
					order = 1,
					values = function()
						local modules = {}

						for k, v in UnderHood:IterateModules() do
							modules[k] = v:GetName()
						end

						return modules
					end,
					get = function(info, key)
						return UnderHood:GetModule(key):IsEnabled()
					end,
					set = function(info, key, value)
						if value then
							UnderHood:GetModule(key):Enable()
						else
							UnderHood:GetModule(key):Disable()
						end

						UnderHood.db.profile.modules[key] = value
					end
				},
			},
			plugins = { modules = {} },
		},
--]]
	},
}

function UnderHood:OnModuleCreated(module)
--[[
	if type(module.GetOptions) == "function" then
		local moduleOptions = module:GetOptions()

		if moduleOptions then
			moduleOptions.hidden = function() return not module:IsEnabled() end
		end

		options.args.modules.plugins.modules[module:GetName()] = moduleOptions
	end

	self:NotifyOptionsChanged()
--]]
end

function UnderHood:InitializeOptions()
	-- Adding profiles
	options.args.profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	options.args.profiles.order = -1

	-- Registering
	LibStub("AceConfig-3.0"):RegisterOptionsTable("UnderHood", options)
	self:RegisterChatCommand("UnderHood", function() LibStub("AceConfigDialog-3.0"):Open("UnderHood") end)

	local ldb = LibStub:GetLibrary("LibDataBroker-1.1")

	if ldb then
		LibStub:GetLibrary("LibDataBroker-1.1"):NewDataObject("UnderHood", {
			type = "launcher",
			icon = "Interface\\Icons\\INV_Helmet_99",
			OnClick = function(clickedframe, button)
				LibStub("AceConfigDialog-3.0"):Open("UnderHood")
			end,
		})
	end
end

function UnderHood:NotifyOptionsChanged()
	LibStub("AceConfigRegistry-3.0"):NotifyChange("UnderHood")
end

function UnderHood:AddToplevelOptionsSection(name, section)
	assert(type(name) == "string")
	assert(type(section) == "table")

	options.args[name] = section

	self:NotifyOptionsChanged()
end

function UnderHood:AddGeneralOptionsSection(name, section)
	assert(type(name) == "string")
	assert(type(section) == "table")

	options.args.general.args[name] = section

	self:NotifyOptionsChanged()
end
