local _, class = UnitClass("player")

local controlAuraName = UnderHood.L["ClassControlAura_"..class] or ""

local frames = {
	["PlayerDebuffs"] = {
		["class"] = "AurasFrame",
		["settings"] = {
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "vehicle",
			},
			["positionAndSize"] = {
				["y"] = 141,
				["x"] = -119,
				["point"] = "CENTER",
				["width"] = 1,
				["scale"] = 1,
				["height"] = 1,
				["targetPoint"] = "CENTER",
				["targetFrame"] = ":uiparent:",
			},
			["auras"] = {
				["type"] = "debuffs",
				["maxAuras"] = 16,
				["spacing"] = 1,
				["columns"] = 8,
				["layout"] = "RTU",
				["tooltips"] = "ooc",
				["size"] = 30,
			},
		},
	},
	["ThreatText"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 16,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "player",
			},
			["text"] = "[PercentThreat:Round:Hide(0):Percent:UnitThreatStatusColor]",
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -4,
				["point"] = "TOPRIGHT",
				["targetFrame"] = "ThreatBar",
				["scale"] = 1,
				["targetPoint"] = "TOPLEFT",
				["height"] = 18,
				["width"] = 50,
			},
			["fontName"] = "Arial Narrow",
			["hAlign"] = "RIGHT",
		},
	},
	["PlayerLeaderIcon"] = {
		["class"] = "Icon",
		["settings"] = {
			["icon"] = "leader",
			["positionAndSize"] = {
				["y"] = -2,
				["x"] = 2,
				["point"] = "TOPLEFT",
				["targetFrame"] = "PlayerHealthBar",
				["scale"] = 1,
				["targetPoint"] = "TOPRIGHT",
				["height"] = 12,
				["width"] = 12,
			},
			["general"] = {
				["interactive"] = false,
				["visibility"] = "ooc",
				["unit"] = "player",
			},
		},
	},
	["FocusPolyTimer"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 19,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "focus",
			},
			["text"] = "[AuraDuration(\""..controlAuraName.."\"):Floor]",
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 0,
				["point"] = "RIGHT",
				["targetFrame"] = "FocusPortrait",
				["scale"] = 1,
				["targetPoint"] = "LEFT",
				["height"] = 16,
				["width"] = 80,
			},
			["fontName"] = "Morpheus",
			["hAlign"] = "RIGHT",
		},
	},
	["TargetPowerBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Power",
					["settings"] = {
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["style"] = "UnderHood",
			["styleSettings"] = {
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["cbVertical"] = true,
				["showBorder"] = true,
				["showBackground"] = false,
				["sbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["general"] = {
				["interactive"] = false,
				["visibility"] = "auto",
				["unit"] = "target",
			},
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -3,
				["point"] = "LEFT",
				["targetFrame"] = "PlayerPowerBar",
				["scale"] = 1,
				["targetPoint"] = "RIGHT",
				["height"] = 256,
				["width"] = 22,
			},
			["tooltips"] = "never",
		},
	},
	["TargetPowerText"] = {
		["class"] = "Text",
		["settings"] = {
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "target",
			},
			["fontSize"] = 14,
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 20,
				["point"] = "TOPLEFT",
				["targetFrame"] = "PlayerPowerText",
				["scale"] = 1,
				["targetPoint"] = "BOTTOMLEFT",
				["height"] = 18,
				["width"] = 150,
			},
			["fontName"] = "Arial Narrow",
			["text"] = "[HasMP ? FractionalMP:PowerColor] [HasMP ? PercentMP:Percent:PowerColor:Paren]",
		},
	},
	["PlayerHealthBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Health",
					["settings"] = {
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "Cast",
					["settings"] = {
						["unit"] = "default",
					},
				}, -- [2]
			},
			["style"] = "UnderHood",
			["styleSettings"] = {
				["sbReversed"] = true,
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["rcbVertical"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "ooc",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -200,
				["point"] = "CENTER",
				["width"] = 22,
				["scale"] = 1,
				["height"] = 256,
				["targetPoint"] = "CENTER",
				["targetFrame"] = ":uiparent:",
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "player",
			},
		},
	},
	["PlayerHolyPower"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "HolyPower",
					["settings"] = {
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["class"] = "PALADIN",
				["unit"] = "player",
			},
			["styleSettings"] = {
				["sbReversed"] = true,
				["rcbReversed"] = false,
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["rcbVertical"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["sbVertical"] = true,
				["showBorder"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -3,
				["point"] = "TOPLEFT",
				["width"] = 21,
				["scale"] = 1,
				["height"] = 93,
				["targetPoint"] = "TOPRIGHT",
				["targetFrame"] = "PlayerHealthBar",
			},
			["tooltips"] = "never",
			["style"] = "UnderHood",
		},
	},
	["PlayerSoulShards"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "SoulShards",
					["settings"] = {
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["class"] = "WARLOCK",
				["unit"] = "player",
			},
			["styleSettings"] = {
				["sbReversed"] = true,
				["rcbReversed"] = false,
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["rcbVertical"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["sbVertical"] = true,
				["showBorder"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -3,
				["point"] = "TOPLEFT",
				["width"] = 21,
				["scale"] = 1,
				["height"] = 93,
				["targetPoint"] = "TOPRIGHT",
				["targetFrame"] = "PlayerHealthBar",
			},
			["tooltips"] = "never",
			["style"] = "UnderHood",
		},
	},
	["PlayerEclipse"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Eclipse",
					["settings"] = {
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["class"] = "DRUID",
				["unit"] = "player",
			},
			["styleSettings"] = {
				["sbReversed"] = true,
				["rcbReversed"] = false,
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["rcbVertical"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["sbVertical"] = true,
				["showBorder"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -3,
				["point"] = "TOPLEFT",
				["width"] = 21,
				["scale"] = 1,
				["height"] = 93,
				["targetPoint"] = "TOPRIGHT",
				["targetFrame"] = "PlayerHealthBar",
			},
			["tooltips"] = "never",
			["style"] = "UnderHood",
		},
	},
	["ComboPoints"] = {
		["class"] = "ComboPoints",
		["settings"] = {
			["positionAndSize"] = {
				["y"] = -5,
				["x"] = 10,
				["point"] = "TOPLEFT",
				["targetFrame"] = "TargetPowerBar",
				["scale"] = 1,
				["targetPoint"] = "TOPRIGHT",
				["height"] = 1,
				["width"] = 1,
			},
			["combo"] = {
				["size"] = 16,
				["layout"] = "D",
				["style"] = "default",
				["spacing"] = 0,
			},
		},
	},
	["PlayerRestingIcon"] = {
		["class"] = "Icon",
		["settings"] = {
			["icon"] = "resting",
			["positionAndSize"] = {
				["y"] = -4,
				["x"] = 0,
				["point"] = "TOP",
				["width"] = 14,
				["scale"] = 1,
				["height"] = 14,
				["targetPoint"] = "BOTTOM",
				["targetFrame"] = "PlayerMasterLooterIcon",
			},
			["general"] = {
				["visibility"] = "ooc",
				["interactive"] = false,
				["unit"] = "player",
			},
		},
	},
	["PlayerHealthText"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 14,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "player",
			},
			["text"] = "[FractionalHP:Green] [PercentHP:Percent:Green:Paren]",
			["style"] = "Smart",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 0,
				["point"] = "TOPRIGHT",
				["targetFrame"] = "PlayerHealthBar",
				["scale"] = 1,
				["targetPoint"] = "BOTTOMRIGHT",
				["height"] = 18,
				["width"] = 150,
			},
			["fontName"] = "Arial Narrow",
			["hAlign"] = "RIGHT",
		},
	},
	["PlayerPowerBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Power",
					["settings"] = {
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "GCD",
					["settings"] = {
						["primarySpell"] = "Раскаленный доспех",
						["secondarySpell"] = "Выстрел",
					},
				}, -- [2]
			},
			["style"] = "UnderHood",
			["styleSettings"] = {
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["cbVertical"] = true,
				["showBackground"] = false,
				["sbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 200,
				["point"] = "CENTER",
				["targetFrame"] = ":uiparent:",
				["scale"] = 1,
				["targetPoint"] = "CENTER",
				["height"] = 256,
				["width"] = 22,
			},
			["general"] = {
				["interactive"] = false,
				["visibility"] = "auto",
				["unit"] = "player",
			},
		},
	},
	["PlayerCastSpell"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 14,
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "player",
			},
			["text"] = "[Alpha((-CastStopDuration or 0) + 1) CastName:Abbreviate]",
			["style"] = "Spell name",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -2,
				["point"] = "BOTTOMRIGHT",
				["width"] = 100,
				["scale"] = 1,
				["height"] = 16,
				["targetPoint"] = "TOPRIGHT",
				["targetFrame"] = "PlayerHealthBar",
			},
			["fontName"] = "Arial Narrow",
			["hAlign"] = "RIGHT",
		},
	},
	["TargetOfTargetBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Health",
					["settings"] = {
						["colorByClass"] = false,
						["colorByHostility"] = true,
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "Power",
					["settings"] = {
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [2]
			},
			["style"] = "UnderHood",
			["styleSettings"] = {
				["cbReversed"] = false,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = false,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = false,
				["showBackground"] = false,
				["cbVertical"] = false,
				["sbTexture"] = "Armory",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = -122,
				["x"] = 0,
				["point"] = "CENTER",
				["targetFrame"] = ":uiparent:",
				["scale"] = 1,
				["targetPoint"] = "CENTER",
				["height"] = 28,
				["width"] = 240,
			},
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "targettarget",
			},
		},
	},
	["PetPowerBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Power",
					["settings"] = {
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "Cast",
					["settings"] = {
						["unit"] = "default",
					},
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "pet",
			},
			["styleSettings"] = {
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -2,
				["point"] = "LEFT",
				["targetFrame"] = "PetHealthBar",
				["scale"] = 1,
				["targetPoint"] = "RIGHT",
				["height"] = 128,
				["width"] = 21,
			},
			["style"] = "UnderHood",
		},
	},
	["TargetOfTargetName"] = {
		["class"] = "Text",
		["settings"] = {
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "targettarget",
			},
			["fontSize"] = 14,
			["style"] = "Long",
			["category"] = "name",
			["positionAndSize"] = {
				["strata"] = "HIGH",
				["point"] = "LEFT",
				["targetPoint"] = "LEFT",
				["width"] = 120,
				["y"] = 1,
				["x"] = 8,
				["height"] = 18,
				["targetFrame"] = "TargetOfTargetBar",
				["scale"] = 1,
			},
			["fontName"] = "Arial Narrow",
			["text"] = "[Level:DifficultyColor:Bracket] [Name:ClassColor] [AFK || DND]",
		},
	},
	["PlayerMasterLooterIcon"] = {
		["class"] = "Icon",
		["settings"] = {
			["general"] = {
				["icon"] = "resting",
				["visibility"] = "ooc",
				["interactive"] = false,
				["unit"] = "player",
			},
			["positionAndSize"] = {
				["y"] = -2,
				["x"] = 0,
				["point"] = "TOPLEFT",
				["targetFrame"] = "PlayerLeaderIcon",
				["scale"] = 1,
				["targetPoint"] = "BOTTOMLEFT",
				["height"] = 12,
				["width"] = 12,
			},
			["icon"] = "ml",
		},
	},
	["TargetHealthBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Health",
					["settings"] = {
						["colorByHostility"] = true,
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "Cast",
					["settings"] = {
						["unit"] = "default",
					},
				}, -- [2]
			},
			["style"] = "UnderHood",
			["styleSettings"] = {
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 3,
				["point"] = "RIGHT",
				["targetFrame"] = "PlayerHealthBar",
				["scale"] = 1,
				["targetPoint"] = "LEFT",
				["height"] = 256,
				["width"] = 22,
			},
			["general"] = {
				["interactive"] = false,
				["visibility"] = "auto",
				["unit"] = "target",
			},
		},
	},
	["FocusPowerBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Power",
					["settings"] = {
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "Cast",
					["settings"] = {
						["unit"] = "default",
					},
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "focus",
			},
			["styleSettings"] = {
				["sbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["cbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -2,
				["point"] = "LEFT",
				["width"] = 21,
				["scale"] = 1,
				["height"] = 128,
				["targetPoint"] = "RIGHT",
				["targetFrame"] = "FocusHealthBar",
			},
			["style"] = "UnderHood",
		},
	},
	["TartetRaidIcon"] = {
		["class"] = "Icon",
		["settings"] = {
			["icon"] = "rt",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 0,
				["point"] = "TOP",
				["width"] = 20,
				["scale"] = 1,
				["height"] = 20,
				["targetPoint"] = "BOTTOM",
				["targetFrame"] = "TargetOfTargetBar",
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "target",
			},
		},
	},
	["PlayerCastTime"] = {
		["class"] = "Text",
		["settings"] = {
			["style"] = "Long",
			["fontSize"] = 14,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "player",
			},
			["category"] = "cast",
			["text"] = "[if not CastStopDuration then Concatenate('+', CastDelay:Round(1):Hide(0)):Red ' ' [CastEndDuration >= 0 ? '%.1f':Format(CastEndDuration)]]",
			["fontName"] = "Arial Narrow",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 4,
				["point"] = "LEFT",
				["targetFrame"] = "PlayerCastSpell",
				["scale"] = 1,
				["targetPoint"] = "RIGHT",
				["height"] = 16,
				["width"] = 50,
			},
		},
	},
	["FocusRaidTargetIcon"] = {
		["class"] = "Icon",
		["settings"] = {
			["positionAndSize"] = {
				["y"] = -2,
				["x"] = 0,
				["point"] = "TOP",
				["targetFrame"] = "FocusPortrait",
				["scale"] = 1,
				["targetPoint"] = "BOTTOM",
				["height"] = 20,
				["width"] = 20,
			},
			["general"] = {
				["interactive"] = false,
				["visibility"] = "auto",
				["unit"] = "focus",
			},
			["icon"] = "rt",
		},
	},
	["FocusPortrait"] = {
		["class"] = "Portrait",
		["settings"] = {
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "focus",
			},
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 3,
				["point"] = "BOTTOMRIGHT",
				["width"] = 40,
				["scale"] = 1,
				["height"] = 40,
				["targetPoint"] = "BOTTOMLEFT",
				["targetFrame"] = "PlayerPowerBar",
			},
			["portrait"] = {
				["style"] = "animated",
				["showBorder"] = true,
			},
		},
	},
	["TargetInfoText"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 16,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "target",
			},
			["text"] = "[Level:DifficultyColor:Bracket] [Name:ClassColor] [AFK || DND]\n[Classification] [SmartRace:Bracket] [SmartClass:ClassColor] [DruidForm:Paren]\n[Guild:Angle]",
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = -22,
				["x"] = 0,
				["point"] = "TOP",
				["targetFrame"] = "TargetOfTargetBar",
				["scale"] = 1,
				["targetPoint"] = "BOTTOM",
				["height"] = 50,
				["width"] = 256,
			},
			["vAlign"] = "TOP",
			["fontName"] = "Arial Narrow",
			["hAlign"] = "CENTER",
		},
	},
	["PetHealthBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Health",
					["settings"] = {
						["colorByHostility"] = true,
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "pet",
			},
			["styleSettings"] = {
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = -3,
				["x"] = 0,
				["point"] = "BOTTOMLEFT",
				["targetFrame"] = "PetPortrait",
				["scale"] = 1,
				["targetPoint"] = "TOPLEFT",
				["height"] = 128,
				["width"] = 21,
			},
			["style"] = "UnderHood",
		},
	},
	["PetPowerText"] = {
		["class"] = "Text",
		["settings"] = {
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = true,
				["unit"] = "pet",
			},
			["fontSize"] = 14,
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 0,
				["point"] = "BOTTOMLEFT",
				["targetFrame"] = "PetPowerBar",
				["scale"] = 1,
				["targetPoint"] = "BOTTOMRIGHT",
				["height"] = 16,
				["width"] = 40,
			},
			["fontName"] = "Friz Quadrata TT",
			["text"] = "[MP:Hide(0):PowerColor]",
		},
	},
	["PlayerPowerText"] = {
		["class"] = "Text",
		["settings"] = {
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "player",
			},
			["fontSize"] = 14,
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 0,
				["point"] = "TOPLEFT",
				["targetFrame"] = "PlayerPowerBar",
				["scale"] = 1,
				["targetPoint"] = "BOTTOMLEFT",
				["height"] = 18,
				["width"] = 150,
			},
			["fontName"] = "Arial Narrow",
			["text"] = "[HasMP ? FractionalMP:PowerColor] [HasMP ? PercentMP:Percent:PowerColor:Paren]",
		},
	},
	["TargetHealthText"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 14,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "target",
			},
			["text"] = "[FractionalHP:HostileColor] [PercentHP:Percent:HostileColor:Paren]",
			["style"] = "Spell name",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -20,
				["point"] = "TOPRIGHT",
				["targetFrame"] = "PlayerHealthText",
				["scale"] = 1,
				["targetPoint"] = "BOTTOMRIGHT",
				["height"] = 18,
				["width"] = 150,
			},
			["fontName"] = "Arial Narrow",
			["hAlign"] = "RIGHT",
		},
	},
	["PetRemainingTime"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 19,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "pet",
			},
			["text"] = "[PetRemainingTime:Round]",
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 0,
				["point"] = "LEFT",
				["width"] = 80,
				["scale"] = 1,
				["height"] = 16,
				["targetPoint"] = "RIGHT",
				["targetFrame"] = "PetPortrait",
			},
			["fontName"] = "Morpheus",
			["hAlign"] = "LEFT",
		},
	},
	["TargetOfTargetHealthText"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 14,
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = true,
				["unit"] = "targettarget",
			},
			["text"] = "[FractionalHP:Short] ([PercentHP:Percent])",
			["style"] = "Absolute Short",
			["category"] = "none",
			["positionAndSize"] = {
				["strata"] = "HIGH",
				["point"] = "RIGHT",
				["targetPoint"] = "RIGHT",
				["targetFrame"] = "TargetOfTargetBar",
				["y"] = 1,
				["x"] = -6,
				["height"] = 18,
				["scale"] = 1,
				["width"] = 140,
			},
			["fontName"] = "Arial Narrow",
			["hAlign"] = "RIGHT",
		},
	},
	["FocusName"] = {
		["class"] = "Text",
		["settings"] = {
			["fontSize"] = 14,
			["general"] = {
				["interactive"] = true,
				["visibility"] = "auto",
				["unit"] = "focus",
			},
			["text"] = "[Name:Abbreviate:ClassColor] [Level:DifficultyColor:Bracket]",
			["style"] = "Long",
			["category"] = "none",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = -4,
				["point"] = "BOTTOMRIGHT",
				["targetFrame"] = "FocusPowerBar",
				["scale"] = 1,
				["targetPoint"] = "TOPRIGHT",
				["height"] = 16,
				["width"] = 150,
			},
			["fontName"] = "Arial Narrow",
			["hAlign"] = "RIGHT",
		},
	},
	["PetPortrait"] = {
		["class"] = "Portrait",
		["settings"] = {
			["positionAndSize"] = {
				["strata"] = "MEDIUM",
				["point"] = "BOTTOMLEFT",
				["targetPoint"] = "BOTTOMRIGHT",
				["targetFrame"] = "PlayerHealthBar",
				["y"] = 0,
				["x"] = -3,
				["height"] = 40,
				["width"] = 40,
				["scale"] = 1,
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = true,
				["unit"] = "pet",
			},
			["portrait"] = {
				["style"] = "animated",
				["showBorder"] = true,
			},
		},
	},
	["FocusHealthBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Health",
					["settings"] = {
						["colorByHostility"] = true,
						["unit"] = "default",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "focus",
			},
			["styleSettings"] = {
				["sbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["cbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = -3,
				["x"] = 0,
				["point"] = "BOTTOMLEFT",
				["width"] = 21,
				["scale"] = 1,
				["height"] = 128,
				["targetPoint"] = "TOPLEFT",
				["targetFrame"] = "FocusPortrait",
			},
			["style"] = "UnderHood",
		},
	},
	["ThreatBar"] = {
		["class"] = "Bar",
		["settings"] = {
			["zones"] = {
				{
					["provider"] = "Threat",
					["settings"] = {
						["unit"] = "player",
					},
					["animate"] = true,
				}, -- [1]
				{
					["provider"] = "",
				}, -- [2]
			},
			["general"] = {
				["interactive"] = false,
				["visibility"] = "autocombat",
				["unit"] = "target",
			},
			["styleSettings"] = {
				["cbReversed"] = true,
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["sbReversed"] = true,
				["bgTexture"] = "UnderHood Vertical",
				["showBorder"] = true,
				["sbVertical"] = true,
				["showBackground"] = false,
				["cbVertical"] = true,
				["sbTexture"] = "UnderHood Vertical",
			},
			["tooltips"] = "never",
			["positionAndSize"] = {
				["y"] = 0,
				["x"] = 3,
				["point"] = "RIGHT",
				["targetFrame"] = "TargetHealthBar",
				["scale"] = 1,
				["targetPoint"] = "LEFT",
				["height"] = 256,
				["width"] = 22,
			},
			["style"] = "UnderHood",
		},
	},
	["TargetBuffs"] = {
		["class"] = "AurasFrame",
		["settings"] = {
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = true,
				["unit"] = "target",
			},
			["positionAndSize"] = {
				["y"] = -8,
				["x"] = 0,
				["point"] = "TOPRIGHT",
				["width"] = 1,
				["scale"] = 1,
				["height"] = 1,
				["targetPoint"] = "TOPLEFT",
				["targetFrame"] = "TargetInfoText",
			},
			["auras"] = {
				["type"] = "buffs",
				["maxAuras"] = 16,
				["spacing"] = 1,
				["columns"] = 8,
				["layout"] = "LTD",
				["tooltips"] = "ooc",
				["size"] = 20,
			},
		},
	},
	["TargetOfTargetRaidIcon"] = {
		["class"] = "Icon",
		["settings"] = {
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "targettarget",
			},
			["positionAndSize"] = {
				["strata"] = "HIGH",
				["point"] = "BOTTOM",
				["targetPoint"] = "TOP",
				["targetFrame"] = "TargetOfTargetBar",
				["y"] = 2,
				["x"] = 0,
				["height"] = 20,
				["width"] = 20,
				["scale"] = 1,
			},
			["icon"] = "rt",
		},
	},
	["TargetDebuffs"] = {
		["class"] = "AurasFrame",
		["settings"] = {
			["general"] = {
				["visibility"] = "auto",
				["interactive"] = false,
				["unit"] = "target",
			},
			["positionAndSize"] = {
				["y"] = -8,
				["x"] = 0,
				["point"] = "TOPLEFT",
				["width"] = 1,
				["scale"] = 1,
				["height"] = 1,
				["targetPoint"] = "TOPRIGHT",
				["targetFrame"] = "TargetInfoText",
			},
			["auras"] = {
				["spacing"] = 1,
				["type"] = "debuffs",
				["maxAuras"] = 16,
				["filter"] = false,
				["columns"] = 8,
				["layout"] = "RTD",
				["tooltips"] = "ooc",
				["size"] = 20,
			},
		},
	},
	["PlayerRuneFrame"] = {
		["class"] = "Runes",
		["settings"] = {
			["runes"] = {
				["spacing"] = 0,
				["layout"] = "R",
				["style"] = "default",
				["size"] = 22,
			},
			["positionAndSize"] = {
				["y"] = -330,
				["x"] = -65,
				["point"] = "CENTER",
				["width"] = 1,
				["scale"] = 1,
				["height"] = 1,
				["targetPoint"] = "CENTER",
				["targetFrame"] = ":uiparent:",
			},
		},
	},
}

function UnderHood:ApplyDefaultLayout()
	self:CopyTable(frames, self.db.profile.frames)
end
