local UnitCastingInfo = UnitCastingInfo
local UnitChannelInfo = UnitChannelInfo
local UnitExists = UnitExists
local UnitHealth = UnitHealth
local UnitHealthMax = UnitHealthMax
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local UnitPowerType = UnitPowerType

function UnderHood:InitializeAlphaEngine()
	self:RegisterEvent("PLAYER_TARGET_CHANGED", "UpdateAlpha")
	self:RegisterEvent("PLAYER_FOCUS_CHANGED", "UpdateAlpha")
	self:RegisterEvent("UNIT_HEALTH", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_POWER", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_PET", "UpdateAlphaIfPlayer")

	self:RegisterEvent("UNIT_SPELLCAST_START", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_STOP", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_FAILED", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_DELAYED", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP", "UpdateAlphaIfPlayer")
	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_INTERRUPTED", "UpdateAlphaIfPlayer")
end

function UnderHood:UpdateAlphaIfPlayer(event, unit)
	if unit ~= "player" then return end

	self:UpdateAlpha()
end

function UnderHood:UpdateAlpha()
	self.globalAlpha = self:CalculateAlpha(self.db.profile.alpha)

	for _, v in self:IterateFrames() do
		v:UpdateAlpha()
	end
end

function UnderHood:CalculateAlpha(settings)
	local alpha
	local pt = UnitPowerType("player")

	if self.configMode then
		alpha = 1
	elseif settings.enableCasting and (UnitCastingInfo("player") or UnitChannelInfo("player")) then
		alpha = settings.casting
	elseif self.inCombat then
		alpha = settings.combat
	elseif settings.enableTarget and UnitExists("target") then
		alpha = settings.target
	elseif settings.enableFocus and UnitExists("focus") then
		alpha = settings.focus
	elseif settings.enablePet and UnitExists("pet") then
		alpha = settings.pet
	elseif settings.enableRegen and
			(
				UnitHealth("player") ~= UnitHealthMax("player") or -- All classes
				(pt == SPELL_POWER_MANA and UnitPower("player", SPELL_POWER_MANA) ~= UnitPowerMax("player", SPELL_POWER_MANA)) or -- Casters
				(pt == SPELL_POWER_RAGE and UnitPower("player", SPELL_POWER_RAGE) > 0) or -- Warriors and Bear-druids
				(pt == SPELL_POWER_ENERGY and UnitPower("player", SPELL_POWER_ENERGY) ~= UnitPowerMax("player", SPELL_POWER_ENERGY)) or -- Rogues and Cat-druids
				(pt == SPELL_POWER_RUNIC_POWER and UnitPower("player", SPELL_POWER_RUNIC_POWER) > 0) -- Death Knights
			) then
		alpha = settings.regen
	else
		alpha = settings.ooc
	end

	return alpha
end
